-----------------------固定资产构成分析---------------------------
-----固定资产构成商业分析事实表
if exists (select * from ksql_usertables where ksql_tabname ='dw_fact_facard')
  drop table dw_fact_facard;
create table dw_fact_facard
(
  fid                     varchar(44) not null,
  fassetvalue             numeric(19,4) default 0,
  fassetcatid             varchar(44),
  foriginmethodid         varchar(44),
  fusestatusid            varchar(44),
  fstorecityid            varchar(44),
  feconomicpurpid         varchar(44),
  fcurrencyid             varchar(44),
  fasstacttypeid          varchar(44),
  fperiodid               varchar(44),
  fcompanyid              varchar(44),
  fapportionscale         numeric(19,4),
  fiscurdata              int,
  fassetcatcatnumber      nvarchar(250),
  foriginmethodcatnumber  nvarchar(250),
  fusestatuscatnumber     nvarchar(250),
  feconomicpurpcatnumber  nvarchar(250),
  fstorecitycatnumber     nvarchar(250),
  fasstacttypecatnumber   nvarchar(250),
  fperiodyear             int,
  fperiodquarter          int,
  fperiodnumber           int
);

-----固定资产构成方式维度表
if exists (select * from ksql_usertables where ksql_tabname ='dw_dim_facomposemode')
  drop table dw_dim_facomposemode;
create table dw_dim_facomposemode
(
  fid                    varchar(44) not null,
  fname_l1               nvarchar(255),
  fname_l2               nvarchar(255),
  fname_l3               nvarchar(255),
  fnumber                nvarchar(80),
  flongnumber            nvarchar(250),
  fparentid              varchar(44),
  fisleaf                int,
  flevel                 int,
  fcompanyid             varchar(44),
  fisfiltercompany       int,
  fcomposemode           int,
  faddeddata             varchar(250),
  constraint pk_fa_composemode primary key (fid)
);

-----------------------利润余额分析---------------------------------
-----利润余额商业分析维度表（核算项目表）
if exists (select * from ksql_usertables where ksql_tabname ='dw_dim_pbasstactitem')
  drop table dw_dim_pbasstactitem;
create table dw_dim_pbasstactitem
(
  fcompanyid          varchar(44) not null,
  fcurrencyid         varchar(44) not null,
  fasstactitemid      varchar(80) not null,
  fname_l1            nvarchar(255),
  fname_l2            nvarchar(255),
  fname_l3            nvarchar(255),
  fnumber             nvarchar(80),
  fparentid           varchar(80),
  constraint pk_dim_gl_balactit primary key (fcompanyid,fcurrencyid,fasstactitemid)
);

-----利润余额商业分析维度表（财务组织）
if exists (select * from ksql_usertables where ksql_tabname ='dw_dim_finance')
  drop table dw_dim_finance;
create table dw_dim_finance
(
  fid                 varchar(44) not null,
  fname_l1            nvarchar(255),
  fname_l2            nvarchar(255),
  fname_l3            nvarchar(255),
  fnumber             nvarchar(80),
  flongnumber         nvarchar(200),
  fparentid           varchar(44),
  fisstart            int,
  fmainorgid          varchar(44),
  faccountschemeid    varchar(44),
  fisousealup         int,
  constraint pk_dw_dim_finance primary key (fid)
);

-----利润余额商业分析维度表（损益类科目）
if exists (select * from ksql_usertables where ksql_tabname ='dw_dim_placcount')
  drop table dw_dim_placcount;
create table dw_dim_placcount
(
  fid                 varchar(44) not null,
  fname_l1            nvarchar(256),
  fname_l2            nvarchar(256),
  fname_l3            nvarchar(256),
  fnumber             nvarchar(80),
  fisleaf             int,
  flevel              int,
  flongnumber         nvarchar(200),
  fdc                 numeric(10),
  fparentid           varchar(44),
  fcompanyid          varchar(44),
  constraint pk_dim_placcount primary key (fid)
);

-----利润余额商业分析事实表
if exists (select * from ksql_usertables where ksql_tabname ='dw_fact_profitbalance')
  drop table dw_fact_profitbalance;
create table dw_fact_profitbalance
(
  faccountid         varchar(44) not null,
  fcurrencyid        varchar(44) not null,
  fcompanyid         varchar(44) not null,
  fyearaccumulation  numeric(19,4),
  fcurresult         numeric(19,4),
  fperiodyear        int,
  fperiodquarter     int,
  fperiodnumber      int,
  fasstactitemid     varchar(80),
  fhgid              varchar(44)
);

--------------------多账簿差异分析--------------------------
-----事实表
if exists (select * from ksql_usertables where ksql_tabname ='dw_fact_booksdiff')
  drop table dw_fact_booksdiff;
create table dw_fact_booksdiff
(
  fcompanyid         varchar(44) not null,
  fcurrencyid        varchar(44) not null,
  fperiodyear        numeric(10) not null,
  fperiodsemiyear    numeric(10) not null,
  fperiodquarter     numeric(10) not null,
  fperiodnumber      numeric(10) not null,
  faccountproperty   numeric(10) not null,
  fbooksschemeid     varchar(44),
  fperiodtype        numeric(10),
  fyearbegindebit    numeric(19,4) default 0 not null,
  fyearbegincredit   numeric(19,4) default 0 not null,
  fenddebit          numeric(19,4) default 0 not null,
  fendcredit         numeric(19,4) default 0 not null,
  fyeardebit         numeric(19,4) default 0 not null,
  fyearcredit        numeric(19,4) default 0 not null,
  fdebit             numeric(19,4) default 0 not null,
  fcredit            numeric(19,4) default 0 not null,
  fiscurrentperiod   numeric(10),
  fisovercurrentyear numeric(10),
  fisdeleted         numeric(10)
);

-----账簿方案维度表
if exists (select * from ksql_usertables where ksql_tabname ='dw_dim_booksscheme')
  drop table dw_dim_booksscheme;
create table dw_dim_booksscheme
(
  fid               varchar(44) not null,
  fname_l1          nvarchar(255),
  fname_l2          nvarchar(255),
  fname_l3          nvarchar(255),
  fnumber           nvarchar(80) not null,
  fdescription_l1   nvarchar(255),
  fdescription_l2   nvarchar(255),
  fdescription_l3   nvarchar(255),
  fsimplename       nvarchar(80),
  fperiodtypeid     varchar(44),
  faccounttableid   varchar(44),
  fratetableid      varchar(44),
  fcurrencyid       varchar(44),
  freportcurrencyid varchar(44),
  ftype             numeric(10) default 2,
  frptratetableid   varchar(44),
  fadjratetableid   varchar(44),
  fismaster         numeric(10) default 0 not null,
  fislock           numeric(10) default 0,
  frule             numeric(10) default 1 not null,
  fbooktype         numeric(10) default 1 not null,
  fcontrolunitid    varchar(44) default '11111111-1111-1111-1111-111111111111cce7aed4' not null,
  constraint pk_dim_booksscheme primary key (fid)
);
