﻿If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_CAS_BankStatement')
Create Table T_CAS_BankStatement ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FNumber NVARCHAR(80),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyID VARCHAR(44),FAccountViewId VARCHAR(44),FCurrencyId VARCHAR(44),FAccountBankID VARCHAR(44),FPeriodID VARCHAR(44),FCreateDate DateTime,FSettleNumber NVARCHAR(80),FSettleTypeID VARCHAR(44),FDebitAmount NUMERIC(28,10) DEFAULT 0,FCreditAmount NUMERIC(28,10) DEFAULT 0,FVerifyStatus INT,FRelatedBizDate DateTime,FSource INT,FIsDebit INT,FSequenceNumber NVARCHAR(80),FTradeNumber NVARCHAR(80),FCashier NVARCHAR(80),FOppAccountNumber NVARCHAR(80),FVoucherNumber NVARCHAR(80),FFpItemID VARCHAR(44),CONSTRAINT PK_BankStatement PRIMARY KEY NONCLUSTERED (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_CAS_CashCount')
Create Table T_CAS_CashCount ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FCompanyID VARCHAR(44),FCountedDate DateTime,FAccountID VARCHAR(44),FCounterID VARCHAR(44),FComment NVARCHAR(200),FSubTotal NUMERIC(19,4) DEFAULT 0 NOT NULL ,FCurrencyID VARCHAR(44),FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4' NOT NULL ,CONSTRAINT PK_CAS_CashCount PRIMARY KEY NONCLUSTERED (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_CAS_CashCountEntry')
Create Table T_CAS_CashCountEntry ( FID VARCHAR(44) NOT NULL ,FCashCountId VARCHAR(44) NOT NULL ,FDenominatorId VARCHAR(44) NOT NULL ,FHundreds INT NOT NULL ,FTwenties INT NOT NULL ,FMantissa INT NOT NULL ,FSubTotal NUMERIC(19,4) DEFAULT 0 NOT NULL ,CONSTRAINT PK_CAS_CCEntry PRIMARY KEY NONCLUSTERED (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_CAS_Journal')
Create Table T_CAS_Journal ( FID VARCHAR(44) NOT NULL ,FNumber NVARCHAR(80),FBizDate DateTime,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44) NOT NULL ,FHandlerID VARCHAR(44),FDescription NVARCHAR(200),FHasEffected INT NOT NULL ,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyID VARCHAR(44) NOT NULL ,FAccountViewID VARCHAR(44) NOT NULL ,FAccountBankID VARCHAR(44),FCurrencyID VARCHAR(44) NOT NULL ,FCreateDate DateTime NOT NULL ,FAssisDate DateTime,FVoucherNumber NVARCHAR(80),FBillType INT,FBillNumber NVARCHAR(80),FSettlementNumber NVARCHAR(80),FIsDebit INT NOT NULL ,FPlanItemID VARCHAR(44),FDebitAmount NUMERIC(19,4) DEFAULT 0 NOT NULL ,FCreditAmount NUMERIC(19,4) DEFAULT 0 NOT NULL ,FOppAccountViewId VARCHAR(44),FVoucherTypeID VARCHAR(44),FVoucherId VARCHAR(44),FSettlementTypeId VARCHAR(44),FCashierId VARCHAR(44),FSource INT NOT NULL ,FRelatedBizDate DateTime,FBillId NVARCHAR(80),FNoticeType INT,FType INT NOT NULL ,FSummaryID VARCHAR(44),FTicketNumber NVARCHAR(80),FPeriodId VARCHAR(44),FVerifyStatus INT NOT NULL ,FTicketTypeID VARCHAR(44) ,CONSTRAINT PK_CAS_Journal PRIMARY KEY  NONCLUSTERED (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_CAS_JournalBalance')
Create Table T_CAS_JournalBalance ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FCompanyId VARCHAR(44),FAccountViewId VARCHAR(44),FCurrencyId VARCHAR(44),FAccountBankId VARCHAR(44),FPeriodId VARCHAR(44),FMonthStartAmt NUMERIC(19,4) DEFAULT 0 NOT NULL ,FMonthDebitAmt NUMERIC(19,4) DEFAULT 0 NOT NULL ,FMonthCreditAmt NUMERIC(19,4) DEFAULT 0 NOT NULL ,FMonthBalance NUMERIC(19,4) DEFAULT 0 NOT NULL ,FYearStartAmt NUMERIC(19,4) DEFAULT 0 NOT NULL ,FYearDebitAmt NUMERIC(19,4) DEFAULT 0 NOT NULL ,FYearCreditAmt NUMERIC(19,4) DEFAULT 0 NOT NULL ,FYearBalance NUMERIC(19,4) DEFAULT 0 NOT NULL ,FDebitStartAmt NUMERIC(19,4) DEFAULT 0 NOT NULL ,FCreditStartAmt NUMERIC(19,4) DEFAULT 0 NOT NULL ,FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4' NOT NULL ,FIsInit INT,FIsBalanced INT,FType INT,CONSTRAINT PK_CAS_JB PRIMARY KEY NONCLUSTERED (FID));

--付款单增加业务种?
If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_CAS_PaymentBill')
Create Table T_CAS_PaymentBill ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FNumber NVARCHAR(80),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyID VARCHAR(44),FSourceType INT,FSourceSysType INT,FCurrencyID VARCHAR(44),FExchangeRate NUMERIC(28,16) DEFAULT 0 NOT NULL ,FIsExchanged INT DEFAULT 0 NOT NULL ,FLastExhangeRate NUMERIC(28,16) DEFAULT 0 NOT NULL ,FSettlementTypeID VARCHAR(44),FSettlementNumber NVARCHAR(80),FOppAccountID VARCHAR(44),FFpItemID VARCHAR(44),FIsCommitSettle INT,FSettleBizType INT,FAuditDate DateTime,FCashierID VARCHAR(44),FAccountantID VARCHAR(44),FIsInitializeBill INT DEFAULT 0 NOT NULL ,FFiVouchered INT DEFAULT 0 NOT NULL ,FBillStatus INT DEFAULT 10 NOT NULL ,FSettlementStatus INT DEFAULT 10 NOT NULL ,FFundType INT,FPayType INT,FActualPayAmount NUMERIC(19,4) DEFAULT 0 NOT NULL ,FActPayAmtVc NUMERIC(19,4) DEFAULT 0 NOT NULL ,FActPayLocAmt NUMERIC(19,4) DEFAULT 0 NOT NULL ,FActPayLocAmtVc NUMERIC(19,4) DEFAULT 0 NOT NULL ,FPayerBankID VARCHAR(44),FPayerAccountBankID VARCHAR(44),FPayerAccountID VARCHAR(44),FPayeeTypeID VARCHAR(44),FPayeeID VARCHAR(44),FPayeeNumber NVARCHAR(80),FPayeeName NVARCHAR(80),FPayeeBank NVARCHAR(80),FPayeeAccountBank NVARCHAR(80),FIsImport INT DEFAULT 0 NOT NULL ,FAmount NUMERIC(19,4) DEFAULT 0 NOT NULL ,FLocalAmount NUMERIC(19,4) DEFAULT 0 NOT NULL ,FAdminOrgUnitId VARCHAR(44),FPersonId VARCHAR(44),FPayDate DateTime,FAccessoryAmt INT DEFAULT 0,FConceit NVARCHAR(160),FIsRelateCheque INT DEFAULT 0 NOT NULL ,FChequeId VARCHAR(44),FSummary NVARCHAR(160),FDayaccount NUMERIC(19,4) DEFAULT 0,FFdcPayTypeID VARCHAR(44),FCurProjectId NVARCHAR(80),FFdcPayeeNameID VARCHAR(44),FFdcPayeeType VARCHAR(44),FContractNo NVARCHAR(80),FContractBillID VARCHAR(44),FCapitalAmount NVARCHAR(80),FUseDepartmentID VARCHAR(44),FUrentDegree INT,FDeductMoneyTypeID VARCHAR(44),FLatestPrice NUMERIC(19,4) DEFAULT 0,FAddProjectAmt NUMERIC(19,4) DEFAULT 0,FChangeAmt NUMERIC(19,4) DEFAULT 0,FPayedAmt NUMERIC(19,4) DEFAULT 0,FPayPartAMatlAmt NUMERIC(19,4) DEFAULT 0,FPayTimes INT DEFAULT 0,FProjectPriceInContract NUMERIC(19,4) DEFAULT 0,FScheduleAmt NUMERIC(19,4) DEFAULT 0,FSettleAmt NUMERIC(19,4) DEFAULT 0,FCurPlannedPayment NUMERIC(19,4) DEFAULT 0,FCurBackPay NUMERIC(19,4) DEFAULT 0,FPaymentPlan NUMERIC(19,4) DEFAULT 0,FCurReqPercent NUMERIC(19,4) DEFAULT 0,FAllReqPercent NUMERIC(19,4) DEFAULT 0,FImageSchedule NUMERIC(19,4) DEFAULT 0,FCurPaid NUMERIC(19,4) DEFAULT 0,FPrjAllReqAmt NUMERIC(19,4) DEFAULT 0,FAddPrjAllReqAmt NUMERIC(19,4) DEFAULT 0,FPayPartAMatlAllReqAmt NUMERIC(19,4) DEFAULT 0,FActFdcPayeeNameID VARCHAR(44),FFdcPayReqNumber NVARCHAR(80),FOppInnerAcctID VARCHAR(44),FProvinceID VARCHAR(44),FCityID VARCHAR(44),FRegionID VARCHAR(44),FFeeType INT,FProjectID VARCHAR(44),FProjectManagerID VARCHAR(44),FLstPrjAllPaidAmt NUMERIC(28,10) DEFAULT 0,FLstAddPrjAllPaidAmt NUMERIC(28,10) DEFAULT 0,FLstAMatlAllPaidAmt NUMERIC(28,10) DEFAULT 0,FLstPrjAllReqAmt NUMERIC(28,10) DEFAULT 0,FLstAddPrjAllReqAmt NUMERIC(28,10) DEFAULT 0,FLstAMatlAllReqAmt NUMERIC(28,10) DEFAULT 0,FFdcPayReqID VARCHAR(44),FPayeeAccountName NVARCHAR(200),FPayeeAreaID VARCHAR(44),FVoucherID VARCHAR(44),FVoucherTypeID VARCHAR(44),FIsEmergency INT DEFAULT 0 NOT NULL, FBizTypeID VARCHAR(44),FIsBookRL INT, FBgAmount NUMERIC(28,10) DEFAULT 0,FIsAppointVoucher INT DEFAULT 0 NOT NULL,fsrcAgenPaymentBillID VARCHAR(44),fagentPaymentBillID VARCHAR(44),FPaymentBillType INT DEFAULT 1 NOT NULL,FAgentPayCompanyID VARCHAR(44),CONSTRAINT PK_CA_PaymentBill PRIMARY KEY NONCLUSTERED  (FID));
--升级付款?
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FPayBillTypeID' and KSQL_COL_TABNAME='T_CAS_PaymentBill')
alter table T_CAS_PaymentBill add  FPayBillTypeID VARCHAR(44); 

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FIsRelatePayBook' and KSQL_COL_TABNAME='T_CAS_PaymentBill')
alter table T_CAS_PaymentBill add  FIsRelatePayBook INT; 

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FPayeeAccountBankOID' and KSQL_COL_TABNAME='T_CAS_PaymentBill')
alter table T_CAS_PaymentBill add  FPayeeAccountBankOID VARCHAR(44); 

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_CAS_PaymentBillEntry')
Create Table T_CAS_PaymentBillEntry ( FID VARCHAR(44) NOT NULL ,FSeq INT,FAmount NUMERIC(19,4) DEFAULT 0,FAmountVc NUMERIC(19,4) DEFAULT 0,FLocalAmount NUMERIC(19,4) DEFAULT 0,FLocalAmtVc NUMERIC(19,4) DEFAULT 0,FUnVcAmount NUMERIC(19,4) DEFAULT 0,FUnVcLocAmount NUMERIC(19,4) DEFAULT 0,FUnVerifyExgRateLoc NUMERIC(19,4) DEFAULT 0 NOT NULL ,FRebate NUMERIC(19,4) DEFAULT 0,FRebateAmtVc NUMERIC(19,4) DEFAULT 0,FRebateLocAmt NUMERIC(19,4) DEFAULT 0,FRebateLocAmtVc NUMERIC(19,4) DEFAULT 0,FActualAmt NUMERIC(19,4) DEFAULT 0,FActualAmtVc NUMERIC(19,4) DEFAULT 0,FActualLocAmt NUMERIC(19,4) DEFAULT 0,FActualLocAmtVc NUMERIC(19,4) DEFAULT 0,FRemark NVARCHAR(80),FLockAmt NUMERIC(19,4) DEFAULT 0,FLockLocAmt NUMERIC(19,4) DEFAULT 0,FUnLockAmt NUMERIC(19,4) DEFAULT 0,FUnLockLocAmt NUMERIC(19,4) DEFAULT 0,FSourceBillId NVARCHAR(80),FSourceBillEntryId NVARCHAR(80),FVcStatus INT DEFAULT 10 NOT NULL ,FPaymentBillID VARCHAR(44),FHisUnVcAmount NUMERIC(19,4) DEFAULT 0 NOT NULL ,FHisUnVcLocAmount NUMERIC(19,4) DEFAULT 0 NOT NULL ,FCoreBillTypeId VARCHAR(44),FCoreBillId VARCHAR(44),FCoreBillEntryId VARCHAR(44),FCoreBillNumber NVARCHAR(80),FCoreBillEntrySeq INT,FTrackNumber NVARCHAR(80),FCurrencyId VARCHAR(44),FCurProjectID VARCHAR(44),FProductTypeID VARCHAR(44),FCostAmt NUMERIC(19,4) DEFAULT 0 ,CONSTRAINT PK_CAS_PayBillEntr PRIMARY KEY NONCLUSTERED (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_CAS_ReceiptForm')
Create Table T_CAS_ReceiptForm ( FID VARCHAR(44) NOT NULL ,FNumber NVARCHAR(80),FBizDate DateTime,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FAuditorID VARCHAR(44),FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT,FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyID VARCHAR(44),FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4',FAsstActID NVARCHAR(100),FAsstActNumber NVARCHAR(100),FAsstActName NVARCHAR(100),FAmtSum NUMERIC(19,4),FBillStatus INT DEFAULT 1,FCurrencyID VARCHAR(44),FAsstActTypeID VARCHAR(44),CONSTRAINT PK_CAS_ReceiptForm PRIMARY KEY NONCLUSTERED (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_CAS_ReceiptFormEntry')
Create Table T_CAS_ReceiptFormEntry ( FID VARCHAR(44) NOT NULL ,FSeq INT,FParentID VARCHAR(44) NOT NULL ,FBizDate DateTime,FEndDate DateTime,FTicketNumber NVARCHAR(100),FInvoiceNumber NVARCHAR(100),FArSettlementNum NVARCHAR(100),FBizBillNumber NVARCHAR(100),FCustomerBillNum NVARCHAR(100),FSettlementTypeID VARCHAR(44),FDescription NVARCHAR(100),FQuantity NUMERIC(28,16) DEFAULT 0,FPrice NUMERIC(28,16) DEFAULT 0,FRebate NUMERIC(28,16) DEFAULT 0,FAmount NUMERIC(19,4) DEFAULT 0,FSrcBillID NVARCHAR(100),FSrcBillEntryID NVARCHAR(100),CONSTRAINT PK_CAS_ReceiptFEID PRIMARY KEY NONCLUSTERED (FID));

--收款单增加业务种?
If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_CAS_ReceivingBill')
Create Table T_CAS_ReceivingBill ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FNumber NVARCHAR(80),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyID VARCHAR(44),FSourceType INT,FSourceSysType INT,FCurrencyID VARCHAR(44),FExchangeRate NUMERIC(28,16) DEFAULT 0 NOT NULL ,FIsExchanged INT DEFAULT 0 NOT NULL ,FLastExhangeRate NUMERIC(28,16) DEFAULT 0 NOT NULL ,FSettlementTypeID VARCHAR(44),FSettlementNumber NVARCHAR(80),FOppAccountID VARCHAR(44),FFpItemID VARCHAR(44),FIsCommitSettle INT,FSettleBizType INT,FAuditDate DateTime,FCashierID VARCHAR(44),FAccountantID VARCHAR(44),FIsInitializeBill INT DEFAULT 0 NOT NULL ,FFiVouchered INT DEFAULT 0 NOT NULL ,FBillStatus INT DEFAULT 10 NOT NULL ,FSettlementStatus INT DEFAULT 10 NOT NULL ,FFundType INT,FRecType INT,FActRecAmt NUMERIC(19,4) DEFAULT 0 NOT NULL ,FActRecAmtVc NUMERIC(19,4) DEFAULT 0 NOT NULL ,FActRecLocAmt NUMERIC(19,4) DEFAULT 0 NOT NULL ,FActRecLocAmtVc NUMERIC(19,4) DEFAULT 0 NOT NULL ,FPayeeBankID VARCHAR(44),FPayeeAccountBankID VARCHAR(44),FPayeeAccountID VARCHAR(44),FPayerTypeID VARCHAR(44),FPayerID VARCHAR(44),FPayerNumber NVARCHAR(80),FPayerName NVARCHAR(80),FPayerAccountNumber NVARCHAR(80),FPayerAccountBank NVARCHAR(80),FIsImport INT DEFAULT 0 NOT NULL ,FAmount NUMERIC(19,4) DEFAULT 0 NOT NULL ,FLocalAmount NUMERIC(19,4) DEFAULT 0 NOT NULL ,FAdminOrgUnitId VARCHAR(44),FPersonId VARCHAR(44),FRecDate DateTime,FAccessoryAmt INT DEFAULT 0,FConceit NVARCHAR(160),FIsRelateReceipt INT DEFAULT 0 NOT NULL ,FReceiptId VARCHAR(44),FCurProjectId NVARCHAR(80),FSummary NVARCHAR(160),FDayaccount NUMERIC(19,4),FContractNo NVARCHAR(80),FContractBillID VARCHAR(44),FCapitalAmount NVARCHAR(80),FOppInnerAcctID VARCHAR(44),FFeeType INT,FProjectID VARCHAR(44),FProjectManagerID VARCHAR(44),FVoucherID VARCHAR(44),FVoucherTypeID VARCHAR(44),FDeliverID VARCHAR(44), FBizTypeID VARCHAR(44),FIsBookRL INT, FBgAmount NUMERIC(28,10) DEFAULT 0,FIsAppointVoucher INT DEFAULT 0 NOT NULL,FReceivingBillType INT DEFAULT 1 NOT NULL,FRealRecCompanyID VARCHAR(44),FRealRecBillID VARCHAR(44),FSrcRealRecBillID VARCHAR(44),CONSTRAINT PK_CAS_RBill PRIMARY KEY NONCLUSTERED (FID));
--升级收款?
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FRecBillTypeID' and KSQL_COL_TABNAME='t_cas_receivingbill')
alter table t_cas_receivingbill add  FRecBillTypeID VARCHAR(44); 

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FIsRelateRecBook' and KSQL_COL_TABNAME='t_cas_receivingbill')
alter table t_cas_receivingbill add  FIsRelateRecBook INT; 

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_CAS_ReceivingBillEntry')
Create Table T_CAS_ReceivingBillEntry ( FID VARCHAR(44) NOT NULL ,FSeq INT,FAmount NUMERIC(19,4) DEFAULT 0,FAmountVc NUMERIC(19,4) DEFAULT 0,FLocalAmount NUMERIC(19,4) DEFAULT 0,FLocalAmtVc NUMERIC(19,4) DEFAULT 0,FUnVcAmount NUMERIC(19,4) DEFAULT 0,FUnVcLocAmount NUMERIC(19,4) DEFAULT 0,FUnVerifyExgRateLoc NUMERIC(19,4) DEFAULT 0 NOT NULL ,FRebate NUMERIC(19,4) DEFAULT 0,FRebateAmtVc NUMERIC(19,4) DEFAULT 0,FRebateLocAmt NUMERIC(19,4) DEFAULT 0,FRebateLocAmtVc NUMERIC(19,4) DEFAULT 0,FActualAmt NUMERIC(19,4) DEFAULT 0,FActualAmtVc NUMERIC(19,4) DEFAULT 0,FActualLocAmt NUMERIC(19,4) DEFAULT 0,FActualLocAmtVc NUMERIC(19,4) DEFAULT 0,FRemark NVARCHAR(80),FLockAmt NUMERIC(19,4) DEFAULT 0,FLockLocAmt NUMERIC(19,4) DEFAULT 0,FUnLockAmt NUMERIC(19,4) DEFAULT 0,FUnLockLocAmt NUMERIC(19,4) DEFAULT 0,FSourceBillId NVARCHAR(80),FSourceBillEntryId NVARCHAR(80),FVcStatus INT DEFAULT 10 NOT NULL ,FReceivingBillID VARCHAR(44),FBizDate DateTime,FBizBillNumber VARCHAR(44),FCustomerBillNum VARCHAR(44),FReceiptNumber VARCHAR(44),FReceiptID VARCHAR(44),FHisUnVcAmount NUMERIC(19,4) DEFAULT 0 NOT NULL ,FHisUnVcLocAmount NUMERIC(19,4) DEFAULT 0 NOT NULL ,FCoreBillTypeId VARCHAR(44),FCoreBillId VARCHAR(44),FCoreBillEntryId VARCHAR(44),FCoreBillNumber NVARCHAR(80),FCoreBillEntrySeq INT,FTrackNumber NVARCHAR(80),FArPrintBillId VARCHAR(44),FArPrintBillEntryId VARCHAR(44),FCurrencyId VARCHAR(44),CONSTRAINT PK_CAS_ReceBillEn PRIMARY KEY NONCLUSTERED (FID));

--增加付款类型基础资料
If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_CAS_PaymentBillType')
Create Table T_CAS_PaymentBillType ( FID VARCHAR(44) NOT NULL ,FNumber NVARCHAR(80),FName_L1 NVARCHAR(255),FName_L2 NVARCHAR(255),FName_L3 NVARCHAR(255),FSourceSysType INT,FSimpleName NVARCHAR(80),FIsPreSet INT DEFAULT 0,FDescription_L1 NVARCHAR(255),FDescription_L2 NVARCHAR(255),FDescription_L3 NVARCHAR(255),FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),CONSTRAINT PK_CAS_PayBillType PRIMARY KEY (FID));
--增加收款类型基础资料
If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_CAS_ReceivingBillType')
Create Table T_CAS_ReceivingBillType ( FID VARCHAR(44) NOT NULL ,FNumber NVARCHAR(80),FName_L1 NVARCHAR(255),FName_L2 NVARCHAR(255),FName_L3 NVARCHAR(255),FSimpleName NVARCHAR(80),FIsPreSet INT DEFAULT 0,FSourceSysType INT,FDescription_L1 NVARCHAR(255),FDescription_L2 NVARCHAR(255),FDescription_L3 NVARCHAR(255),FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),CONSTRAINT PK_CAS_RecBillTy PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where  KSQL_TABNAME='T_CAS_ForExchangeSlip')
Create Table T_CAS_ForExchangeSlip ( FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime 
DateTime,FControlUnitID VARCHAR(44),FNumber NVARCHAR(80),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected 
INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyID VARCHAR(44),FID VARCHAR(44) NOT NULL ,FAppendix 
INT,FFIVouchered INT,FSellAmount NUMERIC(28,10),FBuyAmount NUMERIC(28,10),FExchangeRate NUMERIC(28,10),FDigest NVARCHAR(80),FSellCurrencyID 
VARCHAR(44),FBuyCurrency VARCHAR(44),FSellBankAccount VARCHAR(44),FBuyBankAccount VARCHAR(44),FSellAccountView VARCHAR(44),FBuyAccountView 
VARCHAR(44),FBank VARCHAR(44),FFPItemIn VARCHAR(44),FFpItemOutID VARCHAR(44),FCashier VARCHAR(44),FAccountant VARCHAR(44),FBillState 
INT,FMyHandler VARCHAR(44),CONSTRAINT PK_ForeignExchange PRIMARY KEY (FID));

IF not EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'FExpenseTypeID'  
AND KSQL_COL_TABNAME = 'T_CAS_PaymentBillEntry' ) 
ALTER TABLE T_CAS_PaymentBillEntry ADD FExpenseTypeID VARCHAR(44);  
 
IF not EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'FLineNo'  
AND KSQL_COL_TABNAME = 'T_CAS_Journal' ) 
ALTER TABLE T_CAS_Journal ADD FLineNo INT DEFAULT 0;  

IF not EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'FOppUnit'  
AND KSQL_COL_TABNAME = 'T_CAS_Journal' ) 
ALTER TABLE T_CAS_Journal ADD FOppUnit NVARCHAR(80);  
IF not EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'FOppAcctNumber'  
AND KSQL_COL_TABNAME = 'T_CAS_Journal' ) 
ALTER TABLE T_CAS_Journal ADD FOppAcctNumber NVARCHAR(80);  
IF not EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'FOppBank'  
AND KSQL_COL_TABNAME = 'T_CAS_Journal' ) 
ALTER TABLE T_CAS_Journal ADD FOppBank NVARCHAR(80);  

IF not EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'FIsOnlineVCCheque'  
AND KSQL_COL_TABNAME = 'T_CAS_Journal' ) 
ALTER TABLE T_CAS_Journal ADD FIsOnlineVCCheque INT DEFAULT 0;  

IF not EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'FLineNo'  
AND KSQL_COL_TABNAME = 'T_CAS_BankStatement' ) 
ALTER TABLE T_CAS_BankStatement ADD FLineNo INT DEFAULT 0;  


If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_CAS_SubAcctJournal')
Create Table T_CAS_SubAcctJournal ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FNumber NVARCHAR(80),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyID VARCHAR(44),FCurrencyID VARCHAR(44),FPeriodID VARCHAR(44),FSubacctID VARCHAR(44),FBookDate DateTime,FBillId NVARCHAR(80),FBillType INT,FBillNumber NVARCHAR(80),FIsDebit INT,FDebitAmount NUMERIC(28,10) DEFAULT 0,FCreditAmount NUMERIC(28,10) DEFAULT 0,FCashierID VARCHAR(44),CONSTRAINT PK_SubAcctJournal PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_CAS_SubAccountBalance')
Create Table T_CAS_SubAccountBalance ( FID VARCHAR(44) NOT NULL ,FCompanyID VARCHAR(44),FCurrencyID VARCHAR(44),FPeriodID VARCHAR(44),FSubacctID VARCHAR(44),FPeriodStartBalance NUMERIC(28,10),FPeriodDebitAmt NUMERIC(28,10),FPeriodCreditAmt NUMERIC(28,10),FPeriodEndBalance NUMERIC(28,10),FYearStartBalance NUMERIC(28,10),FYearDebitAmt NUMERIC(28,10),FYearCreditAmt NUMERIC(28,10),FYearEndBalance NUMERIC(28,10),FDebitStartAmt NUMERIC(28,10),FCreditStartAmt NUMERIC(28,10),FIsInit INT,FIsFinal INT,CONSTRAINT PK_SubAccountBalan PRIMARY KEY (FID));



If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_CAS_SubAccount')
Create Table T_CAS_SubAccount ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FName_l1 NVARCHAR(255),FName_l2 NVARCHAR(255),FName_l3 NVARCHAR(255),FNumber NVARCHAR(80),FDescription_l1 NVARCHAR(255),FDescription_l2 NVARCHAR(255),FDescription_l3 NVARCHAR(255),FSimpleName NVARCHAR(80),FCompanyID VARCHAR(44),FAccountNumber NVARCHAR(80),FBankID VARCHAR(44),FRelationalUnitID VARCHAR(44),FInnerAccountID VARCHAR(44),FAccountViewID VARCHAR(44),FAccountBankID VARCHAR(44),FCtrlStrategyID VARCHAR(44),FDeletedStatus INT DEFAULT 1,FIsClosed INT DEFAULT 0,CONSTRAINT PK_CAS_SubAccount PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_CAS_FeeType')
Create Table T_CAS_FeeType ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FName_l1 NVARCHAR(255),FName_l2 NVARCHAR(255),FName_l3 NVARCHAR(255),FNumber NVARCHAR(80),FDescription_l1 NVARCHAR(255),FDescription_l2 NVARCHAR(255),FDescription_l3 NVARCHAR(255),FSimpleName NVARCHAR(80),CONSTRAINT PK_FeeType PRIMARY KEY (FID));


--begin fengrenfei
If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FFeeTypeID' and KSQL_COL_TABNAME = 'T_CAS_PaymentBill' )
ALTER TABLE T_CAS_PaymentBill ADD FFeeTypeID VARCHAR(44);

If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FFeeTypeID' and KSQL_COL_TABNAME = 'T_CAS_ReceivingBill' )
ALTER TABLE T_CAS_ReceivingBill ADD FFeeTypeID VARCHAR(44);
If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FPayerAccountBankID' and KSQL_COL_TABNAME = 'T_CAS_ReceivingBill' )
ALTER TABLE T_CAS_ReceivingBill ADD FPayerAccountBankID VARCHAR(44);

If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FIsCtrlOppAcct' and KSQL_COL_TABNAME = 'T_CAS_ReceivingBill' )
ALTER TABLE T_CAS_ReceivingBill ADD FIsCtrlOppAcct int default 0;

If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FIsCtrlOppAcct' and KSQL_COL_TABNAME = 'T_CAS_PaymentBill' )
ALTER TABLE T_CAS_PaymentBill ADD FIsCtrlOppAcct int default 0;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FIsRedBill' and KSQL_COL_TABNAME='T_CAS_PaymentBill')
alter table T_CAS_PaymentBill add  FIsRedBill int default 0;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FIsRedBill' and KSQL_COL_TABNAME='T_CAS_ReceivingBill')
alter table T_CAS_ReceivingBill add  FIsRedBill int default 0; 
--end
--begin by junli_qu
--收款单删除收款类型枚举字??
If exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FRecType' 
and KSQL_COL_TABNAME='T_CAS_ReceivingBill' AND KSQL_COL_DEFAULT IS NULL)
ALTER TABLE T_CAS_ReceivingBill add default  0 for FRecType; 
--付款单删除付款类型枚举字??
If exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FPayType' 
and KSQL_COL_TABNAME='T_CAS_PaymentBill' AND KSQL_COL_DEFAULT IS NULL)
ALTER TABLE T_CAS_PaymentBill add default  0 for FPayType; 
--end

--增加收付款转移相关的??
If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FIsTransBill' and KSQL_COL_TABNAME = 'T_CAS_ReceivingBill' )
ALTER TABLE T_CAS_ReceivingBill ADD FIsTransBill int default 0;

If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FIsTransBill' and KSQL_COL_TABNAME = 'T_CAS_PaymentBill' )
ALTER TABLE T_CAS_PaymentBill ADD FIsTransBill int default 0;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FSourceBillAsstActID' 
	and KSQL_COL_TABNAME='T_CAS_ReceivingBillEntry')
ALTER TABLE T_CAS_ReceivingBillEntry ADD FSourceBillAsstActID VARCHAR(44);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FSourceBillAsstActID' 
	and KSQL_COL_TABNAME='T_CAS_PaymentBillEntry')
ALTER TABLE T_CAS_PaymentBillEntry ADD FSourceBillAsstActID VARCHAR(44);

--end by booming

--begin by junli_qu
--??/付款单分录增加对方科目和计划项目
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FOppAccountID' 
	and KSQL_COL_TABNAME='T_CAS_ReceivingBillEntry')
ALTER TABLE T_CAS_ReceivingBillEntry ADD FOppAccountID VARCHAR(44);
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FFpItemID' 
	and KSQL_COL_TABNAME='T_CAS_ReceivingBillEntry')
ALTER TABLE T_CAS_ReceivingBillEntry ADD FFpItemID VARCHAR(44);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FOppAccountID' 
	and KSQL_COL_TABNAME='T_CAS_PaymentBillEntry')
ALTER TABLE T_CAS_PaymentBillEntry ADD FOppAccountID VARCHAR(44);
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FFpItemID' 
	and KSQL_COL_TABNAME='T_CAS_PaymentBillEntry')
ALTER TABLE T_CAS_PaymentBillEntry ADD FFpItemID VARCHAR(44);
--end by junli_qu

--?????????
If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_CAS_SubAccount')
Create Table T_CAS_SubAccount ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FName_l1 NVARCHAR(255),FName_l2 NVARCHAR(255),FName_l3 NVARCHAR(255),FNumber NVARCHAR(80),FDescription_l1 NVARCHAR(255),FDescription_l2 NVARCHAR(255),FDescription_l3 NVARCHAR(255),FSimpleName NVARCHAR(80),FCompanyID VARCHAR(44),FAccountNumber NVARCHAR(80),FBankID VARCHAR(44),FRelationalUnitID VARCHAR(44),FInnerAccountID VARCHAR(44),FAccountViewID VARCHAR(44),FAccountBankID VARCHAR(44),FCtrlStrategyID VARCHAR(44),FDeletedStatus INT DEFAULT 1,FIsClosed INT DEFAULT 0,CONSTRAINT PK_CAS_SubAccount PRIMARY KEY (FID));
--由于db2删除字段,ksql通过存储过程中drop table来处理的,导致视图失效,所以需要重新建视图

If exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_CAS_JournalSummary') 
DROP view T_CAS_JournalSummary;
 
CREATE VIEW T_CAS_JournalSummary
AS 
SELECT   fcompanyid, faccountviewid, fcurrencyid, fperiodid, fcreatedate,
         SUM (fdebitamount) AS fdebitamount,
         SUM (fcreditamount) AS fcreditamount, faccountbankid,
         SUM (fisdebit) AS fdebitcount,
         COUNT (fisdebit) - SUM (fisdebit) AS fcreditcount, ftype
    FROM t_cas_journal where fperiodid is not null 
GROUP BY fcompanyid, fperiodid,fcreatedate,  ftype, fcurrencyid,faccountviewid, faccountbankid;

--增加收付款转移相关的列
If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FIsTransOtherBill' and KSQL_COL_TABNAME = 'T_CAS_ReceivingBill' )
ALTER TABLE T_CAS_ReceivingBill ADD FIsTransOtherBill int default 0;

If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FIsTransOtherBill' and KSQL_COL_TABNAME = 'T_CAS_PaymentBill' )
ALTER TABLE T_CAS_PaymentBill ADD FIsTransOtherBill int default 0;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FOtherBillTransAsstTypeId' 
	and KSQL_COL_TABNAME='T_CAS_ReceivingBillEntry')
ALTER TABLE T_CAS_ReceivingBillEntry ADD FOtherBillTransAsstTypeId VARCHAR(44);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FOtherBillTransAsstTypeId' 
	and KSQL_COL_TABNAME='T_CAS_PaymentBillEntry')
ALTER TABLE T_CAS_PaymentBillEntry ADD FOtherBillTransAsstTypeId VARCHAR(44);

--end by booming

--fengrenfei
If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FActRecAccountBank' and KSQL_COL_TABNAME = 'T_CAS_PaymentBill' )
ALTER TABLE T_CAS_PaymentBill ADD FActRecAccountBank NVARCHAR(80);
--end

--add FVerifiedAmt  FUnVerifiedAmt by booming
If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FVerifiedAmt' and KSQL_COL_TABNAME = 'T_CAS_ReceivingBill' )
ALTER TABLE T_CAS_ReceivingBill ADD FVerifiedAmt NUMERIC(19,4) DEFAULT 0;

If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FVerifiedAmtLoc' and KSQL_COL_TABNAME = 'T_CAS_ReceivingBill' )
ALTER TABLE T_CAS_ReceivingBill ADD FVerifiedAmtLoc NUMERIC(19,4) DEFAULT 0;

If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FUnVerifiedAmt' and KSQL_COL_TABNAME = 'T_CAS_ReceivingBill' )
ALTER TABLE T_CAS_ReceivingBill ADD FUnVerifiedAmt NUMERIC(19,4) DEFAULT 0;

If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FUnVerifiedAmtLoc' and KSQL_COL_TABNAME = 'T_CAS_ReceivingBill' )
ALTER TABLE T_CAS_ReceivingBill ADD FUnVerifiedAmtLoc NUMERIC(19,4) DEFAULT 0;


If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FVerifiedAmt' and KSQL_COL_TABNAME = 'T_CAS_PaymentBill' )
ALTER TABLE T_CAS_PaymentBill ADD FVerifiedAmt NUMERIC(19,4) DEFAULT 0;

If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FVerifiedAmtLoc' and KSQL_COL_TABNAME = 'T_CAS_PaymentBill' )
ALTER TABLE T_CAS_PaymentBill ADD FVerifiedAmtLoc NUMERIC(19,4) DEFAULT 0;

If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FUnVerifiedAmt' and KSQL_COL_TABNAME = 'T_CAS_PaymentBill' )
ALTER TABLE T_CAS_PaymentBill ADD FUnVerifiedAmt NUMERIC(19,4) DEFAULT 0;

If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FUnVerifiedAmtLoc' and KSQL_COL_TABNAME = 'T_CAS_PaymentBill' )
ALTER TABLE T_CAS_PaymentBill ADD FUnVerifiedAmtLoc NUMERIC(19,4) DEFAULT 0;

--end
--5.4 begin by junli_qu

If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FIsDifferPlace' 
    and KSQL_COL_TABNAME = 'T_CAS_PaymentBill' )
ALTER TABLE T_CAS_PaymentBill ADD FIsDifferPlace int default 0;
--???????4????λ??
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FEditFlag' 
	and KSQL_COL_TABNAME='T_CAS_PaymentBill')
ALTER TABLE T_CAS_PaymentBill ADD FEditFlag VARCHAR(80);
--5.4 end
If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FIsNeedVoucher' and KSQL_COL_TABNAME = 'T_CAS_PaymentBill' )
ALTER TABLE T_CAS_PaymentBill ADD FIsNeedVoucher int default 1;
If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FVoucherNumber' 
and KSQL_COL_TABNAME = 'T_CAS_PaymentBill' )
ALTER TABLE T_CAS_PaymentBill ADD FVoucherNumber NVARCHAR(80);

If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FIsNeedVoucher' and KSQL_COL_TABNAME = 'T_CAS_ReceivingBill' )
ALTER TABLE T_CAS_ReceivingBill ADD FIsNeedVoucher int default 1;

If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FVoucherNumber' and KSQL_COL_TABNAME = 'T_CAS_ReceivingBill' )
ALTER TABLE T_CAS_ReceivingBill ADD FVoucherNumber NVARCHAR(80);

--付款单增加是否提交银企互联列
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FisCommittoBe' AND KSQL_COL_TABNAME='T_CAS_PaymentBill') 
ALTER TABLE T_CAS_PaymentBill ADD FisCommittoBe INT DEFAULT 0;
--付款单增加审核日期和审核人
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FApproverID' 
	and KSQL_COL_TABNAME='T_CAS_PaymentBill')
ALTER TABLE T_CAS_PaymentBill ADD FApproverID VARCHAR(44);
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FApproveDate' 
	and KSQL_COL_TABNAME='T_CAS_PaymentBill')
ALTER TABLE T_CAS_PaymentBill ADD FApproveDate DateTime;
--收款单增加审核日期和审核人
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FApproverID' 
	and KSQL_COL_TABNAME='T_CAS_ReceivingBill')
ALTER TABLE T_CAS_ReceivingBill ADD FApproverID VARCHAR(44);
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FApproveDate' 
	and KSQL_COL_TABNAME='T_CAS_ReceivingBill')
ALTER TABLE T_CAS_ReceivingBill ADD FApproveDate DateTime;

--fengrenfei 用途
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FUsage' 
	and KSQL_COL_TABNAME='T_CAS_PaymentBill')
ALTER TABLE T_CAS_PaymentBill ADD FUsage NVARCHAR(100);

If not exists (select * from KSQL_USERTABLES where  KSQL_TABNAME='T_CAS_ForExchangeSlip')
Create Table T_CAS_ForExchangeSlip ( FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime 
DateTime,FControlUnitID VARCHAR(44),FNumber NVARCHAR(80),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected 
INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyID VARCHAR(44),FID VARCHAR(44) NOT NULL ,FAppendix 
INT,FFIVouchered INT,FSellAmount NUMERIC(28,10),FBuyAmount NUMERIC(28,10),FExchangeRate NUMERIC(28,10),FDigest NVARCHAR(80),FSellCurrencyID 
VARCHAR(44),FBuyCurrency VARCHAR(44),FSellBankAccount VARCHAR(44),FBuyBankAccount VARCHAR(44),FSellAccountView VARCHAR(44),FBuyAccountView 
VARCHAR(44),FBank VARCHAR(44),FFPItemIn VARCHAR(44),FFpItemOutID VARCHAR(44),FCashier VARCHAR(44),FAccountant VARCHAR(44),FBillState 
INT,FMyHandler varchar(44), CONSTRAINT PK_ForeignExchange PRIMARY KEY (FID));



--从5.3迁来的字段
--付款单增加收款方省，市县
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FRecProvince' 
	and KSQL_COL_TABNAME='T_CAS_PaymentBill')
ALTER TABLE T_CAS_PaymentBill ADD FRecProvince NVARCHAR(100);
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FRecCity' 
	and KSQL_COL_TABNAME='T_CAS_PaymentBill')
ALTER TABLE T_CAS_PaymentBill ADD FRecCity NVARCHAR(100);
--增加禁用启用状态
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FDeletedStatus' 
and KSQL_COL_TABNAME='T_CAS_ReceivingBillType')
ALTER TABLE T_CAS_ReceivingBillType ADD FDeletedStatus INT  DEFAULT 1;
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FDeletedStatus' 
and KSQL_COL_TABNAME='T_CAS_PaymentBillType')
ALTER TABLE T_CAS_PaymentBillType ADD FDeletedStatus INT  DEFAULT 1;
--增加同城异地，是否加急
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FDifPlace' 
and KSQL_COL_TABNAME='T_CAS_PaymentBill')
ALTER TABLE T_CAS_PaymentBill ADD FDifPlace INT  DEFAULT 1;
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FMergencyState' 
and KSQL_COL_TABNAME='T_CAS_PaymentBill')
ALTER TABLE T_CAS_PaymentBill ADD FMergencyState INT  DEFAULT 1;
--从5.3第2次迁移过来
--付款单增加银行付款单状态,银行返回信息
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FBankPayState' 
	and KSQL_COL_TABNAME='T_CAS_PaymentBill')
ALTER TABLE T_CAS_PaymentBill ADD FBankPayState INT;
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FBankReturnInfo' 
	and KSQL_COL_TABNAME='T_CAS_PaymentBill')
ALTER TABLE T_CAS_PaymentBill ADD FBankReturnInfo NVARCHAR(80);
--收款单分录增加费用类型
IF not EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'FExpenseTypeID'  
AND KSQL_COL_TABNAME = 'T_CAS_ReceivingBillEntry' ) 
ALTER TABLE T_CAS_ReceivingBillEntry ADD FExpenseTypeID VARCHAR(44);  
--资金调拨单
If not exists (select * from KSQL_USERTABLES where  KSQL_TABNAME='T_CAS_FundsMoveBill')
Create Table T_CAS_FundsMoveBill ( FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FNumber NVARCHAR(80),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyID VARCHAR(44),FID VARCHAR(44) NOT NULL ,FAppendix INT,FmoveType VARCHAR(44),FFIVouchered INT default 0 not NULL,FSellCurrencyID VARCHAR(44),FSellAmount NUMERIC(28,10),FMoveOutLocRate NUMERIC(28,10),FMoveOutLocAmt NUMERIC(28,10),FSellBankAccount VARCHAR(44),FSellAccountView VARCHAR(44),FFPItemIn VARCHAR(44),FBuyCurrency VARCHAR(44),FMoveInLocRate NUMERIC(28,10),FBuyAmount NUMERIC(28,10),FMoveInLocAmt NUMERIC(28,10),FBuyBankAccount VARCHAR(44),FBuyAccountView VARCHAR(44),FFpItemOutID VARCHAR(44),FFeeCurrencyID VARCHAR(44),FFeeBankAccountID VARCHAR(44),FPayoutAcctViewID VARCHAR(44),FFeeAmount NUMERIC(28,10),FFeeLocRate NUMERIC(28,10),FFeeLocAmt NUMERIC(28,10),FFeeAcctViewID VARCHAR(44),FFeeFPItemID VARCHAR(44),FIncome NUMERIC(28,10),FIncomeAcctViewID VARCHAR(44),FIncomeFPItemID VARCHAR(44),FDigest NVARCHAR(80),FBillState INT,FMyHandler VARCHAR(44),FCashier VARCHAR(44),FAccountant VARCHAR(44),FExchangeRate NUMERIC(28,10),FbaseCurrency VARCHAR(44),CONSTRAINT PK_FundsMoveBill PRIMARY KEY (FID));


--调拨类型
If not exists (select * from KSQL_USERTABLES where  KSQL_TABNAME='T_CAS_FundsMoveType')
Create Table T_CAS_FundsMoveType ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FName_l1 NVARCHAR(255),FName_l2 NVARCHAR(255),FName_l3 NVARCHAR(255),FNumber NVARCHAR(80),FDescription_l1 NVARCHAR(255),FDescription_l2 NVARCHAR(255),FDescription_l3 NVARCHAR(255),FSimpleName NVARCHAR(80),FIsSystem INT default 0 not NULL,FGroup INT,CONSTRAINT PK_FundsMoveType PRIMARY KEY (FID));

--付款单增加是否已生成指定凭证
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'FIsAppointVoucher' AND KSQL_COL_TABNAME = 'T_CAS_PaymentBill')
alter table T_CAS_PaymentBill add FIsAppointVoucher INT DEFAULT 0 NOT NULL ;

--收款单增加是否已生成指定凭证
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'FIsAppointVoucher' AND KSQL_COL_TABNAME = 'T_CAS_ReceivingBill')
alter table T_CAS_ReceivingBill add FIsAppointVoucher INT DEFAULT 0 NOT NULL ;

--5.4补丁begin
--费用类别默认信息表
If not exists (select * from KSQL_USERTABLES where  KSQL_TABNAME='T_CAS_FeeTypeDefaultMsg')
Create Table T_CAS_FeeTypeDefaultMsg ( FName_l1 NVARCHAR(255),FName_l2 NVARCHAR(255),FName_l3 NVARCHAR(255),FNumber NVARCHAR(80),FDescription_l1 NVARCHAR(255),FDescription_l2 NVARCHAR(255),FDescription_l3 NVARCHAR(255),FSimpleName NVARCHAR(80),FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4',FFeeTypeID VARCHAR(44),FOppAccountViewID VARCHAR(44),FRecPayerTypeID VARCHAR(44),CONSTRAINT PK_CAS_FeeTDMID PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_CAS_AssItemsForCashPay')
Create Table T_CAS_AssItemsForCashPay ( FID VARCHAR(44) NOT NULL ,FSeq INT,FFromID NVARCHAR(80),FFromNumber NVARCHAR(80),FIsSelected INT,FMappingFileds NVARCHAR(80),FTableName NVARCHAR(80),FAsstActTypeID VARCHAR(44),FParentID VARCHAR(44),CONSTRAINT PK_AssItemsPay PRIMARY KEY (FID));
If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_CAS_AssItemsForCashRec')
Create Table T_CAS_AssItemsForCashRec ( FID VARCHAR(44) NOT NULL ,FSeq INT,FFromID NVARCHAR(80),FFromNumber NVARCHAR(80),FIsSelected INT,FMappingFileds NVARCHAR(80),FTableName NVARCHAR(80),FAsstActTypeID VARCHAR(44),FParentID VARCHAR(44),CONSTRAINT PK_AssItemsRec PRIMARY KEY (FID));

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'FAccepter' AND KSQL_COL_TABNAME = 'T_CAS_PaymentBill')
alter table T_CAS_PaymentBill add FAccepter NVARCHAR(80);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'FAccepterDate' AND KSQL_COL_TABNAME = 'T_CAS_PaymentBill')
alter table T_CAS_PaymentBill add FAccepterDate DateTime;

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'FAccepter' AND KSQL_COL_TABNAME = 'T_CAS_ReceivingBill')
alter table T_CAS_ReceivingBill add FAccepter NVARCHAR(80);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'FAccepterDate' AND KSQL_COL_TABNAME = 'T_CAS_ReceivingBill')
alter table T_CAS_ReceivingBill add FAccepterDate DateTime;

--add Entry FRecBillTypeID  FPayBillTypeID by booming
If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FRecBillTypeID' and KSQL_COL_TABNAME = 'T_CAS_ReceivingBillEntry' )
ALTER TABLE T_CAS_ReceivingBillEntry ADD FRecBillTypeID VARCHAR(44);

If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FPayBillTypeID' and KSQL_COL_TABNAME = 'T_CAS_PaymentBillEntry' )
ALTER TABLE T_CAS_PaymentBillEntry ADD FPayBillTypeID VARCHAR(44);

If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FMixEntryVerify' and KSQL_COL_TABNAME = 'T_CAS_ReceivingBill' )
ALTER TABLE T_CAS_ReceivingBill ADD FMixEntryVerify int default 0;

If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FMixEntryVerify' and KSQL_COL_TABNAME = 'T_CAS_PaymentBill' )
ALTER TABLE T_CAS_PaymentBill ADD FMixEntryVerify int default 0;

IF not EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'FBillCreateTime'  
AND KSQL_COL_TABNAME = 'T_CAS_Journal' ) 
ALTER TABLE T_CAS_Journal ADD FBillCreateTime DateTime;  

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FAssistHgID' 
and KSQL_COL_TABNAME='T_CAS_Journal')
ALTER TABLE T_CAS_Journal ADD FAssistHgID VARCHAR(44);
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'FAssistHgName' 
AND KSQL_COL_TABNAME = 'T_CAS_Journal')
alter table T_CAS_Journal add FAssistHgName NVARCHAR(200);
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FLastPayerTypeID' and KSQL_COL_TABNAME='t_cas_receivingbill')
alter table t_cas_receivingbill add  FLastPayerTypeID VARCHAR(44);
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FLastPayerNumber' and KSQL_COL_TABNAME='t_cas_receivingbill')
alter table t_cas_receivingbill add  FLastPayerNumber VARCHAR(80);
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FLastPayerName' and KSQL_COL_TABNAME='t_cas_receivingbill')
alter table t_cas_receivingbill add  FLastPayerName VARCHAR(80);
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FLastPayerID' and KSQL_COL_TABNAME='t_cas_receivingbill')
alter table t_cas_receivingbill add  FLastPayerID VARCHAR(40);
--end


If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FentryParentID' 
	and KSQL_COL_TABNAME='T_CAS_AssItemsForCashPay')
alter table T_CAS_AssItemsForCashPay add FentryParentID VarChar(44);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FEntrySeq' 
	and KSQL_COL_TABNAME='T_CAS_AssItemsForCashPay')
alter table T_CAS_AssItemsForCashPay add FEntrySeq INT;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FentryParentID' 
	and KSQL_COL_TABNAME='T_CAS_AssItemsForCashRec')
alter table T_CAS_AssItemsForCashRec add FentryParentID VarChar(44);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FEntrySeq' 
	and KSQL_COL_TABNAME='T_CAS_AssItemsForCashRec')
alter table T_CAS_AssItemsForCashRec add FEntrySeq INT;

update T_CAS_AssItemsForCashRec set FEntrySeq = -99 where FEntrySeq is null;
update T_CAS_AssItemsForCashPay set FEntrySeq = -99 where FEntrySeq is null;

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_CAS_AssItemsForCashPay')
Create Table T_CAS_AssItemsForCashPay ( FID VARCHAR(44) NOT NULL ,FSeq INT,FFromID NVARCHAR(80),FFromNumber NVARCHAR(80),FIsSelected INT,FMappingFileds NVARCHAR(80),FTableName NVARCHAR(80),FAsstActTypeID VARCHAR(44),FParentID VARCHAR(44),CONSTRAINT PK_AssItemsPay PRIMARY KEY (FID));
If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_CAS_AssItemsForCashRec')
Create Table T_CAS_AssItemsForCashRec ( FID VARCHAR(44) NOT NULL ,FSeq INT,FFromID NVARCHAR(80),FFromNumber NVARCHAR(80),FIsSelected INT,FMappingFileds NVARCHAR(80),FTableName NVARCHAR(80),FAsstActTypeID VARCHAR(44),FParentID VARCHAR(44),CONSTRAINT PK_AssItemsRec PRIMARY KEY (FID));

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FLastPayeeTypeID' and KSQL_COL_TABNAME='t_cas_paymentbill')
alter table t_cas_paymentbill add  FLastPayeeTypeID VARCHAR(44);
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FLastPayeeNumber' and KSQL_COL_TABNAME='t_cas_paymentbill')
alter table t_cas_paymentbill add  FLastPayeeNumber VARCHAR(80);
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FLastPayeeName' and KSQL_COL_TABNAME='t_cas_paymentbill')
alter table t_cas_paymentbill add  FLastPayeeName VARCHAR(80);
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FLastPayeeID' and KSQL_COL_TABNAME='t_cas_paymentbill')
alter table t_cas_paymentbill add  FLastPayeeID VARCHAR(40);

--收款单增加 是否从总账引入  字段

If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FIsImpFromGL' and KSQL_COL_TABNAME = 'T_CAS_ReceivingBill' )

ALTER TABLE T_CAS_ReceivingBill ADD FIsImpFromGL int default 0;

--付款单增加 是否从总账引入  字段

If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FIsImpFromGL' and KSQL_COL_TABNAME = 'T_CAS_PaymentBill')

ALTER TABLE T_CAS_PaymentBill ADD FIsImpFromGL int default 0;
If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_CAS_MidJournalBacth')
Create Table T_CAS_MidJournalBacth (JBatchId VARCHAR(44),SrcBillId VARCHAR(44));

--收款单单头增加是否销售回款，代收款， 预收款
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'FIsSaleReturn' AND KSQL_COL_TABNAME = 'T_CAS_ReceivingBill')
alter table T_CAS_ReceivingBill add FIsSaleReturn INT DEFAULT 0 ;

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'FIsProxyReturn' AND KSQL_COL_TABNAME = 'T_CAS_ReceivingBill')
alter table T_CAS_ReceivingBill add FIsProxyReturn INT DEFAULT 0 ;

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'FIsPreReturn' AND KSQL_COL_TABNAME = 'T_CAS_ReceivingBill')
alter table T_CAS_ReceivingBill add FIsPreReturn INT DEFAULT 0 ;
--end

--是否需要支付，同步5.3    20080701 By JinXP
If not exists (select 1 from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FIsNeedPay'
 and KSQL_COL_TABNAME='T_CAS_PaymentBill')    
alter table T_CAS_PaymentBill add FIsNeedPay int default 1 not null;


--------------明细表优化---------------
--收款单增加 来源单部门 容余字段
If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FAdminOrgUnitId_SourceBill' and KSQL_COL_TABNAME = 'T_CAS_ReceivingBill' )
ALTER TABLE T_CAS_ReceivingBill ADD FAdminOrgUnitId_SourceBill VARCHAR(44);
--收款单增加 来源单人员 容余字段
If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FPersonID_SourceBill' and KSQL_COL_TABNAME = 'T_CAS_ReceivingBill' )
ALTER TABLE T_CAS_ReceivingBill ADD FPersonID_SourceBill VARCHAR(44);
--收款单增加 来源单往来户 容余字段
If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FAsstActID_SourceBill' and KSQL_COL_TABNAME = 'T_CAS_ReceivingBill' )
ALTER TABLE T_CAS_ReceivingBill ADD FAsstActID_SourceBill VARCHAR(44);
--收款单增加 来源单日期 容余字段
If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FBillDate_SourceBill' and KSQL_COL_TABNAME = 'T_CAS_ReceivingBill' )
ALTER TABLE T_CAS_ReceivingBill ADD FBillDate_SourceBill DateTime;
--收款单增加 来源单往来类型 容余字段
If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FAsstActTypeID_SourceBill' and KSQL_COL_TABNAME = 'T_CAS_ReceivingBill' )
ALTER TABLE T_CAS_ReceivingBill ADD FAsstActTypeID_SourceBill VARCHAR(44);

--付款单增加 来源单部门 容余字段
If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FAdminOrgUnitId_SourceBill' and KSQL_COL_TABNAME = 'T_CAS_PaymentBill' )
ALTER TABLE T_CAS_PaymentBill ADD FAdminOrgUnitId_SourceBill VARCHAR(44);
--付款单增加 来源单人员 容余字段
If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FPersonID_SourceBill' and KSQL_COL_TABNAME = 'T_CAS_PaymentBill' )
ALTER TABLE T_CAS_PaymentBill ADD FPersonID_SourceBill VARCHAR(44);
--付款单增加 来源单往来户 容余字段
If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FAsstActID_SourceBill' and KSQL_COL_TABNAME = 'T_CAS_PaymentBill' )
ALTER TABLE T_CAS_PaymentBill ADD FAsstActID_SourceBill VARCHAR(44);
--付款单增加 来源单日期 容余字段
If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FBillDate_SourceBill' and KSQL_COL_TABNAME = 'T_CAS_PaymentBill' )
ALTER TABLE T_CAS_PaymentBill ADD FBillDate_SourceBill DateTime;
--付款单增加 来源单往来类型 容余字段
If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FAsstActTypeID_SourceBill' and KSQL_COL_TABNAME = 'T_CAS_PaymentBill' )
ALTER TABLE T_CAS_PaymentBill ADD FAsstActTypeID_SourceBill VARCHAR(44);
--------------明细表优化---------------
--收款方国家
If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FFRecCountryID' and KSQL_COL_TABNAME = 'T_CAS_PaymentBill' )
ALTER TABLE T_CAS_PaymentBill ADD FFRecCountryID VARCHAR(44);
