If exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_gl_VirtualBalance')  drop view v_gl_VirtualBalance;
create view v_gl_VirtualBalance
as
select bal.FBalType, compGrp.FID as FOrgUnitID, acctGrp.FID as FAccountID, acctGrp.FNumber as FAccountNumber, 
    bal.FPeriodID, bal.FCurrencyID,

    sum(bal.FBeginBalanceFor) as FBeginBalanceFor,
    sum(bal.FDebitFor) as FDebitFor,         
    sum(bal.FYearDebitFor) as FYearDebitFor,
    sum(bal.FCreditFor) as FCreditFor,   
    sum(bal.FYearCreditFor) as FYearCreditFor, 
    sum(bal.FEndBalanceFor) as FEndBalanceFor,    

    sum(bal.FBeginBalanceLocal) as FBeginBalanceLocal,
    sum(bal.FDebitLocal) as FDebitLocal,  
    sum(bal.FYearDebitLocal) as FYearDebitLocal, 
    sum(bal.FCreditLocal) as FCreditLocal,   
    sum(bal.FYearCreditLocal) as FYearCreditLocal, 
    sum(bal.FEndBalanceLocal) as FEndBalanceLocal, 

    sum(bal.FBeginBalanceRpt) as FBeginBalanceRpt,
    sum(bal.FDebitRpt) as FDebitRpt, 
    sum(bal.FYearDebitRpt) as FYearDebitRpt,
    sum(bal.FCreditRpt) as FCreditRpt, 
    sum(bal.FYearCreditRpt) as FYearCreditRpt,    
    sum(bal.FEndBalanceRpt) as FEndBalanceRpt,          

    sum(bal.FBeginQty) as FBeginQty,   
    sum(bal.FDebitQty) as FDebitQty,  
    sum(bal.FYearDebitQty) as FYearDebitQty,  
    sum(bal.FCreditQty) as FCreditQty,     
    sum(bal.FYearCreditQty) as FYearCreditQty, 
    sum(bal.FEndQty) as FEndQty, 

    sum(bal.FMonthPnLFor) as FMonthPnLFor, 
    sum(bal.FMonthPnLLocal) as FMonthPnLLocal, 
    sum(bal.FMonthPnLRpt) as FMonthPnLRpt, 

    sum(bal.FYearPnLFor) as FYearPnLFor, 
    sum(bal.FYearPnLLocal) as FYearPnLLocal, 
    sum(bal.FYearPnLRpt) as FYearPnLRpt 

from t_gl_AccountBalance bal
inner join  v_bd_AccountView acct on acct.FID = bal.FAccountID and acct.FCompanyID = bal.FOrgUnitID
inner join  t_org_Company comp on comp.FID = acct.FCompanyID and comp.FIsBizUnit = 1
--inner join  t_org_BaseUnit unit on unit.FID = comp.FID

inner join  v_bd_AccountView acctGrp on acctGrp.FNumber= acct.FNumber
inner join t_org_Company compGrp on compGrp.Fid=acctGrp.FCompanyID and compGrp.FIsBizUnit = 0 
--inner join t_org_BaseUnit unitGrp on  unitGrp.FID = compGrp.FID

--where CharIndex(unitGrp.FLongNumber || '!', unit.FLongNumber ) = 1
where CharIndex(compGrp.FLongNumber || '!', comp.FLongNumber ) = 1
and comp.FIsAssistantOrg = 0
group by bal.FBalType, compGrp.FID, bal.FPeriodID, acctGrp.FID, acctGrp.FNumber, bal.FCurrencyID;

--添加往来期间视图
If exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_gl_acperiod') 
drop view v_gl_acperiod;

create view v_gl_acperiod as
select distinct c.FCOMPANYID fcompanyid, rangeperiod.fid fperiodid from t_bd_systemstatusctrol c,
t_bd_period p,t_bd_period rangeperiod
where p.fid =(select case when c.facperiodid is not null then c.facperiodid else c.fstartperiodid end)
and (p.fperiodyear*100+p.fperiodnumber)<=(rangeperiod.fperiodyear*100+rangeperiod.fperiodnumber) and p.ftypeid=rangeperiod.ftypeid
and c.fsystemstatusid = (select fid from t_bd_systemstatus where fname=6);



--不包含结转损益
If exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='V_gl_assistbalancenoPL') 
DROP VIEW V_gl_assistbalancenoPL ;
create view V_gl_assistbalancenoPL as 
select 
ab.FBALTYPE,	ab.FORGUNITID,	ab.FPERIODID,	ab.FACCOUNTID,	ab.FASSISTGRPID,	ab.FCURRENCYID,	

case when avt.fproperty<>4 then FBEGINBALANCEFOR else case when (b.FStartPeriodID = ab.fperiodid ) then FBEGINBALANCEFOR else FBEGINBALANCEFOR + Fyearpnlfor - Fmonthpnlfor  end end FBEGINBALANCEFOR,--期初扣除当前月以前本年累计损益数	
case when avt.fproperty<>4 then FYEARDEBITFOR else case when (b.FStartPeriodID = ab.fperiodid ) then (CASE WHEN Fmonthpnlfor-(FDEBITFOR -FCREDITFOR) < 0 then Fmonthpnlfor-(FDEBITFOR -FCREDITFOR) + FYEARDEBITFOR else FYEARDEBITFOR end ) else (CASE WHEN Fyearpnlfor-(FDEBITFOR -FCREDITFOR) < 0 then Fyearpnlfor-(FDEBITFOR -FCREDITFOR) + FYEARDEBITFOR else FYEARDEBITFOR end ) end end FYEARDEBITFOR,	
case when avt.fproperty<>4 then FYEARCREDITFOR else case when (b.FStartPeriodID = ab.fperiodid ) then (CASE WHEN Fmonthpnlfor-(FDEBITFOR -FCREDITFOR) < 0 then FYEARCREDITFOR else FYEARCREDITFOR- (Fmonthpnlfor-(FDEBITFOR -FCREDITFOR)) end ) else (CASE WHEN Fyearpnlfor-(FDEBITFOR -FCREDITFOR) < 0 then FYEARCREDITFOR else FYEARCREDITFOR- (Fyearpnlfor-(FDEBITFOR -FCREDITFOR)) end ) end end FYEARCREDITFOR,--本年累计	
case when avt.fproperty<>4 then FDEBITFOR else (CASE WHEN Fmonthpnlfor-(FDEBITFOR -FCREDITFOR) < 0 then Fmonthpnlfor-(FDEBITFOR -FCREDITFOR) + FDEBITFOR else FDEBITFOR end ) end FDEBITFOR,	
case when avt.fproperty<>4 then FCREDITFOR else (CASE WHEN Fmonthpnlfor-(FDEBITFOR -FCREDITFOR) < 0 then FCREDITFOR else FCREDITFOR- (Fmonthpnlfor-(FDEBITFOR -FCREDITFOR)) end ) end FCREDITFOR,--本期发生	
case when avt.fproperty<>4 then FENDBALANCEFOR else case when (b.FStartPeriodID = ab.fperiodid ) then FENDBALANCEFOR + (Fmonthpnlfor-(FDEBITFOR -FCREDITFOR)) else FENDBALANCEFOR +　Fyearpnlfor-(FDEBITFOR -FCREDITFOR) end end　FENDBALANCEFOR, --期末扣除本年累计损益数


case when avt.fproperty<>4 then FBEGINBALANCElocal else case when (b.FStartPeriodID = ab.fperiodid ) then FBEGINBALANCElocal else FBEGINBALANCElocal + Fyearpnllocal - Fmonthpnllocal  end end FBEGINBALANCElocal,--期初扣除当前月以前本年累计损益数	
case when avt.fproperty<>4 then FYEARDEBITlocal else case when (b.FStartPeriodID = ab.fperiodid ) then (CASE WHEN Fmonthpnllocal-(FDEBITlocal -FCREDITlocal) < 0 then Fmonthpnllocal-(FDEBITlocal -FCREDITlocal) + FYEARDEBITlocal else FYEARDEBITlocal end ) else (CASE WHEN Fyearpnllocal-(FDEBITlocal -FCREDITlocal) < 0 then Fyearpnllocal-(FDEBITlocal -FCREDITlocal) + FYEARDEBITlocal else FYEARDEBITlocal end ) end end FYEARDEBITlocal,	
case when avt.fproperty<>4 then FYEARCREDITlocal else case when (b.FStartPeriodID = ab.fperiodid ) then (CASE WHEN Fmonthpnllocal-(FDEBITlocal -FCREDITlocal) < 0 then FYEARCREDITlocal else FYEARCREDITlocal- (Fmonthpnllocal-(FDEBITlocal -FCREDITlocal)) end ) else (CASE WHEN Fyearpnllocal-(FDEBITlocal -FCREDITlocal) < 0 then FYEARCREDITlocal else FYEARCREDITlocal- (Fyearpnllocal-(FDEBITlocal -FCREDITlocal)) end ) end end FYEARCREDITlocal,--本年累计	
case when avt.fproperty<>4 then FDEBITlocal else (CASE WHEN Fmonthpnllocal-(FDEBITlocal -FCREDITlocal) < 0 then Fmonthpnllocal-(FDEBITlocal -FCREDITlocal) + FDEBITlocal else FDEBITlocal end ) end FDEBITlocal,	
case when avt.fproperty<>4 then FCREDITlocal else (CASE WHEN Fmonthpnllocal-(FDEBITlocal -FCREDITlocal) < 0 then FCREDITlocal else FCREDITlocal- (Fmonthpnllocal-(FDEBITlocal -FCREDITlocal)) end ) end FCREDITlocal,--本期发生	
case when avt.fproperty<>4 then FENDBALANCElocal else case when (b.FStartPeriodID = ab.fperiodid ) then FENDBALANCElocal + (Fmonthpnllocal-(FDEBITlocal -FCREDITlocal)) else FENDBALANCElocal +　Fyearpnllocal-(FDEBITlocal -FCREDITlocal) end end　FENDBALANCElocal, --期末扣除本年累计损益数



case when avt.fproperty<>4 then FBEGINBALANCErpt else case when (b.FStartPeriodID = ab.fperiodid ) then FBEGINBALANCErpt else FBEGINBALANCErpt + Fyearpnlrpt - Fmonthpnlrpt  end end FBEGINBALANCErpt,--期初扣除当前月以前本年累计损益数	
case when avt.fproperty<>4 then FYEARDEBITrpt else case when (b.FStartPeriodID = ab.fperiodid ) then (CASE WHEN Fmonthpnlrpt-(FDEBITrpt -FCREDITrpt) < 0 then Fmonthpnlrpt-(FDEBITrpt -FCREDITrpt) + FYEARDEBITrpt else FYEARDEBITrpt end ) else (CASE WHEN Fyearpnlrpt-(FDEBITrpt -FCREDITrpt) < 0 then Fyearpnlrpt-(FDEBITrpt -FCREDITrpt) + FYEARDEBITrpt else FYEARDEBITrpt end ) end end FYEARDEBITrpt,	
case when avt.fproperty<>4 then FYEARCREDITrpt else case when (b.FStartPeriodID = ab.fperiodid ) then (CASE WHEN Fmonthpnlrpt-(FDEBITrpt -FCREDITrpt) < 0 then FYEARCREDITrpt else FYEARCREDITrpt- (Fmonthpnlrpt-(FDEBITrpt -FCREDITrpt)) end ) else (CASE WHEN Fyearpnlrpt-(FDEBITrpt -FCREDITrpt) < 0 then FYEARCREDITrpt else FYEARCREDITrpt- (Fyearpnlrpt-(FDEBITrpt -FCREDITrpt)) end ) end end FYEARCREDITrpt,--本年累计	
case when avt.fproperty<>4 then FDEBITrpt else (CASE WHEN Fmonthpnlrpt-(FDEBITrpt -FCREDITrpt) < 0 then Fmonthpnlrpt-(FDEBITrpt -FCREDITrpt) + FDEBITrpt else FDEBITrpt end ) end FDEBITrpt,	
case when avt.fproperty<>4 then FCREDITrpt else (CASE WHEN Fmonthpnlrpt-(FDEBITrpt -FCREDITrpt) < 0 then FCREDITrpt else FCREDITrpt- (Fmonthpnlrpt-(FDEBITrpt -FCREDITrpt)) end ) end FCREDITrpt,--本期发生	
case when avt.fproperty<>4 then FENDBALANCErpt else case when (b.FStartPeriodID = ab.fperiodid ) then FENDBALANCErpt + (Fmonthpnlrpt-(FDEBITrpt -FCREDITrpt)) else FENDBALANCErpt +　Fyearpnlrpt-(FDEBITrpt -FCREDITrpt) end end　FENDBALANCErpt, --期末扣除本年累计损益数

FBEGINQTY,	FYEARDEBITQTY,	FYEARCREDITQTY,	FDEBITQTY,	FCREDITQTY,	FENDQTY
from t_gl_assistbalance ab

inner join t_bd_systemstatusctrol b on ab.forgunitid=b.fcompanyid  
inner join t_bd_systemstatus c on c.fid=b.fsystemstatusid
inner join t_bd_accountview av on ab.faccountid = av.fid
inner join t_bd_accounttype avt on av.FAccountTypeID = avt.fid
and c.fname=6 
;





--不包含结转损益
If exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='V_gl_assistmeasurebalancenoPL') 
DROP VIEW V_gl_assistmeasurebalancenoPL ;
create view V_gl_assistmeasurebalancenoPL as 
select 
ab.FBALTYPE,	ab.FORGUNITID,	ab.FPERIODID,	ab.FACCOUNTID,	ab.FMEASUREUNITID,		ab.FASSISTGRPID,	ab.FCURRENCYID,



case when avt.fproperty<>4 then FBEGINBALANCEFOR else case when (b.FStartPeriodID = ab.fperiodid ) then FBEGINBALANCEFOR else FBEGINBALANCEFOR + Fyearpnlfor - Fmonthpnlfor  end end FBEGINBALANCEFOR,--期初扣除当前月以前本年累计损益数	
case when avt.fproperty<>4 then FYEARDEBITFOR else case when (b.FStartPeriodID = ab.fperiodid ) then (CASE WHEN Fmonthpnlfor-(FDEBITFOR -FCREDITFOR) < 0 then Fmonthpnlfor-(FDEBITFOR -FCREDITFOR) + FYEARDEBITFOR else FYEARDEBITFOR end ) else (CASE WHEN Fyearpnlfor-(FDEBITFOR -FCREDITFOR) < 0 then Fyearpnlfor-(FDEBITFOR -FCREDITFOR) + FYEARDEBITFOR else FYEARDEBITFOR end ) end end FYEARDEBITFOR,	
case when avt.fproperty<>4 then FYEARCREDITFOR else case when (b.FStartPeriodID = ab.fperiodid ) then (CASE WHEN Fmonthpnlfor-(FDEBITFOR -FCREDITFOR) < 0 then FYEARCREDITFOR else FYEARCREDITFOR- (Fmonthpnlfor-(FDEBITFOR -FCREDITFOR)) end ) else (CASE WHEN Fyearpnlfor-(FDEBITFOR -FCREDITFOR) < 0 then FYEARCREDITFOR else FYEARCREDITFOR- (Fyearpnlfor-(FDEBITFOR -FCREDITFOR)) end ) end end FYEARCREDITFOR,--本年累计	
case when avt.fproperty<>4 then FDEBITFOR else (CASE WHEN Fmonthpnlfor-(FDEBITFOR -FCREDITFOR) < 0 then Fmonthpnlfor-(FDEBITFOR -FCREDITFOR) + FDEBITFOR else FDEBITFOR end ) end FDEBITFOR,	
case when avt.fproperty<>4 then FCREDITFOR else (CASE WHEN Fmonthpnlfor-(FDEBITFOR -FCREDITFOR) < 0 then FCREDITFOR else FCREDITFOR- (Fmonthpnlfor-(FDEBITFOR -FCREDITFOR)) end ) end FCREDITFOR,--本期发生	
case when avt.fproperty<>4 then FENDBALANCEFOR else case when (b.FStartPeriodID = ab.fperiodid ) then FENDBALANCEFOR + (Fmonthpnlfor-(FDEBITFOR -FCREDITFOR)) else FENDBALANCEFOR +　Fyearpnlfor-(FDEBITFOR -FCREDITFOR) end end　FENDBALANCEFOR, --期末扣除本年累计损益数


case when avt.fproperty<>4 then FBEGINBALANCElocal else case when (b.FStartPeriodID = ab.fperiodid ) then FBEGINBALANCElocal else FBEGINBALANCElocal + Fyearpnllocal - Fmonthpnllocal  end end FBEGINBALANCElocal,--期初扣除当前月以前本年累计损益数	
case when avt.fproperty<>4 then FYEARDEBITlocal else case when (b.FStartPeriodID = ab.fperiodid ) then (CASE WHEN Fmonthpnllocal-(FDEBITlocal -FCREDITlocal) < 0 then Fmonthpnllocal-(FDEBITlocal -FCREDITlocal) + FYEARDEBITlocal else FYEARDEBITlocal end ) else (CASE WHEN Fyearpnllocal-(FDEBITlocal -FCREDITlocal) < 0 then Fyearpnllocal-(FDEBITlocal -FCREDITlocal) + FYEARDEBITlocal else FYEARDEBITlocal end ) end end FYEARDEBITlocal,	
case when avt.fproperty<>4 then FYEARCREDITlocal else case when (b.FStartPeriodID = ab.fperiodid ) then (CASE WHEN Fmonthpnllocal-(FDEBITlocal -FCREDITlocal) < 0 then FYEARCREDITlocal else FYEARCREDITlocal- (Fmonthpnllocal-(FDEBITlocal -FCREDITlocal)) end ) else (CASE WHEN Fyearpnllocal-(FDEBITlocal -FCREDITlocal) < 0 then FYEARCREDITlocal else FYEARCREDITlocal- (Fyearpnllocal-(FDEBITlocal -FCREDITlocal)) end ) end end FYEARCREDITlocal,--本年累计	
case when avt.fproperty<>4 then FDEBITlocal else (CASE WHEN Fmonthpnllocal-(FDEBITlocal -FCREDITlocal) < 0 then Fmonthpnllocal-(FDEBITlocal -FCREDITlocal) + FDEBITlocal else FDEBITlocal end ) end FDEBITlocal,	
case when avt.fproperty<>4 then FCREDITlocal else (CASE WHEN Fmonthpnllocal-(FDEBITlocal -FCREDITlocal) < 0 then FCREDITlocal else FCREDITlocal- (Fmonthpnllocal-(FDEBITlocal -FCREDITlocal)) end ) end FCREDITlocal,--本期发生	
case when avt.fproperty<>4 then FENDBALANCElocal else case when (b.FStartPeriodID = ab.fperiodid ) then FENDBALANCElocal + (Fmonthpnllocal-(FDEBITlocal -FCREDITlocal)) else FENDBALANCElocal +　Fyearpnllocal-(FDEBITlocal -FCREDITlocal) end end　FENDBALANCElocal, --期末扣除本年累计损益数



case when avt.fproperty<>4 then FBEGINBALANCErpt else case when (b.FStartPeriodID = ab.fperiodid ) then FBEGINBALANCErpt else FBEGINBALANCErpt + Fyearpnlrpt - Fmonthpnlrpt  end end FBEGINBALANCErpt,--期初扣除当前月以前本年累计损益数	
case when avt.fproperty<>4 then FYEARDEBITrpt else case when (b.FStartPeriodID = ab.fperiodid ) then (CASE WHEN Fmonthpnlrpt-(FDEBITrpt -FCREDITrpt) < 0 then Fmonthpnlrpt-(FDEBITrpt -FCREDITrpt) + FYEARDEBITrpt else FYEARDEBITrpt end ) else (CASE WHEN Fyearpnlrpt-(FDEBITrpt -FCREDITrpt) < 0 then Fyearpnlrpt-(FDEBITrpt -FCREDITrpt) + FYEARDEBITrpt else FYEARDEBITrpt end ) end end FYEARDEBITrpt,	
case when avt.fproperty<>4 then FYEARCREDITrpt else case when (b.FStartPeriodID = ab.fperiodid ) then (CASE WHEN Fmonthpnlrpt-(FDEBITrpt -FCREDITrpt) < 0 then FYEARCREDITrpt else FYEARCREDITrpt- (Fmonthpnlrpt-(FDEBITrpt -FCREDITrpt)) end ) else (CASE WHEN Fyearpnlrpt-(FDEBITrpt -FCREDITrpt) < 0 then FYEARCREDITrpt else FYEARCREDITrpt- (Fyearpnlrpt-(FDEBITrpt -FCREDITrpt)) end ) end end FYEARCREDITrpt,--本年累计	
case when avt.fproperty<>4 then FDEBITrpt else (CASE WHEN Fmonthpnlrpt-(FDEBITrpt -FCREDITrpt) < 0 then Fmonthpnlrpt-(FDEBITrpt -FCREDITrpt) + FDEBITrpt else FDEBITrpt end ) end FDEBITrpt,	
case when avt.fproperty<>4 then FCREDITrpt else (CASE WHEN Fmonthpnlrpt-(FDEBITrpt -FCREDITrpt) < 0 then FCREDITrpt else FCREDITrpt- (Fmonthpnlrpt-(FDEBITrpt -FCREDITrpt)) end ) end FCREDITrpt,--本期发生	
case when avt.fproperty<>4 then FENDBALANCErpt else case when (b.FStartPeriodID = ab.fperiodid ) then FENDBALANCErpt + (Fmonthpnlrpt-(FDEBITrpt -FCREDITrpt)) else FENDBALANCErpt +　Fyearpnlrpt-(FDEBITrpt -FCREDITrpt) end end　FENDBALANCErpt, --期末扣除本年累计损益数


FBEGINQTY,	FYEARDEBITQTY,	FYEARCREDITQTY,	FDEBITQTY,	FCREDITQTY,	FENDQTY
from t_gl_assistmeasurebalance ab 

inner join t_bd_systemstatusctrol b on ab.forgunitid=b.fcompanyid  
inner join t_bd_systemstatus c on c.fid=b.fsystemstatusid
inner join t_bd_accountview av on ab.faccountid = av.fid
inner join t_bd_accounttype avt on av.FAccountTypeID = avt.fid
and c.fname=6 
;








--科目余额表
If exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='V_gl_accountbalancenoPL') 
DROP VIEW V_gl_accountbalancenoPL ;
create view V_gl_accountbalancenoPL as 
select 
ab.FBALTYPE,	ab.FORGUNITID,	ab.FPERIODID,	ab.FACCOUNTID,	ab.FCURRENCYID,	


case when avt.fproperty<>4 then FBEGINBALANCEFOR else case when (b.FStartPeriodID = ab.fperiodid ) then FBEGINBALANCEFOR else FBEGINBALANCEFOR + Fyearpnlfor - Fmonthpnlfor  end end FBEGINBALANCEFOR,--期初扣除当前月以前本年累计损益数	
case when avt.fproperty<>4 then FYEARDEBITFOR else case when (b.FStartPeriodID = ab.fperiodid ) then (CASE WHEN Fmonthpnlfor-(FDEBITFOR -FCREDITFOR) < 0 then Fmonthpnlfor-(FDEBITFOR -FCREDITFOR) + FYEARDEBITFOR else FYEARDEBITFOR end ) else (CASE WHEN Fyearpnlfor-(FDEBITFOR -FCREDITFOR) < 0 then Fyearpnlfor-(FDEBITFOR -FCREDITFOR) + FYEARDEBITFOR else FYEARDEBITFOR end ) end end FYEARDEBITFOR,	
case when avt.fproperty<>4 then FYEARCREDITFOR else case when (b.FStartPeriodID = ab.fperiodid ) then (CASE WHEN Fmonthpnlfor-(FDEBITFOR -FCREDITFOR) < 0 then FYEARCREDITFOR else FYEARCREDITFOR- (Fmonthpnlfor-(FDEBITFOR -FCREDITFOR)) end ) else (CASE WHEN Fyearpnlfor-(FDEBITFOR -FCREDITFOR) < 0 then FYEARCREDITFOR else FYEARCREDITFOR- (Fyearpnlfor-(FDEBITFOR -FCREDITFOR)) end ) end end FYEARCREDITFOR,--本年累计	
case when avt.fproperty<>4 then FDEBITFOR else (CASE WHEN Fmonthpnlfor-(FDEBITFOR -FCREDITFOR) < 0 then Fmonthpnlfor-(FDEBITFOR -FCREDITFOR) + FDEBITFOR else FDEBITFOR end ) end FDEBITFOR,	
case when avt.fproperty<>4 then FCREDITFOR else (CASE WHEN Fmonthpnlfor-(FDEBITFOR -FCREDITFOR) < 0 then FCREDITFOR else FCREDITFOR- (Fmonthpnlfor-(FDEBITFOR -FCREDITFOR)) end ) end FCREDITFOR,--本期发生	
case when avt.fproperty<>4 then FENDBALANCEFOR else case when (b.FStartPeriodID = ab.fperiodid ) then FENDBALANCEFOR + (Fmonthpnlfor-(FDEBITFOR -FCREDITFOR)) else FENDBALANCEFOR +　Fyearpnlfor-(FDEBITFOR -FCREDITFOR) end end　FENDBALANCEFOR, --期末扣除本年累计损益数


case when avt.fproperty<>4 then FBEGINBALANCElocal else case when (b.FStartPeriodID = ab.fperiodid ) then FBEGINBALANCElocal else FBEGINBALANCElocal + Fyearpnllocal - Fmonthpnllocal  end end FBEGINBALANCElocal,--期初扣除当前月以前本年累计损益数	
case when avt.fproperty<>4 then FYEARDEBITlocal else case when (b.FStartPeriodID = ab.fperiodid ) then (CASE WHEN Fmonthpnllocal-(FDEBITlocal -FCREDITlocal) < 0 then Fmonthpnllocal-(FDEBITlocal -FCREDITlocal) + FYEARDEBITlocal else FYEARDEBITlocal end ) else (CASE WHEN Fyearpnllocal-(FDEBITlocal -FCREDITlocal) < 0 then Fyearpnllocal-(FDEBITlocal -FCREDITlocal) + FYEARDEBITlocal else FYEARDEBITlocal end ) end end FYEARDEBITlocal,	
case when avt.fproperty<>4 then FYEARCREDITlocal else case when (b.FStartPeriodID = ab.fperiodid ) then (CASE WHEN Fmonthpnllocal-(FDEBITlocal -FCREDITlocal) < 0 then FYEARCREDITlocal else FYEARCREDITlocal- (Fmonthpnllocal-(FDEBITlocal -FCREDITlocal)) end ) else (CASE WHEN Fyearpnllocal-(FDEBITlocal -FCREDITlocal) < 0 then FYEARCREDITlocal else FYEARCREDITlocal- (Fyearpnllocal-(FDEBITlocal -FCREDITlocal)) end ) end end FYEARCREDITlocal,--本年累计	
case when avt.fproperty<>4 then FDEBITlocal else (CASE WHEN Fmonthpnllocal-(FDEBITlocal -FCREDITlocal) < 0 then Fmonthpnllocal-(FDEBITlocal -FCREDITlocal) + FDEBITlocal else FDEBITlocal end ) end FDEBITlocal,	
case when avt.fproperty<>4 then FCREDITlocal else (CASE WHEN Fmonthpnllocal-(FDEBITlocal -FCREDITlocal) < 0 then FCREDITlocal else FCREDITlocal- (Fmonthpnllocal-(FDEBITlocal -FCREDITlocal)) end ) end FCREDITlocal,--本期发生	
case when avt.fproperty<>4 then FENDBALANCElocal else case when (b.FStartPeriodID = ab.fperiodid ) then FENDBALANCElocal + (Fmonthpnllocal-(FDEBITlocal -FCREDITlocal)) else FENDBALANCElocal +　Fyearpnllocal-(FDEBITlocal -FCREDITlocal) end end　FENDBALANCElocal, --期末扣除本年累计损益数



case when avt.fproperty<>4 then FBEGINBALANCErpt else case when (b.FStartPeriodID = ab.fperiodid ) then FBEGINBALANCErpt else FBEGINBALANCErpt + Fyearpnlrpt - Fmonthpnlrpt  end end FBEGINBALANCErpt,--期初扣除当前月以前本年累计损益数	
case when avt.fproperty<>4 then FYEARDEBITrpt else case when (b.FStartPeriodID = ab.fperiodid ) then (CASE WHEN Fmonthpnlrpt-(FDEBITrpt -FCREDITrpt) < 0 then Fmonthpnlrpt-(FDEBITrpt -FCREDITrpt) + FYEARDEBITrpt else FYEARDEBITrpt end ) else (CASE WHEN Fyearpnlrpt-(FDEBITrpt -FCREDITrpt) < 0 then Fyearpnlrpt-(FDEBITrpt -FCREDITrpt) + FYEARDEBITrpt else FYEARDEBITrpt end ) end end FYEARDEBITrpt,	
case when avt.fproperty<>4 then FYEARCREDITrpt else case when (b.FStartPeriodID = ab.fperiodid ) then (CASE WHEN Fmonthpnlrpt-(FDEBITrpt -FCREDITrpt) < 0 then FYEARCREDITrpt else FYEARCREDITrpt- (Fmonthpnlrpt-(FDEBITrpt -FCREDITrpt)) end ) else (CASE WHEN Fyearpnlrpt-(FDEBITrpt -FCREDITrpt) < 0 then FYEARCREDITrpt else FYEARCREDITrpt- (Fyearpnlrpt-(FDEBITrpt -FCREDITrpt)) end ) end end FYEARCREDITrpt,--本年累计	
case when avt.fproperty<>4 then FDEBITrpt else (CASE WHEN Fmonthpnlrpt-(FDEBITrpt -FCREDITrpt) < 0 then Fmonthpnlrpt-(FDEBITrpt -FCREDITrpt) + FDEBITrpt else FDEBITrpt end ) end FDEBITrpt,	
case when avt.fproperty<>4 then FCREDITrpt else (CASE WHEN Fmonthpnlrpt-(FDEBITrpt -FCREDITrpt) < 0 then FCREDITrpt else FCREDITrpt- (Fmonthpnlrpt-(FDEBITrpt -FCREDITrpt)) end ) end FCREDITrpt,--本期发生	
case when avt.fproperty<>4 then FENDBALANCErpt else case when (b.FStartPeriodID = ab.fperiodid ) then FENDBALANCErpt + (Fmonthpnlrpt-(FDEBITrpt -FCREDITrpt)) else FENDBALANCErpt +　Fyearpnlrpt-(FDEBITrpt -FCREDITrpt) end end　FENDBALANCErpt, --期末扣除本年累计损益数

FBEGINQTY,	FYEARDEBITQTY,	FYEARCREDITQTY,	FDEBITQTY,	FCREDITQTY,	FENDQTY
from t_gl_accountbalance ab

inner join t_bd_systemstatusctrol b on ab.forgunitid=b.fcompanyid  
inner join t_bd_systemstatus c on c.fid=b.fsystemstatusid
inner join t_bd_accountview av on ab.faccountid = av.fid
inner join t_bd_accounttype avt on av.FAccountTypeID = avt.fid
and c.fname=6 
;
