﻿CREATE  INDEX IX_Req_Company ON T_CSL_Requisition(FSrcCompanyID ASC,FTargCompanyID ASC);

CREATE  INDEX IX_Req_Voucher ON T_CSL_Requisition(FVoucherID ASC);

ALTER TABLE T_CSL_Requisition ADD CONSTRAINT UK_Req_Number UNIQUE(FNumber );

CREATE  INDEX IX_Req_CU ON T_CSL_Requisition(FControlUnitID ASC);

CREATE  INDEX IX_CSL_ReqE_ReqE ON T_CSL_RequisitionEntry(FRequisitionID ASC,FAccountID ASC,FCurrencyID ASC,FDc ASC,FStatus ASC);

CREATE  INDEX IX_CSL_ReqE_Assis ON T_CSL_RequisitionEntry(FAssistRecordID ASC);

ALTER TABLE T_CSL_Adjust ADD CONSTRAINT UK_CSL_Adj_Adj UNIQUE(FOrgBoundID ,FPeriodType ,FYear ,FPeriod ,FNumber );

CREATE  INDEX IX_CSL_Adj_CU ON T_CSL_Adjust(FControlUnitID ASC);

CREATE  INDEX IX_CSL_AdjE_Seq ON T_CSL_AdjustEntry(FAdjustID ASC,FSeq ASC);

ALTER TABLE T_CSL_AdjustMode ADD CONSTRAINT UK_CSL_Mode_Num UNIQUE(FNumber );

CREATE  INDEX UK_CSL_Mode_CU ON T_CSL_AdjustMode(FControlUnitID ASC);

ALTER TABLE T_CSL_AdjustTemplet ADD CONSTRAINT UK_CSL_AdjT_Num UNIQUE(FAdjustModeID ,FNumber );

CREATE  INDEX UK_CSL_AdjT_CU ON T_CSL_AdjustTemplet(FControlUnitID ASC);

CREATE  INDEX IX_CSL_AdjTE_Tmp ON T_CSL_AdjustTempletEntry(FTempletID ASC);

CREATE  INDEX UK_CSL_ChkFl_CU ON T_CSL_CheckFormula(FControlUnitID ASC);

ALTER TABLE T_CSL_CheckFormula ADD CONSTRAINT UK_CSL_ChkFl_Num UNIQUE(FNumber );

Create Unique Index UX_CSL_ChkFlItm On T_CSL_CheckFormulaItems(FCheckFormulaID,FItemID,FDynaItem);

CREATE  INDEX IX_CSL_Postil_Rpt ON T_CSL_CslPostil(FReportID ASC);

CREATE  INDEX IX_CSL_Postil_Num ON T_CSL_CslPostil(FItemNumber ASC);

CREATE  INDEX IX_CSL_Postil_CU ON T_CSL_CslPostil(FControlUnitID ASC);

CREATE  INDEX IX_CSL_Rpt_Tmp ON T_CSL_CslReport(FTemplateID ASC);

CREATE  INDEX IX_CSL_Rpt_Num ON T_CSL_CslReport(FNumber ASC);

CREATE  INDEX IX_CSL_Rpt_CU ON T_CSL_CslReport(FControlUnitID ASC);

CREATE  INDEX IX_CSL_Rpt_OT ON T_CSL_CslReport(FOrgTreeID ASC);

CREATE  INDEX IX_CSL_Rpt_CP ON T_CSL_CslReport(FOrgUnitID ASC);

CREATE  INDEX IX_CSL_Rpt_Cy ON T_CSL_CslReport(FCurrencyID ASC);

ALTER TABLE T_CSL_CslRptRela ADD CONSTRAINT UK_CSL_RptRL UNIQUE(FSourceTemplet ,FTargetTemplet );

CREATE  INDEX UK_CSL_RptRL_CU ON T_CSL_CslRptRela(FControlUnitID ASC);

ALTER TABLE T_CSL_CyConvtSchm ADD CONSTRAINT UK_CSL_CyCtSch_Num UNIQUE(FNumber );

CREATE  INDEX IX_CSL_CyCtSch_CU ON T_CSL_CyConvtSchm(FControlUnitID ASC);

ALTER TABLE T_CSL_CyConvtSchmEntry ADD CONSTRAINT UK_CSL_CyCtShEntry UNIQUE(FSchemeID ,FItemID );

ALTER TABLE T_CSL_DataCheckageEntry ADD CONSTRAINT UK_CSL_ChkE_Seq UNIQUE(FCheckageID ,FSeq );

CREATE  INDEX IX_CSL_ChkE_Item ON T_CSL_DataCheckageEntry(FItemID ASC);

CREATE  INDEX IX_CSL_ChkE_TCp ON T_CSL_DataCheckageEntry(FTargetCompanyID ASC);

CREATE  INDEX IX_CSL_ChkE_Cp ON T_CSL_DataCheckageEntry(FCompanyID ASC);

CREATE  INDEX IX_CSL_ElimRd_CU ON T_CSL_ElimRecord(FControlUnitID ASC);

ALTER TABLE T_CSL_ElimRecord ADD CONSTRAINT UK_CSL_ElimRd UNIQUE(FEliminationID ,FCheckageDataID );

CREATE  INDEX IX_CSL_ElimT_Group ON T_CSL_ElimTemplet(FElimGroupID ASC);

CREATE  INDEX IX_CSL_ElimT_CU ON T_CSL_ElimTemplet(FControlUnitID ASC);

CREATE  INDEX IX_CSL_ElimT_Cp ON T_CSL_ElimTemplet(FCompanyID ASC);

CREATE  INDEX IX_CSL_ElimTE_T ON T_CSL_ElimTempletEntry(FTempletID ASC);

ALTER TABLE T_CSL_ElimTempletGroup ADD CONSTRAINT UK_CSL_ElimGrp_Num UNIQUE(FNumber );

CREATE  INDEX IK_CSL_ElimGrp_CU ON T_CSL_ElimTempletGroup(FControlUnitID ASC);

ALTER TABLE T_CSL_Elimination ADD CONSTRAINT UK_CSL_Elim_Elim UNIQUE(FOrgBoundID ,FOrgUnit, FPeriodType ,FYear ,FPeriod ,FNumber );

CREATE  INDEX IX_CSL_Elim_CU ON T_CSL_Elimination(FControlUnitID ASC);

CREATE  INDEX IX_CSL_ExchChk_Cy ON T_CSL_ExchCheckage(FCurrencyID ASC);

CREATE  INDEX IX_CSL_ExchChk_CU ON T_CSL_ExchCheckage(FControlUnitID ASC);

CREATE  INDEX IX_CSL_ExchChk_Cp ON T_CSL_ExchCheckage(FCompanyID ASC);

CREATE  INDEX IX_CSL_ExchChk_OT ON T_CSL_ExchCheckage(FOrgBoundID ASC);

ALTER TABLE T_CSL_ExchCheckageEntry ADD CONSTRAINT UK_CSL_ExChkE_Seq UNIQUE(FCheckageID ,FSeq );

CREATE  INDEX IX_CSL_ExChkE_Item ON T_CSL_ExchCheckageEntry(FItemID ASC);

CREATE  INDEX IX_CSL_ExChkE_TCp ON T_CSL_ExchCheckageEntry(FTargetCompanyID ASC);

CREATE  INDEX IX_CSL_ExChkE_Cp ON T_CSL_ExchCheckageEntry(FCompanyID ASC);

CREATE  INDEX IX_CSL_IIAT ON T_CSL_IIAssistant(FOrgBoundID ASC,FOrgUnitID ASC,FCompanyID ASC,FTargetCompanyID ASC,FCurrencyID ASC,FYear ASC,FPeriod ASC);

CREATE  INDEX IX_CSL_IntChk_CU ON T_CSL_InterDataCheckage(FControlUnitID ASC);

CREATE  INDEX IX_CSL_IntChk_Cp ON T_CSL_InterDataCheckage(FCompanyID ASC);

CREATE  INDEX IX_CSL_IntChk_Cy ON T_CSL_InterDataCheckage(FCurrencyID ASC);

CREATE  INDEX IX_CSL_IntChk_OT ON T_CSL_InterDataCheckage(FOrgBoundID ASC);

CREATE  INDEX IX_CSL_Inter_Rpt ON T_CSL_InterItemData(FReport ASC);

CREATE  INDEX IX_CSL_Inter_Cp ON T_CSL_InterItemData(FCompanyID ASC);

CREATE  INDEX IX_CSL_Inter_TCp ON T_CSL_InterItemData(FTargetCompanyID ASC);

CREATE  INDEX IX_CSL_Inter_Cy ON T_CSL_InterItemData(FCurrencyID ASC);

CREATE  INDEX IX_CSL_Inter_OT ON T_CSL_InterItemData(FOrgBoundID ASC);

Create UNIQUE Index UX_CSL_IVCK On T_CSL_InvestCheckage(FOrgBoundID ,FOrgUnitID ,FCompanyID ,FTargetCompanyID ,FCurrencyID ,FPeriodType ,FYear ,FPeriod ,FMergeMode ,FDataElement ,FTargetCurrencyID ,FDay );

CREATE  INDEX IX_CSL_ID_CLS1 ON T_CSL_InvestDay(FCompanyID ASC,FTargetCompanyID ASC,FChangeDate DESC,FCurrencyID ASC);

CREATE  INDEX IX_ITEntry ON T_CSL_InvestDayEntry(FControlAttr ASC,FInvestDayID ASC,FAssistantFlag ASC);

CREATE  INDEX IX_CSL_ItemData ON T_CSL_ItemData(FCompanyID ASC,FCurrencyID ASC,FTargetCurrencyID ASC,FPeriodType ASC,FDataSource ASC,FCommitStatus ASC);

CREATE  INDEX IX_CSL_Assi_Rpt ON T_CSL_ItemDataAssistant(FReport ASC);

CREATE  INDEX IX_CSL_ItmDE ON T_CSL_ItemDataEntry(FItemDataID ASC,FValueType ASC,FYear ASC,FPeriod ASC,FDataElement ASC);

ALTER TABLE T_CSL_ItemDataTable ADD CONSTRAINT UX_CSL_ItmDtTb_Tbn UNIQUE(FTableName );

Create UNIQUE Index UX_CSL_ItmDtYI On T_CSL_ItemDataYearInit(FYear ,FItemID ,FCurrencyID ,FOrgTreeID ,FOrgUnitID ,FValueType ,FDataElement ,FConvertStatus);

CREATE  INDEX IX_CSL_ItmDiIdx_Nm ON T_CSL_ItemDiffIndex(FNumber ASC);

CREATE  INDEX IX_CSL_DiffIdxE_HD ON T_CSL_ItemDiffIndexEntry(FDiffIndexID ASC);

Create Unique Index UX_CSL_DiffIdxE on T_CSL_ItemDiffIndexEntry(FDiffIndexID ,FOrgTreeID ,FOrgUnitID ,FCompanyID );

Create Unique Index UX_CSL_DiffIdIt On T_CSL_ItemDiffIndexItems(FDiffIndexID ,FItemID,FDynaItem);

Create Unique Index UX_Csl_ItmHisRt on T_CSL_ItemHisExchgRate(FOrgBoundGrpID ,FCompanyID ,FChangeDate ,FCurrencyID ,FItemID );

CREATE  INDEX IX_Csl_ItmHisRt_CU ON T_CSL_ItemHisExchgRate(FControlUnitID ASC);

ALTER TABLE T_CSL_ReportClass ADD CONSTRAINT UK_CSL_RptCls_Num UNIQUE(FNumber );

CREATE  INDEX IX_CSL_RptCls_CU ON T_CSL_ReportClass(FControlUnitID ASC);

ALTER TABLE T_CSL_RptItem ADD CONSTRAINT UK_CSL_Item_Num UNIQUE(FNumber );

CREATE  INDEX IX_CSL_Item_CU ON T_CSL_RptItem(FControlUnitID ASC);

ALTER TABLE T_CSL_RptItemMapping ADD CONSTRAINT UX_CSL_IMap_Item UNIQUE(FTargetItem ,FSourceItem );

ALTER TABLE T_CSL_RptReceived ADD CONSTRAINT UX_Csl_RptRev_RpOT UNIQUE(FOrgTreeID ,FReportID );

CREATE  INDEX IX_CSL_SumRptRl_CU ON T_CSL_SumRptRela(FControlUnitID ASC);

ALTER TABLE T_CSL_SumRptRela ADD CONSTRAINT UX_CSL_SumRptRela UNIQUE(FSumReportID ,FReportID,FSheetId );

CREATE  INDEX IX_CSL_TmpDis_CU ON T_CSL_TempletDispense(FControlUnitID ASC);

CREATE  INDEX IX_CSL_TmpDis_Src ON T_CSL_TempletDispense(FDispenseSrcID ASC);

CREATE  INDEX IX_CSL_TmpDis_OT ON T_CSL_TempletDispense(FOrgBoundID ASC);

CREATE  INDEX IX_CSL_TmpDis_Cp ON T_CSL_TempletDispense(FCompanyID ASC);

CREATE  INDEX IX_CSL_ItemL_Tmp ON T_CSL_TempletItemList(FTemplateID ASC);

CREATE  INDEX IX_CSL_ItemL_Num ON T_CSL_TempletItemList(FItemNumber ASC);

ALTER TABLE T_CSl_ItemFieldMapped ADD CONSTRAINT UX_CSL_ItmFdMp_Itm UNIQUE(FItemID );

ALTER TABLE T_CSl_ItemFieldMapped ADD CONSTRAINT UX_CSL_ItmFdMp_TbF UNIQUE(FTableName ,FFieldName );

ALTER TABLE T_CSl_ItemFieldMapped ADD CONSTRAINT UX_CSL_ItmFdMp_Seq UNIQUE(FSeq );

ALTER TABLE T_CSL_RptControl ADD CONSTRAINT UK_CSL_RC UNIQUE(FType ,FControl);

ALTER TABLE T_Csl_DataElement ADD CONSTRAINT UX_Csl_DE_Number UNIQUE(FNumber);

ALTER TABLE T_Csl_DataElement ADD CONSTRAINT UX_Csl_DE_IntSeq UNIQUE(FInterSeq);

--优化核对
CREATE UNIQUE INDEX UX_CSL_IntChk ON T_CSL_InterDataCheckage(FOrgUnitID, FNumber, FPeriod, FYear, FPeriodType, FOrgBoundID);
CREATE UNIQUE INDEX UX_CSL_ExcChk ON T_CSL_ExchCheckage(FOrgUnitID, FNumber, FPeriod, FYear, FPeriodType, FOrgBoundID);

--对查询来源报表的查询优化
Create Index IX_Csl_Rpt_SrcRpt On T_CSL_CslReport(FSourceRptID); 

--对查询项目数据分录表的优�????
Create Index IX_Csl_ItmDE_1 On T_CSL_ItemDataEntry(FValueType,FYear,FPeriod,FDataElement);

--解决�????来查询死锁问�????
CREATE INDEX IX_CSL_IntData on T_CSL_InterItemdata(FItemNumber,FReport,FCompanyId,FTargetCompanyId,FPeriod,FYear,FPeriodType,FTargetCurrencyId);

ALTER TABLE T_CSL_FormulaDispense ADD CONSTRAINT UK_CSL_FormulaTemp UNIQUE(FFormulaType ,FFormulaNumber ,FTemplateNumber ,FTemplateType );

ALTER TABLE T_CSL_DynaItem2ElimItem ADD CONSTRAINT UK_CSL_DItem2EItem UNIQUE(FDynaItemID ,FElimItemID );

CREATE  INDEX IX_CSL_ElmiDItem ON T_CSL_ElimDynaItemEntry(FEliminationEntryID ASC);

CREATE  INDEX IX_CSL_AdjustEntry ON T_CSL_AdjustDynamicItem(FAdjustEntryID ASC);

ALTER TABLE T_CSL_ItemHisExchgPromRate ADD CONSTRAINT UX_Csl_ItmHisPmtRt UNIQUE(FItemHisExchgRateID ,FCurrencyID );

create index IX_CSL_EXCHITEMDA on T_CSL_ExchItemdata(FCompanyId,FTargetCompanyId,FYear,FPeriod);

create index IX_CSL_INTERITEMDA on T_CSL_InterItemdata(FCompanyId,FTargetCompanyId,FYear,FPeriod);

CREATE  INDEX IX_CSL_BkRpt_Cy ON T_CSL_BackedReport(FCurrencyID ASC);

CREATE  INDEX IX_CSL_BkRpt_OU ON T_CSL_BackedReport(FOrgUnitID ASC);

CREATE  INDEX IX_CSL_BkRpt_Tmp ON T_CSL_BackedReport(FTemplateID ASC);

CREATE  INDEX IX_Csl_FormResGrp ON T_CSL_ItemFormulaCheckResult(FGroup ASC);

CREATE  INDEX IX_Csl_FormRes ON T_CSL_ItemFormulaCheckResult(FReportId ,FFormulaId ,FGroup );

ALTER TABLE T_CSL_DiffTableSumRela ADD CONSTRAINT UX_CSL_DiffSum UNIQUE(FDiffTableTemplate ,FSumTmpGroup );

CREATE  INDEX IX_CSL_InvestOwner ON T_CSL_InvestOwnerEntry(FItemID ASC,FInvestDayID ASC,FIsBeforeInvest ASC);

CREATE INDEX IX_Rpt_SheetParam ON T_RPT_RptSheetPara(FReportID,FSheetID);

CREATE  INDEX IX_CSL_INTERIMPORT ON T_CSL_InterItemData(FSourceType ASC);

CREATE  INDEX IX_CSL_EXCHIMPORT ON T_CSL_ExchItemData(FSourceType ASC);

CREATE INDEX IX_ItemDatarptid ON T_CSL_ItemData(FReportID ASC);

CREATE INDEX IX_Csl_RptCls_De ON T_Csl_ReportClass(FDataElement asc);

ALTER TABLE T_CSL_WebTimeCompany ADD CONSTRAINT UK_CSL_WebTimeCom UNIQUE(FScheduleID ,FCompanyID );

ALTER TABLE T_CSL_WebTimeCurrency ADD CONSTRAINT UK_CSL_WebTimeCurr UNIQUE(FScheduleID ,FCurrencyID );

ALTER TABLE T_CSL_WebTimeTemplate ADD CONSTRAINT UK_CSL_WebTimeTemp UNIQUE(FScheduleID ,FTemplateNumber ,FTemplateType );

CREATE  INDEX IX_CSL_DynaEntry ON T_CSL_DynaItemDataEntry (FItemDataID ASC);

CREATE  INDEX IX_CSL_ElimEntry2 ON T_CSL_EliminationEntry (FEliminationID, FItemID, FCompanyID, FDataElement);

CREATE  INDEX IX_CSL_AdjtEntry2 ON T_CSL_AdjustEntry (FAdjustID, FItemID, FDataElement);

CREATE  INDEX IX_CSL_TemList1 ON T_CSL_TempletItemList (FTemplateID, FValueType, FItemNumber, FDataElement);

CREATE  INDEX IX_RPT_Report1 ON T_RPT_Report (FSrcReport);

--为消除全表扫描加这两个索引，其实没什么意义
create index IX_CSL_ItemDataEn1 on t_csl_itemDataEntry (FId, FItemDataId, FValueType, FYear, FPeriod, FDataElement, FDay);

create index IX_CSL_ItemData1 on t_csl_itemData (FId,FReportID,FCurrencyID,FTargetCurrencyID,FCompanyID,FIsAdjusted, FPeriodType, FCommitStatus, FDataSource);

CREATE  INDEX IX_RPTITEM_CONTROL ON T_CSL_RPTITEM(FCONTROL ASC);

--create index IX_TEMPDIS_DIS1 on T_CSL_TempletDispense(FDispenseSrcID,FCompanyID,FOrgBoundID,FLastUpdateUserID);

create index IX_PARAMIT_001 on T_BAS_PARAMITEM (FORGTREEID, FVALUE_L2, FKEYID);

create index IX_RPT_TMP_002 on T_RPT_TEMPLATE (FGROUPTEMPLATEID, FCOMPANYID, FVERSIONSTATUS, FTEMPLATETYPE, FID);

create index IX_ORG_COMPANY_001 on T_ORG_COMPANY (FLONGNUMBER, FID, FNAME_L2);

create index IX_PM_USER_001 on T_PM_USER (FNAME_L2, FID);

create index IX_RPT_TEMP_001 on T_RPT_TEMPLATE (FGROUPTEMPLATEID, FCOMPANYID, FVERSIONSTATUS, FTEMPLATETYPE);
