﻿If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FIN_CompDepositAccountBill')
Create Table T_FIN_CompDepositAccountBill ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FNumber NVARCHAR(80),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyID VARCHAR(44),FIsHistory INT DEFAULT 0,FFiVouchered INT DEFAULT 0,FVoucherID VARCHAR(44),FVouchertypeID VARCHAR(44),FCurrencyID VARCHAR(44),FDepositBankID VARCHAR(44),FCertificateNo NVARCHAR(80),FBasePoints NUMERIC(28,10) DEFAULT 0,FMyhandlerID VARCHAR(44),FDigest NVARCHAR(80),FAccountantID VARCHAR(44),FIntFreeAmt NUMERIC(28,10) DEFAULT 0,FYearDays INT,FLastIntDate DateTime,FYearRate NUMERIC(28,10) DEFAULT 0,FCurYearRate NUMERIC(28,10) DEFAULT 0,FAmount NUMERIC(28,10) DEFAULT 0,FBalance NUMERIC(28,10) DEFAULT 0,FIsAccrualToDepositAmt INT,FAccrualToDepositAmt NUMERIC(28,10) DEFAULT 0,FIsReDeposited INT DEFAULT 0,FDepositType VARCHAR(80),FEffectiveDate DateTime,FMaturityDay DateTime,FIntRateTableID VARCHAR(44),FExchangeRate NUMERIC(28,10),FIntermID VARCHAR(44),FExpireIn NUMERIC(28,10) DEFAULT 0,FCorpDepAcctID VARCHAR(44),FCorpCurAcctID VARCHAR(44),FNaturalAmt NUMERIC(28,10) DEFAULT 0,FIntRateTypeExpression VARCHAR(80),FIntAccountID VARCHAR(44),FRemark NVARCHAR(80),FOrgAccountID VARCHAR(44),FIsSubBankDep INT DEFAULT 0,FDepCompanyID VARCHAR(44),FEffectedStatus INT DEFAULT 1,FBillStatus VARCHAR(80),FIsreceived INT DEFAULT 0,FLastUnDepositDate DateTime,FInitBalanceOfHistoryBill NUMERIC(28,10),FIsPreDraw INT DEFAULT 0,FIsUnDeposit INT,FIsbook INT DEFAULT 0,FIsChangeByReDeposited INT DEFAULT 0,FDepType VARCHAR(80),FFpItemID VARCHAR(44),FlastPayDate DateTime,CONSTRAINT PK_CompDepositAcco PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FIN_CompIntReceivedBill')
Create Table T_FIN_CompIntReceivedBill ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FNumber NVARCHAR(80),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyID VARCHAR(44),FIntReceiveType VARCHAR(80),FTimeDepositBillIDID VARCHAR(44),FBankID VARCHAR(44),FCurrencyID VARCHAR(44),FEffectiveDate DateTime,FEndDate DateTime,FIntervalDays INT,FDepositAmt NUMERIC(28,10) DEFAULT 0,FDepYearRate NUMERIC(28,10) DEFAULT 0,FDeInterest NUMERIC(28,10) DEFAULT 0,FSrcBillID NVARCHAR(80),FIntRateTypeExpression VARCHAR(80),FYearDays INT DEFAULT 0,FCreYearRate NUMERIC(28,10) DEFAULT 0,FCreInterest NUMERIC(28,10) DEFAULT 0,FShijiAmt NUMERIC(28,10) DEFAULT 0,FYingjiAmt NUMERIC(28,10) DEFAULT 0,FYichongxiaoAmt NUMERIC(28,10) DEFAULT 0,FDigest NVARCHAR(80),FFivouchered INT DEFAULT 0,FAccountantID VARCHAR(44),FWeixiaoheAmt NUMERIC(28,10) DEFAULT 0,FIsChongzhang INT,FCorpCurAcctID VARCHAR(44),FIsreceived INT DEFAULT 0,FDepCompanyID VARCHAR(44),FStrikedBy NVARCHAR(80),FLastIntDate DateTime,FIsBooked INT,FExchangeRate NUMERIC(28,10),FDepositAmtLocal NUMERIC(28,10),FEffectedStatus INT,CONSTRAINT PK_CompIntReceived PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FIN_CreditLimit')
Create Table T_FIN_CreditLimit ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FNumber NVARCHAR(80),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(500),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyID VARCHAR(44),FIsBankCredit INT,FRegion INT,FCreditUsageID VARCHAR(44),FProperty INT,FCurrencyID VARCHAR(44),FQuotaAmount NUMERIC(19,4) DEFAULT 0,FBalance NUMERIC(19,4) DEFAULT 0,FExchangeRate NUMERIC(28,16) DEFAULT 0,FIssueDate DateTime,FExpiredDate DateTime,FCreditHorizon NUMERIC(19,4) DEFAULT 0,FGuaranteeTypeID VARCHAR(44),FGuarantee NVARCHAR(500) NOT NULL ,FShareType INT,FIsClosed INT,FRemark NVARCHAR(500),FCreditLimitStat INT,FCreditInstitutionId VARCHAR(44),FLocalAmount NUMERIC(19,4) DEFAULT 0,FUsedAmount NUMERIC(19,4) DEFAULT 0,FIsPromises INT DEFAULT 0,FIsOverdue INT DEFAULT 0,FAssureCurrencyID VARCHAR(44),FAssureExRate NUMERIC(28,10),FAssureBillId VARCHAR(44),FUseAssureBill INT,FIsUnion INT DEFAULT 0,FGuaranteeTypeInputMode INT,FProjectID VARCHAR(44),FBalanceBack NUMERIC(19,4) DEFAULT 0,CONSTRAINT pk_fin_creditlimit PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FIN_CreditLimitEntry')
Create Table T_FIN_CreditLimitEntry ( FID VARCHAR(44) NOT NULL ,FSeq INT,FParentID VARCHAR(44) NOT NULL ,FShareOrgID VARCHAR(44),FSharedAmount NUMERIC(19,4) DEFAULT 0 NOT NULL,FBanlance NUMERIC(19,4) DEFAULT 0 NOT NULL,FIsUnion INT DEFAULT 0,FBalanceBack NUMERIC(28,10) DEFAULT 0,CONSTRAINT pk_fin_creditleid PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FIN_CreditLimitUsed')
Create Table T_FIN_CreditLimitUsed ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FProperty INT,FCurrencyID VARCHAR(44),FBillId NVARCHAR(100),FBillType NVARCHAR(100),FBillNumber NVARCHAR(100),FUsedQuota NUMERIC(19,4) DEFAULT 0 NOT NULL,FReturnedQuota NUMERIC(19,4) DEFAULT 0 NOT NULL,FCreditLimitId VARCHAR(44),FCompanyID VARCHAR(44),FIsUnionAddnew INT DEFAULT 0,FIsUnioned INT DEFAULT 0,CONSTRAINT pk_fin_creditluid PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FIN_CreditUsage')
Create Table T_FIN_CreditUsage ( FName_l1 NVARCHAR(255),FName_l2 NVARCHAR(255),FName_l3 NVARCHAR(255),FNumber NVARCHAR(80),FDescription_l1 NVARCHAR(255),FDescription_l2 NVARCHAR(255),FDescription_l3 NVARCHAR(255),FSimpleName NVARCHAR(80),FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4',FRemark NVARCHAR(255),CONSTRAINT PK_FIN_CreditUsage PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FIN_CreditlimitGTEntry')
Create Table T_FIN_CreditlimitGTEntry ( FID VARCHAR(44) NOT NULL ,FSeq INT,FParentBillIdID VARCHAR(44),FGuaranteeTypeID VARCHAR(44),FGuarantee NVARCHAR(80),FScale NUMERIC(28,10),FAssureCompanyID VARCHAR(44),FAmount NUMERIC(28,10),FAssureCurrencyID VARCHAR(44),FExchangeRate NUMERIC(28,10),FBillId NVARCHAR(80),FBillNumber NVARCHAR(80),FBilltype INT,FGuaranteeCompHand NVARCHAR(80),FWage NUMERIC(28,10) DEFAULT 0,FWageRate NUMERIC(28,10) DEFAULT 0,FCanWage NUMERIC(28,10) DEFAULT 0,FRealWage NUMERIC(28,10) DEFAULT 0,FRemark NVARCHAR(80),FIsUnion INT DEFAULT 0,FGuaranteeTypeProperty INT,CONSTRAINT PK_CreditlimitGTEn PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FIN_CreditorGroup')
Create Table T_FIN_CreditorGroup ( FName_l1 NVARCHAR(255),FName_l2 NVARCHAR(255),FName_l3 NVARCHAR(255),FNumber NVARCHAR(80),FDescription_l1 NVARCHAR(255),FDescription_l2 NVARCHAR(255),FDescription_l3 NVARCHAR(255),FSimpleName NVARCHAR(80),FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4',FRemark NVARCHAR(255),CONSTRAINT PK_FIN_CreditorGro PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FIN_FinancingFee')
Create Table T_FIN_FinancingFee ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FName_l1 NVARCHAR(255),FName_l2 NVARCHAR(255),FName_l3 NVARCHAR(255),FNumber NVARCHAR(80),FDescription_l1 NVARCHAR(255),FDescription_l2 NVARCHAR(255),FDescription_l3 NVARCHAR(255),FSimpleName NVARCHAR(80),FRemark NVARCHAR(80),CONSTRAINT PK_FinancingFee PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FIN_FinancingProducts')
Create Table T_FIN_FinancingProducts ( FName_l1 NVARCHAR(255),FName_l2 NVARCHAR(255),FName_l3 NVARCHAR(255),FNumber NVARCHAR(80) NOT NULL ,FDescription_l1 NVARCHAR(255),FDescription_l2 NVARCHAR(255),FDescription_l3 NVARCHAR(255),FSimpleName NVARCHAR(80),FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4',FFinancingSourceID VARCHAR(44),FBillType INT,FRemark NVARCHAR(255),FNoteTypeID VARCHAR(44),CONSTRAINT PK_FIN_FinProduct PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FIN_FinancingSources')
Create Table T_FIN_FinancingSources ( FName_l1 NVARCHAR(255),FName_l2 NVARCHAR(255),FName_l3 NVARCHAR(255),FNumber NVARCHAR(80),FDescription_l1 NVARCHAR(255),FDescription_l2 NVARCHAR(255),FDescription_l3 NVARCHAR(255),FSimpleName NVARCHAR(80),FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4',FRemark NVARCHAR(255),FIsLeaf INT,FLevel INT,FLongNumber VARCHAR(44),FDisplayName_l1 VARCHAR(250),FDisplayName_l2 VARCHAR(250),FDisplayName_l3 VARCHAR(250),FParentId VARCHAR(44),CONSTRAINT PK_FIN_FinancingSI PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FIN_GuaranteeDetail')
Create Table T_FIN_GuaranteeDetail ( FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FName_l1 NVARCHAR(255),FName_l2 NVARCHAR(255),FName_l3 NVARCHAR(255),FNumber NVARCHAR(80),FDescription_l1 NVARCHAR(255),FDescription_l2 NVARCHAR(255),FDescription_l3 NVARCHAR(255),FSimpleName NVARCHAR(80),FID VARCHAR(44) NOT NULL ,FParentBillType INT,FParentBillId VARCHAR(44),FScale NUMERIC(28,10),FAmount NUMERIC(28,10) DEFAULT 0 NOT NULL ,FExchangeRate NUMERIC(28,10),FBalance NUMERIC(28,10) DEFAULT 0 NOT NULL ,FGuaranteeTypeID VARCHAR(44),FGuaranteeName NVARCHAR(500),FBillId VARCHAR(44),FBillNumber NVARCHAR(80),FBilltype INT DEFAULT 0,FCurrencyID VARCHAR(44),FGuaranteeCompID NVARCHAR(80),FGuaranteeCompHand NVARCHAR(80),FWage NUMERIC(28,10),FWageRate NUMERIC(28,10),FCanWage NUMERIC(28,10),FRealWage NUMERIC(28,10),FRemark NVARCHAR(80),FGuaranteeTypeProperty INT,CONSTRAINT PK_GuaranteeDetail PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FIN_GuaranteeType')
Create Table T_FIN_GuaranteeType ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FName_l1 NVARCHAR(255),FName_l2 NVARCHAR(255),FName_l3 NVARCHAR(255),FNumber NVARCHAR(80),FDescription_l1 NVARCHAR(255),FDescription_l2 NVARCHAR(255),FDescription_l3 NVARCHAR(255),FSimpleName NVARCHAR(80),FRemark NVARCHAR(255),FLinkAssureBill INT,FLinkBillType INT,FProperty INT,CONSTRAINT pk_fin_guaranteety PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FIN_LetterOfCredit')
Create Table T_FIN_LetterOfCredit ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FNumber NVARCHAR(80),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(255),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyID VARCHAR(44),FSourceID VARCHAR(44),FTypeID VARCHAR(44),FRegion INT,FCurrencyID VARCHAR(44),FAmount NUMERIC(19,4) DEFAULT 0 NOT NULL,FBalance NUMERIC(19,4) DEFAULT 0 NOT NULL,FLocalCurExRate NUMERIC(28,16) DEFAULT 0 NOT NULL,FIsInCredit INT,FUsedQuota NUMERIC(19,4) DEFAULT 0 NOT NULL,FIssueDate DateTime,FExpiredDate DateTime,FHorizon NUMERIC(19,4) DEFAULT 0 NOT NULL,FGaranteeTypeID VARCHAR(44),FRemark NVARCHAR(500),FGarantee NVARCHAR(500),FCreditLimitId VARCHAR(44),FAmountLocalCur NUMERIC(19,4) DEFAULT 0 NOT NULL,FInstitutionId VARCHAR(44),FCreditCurrencyID VARCHAR(44),FCreditCurExRate NUMERIC(19,4) DEFAULT 0 NOT NULL,FUseAssureBill INT,FAssureBillId VARCHAR(44),FAssExRate NUMERIC(28,10),FAssCurrencyId VARCHAR(44),FFiVouchered INT DEFAULT 0,FHistoryBill INT,FGuaranteeTypeInputMode INT,FIsForward INT,FBeneficiary NVARCHAR(100),FBlockFlowTypeID VARCHAR(44),FAccountantID VARCHAR(44),FRemainAmount NUMERIC(19,4) DEFAULT 0 NOT NULL ,FIsRelBankInCredit INT DEFAULT 0,FNtTypeID VARCHAR(44),FCreditLocalAmt NUMERIC(28,10),FvoucherTypeID VARCHAR(44),FvoucherNumber NVARCHAR(80), FDeferReturnCreditLimitDays INT not null default 0, CONSTRAINT pk_fin_letterofcre PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FIN_Loan')
Create Table T_FIN_Loan ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FNumber NVARCHAR(80),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(255),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyID VARCHAR(44),FSourceID VARCHAR(44),FTypeID VARCHAR(44),FRegion INT,FCurrencyID VARCHAR(44),FAmount NUMERIC(19,4) DEFAULT 0 NOT NULL,FBalance NUMERIC(19,4) DEFAULT 0 NOT NULL,FLocalCurExRate NUMERIC(28,16) DEFAULT 0 NOT NULL,FIsInCredit INT,FUsedQuota NUMERIC(19,4) DEFAULT 0 NOT NULL,FIssueDate DateTime,FExpiredDate DateTime,FHorizon NUMERIC(28,16) DEFAULT 0 NOT NULL,FGaranteeTypeID VARCHAR(44),FRemark NVARCHAR(500),FGarantee NVARCHAR(500),FCreditLimitId VARCHAR(44),FAmountLocalCur NUMERIC(19,4) DEFAULT 0 NOT NULL,FInstitutionId VARCHAR(44),FCreditCurrencyID VARCHAR(44),FCreditCurExRate NUMERIC(28,16) DEFAULT 0 NOT NULL,FUseAssureBill INT,FAssureBillId VARCHAR(44),FAssExRate NUMERIC(28,10),FAssCurrencyId VARCHAR(44),FFiVouchered INT DEFAULT 0,FHistoryBill INT DEFAULT 0 NOT NULL,FGuaranteeTypeInputMode INT,FIsBankLoan INT,FCreditorGroupID VARCHAR(44),FBankAcctID VARCHAR(44),FSettlementAcctID VARCHAR(44),FLoanAcctID VARCHAR(44),FApplicationRule INT,FBasePoints NUMERIC(19,4) DEFAULT 0 NOT NULL,FYieldRate NUMERIC(19,4) DEFAULT 0 NOT NULL,FRepaymentType INT,FIntRateTypeID VARCHAR(44),FIsGroupLoan INT,FGroupId VARCHAR(44),FBankId VARCHAR(44),FContractNum NVARCHAR(80),FIsMulCon INT,FLoanAccountID VARCHAR(44),FLoanCompanyID VARCHAR(44),FDeliverAccountID VARCHAR(44),FIntAccountID VARCHAR(44),FIntFreeAmt NUMERIC(28,10),FConvertDays INT,FPunishIntRateType VARCHAR(44),FPunishIntRate NUMERIC(28,10),FMyHandlerID VARCHAR(44),FPurpose NVARCHAR(160),FIsOverdue INT DEFAULT 0 NOT NULL,FAccountantID VARCHAR(44),FLastIntDate DateTime,FLastPreIntDate DateTime,FIntRateTypeExpression VARCHAR(80),FYearDays INT,FPenAccrualType VARCHAR(80),FPenAccrualRate NUMERIC(28,10),FEntLoanID VARCHAR(44),FSeqMulCon INT,FMainConLoanID VARCHAR(44),FProjectID VARCHAR(44),FRemainAmount NUMERIC(19,4) DEFAULT 0 NOT NULL ,FFpItemID VARCHAR(44),FFirstRateAdjustDate DateTime,FRateAdjustPeriod INT,FFloatAction INT,FPayIntModeID VARCHAR(44),FLOANAPPLYBILLID VARCHAR(44),FStatus INT,FHandlerRemark NVARCHAR(500),FIsRelBankInCredit INT DEFAULT 0,CONSTRAINT pk_fin_loan PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FIN_LoanAdjustInterest')
Create Table T_FIN_LoanAdjustInterest ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FNumber NVARCHAR(80),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyID VARCHAR(44),FLoanID VARCHAR(44),FCreditorAsCompanyID VARCHAR(44),FCreditorAsBankID VARCHAR(44),FAccountID VARCHAR(44),FContractNum NVARCHAR(80),FAdjustSeq INT,FAdjustDate DateTime,FIntRateTypeExpression VARCHAR(80),FYearDays INT,FAdjustAfterRate NUMERIC(28,10),FPenAccrualType VARCHAR(80),FPenAccrualRate NUMERIC(28,10),FIsUsed INT,CONSTRAINT PK_LoanAdjustInter PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FIN_LoanDefer')
Create Table T_FIN_LoanDefer ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FNumber NVARCHAR(80),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyID VARCHAR(44),FLoanID VARCHAR(44),FSeq INT,FBalance NUMERIC(28,10),FCurrencyID VARCHAR(44),FExchangeRate NUMERIC(28,10),FLocalAmount NUMERIC(28,10),FBeforeDeferDate DateTime,FAfterDeferDate DateTime,FRateExpression VARCHAR(80),FYearDays INT,FDeferRate NUMERIC(28,10),FPenaIntType VARCHAR(80),FPeneIntRate NUMERIC(28,10),FFivouchered INT DEFAULT 0,FAccountantID VARCHAR(44),FContractNum NVARCHAR(80),FCreditorAsCompanyID VARCHAR(44),FCreditorAsBankID VARCHAR(44),FAccountID VARCHAR(44),FChLoanExtendBillID VARCHAR(44),CONSTRAINT PK_LoanDefer PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FIN_LoanEntry')
Create Table T_FIN_LoanEntry ( FID VARCHAR(44) NOT NULL ,FSeq INT,FAmount NUMERIC(19,4) DEFAULT 0 NOT NULL ,FDate DateTime,FParentId VARCHAR(44),FBlockFlowTypeID VARCHAR(44),FRepayIntType INT,CONSTRAINT PK_FIN_LoanEntry PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FIN_LoanInterest')
Create Table T_FIN_LoanInterest ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FNumber NVARCHAR(80),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyID VARCHAR(44),FInterestType INT,FLoanID VARCHAR(44),FCreditorAsCompanyID VARCHAR(44),FCreditorAsBankID VARCHAR(44),FAccountID VARCHAR(44),FCurrencyID VARCHAR(44),FBeginDate DateTime,FEndDate DateTime,FDays INT,FAmount NUMERIC(28,10),FIntRateTypeExpression VARCHAR(80),FIntRate NUMERIC(28,10),FInterest NUMERIC(28,10),FRealInterest NUMERIC(28,10),FDaysOverdue INT,FPunishIntType VARCHAR(80),FPunishIntRate NUMERIC(28,10),FPunishInterest NUMERIC(28,10),FRealPunishInterest NUMERIC(28,10),FStrikeAmount NUMERIC(28,10),FLoanInterestBillID VARCHAR(44),FRepaymentID VARCHAR(44),FStrikeStatus VARCHAR(80),FFivouchered INT DEFAULT 0,FLastIntDate DateTime,FAccountantID VARCHAR(44),FExchange NUMERIC(28,10),FFpItemID VARCHAR(44),FFpItemFactor NUMERIC(28,10) DEFAULT 1 NOT NULL,FIsPrediction INT DEFAULT 0,CONSTRAINT PK_LoanInterest PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FIN_LoanInterestEntry')
Create Table T_FIN_LoanInterestEntry ( FID VARCHAR(44) NOT NULL ,FSeq INT,FParentID VARCHAR(44),FBeginDate DateTime,FEndDate DateTime,FDays INT,FAmount NUMERIC(28,10),FIntRate NUMERIC(28,10),FInterest NUMERIC(28,10),FDaysOverdue INT,FPunishIntRate NUMERIC(28,10),FPunishInterest NUMERIC(28,10),FIntRateTypeExpression VARCHAR(80),FYearDays INT,CONSTRAINT PK_LoanInterestEnt PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FIN_LoanOfFinFeeEntry')
Create Table T_FIN_LoanOfFinFeeEntry ( FID VARCHAR(44) NOT NULL ,FSeq INT,FParentID VARCHAR(44),FFinFeeID VARCHAR(44),FAmount NUMERIC(28,10),FCurrencyID VARCHAR(44),FLocalCurExRate NUMERIC(28,10),FAmountLocalCur NUMERIC(28,10),CONSTRAINT PK_LoanOfFinFeeEnt PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FIN_MainConLoan')
Create Table T_FIN_MainConLoan ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FNumber NVARCHAR(80),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyID VARCHAR(44),FConNumber NVARCHAR(80),FSeq INT,FStartDate DateTime,FEndDate DateTime,FConAmount NUMERIC(28,10),FAddConAmount NUMERIC(28,10),FRemainConAmount NUMERIC(28,10),FIsMulCon INT,CONSTRAINT PK_MainConLoan PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FIN_Repayment')
Create Table T_FIN_Repayment ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FNumber NVARCHAR(80),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyID VARCHAR(44),FSourceType INT,FCTLCancel INT,FCreditorID VARCHAR(44),FRegion INT,FCurrencyID VARCHAR(44),FAmount NUMERIC(28,10) DEFAULT 0,FLocalCurExRate NUMERIC(28,10) DEFAULT 0,FInterest NUMERIC(28,10) DEFAULT 0,FPayment NUMERIC(28,10) DEFAULT 0,FBankAcctID VARCHAR(44),FLoanAcctID VARCHAR(44),FInterestAcctID VARCHAR(44),FRemark NVARCHAR(80),FCreditLimitId VARCHAR(44),FIsPushDown INT DEFAULT 0,FLocalAmount NUMERIC(28,10),FSourceBillNum NVARCHAR(80),FReturnedQuota NUMERIC(28,10) DEFAULT 0,FCreditCurrencyID VARCHAR(44),FCreditCurExRate NUMERIC(28,10) DEFAULT 0,FUseAssureBill INT,FAssureBillId VARCHAR(44),FAssExRate NUMERIC(28,10),FAssCurrencyId VARCHAR(44),FApplyUnitId VARCHAR(44),FInnerAccountID VARCHAR(44),FConfirmerID VARCHAR(44),FSourceCompanyID VARCHAR(44),FMakeType INT,FBankID VARCHAR(44),FLoanCompanyID VARCHAR(44),FLoanID VARCHAR(44),FIsRepayInt INT,FIsCalInt INT,FIsCalPunishInt INT,FSeq INT,FPayeeAccountID VARCHAR(44),FTotalRepayAmt NUMERIC(28,10),FFiVouchered INT DEFAULT 0,FAccountantID VARCHAR(44),FPayee VARCHAR(80),FPayeeCust VARCHAR(44),FCommercialDraftID VARCHAR(44),FCreditorCompanyID VARCHAR(44),FRepaySeq INT,FAddAmount NUMERIC(28,10),FEntRepaymentBillID VARCHAR(44),FDepositAccountID VARCHAR(44),FIntRate NUMERIC(28,10) DEFAULT 0,FDepositAmt NUMERIC(28,10) DEFAULT 0,FFpItemID VARCHAR(44),CONSTRAINT PK_Repayment PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FIN_UnTimeDepositBill')
Create Table T_FIN_UnTimeDepositBill ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FNumber NVARCHAR(80),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyID VARCHAR(44),FUnDepositType VARCHAR(80),FBankID VARCHAR(44),FTimeDepositBillID VARCHAR(44),FUnTimeDepositSeqNo INT,FCorpCurAcctID VARCHAR(44),FCorpDepAcctID VARCHAR(44),FCurrencyID VARCHAR(44),FExchangeRate NUMERIC(28,10) DEFAULT 0,FUnDepositAmt NUMERIC(28,10) DEFAULT 0,FAccumulativeUnTimeDepostAmt NUMERIC(28,10) DEFAULT 0,FIsVouchered INT DEFAULT 0,FCashierID VARCHAR(44),FAccountantID VARCHAR(44),FIsHis INT,FUnDepositAmtLocal NUMERIC(28,10) DEFAULT 0,FIsBooked INT,FIsreceived INT,FUntimeDate DateTime,FDepCompanyID VARCHAR(44),FLastUnDepositDate DateTime,FYearRate NUMERIC(28,10) DEFAULT 0 NOT NULL ,FIsAppointRate INT DEFAULT 0,FIntDeAmt NUMERIC(28,10) DEFAULT 0 NOT NULL ,FIntCurAmt NUMERIC(28,10) DEFAULT 0 NOT NULL ,FIntSum NUMERIC(28,10) DEFAULT 0 NOT NULL ,FIsCalInt INT DEFAULT 0,CONSTRAINT PK_CompUnTimeDepos PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FIN_Wage')
Create Table T_FIN_Wage ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FNumber NVARCHAR(80),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(255),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyID VARCHAR(44),FProperty VARCHAR(80),FWageTypeID VARCHAR(44),FRelation VARCHAR(80),FCustomerCompanyID VARCHAR(44),FWageAmount NUMERIC(28,10) DEFAULT 0,FAmount NUMERIC(28,10) DEFAULT 0,FGuarantee NVARCHAR(80),FInstitutionId VARCHAR(44),FCurrencyID VARCHAR(44),FLocalCurExRate NUMERIC(28,10),FAmountLocalCur NUMERIC(28,10) DEFAULT 0,FWageRate NUMERIC(28,10) DEFAULT 0,FIssueDate DateTime,FExpiredDate DateTime,FHorizon NUMERIC(28,10) DEFAULT 0,FCount NVARCHAR(80),FUnit NVARCHAR(80),FRemark NVARCHAR(80),FMyhandlerID VARCHAR(44),FFee NUMERIC(28,10) DEFAULT 0,FIsWage INT DEFAULT 0,FOwnerRight INT DEFAULT 1,FOwnerRightName NVARCHAR(80),FOwnerCompanyID VARCHAR(44),Fusedamount NUMERIC(28,10) DEFAULT 0 NOT NULL ,Fbalance NUMERIC(28,10) DEFAULT 0,FisRelationRec INT DEFAULT 0 NOT NULL ,FOppAccountViewID Varchar(44), FFivouchered INT DEFAULT 0,CONSTRAINT PK_Wage PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FIN_WageEntry')
Create Table T_FIN_WageEntry ( FID VARCHAR(44) NOT NULL ,FSeq INT,FParentID VARCHAR(44),FTypeID VARCHAR(44),FBillid NVARCHAR(80),FBillnumber NVARCHAR(80),FIssueDate DateTime,FExpiredDate DateTime,FBilltype INT,FAmount NUMERIC(28,10) DEFAULT 0,FRealWage NUMERIC(28,10) DEFAULT 0,FRemark NVARCHAR(80),CONSTRAINT PK_WageEntry PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FIN_WageType')
Create Table T_FIN_WageType ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FName_l1 NVARCHAR(255),FName_l2 NVARCHAR(255),FName_l3 NVARCHAR(255),FNumber NVARCHAR(80),FDescription_l1 NVARCHAR(255),FDescription_l2 NVARCHAR(255),FDescription_l3 NVARCHAR(255),FSimpleName NVARCHAR(80),FRemark NVARCHAR(80),CONSTRAINT PK_WageType PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FIN_LoanApplyBill')
Create Table T_FIN_LoanApplyBill ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FNumber NVARCHAR(80),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyID VARCHAR(44),FApplyDate DateTime,FPurpose NVARCHAR(80),FLoanProperty VARCHAR(80),FLoanType VARCHAR(80),FFinancingOrgID VARCHAR(44),FBankID VARCHAR(44),FCustomerID VARCHAR(44),FCurrencyID VARCHAR(44),FApplyLoanAmt NUMERIC(28,10) DEFAULT 0,FAccountBankID VARCHAR(44),FEffectiveDate DateTime,FMaturityDate DateTime,FHorizon NUMERIC(28,10) DEFAULT 0,FStatus INT,FIsGenLoanBill INT DEFAULT 0,FIsGenLoanOrgBill INT DEFAULT 0,FProjectID VARCHAR(44),CONSTRAINT PK_LoanApplyBill PRIMARY KEY (FID));

iF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FcreditCompanyID' 
	AND KSQL_COL_TABNAME='T_FIN_CreditLimit')
ALTER TABLE T_FIN_CreditLimit ADD FcreditCompanyID VARCHAR(44);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCreditLocalAmt' 
	and KSQL_COL_TABNAME='T_FIN_Loan')
ALTER TABLE T_FIN_Loan ADD FCreditLocalAmt NUMERIC(28,10);

update T_FIN_Loan  set FCreditLocalAmt = FUsedQuota where FCreditLocalAmt is null;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FisIncredit' 
	and KSQL_COL_TABNAME='T_FIN_Repayment')
ALTER TABLE T_FIN_Repayment  ADD FisIncredit INT ;

update T_FIN_Repayment set FisIncredit = 0 where FisIncredit is null;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FcreditPercentage' 
	and KSQL_COL_TABNAME='T_FIN_LetterOfCredit')
ALTER TABLE T_FIN_LetterOfCredit  ADD FcreditPercentage NUMERIC(28,10);


If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FcreditPercetage' 
	and KSQL_COL_TABNAME='T_FIN_Repayment')
ALTER TABLE  T_FIN_Repayment  ADD FcreditPercetage NUMERIC(28,10);


update T_FIN_LetterOfCredit set FcreditPercentage = 100 where FcreditPercentage is null;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FUsedCreditAmt' 
	and KSQL_COL_TABNAME='T_FIN_LetterOfCredit')
ALTER TABLE T_FIN_LetterOfCredit  ADD FUsedCreditAmt NUMERIC(28,10);

update T_FIN_LetterOfCredit set FUsedCreditAmt = FAmount where FUsedCreditAmt is null;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCreditLocalAmt' 
	and KSQL_COL_TABNAME='T_FIN_LetterOfCredit')
ALTER TABLE T_FIN_LetterOfCredit  ADD FCreditLocalAmt NUMERIC(28,10);


If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FIN_CreditFinancingReduce')
Create Table T_FIN_CreditFinancingReduce ( FBillID VARCHAR(44) NOT NULL ,FShareOrgID VARCHAR(44),FFinProID VARCHAR(44),FAssignAmt NUMERIC(28,10),FUsedAmt NUMERIC(28,10),FBalance NUMERIC(28,10),FControlWay INT,FCreditEntryID VARCHAR(44) NOT NULL ,FCreditLimitID VARCHAR(44) NOT NULL ,FReduceSeq INT,FID VARCHAR(44) NOT NULL ,CONSTRAINT PK_CreditFinancing PRIMARY KEY (FID));



If exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FcreditLimitAmtLocal' 
	and KSQL_COL_TABNAME='T_FIN_LetterOfCredit')
ALTER TABLE T_FIN_LetterOfCredit  DROP column FcreditLimitAmtLocal;

update T_FIN_LetterOfCredit set FCreditLocalAmt = fcreditcurexrate*FUsedCreditAmt where FCreditLocalAmt is null;

If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FIsDifferPlace' 
    and KSQL_COL_TABNAME = 'T_CAS_PaymentBill' )
ALTER TABLE T_CAS_PaymentBill ADD FIsDifferPlace int default 0;

 
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='ftmpCol' 
	and KSQL_COL_TABNAME='t_fin_loan')
alter table t_fin_loan add  ftmpCol NUMERIC(21,10);


update t_fin_loan set ftmpCol=fyieldrate; 


If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='fyieldrate' 
	and KSQL_COL_TABNAME='t_fin_loan' and KSQL_COL_NULLABLE='Y')
alter table t_fin_loan alter fyieldrate NUMERIC(19,4) null;


update t_fin_loan set fyieldrate = null;


alter table t_fin_loan alter fyieldrate NUMERIC(21,10);


update t_fin_loan set fyieldrate=ftmpCol;


alter table t_fin_loan drop column ftmpCol;


IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FIntFeeAcctViewID' 
	AND KSQL_COL_TABNAME='T_FIN_LoanInterest')
ALTER TABLE T_FIN_LoanInterest ADD FIntFeeAcctViewID VARCHAR(44);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FCashierID' 
	AND KSQL_COL_TABNAME='T_FIN_LoanInterest')
ALTER TABLE T_FIN_LoanInterest ADD FCashierID VARCHAR(44);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCautionAmt' 
	and KSQL_COL_TABNAME='T_FIN_Loan')
ALTER TABLE T_FIN_Loan ADD FCautionAmt NUMERIC(28,10) Default 0;

update T_FIN_Loan  set FCautionAmt = 0 where FCautionAmt is null;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCautionAmt' 
	and KSQL_COL_TABNAME='T_FIN_Repayment')
ALTER TABLE T_FIN_Repayment ADD FCautionAmt NUMERIC(28,10) Default 0;

update T_FIN_Repayment  set FCautionAmt = 0 where FCautionAmt is null;



If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FcautionAmtRepay' 
	and KSQL_COL_TABNAME='T_FIN_Loan')
ALTER TABLE T_FIN_Loan ADD FcautionAmtRepay NUMERIC(28,10) Default 0;

update T_FIN_Loan set FcautionAmtRepay = 0 where FcautionAmtRepay is null;



IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FIntFeeAcctViewID' 
	AND KSQL_COL_TABNAME='T_FIN_Loan')
ALTER TABLE T_FIN_Loan ADD FIntFeeAcctViewID VARCHAR(44);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FCautionAcctBankID' 
	AND KSQL_COL_TABNAME='T_FIN_Loan')
ALTER TABLE T_FIN_Loan ADD FCautionAcctBankID VARCHAR(44);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FAuctionPerc' 
	and KSQL_COL_TABNAME='T_FIN_Loan')
ALTER TABLE T_FIN_Loan ADD FAuctionPerc NUMERIC(28,10) Default 0;

update T_FIN_Loan set FAuctionPerc = 0 where FAuctionPerc is null;


IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FIntFeeAcctViewID' 
	AND KSQL_COL_TABNAME='T_FIN_Repayment')
ALTER TABLE T_FIN_Repayment ADD FIntFeeAcctViewID VARCHAR(44);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FAcutionAcctBankID' 
	AND KSQL_COL_TABNAME='T_FIN_Repayment')
ALTER TABLE T_FIN_Repayment ADD FAcutionAcctBankID VARCHAR(44);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FCashierID' 
	AND KSQL_COL_TABNAME='T_FIN_Loan')
ALTER TABLE T_FIN_Loan ADD FCashierID VARCHAR(44);


IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FTransBillID' 
	AND KSQL_COL_TABNAME='T_FIN_Loan')
ALTER TABLE T_FIN_Loan ADD FTransBillID VARCHAR(44);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FvoucherNumber' AND KSQL_COL_TABNAME='T_FIN_Loan') 
ALTER TABLE T_FIN_Loan ADD FvoucherNumber NVARCHAR(80);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FvoucherTypeID' AND KSQL_COL_TABNAME='T_FIN_Loan') 
ALTER TABLE T_FIN_Loan ADD FvoucherTypeID VARCHAR(44);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FvoucherNumber' AND KSQL_COL_TABNAME='T_FIN_LoanDefer') 
ALTER TABLE T_FIN_LoanDefer ADD FvoucherNumber NVARCHAR(80);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FvoucherTypeID' AND KSQL_COL_TABNAME='T_FIN_LoanDefer') 
ALTER TABLE T_FIN_LoanDefer ADD FvoucherTypeID VARCHAR(44);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FvoucherNumber' AND KSQL_COL_TABNAME='T_FIN_Repayment') 
ALTER TABLE T_FIN_Repayment ADD FvoucherNumber NVARCHAR(80);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FvoucherTypeID' AND KSQL_COL_TABNAME='T_FIN_Repayment') 
ALTER TABLE T_FIN_Repayment ADD FvoucherTypeID VARCHAR(44);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FvoucherNumber' AND KSQL_COL_TABNAME='T_FIN_LoanInterest') 
ALTER TABLE T_FIN_LoanInterest ADD FvoucherNumber NVARCHAR(80);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FvoucherTypeID' AND KSQL_COL_TABNAME='T_FIN_LoanInterest') 
ALTER TABLE T_FIN_LoanInterest ADD FvoucherTypeID VARCHAR(44);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FlastPayDate' 
	and KSQL_COL_TABNAME='T_FIN_CompDepositAccountBill')
ALTER TABLE T_FIN_CompDepositAccountBill ADD FlastPayDate DateTime;


IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FvoucherNumber' AND KSQL_COL_TABNAME='T_FIN_CompDepositAccountBill') 
ALTER TABLE T_FIN_CompDepositAccountBill ADD FvoucherNumber NVARCHAR(80);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FvoucherTypeID' AND KSQL_COL_TABNAME='T_FIN_CompDepositAccountBill') 
ALTER TABLE T_FIN_CompDepositAccountBill ADD FvoucherTypeID VARCHAR(44);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FvoucherNumber' AND KSQL_COL_TABNAME='T_FIN_CompIntReceivedBill') 
ALTER TABLE T_FIN_CompIntReceivedBill ADD FvoucherNumber NVARCHAR(80);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FvoucherTypeID' AND KSQL_COL_TABNAME='T_FIN_CompIntReceivedBill') 
ALTER TABLE T_FIN_CompIntReceivedBill ADD FvoucherTypeID VARCHAR(44);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FvoucherNumber' AND KSQL_COL_TABNAME='T_FIN_UnTimeDepositBill') 
ALTER TABLE T_FIN_UnTimeDepositBill ADD FvoucherNumber NVARCHAR(80);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FvoucherTypeID' AND KSQL_COL_TABNAME='T_FIN_UnTimeDepositBill') 
ALTER TABLE T_FIN_UnTimeDepositBill ADD FvoucherTypeID VARCHAR(44);


--信用证添加字段
--1 保证金比例
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FMarginRate' AND KSQL_COL_TABNAME='T_FIN_LetterOfCredit') 
ALTER TABLE T_FIN_LetterOfCredit ADD FMarginRate NUMERIC(28,10);

--2 折授信币别保证金
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FLimitMargin' AND KSQL_COL_TABNAME='T_FIN_LetterOfCredit') 
ALTER TABLE T_FIN_LetterOfCredit ADD FLimitMargin NUMERIC(28,10);

--3 保证金币别
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FMarginCurrencyID' AND KSQL_COL_TABNAME='T_FIN_LetterOfCredit') 
ALTER TABLE T_FIN_LetterOfCredit ADD FMarginCurrencyID VARCHAR(44);

--4 折保证金币别汇率
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FMarginExRate' AND KSQL_COL_TABNAME='T_FIN_LetterOfCredit') 
ALTER TABLE T_FIN_LetterOfCredit ADD FMarginExRate NUMERIC(28,10);

--5 折保证金币别保证金
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FMarginEx' AND KSQL_COL_TABNAME='T_FIN_LetterOfCredit') 
ALTER TABLE T_FIN_LetterOfCredit ADD FMarginEx NUMERIC(28,10);

--6 保证金账户
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FMarginAcctID' AND KSQL_COL_TABNAME='T_FIN_LetterOfCredit') 
ALTER TABLE T_FIN_LetterOfCredit ADD FMarginAcctID VARCHAR(44);

--7 保证金余额
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FMarginBalance' AND KSQL_COL_TABNAME='T_FIN_LetterOfCredit') 
ALTER TABLE T_FIN_LetterOfCredit ADD FMarginBalance NUMERIC(28,10);

--8 付款账户
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FPayBankAcctID' AND KSQL_COL_TABNAME='T_FIN_LetterOfCredit') 
ALTER TABLE T_FIN_LetterOfCredit ADD FPayBankAcctID VARCHAR(44);

--8 保证金算法
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FMarginAlgorithm' AND KSQL_COL_TABNAME='T_FIN_LetterOfCredit') 
ALTER TABLE T_FIN_LetterOfCredit ADD FMarginAlgorithm INT;

--9 部门
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FDepartmentID' AND KSQL_COL_TABNAME='T_FIN_LetterOfCredit') 
ALTER TABLE T_FIN_LetterOfCredit ADD FDepartmentID VARCHAR(44);

--10 项目
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FProjectID' AND KSQL_COL_TABNAME='T_FIN_LetterOfCredit') 
ALTER TABLE T_FIN_LetterOfCredit ADD FProjectID VARCHAR(44);

--还款单
--1 保证金币别
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FMarginCurrencyID' AND KSQL_COL_TABNAME='T_FIN_Repayment') 
ALTER TABLE T_FIN_Repayment ADD FMarginCurrencyID VARCHAR(44);

--2 保证金余额
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FMarginBalance' AND KSQL_COL_TABNAME='T_FIN_Repayment') 
ALTER TABLE T_FIN_Repayment ADD FMarginBalance NUMERIC(28,10);


If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FControlWay' 
	and KSQL_COL_TABNAME='T_FIN_CreditLimitEntry')
ALTER TABLE T_FIN_CreditLimitEntry ADD FControlWay INT;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FFinProID' 
	and KSQL_COL_TABNAME='T_FIN_CreditLimitEntry')
ALTER TABLE T_FIN_CreditLimitEntry ADD FFinProID VARCHAR(44);

if not exists (select * from ksql_usercolumns where ksql_col_name ='fstatusextenum' and ksql_col_tabname='t_fin_loandefer') 
alter table t_fin_loandefer add fstatusextenum int;

if not exists (select * from ksql_usercolumns where ksql_col_name ='fstatusextenum' and ksql_col_tabname='t_fin_loaninterest') 
alter table t_fin_loaninterest add fstatusextenum int;

if not exists (select * from ksql_usercolumns where ksql_col_name ='fstatusextenum' and ksql_col_tabname='t_fin_repayment') 
alter table t_fin_repayment add fstatusextenum int;

update t_fin_loandefer set  fstatusextenum = 0 where fstatusextenum is null;
update t_fin_loaninterest set  fstatusextenum = 0 where fstatusextenum is null;
update t_fin_repayment set  fstatusextenum = 0 where fstatusextenum is null;

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FcreditCompanyID' 
	AND KSQL_COL_TABNAME='T_FIN_CreditLimit')
ALTER TABLE T_FIN_CreditLimit ADD FcreditCompanyID VARCHAR(44);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCreditLocalAmt' 
	and KSQL_COL_TABNAME='T_FIN_Loan')
ALTER TABLE T_FIN_Loan ADD FCreditLocalAmt NUMERIC(28,10);

update T_FIN_Loan  set FCreditLocalAmt = FUsedQuota where FCreditLocalAmt is null;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FisIncredit' 
	and KSQL_COL_TABNAME='T_FIN_Repayment')
ALTER TABLE T_FIN_Repayment  ADD FisIncredit INT ;

update T_FIN_Repayment set FisIncredit = 0 where FisIncredit is null;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FcreditPercentage' 
	and KSQL_COL_TABNAME='T_FIN_LetterOfCredit')
ALTER TABLE T_FIN_LetterOfCredit  ADD FcreditPercentage NUMERIC(28,10);


If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FcreditPercetage' 
	and KSQL_COL_TABNAME='T_FIN_Repayment')
ALTER TABLE  T_FIN_Repayment  ADD FcreditPercetage NUMERIC(28,10);


update T_FIN_LetterOfCredit set FcreditPercentage = 100 where FcreditPercentage is null;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FUsedCreditAmt' 
	and KSQL_COL_TABNAME='T_FIN_LetterOfCredit')
ALTER TABLE T_FIN_LetterOfCredit  ADD FUsedCreditAmt NUMERIC(28,10);

update T_FIN_LetterOfCredit set FUsedCreditAmt = FAmount where FUsedCreditAmt is null;


If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCreditLocalAmt' 
	and KSQL_COL_TABNAME='T_FIN_LetterOfCredit')
ALTER TABLE T_FIN_LetterOfCredit  ADD FCreditLocalAmt NUMERIC(28,10);

If exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FcreditLimitAmtLocal' 
	and KSQL_COL_TABNAME='T_FIN_LetterOfCredit')
ALTER TABLE T_FIN_LetterOfCredit  DROP column FcreditLimitAmtLocal;

update T_FIN_LetterOfCredit set FCreditLocalAmt = fcreditcurexrate*FUsedCreditAmt where FCreditLocalAmt is null;

If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FIsDifferPlace' 
    and KSQL_COL_TABNAME = 'T_CAS_PaymentBill' )
ALTER TABLE T_CAS_PaymentBill ADD FIsDifferPlace int default 0;

--增加临时列ftmpCol
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='ftmpCol' 
	and KSQL_COL_TABNAME='t_fin_loan')
alter table t_fin_loan add  ftmpCol NUMERIC(21,10);

--把fyieldrate瘿?备份到ftmpCol
update t_fin_loan set ftmpCol=fyieldrate; 


If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='fyieldrate' 
	and KSQL_COL_TABNAME='t_fin_loan' and KSQL_COL_NULLABLE='Y')
alter table t_fin_loan alter fyieldrate NUMERIC(19,4) null;

--清空fyieldrate
update t_fin_loan set fyieldrate = null;

--修改列长? 
alter table t_fin_loan alter fyieldrate NUMERIC(21,10);

--还原fyieldrate列的?
update t_fin_loan set fyieldrate=ftmpCol;

--删除alter_FreturnWay
alter table t_fin_loan drop column ftmpCol;


IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FIntFeeAcctViewID' 
	AND KSQL_COL_TABNAME='T_FIN_LoanInterest')
ALTER TABLE T_FIN_LoanInterest ADD FIntFeeAcctViewID VARCHAR(44);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FCashierID' 
	AND KSQL_COL_TABNAME='T_FIN_LoanInterest')
ALTER TABLE T_FIN_LoanInterest ADD FCashierID VARCHAR(44);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCautionAmt' 
	and KSQL_COL_TABNAME='T_FIN_Loan')
ALTER TABLE T_FIN_Loan ADD FCautionAmt NUMERIC(28,10) Default 0;

update T_FIN_Loan  set FCautionAmt = 0 where FCautionAmt is null;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCautionAmt' 
	and KSQL_COL_TABNAME='T_FIN_Repayment')
ALTER TABLE T_FIN_Repayment ADD FCautionAmt NUMERIC(28,10) Default 0;

update T_FIN_Repayment  set FCautionAmt = 0 where FCautionAmt is null;



If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FcautionAmtRepay' 
	and KSQL_COL_TABNAME='T_FIN_Loan')
ALTER TABLE T_FIN_Loan ADD FcautionAmtRepay NUMERIC(28,10) Default 0;

update T_FIN_Loan set FcautionAmtRepay = 0 where FcautionAmtRepay is null;



IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FIntFeeAcctViewID' 
	AND KSQL_COL_TABNAME='T_FIN_Loan')
ALTER TABLE T_FIN_Loan ADD FIntFeeAcctViewID VARCHAR(44);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FCautionAcctBankID' 
	AND KSQL_COL_TABNAME='T_FIN_Loan')
ALTER TABLE T_FIN_Loan ADD FCautionAcctBankID VARCHAR(44);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FCashierID' 
	AND KSQL_COL_TABNAME='T_FIN_Loan')
ALTER TABLE T_FIN_Loan ADD FCashierID VARCHAR(44);


IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FTransBillID' 
	AND KSQL_COL_TABNAME='T_FIN_Loan')
ALTER TABLE T_FIN_Loan ADD FTransBillID VARCHAR(44);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FAuctionPerc' 
	and KSQL_COL_TABNAME='T_FIN_Loan')
ALTER TABLE T_FIN_Loan ADD FAuctionPerc NUMERIC(28,10) Default 0;

update T_FIN_Loan set FAuctionPerc = 0 where FAuctionPerc is null;


IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FIntFeeAcctViewID' 
	AND KSQL_COL_TABNAME='T_FIN_Repayment')
ALTER TABLE T_FIN_Repayment ADD FIntFeeAcctViewID VARCHAR(44);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FAcutionAcctBankID' 
	AND KSQL_COL_TABNAME='T_FIN_Repayment')
ALTER TABLE T_FIN_Repayment ADD FAcutionAcctBankID VARCHAR(44);


IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FvoucherNumber' AND KSQL_COL_TABNAME='T_FIN_Loan') 
ALTER TABLE T_FIN_Loan ADD FvoucherNumber NVARCHAR(80);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FvoucherTypeID' AND KSQL_COL_TABNAME='T_FIN_Loan') 
ALTER TABLE T_FIN_Loan ADD FvoucherTypeID VARCHAR(44);

update T_FIN_Loan set (fnumber,fvoucherNumber,fvoucherTypeid) = 
(
	select a.loannumber,a.vounumber,a.voutype
	from
	(
		select chloan.fid as loanid,chloan.fnumber as loannumber ,vou.fnumber as vouNumber,vou.fvoucherTypeid as vouType
		from T_FIN_Loan as chloan
		inner join t_bot_relation rela on rela.fsrcobjectid = chloan.fid
		inner join t_gl_voucher as vou on rela.fdestobjectid = vou.fid
	) as a
	where a.loanid = fid
);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FvoucherNumber' AND KSQL_COL_TABNAME='T_FIN_LoanDefer') 
ALTER TABLE T_FIN_LoanDefer ADD FvoucherNumber NVARCHAR(80);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FvoucherTypeID' AND KSQL_COL_TABNAME='T_FIN_LoanDefer') 
ALTER TABLE T_FIN_LoanDefer ADD FvoucherTypeID VARCHAR(44);
update T_FIN_LoanDefer set (fnumber,fvoucherNumber,fvoucherTypeid) = 
(
	select a.loannumber,a.vounumber,a.voutype
	from
	(
		select chloan.fid as loanid,chloan.fnumber as loannumber ,vou.fnumber as vouNumber,vou.fvoucherTypeid as vouType
		from T_FIN_LoanDefer as chloan
		inner join t_bot_relation rela on rela.fsrcobjectid = chloan.fid
		inner join t_gl_voucher as vou on rela.fdestobjectid = vou.fid
	) as a
	where a.loanid = fid
);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FvoucherNumber' AND KSQL_COL_TABNAME='T_FIN_Repayment') 
ALTER TABLE T_FIN_Repayment ADD FvoucherNumber NVARCHAR(80);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FvoucherTypeID' AND KSQL_COL_TABNAME='T_FIN_Repayment') 
ALTER TABLE T_FIN_Repayment ADD FvoucherTypeID VARCHAR(44);

update T_FIN_Repayment set (fnumber,fvoucherNumber,fvoucherTypeid) = 
(
	select a.loannumber,a.vounumber,a.voutype
	from
	(
		select chloan.fid as loanid,chloan.fnumber as loannumber ,vou.fnumber as vouNumber,vou.fvoucherTypeid as vouType
		from T_FIN_Repayment as chloan
		inner join t_bot_relation rela on rela.fsrcobjectid = chloan.fid
		inner join t_gl_voucher as vou on rela.fdestobjectid = vou.fid
	) as a
	where a.loanid = fid
);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FvoucherNumber' AND KSQL_COL_TABNAME='T_FIN_LoanInterest') 
ALTER TABLE T_FIN_LoanInterest ADD FvoucherNumber NVARCHAR(80);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FvoucherTypeID' AND KSQL_COL_TABNAME='T_FIN_LoanInterest') 
ALTER TABLE T_FIN_LoanInterest ADD FvoucherTypeID VARCHAR(44);

update T_FIN_LoanInterest set (fnumber,fvoucherNumber,fvoucherTypeid) = 
(
	select a.loannumber,a.vounumber,a.voutype
	from
	(
		select chloan.fid as loanid,chloan.fnumber as loannumber ,vou.fnumber as vouNumber,vou.fvoucherTypeid as vouType
		from T_FIN_LoanInterest as chloan
		inner join t_bot_relation rela on rela.fsrcobjectid = chloan.fid
		inner join t_gl_voucher as vou on rela.fdestobjectid = vou.fid
	) as a
	where a.loanid = fid
);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FlastPayDate' 
	and KSQL_COL_TABNAME='T_FIN_CompDepositAccountBill')
ALTER TABLE T_FIN_CompDepositAccountBill ADD FlastPayDate DateTime;


IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FvoucherNumber' AND KSQL_COL_TABNAME='T_FIN_CompDepositAccountBill') 
ALTER TABLE T_FIN_CompDepositAccountBill ADD FvoucherNumber NVARCHAR(80);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FvoucherTypeID' AND KSQL_COL_TABNAME='T_FIN_CompDepositAccountBill') 
ALTER TABLE T_FIN_CompDepositAccountBill ADD FvoucherTypeID VARCHAR(44);

update T_FIN_CompDepositAccountBill set (fnumber,fvoucherNumber,fvoucherTypeid) = 
(
	select a.loannumber,a.vounumber,a.voutype
	from
	(
		select chloan.fid as loanid,chloan.fnumber as loannumber ,vou.fnumber as vouNumber,vou.fvoucherTypeid as vouType
		from T_FIN_CompDepositAccountBill as chloan
		inner join t_bot_relation rela on rela.fsrcobjectid = chloan.fid
		inner join t_gl_voucher as vou on rela.fdestobjectid = vou.fid
	) as a
	where a.loanid = fid
);


IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FvoucherNumber' AND KSQL_COL_TABNAME='T_FIN_CompIntReceivedBill') 
ALTER TABLE T_FIN_CompIntReceivedBill ADD FvoucherNumber NVARCHAR(80);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FvoucherTypeID' AND KSQL_COL_TABNAME='T_FIN_CompIntReceivedBill') 
ALTER TABLE T_FIN_CompIntReceivedBill ADD FvoucherTypeID VARCHAR(44);

update T_FIN_CompIntReceivedBill set (fnumber,fvoucherNumber,fvoucherTypeid) = 
(
	select a.loannumber,a.vounumber,a.voutype
	from
	(
		select chloan.fid as loanid,chloan.fnumber as loannumber ,vou.fnumber as vouNumber,vou.fvoucherTypeid as vouType
		from T_FIN_CompIntReceivedBill as chloan
		inner join t_bot_relation rela on rela.fsrcobjectid = chloan.fid
		inner join t_gl_voucher as vou on rela.fdestobjectid = vou.fid
	) as a
	where a.loanid = fid
);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FvoucherNumber' AND KSQL_COL_TABNAME='T_FIN_UnTimeDepositBill') 
ALTER TABLE T_FIN_UnTimeDepositBill ADD FvoucherNumber NVARCHAR(80);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FvoucherTypeID' AND KSQL_COL_TABNAME='T_FIN_UnTimeDepositBill') 
ALTER TABLE T_FIN_UnTimeDepositBill ADD FvoucherTypeID VARCHAR(44);

update T_FIN_UnTimeDepositBill set (fnumber,fvoucherNumber,fvoucherTypeid) = 
(
	select a.loannumber,a.vounumber,a.voutype
	from
	(
		select chloan.fid as loanid,chloan.fnumber as loannumber ,vou.fnumber as vouNumber,vou.fvoucherTypeid as vouType
		from T_FIN_UnTimeDepositBill as chloan
		inner join t_bot_relation rela on rela.fsrcobjectid = chloan.fid
		inner join t_gl_voucher as vou on rela.fdestobjectid = vou.fid
	) as a
	where a.loanid = fid
);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FEntLoanID' AND KSQL_COL_TABNAME='T_FIN_Loan') 
ALTER TABLE T_FIN_Loan ADD FEntLoanID varchar(44);


if not exists (select * from ksql_usercolumns where ksql_col_name ='fstatusextenum' and ksql_col_tabname='t_fin_loandefer') 
alter table t_fin_loandefer add fstatusextenum int;

if not exists (select * from ksql_usercolumns where ksql_col_name ='fstatusextenum' and ksql_col_tabname='t_fin_loaninterest') 
alter table t_fin_loaninterest add fstatusextenum int;

if not exists (select * from ksql_usercolumns where ksql_col_name ='fstatusextenum' and ksql_col_tabname='t_fin_repayment') 
alter table t_fin_repayment add fstatusextenum int;

update t_fin_loandefer set  fstatusextenum = 0 where fstatusextenum is null;
update t_fin_loaninterest set  fstatusextenum = 0 where fstatusextenum is null;
update t_fin_repayment set  fstatusextenum = 0 where fstatusextenum is null;

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FTRANSBILLID' AND KSQL_COL_TABNAME='T_FIN_Loan') 
ALTER TABLE T_FIN_Loan ADD FTRANSBILLID varchar(44);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCautionAmt' 
	and KSQL_COL_TABNAME='t_fin_repayment')
ALTER TABLE t_fin_repayment ADD FCautionAmt NUMERIC(28,10);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FIntFeeAcctViewID' 
	and KSQL_COL_TABNAME='T_FIN_LoanInterest')
ALTER TABLE T_FIN_LoanInterest ADD FIntFeeAcctViewID VARCHAR(44);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCashierID' 
	and KSQL_COL_TABNAME='T_FIN_LoanInterest')
ALTER TABLE T_FIN_LoanInterest ADD FCashierID VARCHAR(44);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCashierID' 
	and KSQL_COL_TABNAME='T_FIN_repayment')
ALTER TABLE T_FIN_repayment ADD FCashierID VARCHAR(44);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FFinancingResult' 
	AND KSQL_COL_TABNAME='t_fin_loanapplybill')
alter table t_fin_loanapplybill add  FFinancingResult INT; 

update t_fin_loanapplybill set FFinancingResult = -1 where FFinancingResult is null;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FIsGenRecBill' 
	and KSQL_COL_TABNAME='T_FIN_Loan')
ALTER TABLE T_FIN_Loan ADD FIsGenRecBill INT;

update T_FIN_Loan set FIsGenRecBill = 0 where FIsGenRecBill is null;


--信用证添加字段
--1 保证金比例
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FMarginRate' AND KSQL_COL_TABNAME='T_FIN_LetterOfCredit') 
ALTER TABLE T_FIN_LetterOfCredit ADD FMarginRate NUMERIC(28,10);

--2 折授信币别保证金
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FLimitMargin' AND KSQL_COL_TABNAME='T_FIN_LetterOfCredit') 
ALTER TABLE T_FIN_LetterOfCredit ADD FLimitMargin NUMERIC(28,10);

--3 保证金币别
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FMarginCurrencyID' AND KSQL_COL_TABNAME='T_FIN_LetterOfCredit') 
ALTER TABLE T_FIN_LetterOfCredit ADD FMarginCurrencyID VARCHAR(44);

--4 折保证金币别汇率
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FMarginExRate' AND KSQL_COL_TABNAME='T_FIN_LetterOfCredit') 
ALTER TABLE T_FIN_LetterOfCredit ADD FMarginExRate NUMERIC(28,10);

--5 折保证金币别保证金
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FMarginEx' AND KSQL_COL_TABNAME='T_FIN_LetterOfCredit') 
ALTER TABLE T_FIN_LetterOfCredit ADD FMarginEx NUMERIC(28,10);

--6 保证金账户
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FMarginAcctID' AND KSQL_COL_TABNAME='T_FIN_LetterOfCredit') 
ALTER TABLE T_FIN_LetterOfCredit ADD FMarginAcctID VARCHAR(44);

--7 保证金余额
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FMarginBalance' AND KSQL_COL_TABNAME='T_FIN_LetterOfCredit') 
ALTER TABLE T_FIN_LetterOfCredit ADD FMarginBalance NUMERIC(28,10);

--8 付款账户
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FPayBankAcctID' AND KSQL_COL_TABNAME='T_FIN_LetterOfCredit') 
ALTER TABLE T_FIN_LetterOfCredit ADD FPayBankAcctID VARCHAR(44);

--8 保证金算法
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FMarginAlgorithm' AND KSQL_COL_TABNAME='T_FIN_LetterOfCredit') 
ALTER TABLE T_FIN_LetterOfCredit ADD FMarginAlgorithm INT;

--9 部门
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FDepartmentID' AND KSQL_COL_TABNAME='T_FIN_LetterOfCredit') 
ALTER TABLE T_FIN_LetterOfCredit ADD FDepartmentID VARCHAR(44);

--10 项目
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FProjectID' AND KSQL_COL_TABNAME='T_FIN_LetterOfCredit') 
ALTER TABLE T_FIN_LetterOfCredit ADD FProjectID VARCHAR(44);

--还款单
--1 保证金币别
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FMarginCurrencyID' AND KSQL_COL_TABNAME='T_FIN_Repayment') 
ALTER TABLE T_FIN_Repayment ADD FMarginCurrencyID VARCHAR(44);

--2 保证金余额
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FMarginBalance' AND KSQL_COL_TABNAME='T_FIN_Repayment') 
ALTER TABLE T_FIN_Repayment ADD FMarginBalance NUMERIC(28,10);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FIsGenPayBill' 
	and KSQL_COL_TABNAME='T_FIN_Repayment')
ALTER TABLE T_FIN_Repayment ADD FIsGenPayBill INT;

update T_FIN_Repayment set FIsGenPayBill = 0 where FIsGenPayBill is null;


If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FIsGenPayBill' 
	and KSQL_COL_TABNAME='T_FIN_LoanInterest')
ALTER TABLE T_FIN_LoanInterest ADD FIsGenPayBill INT;

update T_FIN_LoanInterest set FIsGenPayBill = 0 where FIsGenPayBill is null;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCashierID' 
	and KSQL_COL_TABNAME='T_FIN_LetterOfCredit')
ALTER TABLE T_FIN_LetterOfCredit ADD FCashierID VARCHAR(44);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FisGenRepayment' 
	and KSQL_COL_TABNAME='T_FIN_LetterOfCredit')
ALTER TABLE T_FIN_LetterOfCredit ADD FisGenRepayment INT;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FUsingBankID' 
	and KSQL_COL_TABNAME='T_FIN_CreditLimitUsed')
ALTER TABLE T_FIN_CreditLimitUsed ADD FUsingBankID VARCHAR(44);


If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FFinacingProductID' 
	and KSQL_COL_TABNAME='T_FIN_CreditUsage')
ALTER TABLE T_FIN_CreditUsage ADD FFinacingProductID VARCHAR(44);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FColligateCredit' 
	and KSQL_COL_TABNAME='T_FIN_CreditUsage')
ALTER TABLE T_FIN_CreditUsage ADD FColligateCredit INT;


If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FControlWay' 
	and KSQL_COL_TABNAME='T_FIN_CreditLimitEntry')
ALTER TABLE T_FIN_CreditLimitEntry ADD FControlWay INT;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FFinProID' 
	and KSQL_COL_TABNAME='T_FIN_CreditLimitEntry')
ALTER TABLE T_FIN_CreditLimitEntry ADD FFinProID VARCHAR(44);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCreditUsageID' 
	and KSQL_COL_TABNAME='T_FIN_CreditLimitUsed')
ALTER TABLE T_FIN_CreditLimitUsed ADD FCreditUsageID VARCHAR(44);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FMortgageType' 
	and KSQL_COL_TABNAME='T_FIN_GuaranteeDetail')
ALTER TABLE T_FIN_GuaranteeDetail ADD FMortgageType INT;	

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FIN_CreditFinancingReduce')
Create Table T_FIN_CreditFinancingReduce ( FBillID VARCHAR(44) NOT NULL ,FShareOrgID VARCHAR(44),FFinProID VARCHAR(44),FAssignAmt NUMERIC(28,10),FUsedAmt NUMERIC(28,10),FBalance NUMERIC(28,10),FControlWay INT,FCreditEntryID VARCHAR(44) NOT NULL ,FCreditLimitID VARCHAR(44) NOT NULL ,FReduceSeq INT,FID VARCHAR(44) NOT NULL ,CONSTRAINT PK_CreditFinancing PRIMARY KEY (FID));

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FisUnion' 
	and KSQL_COL_TABNAME='T_FIN_CreditFinancingReduce')
ALTER TABLE T_FIN_CreditFinancingReduce ADD FisUnion INT;

update T_FIN_CreditFinancingReduce set FisUnion = 0  where FisUnion is null;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FUsingCompanyID' 
	and KSQL_COL_TABNAME='T_FIN_CreditLimitUsed')
ALTER TABLE T_FIN_CreditLimitUsed ADD FUsingCompanyID VARCHAR(44);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='fbalance'  and KSQL_COL_TABNAME='T_FIN_CreditLimitUsed')
ALTER TABLE T_FIN_CreditLimitUsed ADD fbalance NUMERIC(28,10);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FASSIGNAMT'  and KSQL_COL_TABNAME='T_FIN_CreditLimitUsed')
ALTER TABLE T_FIN_CreditLimitUsed ADD FASSIGNAMT NUMERIC(28,10);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FFinProID' 
	and KSQL_COL_TABNAME='T_FIN_CreditLimitUsed')
ALTER TABLE T_FIN_CreditLimitUsed ADD FFinProID VARCHAR(44);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FLongNumberTmp' 
	and KSQL_COL_TABNAME='T_FIN_FinancingSources')
alter table T_FIN_FinancingSources add  FLongNumberTmp NVARCHAR(255);

update T_FIN_FinancingSources set FLongNumberTmp = FLongNumber; 

alter table T_FIN_FinancingSources drop column FLongNumber;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FLongNumber' 
	and KSQL_COL_TABNAME='T_FIN_FinancingSources')
alter table T_FIN_FinancingSources add  FLongNumber NVARCHAR(255);
 
update T_FIN_FinancingSources set FLongNumber = FLongNumberTmp; 

alter table T_FIN_FinancingSources drop column FLongNumberTmp;


-----------授信额度 增加2个字段 ,设置 关闭日期 的初始数据 
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FDeferDay' 
and KSQL_COL_TABNAME='t_fin_creditlimit') 
alter table t_fin_creditlimit add FDeferDay INT default 0;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCreditCloseDate' 
and KSQL_COL_TABNAME='t_fin_creditlimit') 
alter table t_fin_creditlimit add FCreditCloseDate datetime;

If exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCreditCloseDate' 
and KSQL_COL_TABNAME='t_fin_creditlimit') 
update t_fin_creditlimit set FCreditCloseDate=fExpiredDate where FCreditCloseDate is null;

--收款单增加项目
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FItemID' and KSQL_COL_TABNAME='T_FIN_REpayment')
alter table T_FIN_REpayment add FItemID Varchar(44);

--核销单号                                                                    
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FHxdNumber' 
and KSQL_COL_TABNAME='t_fin_repayment')                                    
alter table t_fin_repayment add FHxdNumber NVARCHAR(80);                   
                                                                                
--备案表号码                                                                  
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FBabNumber' 
and KSQL_COL_TABNAME='t_fin_repayment')                                    
alter table t_fin_repayment add FBabNumber NVARCHAR(80);   

--手续费类别
If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FIN_FeeTypeMaintenance')
Create Table T_FIN_FeeTypeMaintenance ( FName_l1 NVARCHAR(255),FName_l2 NVARCHAR(255),FName_l3 NVARCHAR(255),FNumber NVARCHAR(80),FDescription_l1 NVARCHAR(255),FDescription_l2 NVARCHAR(255),FDescription_l3 NVARCHAR(255),FSimpleName NVARCHAR(80),FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4',FAssociateType INT,FRemark NVARCHAR(255),FEnabled INT DEFAULT 1,FISPREFAB INT,CONSTRAINT PK_FIN_FeeTMID PRIMARY KEY (FID)); 

--手续费维护
If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FIN_FeeManage')
Create Table T_FIN_FeeManage ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FNumber NVARCHAR(80),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyID VARCHAR(44),FBusinessNumber NVARCHAR(80),FCurrency VARCHAR(80),FIsCreatorBear INT,FBearDeptID VARCHAR(44),FMoneyAmount NUMERIC(28,10),FSxfzbwb NUMERIC(28,10),FAccountBankID VARCHAR(44),FAccountviewID VARCHAR(44),FAbtract NVARCHAR(80),FLetterCreditID NVARCHAR(80),FLineNo INT,FFeeNameID VARCHAR(44),FExchangeRate NUMERIC(28,10),FFiVouchered INT,CONSTRAINT PK_FeeManage PRIMARY KEY (FID));


--信用证新增字段操作：
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FIntendPayDate' 
and KSQL_COL_TABNAME='T_FIN_LetterOfCredit')  
alter table T_FIN_LetterOfCredit add FIntendPayDate DateTime;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FContractNumber' 
and KSQL_COL_TABNAME='T_FIN_LetterOfCredit')
alter table T_FIN_LetterOfCredit add FContractNumber NVARCHAR(80);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FContractAmount' 
and KSQL_COL_TABNAME='T_FIN_LetterOfCredit')
alter table T_FIN_LetterOfCredit add FContractAmount NUMERIC(28,10);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FOperateStatus' 
and KSQL_COL_TABNAME='T_FIN_LetterOfCredit')
Alter Table T_FIN_LetterOfCredit Add FOperateStatus int default 5;

update T_FIN_LetterOfCredit set FOperateStatus = 5 where FOperateStatus is null;



If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FForwardDate' 
and KSQL_COL_TABNAME='T_FIN_LetterOfCredit')
alter table T_FIN_LetterOfCredit add FForwardDate NVARCHAR(80);


If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FLoadPort' 
and KSQL_COL_TABNAME='T_FIN_LetterOfCredit')
alter table T_FIN_LetterOfCredit add FLoadPort NVARCHAR(80);


If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FDestinationPort' 
and KSQL_COL_TABNAME='T_FIN_LetterOfCredit')
alter table T_FIN_LetterOfCredit add FDestinationPort NVARCHAR(80);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FLoadDate' 
and KSQL_COL_TABNAME='T_FIN_LetterOfCredit')
alter table T_FIN_LetterOfCredit add FLoadDate DateTime;


If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FBeneficiaryStatID' 
and KSQL_COL_TABNAME='T_FIN_LetterOfCredit')
alter table T_FIN_LetterOfCredit add FBeneficiaryStatID VARCHAR(44);


If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FNotifyBankID' 
and KSQL_COL_TABNAME='T_FIN_LetterOfCredit')
alter table T_FIN_LetterOfCredit add FNotifyBankID VARCHAR(44);


If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FTransportMode' 
and KSQL_COL_TABNAME='T_FIN_LetterOfCredit')
alter table T_FIN_LetterOfCredit add FTransportMode NVARCHAR(80);


If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FIsDYZ' 
and KSQL_COL_TABNAME='T_FIN_LetterOfCredit')
alter table T_FIN_LetterOfCredit add FIsDYZ INT;


If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FFluctuateScale' 
and KSQL_COL_TABNAME='T_FIN_LetterOfCredit')
alter table T_FIN_LetterOfCredit add FFluctuateScale INT;


If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FLetterContent' 
and KSQL_COL_TABNAME='T_FIN_LetterOfCredit')
alter table T_FIN_LetterOfCredit add FLetterContent NVARCHAR(80);


If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FProjectID' 
and KSQL_COL_TABNAME='T_FIN_LetterOfCredit')
alter table T_FIN_LetterOfCredit add FProjectID VARCHAR(44);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FDepartmentID' 
and KSQL_COL_TABNAME='T_FIN_LetterOfCredit')
alter table T_FIN_LetterOfCredit add FDepartmentID VARCHAR(44);


If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FLtterHandlerID' 
and KSQL_COL_TABNAME='T_FIN_LetterOfCredit')
alter table T_FIN_LetterOfCredit add FLtterHandlerID VARCHAR(44);


If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FIsBatch' 
and KSQL_COL_TABNAME='T_FIN_LetterOfCredit')
alter table T_FIN_LetterOfCredit add FIsBatch INT;


If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FHxdNumber' 
and KSQL_COL_TABNAME='T_FIN_LetterOfCredit')
alter table T_FIN_LetterOfCredit add FHxdNumber NVARCHAR(2000);


If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FBabNumber' 
and KSQL_COL_TABNAME='T_FIN_LetterOfCredit')
alter table T_FIN_LetterOfCredit add FBabNumber NVARCHAR(2000);


If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FLetterStatus' 
and KSQL_COL_TABNAME='T_FIN_LetterOfCredit')
alter table t_fin_letterofcredit add FLetterStatus VARCHAR(80) DEFAULT '0';


If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FIsDivert' 
and KSQL_COL_TABNAME='T_FIN_LetterOfCredit')
alter table T_FIN_LetterOfCredit add FIsDivert INT DEFAULT 1;


If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCreditLocalAmt' 
and KSQL_COL_TABNAME='T_FIN_LetterOfCredit')
alter table T_FIN_LetterOfCredit add FCreditLocalAmt NUMERIC(28,10);


If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FLetterNumber' 
and KSQL_COL_TABNAME='T_FIN_LetterOfCredit')
alter table T_FIN_LetterOfCredit add FLetterNumber NVARCHAR(100);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FContractCurrencID' 
and KSQL_COL_TABNAME='T_FIN_LetterOfCredit')
alter table T_FIN_LetterOfCredit add FContractCurrencID VARCHAR(44);

--授信额度迁移相关sql
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FFinacingProductID' 
	and KSQL_COL_TABNAME='T_FIN_CreditUsage')
ALTER TABLE T_FIN_CreditUsage ADD FFinacingProductID VARCHAR(44);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FColligateCredit' 
	and KSQL_COL_TABNAME='T_FIN_CreditUsage')
ALTER TABLE T_FIN_CreditUsage ADD FColligateCredit INT;

update T_FIN_CreditUsage  set FColligateCredit =0 where FColligateCredit is null;




If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FDeferDay' 
and KSQL_COL_TABNAME='t_fin_creditlimit') 
alter table t_fin_creditlimit add FDeferDay INT default 0;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCreditCloseDate' 
and KSQL_COL_TABNAME='t_fin_creditlimit') 
alter table t_fin_creditlimit add FCreditCloseDate datetime;

If exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCreditCloseDate' 
and KSQL_COL_TABNAME='t_fin_creditlimit') 
update t_fin_creditlimit set FCreditCloseDate=fExpiredDate where FCreditCloseDate is null;


If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FUsingBankID' 
	and KSQL_COL_TABNAME='T_FIN_CreditLimitUsed')
ALTER TABLE T_FIN_CreditLimitUsed ADD FUsingBankID VARCHAR(44);



If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FControlWay' 
	and KSQL_COL_TABNAME='T_FIN_CreditLimitEntry')
ALTER TABLE T_FIN_CreditLimitEntry ADD FControlWay INT;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FFinProID' 
	and KSQL_COL_TABNAME='T_FIN_CreditLimitEntry')
ALTER TABLE T_FIN_CreditLimitEntry ADD FFinProID VARCHAR(44);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCreditUsageID' 
	and KSQL_COL_TABNAME='T_FIN_CreditLimitUsed')
ALTER TABLE T_FIN_CreditLimitUsed ADD FCreditUsageID VARCHAR(44);




If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCreditLocalAmt' 
	and KSQL_COL_TABNAME='T_FIN_Loan')
ALTER TABLE T_FIN_Loan ADD FCreditLocalAmt NUMERIC(28,10);


If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCreditLocalAmt' 
	and KSQL_COL_TABNAME='T_FIN_LetterOfCredit')
ALTER TABLE T_FIN_LetterOfCredit  ADD FCreditLocalAmt NUMERIC(28,10);


If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FIN_CreditFinancingReduce')
Create Table T_FIN_CreditFinancingReduce ( FBillID VARCHAR(44) NOT NULL ,FShareOrgID VARCHAR(44),FFinProID VARCHAR(44),FAssignAmt NUMERIC(28,10),FUsedAmt NUMERIC(28,10),FBalance NUMERIC(28,10),FControlWay INT,FCreditEntryID VARCHAR(44) NOT NULL ,FCreditLimitID VARCHAR(44) NOT NULL ,FReduceSeq INT,FID VARCHAR(44) NOT NULL ,CONSTRAINT PK_CreditFinancing PRIMARY KEY (FID));

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FisUnion' 
	and KSQL_COL_TABNAME='T_FIN_CreditFinancingReduce')
ALTER TABLE T_FIN_CreditFinancingReduce ADD FisUnion INT;


If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FUsingCompanyID' 
	and KSQL_COL_TABNAME='T_FIN_CreditLimitUsed')
ALTER TABLE T_FIN_CreditLimitUsed ADD FUsingCompanyID VARCHAR(44);


If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='fbalance'  and KSQL_COL_TABNAME='T_FIN_CreditLimitUsed')
ALTER TABLE T_FIN_CreditLimitUsed ADD fbalance NUMERIC(28,10);


If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FASSIGNAMT'  and KSQL_COL_TABNAME='T_FIN_CreditLimitUsed')
ALTER TABLE T_FIN_CreditLimitUsed ADD FASSIGNAMT NUMERIC(28,10);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FFinProID' 
	and KSQL_COL_TABNAME='T_FIN_CreditLimitUsed')
ALTER TABLE T_FIN_CreditLimitUsed ADD FFinProID VARCHAR(44);



---改证体
If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FIN_ModifyLetterEntry')
Create Table T_FIN_ModifyLetterEntry ( FSeq INT,FID VARCHAR(44) NOT NULL ,FParentID VARCHAR(44) NOT NULL ,FModifyItem VARCHAR(100),FContentBeforeM NVARCHAR(100),FContentAfterM NVARCHAR(100),FLetterAbstract NVARCHAR(100),CONSTRAINT PK_FIN_ModifyLEID PRIMARY KEY (FID));
--改证头
If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FIN_ModifyLetter')
Create Table T_FIN_ModifyLetter ( FNumber NVARCHAR(80),FBizDate DateTime,FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyID VARCHAR(44),FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4',FFivouchered INT,FLetterNumber NVARCHAR(100),FModifyDate DateTime,FLetterHandlerID VARCHAR(44),FModifyNumber INT,FLetterReason NVARCHAR(100),FLetterId NVARCHAR(100),CONSTRAINT PK_FIN_ModifyLID PRIMARY KEY (FID));

--先前需求：额度关闭日期默认=到期日  现需求：额度关闭日期默认=到期日+1天 by gss
--增加延期天数字段 by gss
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FDeferDay' 
and KSQL_COL_TABNAME='t_fin_creditlimit') 
alter table t_fin_creditlimit add FDeferDay INT;
--增加额度关闭日期字段 by gss
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCreditCloseDate' 
and KSQL_COL_TABNAME='t_fin_creditlimit') 
alter table t_fin_creditlimit add FCreditCloseDate datetime;


--信用证手续费 新增 出纳字段 add by 张帅 
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCashierID' 
and KSQL_COL_TABNAME='t_fin_feemanage')
alter table t_fin_feemanage add FCashierID varchar(44);
-- 信用证手续费 新增 内部帐户字段 add by 张帅 
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FInnerAccountID' 
and KSQL_COL_TABNAME='t_fin_feemanage')
alter table t_fin_feemanage add FInnerAccountID VARCHAR(44);
-- 信用证手续费 新增 备注字段 add by 张帅 
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCdItemID' 
and KSQL_COL_TABNAME='t_fin_feemanage')
alter table t_fin_feemanage add FCdItemID VARCHAR(44);
--信用证还款单 新增 出纳字段 add by 张帅    
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCashierID' 
and KSQL_COL_TABNAME='t_fin_repayment')
alter table t_fin_repayment add FCashierID varchar(44);
--单据字段 长度修改
If exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='flettercontent' 
and KSQL_COL_TABNAME='t_fin_letterofcredit')
alter table t_fin_letterofcredit alter flettercontent NVARCHAR(2000);

--PT017059开始
--创建信用证的 延期返还授信额度分录表
If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FIN_DeferReturnCLEntry')
Create Table T_FIN_DeferReturnCLEntry ( FID VARCHAR(44) NOT NULL ,FSeq INT,FParentID VARCHAR(44) NOT NULL ,FRepaymentID VARCHAR(44) NOT NULL ,FIsReturnedCL INT DEFAULT 0 NOT NULL ,FActualCLReturnDate DateTime,FSupposeCLReturnDate DateTime,CONSTRAINT PK_DeferRTCLEntr PRIMARY KEY (FID));
--PT017059结束
