﻿If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_AssessPeriod')
Create Table T_PF_AssessPeriod ( 
                       FName_L1 NVarchar(255),
                       FName_L2 NVarchar(255),
                       FName_L3 NVarchar(255),
                       FNumber NVarchar(80),
                       FDescription_L1 NVarchar(255),
                       FDescription_L2 NVarchar(255),
                       FDescription_L3 NVarchar(255),
                       FSimpleName NVarchar(80),
                       FID Varchar(44) NOT NULL ,
                       FCreatorID Varchar(44),
                       FCreateTime DateTime,
                       FLastUpdateUserID Varchar(44),
                       FLastUpdateTime DateTime,
                       FControlUnitID Varchar(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4',
                       FStartDate DateTime,
                       FEndDate DateTime,
                       FRemark NVarchar(255),
                       FHROrgUnitID VARCHAR(44),
                       CONSTRAINT PK_PF_AssessPeriod PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_ConcurrenceArgs')
Create Table T_PF_ConcurrenceArgs ( 
                       FID Varchar(44) NOT NULL ,
                       FSeq Int,
                       FConcurrenceLevel Int,
                       FCount Int,
                       FEvalWorkFlowID Varchar(44),
                       CONSTRAINT PK_PF_ConcurArgs PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_EvaluDetail')
Create Table T_PF_EvaluDetail ( 
                       FID Varchar(44) NOT NULL ,
                       FSeq Int,
                       FTargetScore Decimal(28,16),
                       FTargetSummary NVarchar(80),
                       FNodeProcesserID Varchar(44),
                       FTargetEvaluStoreID Varchar(44),
                       FRankID Varchar(44),
                       FComment NCLOB(10000),
                       FWeight NUMERIC(28,10),
                       FCompValue NVARCHAR(80),
                       CONSTRAINT PK_PF_EvaluDetail PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_EvaluGroup')
Create Table T_PF_EvaluGroup ( 
                       FID Varchar(44) NOT NULL ,
                       FCreatorID Varchar(44),
                       FCreateTime DateTime,
                       FLastUpdateUserID Varchar(44),
                       FLastUpdateTime DateTime,
                       FControlUnitID Varchar(44),
                       FName_L1 NVarchar(255),
                       FName_L2 NVarchar(255),
                       FName_L3 NVarchar(255),
                       FNumber NVarchar(80),
                       FDescription_L1 NVarchar(255),
                       FDescription_L2 NVarchar(255),
                       FDescription_L3 NVarchar(255),
                       FSimpleName NVarchar(80),
                       FSolutionPeriodID Varchar(44),
                       CONSTRAINT PK_PF_EvaluGroup PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_EvaluGroupObject')
Create Table T_PF_EvaluGroupObject ( 
                       FID Varchar(44) NOT NULL ,
                       FCreatorID Varchar(44),
                       FCreateTime DateTime,
                       FLastUpdateUserID Varchar(44),
                       FLastUpdateTime DateTime,
                       FControlUnitID Varchar(44),
                       FName_L1 NVarchar(255),
                       FName_L2 NVarchar(255),
                       FName_L3 NVarchar(255),
                       FNumber NVarchar(80),
                       FDescription_L1 NVarchar(255),
                       FDescription_L2 NVarchar(255),
                       FDescription_L3 NVarchar(255),
                       FSimpleName NVarchar(80),
                       FEvaluGroupID Varchar(44),
                       FEvaluObjectID Varchar(44),
                       CONSTRAINT PK_PF_EvaluGroupO PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_EvaluGroupTarget')
Create Table T_PF_EvaluGroupTarget ( 
                       FID Varchar(44) NOT NULL ,
                       FCreatorID Varchar(44),
                       FCreateTime DateTime,
                       FLastUpdateUserID Varchar(44),
                       FLastUpdateTime DateTime,
                       FControlUnitID Varchar(44),
                       FName_L1 NVarchar(255),
                       FName_L2 NVarchar(255),
                       FName_L3 NVarchar(255),
                       FNumber NVarchar(80),
                       FDescription_L1 NVarchar(255),
                       FDescription_L2 NVarchar(255),
                       FDescription_L3 NVarchar(255),
                       FSimpleName NVarchar(80),
                       FWeight Decimal(28,16),
                       FEvaluGroupID Varchar(44),
                       FEvaluTargetID Varchar(44),
                       CONSTRAINT PK_PF_EvaluGroupT PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_EvaluGroupTargetType')
Create Table T_PF_EvaluGroupTargetType ( 
                       FID Varchar(44) NOT NULL ,
                       FCreatorID Varchar(44),
                       FCreateTime DateTime,
                       FLastUpdateUserID Varchar(44),
                       FLastUpdateTime DateTime,
                       FControlUnitID Varchar(44),
                       FName_L1 NVarchar(255),
                       FName_L2 NVarchar(255),
                       FName_L3 NVarchar(255),
                       FNumber NVarchar(80),
                       FDescription_L1 NVarchar(255),
                       FDescription_L2 NVarchar(255),
                       FDescription_L3 NVarchar(255),
                       FSimpleName NVarchar(80),
                       FWeight Decimal(28,16),
                       FPerformTargetTypeID Varchar(44),
                       FEvaluGroupID Varchar(44),
                       CONSTRAINT PK_PF_EvaluGTT PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_EvaluNode')
Create Table T_PF_EvaluNode ( 
                       FID Varchar(44) NOT NULL ,
                       FSeq Int,
                       FNodeName NVarchar(80),
                       FSeqNumber Int,
                       FWeight Decimal(28,16),
                       FCanComment Int,
                       FCanGrade Int,
                       FCanEvaluateLevel Int,
                       FNodeLevel Int,
                       FParticipatorType Int,
                       FParticipatorID Varchar(44),
                       FRelationType Int,
                       FSelectedOrgType Int,
                       FRefNode Int,
                       FEvalWorkFlowID Varchar(44),
                       FWeightVisable Int DEFAULT 1 NOT NULL,
                       CONSTRAINT PK_PF_EvaluNode PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_EvaluObject')
Create Table T_PF_EvaluObject ( 
                       FID Varchar(44) NOT NULL ,
                       FCreatorID Varchar(44),
                       FCreateTime DateTime,
                       FLastUpdateUserID Varchar(44),
                       FLastUpdateTime DateTime,
                       FControlUnitID Varchar(44),
                       FName_L1 NVarchar(255),
                       FName_L2 NVarchar(255),
                       FName_L3 NVarchar(255),
                       FNumber NVarchar(80),
                       FDescription_L1 NVarchar(1000),
                       FDescription_L2 NVarchar(1000),
                       FDescription_L3 NVarchar(1000),
                       FSimpleName NVarchar(255),
                       FEvaluObjectType Int,
                       FObjectID Varchar(44),
                       FResponserID Varchar(44),
                       FEvaluSolutionID Varchar(44),
                       FPositionID Varchar(44),
                       FDeleted INT default 0,
                       CONSTRAINT PK_PF_EvaluObject PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_EvaluResult')
Create Table T_PF_EvaluResult ( 
                       FID Varchar(44) NOT NULL ,
                       FCreatorID Varchar(44),
                       FCreateTime DateTime,
                       FLastUpdateUserID Varchar(44),
                       FLastUpdateTime DateTime,
                       FControlUnitID Varchar(44),
                       FTargetEvaluScore Decimal(28,16),
                       FModifiedScore Decimal(28,16),
                       FIsApproved Int,
                       FIsReferenced Int,
                       FModifyCause NVarchar(255),
                       FEvaluObjectID Varchar(44),
                       FSolutionPeriodID Varchar(44),
                       FAuditorID Varchar(44),
                       FAuditDate DateTime,
                       FModifierID Varchar(44),
                       FModifyDate DateTime,
                       FPerfRankID Varchar(44),
                       FCmpPeriodID Varchar(44),
                       FIsModified Int,
                       FRankConvertRuleID Varchar(44),
                       FHROrgUnitID Varchar(44),
                       FPositionID VARCHAR(44),
                       FAdminOrgUnitID VARCHAR(44),
                       FJobGradeID VARCHAR(44),
                       CONSTRAINT PK_EvaluResult PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_EvaluSolution')
Create Table T_PF_EvaluSolution ( 
                       FID Varchar(44) NOT NULL ,
                       FCreatorID Varchar(44),
                       FCreateTime DateTime,
                       FLastUpdateUserID Varchar(44),
                       FLastUpdateTime DateTime,
                       FControlUnitID Varchar(44),
                       FName_L1 NVarchar(255),
                       FName_L2 NVarchar(255),
                       FName_L3 NVarchar(255),
                       FNumber NVarchar(80),
                       FDescription_L1 NVarchar(255),
                       FDescription_L2 NVarchar(255),
                       FDescription_L3 NVarchar(255),
                       FSimpleName NVarchar(80),
                       FSolutionCategory Int,
                       FTargetGradeMode Int,
                       FTargetCreateMode Int,
                       FWeightCreateMode Int,
                       FDeliverMode Int,
                       FSolutionStatus Int,
                       FOrgUnitID Varchar(44),
                       FEffectDate DateTime,
                       FRankGroupID Varchar(44),
                       FGradeModeID Varchar(44),
                       FTargetRankGroupID Varchar(44),
                       FTargetGradeModeLinkID Varchar(44),
                       FSolutionType Int,
                       FCanViewEvaluForm Int DEFAULT 0,
                       FHROrgUnitID Varchar(44),
                       FCanComment INT DEFAULT 0 NOT NULL,
                       FAllocateTarget INT DEFAULT 0 NOT NULL,
                       FViewSelfForm INT DEFAULT 0 NOT NULL,
                       FViewOtherResult INT DEFAULT 0 NOT NULL,
                       FOutGradeMode INT DEFAULT 0 NOT NULL,
                       FIsControlWeight INT DEFAULT 0 NOT NULL,
                       CONSTRAINT PK_PF_ES PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_EvaluTarget')
Create Table T_PF_EvaluTarget ( 
                       FID Varchar(44) NOT NULL ,
                       FCreatorID Varchar(44),
                       FCreateTime DateTime,
                       FLastUpdateUserID Varchar(44),
                       FLastUpdateTime DateTime,
                       FControlUnitID Varchar(44),
                       FContent NVarchar(255),
                       FStandard NVarchar(255),
                       FTypeID Varchar(44),
                       FNumber NVarchar(80),
                       FTargetType Int,
                       FSolutionPeriodID Varchar(44),
                       FTargetID Varchar(44),
                       FValue NVARCHAR(80),
                       FContent2  NCLOB(10000),
                       FStandard2 NCLOB(10000),
                       CONSTRAINT PK_PF_EvaluTarget PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_EvalWFObjects')
Create Table T_PF_EvalWFObjects ( 
                       FID Varchar(44) NOT NULL ,
                       FSeq Int,
                       FStatus Int DEFAULT 10,
                       FEvaluObjectID Varchar(44),
                       FEvalWorkFlowID Varchar(44),
		               FProcInstID Varchar(44),
                       CONSTRAINT PK_PF_EWFO PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_EvalWorkFlow')
Create Table T_PF_EvalWorkFlow ( 
                       FID Varchar(44) NOT NULL ,
                       FSeq Int,
                       FName NVarchar(80),
                       FWfLevels Int,
                       FConcurrenceLevels Int,
                       FWorkFlowID Varchar(44),
                       FWorkFlowTmpID Varchar(44),
                       FSolutionPeriodID Varchar(44),
                       FNumber Varchar(255),
                       FFellowType Int,
                       CONSTRAINT PK_PF_EvalWorkFlow PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_GradeMode')
Create Table T_PF_GradeMode ( 
                       FID Varchar(44) NOT NULL ,
                       FCreatorID Varchar(44),
                       FCreateTime DateTime,
                       FLastUpdateUserID Varchar(44),
                       FLastUpdateTime DateTime,
                       FControlUnitID Varchar(44),
                       FName_L1 NVarchar(255),
                       FName_L2 NVarchar(255),
                       FName_L3 NVarchar(255),
                       FNumber NVarchar(80),
                       FDescription_L1 NVarchar(255),
                       FDescription_L2 NVarchar(255),
                       FDescription_L3 NVarchar(255),
                       FSimpleName NVarchar(80),
                       FMaxGrade Decimal(28,16),
                       FMinGrade Decimal(28,16),
                       FIsDefault Int,
                       FState Varchar(80),
                       FHROrgUnitID VARCHAR(44),
                       CONSTRAINT PK_GradeMode PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_MailPerson')
Create Table T_PF_MailPerson ( 
                       FID Varchar(44) NOT NULL ,
                       FPersonID Varchar(44),
                       FToPersonID Varchar(44),
                       CONSTRAINT PK_PF_MailP PRIMARY KEY (FID)
                       );

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_NodeProcesser')
Create Table T_PF_NodeProcesser ( 
                       FID Varchar(44) NOT NULL ,
                       FCreatorID Varchar(44),
                       FCreateTime DateTime,
                       FLastUpdateUserID Varchar(44),
                       FLastUpdateTime DateTime,
                       FControlUnitID Varchar(44),
                       FComment NVarchar(2000),
                       FProcesserName NVarchar(80),
                       FEvaluerID Varchar(44),
                       FEvaluResultID Varchar(44),
                       FEvaluNodeID Varchar(44),
                       FRankID Varchar(44),
                       FEvalRank Varchar(80),
                       FNodeScore NUMERIC(28,10),
                       CONSTRAINT PK_PF_NodeProce PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_OrgKeyEvent')
Create Table T_PF_OrgKeyEvent ( 
                       FID Varchar(44) NOT NULL ,
                       FCreatorID Varchar(44),
                       FCreateTime DateTime,
                       FLastUpdateUserID Varchar(44),
                       FLastUpdateTime DateTime,
                       FControlUnitID Varchar(44),
                       FAdminOrgUnitID Varchar(44),
                       FKeyEventType Int,
                       FFounderID Varchar(44),
                       FEventStartDate DateTime,
                       FEventEndDate DateTime,
                       FRecordDate DateTime,
                       FContent_L1 NVarchar(1000),
                       FContent_L2 NVarchar(1000),
                       FContent_L3 NVarchar(1000),
                       FHROrgUnitID Varchar(44),
                       CONSTRAINT PK_PF_OKeyEnt PRIMARY KEY (FID)
                       );

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_PerfItem')
Create Table T_PF_PerfItem ( 
                       FID Varchar(44) NOT NULL ,
                       FCreatorID Varchar(44),
                       FCreateTime DateTime,
                       FLastUpdateUserID Varchar(44),
                       FLastUpdateTime DateTime,
                       FControlUnitID Varchar(44),
                       FContent NVarchar(255),
                       FStandard NVarchar(255),
                       FIsReferenced Int,
                       FType Varchar(44),
                       FNumber NVarchar(80),
                       FValueable INT,
                       Fvalue NVARCHAR(80),
                       FContent2  NCLOB(10000),
                       FStandard2 NCLOB(10000),
                       CONSTRAINT PK_PerformTargetIt PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_PerformTargetType')
Create Table T_PF_PerformTargetType ( 
                       FID Varchar(44) NOT NULL ,
                       FCreatorID Varchar(44),
                       FCreateTime DateTime,
                       FLastUpdateUserID Varchar(44),
                       FLastUpdateTime DateTime,
                       FControlUnitID Varchar(44),
                       FName_L1 NVarchar(255),
                       FName_L2 NVarchar(255),
                       FName_L3 NVarchar(255),
                       FNumber NVarchar(80),
                       FDescription_L1 NVarchar(255),
                       FDescription_L2 NVarchar(255),
                       FDescription_L3 NVarchar(255),
                       FSimpleName NVarchar(80),
                       FIsLeaf Int,
                       FLevel Int,
                       FLongNumber NVarchar(80),
                       FParent Varchar(44),
                       FChildCount Int DEFAULT 0,
                       FDisplayName_L1 NVarchar(255),
                       FDisplayName_L2 NVarchar(255),
                       FDisplayName_L3 NVarchar(255),
                       FHROrgUnitID VARCHAR(44),
                       CONSTRAINT PK_PerformTargetTy PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_PerfSummary')
Create Table T_PF_PerfSummary ( 
                       FID Varchar(44) NOT NULL ,
                       FCreatorID Varchar(44),
                       FCreateTime DateTime,
                       FLastUpdateUserID Varchar(44),
                       FLastUpdateTime DateTime,
                       FControlUnitID Varchar(44),
                       FPersonID Varchar(44),
                       FAssessPeriodID Varchar(44),
                       FContent NVarchar(2000),
                       FContent2 NCLOB(20000),
                       CONSTRAINT PK_PerfSummary PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_PersonKeyEvent')
Create Table T_PF_PersonKeyEvent ( 
                       FID Varchar(44) NOT NULL ,
                       FCreatorID Varchar(44),
                       FCreateTime DateTime,
                       FLastUpdateUserID Varchar(44),
                       FLastUpdateTime DateTime,
                       FControlUnitID Varchar(44),
                       FPersonID Varchar(44),
                       FKeyEventType Int,
                       FFounderID Varchar(44),
                       FEventStartDate DateTime,
                       FEventEndDate DateTime,
                       FRecordDate DateTime,
                       FContent_L1 NVarchar(1000),
                       FContent_L2 NVarchar(1000),
                       FContent_L3 NVarchar(1000),
                       FHROrgUnitID Varchar(44),
                       CONSTRAINT PK_PF_PKeyEvent PRIMARY KEY (FID)
                       );

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_PlanFreqType')
Create Table T_PF_PlanFreqType ( 
                       FID Varchar(44) NOT NULL ,
                       FCreatorID Varchar(44),
                       FCreateTime DateTime,
                       FLastUpdateUserID Varchar(44),
                       FLastUpdateTime DateTime,
                       FControlUnitID Varchar(44),
                       FType Int,
                       FIsEnable Int,
                       FIsDefault Int,
                       FDays Int,
                       FHROrgUnitID Varchar(44),
                       CONSTRAINT PK_PF_PlanFTID PRIMARY KEY (FID)
                       );

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_PlanItemCate')
Create Table T_PF_PlanItemCate ( 
                       FID Varchar(44) NOT NULL ,
                       FCreatorID Varchar(44),
                       FCreateTime DateTime,
                       FLastUpdateUserID Varchar(44),
                       FLastUpdateTime DateTime,
                       FControlUnitID Varchar(44),
                       FName_L1 NVarchar(80),
                       FName_L2 NVarchar(80),
                       FName_L3 NVarchar(80),
                       FNumber NVarchar(80),
                       FDescription_L1 NVarchar(255),
                       FDescription_L2 NVarchar(255),
                       FDescription_L3 NVarchar(255),
                       FSimpleName NVarchar(80),
                       FHROrgUnitID Varchar(44));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_PlanWriter')
Create Table T_PF_PlanWriter ( 
                       FID Varchar(44) NOT NULL ,
                       FCreatorID Varchar(44),
                       FCreateTime DateTime,
                       FLastUpdateUserID Varchar(44),
                       FLastUpdateTime DateTime,
                       FControlUnitID Varchar(44),
                       FPersonID Varchar(44),
                       FWriterID Varchar(44),
                       FHROrgUnitID Varchar(44),
                       CONSTRAINT PK_PF_PlanWriter PRIMARY KEY (FID)
                       );

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_Rank')
Create Table T_PF_Rank ( 
                       FID Varchar(44) NOT NULL ,
                       FCreatorID Varchar(44),
                       FCreateTime DateTime,
                       FLastUpdateUserID Varchar(44),
                       FLastUpdateTime DateTime,
                       FControlUnitID Varchar(44),
                       FName_L1 NVarchar(255),
                       FName_L2 NVarchar(255),
                       FName_L3 NVarchar(255),
                       FNumber NVarchar(80),
                       FDescription_L1 NVarchar(255),
                       FDescription_L2 NVarchar(255),
                       FDescription_L3 NVarchar(255),
                       FSimpleName NVarchar(80),
                       FGrade Decimal(28,16),
                       FGroupID Varchar(44),
                       FSerial Int,
                       CONSTRAINT PK_Rank PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_RankConvertRule')
Create Table T_PF_RankConvertRule ( 
                       FID Varchar(44) NOT NULL ,
                       FCreatorID Varchar(44),
                       FCreateTime DateTime,
                       FLastUpdateUserID Varchar(44),
                       FLastUpdateTime DateTime,
                       FControlUnitID Varchar(44),
                       FName_L1 NVarchar(255),
                       FName_L2 NVarchar(255),
                       FName_L3 NVarchar(255),
                       FNumber NVarchar(80),
                       FDescription_L1 NVarchar(255),
                       FDescription_L2 NVarchar(255),
                       FDescription_L3 NVarchar(255),
                       FSimpleName NVarchar(80),
                       FRemark NVarchar(255),
                       FGradeModeID Varchar(44),
                       FRankGroupID Varchar(44),
                       FHROrgUnitID VARCHAR(44),
                       CONSTRAINT PK_PF_RankConRule PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_RankConvertRuleDetail')
Create Table T_PF_RankConvertRuleDetail ( 
                       FID Varchar(44) NOT NULL ,
                       FCreatorID Varchar(44),
                       FCreateTime DateTime,
                       FLastUpdateUserID Varchar(44),
                       FLastUpdateTime DateTime,
                       FControlUnitID Varchar(44),
                       FName_L1 NVarchar(255),
                       FName_L2 NVarchar(255),
                       FName_L3 NVarchar(255),
                       FNumber NVarchar(80),
                       FDescription_L1 NVarchar(255),
                       FDescription_L2 NVarchar(255),
                       FDescription_L3 NVarchar(255),
                       FSimpleName NVarchar(80),
                       FMinScore Decimal(28,16),
                       FMaxScore Decimal(28,16),
                       FRankID Varchar(44),
                       FRankConvertRuleID Varchar(44),
                       FMaxScoreCondition NVarchar(80),
                       FMinScoreCondition NVarchar(80),
                       CONSTRAINT PK_RankConvertRule PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_RankGroup')
Create Table T_PF_RankGroup ( 
                       FID Varchar(44) NOT NULL ,
                       FCreatorID Varchar(44),
                       FCreateTime DateTime,
                       FLastUpdateUserID Varchar(44),
                       FLastUpdateTime DateTime,
                       FControlUnitID Varchar(44),
                       FName_L1 NVarchar(255),
                       FName_L2 NVarchar(255),
                       FName_L3 NVarchar(255),
                       FNumber NVarchar(80),
                       FDescription_L1 NVarchar(255),
                       FDescription_L2 NVarchar(255),
                       FDescription_L3 NVarchar(255),
                       FSimpleName NVarchar(80),
                       FGradeMode Varchar(44),
                       FIsDefault Int,
                       FHROrgUnitID VARCHAR(44),
                       CONSTRAINT PK_RankGroup PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_ReferenceItem')
Create Table T_PF_ReferenceItem ( 
                       FID Varchar(44) NOT NULL ,
                       FCreatorID Varchar(44),
                       FCreateTime DateTime,
                       FLastUpdateUserID Varchar(44),
                       FLastUpdateTime DateTime,
                       FControlUnitID Varchar(44),
                       FHROrgUnitID varchar(44),
                       FRemark NVarchar(255),
                       FCmpItemID Varchar(44),
                       FRefType Int,
                       CONSTRAINT PK_ReferenceItem PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_SolutionPeriod')
Create Table T_PF_SolutionPeriod ( 
                       FID Varchar(44) NOT NULL ,
                       FCreatorID Varchar(44),
                       FCreateTime DateTime,
                       FLastUpdateUserID Varchar(44),
                       FLastUpdateTime DateTime,
                       FControlUnitID Varchar(44),
                       FName_L1 NVarchar(255),
                       FName_L2 NVarchar(255),
                       FName_L3 NVarchar(255),
                       FNumber NVarchar(80),
                       FDescription_L1 NVarchar(255),
                       FDescription_L2 NVarchar(255),
                       FDescription_L3 NVarchar(255),
                       FSimpleName NVarchar(80),
                       FEvaluStartDate DateTime,
                       FEvaluEndDate DateTime,
                       FFormTitle NVarchar(80),
                       FStatus Int,
                       FEvaluSolutionID Varchar(44),
                       FAssessPeriodID Varchar(44),
                       FHROrgUnitID Varchar(44),
                       CONSTRAINT PK_PF_SP PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_TargetDeliverer')
Create Table T_PF_TargetDeliverer ( 
                       FID Varchar(44) NOT NULL ,
                       FCreatorID Varchar(44),
                       FCreateTime DateTime,
                       FLastUpdateUserID Varchar(44),
                       FLastUpdateTime DateTime,
                       FControlUnitID Varchar(44),
                       FPersonID Varchar(44),
                       FEvaluObjectID Varchar(44),
                       CONSTRAINT PK_PF_TargetDeliv PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_TargetEvaluStore')
Create Table T_PF_TargetEvaluStore ( 
                       FID Varchar(44) NOT NULL ,
                       FCreatorID Varchar(44),
                       FCreateTime DateTime,
                       FLastUpdateUserID Varchar(44),
                       FLastUpdateTime DateTime,
                       FControlUnitID Varchar(44),
                       FName_L1 NVarchar(255),
                       FName_L2 NVarchar(255),
                       FName_L3 NVarchar(255),
                       FNumber NVarchar(80),
                       FDescription_L1 NVarchar(255),
                       FDescription_L2 NVarchar(255),
                       FDescription_L3 NVarchar(255),
                       FSimpleName NVarchar(80),
                       FWeight Decimal(28,16) DEFAULT 0,
                       FIsDelivered Int DEFAULT 0,
                       FEvaluObjectID Varchar(44),
                       FTargetDelivererID Varchar(44),
                       FEvaluTargetID Varchar(44),
                       FSolutionPeriodID Varchar(44),
                       FHROrgUnitID Varchar(44),
                       CONSTRAINT PK_PF_TargetEvaluS PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_WorkItem')
Create Table T_PF_WorkItem ( 
                       FID Varchar(44) NOT NULL ,
                       FCreatorID Varchar(44),
                       FCreateTime DateTime,
                       FLastUpdateUserID Varchar(44),
                       FLastUpdateTime DateTime,
                       FControlUnitID Varchar(44),
                       FPlanItemCategoryID Varchar(44),
                       FPlanItem NVarchar(255),
                       FNumber NVarchar(80),
                       FRequirement NVarchar(500),
                       FExecutorID Varchar(44),
                       FMonitor Varchar(44),
                       FAccomplishResult NVarchar(500),
                       FStatue Int,
                       FGuage Decimal(28,16),
                       FProblem NVarchar(500),
                       FAdvice NVarchar(500),
                       FPlanStartDate DateTime,
                       FEndDate DateTime,
                       FExeStartDate DateTime,
                       FExeEndDate DateTime,
                       FPlanTimeCost Decimal(28,16),
                       FExeTimeCost Decimal(28,16),
                       FSelfLastUpdateTime DateTime,
                       FSuperLastUpdateTime DateTime,
                       FFounber Varchar(44),
                       FWorkPlanID Varchar(44),
                       CONSTRAINT PK_PF_WorkItem PRIMARY KEY (FID)
                       );

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_WorkPlan')
Create Table T_PF_WorkPlan ( 
                       FID Varchar(44) NOT NULL ,
                       FCreatorID Varchar(44),
                       FCreateTime DateTime,
                       FLastUpdateUserID Varchar(44),
                       FLastUpdateTime DateTime,
                       FControlUnitID Varchar(44),
                       FPersonID Varchar(44),
                       FPlanFreqTypeID Varchar(44),
                       FStartDate DateTime,
                       FEndDate DateTime,
                       FDescription_L2 NVarchar(2000),
                       FAccomplishResult_L1 NVarchar(255),
                       FAccomplishResult_L2 NVarchar(255),
                       FAccomplishResult_L3 NVarchar(255),
                       FAdvice_L2 NVarchar(2000),
                       FHROrgUnitID Varchar(44),
                       FTarget NCLOB(20000),
                       FSelfResult_L2 NCLOB(20000),
                       CONSTRAINT PK_PF_WorkPlan PRIMARY KEY (FID)
                       );

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_AppointPerson')
Create Table T_PF_AppointPerson ( 
       FID VARCHAR(44) NOT NULL ,
       FPersonID VARCHAR(44),
       FPositioinID VARCHAR(44),
       FEvaluRelationID VARCHAR(44),
       CONSTRAINT PK_AppointPerson PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_EvalPerson')
Create Table T_PF_EvalPerson ( 
       FID VARCHAR(44) NOT NULL ,
       FPositionID VARCHAR(44),
       FScore NUMERIC(28,16),
       FModifyScore NUMERIC(28,16),
       FWorkflowID NVARCHAR(80),
       FProcInstID NVARCHAR(80),
       FIsOrigin INT,
       FPaperState INT,
       FPersonID VARCHAR(44),
       FEvalReDetailID VARCHAR(44),
       FWfStatus INT,
       FRankID VARCHAR(44),
       CONSTRAINT PK_PF_EvPerson PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_EvalReDetail')
Create Table T_PF_EvalReDetail ( 
       FID VARCHAR(44) NOT NULL ,
       FSelected INT,
       FAvrScore NUMERIC(28,16),
       FModifyScore NUMERIC(28,16),
       FName_L1 NVARCHAR(255),
       FName_L2 NVARCHAR(255),
       FName_L3 NVARCHAR(255),
       FEvalRelationID VARCHAR(44),
       FMDEvaluatorID VARCHAR(44),
       CONSTRAINT PK_EvalRelationDet PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_EvaluRelation')
Create Table T_PF_EvaluRelation ( 
       FID VARCHAR(44) NOT NULL ,
       FName_L1 NVARCHAR(255),
       FName_L2 NVARCHAR(255),
       FName_L3 NVARCHAR(255),
       FPersonRestrict INT,
       FWeight NUMERIC(28,16),
       FMDEvaluTypeEnum INT,
       FPaperID VARCHAR(44),
       FMdEvaluGroupID VARCHAR(44),
       FMinRestrict INT  default 0,
       CONSTRAINT PK_EvaluRelation PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_MDComDetail')
Create Table T_PF_MDComDetail ( 
       FID VARCHAR(44) NOT NULL ,
       FTestPaperFormID VARCHAR(44),
       FMDCommentID VARCHAR(44),
	   FEvaluation NVARCHAR(255),
       FEvaluation2 NVARCHAR(2000),
       CONSTRAINT PK_PF_MDComDetail PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_MDEVALURESULT')
Create Table T_PF_MDEVALURESULT ( 
       FID VARCHAR(44) NOT NULL ,
       FEvaluScore NUMERIC(28,16),
       FModifiedScore NUMERIC(28,16),
       FIsApproved INT DEFAULT 0,
       FIsModify INT DEFAULT 0,
       FModifyCause NVARCHAR(255),
       FModifyDate DateTime,
       FAuditDate DateTime,
       FMdObjectID VARCHAR(44),
       FSolutionPeriodID VARCHAR(44),
       FRankID VARCHAR(44),
       FRankConvertRuleID VARCHAR(44),
       FModifyerID VARCHAR(44),
       FAuditorID VARCHAR(44),
       FPositionID VARCHAR(44),
       FAdminOrgUnitID VARCHAR(44),
       FJobGradeID VARCHAR(44),
       FDisplayName_L1  NVARCHAR(500),
       FDisplayName_L2  NVARCHAR(500),
       FDisplayName_L3  NVARCHAR(500),
       CONSTRAINT PK_PF_MDEvaluResul PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_MDEvalDetail')
Create Table T_PF_MDEvalDetail ( 
       FID VARCHAR(44) NOT NULL ,
       FTestPaperFormID VARCHAR(44),
       FMDEvalID VARCHAR(44),
       FScore NUMERIC(28,16),
       CONSTRAINT PK_PF_MDEvDetail PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_MDEvaluGroup')
Create Table T_PF_MDEvaluGroup ( 
       FID VARCHAR(44) NOT NULL ,
       FCreatorID VARCHAR(44),
       FCreateTime DateTime,
       FLastUpdateUserID VARCHAR(44),
       FLastUpdateTime DateTime,
       FControlUnitID VARCHAR(44),
       FName_L1 NVARCHAR(255),
       FName_L2 NVARCHAR(255),
       FName_L3 NVARCHAR(255),
       FNumber NVARCHAR(80),
       FDescription_L1 NVARCHAR(255),
       FDescription_L2 NVARCHAR(255),
       FDescription_L3 NVARCHAR(255),
       FSimpleName NVARCHAR(80),
       FSolutionPeriodID VARCHAR(44),
       FFellowType INT,
       CONSTRAINT PK_PF_MDEvaluGroup PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_MDEvaluator')
Create Table T_PF_MDEvaluator ( 
       FID VARCHAR(44) NOT NULL ,
       FAuditState INT,
       FWfStatus INT,
       FMDObjectID VARCHAR(44),
       FSolutionPeriodID VARCHAR(44),
       CONSTRAINT PK_MultiDimEvaluat PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_MDGroupObject')
Create Table T_PF_MDGroupObject ( 
       FID VARCHAR(44) NOT NULL ,
       FMDObjectID VARCHAR(44),
       FMDEvaluGroupID VARCHAR(44),
       CONSTRAINT PK_PF_MDGroupObje PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_MDSolutionPeriod')
Create Table T_PF_MDSolutionPeriod ( 
       FName_L1 NVARCHAR(255),
       FName_L2 NVARCHAR(255),
       FName_L3 NVARCHAR(255),
       FNumber NVARCHAR(80),
       FDescription_L1 NVARCHAR(255),
       FDescription_L2 NVARCHAR(255),
       FDescription_L3 NVARCHAR(255),
       FSimpleName NVARCHAR(80),
       FID VARCHAR(44) NOT NULL ,
       FCreatorID VARCHAR(44),
       FCreateTime DateTime,
       FLastUpdateUserID VARCHAR(44),
       FLastUpdateTime DateTime,
       FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4',
       FMDSolutionID VARCHAR(44),
       FAssessPeriodID VARCHAR(44),
       FSPStatuEnum INT,
       FEvaluStartDate DateTime,
       FEvaluEndDate DateTime,
       	FTransactionState INT DEFAULT 0 NOT NULL ,
	FLastOperateTime DateTime,
       CONSTRAINT PK_PF_MultiDSPID PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_MultiDimComment')
Create Table T_PF_MultiDimComment ( 
       FID VARCHAR(44) NOT NULL ,
       FSerial INT,
       FComment NVARCHAR(255),
       FTestPaperID VARCHAR(44),
       CONSTRAINT PK_PF_MultiDimCom PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_MultiDimEval')
Create Table T_PF_MultiDimEval ( 
       FID VARCHAR(44) NOT NULL ,
       FSerial INT,
       FEvaluation NVARCHAR(255),
       FTestPaperID VARCHAR(44),
       FWeight NUMERIC(28,16),
       CONSTRAINT PK_MultiDimentionE PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_MultiDimentionObject')
Create Table T_PF_MultiDimentionObject ( 
       FName_L1 NVARCHAR(255),
       FName_L2 NVARCHAR(255),
       FName_L3 NVARCHAR(255),
       FNumber NVARCHAR(80),
       FDescription_L1 NVARCHAR(1000),
       FDescription_L2 NVARCHAR(1000),
       FDescription_L3 NVARCHAR(1000),
       FSimpleName NVARCHAR(80),
       FID VARCHAR(44) NOT NULL ,
       FCreatorID VARCHAR(44),
       FCreateTime DateTime,
       FLastUpdateUserID VARCHAR(44),
       FLastUpdateTime DateTime,
       FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4',
       FMDSolutionID VARCHAR(44),
       FPositionID VARCHAR(44),
       FPersonID VARCHAR(44),
       FDeleted int default 0,
       FEvaluObjectType int default 100,
       FEvaluOrgID VARCHAR(44),
       FResponserID VARCHAR(44),
       CONSTRAINT PK_PF_MultiDOID PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_MultiDimentionSolution')
Create Table T_PF_MultiDimentionSolution ( 
       FName_L1 NVARCHAR(255),
       FName_L2 NVARCHAR(255),
       FName_L3 NVARCHAR(255),
       FNumber NVARCHAR(80),
       FDescription_L1 NVARCHAR(255),
       FDescription_L2 NVARCHAR(255),
       FDescription_L3 NVARCHAR(255),
       FSimpleName NVARCHAR(80),
       FID VARCHAR(44) NOT NULL ,
       FCreatorID VARCHAR(44),
       FCreateTime DateTime,
       FLastUpdateUserID VARCHAR(44),
       FLastUpdateTime DateTime,
       FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4',
       FOrgUnitID VARCHAR(44),
       FCanViewEvalor INT,
       FHrOrgUnitID VARCHAR(44),
       FOperateDescript_L1 NVARCHAR(255),
       FOperateDescript_L2 NVARCHAR(255),
       FOperateDescript_L3 NVARCHAR(255),
       FCanViewSelfForm INT,
       FSolutionStatuEn INT,
       FMultiDimntModeE INT,
       FEvaluModeEnum INT,
       FGradeModeID VARCHAR(44),
       FRankGroupID VARCHAR(44),
       FHidePaperWeight INT,
       FSolutionType int default 100,
       CONSTRAINT PK_PF_MultiDSID PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_PaperQueDetail')
Create Table T_PF_PaperQueDetail ( 
       FID VARCHAR(44) NOT NULL ,
       FTestPageFormID VARCHAR(44),
       FPaperQueID VARCHAR(44),
       FScore NUMERIC(28,16),
       FRankID VARCHAR(44),
       CONSTRAINT PK_PF_PapQuDetail PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_PaperQuestions')
Create Table T_PF_PaperQuestions ( 
       FID VARCHAR(44) NOT NULL ,
       FTestPaperID VARCHAR(44),
       FTestQuestionID VARCHAR(44),
       FSerial INT,
       FWeight NUMERIC(28,16),
       FEvaluationID VARCHAR(44),
       CONSTRAINT PK_PF_PaperQue PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_PaperType')
Create Table T_PF_PaperType ( 
       FID VARCHAR(44) NOT NULL ,
       FCreatorID VARCHAR(44),
       FCreateTime DateTime,
       FLastUpdateUserID VARCHAR(44),
       FLastUpdateTime DateTime,
       FControlUnitID VARCHAR(44),
       FName_L1 NVARCHAR(255),
       FName_L2 NVARCHAR(255),
       FName_L3 NVARCHAR(255),
       FNumber NVARCHAR(80),
       FDescription_L1 NVARCHAR(255),
       FDescription_L2 NVARCHAR(255),
       FDescription_L3 NVARCHAR(255),
       FSimpleName NVARCHAR(80),
       FIsLeaf INT,
       FLevel INT,
       FLongNumber NVARCHAR(80),
       FDisplayName_L1 NVARCHAR(255),
       FDisplayName_L2 NVARCHAR(255),
       FDisplayName_L3 NVARCHAR(255),
       FParentID VARCHAR(44),
       FHROrgUnitID VARCHAR(44),
       FEnabled INT,
       CONSTRAINT PK_PaperStoreType PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_TestPageForm')
Create Table T_PF_TestPageForm ( 
       FID VARCHAR(44) NOT NULL ,
       FTestPaperID VARCHAR(44),
       FEvalPersonID VARCHAR(44),
       FRankID VARCHAR(44),
       FMDEvaluResultID VARCHAR(44),
       FScore NUMERIC(28,16),
       CONSTRAINT PK_PF_TePagForm PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_TestPaper')
Create Table T_PF_TestPaper ( 
       FCreatorID VARCHAR(44),
       FCreateTime DateTime,
       FLastUpdateUserID VARCHAR(44),
       FLastUpdateTime DateTime,
       FControlUnitID VARCHAR(44),
       FName_L1 NVARCHAR(255),
       FName_L2 NVARCHAR(255),
       FName_L3 NVARCHAR(255),
       FNumber NVARCHAR(80),
       FDescription_L1 NVARCHAR(255),
       FDescription_L2 NVARCHAR(255),
       FDescription_L3 NVARCHAR(255),
       FSimpleName NVARCHAR(80),
       FID VARCHAR(44) NOT NULL ,
       FOrgUnitID VARCHAR(44),
       FRemark NVARCHAR(255),
       FCount INT,
       FTypeID VARCHAR(44),
       FGradeModeID VARCHAR(44),
       FRankGroupID VARCHAR(44),
       FState INT,
       CONSTRAINT PK_TestPaper PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_TestQuestion')
Create Table T_PF_TestQuestion ( 
       FName_L1 NVARCHAR(255),
       FName_L2 NVARCHAR(255),
       FName_L3 NVARCHAR(255),
       FNumber NVARCHAR(80),
       FDescription_L1 NVARCHAR(255),
       FDescription_L2 NVARCHAR(255),
       FDescription_L3 NVARCHAR(255),
       FSimpleName NVARCHAR(80),
       FID VARCHAR(44) NOT NULL ,
       FCreatorID VARCHAR(44),
       FCreateTime DateTime,
       FLastUpdateUserID VARCHAR(44),
       FLastUpdateTime DateTime,
       FTreeID VARCHAR(44),
       FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4',
       FContent NVARCHAR(100),
       FStandard NVARCHAR(2000),
       FDisabled INT NOT NULL ,
       FOrgUnitID VARCHAR(44),
       CONSTRAINT PK_PF_TestQuestion PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_TestQuestionType')
Create Table T_PF_TestQuestionType ( 
       FName_L1 NVARCHAR(255),
       FName_L2 NVARCHAR(255),
       FName_L3 NVARCHAR(255),
       FNumber NVARCHAR(80),
       FDescription_L1 NVARCHAR(255),
       FDescription_L2 NVARCHAR(255),
       FDescription_L3 NVARCHAR(255),
       FSimpleName NVARCHAR(80),
       FIsLeaf INT,
       FLevel INT,
       FLongNumber NVARCHAR(80),
       FID VARCHAR(44) NOT NULL ,
       FCreatorID VARCHAR(44),
       FCreateTime DateTime,
       FLastUpdateUserID VARCHAR(44),
       FLastUpdateTime DateTime,
       FParentID VARCHAR(44),
       FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4',
       FIsEnabled INT,
       FHROrgUnitID VARCHAR(44),
       FDisplayName_L1 NVARCHAR(255),
       FDisplayName_L2 NVARCHAR(255),
       FDisplayName_L3 NVARCHAR(255),
       CONSTRAINT PK_PF_TestQTREEID PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_SynSolution')
Create Table T_PF_SynSolution ( 
	FID VARCHAR(44) NOT NULL ,
	FCreatorID VARCHAR(44),
	FCreateTime DateTime,
	FLastUpdateUserID VARCHAR(44),
	FLastUpdateTime DateTime,
	FControlUnitID VARCHAR(44),
	FName_L1 NVARCHAR(255),
	FName_L2 NVARCHAR(255),
	FName_L3 NVARCHAR(255),
	FNumber NVARCHAR(80),
	FDescription_L1 NVARCHAR(255),
	FDescription_L2 NVARCHAR(255),
	FDescription_L3 NVARCHAR(255),
	FSimpleName NVARCHAR(80),
	FCanViewTargetResult INT,
	FCanViewMultiResult INT,
	FCanViewEvalForm INT,
	FEvalRemark NVARCHAR(255),
	FSolutionRemark NVARCHAR(255),
	FGradeModeID VARCHAR(44),
	FRankGroupID VARCHAR(44),
	FHROrgUnitID VARCHAR(44),
	FOrgUnitID VARCHAR(44),
	FEvaluMode INT,
	FStatus INT,
	FInputMode INT,
	FCanViewMultiAuditResult INT,
	CONSTRAINT PK_PF_SynSolution PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_SynEvaluItem')
Create Table T_PF_SynEvaluItem ( 
	FID VARCHAR(44) NOT NULL ,
	FNumber NVARCHAR(80),
	FContent NVARCHAR(80),
	FSolutionID VARCHAR(44),
	CONSTRAINT PK_PF_SynEvaluItem PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_SynEvaluObject')
Create Table T_PF_SynEvaluObject (
	 FID VARCHAR(44) NOT NULL ,
	 FPersonID VARCHAR(44),
	 FPositionID VARCHAR(44),
	 FSolutionID VARCHAR(44),
	 FDescription_L1 NVARCHAR(255),
	 FDescription_L2 NVARCHAR(255),
	 FDescription_L3 NVARCHAR(255),
	 FDeleted INT default 0,
	 CONSTRAINT PK_SynEvaluObject PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_SynSolutionPeriod')
Create Table T_PF_SynSolutionPeriod (
 	FID VARCHAR(44) NOT NULL ,
 	FCreatorID VARCHAR(44),
 	FCreateTime DateTime,
 	FLastUpdateUserID VARCHAR(44),
 	FLastUpdateTime DateTime,
 	FControlUnitID VARCHAR(44),
 	FName_L1 NVARCHAR(255),
 	FName_L2 NVARCHAR(255),
 	FName_L3 NVARCHAR(255),
 	FNumber NVARCHAR(80),
 	FDescription_L1 NVARCHAR(255),
 	FDescription_L2 NVARCHAR(255),
 	FDescription_L3 NVARCHAR(255),
 	FSimpleName NVARCHAR(80),
 	FStartDate DateTime,
 	FEndDate DateTime,
 	FTitle NVARCHAR(80),
 	FStatus INT,
 	FAssessPeriodID VARCHAR(44),
 	FSolutionID VARCHAR(44),
 	CONSTRAINT PK_PF_SynSoluPid PRIMARY KEY (FID));
 
 If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_SynEvaluFlow')
 Create Table T_PF_SynEvaluFlow ( 
	FID VARCHAR(44) NOT NULL ,
	FName NVARCHAR(80),
	FWfLevels INT,
	FConcurrenceLevels INT,
	FWorkFlowID VARCHAR(44),
	FWorkFlowTmpID VARCHAR(44),
	FSolutionPeriodID VARCHAR(44),
	FNumber NVARCHAR(80),
	FFellowType INT,
	FSeq INT,
	CONSTRAINT PK_PF_SynEvlFlow PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_SynConcArgs')
Create Table T_PF_SynConcArgs (
	 FID VARCHAR(44) NOT NULL ,
	 FSeq INT,
	 FConcurrenceLevel INT,
	 FCount INT,
	 FEvalWorkFlowID VARCHAR(44),
	 CONSTRAINT PK_PF_SynCocAgs PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_SynFlowObject')
Create Table T_PF_SynFlowObject ( 
	FID VARCHAR(44) NOT NULL ,
	FSeq INT,
	FStatus INT,
	FEvaluObjectID VARCHAR(44),
	FEvalWorkFlowID VARCHAR(44),
	FProcInstID NVARCHAR(80),
	CONSTRAINT PK_PF_SynFlowObj PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_SynFlowNode')
Create Table T_PF_SynFlowNode (
 	FID VARCHAR(44) NOT NULL ,
 	FSeq INT,
 	FNodeName NVARCHAR(80),
 	FSeqNumber INT,
 	FWeight NUMERIC(28,10),
 	FCanComment INT,
 	FCanGrade INT,
 	FCanEvaluateLevel INT,
 	FNodeLevel INT,
 	FParticipatorType INT,
 	FParticipatorID VARCHAR(44),
 	FRelationType INT,
 	FSelectedOrgType INT,
 	FRefNode INT,
 	FEvalWorkFlowID VARCHAR(44),
 	FLevelName NVARCHAR(80),
 	CONSTRAINT PK_PF_SynFlowNode PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_SynNodeEvaluItem')
Create Table T_PF_SynNodeEvaluItem ( 
	FID VARCHAR(44) NOT NULL ,
	FNodeID VARCHAR(44),
	FEvaluItemID VARCHAR(44),
	FCanWrite INT,
	CONSTRAINT PK_PF_SynNdEvItem PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_SYNEVALURESULT')
Create Table T_PF_SYNEVALURESULT (
 	FID VARCHAR(44) NOT NULL ,
 	FEvaluScore NUMERIC(28,10),
 	FModifiedScore NUMERIC(28,10),
 	FIsApproved INT,
 	FIsModify INT,
 	FModifyCause NVARCHAR(80),
 	FModifyDate DateTime,
 	FAuditDate DateTime,
 	FSynObjectID VARCHAR(44),
 	FSolutionPeriodID VARCHAR(44),
 	FRankID VARCHAR(44),
 	FModifyerID VARCHAR(44),
 	FAuditorID VARCHAR(44),
 	FModfiedRankID VARCHAR(44),
 	FPositionID varchar(44),
 	FadminOrgUnitID varchar(44),
 	FJobGradeID varchar(44),
	FRemark NVARCHAR(500),
 	CONSTRAINT PK_PF_SynEvRelt PRIMARY KEY (FID));
 
If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_SynNodeProcesser')
Create Table T_PF_SynNodeProcesser ( 
	FID VARCHAR(44) NOT NULL ,
	FCreatorID VARCHAR(44),
	FCreateTime DateTime,
	FLastUpdateUserID VARCHAR(44),
	FLastUpdateTime DateTime,
	FControlUnitID VARCHAR(44),
	FEvaluerID VARCHAR(44),
	FEvaluResultID VARCHAR(44),
	FEvaluNodeID VARCHAR(44),
	FProcesserName NVARCHAR(80),
	FRankID VARCHAR(44),
	FScore NUMERIC(28,10),
	CONSTRAINT PK_PF_SynNdProc PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_SynCommDetail')
Create Table T_PF_SynCommDetail ( 
	FID VARCHAR(44) NOT NULL ,
	FComment NVARCHAR(255),
	FComment2 NVARCHAR(2000),
	FComment3 NCLOB(10000),
	FEvaluItemID VARCHAR(44),
	FNodeProcesserID VARCHAR(44),
	CONSTRAINT PK_PF_SynComDetl PRIMARY KEY (FID));
	
IF NOT EXISTS (SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME ='T_PF_TargetDeploy') 
Create Table T_PF_TargetDeploy (
    FID VARCHAR(44) NOT NULL ,
    FEvaluGroupID VARCHAR(44),
    FEvalWorkFlowID VARCHAR(44),
    CONSTRAINT PK_PF_TargetDeploy PRIMARY KEY (FID));
   
IF NOT EXISTS (SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME ='T_PF_TargetDeployEntry') 
Create Table T_PF_TargetDeployEntry (
    FID VARCHAR(44) NOT NULL ,
    FSeq INT,FParentID VARCHAR(44),
    FEvaluTargetID VARCHAR(44),
    FEvaluNodeID VARCHAR(44),
    FWeight NUMERIC(28,10),
    CONSTRAINT PK_PF_TarDepEnt PRIMARY KEY (FID));

IF NOT EXISTS (SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME ='T_PF_SumSolution') 
Create Table T_PF_SumSolution ( 
	FID VARCHAR(44) NOT NULL ,
	FCreatorID VARCHAR(44),
	FCreateTime DateTime,
	FLastUpdateUserID VARCHAR(44),
	FLastUpdateTime DateTime,
	FControlUnitID VARCHAR(44),
	FName_L1 NVARCHAR(255),
	FName_L2 NVARCHAR(255),
	FName_L3 NVARCHAR(255),
	FNumber NVARCHAR(80),
	FDescription_L1 NVARCHAR(255),
	FDescription_L2 NVARCHAR(255),
	FDescription_L3 NVARCHAR(255),
	FSimpleName NVARCHAR(80),
	FAssessPeriodID VARCHAR(44),
	FGradeModeID VARCHAR(44),
	FAdminOrgUnitID VARCHAR(44),
	FHROrgUnitID VARCHAR(44),
	FState INT,
	FSumExpID VARCHAR(44),
	FRankGroupID VARCHAR(44),
	CONSTRAINT PK_PF_SumSolution PRIMARY KEY (FID));

IF NOT EXISTS (SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME ='T_PF_SumExp')    
Create Table T_PF_SumExp ( 
	FID VARCHAR(44) NOT NULL ,
	FText NCLOB(10000),
	FSql NCLOB(10000),
	FScript NCLOB(10000),
	FRemark NCLOB(10000),
	CONSTRAINT PK_PF_SumExp PRIMARY KEY (FID));

IF NOT EXISTS (SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME ='T_PF_SumItem')
Create Table T_PF_SumItem (
	FID VARCHAR(44) NOT NULL ,
	FNumber NVARCHAR(80),
	FName NVARCHAR(500),
	FSumSolutionID VARCHAR(44),
	FType VARCHAR(80),
	FSumDetail NCLOB(9000),
	FCalculator NVARCHAR(255) NOT NULL ,
	FTitle_L1 NVARCHAR(80),
	FTitle_L2 NVARCHAR(80),
	FTitle_L3 NVARCHAR(80),
	CONSTRAINT PK_SumItem PRIMARY KEY (FID));

IF NOT EXISTS (SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME ='T_PF_SumPerson')
Create Table T_PF_SumPerson ( 
	FID VARCHAR(44) NOT NULL ,
	FSumSolutionID VARCHAR(44),
	FPersonID VARCHAR(44),
	FPositionID VARCHAR(44),
	FAdminOrgUnit_L1 NVARCHAR(500),
	FAdminOrgUnit_L2 NVARCHAR(500),
	FAdminOrgUnit_L3 NVARCHAR(500),
	CONSTRAINT PK_SumPerson PRIMARY KEY (FID));

IF NOT EXISTS (SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME ='T_PF_SumResult')
Create Table T_PF_SumResult ( 
	FID VARCHAR(44) NOT NULL ,
	FScore NUMERIC(28,10),
	FModifyScore NUMERIC(28,10),
	FRankID VARCHAR(44),
	FModifyDate DateTime,
	FModifierID VARCHAR(44),
	FAuditDate DateTime,
	FAuditorID VARCHAR(44),
	FAudited INT,
	FError NCLOB(10000),
	FDetail NCLOB(10000),
	FSumPersonID VARCHAR(44),
	FModified INT,
	FModifyCause NVARCHAR(255),
	FRankConvertRuleID VARCHAR(44),
	CONSTRAINT PK_PF_SumResult PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_NDRule')
Create Table T_PF_NDRule ( 
	FRankGroupID VARCHAR(44),
	FFetchType INT,
	FHrOrgUnitID VARCHAR(44),
	FName_l1 NVARCHAR(255),
	FName_l2 NVARCHAR(255),
	FName_l3 NVARCHAR(255),
	FNumber NVARCHAR(80),
	FDescription_l1 NVARCHAR(500),
	FDescription_l2 NVARCHAR(500),
	FDescription_l3 NVARCHAR(500),
	FSimpleName NVARCHAR(80),
	FCreatorID VARCHAR(44),
	FCreateTime DateTime,
	FLastUpdateUserID VARCHAR(44),
	FLastUpdateTime DateTime,
	FControlUnitID VARCHAR(44),
	FID VARCHAR(44) NOT NULL,
	CONSTRAINT PK_PF_NDRule PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_NDRuleItem')
Create Table T_PF_NDRuleItem ( 
	FParentID VARCHAR(44),
	FRankID VARCHAR(44),
	FWeight NUMERIC(28,10),
	FSeq INT,
	FID VARCHAR(44) NOT NULL,
	CONSTRAINT PK_PF_NDRuleItem PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PF_NDSolutionPeriod')
Create Table T_PF_NDSolutionPeriod ( 
	FParentID VARCHAR(44),
	FSolutionPeriodId VARCHAR(44),
	FSolutionNumber NVARCHAR(80),
	FSolutionName NVARCHAR(255),
	FAssessPeriodName NVARCHAR(255),
	FSeq INT,
	FID VARCHAR(44) NOT NULL,
	CONSTRAINT PK_PF_NDSolutionPe PRIMARY KEY (FID));
