If exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_HR_TRAINAPPLY') 
DROP view T_HR_TRAINAPPLY;

CREATE VIEW T_HR_TRAINAPPLY 
AS
SELECT 
INNERTRAINAPPLY.FID AS			FID, 
INNERTRAINAPPLY.FNumber AS		FNUMBER, 
INNERTRAINAPPLY.FName AS		FNAME, 
INNERTRAINAPPLY.FApplyDate AS	FAPPLYDATE, 
INNERTRAINAPPLY.FAuditState AS	FAUDITSTATE, 
PERSON.FName_L2 AS				FPERSONNAME, 
AUDITOR.FName_L2 AS				FAUDITORNAME, 
INNERTRAINAPPLY.FHrOrgUnitID AS	FHRORGUNITID, 
APPLIER.FName_L2 AS				FAPPLIERNAME, 
APPLIER.FID AS					FAPPLYERID, 
INNERTRAINAPPLY.FTrainSubmitType AS FTrainSubmitType,
TRAINPLAN.FNAME_L2 AS			FTrainPlan,
'3E2F3C4A' AS					FTYPE 
FROM T_HR_InnerTrainApply AS INNERTRAINAPPLY

LEFT OUTER JOIN T_PM_User AS AUDITOR
ON INNERTRAINAPPLY.FAuditorID = AUDITOR.FID

LEFT OUTER JOIN T_ORG_HRO AS HrOrgUnit
ON INNERTRAINAPPLY.FHrOrgUnitID = HrOrgUnit.FID

LEFT OUTER JOIN T_BD_Person AS PERSON
ON AUDITOR.FPersonId = PERSON.FID

LEFT OUTER JOIN T_BD_Person AS APPLIER
ON INNERTRAINAPPLY.FApplierID = APPLIER.FID

LEFT OUTER JOIN T_HR_TRAINPLAN AS TRAINPLAN
ON INNERTRAINAPPLY.FTrainPlan = TRAINPLAN.FID

UNION 

SELECT
OUTERTRAINAPPLY.FID AS			FID, 
OUTERTRAINAPPLY.FNumber AS		FNUMBER,
OUTERTRAINAPPLY.FName AS		FNAME, 
OUTERTRAINAPPLY.FApplyDate AS	FAPPLYDATE, 
OUTERTRAINAPPLY.FAuditState AS	FAUDITSTATE, 
PERSON.FName_L2 AS				FPERSONNAME, 
AUDITOR.FName_L2 AS				FAUDITORNAME,
OUTERTRAINAPPLY.FHrOrgUnitID AS	FHRORGUNITID, 
APPLIER.FName_L2 AS				FAPPLIERNAME, 
APPLIER.FID AS					FAPPLYERID, 
OUTERTRAINAPPLY.FTrainSubmitType AS FTrainSubmitType,
TRAINPLAN.FNAME_L2 AS			FTrainPlan,
'1D76642F' AS					FTYPE

FROM T_HR_OuterTrainApply AS OUTERTRAINAPPLY

LEFT OUTER JOIN T_PM_User AS AUDITOR
ON OUTERTRAINAPPLY.FAuditorID = AUDITOR.FID

LEFT OUTER JOIN T_ORG_HRO AS HrOrgUnit
ON OUTERTRAINAPPLY.FHrOrgUnitID = HrOrgUnit.FID

LEFT OUTER JOIN T_BD_Person AS PERSON
ON AUDITOR.FPersonId = PERSON.FID

LEFT OUTER JOIN T_BD_Person AS APPLIER
ON OUTERTRAINAPPLY.FApplierID = APPLIER.FID

LEFT OUTER JOIN T_HR_TRAINPLAN AS TRAINPLAN
ON OUTERTRAINAPPLY.FTrainPlan = TRAINPLAN.FID;
