CREATE OR REPLACE FUNCTION newbosid (typestring VARCHAR2)
   RETURN VARCHAR2
IS
   guid     varbinary (32);
   s_guid   VARCHAR2 (32);
   g_hex    VARCHAR (22);
   v_uuid   VARCHAR2 (44);
BEGIN
   guid := SYS_GUID ();
   s_guid := RAWTOHEX (guid);
   g_hex := '0123456789ABCDEFabcdef';

   IF LENGTH (typestring) = 8
   THEN
      FOR i IN 1 .. 8
      LOOP
         IF INSTR (g_hex, SUBSTR (typestring, i, 1), 1, 1) = 0
         THEN
            GOTO old_form;
         END IF;
      END LOOP;

      v_uuid :=
         UTL_RAW.cast_to_varchar2
               (UTL_ENCODE.base64_encode (UTL_RAW.CONCAT (guid,
                                                          HEXTORAW (typestring)
                                                         )
                                         )
               );
      --DBMS_OUTPUT.put_line (v_uuid);

    --  IF INSTR (v_uuid, '+') > 0 OR INSTR (v_uuid, '/') > 0
     -- THEN
       --  v_uuid := newbosid (typestring);
    --  ELSE
         RETURN v_uuid;
     -- END IF;
   ELSIF LENGTH (typestring) = 4
   THEN
      GOTO old_form;
   ELSE
      RETURN NULL;
   END IF;

   <<old_form>>
   RETURN    SUBSTR (s_guid, 0, 8)
          || '-'
          || SUBSTR (s_guid, 8, 4)
          || '-'
          || SUBSTR (s_guid, 12, 4)
          || '-'
          || SUBSTR (s_guid, 16, 4)
          || '-'
          || SUBSTR (s_guid, 20, 12)
          || typestring;
END;
@
create view user_indexesnew(index_name,table_name) as
select index_name,table_name from user_indexes
union 
select constraint_name,table_name from user_CONSTRAINTs;
@