--
If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_SD_PostRequisition')
Create Table T_SD_PostRequisition ( FID VARCHAR(44) NOT NULL ,FNumber NVARCHAR(80) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(200),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FAuditTime DateTime,FBaseStatus INT DEFAULT 1 NOT NULL ,FCarrier NVARCHAR(100),FSaleOrgUnitID VARCHAR(44),FStorageOrgUnitID VARCHAR(44),FBizTypeID VARCHAR(44),FBillTypeID VARCHAR(44),FSourceBillTypeID VARCHAR(44),FYear INT DEFAULT 2999 NOT NULL ,FPeriod INT DEFAULT 1 NOT NULL ,FModificationTime DateTime,FModifierID VARCHAR(44),FCurrencyID VARCHAR(44),FCompanyOrgUnitID VARCHAR(44),FIsReverse INT DEFAULT 0,FExchangeRate numeric(28,16),FConvertMode int,CONSTRAINT PK_SD_PostRID PRIMARY KEY NONCLUSTERED(FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_SD_PostRequisitionEntry')
Create Table T_SD_PostRequisitionEntry ( FID VARCHAR(44) NOT NULL ,FSeq INT,FMaterialID VARCHAR(44),FAssistPropertyID VARCHAR(44),FUnitID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceBillNumber NVARCHAR(80),FSourceBillEntryID NVARCHAR(80),FSourceBillEntrySeq INT,FAssCoefficient NUMERIC(28,10),FBaseStatus INT,FAssociateQty NUMERIC(28,16),FSourceBillTypeID VARCHAR(44),FBaseUnitID VARCHAR(44),FAssistUnitID VARCHAR(44),FRemark NVARCHAR(200),FReasonCodeID VARCHAR(44),FParentID VARCHAR(44),FDeliveryDate DateTime,FDeliveryAddress NVARCHAR(100),FTransLeadTime INT DEFAULT 0,FIsPresent INT DEFAULT 0,FCustPurNumber NVARCHAR(100),FQty NUMERIC(28,16) DEFAULT 0,FAssistQty NUMERIC(28,16) DEFAULT 0,FShippedQty NUMERIC(28,16) DEFAULT 0,FUnShippedQty NUMERIC(28,16) DEFAULT 0,FPrice NUMERIC(28,16) DEFAULT 0,FOrderCustomerID VARCHAR(44),FSalePersonID VARCHAR(44),FAmount NUMERIC(19,4) DEFAULT 0,FDeliveryTypeID VARCHAR(44),FSaleGroupID VARCHAR(44),FAdminOrgUnitID VARCHAR(44),FSendDate DateTime,FWarehouseID VARCHAR(44),FSaleOrderID VARCHAR(44),FSaleOrderEntryID VARCHAR(44),FSaleOrderNumber NVARCHAR(100),FSaleOrderEntrySeq INT DEFAULT 1,FBaseQty NUMERIC(28,16) DEFAULT 0,FShippedBaseQty NUMERIC(28,16) DEFAULT 0,FLocalAmount NUMERIC(19,4) DEFAULT 0,FReason NVARCHAR(80),FTotalReversedQty NUMERIC(28,10) DEFAULT 0,FTotalReversedBaseQty NUMERIC(28,10) DEFAULT 0,FStockTransferBillID varchar(44),FStockTransferBillEntryID varchar(44),FStockTransferBillNumber nvarchar(80),FStockTransferBillEntrySeq int,FLocationID varchar(44),FLot nvarchar(80),FPlanDeliveryQty NUMERIC(28,16) default 0,FDeliveryCustomerID varchar(44),FReceiveCustomerID varchar(44),FPaymentCustomerID varchar(44),CONSTRAINT PK_PostRequisition PRIMARY KEY NONCLUSTERED(FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_SD_Quotation')
Create Table T_SD_Quotation ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FNumber NVARCHAR(80),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FAuditTime DateTime,FBaseStatus INT,FBizTypeID VARCHAR(44),FSourceBillTypeID VARCHAR(44),FBillTypeID VARCHAR(44),FYear INT,FPeriod INT,FModifierID VARCHAR(44),FModificationTime DateTime,FOrderCustomerID VARCHAR(44),FSaleOrgUnitID VARCHAR(44),FSaleGroupID VARCHAR(44),FSalePersonID VARCHAR(44),FDeliveryTypeID VARCHAR(44),FCurrencyID VARCHAR(44),FExchangeRate NUMERIC(28,16),FCusPurNumber NVARCHAR(80),FEnabledDate DateTime,FDisibleDate DateTime,CONSTRAINT PK_Quotation PRIMARY KEY NONCLUSTERED(FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_SD_QuotationEntry')
Create Table T_SD_QuotationEntry ( FID VARCHAR(44) NOT NULL ,FSeq INT,FMaterialID VARCHAR(44),FAssistPropertyID VARCHAR(44),FUnitID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceBillNumber NVARCHAR(80),FSourceBillEntryID NVARCHAR(80),FSourceBillEntrySeq INT,FAssCoefficient NUMERIC(28,16),FBaseStatus INT,FAssociateQty NUMERIC(28,16),FSourceBillTypeID VARCHAR(44),FBaseUnitID VARCHAR(44),FAssistUnitID VARCHAR(44),FReasonCodeID VARCHAR(44),FRemark NVARCHAR(200),FParentID VARCHAR(44),FQtyFrom NUMERIC(28,16) DEFAULT 0,FQtyTo NUMERIC(28,16) DEFAULT 0,FBaseQtyFrom NUMERIC(28,16),FBaseQtyTo NUMERIC(28,16) DEFAULT 0,FPrice NUMERIC(28,16) DEFAULT 0,FTaxRate NUMERIC(28,16) DEFAULT 0,FTaxPrice NUMERIC(28,16) DEFAULT 0,FDiscountCondition INT,FDiscountType INT,FDiscount NUMERIC(28,16) DEFAULT 0,FActualTaxPrice NUMERIC(28,16) DEFAULT 0,FDeliveryDate INT,CONSTRAINT PK_QuotationEntry PRIMARY KEY NONCLUSTERED(FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_SD_SaleOrder')
Create Table T_SD_SaleOrder ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FModifierID VARCHAR(44),FModificationTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FNumber NVARCHAR(80) NOT NULL ,FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT DEFAULT 0 NOT NULL ,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FAuditTime DateTime,FBaseStatus INT DEFAULT 0 NOT NULL ,FBizTypeID VARCHAR(44),FSourceBillTypeID VARCHAR(44),FBillTypeID VARCHAR(44),FYear INT DEFAULT 2199 NOT NULL ,FPeriod INT DEFAULT 1 NOT NULL ,FIsInnerSale INT DEFAULT 0 NOT NULL ,FCustomerOrderNumber NVARCHAR(80),FOrderCustomerID VARCHAR(44),FDirectSupplierID VARCHAR(44),FPurchaseOrgUnitID VARCHAR(44),FDeliveryTypeID VARCHAR(44),FTransLeadTime INT DEFAULT 0 NOT NULL ,FCurrencyID VARCHAR(44),FExchangeRate NUMERIC(28,16) DEFAULT 0 NOT NULL ,FPaymentTypeID VARCHAR(44),FCashDiscountID VARCHAR(44),FSettlementTypeID VARCHAR(44),FPrepayment NUMERIC(19,4) DEFAULT 0 NOT NULL ,FPrepaymentRate NUMERIC(28,16) DEFAULT 0 NOT NULL ,FSaleOrgUnitID VARCHAR(44),FSaleGroupID VARCHAR(44),FSalePersonID VARCHAR(44),FAdminOrgUnitID VARCHAR(44),FTotalAmount NUMERIC(19,4) DEFAULT 0 NOT NULL ,FTotalTax NUMERIC(19,4) DEFAULT 0 NOT NULL ,FTotalTaxAmount NUMERIC(19,4) DEFAULT 0 NOT NULL ,FPreReceived NUMERIC(19,4) DEFAULT 0 NOT NULL ,FUnPrereceivedAmount NUMERIC(19,4) DEFAULT 0 NOT NULL ,FSendAddress NVARCHAR(255),FIsSysBill INT DEFAULT 0 NOT NULL ,FConvertMode INT DEFAULT 0 NOT NULL ,FLocalTotalAmount NUMERIC(19,4) DEFAULT 0 NOT NULL ,FLocalTotalTaxAmount NUMERIC(19,4) DEFAULT 0 NOT NULL ,FCompanyOrgUnitID VARCHAR(44),FIsInTax INT DEFAULT 0 NOT NULL,FCustomerPhone VARCHAR(255),FLinkMan VARCHAR(255),FALTERDATE datetime,FVERSION int,FOLDSTATUS int,FOLDID varchar(44),FALTERPERSON varchar(44),FIsCentralBalance int default 0 ,FStorageOrgUnitID varchar(44),FIsReverse INT DEFAULT 0,FBeenPaidPrepayment NUMERIC(19,4) DEFAULT 0,CONSTRAINT PK_SaleOrder_FID PRIMARY KEY NONCLUSTERED(FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_SD_SaleOrderEntry')
Create Table T_SD_SaleOrderEntry ( FID VARCHAR(44) NOT NULL ,FSeq INT,FMaterialID VARCHAR(44),FAssistPropertyID VARCHAR(44),FUnitID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceBillNumber NVARCHAR(80),FSourceBillEntryID NVARCHAR(80),FSourceBillEntrySeq INT,FAssCoefficient NUMERIC(28,16),FBaseStatus INT,FAssociateQty NUMERIC(28,16),FSourceBillTypeID VARCHAR(44),FBaseUnitID VARCHAR(44),FAssistUnitID VARCHAR(44),FRemark NVARCHAR(200),FReasonCodeID VARCHAR(44),FIsPresent INT DEFAULT 0,FBaseQty NUMERIC(28,16) DEFAULT 0,FQty NUMERIC(28,16) DEFAULT 0,FAssistQty NUMERIC(28,16) DEFAULT 0,FPrice NUMERIC(28,16) DEFAULT 0,FTaxPrice NUMERIC(28,16) DEFAULT 0,FDiscountCondition INT DEFAULT 0,FDiscountType INT DEFAULT 0,FDiscount NUMERIC(28,16) DEFAULT 0,FDiscountAmount NUMERIC(19,4) DEFAULT 0,FAmount NUMERIC(19,4) DEFAULT 0,FLocalAmount NUMERIC(19,4) DEFAULT 0,FActualPrice NUMERIC(28,16) DEFAULT 0,FActualTaxPrice NUMERIC(28,16) DEFAULT 0,FTaxRate NUMERIC(28,16) DEFAULT 0,FTax NUMERIC(19,4) DEFAULT 0,FTaxAmount NUMERIC(19,4) DEFAULT 0,FSendDate DateTime,FDeliveryDate DateTime,FStorageOrgUnitID VARCHAR(44),FCompanyOrgUnitID VARCHAR(44),FWarehouseID VARCHAR(44),FSendOverRate NUMERIC(28,16) DEFAULT 0,FSendOwingRate NUMERIC(28,16) DEFAULT 0,FSendAdvanceDay NUMERIC(28,16) DEFAULT 0,FSendDeferralDay NUMERIC(28,16) DEFAULT 0,FTotalIssueQty NUMERIC(28,16) DEFAULT 0,FTotalReturnedQty NUMERIC(28,16) DEFAULT 0,FTotalInvoicedQty NUMERIC(28,16) DEFAULT 0,FTotalShippingQty NUMERIC(28,16) DEFAULT 0,FTotalReceivedAmount NUMERIC(19,4) DEFAULT 0,FParentID VARCHAR(44),FTotalIssueBaseQty NUMERIC(28,16) DEFAULT 0,FTotalReBaseQty NUMERIC(28,16) DEFAULT 0,FTolInvoidBaseQty NUMERIC(28,16) DEFAULT 0,FTotalShipBaseQty NUMERIC(28,16) DEFAULT 0,FTotalUnReturnBaseQty NUMERIC(28,16) DEFAULT 0,FTotalUnIssueBaseQty NUMERIC(28,16) DEFAULT 0,FTotalUnShipBaseQty NUMERIC(28,16) DEFAULT 0,FTotalUnIssueQty NUMERIC(28,16) DEFAULT 0,FIsLocked INT DEFAULT 0,FLockQty NUMERIC(28,16) DEFAULT 0,FLockBaseQty NUMERIC(28,16) DEFAULT 0,FLocalTax NUMERIC(19,4) DEFAULT 0,FLocalTaxAmount NUMERIC(19,4) DEFAULT 0,FIsBySaleOrder INT DEFAULT 0,FOrderedQty NUMERIC(28,16) DEFAULT 0,FUnOrderedQty NUMERIC(28,16) DEFAULT 0,FPrepaymentRate NUMERIC(28,16) DEFAULT 0,FPrepayment NUMERIC(19,4) DEFAULT 0,FPreReceived NUMERIC(19,4) DEFAULT 0,FUnPrereceivedAmount NUMERIC(19,4) DEFAULT 0,FQuantityUnCtrl INT DEFAULT 1,FTimeUnCtrl INT DEFAULT 1,FDeliveryDateQty INT DEFAULT 0,FReason NVARCHAR(80),FTotalInvoicedAmt NUMERIC(19,4) DEFAULT 0  ,FTotalArAmount NUMERIC(19,4) DEFAULT 0 ,FVERSION int,FOLDSTATUS int,FOLDID varchar(44) ,FIsBetweenCompanySend int default 0,FTotalReversedQty NUMERIC(28,10) DEFAULT 0,FTotalReversedBaseQty NUMERIC(28,10) DEFAULT 0,FPlanDeliveryQty NUMERIC(28, 16) default 0,CONSTRAINT PK_SaleOrderEntry PRIMARY KEY NONCLUSTERED(FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_SD_SaleReturns')
Create Table T_SD_SaleReturns ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FNumber NVARCHAR(80) NOT NULL ,FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT DEFAULT 0,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FAuditTime DateTime,FBaseStatus INT DEFAULT 0,FBizTypeID VARCHAR(44),FSourceBillTypeID VARCHAR(44),FBillTypeID VARCHAR(44),FYear INT DEFAULT 2999,FPeriod INT DEFAULT 1,FOrderCustomerID VARCHAR(44),FReturnsCustomerID VARCHAR(44),FInvoiceCustomerID VARCHAR(44),FSaleOrgUnitID VARCHAR(44),FSaleSymbol VARCHAR(80) DEFAULT '10',FTotalAmount NUMERIC(19,4) DEFAULT 0,FTotalTax NUMERIC(19,4) DEFAULT 0,FTotalTaxAmount NUMERIC(19,4) DEFAULT 0,FReturnsReason INT DEFAULT 0,FCurrencyID VARCHAR(44),FExchangeRate NUMERIC(28,16) DEFAULT 0,FSaleGroupID VARCHAR(44),FSalePersonID VARCHAR(44),FModifierID VARCHAR(44),FModificationTime DateTime,FAdminOrgUnitID VARCHAR(44),FConvertMode INT DEFAULT 0 NOT NULL ,FCompanyOrgUnitID VARCHAR(44),FLocalTotalAmount NUMERIC(19,4) DEFAULT 0,FLocalTotalTax NUMERIC(19,4) DEFAULT 0,FLocalTotalTaxAmount NUMERIC(19,4) DEFAULT 0,FIsInTax INT DEFAULT 0 ,CONSTRAINT PK_SD_SaleReturnsI PRIMARY KEY NONCLUSTERED(FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_SD_SaleReturnsEntry')
Create Table T_SD_SaleReturnsEntry ( FID VARCHAR(44) NOT NULL ,FSeq INT,FMaterialID VARCHAR(44),FAssistPropertyID VARCHAR(44),FUnitID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceBillNumber NVARCHAR(80),FSourceBillEntryID NVARCHAR(80),FSourceBillEntrySeq INT,FAssCoefficient NUMERIC(28,16),FBaseStatus INT,FAssociateQty NUMERIC(28,16),FSourceBillTypeID VARCHAR(44),FBaseUnitID VARCHAR(44),FAssistUnitID VARCHAR(44),FRemark NVARCHAR(200),FReasonCodeID VARCHAR(44),FParentID VARCHAR(44),FIsPresent INT DEFAULT 0,FLot NVARCHAR(80),FQty NUMERIC(28,16) DEFAULT 0,FAssistQty NUMERIC(28,16) DEFAULT 0,FPrice NUMERIC(28,16) DEFAULT 0,FTaxPrice NUMERIC(28,16) DEFAULT 0,FAmount NUMERIC(19,4) DEFAULT 0,FTaxRate NUMERIC(28,16) DEFAULT 0,FTax NUMERIC(19,4) DEFAULT 0,FTaxAmount NUMERIC(19,4) DEFAULT 0,FReturnsDate DateTime,FReturnsQty NUMERIC(28,16) DEFAULT 0,FRemainingQty NUMERIC(28,16) DEFAULT 0,FInvoicedQty NUMERIC(28,16) DEFAULT 0,FInvoicePrice NUMERIC(28,16) DEFAULT 0,FWarehouseID VARCHAR(44),FStorageOrgUnitID VARCHAR(44),FCompanyOrgUnitID VARCHAR(44),FLocalAmount NUMERIC(19,4) DEFAULT 0,FBaseQty NUMERIC(28,16) DEFAULT 0,FReturnsBaseQty NUMERIC(28,16) DEFAULT 0,FRemainingBaseQty NUMERIC(28,16) DEFAULT 0,FInvoicedBaseQty NUMERIC(28,16) DEFAULT 0,FLocalTax NUMERIC(19,4) DEFAULT 0,FLocalTaxAmount NUMERIC(19,4) DEFAULT 0,FTotalReturnAmt NUMERIC(19,4) DEFAULT 0,FReason NVARCHAR(80),FTotalInvoicedAmt NUMERIC(19,4) DEFAULT 0 NOT NULL ,FProduceDate DateTime,FMaturityDate DateTime,CONSTRAINT PK_SaleReturnsEntr PRIMARY KEY NONCLUSTERED(FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_SD_TaxBaseData')
Create Table T_SD_TaxBaseData ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FNumber NVARCHAR(80),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyID VARCHAR(44),FName NVARCHAR(80),FRelationID VARCHAR(44),CONSTRAINT PK_SD_TaxBaseData PRIMARY KEY NONCLUSTERED(FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_SD_TaxBaseDataEntryA')
Create Table T_SD_TaxBaseDataEntryA ( FID VARCHAR(44) NOT NULL ,FSeq INT,FEasCustomer NVARCHAR(80),FTaxCustomer NVARCHAR(80),FParent VARCHAR(44),CONSTRAINT PK_SD_BEntryBaseA PRIMARY KEY NONCLUSTERED(FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_SD_TaxBaseDataEntryB')
Create Table T_SD_TaxBaseDataEntryB ( FID VARCHAR(44) NOT NULL ,FSeq INT,FEasMaterial NVARCHAR(80),FTaxMaterial NVARCHAR(80),FParent VARCHAR(44),CONSTRAINT PK_SD_BEntryBaseB PRIMARY KEY NONCLUSTERED(FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_SD_TaxBaseDataEntryC')
Create Table T_SD_TaxBaseDataEntryC ( FID VARCHAR(44) NOT NULL ,FSeq INT,FEasUnit NVARCHAR(80),FTaxUnit NVARCHAR(80),FParent VARCHAR(44) NOT NULL ,CONSTRAINT PK_SD_BEntryBaseC PRIMARY KEY NONCLUSTERED(FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_SD_TaxBaseDataEntryD')
Create Table T_SD_TaxBaseDataEntryD ( FID VARCHAR(44) NOT NULL ,FSeq INT,FEasHandler NVARCHAR(80),FTaxHandler NVARCHAR(80),FParent VARCHAR(44),CONSTRAINT PK_SD_BEntryBaseD PRIMARY KEY NONCLUSTERED(FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_SD_TaxRelation')
Create Table T_SD_TaxRelation ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FNumber NVARCHAR(80),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyID VARCHAR(44),FName NVARCHAR(80),FBillType VARCHAR(80),FFileType VARCHAR(80),FSeparatorType VARCHAR(80),FSeparator NVARCHAR(80),FFieldTag NVARCHAR(80),FNote NVARCHAR(80),FDetailNumber NVARCHAR(80),FRelationType VARCHAR(20),CONSTRAINT PK_SD_TaxRelation PRIMARY KEY NONCLUSTERED(FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_SD_TaxRelationEntry')
Create Table T_SD_TaxRelationEntry ( FID VARCHAR(44) NOT NULL ,FSeq INT,FEasFieldName NVARCHAR(80),FEasFieldID NVARCHAR(80),FEasFieldType VARCHAR(50),FEasFieldLength INT,FIsNotNull INT,FIsUseFormula INT,FForeignField NVARCHAR(80),FDefaultValue NVARCHAR(80),FParentID VARCHAR(44) NOT NULL ,FEasFieldTypeName NVARCHAR(50),FFormula VARCHAR(300),FDescription NVARCHAR(50),FFieldProperty VARCHAR(20),CONSTRAINT PK_SD_TaxRelEntry PRIMARY KEY NONCLUSTERED(FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_SD_TaxRelationEntryD')
Create Table T_SD_TaxRelationEntryD ( FID VARCHAR(44) NOT NULL ,FSeq INT,FEasFieldName NVARCHAR(80),FEasFieldID NVARCHAR(80),FEasFieldType VARCHAR(50),FEasFieldLength INT,FIsNotNull INT,FIsUseFormula INT,FForeignField NVARCHAR(80),FDefaultValue NVARCHAR(80),FParentID VARCHAR(44) NOT NULL ,FEasFieldTypeName NVARCHAR(50),FFormula VARCHAR(300),FDescription NVARCHAR(50),FFieldProperty VARCHAR(20),CONSTRAINT PK_SD_TaxRelEntryD PRIMARY KEY NONCLUSTERED(FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_SD_CreditBalance')
Create Table T_SD_CreditBalance ( FID VARCHAR(44) NOT NULL ,FCompanyID VARCHAR(44) NOT NULL ,FCustomerID VARCHAR(44) NOT NULL ,FArBalance NUMERIC(28,10) DEFAULT 0 NOT NULL ,FUnInvoicedOrderAmt NUMERIC(28,10) DEFAULT 0 NOT NULL ,FUnArBillInvoiceAmt NUMERIC(28,10) DEFAULT 0 NOT NULL ,FUnInvoicedReturnAmt NUMERIC(28,10) DEFAULT 0 NOT NULL ,FUnIssuedOrderAmt NUMERIC(28,10) DEFAULT 0 NOT NULL ,FUnArBillIssuedAmt NUMERIC(28,10) DEFAULT 0 NOT NULL ,FUnIssuedReturnAmt NUMERIC(28,10) DEFAULT 0 NOT NULL ,FUnArBillOrderAmt NUMERIC(28,10) DEFAULT 0 NOT NULL ,FUnAuditSOAmt numeric(17,4) not null DEFAULT 0 , FReserve1 numeric(19,4) not null DEFAULT 0,FReserve2 numeric(19,4) not null DEFAULT 0,FReserve3 numeric(19,4) not null DEFAULT 0,FReserve4 numeric(19,4) not null DEFAULT 0,FReserve5 numeric(19,4) not null DEFAULT 0,FUnAuditIssuedAmt numeric(19,4) not null DEFAULT 0,FUnAuditPostBillAmt numeric(19,4) not null DEFAULT 0,FUnOutPostBillAmt numeric(19,4) not null DEFAULT 0,CONSTRAINT PK_Credit_Balance PRIMARY KEY  NONCLUSTERED(FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_SD_CreditFile')
Create Table T_SD_CreditFile ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FName_L1 NVARCHAR(255),FName_L2 NVARCHAR(255),FName_L3 NVARCHAR(255),FNumber NVARCHAR(80),FDescription_L1 NVARCHAR(255),FDescription_L2 NVARCHAR(255),FDescription_L3 NVARCHAR(255),FSimpleName NVARCHAR(80),FCompanyOrgUnitID VARCHAR(44),FCustomerID VARCHAR(44),FCustomerGroupID VARCHAR(44),FGrade VARCHAR(44),FAmount NUMERIC(28,10) DEFAULT 0,FQty NUMERIC(28,10),FCreditTerm INT,FCreditFileType INT DEFAULT 1,FCurrencyID VARCHAR(44),FBizAnsCodeID VARCHAR(44),CONSTRAINT PK_SD_Credit PRIMARY KEY NONCLUSTERED(FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_SD_CreditFormula')
Create Table T_SD_CreditFormula ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FName_L1 NVARCHAR(255),FName_L2 NVARCHAR(255),FName_L3 NVARCHAR(255),FNumber NVARCHAR(80),FDescription_L1 NVARCHAR(255),FDescription_L2 NVARCHAR(255),FDescription_L3 NVARCHAR(255),FSimpleName NVARCHAR(80),FCompanyOrgUnitID VARCHAR(44),FScene INT,FFormulaAmount NVARCHAR(255),FFormulaTerm NVARCHAR(255),FFormulaQty NVARCHAR(255),CONSTRAINT PK_SD_CreditFormu PRIMARY KEY NONCLUSTERED(FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_SD_CreditGrade')
Create Table T_SD_CreditGrade ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FName_L1 NVARCHAR(255),FName_L2 NVARCHAR(255),FName_L3 NVARCHAR(255),FNumber NVARCHAR(80),FDescription_L1 NVARCHAR(255),FDescription_L2 NVARCHAR(255),FDescription_L3 NVARCHAR(255),FSimpleName NVARCHAR(80),CONSTRAINT PK_SD_CreditGrade PRIMARY KEY NONCLUSTERED(FID));


--变更描述:销售合同建库、销售退货增加字段
--变更日期:2006-12-31
If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_SCM_Contrace') 
Create Table T_SCM_Contrace ( FName_L1 NVARCHAR(2000),FName_L2 NVARCHAR(2000),FName_L3 NVARCHAR(2000),FNumber NVARCHAR(80),FDescription_L1 NVARCHAR(255),FDescription_L2 NVARCHAR(255),FDescription_L3 NVARCHAR(255),FSimpleName NVARCHAR(80),FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FTreeID VARCHAR(44),FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4',FFStart INT DEFAULT 1 NOT NULL ,FFSeq INT,CONSTRAINT PK_SCM_ContraceID PRIMARY KEY NONCLUSTERED(FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_SCM_ContraceTREE') 
Create Table T_SCM_ContraceTREE ( FName_L1 NVARCHAR(255),FName_L2 NVARCHAR(255),FName_L3 NVARCHAR(255),FNumber NVARCHAR(80),FDescription_L1 NVARCHAR(255),FDescription_L2 NVARCHAR(255),FDescription_L3 NVARCHAR(255),FSimpleName NVARCHAR(80),FIsLeaf INT,FLevel INT,FLongNumber NVARCHAR(80),FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FParentID VARCHAR(44),FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4',FDisplayName_L1 NVARCHAR(255),FDisplayName_L2 NVARCHAR(255),FDisplayName_L3 NVARCHAR(255),FStart INT DEFAULT 1 NOT NULL ,CONSTRAINT PK_SCM_ConTREE PRIMARY KEY NONCLUSTERED(FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_SD_SaleContract') 
Create Table T_SD_SaleContract ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FNumber NVARCHAR(80),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FAuditTime DateTime,FBaseStatus INT,FBizTypeID VARCHAR(44),FSourceBillTypeID VARCHAR(44),FBillTypeID VARCHAR(44),FYear INT,FPeriod INT,FModifierID VARCHAR(44),FModificationTime DateTime,FIsSysBill INT,FIsInTax INT,FExchangeRate NUMERIC(28,16),FConvertMode INT,FTotalAmount NUMERIC(19,4),FLOCALTOTALAMOUNT NUMERIC(19,4),FTotalTax NUMERIC(19,4),FLocalTotalTax NUMERIC(19,4),FLocalTotalTaxAmount NUMERIC(19,4),FTotalTaxAmount NUMERIC(19,4),FCurrencyID VARCHAR(44),FAdminOrgUnitID VARCHAR(44),FCompanyOrgUnitID VARCHAR(44),FSignAddress NVARCHAR(255),FCustomerID VARCHAR(44),FValidTo DateTime,FSaleOrgUnitID VARCHAR(44),FSaleGroupID VARCHAR(44),FSalePersonID VARCHAR(44),FDeliveryTypeID VARCHAR(44),FDeliveryAddress NVARCHAR(255),FPaymentTypeID VARCHAR(44),FCashDiscountID VARCHAR(44),FSettlementTypeID VARCHAR(44),FPrepayment NUMERIC(19,4),FTransLeadTime INT,FIsInnerSale INT,FContractTypeID VARCHAR(44),FALTERDATE datetime,FVERSION int,FOLDSTATUS int,FOLDID varchar(44),FALTERPERSON varchar(44),CONSTRAINT PK_SaleContract PRIMARY KEY NONCLUSTERED(FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_SD_SaleContractEntry') 
Create Table T_SD_SaleContractEntry ( FID VARCHAR(44) NOT NULL ,FSeq INT,FMaterialID VARCHAR(44),FAssistPropertyID VARCHAR(44),FUnitID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceBillNumber NVARCHAR(80),FSourceBillEntryID NVARCHAR(80),FSourceBillEntrySeq INT,FAssCoefficient NUMERIC(28,16),FBaseStatus INT,FAssociateQty NUMERIC(28,16),FSourceBillTypeID VARCHAR(44),FBaseUnitID VARCHAR(44),FAssistUnitID VARCHAR(44),FRemark NVARCHAR(200),FReasonCodeID VARCHAR(44),FIsPresent INT,FQty NUMERIC(28,16),FBaseQty NUMERIC(28,16),FAssistQty NUMERIC(28,16),FPrice NUMERIC(28,16),FAmount NUMERIC(19,4),FLocalAmount NUMERIC(19,4),FTaxRate NUMERIC(19,4),FTaxPrice NUMERIC(28,16),FTax NUMERIC(19,4),FLocalTax NUMERIC(19,4),FTaxAmount NUMERIC(19,4),FLocalTaxAmount NUMERIC(19,4),FDiscountCondition INT,FDiscountType INT,FDiscount NUMERIC(28,16),FActualPrice NUMERIC(28,16),FActualTaxPrice NUMERIC(28,16),FDiscountAmount NUMERIC(19,4),FCloseDate DateTime,FParentID VARCHAR(44),FMaterialGroupID VARCHAR(44),FPrepaymentRate NUMERIC(19,4),FPrepayment NUMERIC(19,4),FPreReceived NUMERIC(19,4),FUnPreReceivedAmount NUMERIC(19,4),FSendDate DateTime,FDeliveryDate DateTime,FStorageOrgUnitID VARCHAR(44),FWarehouseID VARCHAR(44),FSendOverRate NUMERIC(19,4),FSendOwingRate NUMERIC(19,4),FSendAdvanceDay INT,FSendDeferralDay INT,FQuantityUnCtrl INT,FTimeUnCtrl INT,FAmountUnCtrl INT,FTotalOrderedQty NUMERIC(28,16),FTotalOrderedAmt NUMERIC(19,4),FTotalReceivedAmt NUMERIC(19,4),FReason NVARCHAR(255),FQIStandardID VARCHAR(44), FVERSION int,FOLDSTATUS int,FOLDID varchar(44),CONSTRAINT PK_SaleContractEnt PRIMARY KEY NONCLUSTERED(FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_SD_SaleContractQCItem') 
Create Table T_SD_SaleContractQCItem ( FID VARCHAR(44) NOT NULL ,FSeq INT,FComparator1 VARCHAR(80),FLowRange NUMERIC(28,16),FComparator2 VARCHAR(80),FUpRange NUMERIC(28,16),FIsRequiredCheck INT,FQCStandard VARCHAR(44),FQCItem VARCHAR(44),FParent1ID VARCHAR(44),FVERSION int,FOLDID varchar(44),CONSTRAINT PK_SaleContractQCI PRIMARY KEY NONCLUSTERED(FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_SD_SaleContractTerm') 
Create Table T_SD_SaleContractTerm ( FID VARCHAR(44) NOT NULL ,FSeq INT,FRemark NVARCHAR(80),FParentID VARCHAR(44),FTermContent NVARCHAR(2000),FVERSION int,FOLDID varchar(44),CONSTRAINT PK_SaleContractTer PRIMARY KEY NONCLUSTERED(FID));

--增加销售价格历史查询属性表 卢旭峰
If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_SD_SalepriceRecProperty') 
Create Table T_SD_SalepriceRecProperty(FUserNumber Varchar(44) NOT NULL,FOrderResource Varchar(44) NOT NULL,FDateRange Varchar(44) NOT NULL,FCreateTime DateTime,FLastUpdateTime DateTime);

--销售内部价格交易表
If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_SD_SaleInnerDealPrice') 
Create Table T_SD_SaleInnerDealPrice ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FSaleOrderID VARCHAR(44),FSaleOrderEntryID VARCHAR(44),FPrice NUMERIC(28,10),FDiscountMode INT,FDiscount NUMERIC(28,10),FActuralPrice NUMERIC(28,10),FTaxRate NUMERIC(28,10),FTaxPrice NUMERIC(28,10),FActualTaxPrice NUMERIC(28,10),CONSTRAINT PK_SaleInnerDealPr PRIMARY KEY NONCLUSTERED(FID));


--未审核的发货通知单金额
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'FUnAuditPostBillAmt' AND KSQL_COL_TABNAME = 'T_SD_CreditBalance')
ALTER TABLE T_SD_CreditBalance ADD FUnAuditPostBillAmt numeric(19,4) not null DEFAULT 0 ;

--已审核未生成出库的发货通知单金额
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'FUnOutPostBillAmt' AND KSQL_COL_TABNAME = 'T_SD_CreditBalance')
ALTER TABLE T_SD_CreditBalance ADD FUnOutPostBillAmt numeric(19,4) not null DEFAULT 0 ;


--变更描述：销售退货申请单增加字段
--变更人：刘方超
--变更日期：2008-03-31
if not exists(select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCoreBillTypeID' and KSQL_COL_TABNAME   ='T_SD_salereturnsentry')
alter table T_SD_salereturnsentry add FCoreBillTypeID VARCHAR(44);

if not exists(select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCoreBillId' and KSQL_COL_TABNAME   ='T_SD_salereturnsentry')
alter table T_SD_salereturnsentry add FCoreBillId NVARCHAR(80);

if not exists(select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCoreBillNumber' and KSQL_COL_TABNAME   ='T_SD_salereturnsentry')
alter table T_SD_salereturnsentry add FCoreBillNumber NVARCHAR(80);

if not exists(select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCoreBillEntryId' and KSQL_COL_TABNAME   ='T_SD_salereturnsentry')
alter table T_SD_salereturnsentry add FCoreBillEntryId NVARCHAR(80);

if not exists(select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCoreBillEntrySeq' and KSQL_COL_TABNAME   ='T_SD_salereturnsentry')
alter table T_SD_salereturnsentry add FCoreBillEntrySeq INT;

if not exists(select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FReceiveDispatcherType' and KSQL_COL_TABNAME   ='T_SD_salereturnsentry')
alter table T_SD_salereturnsentry add FReceiveDispatcherType INT;

--变更描述：销售订单增加累计退库数量
--变更人：王可文
--变更日期：2008-03-31
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'FTotalCancellingStockQty' AND KSQL_COL_TABNAME = 'T_SD_SaleOrderEntry')
ALTER TABLE T_SD_SaleOrderEntry ADD FTotalCancellingStockQty numeric(19,4) not null DEFAULT 0 ; 

--变更描述：销售订单增加累计退库需补货数量
--变更人：王可文
--变更日期：2008-03-31
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'FTotalSupplyStockQty' AND KSQL_COL_TABNAME = 'T_SD_SaleOrderEntry')
ALTER TABLE T_SD_SaleOrderEntry ADD FTotalSupplyStockQty numeric(19,4) not null DEFAULT 0 ; 

--变更描述：增加返利单建库脚本
--变更人：dongpeng
--变更日期：2008-04-04
If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_SD_SaleBackProfitBill')
Create Table T_SD_SaleBackProfitBill ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FNumber NVARCHAR(80),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FAuditTime DateTime,FBaseStatus INT,FBizTypeID VARCHAR(44),FSourceBillTypeID VARCHAR(44),FBillTypeID VARCHAR(44),FYear INT DEFAULT 1,FPeriod INT DEFAULT 9999,FModifierID VARCHAR(44),FModificationTime DateTime,FCompanyOrgUnitID VARCHAR(44),FCurrencyID VARCHAR(44),FExchangeRate NUMERIC(28,10) DEFAULT 0,FProfitFromDate DateTime,FProfitToDate DateTime,FRemark NVARCHAR(80),FSourceType INT DEFAULT 0,FSaleBackProfitType INT DEFAULT 0,FAccountID VARCHAR(44),FAccountName NVARCHAR(255),FAccountNumber NVARCHAR(80),FBizOrgUnitID VARCHAR(44),FBizOrgUnitName NVARCHAR(255),FBizOrgUnitNumber NVARCHAR(80),CONSTRAINT PK_SD_SaleBProtID PRIMARY KEY NONCLUSTERED(FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_SD_SaleBackProfitBillEntry')
Create Table T_SD_SaleBackProfitBillEntry ( FID VARCHAR(44) NOT NULL ,FSeq INT,FMaterialID VARCHAR(44),FAssistPropertyID VARCHAR(44),FUnitID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceBillNumber NVARCHAR(80),FSourceBillEntryID NVARCHAR(80),FSourceBillEntrySeq INT,FAssCoefficient NUMERIC(28,10) DEFAULT 0,FBaseStatus INT,FAssociateQty NUMERIC(28,16) DEFAULT 0,FSourceBillTypeID VARCHAR(44),FBaseUnitID VARCHAR(44),FAssistUnitID VARCHAR(44),FRemark NVARCHAR(80),FReasonCodeID VARCHAR(44),FMaterialGroupID VARCHAR(44),FQty NUMERIC(28,16) DEFAULT 0,FBaseQty NUMERIC(28,16) DEFAULT 0,FBaseAmount NUMERIC(19,4) DEFAULT 0,FAmount NUMERIC(19,4) DEFAULT 0,FLocalAmount NUMERIC(19,4) DEFAULT 0,FTotalArApAmount NUMERIC(19,4) DEFAULT 0,FTotalLocalArApAmount NUMERIC(19,4) DEFAULT 0,FParentID VARCHAR(44) NOT NULL ,FBaseProfitQty numeric(28,16) DEFAULT 0,FProfitAmount numeric(19,4) DEFAULT 0 ,FReason nvarchar(80),CONSTRAINT PK_SD_SaleBProEID PRIMARY KEY NONCLUSTERED(FID));

--变更描述：销售订单分录增加送货客户字段 
--变更人：王可文
--变更日期：2008-05-23
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'FDeliveryCustomerID' AND KSQL_COL_TABNAME = 'T_SD_SaleOrderEntry')
ALTER TABLE T_SD_SaleOrderEntry ADD FDeliveryCustomerID VARCHAR(44);

--变更描述：销售订单分录增加收款客户字段
--变更人：王可文
--变更日期：2008-05-23
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'FPaymentCustomerID' AND KSQL_COL_TABNAME = 'T_SD_SaleOrderEntry')
ALTER TABLE T_SD_SaleOrderEntry ADD FPaymentCustomerID VARCHAR(44);


--变更描述：销售订单分录增加应收客户字段
--变更人：王可文
--变更日期：2008-05-23
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'FReceiveCustomerID' AND KSQL_COL_TABNAME = 'T_SD_SaleOrderEntry')
ALTER TABLE T_SD_SaleOrderEntry ADD FReceiveCustomerID VARCHAR(44);

--变更描述：销售订单分录增加送货地址字段
--变更人：王可文
--变更日期：2008-05-23
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'FSendAddress' AND KSQL_COL_TABNAME = 'T_SD_SaleOrderEntry')
ALTER TABLE T_SD_SaleOrderEntry ADD FSendAddress NVARCHAR(255);


--变更描述：销售订单增加收款条件
--变更人：王可文
--变更时间：2008-05-27
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'FReceiveConditionID' AND KSQL_COL_TABNAME = 'T_SD_SaleOrder')
ALTER TABLE T_SD_SaleOrder ADD FReceiveConditionID VARCHAR(44);

--变更描述：增加渠道库存更新表
--变更人：董鹏
--变更时间：2008-05-30
If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_SD_ChannelInventory')
Create Table T_SD_ChannelInventory (FID VARCHAR(44) NOT NULL , FSaleOrgUnitID VARCHAR(44),FSaleChannelID VARCHAR(44),FMaterialID VARCHAR(44),FAssistPropertyID VARCHAR(44),FLot NVARCHAR(80),FUnitID VARCHAR(44),FQty NUMERIC(28,16) DEFAULT 0,FAssistUnitID VARCHAR(44),FAssistQty NUMERIC(28,16) DEFAULT 0,FBaseUnitID VARCHAR(44),FBaseQty NUMERIC(28,16) DEFAULT 0,FStorageDate DateTime,CONSTRAINT PK_ChannelInvID PRIMARY KEY NONCLUSTERED (FID));

--变更描述：销售/分销管理 新添加渠道结存单/渠道入库单/渠道进销存单/渠道销量单
--变 更 人：李波
--变更日期：2008-6-20

IF NOT EXISTS   (SELECT * FROM KSQL_USERTABLES where KSQL_TABNAME ='T_CHA_ChannelStockBill')
Create Table T_CHA_ChannelStockBill ( FID VARCHAR(44) NOT NULL ,FSaleOrgUnitID VARCHAR(44),FSalePersonID VARCHAR(44),FChannelType INT,FChannelID VARCHAR(44),FCurrencyID VARCHAR(44),FExchangeRate NUMERIC(21,8),FRemark NVARCHAR(200),FAuditTime DateTime,FBaseStatus INT,FBizTypeID VARCHAR(44),FSourceBillTypeID VARCHAR(44),FBillTypeID VARCHAR(44),FYear INT,FPeriod INT,FModifierID VARCHAR(44),FModificationTime DateTime,FNumber NVARCHAR(80),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),CONSTRAINT PK_ChaSBFID PRIMARY KEY NONCLUSTERED (FID));

IF NOT EXISTS   (SELECT * FROM KSQL_USERTABLES where KSQL_TABNAME ='T_CHA_ChannelStockBillEntry')
Create Table T_CHA_ChannelStockBillEntry ( FID VARCHAR(44) NOT NULL ,FParentID VARCHAR(44),FBatchNo NVARCHAR(44),FQty NUMERIC(21,8),FPrice NUMERIC(17,4),FAmount NUMERIC(17,4),FLocalAmount NUMERIC(17,4),FBaseQty NUMERIC(21,8),FAssistQty NUMERIC(21,8),FMaterialID VARCHAR(44),FAssistPropertyID VARCHAR(44),FUnitID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceBillNumber NVARCHAR(80),FSourceBillEntryID NVARCHAR(80),FSourceBillEntrySeq INT,FAssCoefficient NUMERIC(21,8),FBaseStatus INT,FAssociateQty NUMERIC(21,8),FSourceBillTypeID VARCHAR(44),FBaseUnitID VARCHAR(44),FAssistUnitID VARCHAR(44),FRemark NVARCHAR(200),FReasonCodeID VARCHAR(44),FSeq INT,CONSTRAINT PK_ChaSBEFID PRIMARY KEY NONCLUSTERED (FID));

IF NOT EXISTS   (SELECT * FROM KSQL_USERTABLES where KSQL_TABNAME ='T_CHA_ChannelInWarehsBill')
Create Table T_CHA_ChannelInWarehsBill ( FID VARCHAR(44) NOT NULL ,FInWarehsType INT,FSaleOrgUnitID VARCHAR(44),FSalePersonID VARCHAR(44),FChannelID VARCHAR(44),FCurrencyID VARCHAR(44),FExchangeRate NUMERIC(21,8),FRemark NVARCHAR(200),FAuditTime DateTime,FBaseStatus INT,FBizTypeID VARCHAR(44),FSourceBillTypeID VARCHAR(44),FBillTypeID VARCHAR(44),FYear INT,FPeriod INT,FModifierID VARCHAR(44),FModificationTime DateTime,FNumber NVARCHAR(80),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),CONSTRAINT PK_ChaInWFID PRIMARY KEY NONCLUSTERED (FID));

IF NOT EXISTS   (SELECT * FROM KSQL_USERTABLES where KSQL_TABNAME ='T_CHA_ChannelInWarehsBillEntry')
Create Table T_CHA_ChannelInWarehsBillEntry ( FID VARCHAR(44) NOT NULL ,FParentID VARCHAR(44),FBatchNo NVARCHAR(80),FQty NUMERIC(21,8),FBaseQty NUMERIC(21,8),FAssistQty NUMERIC(21,8),FPrice NUMERIC(17,4),FAmount NUMERIC(17,4),FLocalAmount NUMERIC(17,4),FMaterialID VARCHAR(44),FAssistPropertyID VARCHAR(44),FUnitID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceBillNumber NVARCHAR(80),FSourceBillEntryID NVARCHAR(80),FSourceBillEntrySeq INT,FAssCoefficient NUMERIC(21,8),FBaseStatus INT,FAssociateQty NUMERIC(21,8),FSourceBillTypeID VARCHAR(44),FBaseUnitID VARCHAR(44),FAssistUnitID VARCHAR(44),FRemark NVARCHAR(200),FReasonCodeID VARCHAR(44),FSeq INT,CONSTRAINT PK_ChalInWEFID PRIMARY KEY NONCLUSTERED (FID));

IF NOT EXISTS   (SELECT * FROM KSQL_USERTABLES where KSQL_TABNAME ='T_CHA_ChannelJXCBill')
Create Table T_CHA_ChannelJXCBill ( FID VARCHAR(44) NOT NULL ,FSaleOrgUnitID VARCHAR(44),FSalePersonID VARCHAR(44),FChannelType INT,FChannelID VARCHAR(44),FCurrencyID VARCHAR(44),FExchangeRate NUMERIC(21,8),FStartDate DateTime,FEndDate DateTime,FRemark NVARCHAR(200),FAuditTime DateTime,FBaseStatus INT,FBizTypeID VARCHAR(44),FSourceBillTypeID VARCHAR(44),FBillTypeID VARCHAR(44),FYear INT,FPeriod INT,FModifierID VARCHAR(44),FModificationTime DateTime,FNumber NVARCHAR(80),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),CONSTRAINT PK_ChaJXCFID PRIMARY KEY NONCLUSTERED (FID));

IF NOT EXISTS   (SELECT * FROM KSQL_USERTABLES where KSQL_TABNAME ='T_CHA_ChannelJXCBillEntry')
Create Table T_CHA_ChannelJXCBillEntry ( FID VARCHAR(44) NOT NULL ,FParentID VARCHAR(44),FBatchNo NVARCHAR(80),FInQty NUMERIC(21,8),FOutQty NUMERIC(21,8),FInvQty NUMERIC(21,8),FInPrice NUMERIC(17,4),FOutPrice NUMERIC(17,4),FInvPrice NUMERIC(17,4),FInAmount NUMERIC(17,4),FOutAmount NUMERIC(17,4),FInvAmount NUMERIC(17,4),FInLocalAmount NUMERIC(17,4),FOutLocalAmount NUMERIC(17,4),FInvLocalAmount NUMERIC(17,4),FBaseInQty NUMERIC(21,8),FBaseOutQty NUMERIC(21,8),FBaseInvQty NUMERIC(21,8),FAssistInQty NUMERIC(21,8),FAssistOutQty NUMERIC(21,8),FAssistInvQty NUMERIC(21,8),FMaterialID VARCHAR(44),FAssistPropertyID VARCHAR(44),FUnitID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceBillNumber NVARCHAR(80),FSourceBillEntryID NVARCHAR(80),FSourceBillEntrySeq INT,FAssCoefficient NUMERIC(21,8),FBaseStatus INT,FAssociateQty NUMERIC(21,8),FSourceBillTypeID VARCHAR(44),FBaseUnitID VARCHAR(44),FAssistUnitID VARCHAR(44),FRemark NVARCHAR(200),FReasonCodeID VARCHAR(44),FSeq INT,CONSTRAINT PK_ChaJXCEFID PRIMARY KEY NONCLUSTERED (FID));

IF NOT EXISTS   (SELECT * FROM KSQL_USERTABLES where KSQL_TABNAME ='T_CHA_ChannelSaleIssueBill')
Create Table T_CHA_ChannelSaleIssueBill ( FID VARCHAR(44) NOT NULL ,FSaleOrgUnitID VARCHAR(44),FSalePersonID VARCHAR(44),FChannelID VARCHAR(44),FCurrencyID VARCHAR(44),FExchangeRate NUMERIC(21,8),FRemark NVARCHAR(200),FAuditTime DateTime,FBaseStatus INT,FBizTypeID VARCHAR(44),FSourceBillTypeID VARCHAR(44),FBillTypeID VARCHAR(44),FYear INT,FPeriod INT,FModifierID VARCHAR(44),FModificationTime DateTime,FNumber NVARCHAR(80),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),CONSTRAINT PK_ChaSIFID PRIMARY KEY NONCLUSTERED (FID));

IF NOT EXISTS   (SELECT * FROM KSQL_USERTABLES where KSQL_TABNAME ='T_CHA_ChannelSaleIssueEntry')
Create Table T_CHA_ChannelSaleIssueEntry ( FID VARCHAR(44) NOT NULL ,FParentID VARCHAR(44),FBatchNo NVARCHAR(80),FQty NUMERIC(21,8),FPrice NUMERIC(17,4),FAmount NUMERIC(17,4),FLocalAmount NUMERIC(17,4),FBaseQty NUMERIC(21,8),FAssistQty NUMERIC(21,8), FMaterialID VARCHAR(44),FAssistPropertyID VARCHAR(44),FUnitID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceBillNumber NVARCHAR(80),FSourceBillEntryID NVARCHAR(80),FSourceBillEntrySeq INT,FAssCoefficient NUMERIC(21,8),FBaseStatus INT,FAssociateQty NUMERIC(21,8),FSourceBillTypeID VARCHAR(44),FBaseUnitID VARCHAR(44),FAssistUnitID VARCHAR(44),FRemark NVARCHAR(200),FReasonCodeID VARCHAR(44),FSeq INT,CONSTRAINT PK_ChannelSIEFID PRIMARY KEY NONCLUSTERED (FID));
--变更描述：销售合同增加“收款条件”
--变更人：Stephen_xiao
--变更日期：2008-05-06
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'FReceiveConditionID' AND KSQL_COL_TABNAME = 'T_SD_SaleContract')
ALTER TABLE T_SD_SaleContract ADD FReceiveConditionID varchar(44);
-- 变更描述：渠道销量单增加出库类型字段
-- 变 更 人：bleeli
-- 变更时间：2008-6-26
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FSaleIssueType' and KSQL_COL_TABNAME='T_CHA_ChannelSaleIssueBill')
alter table T_CHA_ChannelSaleIssueBill add FSaleIssueType INT;
-- 变更描述：渠道单据增加精度字段,以便web界面交互
-- 变 更 人：bleeli
-- 变更时间：2008-6-28

--结存单
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCurrencyPrecision' and KSQL_COL_TABNAME='T_CHA_ChannelStockBill')
alter table T_CHA_ChannelStockBill add FCurrencyPrecision INT;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FLocalCurPrecision' and KSQL_COL_TABNAME='T_CHA_ChannelStockBill')
alter table T_CHA_ChannelStockBill add FLocalCurPrecision INT;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FExRatePrecision' and KSQL_COL_TABNAME='T_CHA_ChannelStockBill')
alter table T_CHA_ChannelStockBill add FExRatePrecision INT;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FPricePrecision' and KSQL_COL_TABNAME='T_CHA_ChannelStockBillEntry')
alter table T_CHA_ChannelStockBillEntry add FPricePrecision INT;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FUnitPrecision' and KSQL_COL_TABNAME='T_CHA_ChannelStockBillEntry')
alter table T_CHA_ChannelStockBillEntry add FUnitPrecision INT;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FBaseUnitPrecision' and KSQL_COL_TABNAME='T_CHA_ChannelStockBillEntry')
alter table T_CHA_ChannelStockBillEntry add FBaseUnitPrecision INT;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FAssistUnitPrecision' and KSQL_COL_TABNAME='T_CHA_ChannelStockBillEntry')
alter table T_CHA_ChannelStockBillEntry add FAssistUnitPrecision INT;

--进销存单
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCurrencyPrecision' and KSQL_COL_TABNAME='T_CHA_ChannelJXCBill')
alter table T_CHA_ChannelJXCBill add FCurrencyPrecision INT;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FLocalCurPrecision' and KSQL_COL_TABNAME='T_CHA_ChannelJXCBill')
alter table T_CHA_ChannelJXCBill add FLocalCurPrecision INT;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FExRatePrecision' and KSQL_COL_TABNAME='T_CHA_ChannelJXCBill')
alter table T_CHA_ChannelJXCBill add FExRatePrecision INT;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FPricePrecision' and KSQL_COL_TABNAME='T_CHA_ChannelJXCBillEntry')
alter table T_CHA_ChannelJXCBillEntry add FPricePrecision INT;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FUnitPrecision' and KSQL_COL_TABNAME='T_CHA_ChannelJXCBillEntry')
alter table T_CHA_ChannelJXCBillEntry add FUnitPrecision INT;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FBaseUnitPrecision' and KSQL_COL_TABNAME='T_CHA_ChannelJXCBillEntry')
alter table T_CHA_ChannelJXCBillEntry add FBaseUnitPrecision INT;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FAssistUnitPrecision' and KSQL_COL_TABNAME='T_CHA_ChannelJXCBillEntry')
alter table T_CHA_ChannelJXCBillEntry add FAssistUnitPrecision INT;

--入库单
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCurrencyPrecision' and KSQL_COL_TABNAME='T_CHA_ChannelInWarehsBill')
alter table T_CHA_ChannelInWarehsBill add FCurrencyPrecision INT;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FLocalCurPrecision' and KSQL_COL_TABNAME='T_CHA_ChannelInWarehsBill')
alter table T_CHA_ChannelInWarehsBill add FLocalCurPrecision INT;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FExRatePrecision' and KSQL_COL_TABNAME='T_CHA_ChannelInWarehsBill')
alter table T_CHA_ChannelInWarehsBill add FExRatePrecision INT;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FPricePrecision' and KSQL_COL_TABNAME='T_CHA_ChannelInWarehsBillEntry')
alter table T_CHA_ChannelInWarehsBillEntry add FPricePrecision INT;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FUnitPrecision' and KSQL_COL_TABNAME='T_CHA_ChannelInWarehsBillEntry')
alter table T_CHA_ChannelInWarehsBillEntry add FUnitPrecision INT;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FBaseUnitPrecision' and KSQL_COL_TABNAME='T_CHA_ChannelInWarehsBillEntry')
alter table T_CHA_ChannelInWarehsBillEntry add FBaseUnitPrecision INT;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FAssistUnitPrecision' and KSQL_COL_TABNAME='T_CHA_ChannelInWarehsBillEntry')
alter table T_CHA_ChannelInWarehsBillEntry add FAssistUnitPrecision INT;

--销量单
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCurrencyPrecision' and KSQL_COL_TABNAME='T_CHA_ChannelSaleIssueBill')
alter table T_CHA_ChannelSaleIssueBill add FCurrencyPrecision INT;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FLocalCurPrecision' and KSQL_COL_TABNAME='T_CHA_ChannelSaleIssueBill')
alter table T_CHA_ChannelSaleIssueBill add FLocalCurPrecision INT;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FExRatePrecision' and KSQL_COL_TABNAME='T_CHA_ChannelSaleIssueBill')
alter table T_CHA_ChannelSaleIssueBill add FExRatePrecision INT;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FPricePrecision' and KSQL_COL_TABNAME='T_CHA_ChannelSaleIssueEntry')
alter table T_CHA_ChannelSaleIssueEntry add FPricePrecision INT;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FUnitPrecision' and KSQL_COL_TABNAME='T_CHA_ChannelSaleIssueEntry')
alter table T_CHA_ChannelSaleIssueEntry add FUnitPrecision INT;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FBaseUnitPrecision' and KSQL_COL_TABNAME='T_CHA_ChannelSaleIssueEntry')
alter table T_CHA_ChannelSaleIssueEntry add FBaseUnitPrecision INT;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FAssistUnitPrecision' and KSQL_COL_TABNAME='T_CHA_ChannelSaleIssueEntry')
alter table T_CHA_ChannelSaleIssueEntry add FAssistUnitPrecision INT;

-- 变更描述：渠道单据单价长度修改
-- 变 更 人：bleeli
-- 变更时间：2008-7-3

--结存单
If exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FPrice' and KSQL_COL_TABNAME='T_CHA_ChannelStockBillEntry')
alter table T_CHA_ChannelStockBillEntry ALTER COLUMN  FPrice NUMERIC(21,8);
--进销存单
If exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FInPrice' and KSQL_COL_TABNAME='T_CHA_ChannelJXCBillEntry')
alter table T_CHA_ChannelJXCBillEntry ALTER COLUMN  FInPrice NUMERIC(21,8);

If exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FOutPrice' and KSQL_COL_TABNAME='T_CHA_ChannelJXCBillEntry')
alter table T_CHA_ChannelJXCBillEntry ALTER COLUMN  FOutPrice NUMERIC(21,8);

If exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FInvPrice' and KSQL_COL_TABNAME='T_CHA_ChannelJXCBillEntry')
alter table T_CHA_ChannelJXCBillEntry ALTER COLUMN  FInvPrice NUMERIC(21,8);
--入库单
If exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FPrice' and KSQL_COL_TABNAME='T_CHA_ChannelInWarehsBillEntry')
alter table T_CHA_ChannelInWarehsBillEntry ALTER COLUMN  FPrice NUMERIC(21,8);
--销量单
If exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FPrice' and KSQL_COL_TABNAME='T_CHA_ChannelSaleIssueEntry')
alter table T_CHA_ChannelSaleIssueEntry ALTER COLUMN  FPrice NUMERIC(21,8);

-- 变更描述：渠道单据增加库存组织和辅助属性类型及批次字段
-- 变 更 人：bleeli
-- 变更时间：2008-7-22

--结存单
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FStorageOrgUnitID' and KSQL_COL_TABNAME='T_CHA_ChannelStockBill')
alter table T_CHA_ChannelStockBill add FStorageOrgUnitID VARCHAR(44);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FAssistArrType' and KSQL_COL_TABNAME='T_CHA_ChannelStockBillEntry')
alter table T_CHA_ChannelStockBillEntry add FAssistArrType VARCHAR(44);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FIsBatchNo' and KSQL_COL_TABNAME='T_CHA_ChannelStockBillEntry')
alter table T_CHA_ChannelStockBillEntry add FIsBatchNo INT;

--进销存单
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FStorageOrgUnitID' and KSQL_COL_TABNAME='T_CHA_ChannelJXCBill')
alter table T_CHA_ChannelJXCBill add FStorageOrgUnitID VARCHAR(44);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FAssistArrType' and KSQL_COL_TABNAME='T_CHA_ChannelJXCBillEntry')
alter table T_CHA_ChannelJXCBillEntry add FAssistArrType VARCHAR(44);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FIsBatchNo' and KSQL_COL_TABNAME='T_CHA_ChannelJXCBillEntry')
alter table T_CHA_ChannelJXCBillEntry add FIsBatchNo INT;


--入库单
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FStorageOrgUnitID' and KSQL_COL_TABNAME='T_CHA_ChannelInWarehsBill')
alter table T_CHA_ChannelInWarehsBill add FStorageOrgUnitID VARCHAR(44);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FAssistArrType' and KSQL_COL_TABNAME='T_CHA_ChannelInWarehsBillEntry')
alter table T_CHA_ChannelInWarehsBillEntry add FAssistArrType VARCHAR(44);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FIsBatchNo' and KSQL_COL_TABNAME='T_CHA_ChannelInWarehsBillEntry')
alter table T_CHA_ChannelInWarehsBillEntry add FIsBatchNo INT;

--销量单
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FStorageOrgUnitID' and KSQL_COL_TABNAME='T_CHA_ChannelSaleIssueBill')
alter table T_CHA_ChannelSaleIssueBill add FStorageOrgUnitID VARCHAR(44);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FAssistArrType' and KSQL_COL_TABNAME='T_CHA_ChannelSaleIssueEntry')
alter table T_CHA_ChannelSaleIssueEntry add FAssistArrType VARCHAR(44);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FIsBatchNo' and KSQL_COL_TABNAME='T_CHA_ChannelSaleIssueEntry')
alter table T_CHA_ChannelSaleIssueEntry add FIsBatchNo INT;

--变更描述：修改所有供应链单据的地址/备注/说明等长度应为200,合同文本字段长度应为2000
--变 更 人：李波
--变更日期：2008-07-26
--返利单
if exists(select * from ksql_usercolumns where ksql_tabname = 'T_SD_SaleBackProfitBill' and ksql_col_name='FRemark')
alter table T_SD_SaleBackProfitBill ALTER COLUMN  FRemark nvarchar(200);

if exists(select * from ksql_usercolumns where ksql_tabname = 'T_SD_SaleBackProfitBillEntry' and ksql_col_name='FRemark')
alter table T_SD_SaleBackProfitBillEntry ALTER COLUMN  FRemark nvarchar(200);

--销售合同条款
if exists(select * from ksql_usercolumns where ksql_tabname = 'T_SD_SaleContractTerm' and ksql_col_name='FRemark')
alter table T_SD_SaleContractTerm ALTER COLUMN  FRemark nvarchar(200);

--金税接口表
if exists(select * from ksql_usercolumns where ksql_tabname = 'T_SD_TaxRelation' and ksql_col_name='FDescription')
alter table T_SD_TaxRelation ALTER COLUMN  FDescription nvarchar(255);

if exists(select * from ksql_usercolumns where ksql_tabname = 'T_SD_TaxRelation' and ksql_col_name='FNote')
alter table T_SD_TaxRelation ALTER COLUMN  FNote nvarchar(255);

if exists(select * from ksql_usercolumns where ksql_tabname = 'T_SD_TaxRelationEntry' and ksql_col_name='FDescription')
alter table T_SD_TaxRelationEntry ALTER COLUMN  FDescription nvarchar(255);

if exists(select * from ksql_usercolumns where ksql_tabname = 'T_SD_TaxRelationEntryD' and ksql_col_name='FDescription')
alter table T_SD_TaxRelationEntryD ALTER COLUMN  FDescription nvarchar(255);

--发货通知单
if exists(select * from ksql_usercolumns where ksql_tabname = 'T_SD_PostRequisitionEntry' and ksql_col_name='FDeliveryAddress')
alter table T_SD_PostRequisitionEntry ALTER COLUMN  FDeliveryAddress nvarchar(255);
--送货客户
If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FDeliveryCustomerID' and KSQL_COL_TABNAME = 'T_SD_SaleReturnsEntry' )
ALTER TABLE T_SD_SaleReturnsEntry ADD FDeliveryCustomerID VARCHAR(44);
--收款客户
If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FPaymentCustomerID' and KSQL_COL_TABNAME = 'T_SD_SaleReturnsEntry' )
ALTER TABLE T_SD_SaleReturnsEntry ADD FPaymentCustomerID VARCHAR(44);
--应收客户
If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FReceiveCustomerID' and KSQL_COL_TABNAME = 'T_SD_SaleReturnsEntry' )
ALTER TABLE T_SD_SaleReturnsEntry ADD FReceiveCustomerID VARCHAR(44);
--变更描述：为销售订单添加 累计退库须补货基本数量
--变更人：宫涛
--变更日期：2008-10-9
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FTotalSupplyStockBaseQty' and KSQL_COL_TABNAME='T_SM_PurOrderEntry')
alter table T_SM_PurOrderEntry add FTotalSupplyStockBaseQty NUMERIC(21,8) DEFAULT 0 NOT NULL;
-- 变更人：肖平春
-- 变更日期：2008-12-31
-- 描述：销售订单数据升级脚本
if not exists(select KSQL_COL_NAME FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME='T_SD_SaleOrderEntry' and KSQL_COL_NAME='FArClosedStatus')
	alter table T_SD_SaleOrderEntry add FArClosedStatus int;
