/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.ArapContrastDiffRptService;
import com.kingdee.eas.fi.arap.app.util.ArapContrastDiffRptUtils;
import com.kingdee.eas.fi.arap.impl.ArapRptServiceImpl;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value={"com.kingdee.eas.fi.arap.ArapContrastDiffRptService"})
public class ArapContrastDiffRptServiceImpl
extends ArapRptServiceImpl
implements ArapContrastDiffRptService {
    private DateFormat format = new SimpleDateFormat("yyyy-MM-dd");

    public ArapContrastDiffRptServiceImpl(Context context) {
        super(context);
    }

    @Override
    public Map<String, Object> query(Map<String, Object> condition) throws BOSException, EASBizException {
        String period;
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean fAR = true;
        String system = (String)condition.get("system");
        if ("12".equals(system)) {
            fAR = true;
        } else if ("13".equals(system)) {
            fAR = false;
        } else {
            return result;
        }
        String companyId = (String)condition.get("companyId");
        if (companyId == null) {
            return result;
        }
        String periodId = (String)condition.get("periodId");
        if ((periodId == null || periodId.length() == 0) && (period = (String)condition.get("period")) != null) {
            PeriodInfo periodInfo = this.getPeriodInfo(companyId, Integer.parseInt(period));
            periodId = periodInfo.getId().toString();
        }
        if (periodId == null) {
            return result;
        }
        String currencyId = (String)condition.get("currencyId");
        String project = (String)condition.get("project");
        String acctId = (String)condition.get("acctId");
        String asstActId = (String)condition.get("asstActId");
        String cussTypeId = (String)condition.get("cussTypeId");
        Map temp = ArapContrastDiffRptUtils.createTable((Context)this.getContext(), (boolean)fAR, (String)companyId, (String)periodId, (String)acctId, (int)Integer.parseInt(project), (String)asstActId, (String)currencyId, (String)cussTypeId);
        result.putAll(temp);
        return result;
    }

    @Override
    protected IRowSet executeQuery(Map<String, Object> condition, int from, int rows) throws EASBizException, BOSException {
        String queryId = (String)condition.get("queryId");
        String diffType = (String)condition.get("diffType");
        StringBuffer sql = new StringBuffer();
        sql.append("select * from " + queryId + " \n");
        sql.append("where fDiffType = " + diffType + " \n");
        if ("0".equals(diffType)) {
            sql.append("or FIsSum = 0 \n");
        }
        sql.append("order by FIsSum, FVoucherNumber");
        return DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString(), (int)from, (int)rows);
    }

    @Override
    protected int getRecords(Map<String, Object> condition) throws EASBizException, BOSException, SQLException {
        IRowSet rs;
        String strRecords = (String)condition.get("records");
        if (strRecords != null && strRecords.length() > 0) {
            return Integer.parseInt(strRecords);
        }
        String queryId = (String)condition.get("queryId");
        if (queryId == null || queryId.length() == 0) {
            return 0;
        }
        String diffType = (String)condition.get("diffType");
        StringBuffer sql = new StringBuffer();
        sql.append("select count(*) from " + queryId + " \n");
        sql.append("where fDiffType = " + diffType + " \n");
        if ("0".equals(diffType)) {
            sql.append("or FIsSum = 0 \n");
        }
        if ((rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString())).next()) {
            return rs.getInt(1);
        }
        return 0;
    }

    @Override
    protected Map<String, Object> wrapRow(Map<String, Object> condition, IRowSet rowSet) throws SQLException {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("FID", rowSet.getString("FID"));
        row.put("FBillID", rowSet.getString("FBillID"));
        row.put("FBillType", rowSet.getString("FBillType"));
        row.put("FBillNumber", rowSet.getString("FBillNumber"));
        Date date = rowSet.getDate("FBillDate");
        if (date != null) {
            row.put("FBillDate", this.format.format(date));
        } else {
            row.put("FBillDate", null);
        }
        row.put("FBillAmount", rowSet.getBigDecimal("FBillAmount"));
        String FVoucherID = rowSet.getString("FVoucherID");
        if (FVoucherID == null || FVoucherID.length() == 0) {
            FVoucherID = BOSUuid.create((String)"12345678").toString();
        }
        row.put("FVoucherID", FVoucherID);
        row.put("FVoucherPeriod", rowSet.getString("FVoucherPeriod"));
        row.put("FVoucherNumber", rowSet.getString("FVoucherNumber"));
        row.put("FVoucherAmount", rowSet.getBigDecimal("FVoucherAmount"));
        row.put("FDiffAmount", rowSet.getBigDecimal("FDiffAmount"));
        row.put("FDiffType", rowSet.getString("FDiffType"));
        row.put("FIsSum", rowSet.getInt("FIsSum"));
        return row;
    }
}

