/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.services.core.BusinessServices;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.IAppointmentAccountServices;
import com.kingdee.eas.fi.cas.CasForArApException;
import com.kingdee.eas.framework.batchaction.ActionResult;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.action.ActionResultEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value={"com.kingdee.eas.fi.arap.IAppointmentAccountServices"})
public class AppointmentAccountServices
extends BusinessServices
implements IAppointmentAccountServices {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.impl.AppointmentAccountServices");

    public AppointmentAccountServices(Context context) {
        super(context);
    }

    public Class[] getParameterTypes() {
        return new Class[]{IObjectPK[].class, AccountViewInfo.class, ArrayList.class};
    }

    public BatchExecuteParamsEntry[] getParameters(List<String> idList, String accountid) {
        BatchExecuteParamsEntry[] paramEntries = new BatchExecuteParamsEntry[idList.size()];
        BatchExecuteParamsEntry entry = null;
        AccountViewInfo accountViewInfo = null;
        Class[] paramTypes = null;
        paramTypes = accountid == null || accountid.trim().length() == 0 ? new Class[]{IObjectPK[].class, ArrayList.class} : new Class[]{IObjectPK[].class, AccountViewInfo.class, ArrayList.class};
        for (int i = 0; i < idList.size(); ++i) {
            entry = new BatchExecuteParamsEntry(paramTypes);
            IObjectPK[] pks = new IObjectPK[]{new ObjectUuidPK(idList.get(i))};
            entry.add((Object)pks);
            accountViewInfo = new AccountViewInfo();
            if (accountid != null) {
                accountViewInfo.setId(BOSUuid.read((String)accountid));
                entry.add((Object)accountViewInfo);
            }
            entry.add(null);
            paramEntries[i] = entry;
        }
        return paramEntries;
    }

    public Object getId(BatchExecuteParamsEntry paramEntry) {
        return ((Object[])paramEntry.get(0))[0];
    }

    protected void dealwithResult(BatchExecuteResult exeResult, Map<String, Object> result, BatchExecuteParamsEntry[] params) {
        if (exeResult.getBatchResult() == null) {
            Throwable[] exps = exeResult.getExceptions();
            int errorCount = result.size();
            for (int i = 0; i < exps.length; ++i) {
                if (exps[i] == null) continue;
                ++errorCount;
                result.put(this.getId(params[i]).toString(), exps[i].getMessage());
            }
            result.put("ERROR_COUNT", String.valueOf(errorCount));
        } else {
            int errorCount = result.size();
            BatchActionResults actionResults = (BatchActionResults)exeResult.getBatchResult();
            for (int i = 0; i < params.length; ++i) {
                Object id = this.getId(params[i]);
                ActionResult actionResult = actionResults.getActionResult(id);
                if (actionResult.getResult().equals((Object)ActionResultEnum.SUCCESS)) continue;
                result.put(id.toString(), actionResult.getMessage());
                ++errorCount;
            }
            result.put("ERROR_COUNT", String.valueOf(errorCount));
        }
    }

    protected List<String> requestLocks(Context ctx, List<String> toLockList, Map<String, Object> result) throws BOSException {
        Map lockMap = MutexServiceControlFactory.getLocalInstance((Context)ctx).batchRequestObjIDForUpdate(toLockList);
        ArrayList<String> lockedList = new ArrayList<String>(toLockList.size());
        if (lockMap != null) {
            for (int i = 0; i < toLockList.size(); ++i) {
                String id = toLockList.get(i);
                if (lockMap.containsKey(id) && ((Boolean)lockMap.get(id)).booleanValue()) {
                    lockedList.add(id);
                    continue;
                }
                result.put(id, "request mutex lock failed!");
            }
        }
        return lockedList;
    }

    protected void releaseLocks(Context ctx, List<String> lockList) throws BOSException {
        if (lockList != null && lockList.size() > 0) {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).batchReleaseObjIDForUpdate(lockList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> appointmentAccount(String bosType, String methodName, String accountid, String ids) throws EASBizException, BOSException {
        String[] billIDs = ids.split(",");
        IBizCtrl bizCtrl = (IBizCtrl)BOSObjectFactory.createBOSObject((Context)this.getContext(), (BOSObjectType)BOSObjectType.create((String)bosType));
        ArrayList<String> idList = new ArrayList<String>(billIDs.length);
        for (int i = 0; i < billIDs.length; ++i) {
            idList.add(billIDs[i]);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<String> lockedList = null;
        BatchExecuteResult exeResult = new BatchExecuteResult(idList.size());
        try {
            lockedList = this.requestLocks(this.getContext(), idList, result);
            BatchExecuteParamsEntry[] params = this.getParameters(lockedList, accountid);
            Method method = null;
            try {
                method = bizCtrl.getClass().getMethod(methodName, params[0].getParamTypes());
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            int size = params.length;
            for (int i = 0; i < size; ++i) {
                try {
                    method.invoke((Object)bizCtrl, params[i].toArray());
                    continue;
                }
                catch (Exception e) {
                    if (e.getCause() instanceof CasForArApException) {
                        exeResult.setException(i, e.getCause());
                        continue;
                    }
                    throw new BOSException((Throwable)e);
                }
            }
            this.dealwithResult(exeResult, result, params);
        }
        finally {
            this.releaseLocks(this.getContext(), lockedList);
        }
        return result;
    }

    @Override
    public boolean verifyBefore(String billIDs) throws EASBizException, BOSException {
        String[] ids = billIDs.split(",");
        StringBuffer sql = new StringBuffer();
        sql.append("select count(*) as currencycount from T_cas_paymentbill where fid in (");
        sql.append(this.getString(ids)).append(")");
        sql.append(" group by fcurrencyid");
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString());
        int currencycount = rs.size();
        return currencycount > 1;
    }

    private String getString(String[] billIds) {
        StringBuffer buf = new StringBuffer();
        int len = billIds.length;
        for (int k = 0; k < len; ++k) {
            buf.append("'").append(billIds[k]).append("',");
        }
        if (buf.length() > 0) {
            return buf.substring(0, buf.length() - 1);
        }
        return "null";
    }
}

