/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.services.core.BusinessServices;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.IVoucherType;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.IAppointmentVoucherService;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CasForArApException;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value={"com.kingdee.eas.fi.arap.IAppointmentVoucherService"})
public class AppointmentVoucherService
extends BusinessServices
implements IAppointmentVoucherService {
    protected String cashSaleflag = "cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5";
    protected String cashPurflag = "40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5";
    private String autoResourcePath = "com.kingdee.eas.fi.arap.ARAPAutoGenerateResource";
    private String arapResourcePath = "com.kingdee.eas.fi.arap.ArapResource";
    private String billResourcePath = "com.kingdee.eas.fi.ar.ArApBillResource";

    public AppointmentVoucherService(Context context) {
        super(context);
    }

    private Map getParamMap(String companyid) throws EASBizException, BOSException {
        String[] paramnumbers = new String[]{"AP_PAYVOUCHER_BILLTYPE_CASH", "AR_RECVOUCHER_BILLTYPE_CASH"};
        HashMap paramMap = ParamControlFactory.getLocalInstance((Context)this.getContext()).getParamHashMap(paramnumbers, companyid);
        return paramMap;
    }

    @Override
    public Map<String, Object> appointmentVoucher(String bosType, String companyid, String ids, String voucherid) throws EASBizException, BOSException {
        boolean ispay = true;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        StringBuffer error = new StringBuffer();
        String[] billIDs = ids.split(",");
        ArrayList sucessbillids = new ArrayList();
        Map paramMap = this.getParamMap(companyid);
        String cashflag = paramMap.get("AP_PAYVOUCHER_BILLTYPE_CASH").toString();
        int errorCount = 0;
        Set<String> set = this.requestLocks(this.getContext(), billIDs, resultMap);
        EntityViewInfo viewBill = new EntityViewInfo();
        FilterInfo filterInfoBill = new FilterInfo();
        filterInfoBill.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        viewBill.setFilter(filterInfoBill);
        viewBill.getSelector().add(new SelectorItemInfo("*"));
        if (ispay) {
            viewBill.getSelector().add(new SelectorItemInfo("payBillType.isPurPay"));
            viewBill.getSelector().add(new SelectorItemInfo("paymentType.id"));
        }
        CoreBaseCollection coreBaseCols = this.getBizInterface().getCollection(viewBill);
        this.appointment(sucessbillids, coreBaseCols, voucherid);
        ArrayList<String> lockList = new ArrayList<String>();
        int size = set.size();
        for (int i = 0; i < size; ++i) {
            lockList.add((String)set.toArray()[i]);
        }
        this.releaseLocks(this.getContext(), lockList);
        resultMap.put("ERROR_COUNT", errorCount);
        return resultMap;
    }

    private void appointment(List sucessbillids, CoreBaseCollection coreBaseCols, String voucherid) throws EASBizException, BOSException {
        RecPayBillInfo recPayBillInfo = null;
        HashSet<BOSUuid> ids = new HashSet<BOSUuid>();
        IVoucher iVoucher = VoucherFactory.getLocalInstance((Context)this.getContext());
        VoucherInfo voucher = (VoucherInfo)VoucherFactory.getLocalInstance((Context)this.getContext()).getValue((IObjectPK)new ObjectUuidPK(voucherid));
        boolean isRecOrPay = false;
        IObjectPK logPK = null;
        int size = coreBaseCols.size();
        for (int index = 0; index < size; ++index) {
            recPayBillInfo = (RecPayBillInfo)coreBaseCols.get(index);
            if (!sucessbillids.contains(recPayBillInfo.getId().toString())) continue;
            logPK = LogUtil.beginLog(null, (String)ResourceBase.getString((String)this.autoResourcePath, (String)"58_RecPaypointmentVoucherUI", (Locale)this.getContext().getLocale()), (BOSObjectType)new PaymentBillInfo().getBOSType(), null, (String)(recPayBillInfo.getNumber() + ResourceBase.getString((String)this.autoResourcePath, (String)"58_RecPaypointmentVoucherUI", (Locale)this.getContext().getLocale())));
            if (recPayBillInfo.getSourceType().equals((Object)SourceTypeEnum.AR)) {
                isRecOrPay = true;
            }
            recPayBillInfo.setVoucher(voucher);
            recPayBillInfo.setVoucherNumber(voucher.getNumber());
            recPayBillInfo.setVoucherType(voucher.getVoucherType());
            recPayBillInfo.setIsAppointVoucher(true);
            recPayBillInfo.setFiVouchered(true);
            ids.add(recPayBillInfo.getId());
            this.delBotpRelation(recPayBillInfo.getId().toString());
            this.createBotpRelation(recPayBillInfo.getId().toString(), recPayBillInfo.getVoucher().getId().toString(), isRecOrPay);
            LogUtil.afterLog(null, (IObjectPK)logPK);
        }
        ReceivingBillFactory.getLocalInstance((Context)this.getContext()).batchAppointmentVoucher(ids, recPayBillInfo, isRecOrPay);
        if (coreBaseCols != null && coreBaseCols.size() > 0 && voucher.getSourceBillId() == null && SourceType.HANDCRAFT.equals((Object)voucher.getSourceType())) {
            ObjectUuidPK vorcherID = new ObjectUuidPK(voucher.getId());
            voucher.setSourceBillId(coreBaseCols.get(0).getId().toString());
            iVoucher.update((IObjectPK)vorcherID, (CoreBaseInfo)voucher);
        }
    }

    private void delBotpRelation(String srcObjectId) throws BOSException, UuidException, EASBizException {
        IBOTRelation iBOTRelation2 = BOTRelationFactory.getLocalInstance((Context)this.getContext());
        BOTRelationCollection botRelationCollection2 = null;
        EntityViewInfo view2 = new EntityViewInfo();
        FilterInfo filterInfo2 = new FilterInfo();
        String srcBosType = BOSUuid.read((String)srcObjectId).getType().toString();
        filterInfo2.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)srcBosType, CompareType.EQUALS));
        filterInfo2.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)new VoucherInfo().getBOSType().toString(), CompareType.EQUALS));
        filterInfo2.getFilterItems().add(new FilterItemInfo("srcObjectId", (Object)srcObjectId, CompareType.EQUALS));
        view2.setFilter(filterInfo2);
        botRelationCollection2 = iBOTRelation2.getCollection(view2);
        if (botRelationCollection2.size() > 0) {
            BOTRelationInfo rotpmap = botRelationCollection2.get(0);
            ObjectStringPK pkbot = new ObjectStringPK(rotpmap.getId().toString());
            iBOTRelation2.delete((IObjectPK)pkbot);
        }
    }

    private void createBotpRelation(String srcObjectId, String destObjectId, boolean isRecOrPay) throws BOSException, UuidException, EASBizException {
        if (StringUtils.isEmpty((String)srcObjectId) || StringUtils.isEmpty((String)destObjectId)) {
            return;
        }
        BOTRelationCollection botRelationCollection = null;
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)this.getContext());
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String srcBosType = BOSUuid.read((String)srcObjectId).getType().toString();
        String destBosType = BOSUuid.read((String)destObjectId).getType().toString();
        filterInfo.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)destObjectId, CompareType.EQUALS));
        view.setFilter(filterInfo);
        botRelationCollection = iBOTRelation.getCollection(view);
        if (botRelationCollection != null && botRelationCollection.size() > 0) {
            BOTRelationInfo rotpmap = botRelationCollection.get(0);
            BOTRelationInfo info = new BOTRelationInfo();
            info.setSrcEntityID(srcBosType);
            info.setDestEntityID(destBosType);
            info.setSrcObjectID(srcObjectId);
            info.setDestObjectID(destObjectId);
            info.setDate(new Date());
            info.setOperatorID("system");
            info.setIsEffected(true);
            info.setBOTMappingID(rotpmap.getBOTMappingID());
            info.setType(0);
            iBOTRelation.addnew(info);
        } else {
            BOTRelationInfo info = new BOTRelationInfo();
            info.setSrcEntityID(srcBosType);
            info.setDestEntityID(destBosType);
            info.setSrcObjectID(srcObjectId);
            info.setDestObjectID(destObjectId);
            info.setDate(new Date());
            info.setOperatorID("system");
            info.setIsEffected(true);
            if (isRecOrPay) {
                BOTMappingCollection botMappingColl = BOTMappingFactory.getLocalInstance((Context)this.getContext()).getBOTMappingCollection(" select id where SrcEntityName='FA44FD5B' and DestEntityName='2652E01E'");
                if (botMappingColl != null && botMappingColl.size() > 0) {
                    info.setBOTMappingID(botMappingColl.get(0).getId().toString());
                }
            } else {
                BOTMappingCollection botMappingColl = BOTMappingFactory.getLocalInstance((Context)this.getContext()).getBOTMappingCollection(" select id where SrcEntityName='40284E81' and DestEntityName='2652E01E'");
                if (botMappingColl != null && botMappingColl.size() > 0) {
                    info.setBOTMappingID(botMappingColl.get(0).getId().toString());
                }
            }
            info.setType(0);
            iBOTRelation.addnew(info);
        }
    }

    public String verify(Map paramMap, RecPayBillInfo recPayBillInfo, String companyid) throws EASBizException, BOSException {
        PaymentTypeInfo billPaymentType;
        ReceivingBillInfo billInfo;
        String cashflag = paramMap.get("AP_PAYVOUCHER_BILLTYPE_CASH").toString();
        StringBuffer error = new StringBuffer();
        boolean isPurPay = false;
        boolean sysflag = false;
        if (SystemEnum.ACCOUNTSRECEIVABLE.equals((Object)this.getSysEnum())) {
            sysflag = true;
        }
        if (sysflag) {
            billInfo = (ReceivingBillInfo)recPayBillInfo;
            billPaymentType = billInfo.getPaymentType();
        } else {
            billInfo = (PaymentBillInfo)recPayBillInfo;
            billPaymentType = billInfo.getPaymentType();
            isPurPay = billInfo.getPayBillType().isIsPurPay();
        }
        if (this.cashSaleflag.equals(billPaymentType.getId().toString()) && (cashflag = paramMap.get("AR_RECVOUCHER_BILLTYPE_CASH").toString()).equals("0")) {
            error.append(new CasForArApException(CasForArApException.CASH_APP_SUBJECT).getMessage());
        }
        if (this.cashPurflag.equals(billPaymentType.getId().toString())) {
            cashflag = paramMap.get("AP_PAYVOUCHER_BILLTYPE_CASH").toString();
            if (cashflag.equals("0")) {
                error.append(new CasForArApException(CasForArApException.CASH_APP_SUBJECT).getMessage());
            }
        } else {
            boolean isCanCreateVoucher = this.isPayBillCreateVoucher(companyid);
            if (!isCanCreateVoucher && isPurPay) {
                error.append(this.getReResource(this.billResourcePath, "verificationbill_notcash_cannot_creatvo"));
            }
        }
        return error.toString();
    }

    private String verifyStatus(boolean ispay, String bosType, RecPayBillInfo recPayBillInfo, String companyid, StringBuffer error) throws EASBizException, BOSException {
        boolean sysflag = false;
        if (SystemEnum.ACCOUNTSRECEIVABLE.equals((Object)this.getSysEnum())) {
            sysflag = true;
        }
        if (ispay) {
            if (this.getBooleanParamValue(companyid, "Pay_Vou_001")) {
                if (!recPayBillInfo.getBillStatus().equals((Object)BillStatusEnum.PAYED)) {
                    error.append(this.getReResource(this.billResourcePath, "point_voucher_payment_not")).append("\r\n");
                }
            } else if (!recPayBillInfo.getBillStatus().equals((Object)BillStatusEnum.AUDITED) && !recPayBillInfo.getBillStatus().equals((Object)BillStatusEnum.PAYED)) {
                error.append(this.getReResource(this.billResourcePath, "point_voucher_unaudit_not")).append("\r\n");
            }
        } else if (this.getBooleanParamValue(companyid, "Rec_Vou_001")) {
            if (!recPayBillInfo.getBillStatus().equals((Object)BillStatusEnum.RECED)) {
                error.append(this.getReResource(this.billResourcePath, "point_voucher_receiving_not")).append("\r\n");
            }
        } else if (!recPayBillInfo.getBillStatus().equals((Object)BillStatusEnum.AUDITED) && !recPayBillInfo.getBillStatus().equals((Object)BillStatusEnum.RECED)) {
            error.append(this.getReResource(this.billResourcePath, "point_voucher_unaudit_not")).append("\r\n");
        }
        if (sysflag && ((ReceivingBillInfo)recPayBillInfo).getPayerID() == null) {
            error.append(this.getReResource(this.billResourcePath, "point_voucher_AsstNullNoVoucher")).append("\r\n");
        }
        int system = this.getSysEnum().getValue();
        if (recPayBillInfo.getBizDate().before(this.getCurrentPeriod(system, companyid).getBeginDate())) {
            error.append(this.getReResource(this.billResourcePath, "point_voucher_initbill_not")).append("\r\n");
        }
        return error.toString();
    }

    private String verivyVoucher(String bosType, RecPayBillInfo recPayBillInfo, StringBuffer error) throws EASBizException, BOSException {
        Object msg = null;
        IBOTRelation iBotRelation = BOTRelationFactory.getLocalInstance((Context)this.getContext());
        BOTRelationCollection botRelationCollection = null;
        if (!recPayBillInfo.isIsAppointVoucher()) {
            iBotRelation = BOTRelationFactory.getLocalInstance((Context)this.getContext());
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            if (SystemEnum.ACCOUNTSPAYABLE.equals((Object)this.getSysEnum())) {
                filterInfo.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)new PaymentBillInfo().getBOSType().toString(), CompareType.EQUALS));
            } else if (SystemEnum.ACCOUNTSRECEIVABLE.equals((Object)this.getSysEnum())) {
                filterInfo.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)new ReceivingBillInfo().getBOSType().toString(), CompareType.EQUALS));
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)new VoucherInfo().getBOSType().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)recPayBillInfo.getId().toString(), CompareType.EQUALS));
            view.setFilter(filterInfo);
            botRelationCollection = iBotRelation.getCollection(view);
            if (botRelationCollection.size() > 0) {
                error.append(this.getReResource(this.billResourcePath, "point_voucher_created_not")).append("\r\n");
            }
        }
        return error.toString();
    }

    public boolean getBooleanParamValue(String sCompanyId, String paramNumber) throws EASBizException, BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(sCompanyId);
        String value = null;
        value = ParamManager.getParamValue((Context)this.getContext(), (IObjectPK)pk, (String)paramNumber);
        return "true".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value);
    }

    public boolean isPayBillCreateVoucher(String sCompanyId) throws EASBizException, BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(sCompanyId);
        int checkType = 0;
        checkType = Integer.parseInt(ParamManager.getParamValue((Context)this.getContext(), (IObjectPK)pk, (String)"AP_PAYVOUCHER_BILLTYPE"));
        return checkType != 0;
    }

    protected SystemEnum getSysEnum() {
        return SystemEnum.ACCOUNTSPAYABLE;
    }

    protected ICoreBase getBizInterface() throws EASBizException, BOSException {
        if (this.getSysEnum().equals((Object)SystemEnum.ACCOUNTSPAYABLE)) {
            return PaymentBillFactory.getLocalInstance((Context)this.getContext());
        }
        return ReceivingBillFactory.getLocalInstance((Context)this.getContext());
    }

    private String getReResource(String path, String str) throws EASBizException, BOSException {
        return ResourceBase.getString((String)path, (String)str, (Locale)this.getContext().getLocale());
    }

    public String getBOSEntityAlias(String bostype) throws EASBizException, BOSException {
        EntityObjectInfo info = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(BOSObjectType.create((String)bostype));
        return info.getAlias();
    }

    public PeriodInfo getCurrentPeriod(int system, String companyid) throws BOSException, EASBizException {
        ISystemStatusCtrol ictrol = null;
        ictrol = SystemStatusCtrolFactory.getLocalInstance((Context)this.getContext());
        return ictrol.getCacheCurrentPeriod(system, companyid);
    }

    private String getVouTypeFilter(String cuid) throws BOSException, EASBizException {
        IVoucherType iVoucherType = VoucherTypeFactory.getLocalInstance((Context)this.getContext());
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cuid, CompareType.EQUALS));
        FilterInfo filterVT = null;
        filterVT = VoucherTypeFactory.getLocalInstance((Context)this.getContext()).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuid), "id", "adminCU");
        filterInfo.mergeFilter(filterVT, "OR");
        view.setFilter(filterInfo);
        VoucherTypeCollection voucherCollection = iVoucherType.getVoucherTypeCollection(view);
        VoucherTypeInfo info = null;
        StringBuffer filter = new StringBuffer();
        int size = voucherCollection.size();
        for (int i = 0; i < size; ++i) {
            info = voucherCollection.get(i);
            String id = info.getId().toString();
            filter.append(" id ='").append(id).append("' ");
            if (i >= size - 1) continue;
            filter.append(" or ");
        }
        if (voucherCollection.size() == 0) {
            filter.append("id = 'null' ");
        }
        return filter.toString();
    }

    @Override
    public Map<String, Object> verifyBefore(String bosType, String companyid, String ids) throws EASBizException, BOSException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        StringBuffer error = new StringBuffer();
        boolean ispay = true;
        String[] billIDs = ids.split(",");
        ArrayList<String> sucessbillids = new ArrayList<String>();
        Map paramMap = this.getParamMap(companyid);
        String cashflag = paramMap.get("AP_PAYVOUCHER_BILLTYPE_CASH").toString();
        int errorCount = 0;
        boolean isRelatedAccount = SystemStatusCtrolFactory.getLocalInstance((Context)this.getContext()).isRelatedAccount(companyid, SystemEnum.ACCOUNTSPAYABLE);
        if (!isRelatedAccount) {
            error.append(ResourceBase.getString((String)this.billResourcePath, (String)"isNotRelateGL", (Locale)this.getContext().getLocale()));
            resultMap.put("isNotRelateGL", error);
            return resultMap;
        }
        HashSet<String> set = new HashSet<String>();
        int size = billIDs.length;
        for (int i = 0; i < size; ++i) {
            set.add(billIDs[i]);
        }
        EntityViewInfo viewBill = new EntityViewInfo();
        FilterInfo filterInfoBill = new FilterInfo();
        filterInfoBill.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        viewBill.setFilter(filterInfoBill);
        viewBill.getSelector().add(new SelectorItemInfo("*"));
        if (ispay) {
            viewBill.getSelector().add(new SelectorItemInfo("payBillType.isPurPay"));
            viewBill.getSelector().add(new SelectorItemInfo("paymentType.id"));
        }
        CoreBaseCollection coreBaseCols = this.getBizInterface().getCollection(viewBill);
        int size2 = coreBaseCols.size();
        for (int i = 0; i < size2; ++i) {
            error = new StringBuffer();
            RecPayBillInfo recPayBillInfo = (RecPayBillInfo)coreBaseCols.get(i);
            String id = recPayBillInfo.getId().toString();
            error.append(this.verify(paramMap, recPayBillInfo, companyid));
            this.verifyStatus(ispay, bosType, recPayBillInfo, companyid, error);
            this.verivyVoucher(bosType, recPayBillInfo, error);
            if (error.toString().length() > 0) {
                ++errorCount;
                resultMap.put(id, error.toString());
                continue;
            }
            sucessbillids.add(id);
        }
        resultMap.put("ERROR_COUNT", errorCount);
        return resultMap;
    }

    protected Set<String> requestLocks(Context ctx, String[] ids, Map<String, Object> result) throws BOSException {
        ArrayList<String> idList = new ArrayList<String>();
        int size = ids.length;
        for (int i = 0; i < size; ++i) {
            idList.add(ids[i]);
        }
        Map lockMap = MutexServiceControlFactory.getLocalInstance((Context)ctx).batchRequestObjIDForUpdate(idList);
        HashSet<String> lockedList = new HashSet<String>();
        if (lockMap != null) {
            for (int i = 0; i < ids.length; ++i) {
                String id = ids[i];
                if (lockMap.containsKey(id) && ((Boolean)lockMap.get(id)).booleanValue()) {
                    lockedList.add(id);
                    continue;
                }
                result.put(id, "\u7533\u8bf7\u4e92\u65a5\u5931\u8d25\uff0c\u6709\u4eba\u6b63\u5728\u64cd\u4f5c\u8be5\u5355\u636e");
            }
        }
        return lockedList;
    }

    protected void releaseLocks(Context ctx, List<String> lockList) throws BOSException {
        if (lockList != null && lockList.size() > 0) {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).batchReleaseObjIDForUpdate(lockList);
        }
    }

    @Override
    public Map<String, Object> getInitData(String companyid, int system, String orderid) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = null;
        if (!StringUtil.isEmpty((String)companyid)) {
            ObjectUuidPK pk = new ObjectUuidPK(companyid);
            company = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext()).getCompanyOrgUnitInfo((IObjectPK)pk);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("voucherTypeFilter", this.getVouTypeFilter(company.getCU().getId().toString()));
        PeriodInfo currentPeriod = this.getCurrentPeriod(system, companyid);
        resultMap.put("currentPeriod", currentPeriod);
        return resultMap;
    }

    @Override
    public Map<String, Object> checkVoucher(String companyid, int periodYear, int periodNumber, String voucherTypeid, String vouchernumber) throws EASBizException, BOSException {
        IVoucher iVoucher = VoucherFactory.getLocalInstance((Context)this.getContext());
        EntityViewInfo viewVoucher = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String voucherid = null;
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)vouchernumber, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("period.periodYear", (Object)periodYear, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("period.periodNumber", (Object)periodNumber, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("voucherType.id", (Object)voucherTypeid, CompareType.EQUALS));
        viewVoucher.setFilter(filter);
        VoucherCollection voucherCol = iVoucher.getVoucherCollection(viewVoucher);
        if (voucherCol.size() > 0) {
            voucherid = voucherCol.get(0).getId().toString();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("voucherid", voucherid);
        return map;
    }
}

