/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.codingrule.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleCollection;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleFactory;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.CodingRuleMultiOrgCollection;
import com.kingdee.eas.base.codingrule.CodingRuleMultiOrgFactory;
import com.kingdee.eas.base.codingrule.ICodingRule;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.app.AbstractCodingRuleListUI_DefineHandler;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.util.Date;
import org.apache.log4j.Logger;

public class CodingRuleListUI_DefineHandler
extends AbstractCodingRuleListUI_DefineHandler {
    private static Logger logger = Logger.getLogger(CodingRuleListUI_DefineHandler.class);
    private Context _context = null;

    @Override
    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleInit(request, response, context);
    }

    public boolean enableCodingRule(ICodingRule codRule, CodingRuleInfo codRuleInfo, Context ctx) throws BOSException {
        String strMsg = "";
        String strCRID = codRuleInfo.getId().toString();
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("businessObjectID", (Object)codRuleInfo.getBusinessObjectID()));
        filter.getFilterItems().add(new FilterItemInfo("isEnabled", (Object)true));
        if (!StringUtils.isEmpty((String)codRuleInfo.getCustomProperty())) {
            filter.getFilterItems().add(new FilterItemInfo("customProperty", (Object)codRuleInfo.getCustomProperty()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("customProperty", null));
        }
        FilterInfo oldFilterInfo = (FilterInfo)filter.clone();
        evi.setFilter(filter);
        CodingRuleCollection codRuleCollection = codRule.getCodingRuleCollection(evi);
        if (codRuleCollection.size() == 0) {
            strMsg = "Msg_BeSureEnable";
        } else {
            if (codRuleInfo.getBindingProperty() != null) {
                filter.getFilterItems().add(new FilterItemInfo("bindingProperty.propertyName", (Object)codRuleInfo.getBindingProperty().getPropertyName()));
                filter.getFilterItems().add(new FilterItemInfo("bindingProperty.propertyValue", (Object)codRuleInfo.getBindingProperty().getPropertyValue().toString()));
                oldFilterInfo.getFilterItems().add(new FilterItemInfo("bindingProperty.propertyName", (Object)codRuleInfo.getBindingProperty().getPropertyName()));
                oldFilterInfo.getFilterItems().add(new FilterItemInfo("bindingProperty.propertyValue", (Object)codRuleInfo.getBindingProperty().getPropertyValue().toString()));
                evi.setFilter(filter);
                codRuleCollection = codRule.getCodingRuleCollection(evi);
            }
            if ((codRuleCollection = codRuleInfo.getBindingProExtent().size() > 0 ? CodingRuleManagerFactory.getLocalInstance(this._context).checkMoreAdapt(codRuleInfo) : CodingRuleListUI_DefineHandler.checkCodingRuleCollection(codRuleCollection)).size() > 0) {
                this.checkCanEnable(codRuleInfo, codRuleCollection, oldFilterInfo, codRule);
            } else {
                strMsg = "Msg_BeSureEnable";
            }
        }
        return false;
    }

    private String checkCanEnable(CodingRuleInfo codRuleInfo, CodingRuleCollection codRuleCollection, FilterInfo filter, ICodingRule codRule) throws BOSException {
        String strMsg = "false";
        if (codRuleInfo.isGroupFirst()) {
            strMsg = this.checkGroupFirt(codRuleInfo, codRuleCollection);
        } else if (codRuleInfo.isOrgFirst()) {
            strMsg = this.checkOrgFirt(codRuleInfo, codRuleCollection, filter, codRule);
        } else if (codRuleInfo.isMultiOrgFirst()) {
            strMsg = this.checkMultiOrgFirt(codRuleInfo, codRuleCollection, filter, codRule);
        }
        return strMsg;
    }

    private String checkGroupFirt(CodingRuleInfo codRuleInfo, CodingRuleCollection codRuleCollection) {
        String strMsg = "Msg_GroupEnableInsteadAllEnable";
        return strMsg;
    }

    private String getCurrentCuId(Context ctx) {
        return ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
    }

    private String checkOrgFirt(CodingRuleInfo codRuleInfo, CodingRuleCollection codRuleCollection, FilterInfo filter, ICodingRule codRule) throws BOSException {
        String strMsg = "false";
        if (codRuleCollection.size() == 1 && codRuleCollection.get(0).isGroupFirst() && "00000000-0000-0000-0000-000000000000CCE7AED4".equals(codRuleCollection.get(0).getAppOrgUnit().getId().toString())) {
            if ("00000000-0000-0000-0000-000000000000CCE7AED4".equals(this.getCurrentCuId(this._context))) {
                return "Msg_OrgEnableInsteadGroupEnable";
            }
            return "false";
        }
        CodingRuleMultiOrgCollection orgCol = this.getMultiOrgCRs(codRuleInfo.getAppOrgUnit().getId().toString());
        for (int orgIndex = 0; orgIndex < orgCol.size(); ++orgIndex) {
            CodingRuleInfo tmpCr = orgCol.get(orgIndex).getCodingrule();
            if (!codRuleInfo.getBusinessObject().equalsIgnoreCase(tmpCr.getBusinessObject()) || !tmpCr.isIsEnabled() || tmpCr.getBindingProperty() != null && codRuleInfo.getBindingProperty() != null && !tmpCr.getBindingProperty().getPropertyValue().equals(codRuleInfo.getBindingProperty().getPropertyValue()) || !tmpCr.isIsEnabled()) continue;
            return "false";
        }
        filter.getFilterItems().add(new FilterItemInfo("appOrgUnit", (Object)codRuleInfo.getAppOrgUnit().getId().toString()));
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        evi.setFilter(filter);
        CodingRuleCollection temp = codRule.getCodingRuleCollection(evi);
        temp = codRuleInfo.getBindingProExtent().size() > 0 ? CodingRuleManagerFactory.getLocalInstance(this._context).checkMoreAdapt(codRuleInfo) : CodingRuleListUI_DefineHandler.checkCodingRuleCollection(temp);
        strMsg = temp.size() == 0 ? "Msg_BeSureEnable" : "Msg_OrgEnableInsteadSameOrgEnable";
        return strMsg;
    }

    private String checkMultiOrgFirt(CodingRuleInfo codRuleInfo, CodingRuleCollection codRuleCollection, FilterInfo filter, ICodingRule codRule) throws BOSException {
        String strMsg = "false";
        if (codRuleCollection.size() == 1 && codRuleCollection.get(0).isGroupFirst() && "00000000-0000-0000-0000-000000000000CCE7AED4".equals(codRuleCollection.get(0).getAppOrgUnit().getId().toString())) {
            if ("00000000-0000-0000-0000-000000000000CCE7AED4".equals(this.getCurrentCuId(this._context))) {
                return "false";
            }
            return "false";
        }
        StringBuffer strOrgs = new StringBuffer("");
        for (int orgIndex = 0; orgIndex < codRuleInfo.getMultiOrg().size(); ++orgIndex) {
            if (codRuleInfo.getMultiOrg().get(orgIndex).isIsMainOrg()) continue;
            if (strOrgs.length() > 0) {
                strOrgs.append(",");
            }
            strOrgs.append(codRuleInfo.getMultiOrg().get(orgIndex).getAppOrgUnit().getId().toString());
        }
        StringBuffer strInfoMsg = new StringBuffer("");
        CodingRuleMultiOrgCollection orgCol = this.getMultiOrgCRs(strOrgs.toString());
        for (int orgIndex = 0; orgIndex < orgCol.size(); ++orgIndex) {
            CodingRuleInfo tmpCr = orgCol.get(orgIndex).getCodingrule();
            if (!codRuleInfo.getBusinessObject().equalsIgnoreCase(tmpCr.getBusinessObject()) || !tmpCr.isIsEnabled() || tmpCr.getBindingProperty() != null && codRuleInfo.getBindingProperty() != null && !tmpCr.getBindingProperty().getPropertyValue().equals(codRuleInfo.getBindingProperty().getPropertyValue())) continue;
            if (strInfoMsg.length() > 0) {
                strInfoMsg.append("\u3001");
            }
            strInfoMsg.append(orgCol.get(orgIndex).getAppOrgUnit().getNumber());
        }
        if (strInfoMsg.length() > 0) {
            return "false";
        }
        filter.getFilterItems().add(new FilterItemInfo("appOrgUnit", (Object)strOrgs.toString(), CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        evi.setFilter(filter);
        codRuleCollection = codRule.getCodingRuleCollection(evi);
        codRuleCollection = codRuleInfo.getBindingProExtent().size() > 0 ? CodingRuleManagerFactory.getLocalInstance(this._context).checkMoreAdapt(codRuleInfo) : CodingRuleListUI_DefineHandler.checkCodingRuleCollection(codRuleCollection);
        strMsg = codRuleCollection.size() == 0 ? "Msg_BeSureEnable" : "Msg_MultiOrgFirstCREnabling";
        return strMsg;
    }

    private static CodingRuleCollection checkCodingRuleCollection(CodingRuleCollection col) {
        CodingRuleCollection tmp = (CodingRuleCollection)((Object)col.clone());
        for (int i = 0; i < col.size(); ++i) {
            if (col.get(0).getBindingProExtent() == null || col.get(0).getBindingProExtent().size() < 1) continue;
            tmp.remove(col.get(0));
        }
        return tmp;
    }

    private CodingRuleMultiOrgCollection getMultiOrgCRs(String strOrgs) throws BOSException {
        EntityViewInfo tmpevi = new EntityViewInfo();
        tmpevi.getSelector().add("codingrule.*");
        tmpevi.getSelector().add("appOrgUnit.*");
        tmpevi.getSelector().add("codingrule.bindingProperty.*");
        FilterInfo tmpfilter = new FilterInfo();
        tmpfilter.getFilterItems().add(new FilterItemInfo("appOrgUnit", (Object)strOrgs, CompareType.INCLUDE));
        tmpfilter.getFilterItems().add(new FilterItemInfo("isMainOrg", (Object)true, CompareType.NOTEQUALS));
        tmpevi.setFilter(tmpfilter);
        CodingRuleMultiOrgCollection orgCol = CodingRuleMultiOrgFactory.getLocalInstance(this._context).getCodingRuleMultiOrgCollection(tmpevi);
        return orgCol;
    }

    private static boolean crEnable(KDTable table, Component comp, CodingRuleInfo codingRule, String strMsg) {
        return false;
    }

    private CodingRuleMultiOrgCollection getMultiOrgCRs(String strOrgs, Context context) throws BOSException {
        EntityViewInfo tmpevi = new EntityViewInfo();
        tmpevi.getSelector().add("codingrule.*");
        tmpevi.getSelector().add("appOrgUnit.*");
        tmpevi.getSelector().add("codingrule.bindingProperty.*");
        FilterInfo tmpfilter = new FilterInfo();
        tmpfilter.getFilterItems().add(new FilterItemInfo("appOrgUnit", (Object)strOrgs, CompareType.INCLUDE));
        tmpfilter.getFilterItems().add(new FilterItemInfo("isMainOrg", (Object)true, CompareType.NOTEQUALS));
        tmpevi.setFilter(tmpfilter);
        CodingRuleMultiOrgCollection orgCol = CodingRuleMultiOrgFactory.getLocalInstance(context).getCodingRuleMultiOrgCollection(tmpevi);
        return orgCol;
    }

    protected boolean chechCuOrgBeforeAction(String action, String cuid, String id, Context context) throws Exception {
        boolean canDoAction = false;
        if ("update".equalsIgnoreCase(action)) {
            if (cuid != null) {
                canDoAction = cuid.equals(this.getCurrentCuId(context));
            } else {
                String codingRuleId = id;
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)codingRuleId));
                SelectorItemCollection sc = new SelectorItemCollection();
                sc.add(new SelectorItemInfo("CU"));
                ICodingRule iCR = CodingRuleFactory.getLocalInstance(context);
                CodingRuleInfo cr = iCR.getCodingRuleInfo((IObjectPK)pk, sc);
                canDoAction = cr.getCU().getId().toString().equals(this.getCurrentCuId(context));
            }
        }
        return canDoAction;
    }

    @Override
    protected void _handleActionEnabled(RequestContext request, ResponseContext response, Context context) throws Exception {
        String selectId = (String)request.get("selectid");
        String selectCuId = (String)request.get("cuid");
        this._context = context;
        if (selectId == null || selectCuId == null) {
            return;
        }
        if (!this.chechCuOrgBeforeAction("update", selectCuId, selectId, context)) {
            return;
        }
        ICodingRule codRule = CodingRuleFactory.getLocalInstance(context);
        CodingRuleInfo codRuleInfo = codRule.getCodingRuleInfo((IObjectPK)new ObjectUuidPK(selectId));
        this.enableCodingRule(codRule, codRuleInfo, context);
    }

    @Override
    protected void _handleActionDisabled(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    public void handleCallHandlerEabled(RequestContext request, ResponseContext response, Context context) throws Exception {
        String codingRuleId = (String)request.get("codingRuleId");
        boolean isCustomProperty = (Boolean)request.get("isCustomProperty");
        Date enableDate = (Date)request.get("enableDate");
        try {
            if (isCustomProperty) {
                ICodingRuleManager iCRM = CodingRuleManagerFactory.getLocalInstance(context);
                if (codingRuleId != null && codingRuleId.trim().length() > 0) {
                    try {
                        iCRM.enabledCodingRule(codingRuleId);
                    }
                    catch (CodingRuleException codingRuleException) {}
                }
            } else {
                this.setupCodingRuleState(true, enableDate, codingRuleId, context);
            }
        }
        catch (Exception err) {
            logger.error((Object)("prepare enable error:" + err));
        }
    }

    private void setupCodingRuleState(boolean isEnable, Date date, String id, Context context) throws Exception {
        CodingRuleInfo info = CodingRuleFactory.getLocalInstance(context).getCodingRuleInfo((IObjectPK)new ObjectUuidPK(id));
        info.setIsEnabled(isEnable);
        if (isEnable) {
            info.setEnabledDate(date);
        } else {
            info.setDisabledDate(date);
        }
        CodingRuleManagerFactory.getLocalInstance(context).controlCustomProperty(info);
    }
}

