/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.log.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.commonquery.CustomerParams;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QueryPanelTypeEnum;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.ShareTypeEnum;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.log.AppLogFactory;
import com.kingdee.eas.base.log.AppLogInfo;
import com.kingdee.eas.base.log.HisLogFactory;
import com.kingdee.eas.base.log.HisLogInfo;
import com.kingdee.eas.base.log.IAppLog;
import com.kingdee.eas.base.log.IHisLog;
import com.kingdee.eas.base.log.LogException;
import com.kingdee.eas.base.log.LogInfo;
import com.kingdee.eas.base.log.LogType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.log.client.AbstractLogAppUI;
import com.kingdee.eas.base.log.client.ExcelFileFilter;
import com.kingdee.eas.base.log.client.LogQueryPanelUI;
import com.kingdee.eas.base.log.client.LogSettingUI;
import com.kingdee.eas.base.log.common.Resource;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

public class LogAppUI
extends AbstractLogAppUI {
    public static final int CURRENT = 1;
    public static final int HISTORY = 2;
    public static final int MAXlOGNUM = 100000;
    private static final Integer AUDITADMIN_TYPE = new Integer(70);
    private static final Integer AUTHENTICATEADMIN_TYPE = new Integer(60);
    private static final Integer SYSTEM_TYPE = new Integer(10);
    private static final int DEFAULT_LOG_COUNT = 5000;
    IAppLog appLog = null;
    IHisLog hisLog = null;
    String[] hisHeader = new String[]{"id", "userNumber", "userName", "userType", "clientIP", "clientName", "entityAlias", "companyName", "instanceNo", "operation", "isSuccessed", "occurTime", "Item.type", "cuID"};
    String[] appHeader = new String[]{"id", "userNumber", "userName", "userType", "clientIP", "clientName", "entityAlias", "companyName", "instanceNo", "operation", "isSuccessed", "occurTime", "Item.type", "cuID"};
    protected IMetaDataPK appPk = new MetaDataPK("com.kingdee.eas.base.log.app", "ItemAppQuery");
    protected IMetaDataPK hisPk = new MetaDataPK("com.kingdee.eas.base.log.app", "ItemHisQuery");
    int flag = 1;
    boolean isBoChanged = false;
    private HashMap ctx = null;
    private FilterInfo currentFilterInfo = null;
    private boolean confirm = false;
    private int logNumber = 5000;
    private CommonQueryDialog commonQueryDialog = null;

    @Override
    public void loadFields() {
        super.loadFields();
        this.tblMain.getViewManager().setFreezeView(0, 3);
        this.tblMain.requestFocusInWindow();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.put("flag", (Object)String.valueOf(this.flag));
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    @Override
    public boolean isPrepareInit() {
        return false;
    }

    public void onLoad() throws Exception {
        this.btnDel.setVisible(false);
        this.menuItemDel.setVisible(false);
        IObjectPK pk = null;
        pk = this.flag == 1 ? LogUtil.beginLog(null, Resource.VIEW_LOGS, new AppLogInfo().getBOSType(), null, Resource.VIEW_LOGS) : LogUtil.beginLog(null, Resource.VIEW_LOGS, new HisLogInfo().getBOSType(), null, Resource.VIEW_LOGS);
        super.onLoad();
        this.init();
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = LogAppUI.getQueryInfo((IMetaDataPK)this.appPk).getFullName();
        if (!this.isPerformDefaultQuery(iQuery, queryName)) {
            this.tblMain.checkParsed();
            this.showQueryDialog();
        }
        if (this.mainQuery != null) {
            this.currentFilterInfo = this.mainQuery.getFilter();
        }
        LogUtil.afterLog(null, pk);
    }

    private void showQueryDialog() throws Exception {
        if (this.tHelper == null) {
            this.initHelper();
        }
        if (this.commonQueryDialog == null) {
            this.commonQueryDialog = this.initCommonQueryDialog();
        }
        this.tHelper.setDialog(this.commonQueryDialog);
        if (this.commonQueryDialog.show()) {
            FilterInfo aFilter;
            FilterInfo filterInfo;
            LogQueryPanelUI logPanel = (LogQueryPanelUI)((Object)this.commonQueryDialog.getCommonQueryParam().getPanels().get(0));
            this.flag = logPanel.getSelectedLogType() == 1 ? 1 : 2;
            EntityViewInfo resultEv = this.commonQueryDialog.getEntityViewInfoResult();
            if (resultEv == null || resultEv.getTopCount() == 0) {
                // empty if block
            }
            FilterInfo filterInfo2 = filterInfo = resultEv == null ? null : resultEv.getFilter();
            if (filterInfo != null && (aFilter = this.getDefaultFilterForQuery()) != null && aFilter.getFilterItems().size() > 0) {
                if (filterInfo.getFilterItems().size() > 0) {
                    filterInfo.mergeFilter(aFilter, "AND");
                } else {
                    filterInfo = aFilter;
                }
            }
            this.doQuery(this.commonQueryDialog);
            this.currentFilterInfo = filterInfo;
            if (this.flag == 1) {
                this.showAppLog();
            } else {
                this.showHisLog();
            }
        } else if (this.mainQuery.getTopCount() == 0) {
            // empty if block
        }
    }

    private EntityViewInfo getViewInfoWhenNoSolution() {
        Date currentDate = new Date(System.currentTimeMillis());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        calendar.add(2, -1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date lastMonth = calendar.getTime();
        FilterInfo filter = new FilterInfo();
        Timestamp dateFrom = new Timestamp(lastMonth.getTime());
        filter.getFilterItems().add(new FilterItemInfo("occurTime", (Object)dateFrom, CompareType.GREATER_EQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private void init() throws EASBizException, BOSException {
        String format = CtrlFormatUtilities.getDateTimeFormatString();
        this.tblMain.getColumn("occurTime").getStyleAttributes().setNumberFormat(format);
        this.setUITitle(Resource.SYSLOG);
        this.showMessageBar(this.flag == 1 ? Resource.APPLOG : Resource.HISLOG);
        Icon findPutBG = EASResource.getIcon((String)"imgTbtn_filter");
        this.btnFind.setIcon(findPutBG);
        Icon refreshPutBG = EASResource.getIcon((String)"imgTbtn_refresh");
        this.btnRefresh.setIcon(refreshPutBG);
        Icon outPutBG = EASResource.getIcon((String)"imgTbtn_output");
        this.btnOutput.setIcon(outPutBG);
        Icon transferBG = EASResource.getIcon((String)"imgTbtn_move");
        this.btnDump.setIcon(transferBG);
        this.btnHistory.setIcon(EASResource.getIcon((String)"imgTbtn_demandhistorydata"));
        this.btnCurrent.setIcon(EASResource.getIcon((String)"imgTbtn_demandnoncedata"));
        this.setButtonDefaultStyl(this.btnDel);
        Icon delPutBG = EASResource.getIcon((String)"imgTbtn_delete");
        this.btnDel.setIcon(delPutBG);
        this.actionAddNew.setEnabled(false);
        this.actionEdit.setEnabled(false);
        this.actionRemove.setEnabled(false);
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(10);
        KDTMenuManager tm = this.getMenuManager(this.tblMain);
        if (tm == null) {
            tm = new KDTMenuManager(this.tblMain);
        }
        KDPopupMenu popupMenu = tm.getMenu();
        popupMenu.remove(0);
        this.btnFind.setEnabled(false);
        this.btnFind.setVisible(false);
        this.btnDump.setEnabled(true);
        this.btnOutput.setEnabled(true);
        this.btnCurrent.setVisible(false);
        this.menuItemCurrent.setVisible(false);
        this.btnHistory.setVisible(false);
        this.menuItemHistory.setVisible(false);
        this.btnLocate.setVisible(false);
        this.menuItemLocate.setVisible(false);
        this.actionLocate.setEnabled(false);
        this.separatorView1.setVisible(false);
        this.menuItemExitCurrent.setIcon(EASResource.getIcon((String)"imgTbtn_quit"));
        this.menuItemDel.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.menuItemOutput.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.menuItemDump.setIcon(EASResource.getIcon((String)"imgTbtn_move"));
        this.menuItemLogSetting.setIcon(EASResource.getIcon((String)"imgTbtn_advancedsetting"));
    }

    public HashMap getCtx() {
        if (this.ctx == null) {
            this.ctx = new HashMap();
        }
        return this.ctx;
    }

    @Override
    public void actionCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionCurrent_actionPerformed(e);
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = LogAppUI.getQueryInfo((IMetaDataPK)this.appPk).getFullName();
        EntityViewInfo ev = (EntityViewInfo)iQuery.getDefaultFilterInfo(((Object)((Object)this)).getClass().getName(), queryName);
        this.currentFilterInfo = ev != null ? ev.getFilter() : null;
        this.showAppLog();
    }

    @Override
    public void actionHistory_actionPerformed(ActionEvent e) throws Exception {
        FilterInfo filterInfo;
        super.actionHistory_actionPerformed(e);
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = LogAppUI.getQueryInfo((IMetaDataPK)this.hisPk).getFullName();
        EntityViewInfo ev = (EntityViewInfo)iQuery.getDefaultFilterInfo(((Object)((Object)this)).getClass().getName(), queryName);
        if (ev != null) {
            String filter = null;
            filterInfo = ev.getFilter();
            if (filterInfo != null) {
                filter = filterInfo.toString().trim();
            }
            if (this.isAllowQuery(2, filter)) {
                this.currentFilterInfo = filterInfo;
                this.showHisLog();
                return;
            }
            int relV = MsgBox.showConfirm2((Component)((Object)this), (String)Resource.CHANGE_SPAN);
            if (MsgBox.isCancel((int)relV)) {
                return;
            }
        }
        CommonQueryDialog commonQueryDialog = new CommonQueryDialog();
        commonQueryDialog.setParentUIClassName(((Object)((Object)this)).getClass().getName());
        commonQueryDialog.setQueryObjectPK(this.hisPk);
        commonQueryDialog.setOwner((Component)((Object)this));
        commonQueryDialog.setTitle(Resource.HIS_LOG_FILTER);
        commonQueryDialog.setShowFilter(true);
        commonQueryDialog.setShowSorter(false);
        commonQueryDialog.setShowToolbar(true);
        if (commonQueryDialog.show()) {
            filterInfo = commonQueryDialog.getEntityViewInfoResult() == null ? null : commonQueryDialog.getEntityViewInfoResult().getFilter();
            String filter = null;
            if (filterInfo != null) {
                filter = filterInfo.toString().trim();
            }
            if (this.isAllowQuery(2, filter)) {
                this.currentFilterInfo = filterInfo;
                this.showHisLog();
            } else {
                MsgBox.showInfo((String)Resource.TIME_SPAN);
            }
        }
    }

    private void showAppLog() throws BOSException, EASBizException {
        this.flag = 1;
        this.mainQueryPK = this.appPk;
        if (this.currentFilterInfo != null) {
            this.mainQuery.setFilter(this.currentFilterInfo);
        }
        this.tblMain.putBindContents("mainQuery", this.appHeader);
        this.tblMain.removeRows();
        if (!Administrator.isCUAdmin(null, (IObjectPK)this.getUserPk())) {
            this.menuItemDump.setVisible(false);
            this.btnDump.setVisible(false);
        } else {
            this.menuItemDump.setVisible(true);
            this.btnDump.setVisible(true);
        }
        this.showMessageBar(Resource.APPLOG);
    }

    private void showHisLog() throws BOSException {
        this.flag = 2;
        this.mainQueryPK = this.hisPk;
        this.mainQuery.setFilter(this.currentFilterInfo);
        this.tblMain.putBindContents("mainQuery", this.hisHeader);
        this.tblMain.removeRows();
        this.btnDump.setVisible(false);
        this.menuItemDump.setVisible(false);
        this.showMessageBar(Resource.HISLOG);
    }

    private void showMessageBar(String message) {
        final KDLabel barLabel = this.getMainStatusBar().getMsgLabel();
        barLabel.setForeground(SHOW_MESSAGE_FG_DEFAULT);
        final Color bg = this.getMessageBgcolor();
        barLabel.setIcon(this.getMessageIcon());
        barLabel.setText(message);
        if (bg != null && !this.isShowTextOnly()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < 3; ++i) {
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    barLabel.setBackground(bg);
                                    barLabel.setOpaque(true);
                                    barLabel.repaint();
                                }
                            });
                            Thread.sleep(200L);
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    barLabel.setOpaque(false);
                                    barLabel.repaint();
                                }
                            });
                            Thread.sleep(200L);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }).start();
        }
        barLabel.setText(message);
    }

    public void setLogNumber(int logNum) {
        this.logNumber = logNum;
    }

    @Override
    public void actionOutPut_actionPerformed(ActionEvent e) throws Exception {
        KDFileChooser fileChooser = new KDFileChooser(System.getProperty("user.dir"));
        fileChooser.addChoosableFileFilter((FileFilter)new ExcelFileFilter());
        int reValue = fileChooser.showSaveDialog((Component)((Object)this));
        if (reValue == 0) {
            int relV;
            File file = fileChooser.getSelectedFile();
            String path = file.getAbsolutePath();
            FileFilter ext = fileChooser.getFileFilter();
            if (ext != null && !ext.accept(file)) {
                if (ext instanceof ExcelFileFilter) {
                    path = path + ".xls";
                }
                file = new File(path);
            }
            if (file.exists() && MsgBox.isCancel((int)(relV = MsgBox.showConfirm2((Component)fileChooser, (String)(Resource.FILE + file.getName() + Resource.HAVE_EXISTED + "," + Resource.IS_COVERED + "?"))))) {
                return;
            }
            if (!file.getName().endsWith(".xls")) {
                MsgBox.showInfo((String)Resource.EXCEL_FILE);
                return;
            }
            String filter = null;
            if (this.currentFilterInfo != null) {
                filter = this.currentFilterInfo.toString().trim();
            }
            IObjectPK pk = null;
            pk = this.flag == 1 ? LogUtil.beginLog(null, Resource.EXPORT_LOGS, new AppLogInfo().getBOSType(), null, Resource.EXPORT_LOGS) : LogUtil.beginLog(null, Resource.EXPORT_LOGS, new HisLogInfo().getBOSType(), null, Resource.EXPORT_LOGS);
            int totalNumber = this.getAppLog().getLogNumberByFilter(this.flag, filter);
            this.exportToExcelMultiTimes(file, filter, totalNumber, this.logNumber);
            LogUtil.afterLog(null, pk);
            MsgBox.showInfo((Component)((Object)this), (String)Resource.Export_SUCCESS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportToExcelMultiTimes(File file, String filter, int totalNumber, int logNumber) throws Exception {
        FileOutputStream fos = null;
        this.getAppLog().setLogNumber(logNumber);
        HSSFWorkbook workbook = null;
        HSSFSheet sheet = null;
        List logInfoList = null;
        try {
            fos = new FileOutputStream(file);
            workbook = new HSSFWorkbook();
            sheet = workbook.createSheet();
            workbook.setSheetName(0, Resource.LOG);
            int loops = totalNumber / logNumber;
            if (loops * logNumber < totalNumber) {
                ++loops;
            }
            int filePostfix = 1;
            File newFile = null;
            for (int i = 1; i <= loops; ++i) {
                logInfoList = i < loops ? this.getAppLog().getLogInfoListBetween(this.flag, filter, (i - 1) * logNumber + 1, i * logNumber) : this.getAppLog().getLogInfoListBetween(this.flag, filter, (i - 1) * logNumber + 1, totalNumber);
                this.exportLogInfoListToSheet(sheet, logInfoList);
                if (logInfoList != null) {
                    logInfoList.clear();
                }
                logInfoList = null;
                if (fos != null) {
                    workbook.write((OutputStream)fos);
                    fos.flush();
                    fos.close();
                }
                fos = null;
                if (workbook != null && sheet != null) {
                    for (int j = sheet.getFirstRowNum(); j <= sheet.getLastRowNum(); ++j) {
                        HSSFRow row = sheet.getRow(j);
                        if (row == null) continue;
                        for (short k = row.getFirstCellNum(); k <= row.getLastCellNum(); k = (short)(k + 1)) {
                            HSSFCell cell = row.getCell((int)k);
                            if (cell == null) continue;
                            row.removeCell((Cell)cell);
                            cell = null;
                        }
                        sheet.removeRow((Row)row);
                        row = null;
                    }
                    workbook.removeSheetAt(0);
                    sheet = null;
                    workbook = null;
                }
                if (i == loops) continue;
                String filePath = file.getAbsolutePath();
                int index = filePath.lastIndexOf(".xls");
                if (index > 0) {
                    filePath = filePath.substring(0, index);
                }
                newFile = new File(filePath + "_" + filePostfix + ".xls");
                while (newFile.exists()) {
                    newFile = new File(filePath + "_" + ++filePostfix + ".xls");
                }
                fos = new FileOutputStream(newFile);
                workbook = new HSSFWorkbook();
                sheet = workbook.createSheet();
                workbook.setSheetName(0, Resource.LOG);
            }
        }
        catch (FileNotFoundException e) {
            MsgBox.showInfo((String)Resource.FILE_OPEN);
            return;
        }
        catch (Throwable e) {
            this.handUIException(e);
        }
        finally {
            if (fos != null) {
                fos.flush();
                fos.close();
            }
            if (workbook != null) {
                workbook.close();
            }
            this.getAppLog().clearLogInfoList();
        }
    }

    private void exportLogInfoListToSheet(HSSFSheet sheet, List logInfoList) throws Exception {
        int rowNum = sheet.getLastRowNum();
        HSSFRow row = null;
        HSSFCell[] cells = new HSSFCell[9];
        if (rowNum == -1) {
            rowNum = 0;
        }
        if (rowNum == 0) {
            row = sheet.createRow(0);
            for (int i = 0; i < 9; i = (int)((short)(i + 1))) {
                cells[i] = row.createCell(i);
            }
            cells[0].setCellValue(Resource.USER_NAME);
            cells[1].setCellValue(Resource.COMPANY);
            cells[2].setCellValue(Resource.CLIENT_IP);
            cells[3].setCellValue(Resource.CLIENT_NAME);
            cells[4].setCellValue(Resource.FUNCTION);
            cells[5].setCellValue(Resource.OPERATE_OBJECT);
            cells[6].setCellValue(Resource.OPERATION);
            cells[7].setCellValue(Resource.TIME);
            cells[8].setCellValue(Resource.LOG_TYPE);
            row = sheet.createRow(++rowNum);
        }
        for (LogInfo logInfo : logInfoList) {
            String ins;
            row = sheet.getRow(rowNum);
            for (int i = 0; i < 9 && row != null; i = (int)((short)(i + 1))) {
                cells[i] = row.createCell(i);
            }
            cells[0].setCellValue(logInfo.getUserName());
            cells[1].setCellValue(logInfo.getCompanyName());
            cells[2].setCellValue(logInfo.getClientIP());
            cells[3].setCellValue(logInfo.getClientName());
            cells[4].setCellValue(logInfo.getEntityAlias());
            if (logInfo.getInstanceNo() != null) {
                // empty if block
            }
            if ((ins = logInfo.getInstanceNo()).startsWith("=") || ins.startsWith("@") || ins.startsWith("+") || ins.startsWith("-")) {
                ins = "'" + ins;
            }
            cells[5].setCellValue(ins);
            cells[6].setCellValue(logInfo.getItemAlias());
            cells[7].setCellValue(logInfo.getOccurTime().toString());
            int type = logInfo.getItemType();
            LogType logType = LogType.getEnum(type);
            cells[8].setCellValue(logType.getAlias());
            row = sheet.createRow(++rowNum);
        }
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        if (viewInfo == null || viewInfo.getFilter() == null || viewInfo.getFilter().getFilterItems() == null || viewInfo.getFilter().getFilterItems().size() == 0) {
            this.mainQuery = this.getViewInfoWhenNoSolution();
            this.currentFilterInfo = this.mainQuery.getFilter();
            viewInfo.setFilter(this.mainQuery.getFilter());
        }
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    public IAppLog getAppLog() throws Exception {
        if (this.appLog == null) {
            this.appLog = AppLogFactory.getRemoteInstance();
        }
        return this.appLog;
    }

    public IHisLog getHisLog() throws Exception {
        if (this.hisLog == null) {
            this.hisLog = HisLogFactory.getRemoteInstance();
        }
        return this.hisLog;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = new CommonQueryDialog();
        if (this.getUIWindow() == null) {
            dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            dialog.setOwner((Component)((Object)this));
        }
        dialog.setUiObject((IUIObject)this);
        dialog.setParentUIClassName(((Object)((Object)this)).getClass().getName());
        dialog.setQueryObjectPK(this.appPk);
        dialog.setTitle(Resource.LOG_SEARCH);
        dialog.setShowShareType(16);
        dialog.setCurrentShareType(ShareTypeEnum.USER_NOORG_LEVEL);
        try {
            LogQueryPanelUI logPanel = new LogQueryPanelUI(this.flag);
            dialog.addUserPanel((KDPanel)logPanel);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        dialog.setWidth(600);
        dialog.setHeight(400);
        dialog.setShowFilter(true);
        dialog.setShowSorter(false);
        dialog.setShowToolbar(true);
        return dialog;
    }

    public IUIActionPostman prepareQuery(RequestRowSetEvent e) {
        IUIActionPostman handler = super.prepareQuery(e);
        RequestContext request = this.prepareQueryContext(e);
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    private void prepareAllowQuery(int flag, String filter) throws Exception {
        IUIActionPostman clientHanlder = super.prepareInit();
        RequestContext request = new RequestContext();
        request.setMethodName("_handleAllowQuery");
        request.put("flag", (Object)String.valueOf(flag));
        request.put("filter", (Object)filter);
        clientHanlder.setRequestContext((Serializable)request);
        clientHanlder.callHandler();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        String queryName;
        if (this.isFirstDefaultQuery()) {
            return;
        }
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        if (!this.isPerformDefaultQuery(iQuery, queryName = LogAppUI.getQueryInfo((IMetaDataPK)this.appPk).getFullName())) {
            this.showQueryDialog();
        }
    }

    protected void doDefaultSolution(IQuerySolutionFacade query, String queryName) throws Exception {
        super.doDefaultSolution(query, queryName);
        if (this.getCurrentSolutionInfo() != null) {
            QueryPanelInfo queryPanelInfo = this.getQueryPanelInfoByTypeAndClassName(this.getCurrentSolutionInfo(), QueryPanelTypeEnum.CUSTOMER_PANEL, "com.kingdee.eas.base.log.client.LogQueryPanelUI");
            if (queryPanelInfo == null) {
                this.showAppLog();
                return;
            }
            String customerParams = queryPanelInfo.getCustomerParams();
            CustomerParams cp = new CustomerParams();
            cp = XMLBean.transStrToCommonCustParams((String)customerParams);
            String flag = cp.getCustomerParam("flag");
            if ("1".equals(flag)) {
                this.showAppLog();
            } else {
                this.showHisLog();
            }
        }
    }

    private QueryPanelInfo getQueryPanelInfoByTypeAndClassName(QuerySolutionInfo querySolutionInfo, QueryPanelTypeEnum panelType, String className) {
        QueryPanelCollection queryPanelCollection = querySolutionInfo.getQueryPanelInfo();
        int size = queryPanelCollection.size();
        for (int i = 0; i < size; ++i) {
            QueryPanelInfo queryPanelInfo = queryPanelCollection.get(i);
            if (!panelType.equals((Object)queryPanelInfo.getQueryPanelType()) || !className.equals(queryPanelInfo.getPanelClassName())) continue;
            return queryPanelInfo;
        }
        return null;
    }

    private boolean isAllowQuery(int flag, String filter) throws Exception {
        this.prepareAllowQuery(flag, filter);
        int num = this.getAppLog().getLogNumberByFilter(flag, filter);
        return num <= 100000;
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        this.getCtx().put("Owner", this);
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow uiWindow = uiFactory.create("com.kingdee.eas.base.log.client.DeleteLogUI", (Map)this.getCtx());
            uiWindow.show();
        }
        catch (UIException ex) {
            this.handUIException(ex);
        }
    }

    @Override
    public void actionDump_actionPerformed(ActionEvent e) throws Exception {
        this.getCtx().put("Owner", this);
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow uiWindow = uiFactory.create("com.kingdee.eas.base.log.client.LogDupUI", (Map)this.getCtx());
            uiWindow.show();
        }
        catch (UIException ex) {
            this.handUIException(ex);
        }
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterRet;
        block13: {
            FilterInfo filter = null;
            filterRet = null;
            UserInfo currentUser = SysContext.getSysContext().getCurrentUserInfo();
            ObjectUuidPK userPK = new ObjectUuidPK(currentUser.getId());
            UserType userType = currentUser.getType();
            try {
                if (Administrator.isAdminType((UserType)userType) || LogUtil.isBizAdmin()) {
                    filter = new FilterInfo();
                    filterRet = new FilterInfo();
                    if (PermissionCommonUtil.isAuditAdminEnabled(null)) {
                        Integer[] userTypes;
                        if (UserType.AUDITADMIN.equals((Object)userType)) {
                            filterRet.getFilterItems().add(new FilterItemInfo("userID.bizAdmin", (Object)new Integer(1)));
                            userTypes = new Integer[]{SYSTEM_TYPE, AUTHENTICATEADMIN_TYPE, AUDITADMIN_TYPE};
                            HashSet<Integer> userTypeSet = new HashSet<Integer>();
                            userTypeSet.addAll(Arrays.asList(userTypes));
                            filter.getFilterItems().add(new FilterItemInfo("userID.type", userTypeSet, CompareType.INCLUDE));
                            filterRet.mergeFilter(filter, "or");
                        } else {
                            filterRet.getFilterItems().add(new FilterItemInfo("userID.bizAdmin", (Object)new Integer(1), CompareType.NOTEQUALS));
                            userTypes = new Integer[]{SYSTEM_TYPE, AUTHENTICATEADMIN_TYPE, AUDITADMIN_TYPE};
                            HashSet<Integer> userTypeSet = new HashSet<Integer>();
                            userTypeSet.addAll(Arrays.asList(userTypes));
                            filter.getFilterItems().add(new FilterItemInfo("userID.type", userTypeSet, CompareType.NOTINCLUDE));
                            filterRet.mergeFilter(filter, "and");
                        }
                    }
                    String[] cuids = null;
                    if (LogUtil.isBizAdmin()) {
                        cuids = LogUtil.getDefaultFilter((IObjectPK)userPK);
                    } else if (Administrator.isSuperAdmin((IObjectPK)userPK)) {
                        cuids = LogUtil.getAdminCUs((IObjectPK)userPK);
                    }
                    if (LogUtil.isBizAdmin()) {
                        filter.getFilterItems().clear();
                        filter.getFilterItems().add(new FilterItemInfo("cuID", (Object)String.format("SELECT FORGID FROM T_PM_ORGRANGE WHERE FUserID='%s' and FType=%d", userPK.toString(), 30), CompareType.INNER));
                        filterRet.mergeFilter(filter, "and");
                    } else if (Administrator.isSuperAdmin((IObjectPK)userPK)) {
                        filter.getFilterItems().clear();
                        filter.getFilterItems().add(new FilterItemInfo("cuID", (Object)String.format("SELECT FORGID FROM T_PM_ORGRANGE WHERE FUserID='%s'", userPK.toString()), CompareType.INNER));
                        filterRet.mergeFilter(filter, "and");
                    }
                    break block13;
                }
                throw new LogException(LogException.ONLYADMINCANVIEWLOG);
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        return filterRet;
    }

    @Override
    public void actionSycLogItems_actionPerformed(ActionEvent e) throws Exception {
        Window win = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        LongTimeDialog ltd = null;
        ltd = win instanceof Frame ? new LongTimeDialog((Frame)win) : (win instanceof Dialog ? new LongTimeDialog((Dialog)win) : new LongTimeDialog((Frame)new JFrame()));
        ltd.setTitle(EASResource.getString((String)"com.kingdee.eas.base.log.common.LogResource", (String)"logsyncing"));
        ltd.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                try {
                    IAppLog iAppLog = AppLogFactory.getRemoteInstance();
                    iAppLog.sycLogItems();
                }
                catch (Exception e) {
                    LogAppUI.this.handleException(e);
                }
                return new Boolean(true);
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        ltd.show();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getType() == 1 && e.getClickCount() == 2) {
            this.checkSelected();
            UIContext ctx = new UIContext((Object)this);
            ctx.put("logId", this.getSelectedKeyValue());
            ctx.put("flag", new Integer(this.flag));
            try {
                IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                IUIWindow uiWindow = uiFactory.create("com.kingdee.eas.base.log.client.InstanceDetailUI", (Map)ctx);
                uiWindow.show();
            }
            catch (UIException ex) {
                this.handUIException(ex);
            }
        }
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionLogSetting_actionPerformed(ActionEvent e) throws Exception {
        this.getCtx().put("Owner", this);
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow uiWindow = uiFactory.create(LogSettingUI.class.getName(), (Map)this.getCtx());
            uiWindow.show();
        }
        catch (UIException ex) {
            this.handUIException(ex);
        }
    }
}

