/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.log.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.log.client.AbstractLogDupUI;
import com.kingdee.eas.base.log.client.LogAppUI;
import com.kingdee.eas.base.log.common.Resource;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import javax.swing.JButton;

public class LogDupUI
extends AbstractLogDupUI {
    private LogAppUI logAppUI = null;

    public void onLoad() throws Exception {
        super.onLoad();
        try {
            int dumpUpLimit = this.getLogAppUI().getAppLog().getDumpPolicy();
            if (dumpUpLimit < 0) {
                dumpUpLimit = 0;
            }
            this.kDFormattedTextFieldDump.setColumns(4);
            this.kDFormattedTextFieldDump.setValue((Object)new Integer(dumpUpLimit));
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.init();
    }

    private LogAppUI getLogAppUI() {
        if (this.logAppUI == null) {
            this.logAppUI = (LogAppUI)((Object)this.getUIContext().get("Owner"));
        }
        return this.logAppUI;
    }

    private void init() {
        this.progressBar.setStringPainted(true);
        this.progressBar.setString("");
        this.enableComponents();
        this.getDefaultFilterForQuery();
    }

    private void beginProgress() {
        this.disableComponents();
        this.progressBar.setIndeterminate(true);
    }

    private void endProgress() {
        this.enableComponents();
        this.progressBar.setIndeterminate(false);
    }

    private void disableComponents() {
        this.kDButtonConfirm.setEnabled(false);
        this.kDButtonCancel.setEnabled(false);
    }

    private void enableComponents() {
        this.kDButtonConfirm.setEnabled(true);
        this.kDButtonCancel.setEnabled(true);
    }

    @Override
    protected void kDButtonCancel_actionPerformed(ActionEvent e) throws Exception {
        super.kDButtonCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        BigDecimal days = this.kDFormattedTextFieldDump.getBigDecimalValue();
        int d = days.intValue();
        if (d > 10000) {
            MsgBox.showInfo((Component)((Object)this), (String)Resource.RESET_DAYS);
            return;
        }
        new DumpThread(d).start();
    }

    protected JButton getDefaultButton() {
        return this.kDButtonConfirm;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        UserInfo currentUser = SysContext.getSysContext().getCurrentUserInfo();
        FilterInfo filter = new FilterInfo();
        ObjectUuidPK userPK = new ObjectUuidPK(currentUser.getId());
        try {
            if (!Administrator.isCUAdmin(null, (IObjectPK)userPK)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.log.common.LogResource", (String)"onlyAdminCanDumpLog"));
                SysUtil.abort();
            }
            if (Administrator.isSuperCUAdmin((IObjectPK)userPK)) {
                return filter;
            }
            String[] cus = LogUtil.getAdminCUs((IObjectPK)userPK);
            if (cus == null || cus.length == 0) {
                return filter;
            }
            String mask = "";
            for (int i = 0; i < cus.length; ++i) {
                filter.getFilterItems().add(new FilterItemInfo("cuID", (Object)cus[i]));
                mask = mask + "#" + i;
                if (i >= cus.length - 1) continue;
                mask = mask + " or ";
            }
            filter.setMaskString(mask);
        }
        catch (EASBizException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        return filter;
    }

    class DumpThread
    extends Thread {
        private int days;

        public DumpThread(int days) {
            this.days = days;
        }

        @Override
        public void run() {
            try {
                LogDupUI.this.beginProgress();
                LogDupUI.this.progressBar.setString(Resource.ON_DUMPING);
                LogDupUI.this.getLogAppUI().getAppLog().setDumpPolicy(this.days);
                LogDupUI.this.getLogAppUI().getAppLog().dump(this.days);
                LogDupUI.this.getLogAppUI().refreshList();
            }
            catch (Exception e) {
                LogDupUI.this.handUIException(e);
            }
            finally {
                LogDupUI.this.endProgress();
                LogDupUI.this.getUIWindow().close();
            }
        }
    }
}

