/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.log.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.log.LogType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.log.client.AbstractLogQueryPanelUI;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCtrlF7;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;

public class LogQueryPanelUI
extends AbstractLogQueryPanelUI {
    protected EntityViewInfo entityViewInfo = new EntityViewInfo();
    protected FilterInfo filterInfo = new FilterInfo();
    protected SorterItemCollection sorterItemCollection = this.entityViewInfo.getSorter();
    private Object param = null;
    private String panelName = "";
    private CustomerParams customerParams = null;
    private final String SHOW_CURRENT = "1";
    private int flag;
    private NewCtrlF7 ctrlF7 = null;

    public LogQueryPanelUI(int flag) throws Exception {
        this.flag = flag;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initMainBizOrg();
        this.init();
    }

    private void init() {
        if (this.flag == 1) {
            this.radioCurrent.setSelected(true);
        } else {
            this.radioHistory.setSelected(true);
        }
        this.bizPromptCU.setDisplayFormat("$name$");
        this.bizPromptCU.setCommitFormat("$number$");
        this.bizPromptCU.setEditFormat("$number$");
        this.ctrlF7 = new NewCtrlF7((IUIObject)this);
        this.ctrlF7.setMultiSelect(false);
        if (SysContext.getSysContext().getCurrentUserInfo().isBizAdmin()) {
            this.ctrlF7.setIsCUFilter(false);
            this.ctrlF7.setNeedAddOrgRange(false);
            this.ctrlF7.setOuterFilterInfo(LogUtil.outerFilterInfo());
            String treeFilter = LogUtil.treeFilter().toString();
            this.ctrlF7.setExtraTreeFilters(treeFilter);
            this.bizPromptCU.setSelector((KDPromptSelector)this.ctrlF7);
        }
        this.bizPromptCU.setSelector((KDPromptSelector)this.ctrlF7);
        this.bizPromptCU.setEditable(false);
        this.initUserType();
        this.initLogType();
        this.dateFrom.setTimeEnabled(true);
        this.dateTo.setTimeEnabled(true);
        Date currentDate = new Date(System.currentTimeMillis());
        this.dateFrom.setValue((Object)new Timestamp(System.currentTimeMillis() - 86400000L));
        this.dateTo.setValue((Object)currentDate);
        this.bizPromptCU.requestFocusInWindow();
    }

    private void initUserType() {
        DefaultComboBoxModel<UserType> model = new DefaultComboBoxModel<UserType>();
        model.addElement(null);
        Iterator iter = UserType.iterator();
        while (iter.hasNext()) {
            UserType type = (UserType)iter.next();
            model.addElement(type);
        }
        this.comboUserType.setModel(model);
        this.comboUserType.setSelectedIndex(0);
    }

    private void initLogType() {
        DefaultComboBoxModel<LogType> model = new DefaultComboBoxModel<LogType>();
        model.addElement(null);
        Iterator iter = LogType.iterator();
        while (iter.hasNext()) {
            LogType type = (LogType)((Object)iter.next());
            model.addElement(type);
        }
        this.comboLogType.setModel(model);
        this.comboLogType.setSelectedIndex(0);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public FilterInfo getFilterInfo() {
        LogType selectedLogType;
        UserType selectedUserType;
        FilterInfo filter = new FilterInfo();
        String maskString = "";
        int index = 0;
        Object data = this.bizPromptCU.getData();
        if (data != null) {
            if (data instanceof OrgUnitInfo) {
                filter.getFilterItems().add(new FilterItemInfo("cuID", (Object)((OrgUnitInfo)this.bizPromptCU.getData()).getId().toString()));
                maskString = maskString + "#" + index;
                ++index;
            }
            if (data instanceof OrgUnitInfo[]) {
                OrgUnitInfo[] infos = (OrgUnitInfo[])data;
                if (infos.length == 1) {
                    filter.getFilterItems().add(new FilterItemInfo("cuID", (Object)infos[0].getId().toString()));
                    maskString = index == 0 ? maskString + "#" + index : maskString + " and #" + index;
                    ++index;
                } else {
                    for (int i = 0; i < infos.length; ++i) {
                        filter.getFilterItems().add(new FilterItemInfo("cuID", (Object)infos[i].getId().toString()));
                        maskString = index == 0 ? maskString + "(#" + index : (i == 0 ? maskString + " and (#" + index : (i == infos.length - 1 ? maskString + " or #" + index + ")" : maskString + " or #" + index));
                        ++index;
                    }
                }
            }
        }
        Timestamp fromDate = this.dateFrom.getTimestamp();
        Timestamp toDate = this.dateTo.getTimestamp();
        if (fromDate == null || toDate == null || !fromDate.equals(toDate)) {
            if (fromDate != null) {
                filter.getFilterItems().add(new FilterItemInfo("occurTime", (Object)fromDate, CompareType.GREATER_EQUALS));
                maskString = index == 0 ? maskString + "#" + index : maskString + " and #" + index;
                ++index;
            }
            if (toDate != null) {
                filter.getFilterItems().add(new FilterItemInfo("occurTime", (Object)toDate, CompareType.LESS_EQUALS));
                maskString = index == 0 ? maskString + "#" + index : maskString + " and #" + index;
                ++index;
            }
        }
        if ((selectedUserType = (UserType)this.comboUserType.getSelectedItem()) != null) {
            filter.getFilterItems().add(new FilterItemInfo("userType", (Object)selectedUserType.getAlias()));
            maskString = index == 0 ? maskString + "#" + index : maskString + " and #" + index;
            ++index;
        }
        if ((selectedLogType = (LogType)((Object)this.comboLogType.getSelectedItem())) != null) {
            filter.getFilterItems().add(new FilterItemInfo("Item.type", (Object)new Integer(selectedLogType.getValue())));
            maskString = index == 0 ? maskString + "#" + index : maskString + " and #" + index;
            ++index;
        }
        if (!this.checkSuccess.isSelected() || !this.checkFail.isSelected()) {
            if (this.checkSuccess.isSelected()) {
                filter.getFilterItems().add(new FilterItemInfo("isSuccessed", (Object)new Integer(1)));
                maskString = index == 0 ? maskString + "#" + index : maskString + " and #" + index;
                ++index;
            } else if (this.checkFail.isSelected()) {
                filter.getFilterItems().add(new FilterItemInfo("isSuccessed", (Object)new Integer(0)));
                maskString = index == 0 ? maskString + "#" + index : maskString + " and #" + index;
                ++index;
            }
        }
        filter.setMaskString(maskString);
        return filter;
    }

    public void setFilterInfo(FilterInfo filterInfo) {
        this.filterInfo = filterInfo;
    }

    public void setPanelName(String panelName) {
        this.panelName = panelName;
    }

    public String getPanelName() {
        return this.panelName;
    }

    public void setSorterItems(SorterItemCollection items) {
        this.sorterItemCollection = items;
    }

    public SorterItemCollection getSorterItems() {
        return this.sorterItemCollection;
    }

    public void setParam(Object param) {
        this.param = param;
    }

    public Object getParam() {
        return this.param;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        FilterInfo filterInfo = entityViewInfo.getFilter();
        if (filterInfo == null || filterInfo.getFilterItems().size() == 0) {
            return;
        }
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter().getFilterItems();
        ArrayList<FullOrgUnitInfo> infoList = new ArrayList<FullOrgUnitInfo>();
        for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("cuID")) {
                String cuId = (String)filterItemInfo.getCompareValue();
                try {
                    FullOrgUnitInfo data = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)cuId)));
                    infoList.add(data);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("occurTime")) {
                if (CompareType.GREATER_EQUALS == filterItemInfo.getCompareType()) {
                    this.dateFrom.setValue(filterItemInfo.getCompareValue());
                } else if (CompareType.LESS_EQUALS == filterItemInfo.getCompareType()) {
                    this.dateTo.setValue(filterItemInfo.getCompareValue());
                }
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("userType")) {
                String typeAlias = (String)filterItemInfo.getCompareValue();
                Iterator iter = UserType.iterator();
                while (iter.hasNext()) {
                    UserType userType = (UserType)iter.next();
                    if (!typeAlias.equals(userType.getAlias())) continue;
                    this.comboUserType.setSelectedItem((Object)userType);
                }
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("Item.type")) {
                int type = (Integer)filterItemInfo.getCompareValue();
                this.comboLogType.setSelectedItem((Object)LogType.getEnum(type));
            }
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("isSuccessed")) continue;
            int isSuccessed = (Integer)filterItemInfo.getCompareValue();
            if (isSuccessed == 1) {
                this.checkSuccess.setSelected(true);
            }
            if (isSuccessed != 0) continue;
            this.checkFail.setSelected(true);
        }
        if (infoList.size() > 0) {
            OrgUnitInfo[] infos = new OrgUnitInfo[infoList.size()];
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < infos.length; ++i) {
                infos[i] = (OrgUnitInfo)infoList.get(i);
                idSet.add(infos[i].getId().toString());
            }
            this.bizPromptCU.setData((Object)infos);
            this.ctrlF7.setSelectedOrgIds(idSet);
        }
    }

    public boolean verify() {
        return true;
    }

    public Component getFocusComponent() {
        return null;
    }

    public void clear() {
        this.radioCurrent.setSelected(true);
        this.bizPromptCU.setData(null);
        this.dateFrom.setValue(null);
        this.dateTo.setValue(null);
        this.comboUserType.setSelectedIndex(0);
        this.comboLogType.setSelectedIndex(0);
        this.checkFail.setSelected(false);
        this.checkSuccess.setSelected(false);
        this.init();
    }

    public FilterInfo getInnerFilterInfo() {
        return null;
    }

    public void handUIException(Throwable throwable) {
        ExceptionHandler.handle((Throwable)throwable);
        SysUtil.abort();
    }

    public void setCustomerParams(CustomerParams cp) {
        this.clear();
        this.customerParams = cp;
        if (this.customerParams != null) {
            if ("1".equals(this.customerParams.getCustomerParam("flag"))) {
                this.radioCurrent.setSelected(true);
            } else {
                this.radioHistory.setSelected(true);
            }
        }
    }

    public CustomerParams getCustomerParams() {
        HashMap<String, Integer> hm = new HashMap<String, Integer>();
        int logFlag = 1;
        logFlag = this.radioCurrent.isSelected() ? 1 : 2;
        hm.put("flag", new Integer(logFlag));
        this.customerParams = new CustomerParams();
        this.customerParams.setHm(hm);
        return this.customerParams;
    }

    public int getSelectedLogType() {
        if (this.radioCurrent.isSelected()) {
            return 1;
        }
        return 2;
    }
}

