/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.log.client;

import com.kingdee.eas.base.log.client.AbstractProgressUI;
import com.kingdee.eas.base.log.client.LogAppUI;
import com.kingdee.eas.base.log.common.Resource;
import java.awt.event.ActionEvent;

public class ProgressUI
extends AbstractProgressUI {
    private LogAppUI logAppUI = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    private void init() {
        this.progressBar.setStringPainted(true);
        this.progressBar.setString("");
        this.enableComponents();
    }

    private LogAppUI getLogAppUI() {
        if (this.logAppUI == null) {
            this.logAppUI = (LogAppUI)((Object)this.getUIContext().get("LogUI"));
        }
        return this.logAppUI;
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        super.actionOk_actionPerformed(e);
        new DumpThread().start();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        ((LogAppUI)((Object)this.getUIContext().get("LogUI"))).setConfirm(false);
        this.getUIWindow().close();
    }

    private void beginProgress() {
        this.disableComponents();
        this.progressBar.setIndeterminate(true);
    }

    private void endProgress() {
        this.enableComponents();
        this.progressBar.setIndeterminate(false);
    }

    private void disableComponents() {
        this.btnOk.setEnabled(false);
        this.btnCancel.setEnabled(false);
    }

    private void enableComponents() {
        this.btnOk.setEnabled(true);
        this.btnCancel.setEnabled(true);
    }

    class DumpThread
    extends Thread {
        DumpThread() {
        }

        @Override
        public void run() {
            try {
                ProgressUI.this.beginProgress();
                ProgressUI.this.progressBar.setString(Resource.ON_DUMPING);
                ProgressUI.this.getLogAppUI().getAppLog().dump(1);
                ProgressUI.this.getLogAppUI().setConfirm(true);
            }
            catch (Exception e) {
                ProgressUI.this.getLogAppUI().setConfirm(false);
                ProgressUI.this.handUIException(e);
            }
            finally {
                ProgressUI.this.endProgress();
                ProgressUI.this.getUIWindow().close();
            }
        }
    }
}

