/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.log.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.log.LogException;
import com.kingdee.eas.base.log.app.AbstractAutoDumpLogFacadeControllerBean;
import com.kingdee.eas.base.log.app.AppLogHelper;
import com.kingdee.eas.base.log.common.Resource;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class AutoDumpLogFacadeControllerBean
extends AbstractAutoDumpLogFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)AutoDumpLogFacadeControllerBean.class.getName());
    private static final int MIN_COUNT = 100000;
    private static final int DAY_NUM = 30;

    private Calendar changeDate2Calendar(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal;
    }

    @Override
    protected void _autoDumpLog(Context ctx) throws BOSException, LogException {
        logger.info((Object)"begin write log-----------");
        try {
            logger.error((Object)"begin autoDumpLog--------");
            Date currentDate = new Date(System.currentTimeMillis());
            Calendar currentCal = this.changeDate2Calendar(currentDate);
            SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            StringBuffer sql = new StringBuffer("SELECT COUNT(*) AS TOTALCOUNT FROM T_LOG_APP WHERE FOccurTime < ").append("{ts'").append(formate.format(currentCal.getTime())).append("'}");
            IRowSet totalCountSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (totalCountSet.next()) {
                int totalCount = totalCountSet.getInt("TOTALCOUNT");
                if (totalCount <= 0) {
                    logger.info((Object)"totalCount = 0  no dump---------");
                    return;
                }
                if (totalCount < 100000 && totalCount > 0) {
                    logger.info((Object)"totalCount < MIN_COUNT && totalCount > 0");
                    this.dump(ctx, formate.format(currentCal.getTime()));
                } else {
                    String sqlSel = "SELECT MIN(FOCCURTIME) AS FOCCURTIME FROM T_LOG_APP; ";
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlSel);
                    if (rs.next()) {
                        java.sql.Date occurTime = rs.getDate("FOCCURTIME");
                        logger.info((Object)("occurTime = " + occurTime));
                        Calendar calStart = this.changeDate2Calendar(occurTime);
                        Calendar calEnd = (Calendar)calStart.clone();
                        calEnd.add(6, 30);
                        StringBuffer sqlSelect = new StringBuffer("SELECT COUNT(*) AS TOTALCOUNT FROM T_Log_App WHERE FOccurTime < ").append("{ts'").append(formate.format(calEnd.getTime())).append("'}");
                        IRowSet countSet = DbUtil.executeQuery((Context)ctx, (String)sqlSelect.toString());
                        if (countSet.next()) {
                            int count = countSet.getInt("TOTALCOUNT");
                            logger.info((Object)("count = " + count));
                            int number = count / 100000 + 1;
                            if (number > 1) {
                                int orderDay = 30 / number + 1;
                                calEnd.setTime(calStart.getTime());
                                calEnd.add(6, orderDay);
                            }
                        }
                        this.dump(ctx, formate.format(calEnd.getTime()));
                    }
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        logger.info((Object)"end write log--------");
    }

    private void dump(Context ctx, String dateEnd) throws BOSException {
        Connection cn = null;
        try {
            if (!AppLogHelper.requestMutex(ctx)) {
                throw new BOSException(Resource.IS_STORING_NOW + Resource.PLEASE_TRY_LATER);
            }
            logger.info((Object)"************************ begin dump **************************");
            logger.info((Object)"DumpStatus = true");
            logger.info((Object)("dateEnd = " + dateEnd));
            cn = this.getConnection(ctx);
            String strIns = "INSERT INTO T_Log_His SELECT * FROM T_Log_App WHERE FOccurTime < {ts'" + dateEnd + "'}";
            String strDel = "DELETE FROM T_Log_App WHERE FOccurTime < {ts'" + dateEnd + "'}";
            SQLUtils.execute((Connection)cn, (String)strIns);
            SQLUtils.execute((Connection)cn, (String)strDel);
        }
        catch (Exception ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                AppLogHelper.releaseMutex(ctx);
                SQLUtils.cleanup(cn);
                throw throwable;
            }
        }
        AppLogHelper.releaseMutex(ctx);
        SQLUtils.cleanup((Connection)cn);
    }
}

