/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.log.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.agent.LicenseSrvAgent;
import com.kingdee.eas.base.log.StatisticConstant;
import com.kingdee.eas.base.log.app.AbstractStatisticFacadeControllerBean;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class StatisticFacadeControllerBean
extends AbstractStatisticFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.uiframe.app.StatisticFacadeControllerBean");

    @Override
    protected void _collectData(Context ctx) throws BOSException {
        this.copyLogData(ctx);
        this.generateJsonText(ctx);
    }

    private void copyLogData(Context ctx) {
        String sql = "SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 'T_LOG_APPFORSTATISTIC'";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                String deleteSql = "delete from T_LOG_APPFORSTATISTIC";
                DbUtil.execute((Context)ctx, (String)deleteSql);
            } else {
                String createSql = "Create Table T_LOG_APPFORSTATISTIC ( FID VARCHAR(44) NOT NULL ,FUserID VARCHAR(44),FUserName NVARCHAR(80),FOccurTime DateTime,FClientIP NVARCHAR(80),FClientName NVARCHAR(80),FEntityId VARCHAR(44),FCompanyName_L1 NVARCHAR(80),FCompanyName_L2 NVARCHAR(80),FCompanyName_L3 NVARCHAR(80),FEntityName NVARCHAR(80),FEntityAlias_L1 NVARCHAR(200),FEntityAlias_L2 NVARCHAR(200),FEntityAlias_L3 NVARCHAR(200),FMethodName NVARCHAR(80),FMethodAlias_L1 NVARCHAR(200),FMethodAlias_L2 NVARCHAR(200),FMethodAlias_L3 NVARCHAR(200),FInstanceId VARCHAR(44),FInstanceNo NVARCHAR(1200),FItemName VARCHAR(80), FUserNumber NVARCHAR (80), FCUID VARCHAR (44), FIsSuccessed INT NOT NULL DEFAULT 1, FInstanceDetail BLOB (20000000), FUserType_L1 NVARCHAR(80), FUserType_L2 NVARCHAR(80), FUserType_L3 NVARCHAR(80),FMethodDescription_l1 NVARCHAR(255),FMethodDescription_l2 NVARCHAR(255),FMethodDescription_l3 NVARCHAR(255))";
                DbUtil.execute((Context)ctx, (String)createSql);
            }
            Calendar start = Calendar.getInstance();
            start.add(6, -1);
            this.clearTime(start);
            Timestamp startTime = new Timestamp(start.getTimeInMillis());
            Calendar end = Calendar.getInstance();
            this.clearTime(end);
            Timestamp endTime = new Timestamp(end.getTimeInMillis());
            Object[] params = new Object[]{startTime, endTime};
            String insertAppSql = "insert into T_LOG_APPFORSTATISTIC select * from t_log_app where FOccurTime>? and FOccurTime<?";
            DbUtil.execute((Context)ctx, (String)insertAppSql, (Object[])params);
            String insertHisSql = "insert into T_LOG_APPFORSTATISTIC select * from t_log_his where FOccurTime>? and FOccurTime<?";
            DbUtil.execute((Context)ctx, (String)insertHisSql, (Object[])params);
        }
        catch (Throwable e) {
            logger.error((Object)"StatisticFacadeControllerBean copyLogData:", e);
        }
    }

    private void clearTime(Calendar c) {
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
    }

    private void generateJsonText(Context ctx) {
        try {
            this.deleteHisData(ctx);
            JSONArray logInfo = this.getAllLogInfo(ctx);
            Calendar now = Calendar.getInstance();
            now.add(6, -1);
            Timestamp time = new Timestamp(now.getTimeInMillis());
            String insertSql = "insert into T_BAS_LOGSTATISTIC(occurdate,data) values(?,?)";
            Object[] params = new Object[]{time, logInfo.toString()};
            DbUtil.execute((Context)ctx, (String)insertSql, (Object[])params);
        }
        catch (Throwable e) {
            logger.error((Object)"StatisticFacadeControllerBean generateJsonText:", e);
        }
    }

    private void deleteHisData(Context ctx) {
        String deleteSql = "delete from T_BAS_LOGSTATISTIC where occurdate<?";
        Calendar now = Calendar.getInstance();
        now.add(3, -1);
        Timestamp aWeekAgo = new Timestamp(now.getTimeInMillis());
        Object[] params = new Object[]{aWeekAgo};
        try {
            DbUtil.execute((Context)ctx, (String)deleteSql, (Object[])params);
        }
        catch (Throwable t) {
            logger.error((Object)"deleteHisData:", t);
        }
    }

    private JSONArray getAllLogInfo(Context ctx) {
        Map<String, Set<String>> userRoleNamesMap = this.getUserRoleNamesMap(ctx);
        JSONArray ret = new JSONArray();
        String occurDate = this.getOccurDate(ctx);
        String sql = "select fuserid,fclientip,fclientname,fentityalias_l2 entity,count(1) num  from T_LOG_APPFORSTATISTIC  group by fuserid,fclientip,fclientname,fentityalias_l2   having fentityalias_l2 not in ('\u767b\u5f55\u548c\u6ce8\u9500\u65e5\u5fd7','\u8e22\u51fa\u7528\u6237\u65e5\u5fd7') order by fuserid,fclientip,fclientname,num desc ";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            String userId = null;
            String clientIp = null;
            String clientName = null;
            String function = null;
            int num = 0;
            HashMap<String[], List<Object[]>> userFunctionsMap = new HashMap<String[], List<Object[]>>();
            String[] key = null;
            Object[] functionNum = null;
            List functions = null;
            while (rs.next()) {
                key = new String[3];
                userId = rs.getString("fuserid");
                clientIp = rs.getString("fclientip");
                clientName = rs.getString("fclientname");
                key[0] = userId;
                key[1] = clientIp;
                key[2] = clientName;
                function = rs.getString("entity");
                num = rs.getInt("num");
                functionNum = new Object[]{function, String.valueOf(num)};
                functions = userFunctionsMap.containsKey(key) ? (List)userFunctionsMap.get(key) : new ArrayList();
                functions.add(functionNum);
                userFunctionsMap.put(key, functions);
            }
            ret = this.getJSONArray(ctx, userFunctionsMap, userRoleNamesMap, occurDate);
        }
        catch (Throwable e) {
            logger.error((Object)"StatisticFacadeControllerBean getFunctionUseInfo:", e);
        }
        return ret;
    }

    private JSONArray getJSONArray(Context ctx, Map<String[], List<Object[]>> userFunctionsMap, Map<String, Set<String>> userRoleNamesMap, String occurDate) {
        String FProductID = "S3S001S001";
        JSONArray ret = new JSONArray();
        Iterator<Map.Entry<String[], List<Object[]>>> itr = userFunctionsMap.entrySet().iterator();
        Map.Entry<String[], List<Object[]>> entry = null;
        String[] key = null;
        String userId = null;
        String clientIp = null;
        String clientName = null;
        JSONObject jsonObj = null;
        try {
            LicenseSrvAgent agent = new LicenseSrvAgent();
            LicenseBaseInfo baseInfo = agent.getLicenseBaseInfo();
            String FProductVer = baseInfo.getVersion();
            String FProductRegNO = baseInfo.getSerialNum();
            String FAccountName = ctx.getAIS();
            String roleNames = null;
            String FAdditionalInfo = null;
            JSONArray functionsArr = null;
            JSONObject functionJson = null;
            List<Object[]> functionNumList = null;
            String functionName = null;
            String num = null;
            JSONObject dateJson = null;
            JSONArray dateArr = null;
            while (itr.hasNext()) {
                entry = itr.next();
                key = entry.getKey();
                userId = key[0];
                clientIp = key[1];
                clientName = key[2];
                jsonObj = new JSONObject();
                jsonObj.put("FProductID", (Object)FProductID);
                jsonObj.put("FProductVer", (Object)FProductVer);
                jsonObj.put("FProductRegNO", (Object)FProductRegNO);
                jsonObj.put("FAccountName", (Object)FAccountName);
                jsonObj.put("FAccountUser", (Object)userId);
                roleNames = ToolUtils.aryToStr((Collection)userRoleNamesMap.get(userId), (boolean)false);
                jsonObj.put("FUserRole", (Object)roleNames);
                FAdditionalInfo = clientIp + clientName;
                jsonObj.put("FAdditionalInfo", (Object)FAdditionalInfo);
                functionsArr = new JSONArray();
                functionNumList = entry.getValue();
                int size = functionNumList.size();
                for (int i = 0; i < size; ++i) {
                    functionJson = new JSONObject();
                    Object[] functionNum = functionNumList.get(i);
                    functionName = (String)functionNum[0];
                    num = (String)functionNum[1];
                    functionJson.put("FFunctionKey", (Object)functionName);
                    functionJson.put("FOperationCount", (Object)num);
                    functionsArr.put((Object)functionJson);
                }
                dateJson = new JSONObject();
                dateJson.put("FOperationDay", (Object)occurDate);
                dateJson.put("FFunctions", (Object)functionsArr);
                dateArr = new JSONArray();
                dateArr.put((Object)dateJson);
                jsonObj.put("FOperationDays", (Object)dateArr);
                ret.put((Object)jsonObj);
            }
        }
        catch (Throwable t) {
            logger.error((Object)"", t);
        }
        return ret;
    }

    private String getOccurDate(Context ctx) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMdd");
        String sql = "select top 1 FOccurTime from T_LOG_APPFORSTATISTIC";
        Date date = new Date();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                Timestamp time = rs.getTimestamp("FOccurTime");
                date = new Date(time.getTime());
            }
        }
        catch (Throwable t) {
            logger.error((Object)"getOccurDate", t);
        }
        return sf.format(date);
    }

    private Map<String, Set<String>> getUserRoleNamesMap(Context ctx) {
        HashMap<String, Set<String>> ret = new HashMap<String, Set<String>>();
        try {
            String sql = "select distinct fuserid,b.fname_l2 roleName from t_pm_userroleorg a join t_pm_role b on a.froleid=b.fid  where fuserid in (select distinct fuserid from T_LOG_APPFORSTATISTIC) order by fuserid";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            String userId = null;
            String roleName = null;
            Set roleNameSet = null;
            while (rs.next()) {
                userId = rs.getString("fuserid");
                roleName = rs.getString("roleName");
                roleNameSet = ret.containsKey(userId) ? (Set)ret.get(userId) : new HashSet();
                roleNameSet.add(roleName);
                ret.put(userId, roleNameSet);
            }
        }
        catch (Throwable e) {
            logger.error((Object)"getUserRoleNameMap", e);
        }
        return ret;
    }

    @Override
    protected Map _getStatisticData(Context ctx, String period) throws BOSException {
        HashMap<String, String> ret = new HashMap<String, String>();
        Calendar start = Calendar.getInstance();
        if (StatisticConstant.DATE.equals(period)) {
            start.add(6, -1);
        } else {
            start.add(3, -1);
        }
        this.clearTime(start);
        Timestamp startTime = new Timestamp(start.getTimeInMillis());
        String sql = "select occurdate,data from T_BAS_LOGSTATISTIC where occurdate>?";
        Object[] params = new Object[]{startTime};
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            while (rs.next()) {
                String type = rs.getString("occurdate");
                String data = rs.getString("data");
                ret.put(type, data);
            }
        }
        catch (Throwable e) {
            logger.error((Object)"StatisticFacadeControllerBean _getStatisticData:", e);
        }
        return ret;
    }

    @Override
    protected void _deleteData(Context ctx) throws BOSException {
        String sql = "delete from T_BAS_LOGSTATISTIC";
        try {
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (Throwable t) {
            logger.error((Object)t);
        }
    }
}

