/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.FieldPermFacadeFactory;
import com.kingdee.eas.base.permission.RolePermInfo;
import com.kingdee.eas.base.permission.UserOrgPermInfo;
import com.kingdee.eas.base.permission.UserRoleOrgManagerFactory;
import com.kingdee.eas.base.permission.util.LogNamesHelper;
import com.kingdee.eas.base.permission.util.MyEntityInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class PermissionLogHelper {
    private static String userAccreditPermMethodAlias = null;
    private static String userBatchAccreditPermMethodAlias = null;
    private static String userBatchDeletePermMethodAlias = null;
    private static String userUserRoleMethodAlias = null;
    private static String userBatchAssignRoleMethodAlias = null;
    private static String userBatchDeleteRoleMethodAlias = null;
    private static String roleAccreditPermMethodAlias = null;
    private static String userSaveFieldPermMethodAlias = null;
    private static String roleSaveFieldPermMethodAlias = null;
    private static String roleRemoveUserMethodAlias = null;
    private static final String permissionResource = "com.kingdee.eas.base.permission.PermissionResource";
    private static Map entityAliasAndMethodNameMap = null;

    public static String getLogInstanceDetail(String resName, Object[] params) {
        return MessageFormat.format(EASResource.getString((String)permissionResource, (String)resName), params);
    }

    public static String getUserAccreditPermMethodAlias(Context ctx) {
        if (userAccreditPermMethodAlias == null) {
            userAccreditPermMethodAlias = MyEntityInfo.getMethodAlias(ctx, new UserOrgPermInfo().getBOSType(), "saveUserOrgPerms");
        }
        return userAccreditPermMethodAlias;
    }

    public static String getUserBatchAccreditPermMethodAlias(Context ctx) {
        if (userBatchAccreditPermMethodAlias == null) {
            userBatchAccreditPermMethodAlias = MyEntityInfo.getMethodAlias(ctx, new UserOrgPermInfo().getBOSType(), "saveUserOrgPermsBatch");
        }
        return userBatchAccreditPermMethodAlias;
    }

    public static String getUserBatchDeletePermMethodAlias(Context ctx) {
        if (userBatchDeletePermMethodAlias == null) {
            userBatchDeletePermMethodAlias = MyEntityInfo.getMethodAlias(ctx, new UserOrgPermInfo().getBOSType(), "deleteUserOrgPermsBatch");
        }
        return userBatchDeletePermMethodAlias;
    }

    private static String getUserRoleMethodAlias(Context ctx) throws BOSException {
        if (userUserRoleMethodAlias == null) {
            BOSObjectType bosType = null;
            bosType = ctx == null ? UserRoleOrgManagerFactory.getRemoteInstance().getType() : UserRoleOrgManagerFactory.getLocalInstance(ctx).getType();
            userUserRoleMethodAlias = MyEntityInfo.getFacadeMethodAlias(ctx, bosType, "saveUserRoleOrgs");
        }
        return userUserRoleMethodAlias;
    }

    public static String getUserAssignRoleMethodAlias(Context ctx) throws BOSException {
        return PermissionLogHelper.getUserRoleMethodAlias(ctx) + "_UserAssignRole";
    }

    public static String getRoleAssignUserMethodAlias(Context ctx) throws BOSException {
        return PermissionLogHelper.getUserRoleMethodAlias(ctx) + "_RoleAssignUser";
    }

    public static String getUserBatchAssignRoleMethodAlias(Context ctx) throws BOSException {
        if (userBatchAssignRoleMethodAlias == null) {
            BOSObjectType bosType = null;
            bosType = ctx == null ? UserRoleOrgManagerFactory.getRemoteInstance().getType() : UserRoleOrgManagerFactory.getLocalInstance(ctx).getType();
            userBatchAssignRoleMethodAlias = MyEntityInfo.getFacadeMethodAlias(ctx, bosType, "batchSaveUserRolePerm");
        }
        return userBatchAssignRoleMethodAlias;
    }

    public static String getUserBatchDeleteRoleMethodAlias(Context ctx) throws BOSException {
        if (userBatchDeleteRoleMethodAlias == null) {
            BOSObjectType bosType = null;
            bosType = ctx == null ? UserRoleOrgManagerFactory.getRemoteInstance().getType() : UserRoleOrgManagerFactory.getLocalInstance(ctx).getType();
            userBatchDeleteRoleMethodAlias = MyEntityInfo.getFacadeMethodAlias(ctx, bosType, "batchRemoveUserRolePerm");
        }
        return userBatchDeleteRoleMethodAlias;
    }

    public static String getRoleAccreditPermMethodAlias(Context ctx) throws BOSException {
        if (roleAccreditPermMethodAlias == null) {
            roleAccreditPermMethodAlias = MyEntityInfo.getMethodAlias(ctx, new RolePermInfo().getBOSType(), "saveRolePerms");
        }
        return roleAccreditPermMethodAlias;
    }

    public static String getUserSaveFieldPermMethodAlias(Context ctx) throws BOSException {
        if (userSaveFieldPermMethodAlias == null) {
            BOSObjectType bosType = null;
            bosType = ctx == null ? FieldPermFacadeFactory.getRemoteInstance().getType() : FieldPermFacadeFactory.getLocalInstance(ctx).getType();
            userSaveFieldPermMethodAlias = MyEntityInfo.getFacadeMethodAlias(ctx, bosType, "saveUserFieldPerm");
        }
        return userSaveFieldPermMethodAlias;
    }

    public static String getRoleSaveFieldPermMethodAlias(Context ctx) throws BOSException {
        if (roleSaveFieldPermMethodAlias == null) {
            BOSObjectType bosType = null;
            bosType = ctx == null ? FieldPermFacadeFactory.getRemoteInstance().getType() : FieldPermFacadeFactory.getLocalInstance(ctx).getType();
            roleSaveFieldPermMethodAlias = MyEntityInfo.getFacadeMethodAlias(ctx, bosType, "saveRoleFieldPerm");
        }
        return roleSaveFieldPermMethodAlias;
    }

    public static String getRoleRemoveUserMethodAlias(Context ctx) throws BOSException {
        if (roleRemoveUserMethodAlias == null) {
            BOSObjectType bosType = null;
            bosType = ctx == null ? UserRoleOrgManagerFactory.getRemoteInstance().getType() : UserRoleOrgManagerFactory.getLocalInstance(ctx).getType();
            roleRemoveUserMethodAlias = MyEntityInfo.getFacadeMethodAlias(ctx, bosType, "removeUserRoleOrgs");
        }
        return roleRemoveUserMethodAlias;
    }

    public static List getAllPermChangeMethodList(Context ctx) throws BOSException {
        ArrayList<String> allMethodAlias = new ArrayList<String>();
        allMethodAlias.add(PermissionLogHelper.getUserAccreditPermMethodAlias(ctx));
        allMethodAlias.add(PermissionLogHelper.getUserBatchAccreditPermMethodAlias(ctx));
        allMethodAlias.add(PermissionLogHelper.getUserAssignRoleMethodAlias(ctx));
        allMethodAlias.add(PermissionLogHelper.getUserBatchAssignRoleMethodAlias(ctx));
        allMethodAlias.add(PermissionLogHelper.getRoleAccreditPermMethodAlias(ctx));
        allMethodAlias.add(PermissionLogHelper.getUserBatchDeletePermMethodAlias(ctx));
        allMethodAlias.add(PermissionLogHelper.getUserBatchDeleteRoleMethodAlias(ctx));
        allMethodAlias.add(PermissionLogHelper.getRoleAssignUserMethodAlias(ctx));
        allMethodAlias.add(PermissionLogHelper.getUserSaveFieldPermMethodAlias(ctx));
        allMethodAlias.add(PermissionLogHelper.getRoleSaveFieldPermMethodAlias(ctx));
        allMethodAlias.add(PermissionLogHelper.getRoleRemoveUserMethodAlias(ctx));
        return allMethodAlias;
    }

    public static String getMethodName(Context ctx, String methodAlias) throws BOSException {
        Locale locale = null;
        locale = ctx == null ? SysContext.getSysContext().getLocale() : ctx.getLocale();
        if (entityAliasAndMethodNameMap == null) {
            entityAliasAndMethodNameMap = new HashMap();
            entityAliasAndMethodNameMap.put(PermissionLogHelper.getUserAccreditPermMethodAlias(ctx), LogNamesHelper.getLogName("UserAccreditPermMethodAlias", locale));
            entityAliasAndMethodNameMap.put(PermissionLogHelper.getUserBatchAccreditPermMethodAlias(ctx), LogNamesHelper.getLogName("UserBatchAccreditPermMethodAlias", locale));
            entityAliasAndMethodNameMap.put(PermissionLogHelper.getUserAssignRoleMethodAlias(ctx), LogNamesHelper.getLogName("UserAssignRoleMethodAlias", locale));
            entityAliasAndMethodNameMap.put(PermissionLogHelper.getUserBatchAssignRoleMethodAlias(ctx), LogNamesHelper.getLogName("UserBatchAssignRoleMethodAlias", locale));
            entityAliasAndMethodNameMap.put(PermissionLogHelper.getRoleAccreditPermMethodAlias(ctx), LogNamesHelper.getLogName("RoleAccreditPermMethodAlias", locale));
            entityAliasAndMethodNameMap.put(PermissionLogHelper.getUserBatchDeletePermMethodAlias(ctx), LogNamesHelper.getLogName("UserBatchDeletePermMethodAlias", locale));
            entityAliasAndMethodNameMap.put(PermissionLogHelper.getUserBatchDeleteRoleMethodAlias(ctx), LogNamesHelper.getLogName("UserBatchDeleteRoleMethodAlias", locale));
            entityAliasAndMethodNameMap.put(PermissionLogHelper.getRoleAssignUserMethodAlias(ctx), LogNamesHelper.getLogName("RoleAssignUserMethodAlias", locale));
            entityAliasAndMethodNameMap.put(PermissionLogHelper.getUserSaveFieldPermMethodAlias(ctx), PermissionLogHelper.getUserSaveFieldPermMethodAlias(ctx));
            entityAliasAndMethodNameMap.put(PermissionLogHelper.getRoleSaveFieldPermMethodAlias(ctx), PermissionLogHelper.getRoleSaveFieldPermMethodAlias(ctx));
            entityAliasAndMethodNameMap.put(PermissionLogHelper.getRoleRemoveUserMethodAlias(ctx), LogNamesHelper.getLogName("RoleRemoveUserMethodAliase", locale));
        }
        return StringUtils.cnulls(entityAliasAndMethodNameMap.get(methodAlias));
    }

    public static boolean isUserAccreditPerm(Context ctx, String methodAlias) {
        return PermissionLogHelper.getUserAccreditPermMethodAlias(ctx).equals(methodAlias);
    }

    public static boolean isUserBatchAccreditPerm(Context ctx, String methodAlias) {
        return PermissionLogHelper.getUserBatchAccreditPermMethodAlias(ctx).equals(methodAlias);
    }

    public static boolean isUserBatchDeletePerm(Context ctx, String methodAlias) {
        return PermissionLogHelper.getUserBatchDeletePermMethodAlias(ctx).equals(methodAlias);
    }

    public static boolean isUserAssignRole(Context ctx, String methodAlias) throws BOSException {
        return PermissionLogHelper.getUserAssignRoleMethodAlias(ctx).equals(methodAlias);
    }

    public static boolean isRoleAssignUser(Context ctx, String methodAlias) throws BOSException {
        return PermissionLogHelper.getRoleAssignUserMethodAlias(ctx).equals(methodAlias);
    }

    public static boolean isUserBatchAssignRole(Context ctx, String methodAlias) throws BOSException {
        return PermissionLogHelper.getUserBatchAssignRoleMethodAlias(ctx).equals(methodAlias);
    }

    public static boolean isUserBatchDeleteRole(Context ctx, String methodAlias) throws BOSException {
        return PermissionLogHelper.getUserBatchDeleteRoleMethodAlias(ctx).equals(methodAlias);
    }

    public static boolean isRoleAccreditPerm(Context ctx, String methodAlias) throws BOSException {
        return PermissionLogHelper.getRoleAccreditPermMethodAlias(ctx).equals(methodAlias);
    }

    public static boolean isUserSaveFieldPerm(Context ctx, String methodAlias) throws BOSException {
        return PermissionLogHelper.getUserSaveFieldPermMethodAlias(ctx).equals(methodAlias);
    }

    public static boolean isRoleSaveFieldPerm(Context ctx, String methodAlias) throws BOSException {
        return PermissionLogHelper.getRoleSaveFieldPermMethodAlias(ctx).equals(methodAlias);
    }

    public static boolean isRoleRemoveUser(Context ctx, String methodAlias) throws BOSException {
        return PermissionLogHelper.getRoleRemoveUserMethodAlias(ctx).equals(methodAlias);
    }
}

