/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterCollection;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.RuleInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.util.HashSet;
import java.util.Set;

public class RuleUtil {
    private static final BOSObjectType RULE_TYPE = new RuleInfo().getBOSType();

    private RuleUtil() {
    }

    public static boolean isRuleID(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return false;
        }
        try {
            BOSUuid uuid = BOSUuid.read((String)str);
            return RULE_TYPE.equals((Object)uuid.getType());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Set getEntryPropertyNames(EntityObjectInfo entity) {
        HashSet<String> entryPropertyNames = new HashSet<String>();
        PropertyCollection properties = entity.getInheritedNoDuplicatedProperties();
        int size = properties.size();
        for (int i = 0; i < size; ++i) {
            LinkPropertyInfo propertyInfo;
            if (!(properties.get(i) instanceof LinkPropertyInfo) || !PermissionCommonUtil.isEntry(propertyInfo = (LinkPropertyInfo)properties.get(i))) continue;
            entryPropertyNames.add(propertyInfo.getName());
        }
        return entryPropertyNames;
    }

    public static boolean isEntryRule(EntityObjectInfo entity, RuleInfo ruleInfo) throws ParserException, EASBizException, BOSException {
        Set entryPropertyNames = RuleUtil.getEntryPropertyNames(entity);
        FilterInfo filterInfo = new FilterInfo(ruleInfo.getScript());
        int size = filterInfo.getFilterItems().size();
        for (int i = 0; i < size; ++i) {
            FilterItemInfo filterItemInfo = filterInfo.getFilterItems().get(i);
            String propertyName = filterItemInfo.getPropertyName();
            int index = propertyName.indexOf(".");
            if (index <= 0 || !entryPropertyNames.contains(propertyName.substring(0, index))) continue;
            return true;
        }
        return false;
    }

    public static boolean isMixHeadEntryRule(EntityObjectInfo entity, RuleInfo ruleInfo) throws ParserException, EASBizException, BOSException {
        int headCount = 0;
        int entryCount = 0;
        Set entryPropertyNames = RuleUtil.getEntryPropertyNames(entity);
        FilterInfo filterInfo = new FilterInfo(ruleInfo.getScript());
        int size = filterInfo.getFilterItems().size();
        for (int i = 0; i < size; ++i) {
            FilterItemInfo filterItemInfo = filterInfo.getFilterItems().get(i);
            String propertyName = filterItemInfo.getPropertyName();
            int index = propertyName.indexOf(".");
            if (index > 0) {
                if (entryPropertyNames.contains(propertyName.substring(0, index))) {
                    ++entryCount;
                    continue;
                }
                ++headCount;
                continue;
            }
            ++headCount;
        }
        boolean isMixRule = headCount > 0 && entryCount > 0;
        return isMixRule;
    }

    public static String getEntryPropertyName(String oql) throws ParserException {
        FilterInfo filterInfo = new FilterInfo(oql);
        String propertyName = "";
        for (int i = 0; i < filterInfo.getFilterItems().size(); ++i) {
            FilterItemInfo filterItemInfo = filterInfo.getFilterItems().get(i);
            propertyName = filterItemInfo.getPropertyName();
            int index = propertyName.indexOf(".");
            if (index < 0) continue;
            return propertyName.substring(0, index);
        }
        return propertyName;
    }

    public static Object[] addObjectToArray(Object[] objects, Object insertObject) {
        Object[] insertObjects = new Object[]{insertObject};
        if (objects == null) {
            return insertObjects;
        }
        int length = objects.length;
        if (length == 0) {
            return insertObjects;
        }
        Object[] results = new Object[length + 1];
        results[0] = insertObjects[0];
        for (int i = 1; i <= length; ++i) {
            results[i] = objects[i - 1];
        }
        return results;
    }

    public static EntityViewInfo mergeEntityViewInfo(EntityViewInfo entityViewInfoA, EntityViewInfo entityViewInfoB, String logic) throws ParserException, BOSException {
        EntityViewInfo result = new EntityViewInfo();
        FilterInfo filterInfoA = entityViewInfoA.getFilter();
        FilterInfo filterInfoB = entityViewInfoB.getFilter();
        result.setFilter(RuleUtil.mergeFilterInfo(filterInfoA, filterInfoB, logic));
        FilterCollection entryFilterA = entityViewInfoA.getEntryFilters();
        FilterCollection entryFilterB = entityViewInfoB.getEntryFilters();
        entryFilterA.merge(entryFilterB, logic);
        result.getEntryFilters().addObjectCollection((IObjectCollection)entryFilterA);
        return result;
    }

    public static FilterInfo mergeFilterInfo(FilterInfo filterA, FilterInfo filterB, String logic) throws ParserException, BOSException {
        if (filterA == null || filterA.getFilterItems().size() == 0) {
            if (filterB == null || filterB.getFilterItems().size() == 0) {
                return new FilterInfo();
            }
            return filterB;
        }
        if (filterB == null || filterB.getFilterItems().size() == 0) {
            return filterA;
        }
        filterA.mergeFilter(filterB, logic);
        return filterA;
    }

    public static String mergeOQL(String oqlA, String oqlB, String logic) throws ParserException, BOSException {
        assert (!StringUtils.isEmpty((String)logic));
        if (StringUtils.isEmpty((String)oqlA)) {
            if (StringUtils.isEmpty((String)oqlB)) {
                return null;
            }
            return oqlB;
        }
        if (StringUtils.isEmpty((String)oqlB)) {
            return oqlA;
        }
        EntityViewInfo entityViewInfoA = new EntityViewInfo(oqlA);
        EntityViewInfo entityViewInfoB = new EntityViewInfo(oqlB);
        return RuleUtil.mergeEntityViewInfo(entityViewInfoA, entityViewInfoB, logic).toString();
    }
}

