/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.card;

import com.kingdee.eas.base.permission.card.IDynCardPasswordCheck;
import com.kingdee.eas.portal.web.configuration.PortalConfig;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import org.apache.log4j.Logger;

public class KDCardPwdCheck
implements IDynCardPasswordCheck {
    private static final Logger logger = Logger.getLogger(KDCardPwdCheck.class);
    private boolean isLocal = true;
    private String companyCode = "";
    private String serverURL = "";

    @Override
    public boolean checkPwd(String userName, String userPwd) throws Exception {
        if (this.companyCode == null || this.companyCode.length() <= 0) {
            logger.error((Object)"companyCode is null, check password result is false");
            return false;
        }
        if (this.serverURL == null || this.serverURL.length() <= 0) {
            logger.error((Object)"serverURL is null, check password result is false");
            return false;
        }
        if (this.isLocal) {
            Class<?> cls = Class.forName("com.kingdee.otp.web.totp.TOTP");
            Method method = cls.getMethod("generateTOTP256", String.class, String.class, String.class);
            String newOTPValue = (String)method.invoke(null, "6", userName, this.companyCode);
            if (userPwd.equals(newOTPValue)) {
                return true;
            }
            logger.warn((Object)("OTP compare failed. New OTP is " + newOTPValue + " and verify OTP is " + userPwd));
            return false;
        }
        String result = KDCardPwdCheck.sendPost(this.serverURL, "userName=" + userName + "&companyCode=" + this.companyCode + "&OTPValue=" + userPwd);
        if ("true".equalsIgnoreCase(result)) {
            return true;
        }
        System.out.println("KD card pwd check is : " + result);
        return false;
    }

    public static String sendPost(String url, String params) throws Exception {
        PrintWriter out = null;
        BufferedReader in = null;
        String result = "";
        try {
            String line;
            URL realUrl = new URL(url);
            URLConnection conn = realUrl.openConnection();
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
            conn.setConnectTimeout(30000);
            conn.setReadTimeout(60000);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            out = new PrintWriter(conn.getOutputStream());
            out.print(params);
            out.flush();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = in.readLine()) != null) {
                result = result + line;
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u53d1\u9001POST\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01" + e));
            throw new IOException("KD card pwd check failed, cause by[" + e.getMessage() + ']');
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initCardService(File file) throws Exception {
        Properties pro = new Properties();
        try (FileInputStream is = null;){
            ConfigurationItem xtItem;
            is = new FileInputStream(file);
            pro.load(is);
            String _oldpsw = (String)pro.get("oldpsw");
            if (StringUtils.isEmpty((String)_oldpsw) || !"true".equalsIgnoreCase(_oldpsw)) {
                throw new Exception("\u5f53\u524d EAS Cloud \u7248\u672c\u4e0d\u652f\u6301\u4f7f\u7528\u65e7\u7248\u52a8\u6001\u5bc6\u7801\uff01");
            }
            String _serverURL = (String)pro.get("serverURL");
            if (!StringUtils.isEmpty((String)_serverURL)) {
                this.serverURL = _serverURL;
            }
            this.isLocal = this.serverURL == null || this.serverURL.length() <= 0 || "local".equalsIgnoreCase(this.serverURL);
            String _companyCode = (String)pro.get("companyCode");
            if (!StringUtils.isEmpty((String)_companyCode)) {
                this.companyCode = _companyCode;
            }
            if (StringUtils.isEmpty((String)this.companyCode) && (xtItem = PortalConfig.getConfiguration().getConfigItem("XT_EAS")) != null) {
                this.companyCode = xtItem.getProperty("cust3gNo");
            }
            if (StringUtils.isEmpty((String)this.companyCode)) {
                logger.error((Object)"companyCode is null");
            }
        }
    }
}

