/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.AuthenRecordFactory;
import com.kingdee.eas.base.permission.AuthenStatusEnum;
import com.kingdee.eas.base.permission.OprtTypeEnum;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractAuthenListUI;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AuthenListUI
extends AbstractAuthenListUI {
    private static final Logger logger = CoreUIObject.getLogger(AuthenListUI.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    public AuthenListUI() throws Exception {
        this.passAuthen.setIcon(EASResource.getIcon((String)"imgTbtn_affirm"));
        this.notPassAuthen.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.authenDetail.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.setLoginMode.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.operTypeBox.removeItem((Object)OprtTypeEnum.UserAuthenWayChange);
        this.operTypeBox.removeItem((Object)OprtTypeEnum.AssignUserToRole);
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    AuthenListUI.this.setAuthenBtnStat(e);
                }
                catch (Exception ex) {
                    AuthenListUI.this.handUIException(ex);
                }
            }
        });
    }

    protected FilterInfo getDefaultFilterForQuery() {
        AuthenStatusEnum status = (AuthenStatusEnum)((Object)this.authenStatusBox.getSelectedItem());
        FilterInfo filterInfo = new FilterInfo();
        if (!status.getValue().equals("40")) {
            filterInfo.getFilterItems().add(new FilterItemInfo("authenStatus", (Object)status.getValue(), CompareType.EQUALS));
        }
        String currentUserId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        filterInfo.getFilterItems().add(new FilterItemInfo("authentor.id", (Object)currentUserId, CompareType.EQUALS));
        OprtTypeEnum operType = (OprtTypeEnum)((Object)this.operTypeBox.getSelectedItem());
        if (!operType.getValue().equals("90")) {
            filterInfo.getFilterItems().add(new FilterItemInfo("permChange.operType", (Object)operType.getValue()));
        }
        if (status.getValue().equals("10")) {
            this.addFilterWhenUnauthen(filterInfo, operType);
        } else if (status.getValue().equals("40")) {
            this.addFilterWhenAll(filterInfo, operType);
        }
        return filterInfo;
    }

    private void addFilterWhenAll(FilterInfo filterInfo, OprtTypeEnum operType) {
        try {
            String filterSql = null;
            UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
            FilterInfo otherFilterInfo = new FilterInfo();
            otherFilterInfo.getFilterItems().add(new FilterItemInfo("authenStatus", (Object)"20", CompareType.EQUALS));
            otherFilterInfo.getFilterItems().add(new FilterItemInfo("authenStatus", (Object)"30", CompareType.EQUALS));
            otherFilterInfo.getFilterItems().add(new FilterItemInfo("authenStatus", (Object)"50", CompareType.EQUALS));
            FilterString filterString = null;
            if (operType.getValue().equals("10")) {
                filterString = new AssignPerm2UserFilterString(null);
            } else if (operType.getValue().equals("20")) {
                filterString = new AssignRole2UserFilterString(null);
            } else if (operType.getValue().equals("30")) {
                filterString = new AssignUser2RoleFilterString(null);
            } else if (operType.getValue().equals("40")) {
                filterString = new AssignPerm2RoleFilterString(null);
            } else if (operType.getValue().equals("50")) {
                filterString = new CreateNewUserFilterString(null);
            } else if (operType.getValue().equals("70")) {
                filterString = new AssignGrantRole2UserFilterString(null);
            } else if (operType.getValue().equals("80")) {
                filterString = new AssignGrantPerm2UserFilterString(null);
            } else if (operType.getValue().equals("90")) {
                filterString = new AssignPerm2UserFilterString(new AssignRole2UserFilterString(new AssignUser2RoleFilterString(new AssignPerm2RoleFilterString(new CreateNewUserFilterString(new AssignGrantRole2UserFilterString(new AssignGrantPerm2UserFilterString(null)))))));
            }
            filterSql = filterString.getFilterString();
            otherFilterInfo.getFilterItems().add(new FilterItemInfo("permchange.id", (Object)filterSql.toString(), CompareType.INNER));
            otherFilterInfo.setMaskString("( #0 or #1 or #2 or #3 )");
            filterInfo.mergeFilter(otherFilterInfo, "and");
        }
        catch (BOSException e) {
            logger.error((Object)e);
            MsgBox.showDetailAndOK((Component)((Object)this), (String)"\u6784\u5efa\u8fc7\u6ee4\u6761\u4ef6\u5931\u8d25", (String)ThrowableHelper.toString((Exception)((Object)e)), (int)0);
            SysUtil.abort();
        }
    }

    private void addFilterWhenUnauthen(FilterInfo filterInfo, OprtTypeEnum operType) {
        String filterSql = null;
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        FilterString filterString = null;
        if (operType.getValue().equals("10")) {
            filterString = new AssignPerm2UserFilterString(null);
        } else if (operType.getValue().equals("20")) {
            filterString = new AssignRole2UserFilterString(null);
        } else if (operType.getValue().equals("30")) {
            filterString = new AssignUser2RoleFilterString(null);
        } else if (operType.getValue().equals("40")) {
            filterString = new AssignPerm2RoleFilterString(null);
        } else if (operType.getValue().equals("50")) {
            filterString = new CreateNewUserFilterString(null);
        } else if (operType.getValue().equals("70")) {
            filterString = new AssignGrantRole2UserFilterString(null);
        } else if (operType.getValue().equals("80")) {
            filterString = new AssignGrantPerm2UserFilterString(null);
        } else if (operType.getValue().equals("90")) {
            filterString = new AssignPerm2UserFilterString(new AssignRole2UserFilterString(new AssignUser2RoleFilterString(new AssignPerm2RoleFilterString(new CreateNewUserFilterString(new AssignGrantRole2UserFilterString(new AssignGrantPerm2UserFilterString(null)))))));
        }
        filterSql = filterString.getFilterString();
        filterInfo.getFilterItems().add(new FilterItemInfo("permchange.id", (Object)filterSql.toString(), CompareType.INNER));
    }

    private FilterItemInfo getCUFilter(String currentUserId) {
        try {
            List cuOrgRange = PermissionRangeHelper.getBizUserCUOrgRange(null, (IObjectPK)new ObjectUuidPK(currentUserId));
            HashSet cuOrgRangeSet = new HashSet();
            if (cuOrgRange != null && cuOrgRange.size() > 0) {
                cuOrgRangeSet.addAll(cuOrgRange);
                return new FilterItemInfo("cu.id", cuOrgRangeSet, CompareType.INCLUDE);
            }
            return new FilterItemInfo("cu.id", (Object)"", CompareType.INCLUDE);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void actionAuthStatusChanged_actionPerformed(ActionEvent e) throws Exception {
        if (this.mainQuery == null) {
            return;
        }
        this.passAuthen.setEnabled(false);
        this.notPassAuthen.setEnabled(false);
        if (this.authenStatusBox.getSelectedItem().equals((Object)AuthenStatusEnum.UnAuthen) || this.authenStatusBox.getSelectedItem().equals((Object)AuthenStatusEnum.All)) {
            this.passAuthen.setEnabled(true);
            this.notPassAuthen.setEnabled(true);
        }
        this.mainQuery.setFilter(this.getDefaultFilterForQuery());
        this.execQuery();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    @Override
    public void actionPassAuthen_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionPassAuthen_actionPerformed(e);
        ArrayList fidList = this.getSelectedIdValues();
        AuthenRecordFactory.getRemoteInstance().passAuthenNew(fidList);
        MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"authen_success"));
        this.refresh(e);
    }

    @Override
    public void actionNotPassAuthen_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionNotPassAuthen_actionPerformed(e);
        ArrayList fidList = this.getSelectedIdValues();
        IUIFactory uiFactory = null;
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"fidList", (Object)fidList);
        try {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow uiWindow = uiFactory.create("com.kingdee.eas.base.permission.client.AuthenNotPassDialogUI", (Map)uiContext, null, null);
            uiWindow.show();
        }
        catch (UIException ex) {
            MsgBox.showError((Component)((Object)this), (String)ex.getMessage(), (String)ex.toString());
        }
        this.refresh(e);
    }

    @Override
    public void actionAuthenDetail_actionPerformed(ActionEvent e) throws Exception {
        this.showDetail();
    }

    private void showDetail() throws UIException {
        this.checkSelected();
        String uiName = null;
        KDTSelectBlock selectBlock = null;
        UIContext hm = new UIContext((Object)this);
        selectBlock = this.tblMain.getSelectManager().get(0);
        for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
            IRow row = this.tblMain.getRow(j);
            hm.put("id", row.getCell("id").getValue());
            hm.put("permChange.id", row.getCell("permChange.id").getValue());
            BizEnumValueDTO bizEnum = (BizEnumValueDTO)row.getCell("permChange.operType").getValue();
            if ("10".equals(bizEnum.getValue()) || "80".equals(bizEnum.getValue())) {
                uiName = "com.kingdee.eas.base.permission.client.UserAssignPermAuthenDetailListUI";
                continue;
            }
            if ("20".equals(bizEnum.getValue()) || "30".equals(bizEnum.getValue())) {
                uiName = "com.kingdee.eas.base.permission.client.UserAssignRoleAuthenDetailListUI";
                continue;
            }
            if ("40".equals(bizEnum.getValue())) {
                uiName = "com.kingdee.eas.base.permission.client.RoleAssignPermAuthenDetailListUI";
                continue;
            }
            if (!"70".equals(bizEnum.getValue())) continue;
            uiName = "com.kingdee.eas.base.permission.client.UserAssignGrantRoleAuthenDetailListUI";
        }
        if (!StringUtils.isEmpty(uiName)) {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow referUI = uiFactory.create(uiName, (Map)hm);
            referUI.show();
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 1) {
            super.tblMain_tableClicked(e);
        } else if (e.getClickCount() == 2) {
            this.showDetail();
        }
    }

    protected void setAuthenBtnStat(KDTSelectEvent e) throws Exception {
        this.passAuthen.setEnabled(false);
        this.notPassAuthen.setEnabled(false);
        this.authenDetail.setEnabled(true);
        KDTSelectBlock selectBlock = null;
        selectBlock = this.tblMain.getSelectManager().get(0);
        if (KDTableUtil.getSelectedRowCount((KDTable)this.tblMain) > 1) {
            this.authenDetail.setEnabled(false);
        }
        for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
            IRow row = this.tblMain.getRow(j);
            BizEnumValueDTO oprtTypeEnum = (BizEnumValueDTO)row.getCell("permChange.operType").getValue();
            BizEnumValueDTO authenStatusEnum = (BizEnumValueDTO)row.getCell("authenStatus").getValue();
            if ("50".equals(oprtTypeEnum.getValue())) {
                this.authenDetail.setEnabled(false);
            }
            if (!"10".equals(authenStatusEnum.getValue()) && (!"30".equals(authenStatusEnum.getValue()) || !"50".equals(oprtTypeEnum.getValue()))) continue;
            this.passAuthen.setEnabled(true);
            this.notPassAuthen.setEnabled(true);
        }
    }

    @Override
    public void actionOperTypeChanged_actionPerformed(ActionEvent e) throws Exception {
        if (this.mainQuery == null) {
            return;
        }
        this.passAuthen.setEnabled(false);
        this.notPassAuthen.setEnabled(false);
        if (this.authenStatusBox.getSelectedItem().equals((Object)AuthenStatusEnum.UnAuthen) || this.authenStatusBox.getSelectedItem().equals((Object)AuthenStatusEnum.All)) {
            this.passAuthen.setEnabled(true);
            this.notPassAuthen.setEnabled(true);
        }
        this.mainQuery.setFilter(this.getDefaultFilterForQuery());
        this.execQuery();
    }

    private class AssignGrantPerm2UserFilterString
    extends FilterString {
        protected AssignGrantPerm2UserFilterString(FilterString next) {
            super(next);
        }

        @Override
        protected void initFilterString() {
            UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
            StringBuffer filterSql = new StringBuffer();
            filterSql.append("select userpermchange.fpermchangeid ").append("from t_pm_userorgpermchange as userpermchange ").append("inner join t_pm_authenschemesnapview as snapview on snapview.fpermchangerecordid = userpermchange.fpermchangeid and userpermchange.fpermitemid = snapview.fpermitemid ").append("where userpermchange.fpermchangeid = permchange.fid and ").append("snapview.fuserid = '").append(user.getId().toString()).append("' and ").append("userpermchange.fauthenstatus = '").append("10").append("'");
            this.filterString = filterSql.toString();
        }
    }

    private class AssignGrantRole2UserFilterString
    extends FilterString {
        protected AssignGrantRole2UserFilterString(FilterString next) {
            super(next);
        }

        @Override
        protected void initFilterString() {
            UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
            StringBuffer filterSql = new StringBuffer();
            filterSql.append("select urochange.fpermchangeid ").append("from t_pm_grantuserroleorgchange urochange ").append("inner join t_pm_authenschemesnapview snapview on urochange.fpermchangeid = snapview.fpermchangerecordid and urochange.froleid = snapview.froleid ").append("where urochange.fpermchangeid = permchange.fid and ").append("snapview.fuserid = '").append(user.getId().toString()).append("' and ").append("urochange.fauthenstatus = '").append("10").append("'");
            this.filterString = filterSql.toString();
        }
    }

    private class CreateNewUserFilterString
    extends FilterString {
        protected CreateNewUserFilterString(FilterString next) {
            super(next);
        }

        @Override
        protected void initFilterString() {
            UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
            StringBuffer filterSql = new StringBuffer();
            filterSql.append("select snapview.fpermchangerecordid ").append("from t_pm_authenschemesnapview as snapview ").append("inner join t_pm_authenrecord arecord on arecord.fpermchangeid = snapview.fpermchangerecordid and arecord.fauthentorid = snapview.fuserid ").append("where snapview.fpermchangerecordid = permchange.fid and ").append("arecord.fauthenstatus = '").append("10").append("' and ").append("snapview.fuserid = '").append(user.getId().toString()).append("' and ").append("snapview.fpermitemid = '").append("e693ae65-00fd-1000-e000-0018c0a813dbPERMITEM").append("'");
            this.filterString = filterSql.toString();
        }
    }

    private class AssignPerm2RoleFilterString
    extends FilterString {
        protected AssignPerm2RoleFilterString(FilterString next) {
            super(next);
        }

        @Override
        protected void initFilterString() {
            UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
            StringBuffer filterSql = new StringBuffer();
            filterSql.append("select rolepermchange.fpermchangeid ").append("from t_pm_rolepermchange as rolepermchange ").append("inner join t_pm_authenschemesnapview as snapview on snapview.fpermchangerecordid = rolepermchange.fpermchangeid and rolepermchange.fpermitemid = snapview.fpermitemid ").append("where rolepermchange.fpermchangeid = permchange.fid and ").append("snapview.fuserid = '").append(user.getId().toString()).append("' and ").append("rolepermchange.fauthenstatus = '").append("10").append("'");
            this.filterString = filterSql.toString();
        }
    }

    private class AssignUser2RoleFilterString
    extends FilterString {
        protected AssignUser2RoleFilterString(FilterString next) {
            super(next);
        }

        @Override
        protected void initFilterString() {
            UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
            StringBuffer filterSql = new StringBuffer();
            filterSql.append("select urochange.fpermchangeid ").append("from t_pm_userroleorgchange urochange ").append("inner join t_pm_authenschemesnapview snapview on urochange.fpermchangeid = snapview.fpermchangerecordid and urochange.froleid = snapview.froleid ").append("where urochange.fpermchangeid = permchange.fid and ").append("snapview.fuserid = '").append(user.getId().toString()).append("' and ").append("urochange.fauthenstatus = '").append("10").append("'");
            this.filterString = filterSql.toString();
        }
    }

    private class AssignRole2UserFilterString
    extends FilterString {
        protected AssignRole2UserFilterString(FilterString next) {
            super(next);
        }

        @Override
        protected void initFilterString() {
            UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
            StringBuffer filterSql = new StringBuffer();
            filterSql.append("select urochange.fpermchangeid ").append("from t_pm_userroleorgchange urochange ").append("inner join t_pm_authenschemesnapview snapview on urochange.fpermchangeid = snapview.fpermchangerecordid and urochange.froleid = snapview.froleid ").append("where urochange.fpermchangeid = permchange.fid and ").append("snapview.fuserid = '").append(user.getId().toString()).append("' and ").append("urochange.fauthenstatus = '").append("10").append("'");
            this.filterString = filterSql.toString();
        }
    }

    private class AssignPerm2UserFilterString
    extends FilterString {
        protected AssignPerm2UserFilterString(FilterString next) {
            super(next);
        }

        @Override
        protected void initFilterString() {
            UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
            StringBuffer filterSql = new StringBuffer();
            filterSql.append("select userpermchange.fpermchangeid ").append("from t_pm_userorgpermchange as userpermchange ").append("inner join t_pm_authenschemesnapview as snapview on snapview.fpermchangerecordid = userpermchange.fpermchangeid and userpermchange.fpermitemid = snapview.fpermitemid ").append("where userpermchange.fpermchangeid = permchange.fid and ").append("snapview.fuserid = '").append(user.getId().toString()).append("' and ").append("userpermchange.fauthenstatus = '").append("10").append("'");
            this.filterString = filterSql.toString();
        }
    }

    private abstract class FilterString {
        protected FilterString next;
        protected String filterString;

        protected FilterString(FilterString next) {
            this.next = next;
            this.initFilterString();
        }

        protected abstract void initFilterString();

        public final String getFilterString() {
            if (this.next == null) {
                return this.filterString;
            }
            StringBuffer filterStringBuffer = new StringBuffer();
            filterStringBuffer.append(this.filterString);
            filterStringBuffer.append(" union all ");
            filterStringBuffer.append(this.next.getFilterString());
            return filterStringBuffer.toString();
        }
    }
}

