/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.AuthenRecordFactory;
import com.kingdee.eas.base.permission.AuthenStatusEnum;
import com.kingdee.eas.base.permission.OprtTypeEnum;
import com.kingdee.eas.base.permission.client.AbstractAuthenRecordListUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class AuthenRecordListUI
extends AbstractAuthenRecordListUI {
    private static final Logger logger = CoreUIObject.getLogger(AuthenRecordListUI.class);

    public AuthenRecordListUI() throws Exception {
        this.btnCancelAssignment.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnActionAuthenDetail.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.btnCancelAssignment.setEnabled(true);
        this.btnActionAuthenDetail.setEnabled(true);
        this.authenStatusBox.setEnabled(true);
        this.authenStatusBox.removeItem((Object)AuthenStatusEnum.All);
        this.authenStatusBox.removeItem((Object)AuthenStatusEnum.AuthenSuccess);
        this.operTypeBox.removeItem((Object)OprtTypeEnum.UserAuthenWayChange);
        this.operTypeBox.removeItem((Object)OprtTypeEnum.AssignUserToRole);
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    AuthenRecordListUI.this.setAuthenBtnStat(e);
                }
                catch (Exception ex) {
                    AuthenRecordListUI.this.handUIException(ex);
                }
            }
        });
    }

    protected FilterInfo getDefaultFilterForQuery() {
        OprtTypeEnum operType;
        AuthenStatusEnum status = (AuthenStatusEnum)((Object)this.authenStatusBox.getSelectedItem());
        FilterInfo filterInfo = new FilterInfo();
        if (!status.getValue().equals("40")) {
            filterInfo.getFilterItems().add(new FilterItemInfo("authenStatus", (Object)status.getValue(), CompareType.EQUALS));
        }
        if (!(operType = (OprtTypeEnum)((Object)this.operTypeBox.getSelectedItem())).getValue().equals("90")) {
            filterInfo.getFilterItems().add(new FilterItemInfo("permChange.operType", (Object)operType.getValue()));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("assigner.number", (Object)SysContext.getSysContext().getCurrentUserInfo().getNumber()));
        return filterInfo;
    }

    @Override
    public void actionOperTypeChanged_actionPerformed(ActionEvent e) throws Exception {
        if (this.mainQuery == null) {
            return;
        }
        this.mainQuery.setFilter(this.getDefaultFilterForQuery());
        this.execQuery();
    }

    @Override
    public void actionAuthStatusChanged_actionPerformed(ActionEvent e) throws Exception {
        if (this.mainQuery == null) {
            return;
        }
        this.btnCancelAssignment.setEnabled(true);
        if (this.authenStatusBox.getSelectedItem().equals((Object)AuthenStatusEnum.AuthenFail)) {
            this.btnCancelAssignment.setEnabled(false);
        }
        this.mainQuery.setFilter(this.getDefaultFilterForQuery());
        this.execQuery();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionCancelAssignment_actionPerformed(ActionEvent e) throws Exception {
        this.cancelAssignment();
    }

    private void cancelAssignment() throws EASBizException, BOSException {
        this.checkSelected();
        KDTRange range = this.tblMain.getSelectManager().toRange();
        Iterator it = range.iterator();
        ArrayList<String> permChangeIdList = new ArrayList<String>();
        while (it.hasNext()) {
            KDTSelectBlock block = (KDTSelectBlock)it.next();
            int bottom = block.getBottom();
            for (int index = block.getTop(); index <= bottom; ++index) {
                String permChangeId = (String)this.tblMain.getRow(index).getCell("permChange.id").getValue();
                if (StringUtils.isEmpty((String)permChangeId)) continue;
                permChangeIdList.add(permChangeId);
            }
        }
        AuthenRecordFactory.getRemoteInstance().cancelAssign(permChangeIdList);
        this.tblMain.refresh();
    }

    @Override
    public void actionAuthenDetail_actionPerformed(ActionEvent e) throws Exception {
        this.showDetail();
    }

    private void showDetail() throws UIException {
        this.checkSelected();
        String uiName = null;
        KDTSelectBlock selectBlock = null;
        UIContext hm = new UIContext((Object)this);
        selectBlock = this.tblMain.getSelectManager().get(0);
        for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
            IRow row = this.tblMain.getRow(j);
            hm.put("id", row.getCell("id").getValue());
            hm.put("permChange.id", row.getCell("permChange.id").getValue());
            BizEnumValueDTO bizEnum = (BizEnumValueDTO)row.getCell("permChange.operType").getValue();
            if ("10".equals(bizEnum.getValue())) {
                uiName = "com.kingdee.eas.base.permission.client.UserAssignPermAuthenDetailListUI";
                continue;
            }
            if ("20".equals(bizEnum.getValue()) || "30".equals(bizEnum.getValue())) {
                uiName = "com.kingdee.eas.base.permission.client.UserAssignRoleAuthenDetailListUI";
                continue;
            }
            if (!"40".equals(bizEnum.getValue())) continue;
            uiName = "com.kingdee.eas.base.permission.client.RoleAssignPermAuthenDetailListUI";
        }
        if (!StringUtils.isEmpty(uiName)) {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow referUI = uiFactory.create(uiName, (Map)hm);
            referUI.show();
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 1) {
            super.tblMain_tableClicked(e);
        } else if (e.getClickCount() == 2) {
            this.showDetail();
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AuthenRecordFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected void setAuthenBtnStat(KDTSelectEvent e) throws Exception {
        this.btnActionAuthenDetail.setEnabled(true);
        KDTSelectBlock selectBlock = null;
        selectBlock = this.tblMain.getSelectManager().get(0);
        for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
            IRow row = this.tblMain.getRow(j);
            BizEnumValueDTO oprtTypeEnum = (BizEnumValueDTO)row.getCell("permChange.operType").getValue();
            if (!"50".equals(oprtTypeEnum.getValue()) && !"60".equals(oprtTypeEnum.getValue())) continue;
            this.btnActionAuthenDetail.setEnabled(false);
        }
    }
}

