/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.AuthenScheme3DTypeEnum;
import com.kingdee.eas.base.permission.AuthenSchemeRuleFactory;
import com.kingdee.eas.base.permission.client.AbstractAuthenScheme3DViewUI;
import com.kingdee.eas.base.permission.util.ThrowableHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFileChooser;
import org.apache.log4j.Logger;

public class AuthenScheme3DViewUI
extends AbstractAuthenScheme3DViewUI {
    private static final Logger logger = CoreUIObject.getLogger(AuthenScheme3DViewUI.class);
    private AuthenScheme3DTypeEnum thisType = AuthenScheme3DTypeEnum.AuthenScheme_Org_Perm_User;
    private IMetaDataPK defultQueryPK = new MetaDataPK("com.kingdee.eas.base.permission.app", "AuthenSchemePerm3DViewQuery");
    protected static final String PERM_RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    public void onLoad() throws Exception {
        this.initComponent();
        this.setDoRequestData(false);
        if (this.authenSchemeRole3DViewQuery == null) {
            this.authenSchemeRole3DViewQuery = new EntityViewInfo();
        }
        if (this.authenSchemeOrgUser3DViewQuery == null) {
            this.authenSchemeOrgUser3DViewQuery = new EntityViewInfo();
        }
        super.onLoad();
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        String[] orderByPart;
        super.beforeExcutQuery(ev);
        SorterItemCollection sorterItemCol = new SorterItemCollection();
        for (String onePart : orderByPart = this.getFiledOrderByType(this.thisType)) {
            sorterItemCol.add(new SorterItemInfo(onePart));
        }
        ev.setSorter(sorterItemCol);
    }

    protected void execQuery() {
        if (this.getCurrentSolutionInfo() != null) {
            this.setDoRequestData(true);
        }
        super.execQuery();
    }

    @Override
    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        if (!this.isDoRequestData()) {
            return;
        }
        int start = (Integer)e.getParam1();
        int length = (Integer)e.getParam2() - start + 1;
        switch (this.thisType.getValue()) {
            case 100: 
            case 101: {
                this.requestPermRowSet(e, start, length);
                break;
            }
            case 102: {
                this.requestOrgUserRowSet(e, start, length);
                break;
            }
            case 103: {
                this.requestOrgUserRowSet(e, start, length);
                break;
            }
        }
    }

    private void requestOrgUserRowSet(RequestRowSetEvent e, int start, int length) {
        try {
            IQueryExecutor exec = this.getQueryExecutor(this.authenSchemeOrgUser3DViewQueryPK, this.mainQuery);
            IRowSet rowSet = exec.executeQuery(start, length);
            e.setRowSet(rowSet);
            this.onGetRowSet(rowSet);
        }
        catch (Exception ee) {
            this.handUIException(ee);
        }
    }

    private void requestPermRowSet(RequestRowSetEvent e, int start, int length) {
        try {
            IQueryExecutor exec = this.getQueryExecutor(this.mainQueryPK, this.mainQuery);
            IRowSet rowSet = exec.executeQuery(start, length);
            e.setRowSet(rowSet);
            this.onGetRowSet(rowSet);
        }
        catch (Exception ee) {
            this.handUIException(ee);
        }
    }

    private void requestRoleRowSet(RequestRowSetEvent e, int start, int length) {
        try {
            IQueryExecutor exec = this.getQueryExecutor(this.authenSchemeRole3DViewQueryPK, this.authenSchemeRole3DViewQuery);
            IRowSet rowSet = exec.executeQuery(start, length);
            e.setRowSet(rowSet);
            this.onGetRowSet(rowSet);
        }
        catch (Exception ee) {
            this.handUIException(ee);
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return new FilterInfo();
    }

    private void initComponent() {
        this.cbAuthenScheme3DType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AuthenScheme3DViewUI.this.cbAuthenScheme3DType_authenScheme3DTypeChanged(event);
            }
        });
        this.tblMain.checkParsed();
        this.tblMain.getMergeManager().setMergeMode(1);
        this.tblMain.setColumnMoveable(true);
        this.btnAddNew.setVisible(false);
        this.btnView.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnCheckClash.setEnabled(true);
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    private void cbAuthenScheme3DType_authenScheme3DTypeChanged(ActionEvent event) {
        String[] orderByPart;
        KDComboBox authenScheme3DTypeCB = (KDComboBox)event.getSource();
        AuthenScheme3DTypeEnum selectedType = (AuthenScheme3DTypeEnum)((Object)authenScheme3DTypeCB.getSelectedItem());
        if (selectedType.equals((Object)this.thisType)) {
            return;
        }
        this.thisType = selectedType;
        this.changeTable();
        this.showTableColumn(this.thisType);
        this.clearCommonQueryDialog();
        this.mainQuery.clear();
        SorterItemCollection sorterItemCol = new SorterItemCollection();
        for (String onePart : orderByPart = this.getFiledOrderByType(this.thisType)) {
            sorterItemCol.add(new SorterItemInfo(onePart));
        }
        this.mainQueryPK = selectedType.getValue() == 103 ? this.authenSchemeOrgUser3DViewQueryPK : (selectedType.getValue() == 102 ? this.authenSchemeOrg3DViewQueryPK : this.defultQueryPK);
        int selectedTypeValue = selectedType.getValue();
        if (100 != selectedTypeValue) {
            this.mainQuery.setSorter(sorterItemCol);
        } else {
            this.authenSchemeRole3DViewQuery.setSorter(sorterItemCol);
        }
        this.tblMain.removeRows();
    }

    private boolean isPermType(AuthenScheme3DTypeEnum selectedType) {
        switch (selectedType.getValue()) {
            case 100: 
            case 101: {
                return true;
            }
        }
        return false;
    }

    private void showTableColumn(AuthenScheme3DTypeEnum thisType) {
        boolean isPermType = this.isPermType(thisType);
        this.tblMain.getColumn("permItem.number").getStyleAttributes().setHided(!isPermType);
        this.tblMain.getColumn("permItem.alias").getStyleAttributes().setHided(!isPermType);
        this.tblMain.getColumn("role.number").getStyleAttributes().setHided(isPermType);
        this.tblMain.getColumn("role.name").getStyleAttributes().setHided(isPermType);
        int typeValue = thisType.getValue();
        if (typeValue == 102 || typeValue == 103) {
            this.tblMain.getColumn("authenSchemeRule.isRule").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("role.number").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("role.name").getStyleAttributes().setHided(true);
            if (typeValue == 102) {
                this.tblMain.getColumn("user.name").getStyleAttributes().setHided(true);
                this.tblMain.getColumn("user.number").getStyleAttributes().setHided(true);
            } else {
                this.tblMain.getColumn("user.name").getStyleAttributes().setHided(false);
                this.tblMain.getColumn("user.number").getStyleAttributes().setHided(false);
            }
        } else {
            this.tblMain.getColumn("authenSchemeRule.isRule").getStyleAttributes().setHided(false);
        }
    }

    private void changeTable() {
        String[] newColumnOrderArray = this.getColumnOrderByType(this.thisType);
        if (newColumnOrderArray == null) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)PERM_RESOURCE, (String)"GET_ORDER_NOT_EMPTY"), (String)ThrowableHelper.toString(new BOSException(EASResource.getString((String)PERM_RESOURCE, (String)"GET_ORDER_NOT_EMPTY"))), (int)0);
            SysUtil.abort();
        }
        String nextColumnKey = null;
        int oldIndex = -1;
        for (int newIndex = 0; newIndex < newColumnOrderArray.length; ++newIndex) {
            nextColumnKey = newColumnOrderArray[newIndex];
            oldIndex = this.tblMain.getColumnIndex(nextColumnKey);
            this.tblMain.moveColumn(oldIndex, newIndex);
        }
    }

    private String[] getColumnOrderByType(AuthenScheme3DTypeEnum type) {
        switch (type.getValue()) {
            case 100: {
                return new String[]{"id", "authenScheme.id", "authenScheme.number", "authenScheme.name", "org.id", "org.number", "org.name", "permItem.id", "permItem.number", "permItem.alias", "user.id", "user.number", "user.name", "authenSchemeRule.isRule"};
            }
            case 101: {
                return new String[]{"id", "user.id", "user.number", "user.name", "org.id", "org.number", "org.name", "permItem.id", "permItem.number", "permItem.alias", "authenScheme.id", "authenScheme.number", "authenScheme.name", "authenSchemeRule.isRule"};
            }
            case 102: {
                return new String[]{"authenScheme.id", "authenScheme.number", "authenScheme.name", "org.id", "org.number", "org.name"};
            }
            case 103: {
                return new String[]{"authenScheme.id", "authenScheme.number", "authenScheme.name", "org.id", "org.number", "org.name", "user.id", "user.number", "user.name"};
            }
        }
        return new String[0];
    }

    private String[] getFiledOrderByType(AuthenScheme3DTypeEnum type) {
        switch (type.getValue()) {
            case 100: {
                return new String[]{"authenScheme.number", "authenScheme.name", "org.number", "org.name", "permItem.number", "permItem.alias", "user.number", "user.name"};
            }
            case 101: {
                return new String[]{"user.number", "user.name", "org.number", "org.name", "permItem.number", "permItem.alias", "authenScheme.number", "authenScheme.name"};
            }
            case 102: {
                return new String[]{"authenScheme.id", "authenScheme.number", "authenScheme.name", "org.id", "org.number", "org.name"};
            }
            case 103: {
                return new String[]{"authenScheme.id", "authenScheme.number", "authenScheme.name", "org.id", "org.number", "org.name", "user.id", "user.number", "user.name"};
            }
        }
        return new String[0];
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    @Override
    public void actionCheckClash_actionPerformed(ActionEvent event) throws Exception {
        super.actionCheckClash_actionPerformed(event);
        Object[] clashAuthenSchemeInfoLists = AuthenSchemeRuleFactory.getRemoteInstance().checkAllRuleClash();
        List permClashAuthenSchemeInfoList = (List)clashAuthenSchemeInfoLists[0];
        List roleClashAuthenSchemeInfoList = (List)clashAuthenSchemeInfoLists[1];
        if (this.isNoClash(permClashAuthenSchemeInfoList) && this.isNoClash(roleClashAuthenSchemeInfoList)) {
            MsgBox.showInfo((String)EASResource.getString((String)PERM_RESOURCE, (String)"CONGRA_NOT_CONFLICT"));
            return;
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle("\u6b8b\u5ff5\uff0c\u6709\u51b2\u7a81\uff0c\u8bf7\u9009\u62e9\u5bfc\u51fa\u76ee\u5f55");
        chooser.setApproveButtonText(EASResource.getString((String)PERM_RESOURCE, (String)"EXPORT_THIS_DIR"));
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal != 0) {
            return;
        }
        File dirFile = chooser.getSelectedFile();
        if (!this.isNoClash(permClashAuthenSchemeInfoList)) {
            this.wirteLog(dirFile, permClashAuthenSchemeInfoList, EASResource.getString((String)PERM_RESOURCE, (String)"PERM_ORG_CERTI_SERI") + "\n", "perm_");
        }
        if (!this.isNoClash(roleClashAuthenSchemeInfoList)) {
            this.wirteLog(dirFile, roleClashAuthenSchemeInfoList, EASResource.getString((String)PERM_RESOURCE, (String)"ROLE_ORG_CERTI_SERIA") + "\n", "role_");
        }
        MsgBox.showInfo((String)EASResource.getString((String)PERM_RESOURCE, (String)"EXPORT_SUCCEED"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wirteLog(File dirFile, List clashAuthenSchemeInfoList, String head, String fileNamePrefix) {
        Writer csvWriter = null;
        try {
            if (!dirFile.exists()) {
                dirFile.mkdirs();
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
            String exportFileName = fileNamePrefix + dateFormat.format(new Date()) + ".csv";
            File exportFile = new File(dirFile, exportFileName);
            if (exportFile.exists()) {
                exportFile.delete();
            }
            exportFile.createNewFile();
            csvWriter = new BufferedWriter(new FileWriter(exportFile));
            csvWriter.write(head);
            Iterator clashAuthenSchemeInfoIter = clashAuthenSchemeInfoList.iterator();
            Object[] clashAuthenSchemeInfo = null;
            String keyName = null;
            String orgName = null;
            String schemeName = null;
            boolean isRule = false;
            while (clashAuthenSchemeInfoIter.hasNext()) {
                clashAuthenSchemeInfo = (Object[])clashAuthenSchemeInfoIter.next();
                keyName = (String)clashAuthenSchemeInfo[0];
                orgName = (String)clashAuthenSchemeInfo[1];
                schemeName = (String)clashAuthenSchemeInfo[2];
                isRule = (Boolean)clashAuthenSchemeInfo[3];
                csvWriter.write(keyName);
                csvWriter.write(", ");
                csvWriter.write(orgName);
                csvWriter.write(", ");
                csvWriter.write(schemeName);
                csvWriter.write(", ");
                csvWriter.write(String.valueOf(isRule));
                csvWriter.write("\n");
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)PERM_RESOURCE, (String)"FILD_TO_CLOSE_STREAM"), (String)ThrowableHelper.toString(e), (int)0);
            SysUtil.abort();
        }
        finally {
            try {
                if (csvWriter != null) {
                    csvWriter.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)e);
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)PERM_RESOURCE, (String)"FILD_TO_CLOSE_STREAM"), (String)ThrowableHelper.toString(e), (int)0);
            }
        }
    }

    private boolean isNoClash(List clashInfoList) {
        return clashInfoList == null || clashInfoList.isEmpty();
    }
}

