/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.AuthenSchemePermFactory;
import com.kingdee.eas.base.permission.IAuthenSchemePerm;
import com.kingdee.eas.base.permission.IUserOrgPermFacade;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.UserOrgPermFacadeFactory;
import com.kingdee.eas.base.permission.client.AbstractAuthenSchemeChangePermUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.util.ILongTimeTask2;
import com.kingdee.eas.csinterface.util.LongTimeDialog2;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.csinterface.util.UITools2;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class AuthenSchemeChangePermUI
extends AbstractAuthenSchemeChangePermUI {
    private static final Logger logger = CoreUIObject.getLogger(AuthenSchemeChangePermUI.class);
    protected static final String PERM_RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private static final String EXPANDED_KEY = "expanded";
    private static final String NEED_ALL_KEY = "needAll";
    private Set<String> addPermItemSet = new HashSet<String>();
    private Set<String> deletePermItemSet = new HashSet<String>();
    private String authenSchemeId = null;
    private boolean isNeedAuthenWhenCreateUser = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.preparePerm();
        this.prepareButton();
        this.prepareTree();
        this.initCheckBox();
    }

    private void initCheckBox() {
        this.fillCheckBox();
        this.ckNeedAuthenWhenCreateUser.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                if (!KDCheckBox.class.isInstance(event.getSource())) {
                    return;
                }
                KDCheckBox needAuthenWhenCreateUserCheckBox = (KDCheckBox)event.getSource();
                AuthenSchemeChangePermUI.this.isNeedAuthenWhenCreateUser = needAuthenWhenCreateUserCheckBox.isSelected();
            }
        });
    }

    private void fillCheckBox() {
        try {
            this.isNeedAuthenWhenCreateUser = AuthenSchemePermFactory.getRemoteInstance().isNeedAuthenWhenCreateUser(this.authenSchemeId);
            this.ckNeedAuthenWhenCreateUser.setSelected(this.isNeedAuthenWhenCreateUser);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)PERM_RESOURCE, (String)"FILL_SELECT_FAIL"), (String)ThrowableHelper.toString((Exception)((Object)e)), (int)0);
            SysUtil.abort();
        }
    }

    private void preparePerm() {
        Object authenSchemeIdObj = this.getUIContext().get("authenSchemeId");
        if (authenSchemeIdObj == null) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)PERM_RESOURCE, (String)"FILL_SELECT_FAIL"), (String)ThrowableHelper.toString((Exception)((Object)new BOSException(EASResource.getString((String)PERM_RESOURCE, (String)"FILL_SELECT_FAIL")))), (int)0);
            SysUtil.abort();
        }
        this.authenSchemeId = (String)authenSchemeIdObj;
        this.getUIContext().remove("authenShemeId");
    }

    private void prepareButton() {
        this.btnAdd.setEnabled(true);
        this.btnAddAll.setEnabled(true);
        this.btnDelete.setEnabled(true);
        this.btnDeleteAll.setEnabled(true);
        this.btnSave.setEnabled(true);
    }

    private void prepareTree() throws Exception {
        this.prepareSourceTree();
        this.prepareTargetTree();
        this.clearTree(this.sourceTree);
        this.clearTree(this.targetTree);
        this.buildSourceTopTree();
        this.buildTargetTopTree();
    }

    private void prepareSourceTree() {
        this.sourceTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                KDTreeNode clickTreeNode = (KDTreeNode)event.getPath().getLastPathComponent();
                if (clickTreeNode == null) {
                    return;
                }
                if (clickTreeNode.getChildCount() > 0) {
                    return;
                }
                try {
                    AuthenSchemeChangePermUI.this.buildSourceLevelTree(clickTreeNode);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    MsgBox.showDetailAndOK((Component)((Object)AuthenSchemeChangePermUI.this), (String)EASResource.getString((String)AuthenSchemeChangePermUI.PERM_RESOURCE, (String)"BUILD_TREE_FAIL_SRC"), (String)ThrowableHelper.toString((Exception)e), (int)0);
                    SysUtil.abort();
                }
            }
        });
    }

    private void prepareTargetTree() {
        this.targetTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                KDTreeNode clickTreeNode = (KDTreeNode)event.getPath().getLastPathComponent();
                if (clickTreeNode == null) {
                    return;
                }
                PermItemInfo permItemInfo = (PermItemInfo)clickTreeNode.getUserObject();
                if (permItemInfo == null) {
                    clickTreeNode.removeAllChildren();
                    return;
                }
                boolean expanded = AuthenSchemeChangePermUI.this.getExtendedProperty(permItemInfo, AuthenSchemeChangePermUI.EXPANDED_KEY);
                if (expanded) {
                    return;
                }
                try {
                    AuthenSchemeChangePermUI.this.buildTargetLevelTree(clickTreeNode);
                    AuthenSchemeChangePermUI.this.setExtendedProperty(permItemInfo, AuthenSchemeChangePermUI.EXPANDED_KEY, Boolean.TRUE.toString());
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    MsgBox.showDetailAndOK((Component)((Object)AuthenSchemeChangePermUI.this), (String)EASResource.getString((String)AuthenSchemeChangePermUI.PERM_RESOURCE, (String)"BUILD_TREE_FAIL_TAR"), (String)ThrowableHelper.toString((Exception)e), (int)0);
                    SysUtil.abort();
                }
            }
        });
    }

    private void clearTree(KDTree tree) {
        ((DefaultTreeModel)tree.getModel()).setRoot(null);
    }

    private void buildTopTree(KDTree tree, PermItemCollection permItemCol) {
        Iterator topPermItemIter = permItemCol.iterator();
        PermItemInfo permItemInfo = null;
        KDTreeNode node = null;
        KDTreeNode root = null;
        HashMap<String, KDTreeNode> allPermItem = new HashMap<String, KDTreeNode>();
        while (topPermItemIter.hasNext()) {
            permItemInfo = (PermItemInfo)topPermItemIter.next();
            if (permItemInfo.getParent() == null) {
                if (root != null) {
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)(EASResource.getString((String)PERM_RESOURCE, (String)"TREE_ROOT_ONLYONE") + tree), (String)ThrowableHelper.toString((Exception)((Object)new BOSException(EASResource.getString((String)PERM_RESOURCE, (String)"TREE_ROOT_ONLYONE") + tree))), (int)0);
                    SysUtil.abort();
                }
                root = new KDTreeNode((Object)permItemInfo);
                root.setText(permItemInfo.getAlias());
                allPermItem.put(permItemInfo.getId().toString(), root);
                continue;
            }
            node = new KDTreeNode((Object)permItemInfo);
            node.setText(permItemInfo.getAlias());
            allPermItem.put(permItemInfo.getId().toString(), node);
        }
        this.buildTopTree(tree, allPermItem, root);
    }

    private void buildTopTree(KDTree tree, Map<String, KDTreeNode> allPermItem, KDTreeNode root) {
        KDTreeNode node = null;
        KDTreeNode parentNode = null;
        PermItemInfo permItemInfo = null;
        PermItemInfo parentPermItemInfo = null;
        for (String key : allPermItem.keySet()) {
            node = allPermItem.get(key);
            permItemInfo = (PermItemInfo)node.getUserObject();
            parentPermItemInfo = permItemInfo.getParent();
            if (parentPermItemInfo == null) continue;
            parentNode = allPermItem.get(parentPermItemInfo.getId().toString());
            parentNode.add((MutableTreeNode)node);
        }
        tree.setModel((TreeModel)new DefaultTreeModel((TreeNode)root){

            @Override
            public boolean isLeaf(Object obj) {
                if (!KDTreeNode.class.isInstance(obj)) {
                    return super.isLeaf(obj);
                }
                Object userObj = ((KDTreeNode)obj).getUserObject();
                if (!PermItemInfo.class.isInstance(userObj)) {
                    return super.isLeaf(obj);
                }
                return ((PermItemInfo)userObj).isIsLeaf();
            }
        });
    }

    private boolean getExtendedProperty(PermItemInfo permItemInfo, String key) {
        return Boolean.parseBoolean(permItemInfo.getExtendedProperty(key));
    }

    private void setExtendedProperty(PermItemInfo permItemInfo, String key, String value) {
        permItemInfo.setExtendedProperty(key, value);
    }

    private void updateTree(KDTree tree) {
        tree.updateUI();
    }

    private void buildSourceTopTree() throws Exception {
        try {
            IUserOrgPermFacade iuopFacade = UserOrgPermFacadeFactory.getRemoteInstance();
            PermItemCollection permItemCol = iuopFacade.getTopSourcePermitems();
            this.buildTopTree(this.sourceTree, permItemCol);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw e;
        }
    }

    private void buildSourceLevelTree(KDTreeNode clickTreeNode) throws BOSException, EASBizException {
        PermItemInfo clickPermItem = (PermItemInfo)clickTreeNode.getUserObject();
        if (clickPermItem == null) {
            return;
        }
        IUserOrgPermFacade iuopFacade = UserOrgPermFacadeFactory.getRemoteInstance();
        PermItemCollection permItemCol = iuopFacade.getlevelPermitemsByParent(clickPermItem.getId().toString());
        this.buildSourceLevelTree(clickTreeNode, permItemCol);
    }

    private void buildSourceLevelTree(KDTreeNode parent, PermItemCollection permItemCol) {
        Iterator permItemIter = permItemCol.iterator();
        KDTreeNode node = null;
        PermItemInfo permItem = null;
        while (permItemIter.hasNext()) {
            permItem = (PermItemInfo)permItemIter.next();
            node = new KDTreeNode((Object)permItem);
            node.setText(permItem.getAlias());
            parent.add((MutableTreeNode)node);
        }
    }

    private void buildTargetTopTree() {
        try {
            PermItemCollection permItemCol = AuthenSchemePermFactory.getRemoteInstance().getTargetChildPermCol(this.authenSchemeId, null);
            this.buildTopTree(this.targetTree, permItemCol);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)PERM_RESOURCE, (String)"BUILD_TREE_FAIL_TAR_TOP"), (String)ThrowableHelper.toString((Exception)((Object)e)), (int)0);
            SysUtil.abort();
        }
    }

    private void buildTargetLevelTree(KDTreeNode parent) throws Exception {
        PermItemInfo parentPermItemInfo = (PermItemInfo)parent.getUserObject();
        boolean needAll = this.getExtendedProperty(parentPermItemInfo, NEED_ALL_KEY);
        PermItemCollection childPermItemCol = null;
        childPermItemCol = needAll ? AuthenSchemePermFactory.getRemoteInstance().getTargetAllChidPermCol(parentPermItemInfo) : AuthenSchemePermFactory.getRemoteInstance().getTargetChildPermCol(this.authenSchemeId, parentPermItemInfo);
        if (childPermItemCol.isEmpty()) {
            return;
        }
        Iterator childPermItemIter = childPermItemCol.iterator();
        PermItemInfo childPermItemInfo = null;
        KDTreeNode childNode = null;
        while (childPermItemIter.hasNext()) {
            childPermItemInfo = (PermItemInfo)childPermItemIter.next();
            childNode = new KDTreeNode((Object)childPermItemInfo);
            childNode.setText(childPermItemInfo.getAlias());
            parent.add((MutableTreeNode)childNode);
        }
    }

    private void addTragetTreeNode(TreePath selectionTreePath) {
        List<Object> allTreeList = Arrays.asList(selectionTreePath.getPath());
        Iterator<Object> allTreeIter = allTreeList.iterator();
        KDTreeNode root = (KDTreeNode)this.targetTree.getModel().getRoot();
        KDTreeNode nextSelectedNode = (KDTreeNode)allTreeIter.next();
        if (root == null) {
            root = this.findTargetTreeChildNode(null, nextSelectedNode);
            this.targetTree.setModel((TreeModel)new DefaultTreeModel((TreeNode)root){

                @Override
                public boolean isLeaf(Object obj) {
                    if (!KDTreeNode.class.isInstance(obj)) {
                        return super.isLeaf(obj);
                    }
                    Object userObj = ((KDTreeNode)obj).getUserObject();
                    if (!PermItemInfo.class.isInstance(userObj)) {
                        return super.isLeaf(obj);
                    }
                    return ((PermItemInfo)userObj).isIsLeaf();
                }
            });
        }
        KDTreeNode targetTreeNode = root;
        while (allTreeIter.hasNext()) {
            this.expandTargetTreeNode(targetTreeNode);
            nextSelectedNode = (KDTreeNode)allTreeIter.next();
            targetTreeNode = this.findTargetTreeChildNode(targetTreeNode, nextSelectedNode);
        }
        PermItemInfo targetTreePermItemInfo = (PermItemInfo)targetTreeNode.getUserObject();
        this.setExtendedProperty(targetTreePermItemInfo, NEED_ALL_KEY, Boolean.TRUE.toString());
        this.expandTargetTreeNode(targetTreeNode);
    }

    private void expandTargetTreeNode(KDTreeNode needExpandTreeNode) {
        boolean needExpand;
        PermItemInfo needExpandTreePermItemInfo;
        PermItemInfo permItemInfo = needExpandTreePermItemInfo = needExpandTreeNode == null ? null : (PermItemInfo)needExpandTreeNode.getUserObject();
        boolean bl = needExpandTreePermItemInfo == null ? false : (needExpand = !this.getExtendedProperty(needExpandTreePermItemInfo, EXPANDED_KEY));
        if (needExpand) {
            this.targetTree.expandPath(new TreePath(needExpandTreeNode.getPath()));
        }
    }

    private KDTreeNode findTargetTreeChildNode(KDTreeNode parentNode, KDTreeNode needFindNode) {
        KDTreeNode findedNode = null;
        PermItemInfo needFindPermItemInfo = (PermItemInfo)needFindNode.getUserObject();
        String needFindPermItemId = needFindPermItemInfo.getId().toString();
        if (parentNode == null) {
            return this.copyTreeNode(needFindNode);
        }
        Enumeration childrenEnumera = parentNode.children();
        KDTreeNode childNode = null;
        PermItemInfo childPermItemInfo = null;
        String childPermItemId = null;
        while (childrenEnumera.hasMoreElements()) {
            childNode = (KDTreeNode)childrenEnumera.nextElement();
            childPermItemInfo = (PermItemInfo)childNode.getUserObject();
            childPermItemId = childPermItemInfo.getId().toString();
            if (!needFindPermItemId.equals(childPermItemId)) continue;
            return childNode;
        }
        findedNode = this.copyTreeNode(needFindNode);
        parentNode.add((MutableTreeNode)findedNode);
        return findedNode;
    }

    private KDTreeNode copyTreeNode(KDTreeNode node) {
        PermItemInfo permItemInfo = (PermItemInfo)node.getUserObject();
        permItemInfo = (PermItemInfo)permItemInfo.clone();
        permItemInfo.removeExtendedProperty(NEED_ALL_KEY);
        permItemInfo.removeExtendedProperty(EXPANDED_KEY);
        KDTreeNode newTreeNode = new KDTreeNode((Object)permItemInfo);
        newTreeNode.setText(permItemInfo.getAlias());
        return newTreeNode;
    }

    @Override
    public void actionAddAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddAll_actionPerformed(e);
        this.clearTree(this.targetTree);
        IAuthenSchemePerm iAuthenSchemePerm = AuthenSchemePermFactory.getRemoteInstance();
        PermItemCollection permItemCol = iAuthenSchemePerm.getTargetAllChidPermCol(null);
        this.buildTopTree(this.targetTree, permItemCol);
        this.deletePermItemSet.clear();
        this.addPermItemSet.clear();
        this.addPermItemSet = iAuthenSchemePerm.getTargetAddLeafChildPermCol(this.authenSchemeId, null);
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        super.actionAdd_actionPerformed(e);
        TreePath selectionTreePath = this.sourceTree.getSelectionPath();
        if (selectionTreePath == null) {
            MsgBox.showInfo((String)EASResource.getString((String)PERM_RESOURCE, (String)"PLEASE_SELECT_LEFT_TREE"));
            return;
        }
        this.addTragetTreeNode(selectionTreePath);
        IAuthenSchemePerm iAuthenScheme = AuthenSchemePermFactory.getRemoteInstance();
        KDTreeNode lastNode = (KDTreeNode)selectionTreePath.getLastPathComponent();
        PermItemInfo permItemInfo = (PermItemInfo)lastNode.getUserObject();
        Set addSet = iAuthenScheme.getTargetAddLeafChildPermCol(this.authenSchemeId, permItemInfo);
        this.addPermItemSet.addAll(addSet);
        Set allLeafChildSet = iAuthenScheme.getTargetLeafChildPermCol(this.authenSchemeId, permItemInfo);
        this.deletePermItemSet.removeAll(allLeafChildSet);
        this.updateTree(this.targetTree);
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelete_actionPerformed(e);
        TreePath selectionTreePath = this.targetTree.getSelectionPath();
        if (selectionTreePath == null) {
            MsgBox.showInfo((String)EASResource.getString((String)PERM_RESOURCE, (String)"PLEASE_SELECT_RIGHT_TREE"));
            return;
        }
        KDTreeNode node = (KDTreeNode)selectionTreePath.getLastPathComponent();
        if (node.isRoot()) {
            this.clearTree(this.targetTree);
        } else {
            node.removeFromParent();
        }
        PermItemInfo permItemInfo = (PermItemInfo)node.getUserObject();
        Set deleteSet = AuthenSchemePermFactory.getRemoteInstance().getTargetLeafChildPermCol(this.authenSchemeId, permItemInfo);
        this.addPermItemSet.removeAll(deleteSet);
        this.deletePermItemSet.addAll(deleteSet);
        this.updateTree(this.targetTree);
    }

    @Override
    public void actionDeleteAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeleteAll_actionPerformed(e);
        this.clearTree(this.targetTree);
        this.addPermItemSet.clear();
        Set deleteSet = AuthenSchemePermFactory.getRemoteInstance().getTargetLeafChildPermCol(this.authenSchemeId, null);
        this.deletePermItemSet.addAll(deleteSet);
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        LongTimeDialog2 dialog = UITools2.getDialog((Component)((Object)this), (String)EASResource.getString((String)PERM_RESOURCE, (String)"EXECUTE_UPDATEING"), (String)EASResource.getString((String)PERM_RESOURCE, (String)"WAITING"));
        dialog.setLongTimeTask(new ILongTimeTask2(){

            public Object exec() throws Exception {
                try {
                    AuthenSchemePermFactory.getRemoteInstance().saveChange(AuthenSchemeChangePermUI.this.authenSchemeId, AuthenSchemeChangePermUI.this.addPermItemSet, AuthenSchemeChangePermUI.this.deletePermItemSet, AuthenSchemeChangePermUI.this.isNeedAuthenWhenCreateUser);
                    return "success";
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    return e;
                }
            }

            public void afterExec(Object result) throws Exception {
                if (Throwable.class.isInstance(result)) {
                    MsgBox.showDetailAndOK((Component)((Object)AuthenSchemeChangePermUI.this), (String)EASResource.getString((String)AuthenSchemeChangePermUI.PERM_RESOURCE, (String)"EXECUTE_FAIL"), (String)ThrowableHelper.toString((Throwable)((Throwable)result)), (int)0);
                } else if ("success".equals(result)) {
                    AuthenSchemeChangePermUI.this.addPermItemSet.clear();
                    AuthenSchemeChangePermUI.this.deletePermItemSet.clear();
                    AuthenSchemeChangePermUI.this.buildTargetTopTree();
                    MsgBox.showInfo((String)EASResource.getString((String)AuthenSchemeChangePermUI.PERM_RESOURCE, (String)"EXECUTE_COMPLATE"));
                }
            }
        });
        dialog.show();
    }
}

