/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.syncUI.ThreadPool;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.DynamicCardUserCollection;
import com.kingdee.eas.base.permission.DynamicCardUserFactory;
import com.kingdee.eas.base.permission.DynamicCardUserInfo;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.UsbKeyUserMapCollection;
import com.kingdee.eas.base.permission.UsbKeyUserMapFactory;
import com.kingdee.eas.base.permission.UsbKeyUserMapInfo;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractAuthenticateConfigListUI;
import com.kingdee.eas.base.permission.client.AuthenticateConfigUI;
import com.kingdee.eas.base.permission.client.UserPermViewUI;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.base.permission.client.util.AuthenAdminUtil;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.base.permission.client.util.UIUtil;
import com.kingdee.eas.base.permission.service.OrgRangeService;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class AuthenticateConfigListUI
extends AbstractAuthenticateConfigListUI {
    private static final Logger logger = CoreUIObject.getLogger(AuthenticateConfigListUI.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionUIResource";
    private static final String permissionResource = "com.kingdee.eas.base.permission.PermissionResource";
    private final String USER_ID_LIST = "SelectUserIDList";
    private OrgRangeCollection currentOrgRange = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initContext();
        this.setFilterInfo();
    }

    public void initContext() {
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setAuthWay.setIcon(EASResource.getIcon((String)"imgTbtn_duizsetting"));
        this.notPassAuth.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.passAuth.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.viewPerm.setIcon(EASResource.getIcon((String)"imgTbtn_userview"));
        this.viewPerm.setEnabled(true);
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    protected void execQuery() {
        this.setFilterInfo();
        super.execQuery();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    private void setFilterInfo() {
        String subMaskString;
        ArrayList userRangeList;
        try {
            userRangeList = OrgRangeService.getCUOrgRange(null, ToolUtils.getCurrentUserPK());
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            userRangeList = new ArrayList();
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            userRangeList = new ArrayList();
        }
        FilterItemInfo filterItemInfo = new FilterItemInfo("CU.id", (Object)ToolUtils.aryToStr(userRangeList, false), CompareType.INCLUDE);
        if (this.mainQuery.getFilter() == null) {
            this.mainQuery.setFilter(new FilterInfo());
        }
        this.mainQuery.getFilter().getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("id ", (Object)"00000000-0000-0000-0000-00000000000113B7DE7F", CompareType.NOTEQUALS);
        this.mainQuery.getFilter().getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("id ", (Object)ToolUtils.getCurrentUser().getId().toString(), CompareType.NOTEQUALS);
        this.mainQuery.getFilter().getFilterItems().add(filterItemInfo);
        int filtSize = this.mainQuery.getFilter().getFilterItems().size();
        String maskString = "#" + (filtSize - 3) + " and #" + (filtSize - 2) + " and #" + (filtSize - 1);
        if (filtSize > 0 && (subMaskString = this.mainQuery.getFilter().getMaskString()) != null) {
            maskString = "(" + subMaskString + ") and " + maskString;
        }
        this.mainQuery.getFilter().setMaskString(maskString);
    }

    @Override
    protected void notPassAuth_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IUser iUser = UserFactory.getRemoteInstance();
        iUser.setRegisterResult(this.getSelectedIdValues(), false);
        MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"infoConfigSuccessful"));
        this.refreshList();
    }

    @Override
    protected void passAuth_actionPerformed(ActionEvent e) throws Exception {
        UserInfo userInfo;
        this.checkSelected();
        UsbKeyUserMapCollection col1 = UsbKeyUserMapFactory.getRemoteInstance().getUsbKeyUserMapCollection("where state = 20");
        DynamicCardUserCollection col2 = DynamicCardUserFactory.getRemoteInstance().getDynamicCardUserCollection("where dynamicState = 0");
        HashSet<String> set = new HashSet<String>();
        Iterator it = col1.iterator();
        while (it.hasNext()) {
            userInfo = ((UsbKeyUserMapInfo)it.next()).getUser();
            if (userInfo == null) continue;
            set.add(userInfo.getId().toString());
        }
        it = col2.iterator();
        while (it.hasNext()) {
            userInfo = ((DynamicCardUserInfo)it.next()).getUser();
            if (userInfo == null) continue;
            set.add(userInfo.getId().toString());
        }
        Map map = this.getSelectUserIDMap();
        Iterator it2 = map.keySet().iterator();
        while (it2.hasNext()) {
            String key = it2.next().toString();
            if (set.contains(key) || 0 == ((BizEnumValueInfo)map.get(key)).getInt()) continue;
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"infoCanNotCertified"));
            return;
        }
        IUser iUser = UserFactory.getRemoteInstance();
        iUser.setRegisterResult(this.getSelectedIdValues(), true);
        MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"infoConfigSuccessful"));
        this.refreshList();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    protected void setAuthWay_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("SelectUserIDList", this.getSelectedIdValues());
        hm.put("Owner", (Object)this);
        UIUtil.showWindow(hm, AuthenticateConfigUI.class.getName());
    }

    public OrgRangeCollection getCurrentOrgRange() throws EASBizException, BOSException {
        if (this.currentOrgRange == null) {
            this.currentOrgRange = AuthenAdminUtil.getCurrentUserOrgRange();
        }
        return this.currentOrgRange;
    }

    private Map getSelectUserIDMap() {
        KDTRange range = this.tblMain.getSelectManager().toRange();
        Iterator it = range.iterator();
        HashMap<String, Object> authWayMap = new HashMap<String, Object>();
        while (it.hasNext()) {
            KDTSelectBlock block = (KDTSelectBlock)it.next();
            int bottom = block.getBottom();
            for (int index = block.getTop(); index <= bottom; ++index) {
                String userId = (String)this.tblMain.getRow(index).getCell("id").getValue();
                Object authWay = this.tblMain.getRow(index).getCell("loginAuthorWay").getValue();
                authWayMap.put(userId, authWay);
            }
        }
        return authWayMap;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    private void checkSystemUser() throws Exception {
        if (Administrator.isCUAdmin(null, (IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)permissionResource, (String)"adminCanNotViewPerm"));
            this.abort();
        }
    }

    @Override
    public void actionViewPerm_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkSystemUser();
        LongTimeDialog dialog = UITools.getDialog((Component)((Object)this));
        dialog.setLongTimeTask(new ILongTimeTask(){

            @Override
            public Object exec() throws Exception {
                UIContext uiContext = new UIContext((Object)AuthenticateConfigListUI.this);
                uiContext.put((Object)"targetID", (Object)AuthenticateConfigListUI.this.getSelectedKeyValue());
                uiContext.put((Object)"openModel", (Object)"dialog");
                return UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(UserPermViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            }

            @Override
            public void afterExec(Object result) throws Exception {
                UITools.showObject(result);
                ThreadPool.destroyMonitor();
            }
        });
        dialog.show();
    }
}

