/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractCUAdminListUI;
import com.kingdee.eas.base.permission.client.UserEditUI;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;

public class CUAdminListUI
extends AbstractCUAdminListUI {
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private static final int USER_ID_INDEX = 0;
    private static final int FORBIDDEN_INDEX = 8;
    private static final int LOCK_INDEX = 9;

    protected String getEditUIName() {
        return UserEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return UserFactory.getRemoteInstance();
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor queryExecutor = super.getQueryExecutor(queryPK, viewInfo);
        try {
            queryExecutor.setParameter(1, (Object)this.getCurrentUserPK().toString());
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return queryExecutor;
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    private UserInfo getCurrentUser() {
        return SysContext.getSysContext().getCurrentUserInfo();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int isYes = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"delUserWarning"));
        if (MsgBox.isYes((int)isYes)) {
            try {
                this.processUserDelete();
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"deleteSucceed"));
            }
            catch (EASBizException e1) {
                this.handleException((Exception)((Object)e1));
            }
            catch (BOSException e1) {
                this.handleException((Exception)((Object)e1));
            }
            this.refresh(e);
        }
    }

    private void setStatus() {
    }

    public void onLoad() throws Exception {
        this.setStatus();
        super.onLoad();
        String format = CtrlFormatUtilities.getDateTimeFormatString();
        this.tblMain.getColumn("effectiveDate").getStyleAttributes().setNumberFormat(format);
        this.tblMain.getColumn("invalidationDate").getStyleAttributes().setNumberFormat(format);
        this.removeBtnEASPivot();
    }

    private IObjectPK getCurrentUserPK() {
        return new ObjectUuidPK(this.getCurrentUser().getId());
    }

    @Override
    public void actionForbid_actionPerformed(ActionEvent e) throws Exception {
        super.actionForbid_actionPerformed(e);
        this.checkSelected();
        int isYes = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"confirmForbid"));
        if (MsgBox.isYes((int)isYes)) {
            try {
                this.processUserForbidden(true);
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"forbidSucceed"));
            }
            catch (EASBizException e1) {
                this.handleException((Exception)((Object)e1));
            }
            catch (BOSException e1) {
                this.handleException((Exception)((Object)e1));
            }
            if (this.getEditUIModal().equals("com.kingdee.eas.base.uiframe.client.UIModelDialogFactory")) {
                this.refresh(e);
            }
        }
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dlg = super.initCommonQueryDialog();
        dlg.setShowSorter(false);
        return dlg;
    }

    private void processUserForbidden(boolean isForbidden) throws Exception {
        ArrayList<ObjectUuidPK> arrayList = new ArrayList<ObjectUuidPK>();
        int size = this.tblMain.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            IBlock selectBlock = KDTSelectBlock.change((KDTable)this.tblMain, (IBlock)this.tblMain.getSelectManager().get(i));
            int size1 = selectBlock.getBottom();
            for (int j = selectBlock.getTop(); j <= size1; ++j) {
                Object object = this.tblMain.getRow(j).getCell(0).getValue();
                ObjectUuidPK iObjectPK = new ObjectUuidPK(object.toString());
                arrayList.add(iObjectPK);
            }
        }
        IObjectPK[] userPKs = new IObjectPK[arrayList.size()];
        int length = userPKs.length;
        for (int i = 0; i < length; ++i) {
            userPKs[i] = (IObjectPK)arrayList.get(i);
        }
        IUser iUser = (IUser)this.getBizInterface();
        iUser.forbidUsers(userPKs, isForbidden);
    }

    private void processUserDelete() throws Exception {
        ArrayList<ObjectUuidPK> arrayList = new ArrayList<ObjectUuidPK>();
        int size = this.tblMain.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            IBlock selectBlock = KDTSelectBlock.change((KDTable)this.tblMain, (IBlock)this.tblMain.getSelectManager().get(i));
            int size1 = selectBlock.getBottom();
            for (int j = selectBlock.getTop(); j <= size1; ++j) {
                Object object = this.tblMain.getRow(j).getCell(0).getValue();
                ObjectUuidPK iObjectPK = new ObjectUuidPK(object.toString());
                arrayList.add(iObjectPK);
            }
        }
        IObjectPK[] userPKs = new IObjectPK[arrayList.size()];
        int length = userPKs.length;
        for (int i = 0; i < length; ++i) {
            userPKs[i] = (IObjectPK)arrayList.get(i);
        }
        IUser iUser = (IUser)this.getBizInterface();
        iUser.delete(userPKs);
    }

    @Override
    public void actionUnForbid_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnForbid_actionPerformed(e);
        this.checkSelected();
        int isYes = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"confirmUnForbid"));
        if (MsgBox.isYes((int)isYes)) {
            try {
                this.processUserForbidden(false);
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"unForbidSucceed"));
            }
            catch (EASBizException e1) {
                this.handleException((Exception)((Object)e1));
            }
            catch (BOSException e1) {
                this.handleException((Exception)((Object)e1));
            }
            this.refresh(e);
        }
    }

    private void processUserLock(boolean isLock) throws Exception, BOSException {
        ArrayList<ObjectUuidPK> arrayList = new ArrayList<ObjectUuidPK>();
        int size = this.tblMain.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            IBlock selectBlock = KDTSelectBlock.change((KDTable)this.tblMain, (IBlock)this.tblMain.getSelectManager().get(i));
            int size1 = selectBlock.getBottom();
            for (int j = selectBlock.getTop(); j <= size1; ++j) {
                Object object = this.tblMain.getRow(j).getCell(0).getValue();
                ObjectUuidPK iObjectPK = new ObjectUuidPK(object.toString());
                arrayList.add(iObjectPK);
            }
        }
        IObjectPK[] userPKs = new IObjectPK[arrayList.size()];
        int length = userPKs.length;
        for (int i = 0; i < length; ++i) {
            userPKs[i] = (IObjectPK)arrayList.get(i);
        }
        IUser iUser = (IUser)this.getBizInterface();
        iUser.lockUsers(userPKs, isLock);
    }

    @Override
    public void actionUnLock_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnLock_actionPerformed(e);
        this.checkSelected();
        int isYes = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"confirmUnLock"));
        if (MsgBox.isYes((int)isYes)) {
            try {
                this.processUserLock(false);
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"unLockSucceed"));
            }
            catch (EASBizException e1) {
                this.handleException((Exception)((Object)e1));
            }
            catch (BOSException e1) {
                this.handleException((Exception)((Object)e1));
            }
            if (this.getEditUIModal().equals("com.kingdee.eas.base.uiframe.client.UIModelDialogFactory")) {
                this.refresh(e);
            }
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        try {
            if (this.isSuperAdmin()) {
                return new FilterInfo();
            }
            ICtrlUnit iCtrlUnit = CtrlUnitFactory.getRemoteInstance();
            String longNumber = iCtrlUnit.getCtrlUnitInfo(this.getCurrentUserCUPK()).getLongNumber();
            FilterInfo filterInfo = new FilterInfo();
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT FID FROM T_ORG_CtrlUnit ").append(" WHERE FLongNumber LIKE '").append(longNumber).append("!%'");
            filterInfo.getFilterItems().add(new FilterItemInfo("cu.id", (Object)sql.toString(), CompareType.INNER));
            FilterInfo cuRangeFilter = ToolUtils.getCURangeFilterInfo("cu.id");
            filterInfo.mergeFilter(cuRangeFilter, "and");
            return filterInfo;
        }
        catch (EASBizException e) {
            this.handUIException(e);
            return null;
        }
        catch (BOSException e) {
            this.handUIException(e);
            return null;
        }
    }

    private IObjectPK getCurrentUserCUPK() {
        return new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getCU().getId());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnForbid.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.btnUnForbid.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.btnUnLock.setIcon(EASResource.getIcon((String)"imgTbtn_ffreeze"));
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
    }

    @Override
    protected void tblMain_activeCellChanged(KDTActiveCellEvent e) throws Exception {
        super.tblMain_activeCellChanged(e);
        int rowIndex = -1;
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null && (rowIndex = selectBlock.getTop()) != -1) {
            boolean isForbidden = (Boolean)this.tblMain.getRow(rowIndex).getCell(8).getValue();
            this.btnForbid.setEnabled(!isForbidden);
            this.btnUnForbid.setEnabled(isForbidden);
            boolean isLocked = (Boolean)this.tblMain.getRow(rowIndex).getCell(9).getValue();
            this.btnUnLock.setEnabled(isLocked);
        }
    }

    private boolean isSuperAdmin() {
        return Administrator.isSuperCUAdmin(this.getCurrentUserPK());
    }

    private void removeBtnEASPivot() {
        Component[] components = this.getUIToolBar().getComponents();
        if (components != null && components.length > 0) {
            String text = EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OrgResource", (String)"SENIOR_STATISTICS");
            for (int i = components.length; i > 0; --i) {
                Component obj = components[i - 1];
                if (!(obj instanceof KDWorkButton)) continue;
                KDWorkButton buttion = (KDWorkButton)obj;
                if (text == null || !text.equals(buttion.getText())) continue;
                this.getUIToolBar().remove(i - 1);
                break;
            }
        }
    }
}

