/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.client.IDiscreteAccreditProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DiscreteAccreditManager {
    private static Logger logger = Logger.getLogger((String)DiscreteAccreditManager.class.getName());
    private static final String DISCRETE_ACCREDIT_CONTEXT_FILE = "com/kingdee/eas/base/permission/client/DiscreteAccreditProvider.properties";
    private Properties properties = null;
    private static DiscreteAccreditManager instance = new DiscreteAccreditManager();

    private DiscreteAccreditManager() {
        this.init();
    }

    public static DiscreteAccreditManager getInstace() {
        return instance;
    }

    private void init() {
        this.properties = this.read(DISCRETE_ACCREDIT_CONTEXT_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties read(String file) {
        Properties prop = new Properties();
        InputStream is = null;
        try {
            is = DiscreteAccreditManager.class.getClassLoader().getResourceAsStream(file);
            prop.load(is);
            return prop;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("read file failed:" + e);
        }
        finally {
            try {
                try {
                    is.close();
                    is = null;
                }
                catch (IOException e1) {
                    logger.error((Object)e1);
                    is = null;
                }
            }
            catch (Throwable throwable) {
                is = null;
                throw throwable;
            }
        }
    }

    public IDiscreteAccreditProvider getProvider(BOSObjectType type) {
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            String bosObjectType = (String)entry.getKey();
            if (!bosObjectType.equals(type.toString())) continue;
            String className = (String)entry.getValue();
            try {
                return (IDiscreteAccreditProvider)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                logger.error((Object)"getProvider occur exception:", (Throwable)e);
                throw new IllegalArgumentException("getProvider() failed:" + e);
            }
        }
        throw new IllegalArgumentException("not found provider , BOSObjectType:" + type.toInteger());
    }
}

