/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.DiscretePermCollection;
import com.kingdee.eas.base.permission.DiscretePermInfo;
import com.kingdee.eas.base.permission.DiscretePermissionFactory;
import com.kingdee.eas.base.permission.IDiscretePermission;
import com.kingdee.eas.base.permission.client.DiscreteDataContext;
import com.kingdee.eas.base.permission.client.DiscreteDataSwitch;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.base.permission.client.nivigate.INivigationFinish;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.List;

public class DiscreteBatchAccreditFinish
implements INivigationFinish {
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    @Override
    public void finish(final UIContext ctx) throws Exception {
        final DiscreteDataContext disCtx = (DiscreteDataContext)ctx.get((Object)DiscreteDataContext.class.getName());
        final LongTimeDialog dialog = UITools.getDialog((Component)ctx.get((Object)"Owner"));
        DiscreteDataContext discreteDataCtx = (DiscreteDataContext)ctx.get((Object)DiscreteDataContext.class.getName());
        DiscreteDataSwitch discreteDataSwitch = new DiscreteDataSwitch(discreteDataCtx);
        if (discreteDataSwitch.hasDataTarget()) {
            String tipText;
            if (discreteDataSwitch.hasRoleTarget()) {
                tipText = this.reComponentString(discreteDataCtx.getUserDiscreteAccreditBatchInfo().getRoleIdList());
                this.showNotification4Role(ctx, tipText);
            }
            if (discreteDataSwitch.hasUserTarget()) {
                tipText = this.reComponentString(discreteDataCtx.getUserDiscreteAccreditBatchInfo().getUserIdList());
                this.showNotification4User(ctx, tipText);
            }
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            @Override
            public Object exec() throws Exception {
                if ("DEL".equals(disCtx.getOperatorType())) {
                    DiscreteBatchAccreditFinish.this.finishDel(ctx, dialog);
                } else {
                    DiscreteBatchAccreditFinish.this.finishAdd(ctx, dialog);
                }
                return "";
            }

            @Override
            public void afterExec(Object result) throws Exception {
            }
        });
        dialog.show();
    }

    public void finishDel(UIContext ctx, KDDialog dialog) throws Exception {
        DiscreteDataContext discreteDataCtx = (DiscreteDataContext)ctx.get((Object)DiscreteDataContext.class.getName());
        DiscreteDataSwitch discreteDataSwitch = new DiscreteDataSwitch(discreteDataCtx);
        if (discreteDataSwitch.hasDataTarget()) {
            IDiscretePermission iDiscretePermission = DiscretePermissionFactory.getRemoteInstance();
            if (discreteDataSwitch.hasRoleTarget()) {
                iDiscretePermission.removeRoleDiscretePerms(BOSObjectType.create((String)discreteDataCtx.getBizObjType()), discreteDataSwitch.getDiscretePermCol4Role());
            }
            if (discreteDataSwitch.hasUserTarget()) {
                iDiscretePermission.removeUserDiscretePerms(BOSObjectType.create((String)discreteDataCtx.getBizObjType()), discreteDataSwitch.getDiscretePermCol4User());
            }
            dialog.dispose();
            MsgBox.showInfo((Component)((Component)ctx.get((Object)"Owner")), (String)EASResource.getString((String)RESOURCE, (String)"saveSucceed"));
        }
    }

    public void finishAdd(UIContext ctx, KDDialog dialog) throws Exception {
        DiscreteDataContext discreteDataCtx = (DiscreteDataContext)ctx.get((Object)DiscreteDataContext.class.getName());
        DiscreteDataSwitch discreteDataSwitch = new DiscreteDataSwitch(discreteDataCtx);
        if (discreteDataSwitch.hasDataTarget()) {
            IDiscretePermission iDiscretePermission = DiscretePermissionFactory.getRemoteInstance();
            if (discreteDataSwitch.hasRoleTarget()) {
                iDiscretePermission.saveRoleDiscretePerms(BOSObjectType.create((String)discreteDataCtx.getBizObjType()), discreteDataSwitch.getDiscretePermCol4Role());
            }
            if (discreteDataSwitch.hasUserTarget()) {
                iDiscretePermission.saveUserDiscretePerms(BOSObjectType.create((String)discreteDataCtx.getBizObjType()), discreteDataSwitch.getDiscretePermCol4User());
            }
            dialog.dispose();
            MsgBox.showInfo((Component)((Component)ctx.get((Object)"Owner")), (String)EASResource.getString((String)RESOURCE, (String)"saveSucceed"));
        }
    }

    private void showNotification4User(UIContext ctx, String tipText) {
        if (PermissionHelper.isAuthenticateAdminEnabled()) {
            String msg = MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"USER_WILL_NEED_AUTHEN"), tipText);
            if (MsgBox.showConfirm2((Component)((Component)ctx.get((Object)"Owner")), (String)msg) == 2) {
                SysUtil.abort();
            }
        }
    }

    private void showNotification4Role(UIContext ctx, String tipText) {
        if (PermissionHelper.isAuthenticateAdminEnabled()) {
            String msg = MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"ROLE_WILL_NEED_AUTHEN"), tipText);
            if (MsgBox.showConfirm2((Component)((Component)ctx.get((Object)"Owner")), (String)msg) == 2) {
                SysUtil.abort();
            }
        }
    }

    private String reComponentString4Role(DiscretePermCollection dpc) {
        StringBuffer retStr = new StringBuffer();
        for (int i = 0; i < dpc.size(); ++i) {
            DiscretePermInfo dpi = dpc.get(i);
            retStr.append(dpi.getRole().getNumber()).append(",");
        }
        return retStr.substring(0, retStr.length() - 1);
    }

    private String reComponentString4User(DiscretePermCollection dpc) {
        StringBuffer retStr = new StringBuffer();
        for (int i = 0; i < dpc.size(); ++i) {
            DiscretePermInfo dpi = dpc.get(i);
            retStr.append(dpi.getUser().getNumber()).append(",");
        }
        return retStr.substring(0, retStr.length() - 1);
    }

    private String reComponentString(List targetList) {
        StringBuffer retStr = new StringBuffer();
        for (int i = 0; i < targetList.size(); ++i) {
            String targetId = targetList.get(i).toString();
            String[] idAndNumber = targetId.split(" ");
            retStr.append(idAndNumber[1]).append(",");
        }
        return retStr.substring(0, retStr.length() - 1);
    }
}

