/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IDSecondAuthenNotifyUserCollection;
import com.kingdee.eas.base.permission.IDSecondAuthenNotifyUserFactory;
import com.kingdee.eas.base.permission.IDSecondAuthenNotifyUserInfo;
import com.kingdee.eas.base.permission.IIDSecondAuthenNotifyUser;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractIDSecondAuthenNotifyConfigUI;
import com.kingdee.eas.base.permission.client.UserPromptBox;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class IDSecondAuthenNotifyConfigUI
extends AbstractIDSecondAuthenNotifyConfigUI {
    private static final Logger logger = CoreUIObject.getLogger(IDSecondAuthenNotifyConfigUI.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private Map notifyUserInDbMap = new TreeMap();
    private static String easMsgTypeCheckboxSelected = null;
    private static String emailTypeCheckboxSelected = null;
    private static String mobileTypeCheckboxSelected = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.toolBar.setVisible(false);
        this.menuBar.setVisible(false);
        this.initData();
    }

    private void initData() throws BOSException {
        IIDSecondAuthenNotifyUser iIDSecondAuthenNotifyUser = IDSecondAuthenNotifyUserFactory.getRemoteInstance();
        IDSecondAuthenNotifyUserCollection userColl = iIDSecondAuthenNotifyUser.getIDSecondAuthenNotifyUserCollection();
        for (int i = 0; i < userColl.size(); ++i) {
            IDSecondAuthenNotifyUserInfo notifyUser = userColl.get(i);
            UserInfo userInfo = notifyUser.getUser();
            String itemString = this.getItemString(userInfo);
            this.notifyUserInDbMap.put(itemString, notifyUser.getId().toString());
        }
        this.reloadUserList();
        try {
            if (easMsgTypeCheckboxSelected == null) {
                HashMap paramMap = ParamManager.getParamHashMap(null, (String[])new String[]{"EASMsgNotifyEnable", "EmailNotifyEnable", "SMSNotifyEnable"}, null);
                easMsgTypeCheckboxSelected = (String)paramMap.get("EASMsgNotifyEnable");
                emailTypeCheckboxSelected = (String)paramMap.get("EmailNotifyEnable");
                mobileTypeCheckboxSelected = (String)paramMap.get("SMSNotifyEnable");
            }
            this.easMsgTypeCheckbox.setSelected(Boolean.valueOf(easMsgTypeCheckboxSelected).booleanValue());
            this.emailTypeCheckbox.setSelected(Boolean.valueOf(emailTypeCheckboxSelected).booleanValue());
            this.mobileTypeCheckbox.setSelected(Boolean.valueOf(mobileTypeCheckboxSelected).booleanValue());
        }
        catch (EASBizException e) {
            logger.error((Object)"Fetch parameter error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void mobileTypeCheckbox_actionPerformed(ActionEvent e) throws Exception {
        String selected = String.valueOf(this.mobileTypeCheckbox.isSelected());
        ParamManager.updateParamByNumber(null, (String)"SMSNotifyEnable", (String)selected);
        mobileTypeCheckboxSelected = selected;
        UITools.showMsg(this, EASResource.getString((String)RESOURCE, (String)"dataSaved"), false);
    }

    @Override
    protected void emailTypeCheckbox_actionPerformed(ActionEvent e) throws Exception {
        String selected = String.valueOf(this.emailTypeCheckbox.isSelected());
        ParamManager.updateParamByNumber(null, (String)"EmailNotifyEnable", (String)selected);
        emailTypeCheckboxSelected = selected;
        UITools.showMsg(this, EASResource.getString((String)RESOURCE, (String)"dataSaved"), false);
    }

    @Override
    protected void easMsgTypeCheckbox_actionPerformed(ActionEvent e) throws Exception {
        String selected = String.valueOf(this.easMsgTypeCheckbox.isSelected());
        ParamManager.updateParamByNumber(null, (String)"EASMsgNotifyEnable", (String)selected);
        easMsgTypeCheckboxSelected = selected;
        UITools.showMsg(this, EASResource.getString((String)RESOURCE, (String)"dataSaved"), false);
    }

    private void reloadUserList() {
        this.userList.removeAllElements();
        Set set = this.notifyUserInDbMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.userList.addElement((Object)iterator.next().toString());
        }
    }

    private String getItemString(UserInfo userInfo) {
        if (userInfo.getName() == null) {
            return userInfo.getNumber();
        }
        return userInfo.getNumber() + "(" + userInfo.getName(SysContext.getSysContext().getLocale()) + ")";
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void addReceiverBtn_actionPerformed(ActionEvent e) throws Exception {
        Object obj;
        UserPromptBox dlg = null;
        IUIWindow win = this.getUIWindow();
        dlg = new UserPromptBox(win.getUIObject());
        dlg.setEnabledMultiSelection(true);
        dlg.show();
        if (!dlg.isCanceled() && (obj = dlg.getData()) != null) {
            Object[] objAry = (Object[])obj;
            for (int i = 0; i < objAry.length; ++i) {
                UserInfo userInfo = (UserInfo)objAry[i];
                String itemString = this.getItemString(userInfo);
                if (this.notifyUserInDbMap.get(itemString) != null) continue;
                IIDSecondAuthenNotifyUser iIDSecondAuthenNotifyUser = IDSecondAuthenNotifyUserFactory.getRemoteInstance();
                IDSecondAuthenNotifyUserInfo notifyUserInfo = new IDSecondAuthenNotifyUserInfo();
                notifyUserInfo.setUser(userInfo);
                IObjectPK pk = iIDSecondAuthenNotifyUser.addnew(notifyUserInfo);
                this.notifyUserInDbMap.put(itemString, pk.toString());
            }
            this.reloadUserList();
            UITools.showMsg(this, EASResource.getString((String)RESOURCE, (String)"dataSaved"), false);
        }
    }

    @Override
    protected void deleteReceiverBtn_actionPerformed(ActionEvent e) throws Exception {
        int[] indexArray = this.userList.getSelectedIndices();
        if (indexArray != null && indexArray.length > 0) {
            String logMethod = EASResource.getString((String)RESOURCE, (String)"secondeAuthenNotifyConfigLog");
            ObjectUuidPK[] arrayPK = new ObjectUuidPK[indexArray.length];
            StringBuffer logMsg = new StringBuffer(logMethod).append(":  ");
            String splitChar = "";
            for (int i = 0; i < indexArray.length; ++i) {
                String itemString = (String)this.userList.getElement(indexArray[i]);
                String value = (String)this.notifyUserInDbMap.get(itemString);
                arrayPK[i] = new ObjectUuidPK(value);
                logMsg.append(splitChar).append(itemString);
                splitChar = "  ";
                this.notifyUserInDbMap.remove(itemString);
            }
            IIDSecondAuthenNotifyUser iIDSecondAuthenNotifyUser = IDSecondAuthenNotifyUserFactory.getRemoteInstance();
            IObjectPK logPK = LogUtil.beginLog(null, (String)logMethod, (BOSObjectType)new IDSecondAuthenNotifyUserInfo().getBOSType(), null, (String)logMsg.toString());
            iIDSecondAuthenNotifyUser.delete((IObjectPK[])arrayPK);
            LogUtil.afterLog(null, (IObjectPK)logPK);
            this.reloadUserList();
            UITools.showMsg(this, EASResource.getString((String)RESOURCE, (String)"dataSaved"), false);
        }
    }
}

