/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.AuthorizeTypeEnum;
import com.kingdee.eas.base.permission.IDSecondAuthorizeFactory;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.PermissionResUtil;
import com.kingdee.eas.base.permission.client.AbstractIDSecondAuthorizeListUI;
import com.kingdee.eas.base.permission.client.IDSecondAuthenNotifyConfigUI;
import com.kingdee.eas.base.permission.client.IDSecondAuthorizeCaOrgEditUI;
import com.kingdee.eas.base.permission.client.IDSecondAuthorizeEditUI;
import com.kingdee.eas.base.permission.client.IDSecondAuthorizeTreeUI;
import com.kingdee.eas.base.permission.client.PermItemFilterUI;
import com.kingdee.eas.base.permission.client.tree.IAccreditTreeBuilder;
import com.kingdee.eas.base.permission.client.tree.PermissionTreeBuilderFactory;
import com.kingdee.eas.base.permission.client.util.UIUtil;
import com.kingdee.eas.base.security.client.CAConfigUI;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LowTimer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class IDSecondAuthorizeListUI
extends AbstractIDSecondAuthorizeListUI {
    private static final Logger logger = CoreUIObject.getLogger(IDSecondAuthorizeListUI.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionUIResource";
    private Map permItems = new HashMap();
    private Map authTypes = null;
    private KDTreeNode currentNode = null;
    private String currentNodeNamePath = null;
    Map filterInfo = new HashMap();
    private final String F1 = "nameEqual";
    private final String F2 = "nameLike";
    private final String F3 = "wayEqual";
    private String PERM_LIST = "permList";
    private String AUTH_TYPES = "authTypes";
    private static String PERMITEMALIAS_CELLNAME = "permItemAlias";
    private static String PERMITEM_CELLNAME = "permItem";
    private static KDTreeNode treeBranch;
    private static KDTreeNode treeRoot;
    private static Map cachedAuthType;

    public void onLoad() throws Exception {
        if (!PermissionCommonUtil.isIDAuthorizeEnabled(null)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"infoIDAuthorizeIsDisabled"));
            SysUtil.abort();
        }
        super.onLoad();
        this.buildPermTree();
        this.getAuthTypeMap();
    }

    private void getAuthTypeMap() throws BOSException {
        this.authTypes = IDSecondAuthorizeFactory.getRemoteInstance().getAuthorizeMap();
        if (this.authTypes == null) {
            this.authTypes = new HashMap();
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.reLoadTree();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.treeDefine.setEnabled(true);
        this.setAuthWay.setEnabled(true);
        this.btnRefresh.setEnabled(true);
        this.btnQuery.setEnabled(true);
        this.caOrg.setEnabled(true);
        this.notifyBtn.setEnabled(true);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.treeDefine.setIcon(EASResource.getIcon((String)"imgTbtn_citetree"));
        this.setAuthWay.setIcon(EASResource.getIcon((String)"imgTbtn_setting"));
        this.caOrg.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.notifyBtn.setIcon(EASResource.getIcon((String)"imgTbtn_stafferbatch"));
    }

    @Override
    public void loadFields() {
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return IDSecondAuthorizeListUI.class.getName();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.permItemTree.setSelectionRow(0);
        KDTSortManager sm = new KDTSortManager(this.authWayTable);
        sm.setSortAuto(true);
        for (int index = 0; index < this.authWayTable.getColumnCount(); ++index) {
            this.authWayTable.getColumn(index).setSortable(true);
        }
    }

    protected void initTree() throws Exception {
        this.buildPermTree();
    }

    @Override
    public void actionSetAuthWay_actionPerformed(ActionEvent e) throws Exception {
        UIContext hm = new UIContext((Object)this);
        List permList = this.getSelectPermItemList();
        if (permList == null || permList.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"infoSelectPermItemFirst"));
            return;
        }
        hm.put(this.PERM_LIST, permList);
        hm.put(this.AUTH_TYPES, this.authTypes);
        hm.put("currentNodeNamePath", this.currentNodeNamePath);
        UIUtil.showWindow((HashMap)hm, IDSecondAuthorizeEditUI.class.getName());
        this.authWayTable.removeRows();
        this.initTable(this.currentNode);
    }

    @Override
    protected void notifyBtn_actionPerformed(ActionEvent e) throws Exception {
        UIContext hm = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(IDSecondAuthenNotifyConfigUI.class.getName(), (Map)hm, null, OprtState.EDIT);
        uiWindow.show();
    }

    private List getSelectPermItemList() {
        ArrayList<Object> permList = new ArrayList<Object>();
        KDTRange range = this.authWayTable.getSelectManager().toRange();
        if (range.size() > 0 && range.get(0) != null) {
            KDTSelectBlock block = (KDTSelectBlock)range.get(0);
            int endRow = block.getEndRow();
            for (int rIndex = block.getBeginRow(); rIndex <= endRow; ++rIndex) {
                if (rIndex < 0) continue;
                permList.add(this.authWayTable.getRow(rIndex).getCell(PERMITEM_CELLNAME).getValue());
            }
        }
        return permList;
    }

    @Override
    public void actionTreeDefine_actionPerformed(ActionEvent e) throws Exception {
        UIContext hm = new UIContext((Object)this);
        UIUtil.showWindow((HashMap)hm, IDSecondAuthorizeTreeUI.class.getName());
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)PermissionResUtil.getResource("res_89")));
    }

    public void reLoadTree() throws Exception {
        this.buildPermTree();
        this.permItemTree.repaint();
        this.permItemTree.setSelectionRow(0);
    }

    private void buildPermTree() throws Exception {
        LowTimer lowTimer = new LowTimer();
        float beginTime = lowTimer.msValue();
        float endTime = lowTimer.msValue();
        IAccreditTreeBuilder builder = PermissionTreeBuilderFactory.getPermItemTreeBuilder();
        endTime = lowTimer.msValue();
        logger.debug((Object)("getSourcePerms()  " + (endTime - beginTime)));
        PermItemCollection perms = IDSecondAuthorizeFactory.getRemoteInstance().getPermItemCollection();
        for (int index = 0; index < perms.size(); ++index) {
            if (perms.get(index).isIsLeaf()) continue;
            perms.removeObject(index);
        }
        KDTreeNode root = builder.buildTreeRoot(builder.createSecondAuthorizeTree(), (IObjectCollection)perms);
        this.removeLeafs(root);
        if (root == null) {
            root = new KDTreeNode(null);
            root.setText("EAS");
        }
        ((DefaultTreeModel)this.permItemTree.getModel()).setRoot((TreeNode)root);
    }

    private void removeLeafs(KDTreeNode root) {
        if (root == null) {
            return;
        }
        int count = root.getChildCount();
        for (int i = count - 1; i >= 0; --i) {
            KDTreeNode node = (KDTreeNode)root.getChildAt(i);
            if (node.isLeaf()) {
                List<Object> list = new ArrayList<Object>();
                if (this.permItems.containsKey(root)) {
                    list = (List)this.permItems.get(root);
                }
                list.add(node.getUserObject());
                this.permItems.put(root, list);
                node.removeFromParent();
                continue;
            }
            this.removeLeafs(node);
        }
    }

    private void initTable(KDTreeNode root) {
        if (root == null) {
            return;
        }
        this.bindPermItem2Table(root);
        if (!root.isLeaf()) {
            Enumeration permItemEnum = root.children();
            while (permItemEnum.hasMoreElements()) {
                KDTreeNode node = (KDTreeNode)permItemEnum.nextElement();
                this.initTable(node);
            }
        }
    }

    private void bindPermItem2Table(KDTreeNode node) {
        if (!this.permItems.containsKey(node)) {
            return;
        }
        List leafs = (List)this.permItems.get(node);
        for (PermItemInfo permItem : leafs) {
            AuthorizeTypeEnum type = AuthorizeTypeEnum.noAuthor;
            if (this.authTypes.get(permItem.getId().toString()) != null) {
                type = (AuthorizeTypeEnum)((Object)this.authTypes.get(permItem.getId().toString()));
            }
            if (!this.neededPermItem(permItem, type)) continue;
            IRow row = this.authWayTable.addRow();
            row.getCell(PERMITEMALIAS_CELLNAME).setValue((Object)permItem.getAlias());
            row.getCell(PERMITEM_CELLNAME).setValue((Object)permItem);
            String description = PermissionCommonUtil.getAuthorizeDiscription(type, true);
            row.getCell("authWay").setValue((Object)description);
            row.getStyleAttributes().setLocked(true);
        }
    }

    private boolean neededPermItem(PermItemInfo permItem, AuthorizeTypeEnum type) {
        boolean result = true;
        if (this.filterInfo.get(this.F1) != null && this.filterInfo.get(this.F1).toString().length() > 0) {
            result = permItem.getAlias().equals(this.filterInfo.get(this.F1));
        }
        if (result && this.filterInfo.get(this.F2) != null) {
            boolean bl = result = permItem.getAlias().indexOf(this.filterInfo.get(this.F2).toString()) != -1;
        }
        if (result && this.filterInfo.get(this.F3) != null) {
            result = type.equals(this.filterInfo.get(this.F3));
        }
        return result;
    }

    protected void execQuery() {
        this.authWayTable.removeRows();
        try {
            KDTreeNode node = (KDTreeNode)this.permItemTree.getSelectionPath().getLastPathComponent();
            if (node == null) {
                node = (KDTreeNode)((DefaultTreeModel)this.permItemTree.getModel()).getRoot();
            }
            this.initTable(node);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    @Override
    protected void permItemTree_valueChanged(TreeSelectionEvent e) throws Exception {
        logger.debug((Object)e.getNewLeadSelectionPath());
        this.authWayTable.removeRows();
        KDTreeNode node = null;
        try {
            node = (KDTreeNode)e.getNewLeadSelectionPath().getLastPathComponent();
        }
        catch (Exception ex) {
            node = (KDTreeNode)((DefaultTreeModel)this.permItemTree.getModel()).getRoot();
        }
        this.currentNode = node;
        this.initTable(node);
        this.currentNodeNamePath = "  ";
        this.populateNamePath(node);
    }

    private void populateNamePath(KDTreeNode node) {
        if (node == null) {
            return;
        }
        KDTreeNode parentNode = (KDTreeNode)node.getParent();
        if (parentNode == null || parentNode.isRoot()) {
            this.currentNodeNamePath = node.getText() + this.currentNodeNamePath;
            return;
        }
        this.currentNodeNamePath = ">" + node.getText() + this.currentNodeNamePath;
        this.populateNamePath(parentNode);
    }

    @Override
    protected void btnQuery_actionPerformed(ActionEvent e) throws Exception {
        UIContext hm = new UIContext((Object)this);
        hm.put("filterInfo", this.filterInfo);
        UIUtil.showWindow((HashMap)hm, PermItemFilterUI.class.getName());
        this.execQuery();
    }

    @Override
    public void actionCaOrg_actionPerformed(ActionEvent e) throws Exception {
        UIContext hm = new UIContext((Object)this);
        hm.put("permItems", this.permItems);
        hm.put("currentNode", this.currentNode);
        hm.put("currentNodeNamePath", this.currentNodeNamePath);
        UIUtil.showWindow((HashMap)hm, IDSecondAuthorizeCaOrgEditUI.class.getName());
    }

    @Override
    public void actionCheckConfig_actionPerformed(ActionEvent e) throws Exception {
        UIContext hm = new UIContext((Object)this);
        UIUtil.showWindow((HashMap)hm, CAConfigUI.class.getName());
    }
}

