/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.message.MsgPriority;
import com.kingdee.eas.base.permission.MachineRegisterFactory;
import com.kingdee.eas.base.permission.MachineRegisterInfo;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractMachineRegisterEditUI;
import com.kingdee.eas.base.permission.client.machine.MachineCodeUtil;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.mobile.client.SendMessageSchemaUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.InetAddress;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class MachineRegisterEditUI
extends AbstractMachineRegisterEditUI {
    private static final Logger logger = CoreUIObject.getLogger(MachineRegisterEditUI.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionUIResource";
    private KDMenuItem smsInform = new KDMenuItem();
    private KDMenuItem msInform = new KDMenuItem();

    @Override
    public boolean isPrepareActionMachineCode() {
        return true;
    }

    @Override
    public boolean isPrepareActionRegister() {
        return true;
    }

    @Override
    public boolean isPrepareActionSmsInform() {
        return true;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        return super.prepareInit();
    }

    public void onLoad() throws Exception {
        super.setOprtState("ADDNEW");
        super.onLoad();
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.initUI();
    }

    public void initUI() {
        this.txtUserName.setText(this.editData.getCreator().getNumber());
        this.txtUserAlias.setText(this.editData.getCreator().getName());
        this.txtOrgName.setText(SysContext.getSysContext().getCurrentCtrlUnit().getName());
        this.txtPhoneNumber.setText(this.editData.getPhoneNumber());
        this.pkValidDate.setValue((Object)this.editData.getValidDate());
        this.pkInValidDate.setValue((Object)this.editData.getInValidDate());
        this.txtIp.setText(this.editData.getIp());
        this.btnRegister.setIcon(EASResource.getIcon((String)"imgTbtn_usermanage"));
        this.btnMachineCode.setIcon(EASResource.getIcon((String)"imgTbtn_increasedecimal"));
        this.btnInform.setIcon(EASResource.getIcon((String)"imgTbtn_repeatcheck"));
        if (this.editData.getId() != null) {
            this.setInformBtnEnabled(true);
            this.btnMachineCode.setEnabled(false);
            this.btnRegister.setEnabled(false);
            this.pkValidDate.setEnabled(false);
            this.pkInValidDate.setEnabled(false);
            this.txtPhoneNumber.setEditable(false);
        } else {
            this.btnMachineCode.setEnabled(true);
            this.setInformBtnEnabled(false);
        }
        this.kDLabelContainer3.setVisible(false);
    }

    private void initInformButton() {
        this.msInform.setText(this.btnMsgInform.getText());
        this.msInform.setToolTipText(this.btnMsgInform.getToolTipText());
        this.msInform.setAction((Action)((Object)this.actionMsgInform));
        this.msInform.setIcon(EASResource.getIcon((String)"imgTbtn_sendmessage"));
        this.btnInform.addAssistMenuItem((JMenuItem)this.msInform);
        this.smsInform.setText(this.btnSmsInform.getText());
        this.smsInform.setToolTipText(this.btnSmsInform.getToolTipText());
        this.smsInform.setAction((Action)((Object)this.actionSmsInform));
        this.smsInform.setIcon(EASResource.getIcon((String)"imgTbtn_notice"));
        this.btnInform.addAssistMenuItem((JMenuItem)this.smsInform);
    }

    private void showInformUI() {
        block2: {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"Owner", (Object)this);
            uiContext.put((Object)"is_model_ui", (Object)new Boolean(true));
            uiContext.put((Object)"number", (Object)"...");
            uiContext.put((Object)"content", (Object)this.getMsgBody());
            uiContext.put((Object)"init_receiver", (Object)this.getMsgReceiver());
            uiContext.put((Object)"Priority", (Object)MsgPriority.HIGH);
            IUIFactory uiFactory = null;
            IUIWindow curDialog = null;
            try {
                uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                curDialog = uiFactory.create(SendMessageSchemaUI.class.getName(), (Map)uiContext);
                curDialog.show();
            }
            catch (Throwable ex) {
                if (!(ex instanceof Exception)) break block2;
                this.handleException((Exception)ex);
            }
        }
    }

    private String getMsgReceiver() {
        OrgRangeCollection col;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("user.type", (Object)"10"));
        filter.getFilterItems().add(new FilterItemInfo("org", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString()));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add("user.id");
        viewInfo.getSelector().add("user.number");
        viewInfo.getSelector().add("user.name");
        try {
            col = OrgRangeFactory.getRemoteInstance().getOrgRangeCollection(viewInfo);
        }
        catch (BOSException e) {
            col = new OrgRangeCollection();
            logger.error((Object)"", (Throwable)e);
        }
        StringBuffer receivers = new StringBuffer();
        for (int i = 0; i < col.size(); ++i) {
            if (receivers.length() > 0) {
                receivers.append(",");
            }
            receivers.append(col.get(i).getUser().getName());
        }
        return receivers.toString();
    }

    private void setInformBtnEnabled(boolean isEnabled) {
        this.btnInform.setEnabled(isEnabled);
        this.msInform.setEnabled(isEnabled);
        this.smsInform.setEnabled(isEnabled);
    }

    @Override
    public void actionMachineCode_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setMachineCode(MachineCodeUtil.getMachineCode(null));
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"infoGetMachineInfoSuccessful"));
        this.btnRegister.setEnabled(true);
    }

    @Override
    public void actionRegister_actionPerformed(ActionEvent e) throws Exception {
        Timestamp startTime = this.pkValidDate.getTimestamp();
        Timestamp endTime = this.pkInValidDate.getTimestamp();
        if (startTime == null || endTime == null || startTime.getTime() >= endTime.getTime()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"errorDateInvalid"));
            return;
        }
        if (!StringUtils.isEmpty((String)this.txtPhoneNumber.getText()) && this.txtPhoneNumber.getText().length() > 20) {
            this.txtPhoneNumber.setText(this.txtPhoneNumber.getText().substring(0, 20));
        }
        this.storeField();
        this.actionSubmit_actionPerformed(e);
        this.setInformBtnEnabled(true);
    }

    private void storeField() {
        this.editData.setValidDate(this.pkValidDate.getSqlDate());
        this.editData.setInValidDate(this.pkInValidDate.getSqlDate());
        this.editData.setPhoneNumber(this.txtPhoneNumber.getText());
    }

    @Override
    public void actionSmsInform_actionPerformed(ActionEvent e) throws Exception {
        this.actionSendMessage_actionPerformed(e);
    }

    @Override
    public boolean isPrepareActionMsgInform() {
        return true;
    }

    @Override
    public RequestContext prepareActionMsgInform(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionMsgInform(itemAction);
        request.put("cuid", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        return request;
    }

    @Override
    public void actionMsgInform_actionPerformed(ActionEvent e) throws Exception {
        this.showInformUI();
    }

    private String getMsgBody() {
        Object[] params = new Object[]{this.txtUserAlias.getText(), this.txtIp.getText()};
        return MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"infoInformTitle"), params);
    }

    protected IObjectValue createNewData() {
        MachineRegisterInfo machineInfo = new MachineRegisterInfo();
        UserInfo currentUser = this.getCurrentUser();
        try {
            machineInfo.setIp(SysContext.getSysContext().getClientIP());
            machineInfo.setMachineName(InetAddress.getLocalHost().getHostName());
            machineInfo.setCreator(currentUser);
            machineInfo.setIsRegistered("00000000-0000-0000-0000-00000000000013B7DE7F".equals(currentUser.getId().toString()));
            machineInfo.setValidDate(new Date());
            Calendar InvaildDate = Calendar.getInstance();
            InvaildDate.set(2099, 11, 31, 0, 0, 0);
            machineInfo.setInValidDate(InvaildDate.getTime());
            machineInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        }
        catch (IOException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return machineInfo;
    }

    private UserInfo getCurrentUser() {
        UserInfo currentUser = SysContext.getSysContext().getCurrentUserInfo();
        return currentUser;
    }

    public boolean isModify() {
        return false;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MachineRegisterFactory.getRemoteInstance();
    }
}

