/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.IOrgRangeSolution;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeSolutionCollection;
import com.kingdee.eas.base.permission.OrgRangeSolutionEntryCollection;
import com.kingdee.eas.base.permission.OrgRangeSolutionEntryInfo;
import com.kingdee.eas.base.permission.OrgRangeSolutionFactory;
import com.kingdee.eas.base.permission.OrgRangeSolutionInfo;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractOrgRangeBatchDealUI;
import com.kingdee.eas.base.permission.client.OrgRangeSolutionEditUI;
import com.kingdee.eas.base.permission.client.OrgRangeSolutionUtil;
import com.kingdee.eas.base.permission.client.UserPromptBox;
import com.kingdee.eas.base.permission.client.helper.PermissionUIHelper;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class OrgRangeBatchDealUI
extends AbstractOrgRangeBatchDealUI {
    private static final Logger logger = CoreUIObject.getLogger(OrgRangeBatchDealUI.class);
    private static final int MAX_NUMBER = 200000;
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private boolean delOrg = true;
    private KDBizPromptBox f7SltOrgRangeSln = null;
    private OrgRangeSolutionInfo currentSlnInfo = null;

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        return super.prepareInit();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
        this.tblSelectOrgList.checkParsed();
        this.tblSelectUserList.checkParsed();
        this.tblSelectOrgList.setEditable(false);
        this.tblSelectUserList.setEditable(false);
        KDTSelectManager kDTSelectManager = this.tblSelectUserList.getSelectManager();
        this.tblSelectUserList.getSelectManager();
        kDTSelectManager.setSelectMode(10);
        this.tblSelectUserList.getStyleAttributes().setLocked(true);
        this.cmbOrgRangeType.removeAllItems();
        OrgRangeType[] orgRangetype = new OrgRangeType[]{OrgRangeType.BIZ_ORG_TYPE, OrgRangeType.ADMIN_ORG_TYPE};
        this.cmbOrgRangeType.addItems((Object[])orgRangetype);
        Map uiMap = this.getUIContext();
        if (StringUtils.cnulls((String)((String)uiMap.get("viewBizOrg"))).equals("true")) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"bizOrgBatch"));
        } else {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"adminOrgBatch"));
        }
        String uiTitle = EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"bizOrgBatch");
        if (StringUtils.cnulls((String)((String)uiMap.get("oprType"))).equals("add")) {
            this.delOrg = false;
            this.setUITitle(uiTitle + "_" + EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"add"));
        } else {
            this.delOrg = true;
            this.setUITitle(uiTitle + "_" + EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"del"));
        }
        List ids = (List)this.getUIContext().get("targetIDs");
        if (ids != null && !ids.isEmpty()) {
            FilterInfo userFilterInfo = new FilterInfo();
            userFilterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ToolUtils.aryToStr((Object[])ids.toArray(new String[0]), false), CompareType.INCLUDE));
            if (this.userListQuery == null) {
                this.userListQuery = new EntityViewInfo();
            }
            this.userListQuery.setFilter(userFilterInfo);
            this.tblSelectUserList.refresh();
        }
    }

    private void initUI() {
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
        this.btnAdd.setText(null);
        Icon addIcon = EASResource.getIcon((String)"imgTbtn_insert");
        this.btnAdd.setIcon(addIcon);
        Icon deleteIcon = EASResource.getIcon((String)"imgTbtn_deleteline");
        this.btnDel.setText(null);
        this.btnDel.setIcon(deleteIcon);
        Icon selectOrgIcon = EASResource.getIcon((String)"imgTbtn_selectcompany");
        this.btnSelectOrg.setIcon(selectOrgIcon);
        this.btnSelectOrg.setEnabled(true);
        this.btnDel.setEnabled(true);
        this.btnAdd.setEnabled(true);
        this.btnSaveSolution.setEnabled(false);
        this.btnSaveSolution.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSaveAsSolution.setEnabled(true);
        this.btnSaveAsSolution.setIcon(EASResource.getIcon((String)"imgTbtn_saveas"));
        this.btnEditSolution.setEnabled(true);
        this.btnEditSolution.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnRemoveSolution.setEnabled(true);
        this.btnRemoveSolution.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnSltSolution.setEnabled(true);
        this.btnSltSolution.setIcon(selectOrgIcon);
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        Object[] userInfoAry;
        UserPromptBox dlg = new UserPromptBox((Dialog)((UIModelDialog)this.getUIWindow()));
        dlg.setEnabledMultiSelection(true);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.base.permission.app.UserListQuery");
        dlg.setQueryInfo(queryPK);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isDelete", (Object)"0", CompareType.EQUALS));
        OrgRangeType orgRangeType = OrgRangeType.BIZ_ORG_TYPE;
        if (ToolUtils.getCurrentUser().isBizAdmin()) {
            orgRangeType = OrgRangeType.MANAGE_ORG_TYPE;
        }
        String userOrgRangeSql = PermissionRangeHelper.getUserOrgIdRangeSQL(null, ToolUtils.getCurrentUserPK(), orgRangeType);
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.id in (" + userOrgRangeSql + ")"));
        Set alreadyUserSet = PermissionUIHelper.getSelectedBizDataRanges(this.tblSelectUserList, "id");
        if (alreadyUserSet != null && !alreadyUserSet.isEmpty()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ToolUtils.aryToStr(alreadyUserSet, false), CompareType.NOTINCLUDE));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ToolUtils.getCurrentUserPK().toString(), CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(60), CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(10), CompareType.NOTEQUALS));
        entityViewInfo.setFilter(filterInfo);
        dlg.setEntityViewInfo(entityViewInfo);
        dlg.setHasCUDefaultFilter(false);
        dlg.show();
        if (!dlg.isCanceled() && (userInfoAry = (Object[])dlg.getData()) != null && userInfoAry.length != 0) {
            HashSet<String> newSelectUserSet = new HashSet<String>();
            int size = userInfoAry.length;
            for (int i = 0; i < size; ++i) {
                UserInfo userInfo = (UserInfo)userInfoAry[i];
                if (userInfo == null) continue;
                newSelectUserSet.add(userInfo.getId().toString());
            }
            alreadyUserSet.addAll(newSelectUserSet);
            FilterInfo userFilterInfo = new FilterInfo();
            userFilterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ToolUtils.aryToStr(alreadyUserSet, false), CompareType.INCLUDE));
            if (this.userListQuery == null) {
                this.userListQuery = new EntityViewInfo();
            }
            this.userListQuery.setFilter(userFilterInfo);
            this.tblSelectUserList.refresh();
        }
    }

    @Override
    public void actionDel_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblSelectUserList.getRowCount() == 0 || this.tblSelectUserList.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        ArrayList blocks = this.tblSelectUserList.getSelectManager().getBlocks();
        ArrayList sortedBlocks = this.sortBlocks(blocks);
        int size = sortedBlocks.size();
        for (int i = 0; i < size; ++i) {
            IBlock selectBlock = (IBlock)sortedBlocks.get(i);
            int sizej = selectBlock.getTop();
            for (int j = selectBlock.getBottom(); j >= sizej; --j) {
                this.tblSelectUserList.removeRow(j);
            }
        }
    }

    private ArrayList sortBlocks(ArrayList blocks) {
        ArrayList clone = (ArrayList)blocks.clone();
        Collections.sort(clone, new Comparator(){

            public int compare(Object o1, Object o2) {
                int bottom2;
                int bottom1 = ((IBlock)o1).getBottom();
                if (bottom1 > (bottom2 = ((IBlock)o2).getBottom())) {
                    return -1;
                }
                if (bottom2 > bottom1) {
                    return 1;
                }
                return 0;
            }
        });
        return clone;
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        Set userList = PermissionUIHelper.getSelectedBizDataRanges(this.tblSelectUserList, "id");
        if (userList == null || userList.isEmpty()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"userNotSelect"));
            return;
        }
        Set orgList = PermissionUIHelper.getSelectedBizDataRanges(this.tblSelectOrgList, "orgId");
        if (orgList == null || orgList.isEmpty()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"orgNotSelect"));
            return;
        }
        this.checkMaxNumber(userList, orgList);
        IOrgRange iOrgRange = OrgRangeFactory.getRemoteInstance();
        if (this.delOrg) {
            String isOK;
            String msg = MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"OrangeBatchDelete"), new Object[]{null});
            if (MsgBox.showConfirm2((Component)((Object)this), (String)msg) == 2) {
                this.abort();
            }
            if ("true".equals(isOK = iOrgRange.delOrgRangeBatch(ToolUtils.trans2List(userList), ToolUtils.trans2List(orgList), (OrgRangeType)((Object)this.cmbOrgRangeType.getSelectedItem())))) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"saveSuccessed"));
            } else if ("false".equals(isOK)) {
                MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"BatchDeleteOkMsg"), new Object[]{null}));
            } else {
                String[] notice = isOK.split(";");
                String showmsg = "";
                for (int i = 0; i < notice.length; ++i) {
                    String[] def = notice[i].split(":");
                    showmsg = showmsg + MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"DefaultOrgNotice"), def[0], def[1]) + "\n";
                }
                String deleteError = MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"OrgDeleteNotice"), new Object[]{null});
                MsgBox.showDetailAndOK((Component)((Object)this), (String)deleteError, (String)showmsg, (int)8188);
            }
        } else {
            iOrgRange.addOrgRangeBatch(ToolUtils.trans2List(userList), ToolUtils.trans2List(orgList), (OrgRangeType)((Object)this.cmbOrgRangeType.getSelectedItem()));
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"saveSuccessed"));
        }
    }

    private void checkMaxNumber(Collection userList, Collection orgList) {
        int orgSize;
        int userSize = userList.size();
        int allSize = userSize * (orgSize = orgList.size());
        if (allSize >= 200000) {
            Object[] params = new String[]{String.valueOf(200000)};
            MsgBox.showWarning((String)MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"USER_ORG_TOO_MANY"), params));
            SysUtil.abort();
        }
    }

    @Override
    public void actionSelectOrg_actionPerformed(ActionEvent e) throws Exception {
        Set selectedOrgs = PermissionUIHelper.getSelectedBizOrgRanges(this.tblSelectOrgList, "orgId");
        FullOrgUnitInfo[] fullOrgUnitInfos = null;
        if (!PermissionRangeHelper.hasCUOrgRange(null, ToolUtils.getCurrentUserPK())) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"orgRange_empty"));
            return;
        }
        fullOrgUnitInfos = OrgRangeType.BIZ_ORG_TYPE == this.cmbOrgRangeType.getSelectedItem() ? PermissionUIHelper.getBizOrgRangeByUserSelect((IUIObject)this, selectedOrgs) : PermissionUIHelper.getAdminOrgRangeByUserSelect((IUIObject)this, selectedOrgs);
        if (fullOrgUnitInfos != null && fullOrgUnitInfos.length != 0) {
            ArrayList<String> idList = new ArrayList<String>();
            int size = fullOrgUnitInfos.length;
            for (int i = 0; i < size; ++i) {
                if (fullOrgUnitInfos[i].getId() == null) continue;
                idList.add(fullOrgUnitInfos[i].getId().toString());
            }
            if (idList != null && !idList.isEmpty()) {
                this.tblSelectOrgList.removeRows();
                FilterInfo filterInfo = this.getSelectOrgFilteInfo(ToolUtils.aryToStr(idList, false));
                if (this.baseUnitInfoQuery == null) {
                    this.baseUnitInfoQuery = new EntityViewInfo();
                }
                this.baseUnitInfoQuery.setFilter(filterInfo);
                this.tblSelectOrgList.refresh();
            }
        }
    }

    private FilterInfo getSelectOrgFilteInfo(String idStr) {
        FilterInfo myFilterInfo = new FilterInfo();
        myFilterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INCLUDE));
        return myFilterInfo;
    }

    @Override
    protected void cmbOrgRangeType_itemStateChanged(ItemEvent e) throws Exception {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"1"));
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"2"));
        if (this.baseUnitInfoQuery == null) {
            this.baseUnitInfoQuery = new EntityViewInfo();
        }
        this.baseUnitInfoQuery.setFilter(filterInfo);
        this.tblSelectOrgList.refresh();
        if (this.userListQuery == null) {
            this.userListQuery = new EntityViewInfo();
        }
        this.updateSltSolution();
    }

    private void updateSltSolution() {
        this.f7SltOrgRangeSln = null;
    }

    private OrgRangeType getCurrentOrgRangeType() {
        return (OrgRangeType)((Object)this.cmbOrgRangeType.getSelectedItem());
    }

    @Override
    public void actionSltSolution_actionPerformed(ActionEvent e) throws Exception {
        OrgRangeSolutionCollection coll;
        this.f7SltOrgRangeSln = this.getOrgRangeF7(this.getCurrentOrgRangeType());
        if (this.currentSlnInfo != null) {
            this.f7SltOrgRangeSln.setData((Object)this.currentSlnInfo);
        }
        if ((coll = OrgRangeSolutionUtil.getOrgRangeSolutionColl(this.f7SltOrgRangeSln)) != null && coll.size() == 1) {
            this.currentSlnInfo = coll.get(0);
            this.btnEditSolution.setEnabled(true);
            this.btnRemoveSolution.setEnabled(true);
        }
        if (coll != null && coll.size() > 1) {
            this.btnEditSolution.setEnabled(false);
            this.btnRemoveSolution.setEnabled(false);
        }
        if (coll != null && coll.size() > 0) {
            OrgRangeSolutionUtil.updateOrgTableList(coll, this.tblSelectOrgList, this.baseUnitInfoQuery);
            this.btnSaveSolution.setEnabled(true);
        }
    }

    @Override
    public void actionSaveSolution_actionPerformed(ActionEvent e) throws Exception {
        if (this.currentSlnInfo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"saveAsSln"));
            return;
        }
        Set orgList = PermissionUIHelper.getSelectedBizDataRanges(this.tblSelectOrgList, "orgId");
        if (orgList == null || orgList.isEmpty()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"orgNotSelect"));
            return;
        }
        this.currentSlnInfo.getEntries().clear();
        this.currentSlnInfo.getEntries().addCollection(this.getCurrentSltOrgRangeEntry(orgList));
        IOrgRangeSolution orgRangSln = OrgRangeSolutionFactory.getRemoteInstance();
        orgRangSln.update((IObjectPK)new ObjectUuidPK(this.currentSlnInfo.getId().toString()), this.currentSlnInfo);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"savaSlnSuccess"));
    }

    private OrgRangeSolutionEntryCollection getCurrentSltOrgRangeEntry(Set orgList) {
        OrgRangeSolutionEntryCollection coll = new OrgRangeSolutionEntryCollection();
        List orgIds = ToolUtils.trans2List(orgList);
        int size = orgIds.size();
        for (int i = 0; i < size; ++i) {
            OrgRangeSolutionEntryInfo entryInfo = new OrgRangeSolutionEntryInfo();
            FullOrgUnitInfo fouInfo = new FullOrgUnitInfo();
            fouInfo.setId(BOSUuid.read((String)((String)orgIds.get(i))));
            entryInfo.setOrg(fouInfo);
            coll.add(entryInfo);
        }
        return coll;
    }

    @Override
    public void actionSaveAsSolution_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        Set orgList = PermissionUIHelper.getSelectedBizDataRanges(this.tblSelectOrgList, "orgId");
        if (orgList == null || orgList.isEmpty()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"orgNotSelect"));
            return;
        }
        uiContext.put((Object)"orgIds", (Object)this.getCurrentSltOrgRangeEntry(orgList));
        uiContext.put((Object)"orgRangeType", (Object)this.getCurrentOrgRangeType());
        uiContext.put((Object)"currentSlnInfo", (Object)this.currentSlnInfo);
        IUIWindow window = this.showDialog(OrgRangeSolutionEditUI.class.getName(), (Map)uiContext, OprtState.ADDNEW);
        OrgRangeSolutionEditUI ui = (OrgRangeSolutionEditUI)window.getUIObject();
        String id = (String)ui.getUIContext().get("ID");
        if (id != null) {
            IOrgRangeSolution orgRangSln = OrgRangeSolutionFactory.getRemoteInstance();
            this.currentSlnInfo = orgRangSln.getOrgRangeSolutionInfo((IObjectPK)new ObjectUuidPK(id));
        }
        if (this.currentSlnInfo != null) {
            this.btnSaveSolution.setEnabled(true);
        }
    }

    private IUIWindow showDialog(String strUI, Map map, String status) throws Exception {
        map.put("Owner", this);
        IUIFactory uiFactory = null;
        try {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow curDialog = uiFactory.create(strUI, map, null, status);
            curDialog.show();
            return curDialog;
        }
        catch (UIException ex1) {
            logger.error((Object)ex1.getMessage(), (Throwable)ex1);
            return null;
        }
    }

    @Override
    public void actionEditSolution_actionPerformed(ActionEvent e) throws Exception {
        if (this.currentSlnInfo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"saveAsSln"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        Set orgList = PermissionUIHelper.getSelectedBizDataRanges(this.tblSelectOrgList, "orgId");
        if (orgList == null || orgList.isEmpty()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"orgNotSelect"));
            return;
        }
        uiContext.put((Object)"orgIds", (Object)this.getCurrentSltOrgRangeEntry(orgList));
        uiContext.put((Object)"orgRangeType", (Object)this.getCurrentOrgRangeType());
        uiContext.put((Object)"currentSlnInfo", (Object)this.currentSlnInfo);
        uiContext.put((Object)"ID", (Object)this.currentSlnInfo.getId());
        this.showDialog(OrgRangeSolutionEditUI.class.getName(), (Map)uiContext, OprtState.EDIT);
    }

    @Override
    public void actionRemoveSolution_actionPerformed(ActionEvent e) throws Exception {
        if (this.currentSlnInfo != null) {
            if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"confirmDelCurrentSln")) == 0) {
                IOrgRangeSolution orgRangSln = OrgRangeSolutionFactory.getRemoteInstance();
                orgRangSln.delete((IObjectPK)new ObjectUuidPK(this.currentSlnInfo.getId().toString()));
                this.currentSlnInfo = null;
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"delSlnSuccess"));
                this.btnSaveSolution.setEnabled(false);
                this.btnSaveAsSolution.setEnabled(true);
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"noExistSln"));
        }
    }

    private KDBizPromptBox getOrgRangeF7(OrgRangeType type) {
        return OrgRangeSolutionUtil.getOrgRangeF7(type);
    }
}

