/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.FindedTooMuchRecordsException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.service.CacheService;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IOrgRangeIncludeSubOrg;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.OrgRangeIncludeSubOrgFactory;
import com.kingdee.eas.base.permission.OrgRangeIncludeSubOrgInfo;
import com.kingdee.eas.base.permission.OrgRangeParam;
import com.kingdee.eas.base.permission.OrgRangeSolutionCollection;
import com.kingdee.eas.base.permission.OrgRangeSolutionFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PermissionUtils;
import com.kingdee.eas.base.permission.SystemOrgRangeTypeEnum;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.base.permission.client.AbstractOrgRangeListUI;
import com.kingdee.eas.base.permission.client.AdminOrgRangeListUI;
import com.kingdee.eas.base.permission.client.OrgRangeSolutionUtil;
import com.kingdee.eas.base.permission.client.helper.PermissionOrgF7Factory;
import com.kingdee.eas.base.permission.client.helper.PermissionUIHelper;
import com.kingdee.eas.base.permission.client.helper.UIFunctionView;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgAssistInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.AdminOrgRangeF7PromptDialog;
import com.kingdee.eas.basedata.org.client.BizOrgRangeF7PromptDialog;
import com.kingdee.eas.basedata.org.client.CtrlUnitOrgRangeF7PromptDialog;
import com.kingdee.eas.basedata.org.client.ManageOrgRangeF7PromptDialog;
import com.kingdee.eas.basedata.org.client.OrgRangeF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.CtrlF7;
import com.kingdee.eas.basedata.org.client.f7.OUUnionF7;
import com.kingdee.eas.basedata.org.client.f7.OrgF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class OrgRangeListUI
extends AbstractOrgRangeListUI {
    private static final Logger logger = CoreUIObject.getLogger(OrgRangeListUI.class);
    private String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private static final String ISINCLUDESUBORG = "isIncludeSubOrg";
    private static final String ORGID = "org.id";
    private static final String ID = "id";
    private static final String ORGNAME = "org.name";
    private static final String LONGNUMBER = "longNumber";
    private UserInfo userInfo = null;
    private List currentCUIdList = null;
    private String CUID = "cu.id";
    private Set<String> managedOrgids;

    public void onLoad() throws Exception {
        this.initOrgRangeType();
        this.initSubOrgRange();
        super.onLoad();
        this.kdcOrgRangeType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrgRangeListUI.this.actionOrgRangeTypeChanged(e);
            }
        });
        this.initTable();
        this.addFunction();
        this.initDefaultOrg();
        this.initManagedCu();
    }

    private void initDefaultOrg() {
        if (!(this.kdcOrgRangeType.getSelectedItem() instanceof SystemOrgRangeTypeEnum) && OrgRangeType.BIZ_ORG_TYPE.equals((Object)((OrgRangeType)((Object)this.kdcOrgRangeType.getSelectedItem())))) {
            this.kDLabelContainerDefaulOrg.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"defaultOrg") + "\uff1a");
            this.kDLabelContainerDefaulOrg.getBoundLabel().setForeground(Color.BLUE);
            this.kDLabelDefaultOrg.setForeground(Color.BLUE);
            this.kDLabelDefaultOrg.setText(this.getUser().getDefOrgUnit().getNumber() + "--" + this.getUser().getDefOrgUnit().getName());
            this.kDLabelDefaultOrg.setBounds(new Rectangle(488, 6, 372, 19));
            this.kDLabelContainerDefaulOrg.setBounds(new Rectangle(422, 5, 61, 19));
            this.kDLabelContainerDefaulOrg.setVisible(true);
            this.kDLabelDefaultOrg.setVisible(true);
        } else if (this.kdcOrgRangeType.getSelectedItem() instanceof SystemOrgRangeTypeEnum || OrgRangeType.MANAGE_ORG_TYPE.equals((Object)((OrgRangeType)((Object)this.kdcOrgRangeType.getSelectedItem())))) {
            this.kDLabelContainerDefaulOrg.getBoundLabel().setForeground(Color.BLUE);
            this.kDLabelContainerDefaulOrg.getBoundLabel().setText(EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"defautlCU") + "\uff1a");
            this.kDLabelDefaultOrg.setForeground(Color.BLUE);
            this.kDLabelDefaultOrg.setText(this.getUser().getCU().getNumber() + "--" + this.getUser().getCU().getName());
            this.kDLabelContainerDefaulOrg.setBounds(new Rectangle(422, 5, 100, 19));
            this.kDLabelDefaultOrg.setBounds(new Rectangle(510, 6, 372, 19));
            this.kDLabelContainerDefaulOrg.setVisible(true);
            this.kDLabelDefaultOrg.setVisible(true);
        } else {
            this.kDLabelContainerDefaulOrg.setVisible(false);
            this.kDLabelDefaultOrg.setVisible(false);
        }
    }

    private void initManagedCu() throws Exception {
        ObjectUuidPK userPk = new ObjectUuidPK(this.getUser().getId());
        if (Administrator.isSuperAdmin((IObjectPK)userPk)) {
            return;
        }
        this.managedOrgids = OrgRangeIncludeSubOrgFactory.getRemoteInstance().getOrgIdsByUserAndTypeUsingSQL(this.getCurrentUserPK().toString(), Administrator.isAdminType(this.getCurrentUser().getType()) ? OrgRangeType.BIZ_ORG_TYPE : OrgRangeType.MANAGE_ORG_TYPE);
    }

    private void getBizOrg() {
        this.getInputMap(1).put(KeyStroke.getKeyStroke(66, 3), "biz");
        this.getActionMap().put("biz", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    IOrgRangeIncludeSubOrg iOrgRange = (IOrgRangeIncludeSubOrg)OrgRangeListUI.this.getBizInterface();
                    Set oldSelectedOrgs = iOrgRange.getOrgIdsByUserAndType((IObjectPK)new ObjectUuidPK(OrgRangeListUI.this.getUser().getId()), OrgRangeListUI.this.getOrgRangeType());
                    boolean isSuperAuAdmin = Administrator.isSuperAuAdmin((IObjectPK)new ObjectUuidPK(OrgRangeListUI.this.getUser().getId()));
                    IObjectPK curUserPK = ToolUtils.getCurrentUserPK();
                    OUUnionF7 orgF7 = new OUUnionF7((IUIObject)null);
                    orgF7.setCumulate(true);
                    orgF7.setIsDisplayMaintain(true);
                    orgF7.setShowAssistantOrg(true);
                    orgF7.setShowSub(true);
                    orgF7.setMultiCUs(true);
                    if (isSuperAuAdmin) {
                        orgF7.setCuIdList(PermissionUtils.getAllCU(null));
                    } else {
                        orgF7.setCuIdList(PermissionRangeHelper.getBizUserCUOrgRange(null, curUserPK));
                    }
                    orgF7.disableTheOUWhichIsOnlyAdmin();
                    orgF7.setMultiSelect(true);
                    orgF7.setIsShowContainSealUp(true);
                    orgF7.setCheckedOrgIDs(oldSelectedOrgs);
                    if (!Administrator.isCUAdmin(null, curUserPK) && !isSuperAuAdmin) {
                        List userOrgRangeList = PermissionRangeHelper.getUserOrgId(null, curUserPK, OrgRangeType.BIZ_ORG_TYPE);
                        orgF7.useFilter(ToolUtils.trans2Map(userOrgRangeList));
                    }
                    orgF7.show();
                }
                catch (Exception e1) {
                    logger.error((Object)e1);
                }
            }
        });
    }

    private void getAdminOrg() {
        this.getInputMap(1).put(KeyStroke.getKeyStroke(65, 3), "admin");
        this.getActionMap().put("admin", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    IOrgRangeIncludeSubOrg iOrgRange = (IOrgRangeIncludeSubOrg)OrgRangeListUI.this.getBizInterface();
                    Set oldSelectedOrgs = iOrgRange.getOrgIdsByUserAndType((IObjectPK)new ObjectUuidPK(OrgRangeListUI.this.getUser().getId()), OrgRangeListUI.this.getOrgRangeType());
                    OrgF7 orgF7 = PermissionOrgF7Factory.getOrgF7((IUIObject)OrgRangeListUI.this, new OrgViewType[]{OrgViewType.ADMIN}, true, ToolUtils.getCurrentCUPK().toString());
                    if (oldSelectedOrgs != null && !oldSelectedOrgs.isEmpty()) {
                        orgF7.setCheckedOrgIDs(oldSelectedOrgs);
                    }
                    orgF7.show();
                }
                catch (Exception e1) {
                    logger.error((Object)e1);
                }
            }
        });
    }

    private void getCUOrg() {
        this.getInputMap(1).put(KeyStroke.getKeyStroke(67, 3), "cu");
        this.getActionMap().put("cu", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    IOrgRangeIncludeSubOrg iOrgRange = (IOrgRangeIncludeSubOrg)OrgRangeListUI.this.getBizInterface();
                    Set oldSelectedOrgs = iOrgRange.getOrgIdsByUserAndType((IObjectPK)new ObjectUuidPK(OrgRangeListUI.this.getUser().getId()), OrgRangeListUI.this.getOrgRangeType());
                    CtrlF7 ctrlF7 = new CtrlF7();
                    ctrlF7.setRootUnitID(OrgRangeListUI.this.getUser().getCU().getId().toString());
                    ctrlF7.setMultiSelect(true);
                    ctrlF7.setCheckedOrgIDs(oldSelectedOrgs);
                    ctrlF7.setUnChangeableOrgIDs(oldSelectedOrgs);
                    ctrlF7.setIsShowContainSealUp(true);
                    if (OrgRangeListUI.this.getUser().getId() != null && Administrator.isSuperAdmin((IObjectPK)new ObjectUuidPK(OrgRangeListUI.this.getUser().getId()))) {
                        ctrlF7.setRootUnitID("00000000-0000-0000-0000-000000000000CCE7AED4");
                        ctrlF7.disablePerm();
                    }
                    ctrlF7.setShowNameandNumber(true);
                    ctrlF7.show();
                }
                catch (Exception e1) {
                    logger.error((Object)e1);
                }
            }
        });
    }

    private void getManageOrg() {
        this.getInputMap(1).put(KeyStroke.getKeyStroke(77, 3), "manage");
        this.getActionMap().put("manage", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    IOrgRangeIncludeSubOrg iOrgRange = (IOrgRangeIncludeSubOrg)OrgRangeListUI.this.getBizInterface();
                    Set oldSelectedOrgs = iOrgRange.getOrgIdsByUserAndType((IObjectPK)new ObjectUuidPK(OrgRangeListUI.this.getUser().getId()), OrgRangeListUI.this.getOrgRangeType());
                    OrgF7 orgF7 = PermissionOrgF7Factory.getOrgF7((IUIObject)OrgRangeListUI.this, new OrgViewType[]{OrgViewType.CTRLUNIT}, true, ToolUtils.getCurrentCUPK().toString());
                    if (oldSelectedOrgs != null && !oldSelectedOrgs.isEmpty()) {
                        orgF7.setCheckedOrgIDs(oldSelectedOrgs);
                    }
                    orgF7.show();
                }
                catch (Exception e1) {
                    logger.error((Object)e1);
                }
            }
        });
    }

    private void addFunction() {
        this.getBizOrg();
        this.getAdminOrg();
        this.getCUOrg();
        this.getManageOrg();
    }

    private void initSubOrgRange() throws BOSException, EASBizException {
        IOrgRangeIncludeSubOrg iOrgRangeSub = OrgRangeIncludeSubOrgFactory.getRemoteInstance();
        iOrgRangeSub.initSubOrgByOldUserOrgRange((IObjectPK)new ObjectUuidPK(this.getUser().getId()));
    }

    protected void initTable() {
        IColumn isIncludeSubOrgCol;
        if (OrgRangeType.ADMIN_ORG_TYPE.equals((Object)this.getOrgRangeType()) && (isIncludeSubOrgCol = this.tblMain.getColumn(ISINCLUDESUBORG)) != null) {
            isIncludeSubOrgCol.setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)new KDCheckBox()));
        }
        this.tblMain.getStyleAttributes().setLocked(true);
        IColumn includeSubColumn = this.tblMain.getColumn(ISINCLUDESUBORG);
        if (includeSubColumn != null) {
            includeSubColumn.getStyleAttributes().setLocked(false);
        }
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    OrgRangeListUI.this.kdtTable_editStoped(e);
                }
                catch (Exception e2) {
                    ExceptionHandler.handle((Throwable)e2);
                }
            }

            public void editStarting(KDTEditEvent e) {
                try {
                    ControlUtilities.checkFocusAndCommit();
                }
                catch (ParseException e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        this.tblMain.getInputMap().remove(KeyStroke.getKeyStroke("ctrl pressed A"));
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                if (Administrator.isSuperAdmin((IObjectPK)new ObjectUuidPK(OrgRangeListUI.this.getUser().getId()))) {
                    return;
                }
                int start = e.getFirstRow();
                int end = e.getLastRow();
                for (int i = start; i <= end; ++i) {
                    String org = (String)OrgRangeListUI.this.tblMain.getCell(i, OrgRangeListUI.this.CUID).getValue();
                    if (OrgRangeListUI.this.managedOrgids.contains(org)) continue;
                    OrgRangeListUI.this.tblMain.getRow(i).getStyleAttributes().setBackground(new Color(227, 227, 227));
                    OrgRangeListUI.this.tblMain.getRow(i).getStyleAttributes().setLocked(true);
                }
            }
        });
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                if (Administrator.isSuperAdmin((IObjectPK)new ObjectUuidPK(OrgRangeListUI.this.getUser().getId()))) {
                    return;
                }
                int start = e.getSelectBlock().getBeginRow();
                int end = e.getSelectBlock().getEndRow();
                for (int i = start; i <= end; ++i) {
                    String orgid = (String)OrgRangeListUI.this.tblMain.getRow(i).getCell(OrgRangeListUI.this.CUID).getValue();
                    if (!OrgRangeListUI.this.managedOrgids.contains(orgid)) continue;
                    OrgRangeListUI.this.btnDelOrg.setEnabled(true);
                    return;
                }
                OrgRangeListUI.this.btnDelOrg.setEnabled(false);
            }
        });
    }

    private void kdtTable_editStoped(KDTEditEvent e) throws Exception {
        if (OrgRangeType.ADMIN_ORG_TYPE.equals((Object)this.getOrgRangeType())) {
            IColumn isIncludeSubOrgCol = this.tblMain.getColumn(ISINCLUDESUBORG);
            IRow row = this.tblMain.getRow(e.getRowIndex());
            if (isIncludeSubOrgCol != null && e.getColIndex() == isIncludeSubOrgCol.getColumnIndex()) {
                String orgId = row.getCell(ORGID).getValue().toString();
                UserInfo curUser = this.getCurrentUser();
                ObjectUuidPK curUserPK = new ObjectUuidPK(curUser.getId());
                boolean includeFlag = (Boolean)e.getValue();
                if (includeFlag && !Administrator.isCUAdmin(null, (IObjectPK)curUserPK)) {
                    String curUserId = curUserPK.toString();
                    IOrgRangeIncludeSubOrg iOrgRange = (IOrgRangeIncludeSubOrg)this.getBizInterface();
                    if (!iOrgRange.canGrantIncludeSubOrg(curUserId, orgId)) {
                        String msg = MessageFormat.format(EASResource.getString((String)this.RESOURCE, (String)"USER_INCLUDESUBORG_INFO"), curUser.getNumber(), row.getCell(ORGNAME).getValue().toString());
                        MsgBox.showInfo((String)msg);
                        e.setValue((Object)Boolean.FALSE);
                        this.tblMain.refresh();
                        SysUtil.abort();
                    }
                }
                OrgRangeIncludeSubOrgInfo orgRange = new OrgRangeIncludeSubOrgInfo();
                FullOrgUnitInfo orgInfo = new FullOrgUnitInfo();
                orgInfo.setId(BOSUuid.read((String)orgId));
                orgInfo.setLongNumber(row.getCell(LONGNUMBER).getValue().toString());
                orgRange.setOrg(orgInfo);
                orgRange.setIsIncludeSubOrg(includeFlag);
                orgRange.setId(BOSUuid.read((String)row.getCell(ID).getValue().toString()));
                orgRange.setType(this.getOrgRangeType());
                UserInfo userInfo = new UserInfo();
                userInfo.setId(this.getUser().getId());
                orgRange.setUser(userInfo);
                OrgRangeParam orgRangeParam = this.getOrgRangeParam(null, null, orgRange);
                try {
                    this.saveOrgRange(orgRangeParam);
                    this.refreshList();
                }
                catch (Exception e1) {
                    this.handleException(e1);
                }
            }
        }
    }

    private void initOrgRangeType() {
        try {
            boolean manageOrgRangeByAdminOrg = Boolean.valueOf(ParamManager.getParamValue(null, null, (String)"manageOrgRangeByAdminOrg"));
            if (manageOrgRangeByAdminOrg) {
                this.kdcOrgRangeType.removeItem((Object)OrgRangeType.MANAGE_ORG_TYPE);
            } else {
                this.kdcOrgRangeType.removeItem((Object)OrgRangeType.MANAGE_ADMIN_ORG_TYPE);
            }
        }
        catch (BOSException be) {
            this.handleException((Exception)((Object)be));
        }
        catch (EASBizException ee) {
            this.handleException((Exception)((Object)ee));
        }
        UserType userType = this.getUser().getType();
        this.kdcOrgRangeType.removeItem((Object)OrgRangeType.UNION_ORG_TYPE);
        if (Administrator.isAdminType(userType)) {
            this.kdcOrgRangeType.removeAllItems();
            this.kdcOrgRangeType.addItems(SystemOrgRangeTypeEnum.getEnumList().toArray());
        } else if (!this.getUser().isBizAdmin()) {
            this.kdcOrgRangeType.removeItem((Object)OrgRangeType.MANAGE_ORG_TYPE);
            this.kdcOrgRangeType.removeItem((Object)OrgRangeType.MANAGE_ADMIN_ORG_TYPE);
        }
        if (this.getUser().isBizAdmin() && this.getCurrentUser().isBizAdmin() && !this.getUser().getId().toString().equals(this.getCurrentUser().getId().toString())) {
            this.kdcOrgRangeType.removeItem((Object)OrgRangeType.MANAGE_ORG_TYPE);
            this.kdcOrgRangeType.removeItem((Object)OrgRangeType.MANAGE_ADMIN_ORG_TYPE);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddOrg.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelOrg.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnDelAllOrg.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnAddOrgSln.setIcon(EASResource.getIcon((String)"imgTbtn_importcyclostyle"));
    }

    private OrgRangeType getOrgRangeType() {
        UserType userType = this.getUser().getType();
        if (Administrator.isAdminType(userType) && SystemOrgRangeTypeEnum.SYS_ADMIN_ORG_TYPE.equals((Object)((SystemOrgRangeTypeEnum)((Object)this.kdcOrgRangeType.getSelectedItem())))) {
            return OrgRangeType.BIZ_ORG_TYPE;
        }
        return (OrgRangeType)((Object)this.kdcOrgRangeType.getSelectedItem());
    }

    public void actionOrgRangeTypeChanged(ActionEvent e) {
        OrgRangeType orgRangeType = this.getOrgRangeType();
        try {
            this.swithToType(orgRangeType);
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
    }

    protected void swithToType(OrgRangeType orgRangeType) throws Exception {
        ListUI orgTypeUI = this.getTypeUI(orgRangeType);
        KDTable currentTable = orgTypeUI.getMainTable();
        currentTable.checkParsed(true);
        this.tblMain.removeColumns();
        this.tblMain.setFormatXml(currentTable.getFormatXml());
        this.mainQueryPK = orgTypeUI.getMainQueryPK();
        this.mainQuery.setFilter(this.getDefaultFilterForQuery());
        this.tblMain.putBindContents("mainQuery", this.getFields(orgRangeType));
        this.tblMain.checkParsed(true);
        this.tblMain.getSelectManager().setSelectMode(10);
        this.initDefaultOrg();
        this.execQuery();
    }

    private ListUI getTypeUI(OrgRangeType type) throws Exception {
        if (OrgRangeType.ADMIN_ORG_TYPE.equals((Object)type)) {
            return new AdminOrgRangeListUI();
        }
        return new OrgRangeListUI();
    }

    private String[] getFields(OrgRangeType type) {
        if (OrgRangeType.ADMIN_ORG_TYPE.equals((Object)type)) {
            return new String[]{"org.number", ORGNAME, ISINCLUDESUBORG, ORGID, ID, "org.longNumber"};
        }
        return new String[]{ID, "", ORGID, "org.number", ORGNAME};
    }

    private UserInfo getUser() {
        IObjectPK userPK = (IObjectPK)this.getUIContext().get("userPK");
        if (this.userInfo == null) {
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("*"));
            selectors.add(new SelectorItemInfo("defOrgUnit.*"));
            selectors.add(new SelectorItemInfo("CU.number"));
            selectors.add(new SelectorItemInfo("CU.name"));
            try {
                this.userInfo = UserFactory.getRemoteInstance().getUserInfo(userPK, selectors);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return this.userInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return OrgRangeIncludeSubOrgFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo defaultFilter = super.getDefaultFilterForQuery();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo userFilterItem = new FilterItemInfo("user.id", (Object)this.getUser().getId().toString());
        FilterItemInfo typeFilterItem = null;
        if (OrgRangeType.BIZ_ORG_TYPE.equals((Object)this.getOrgRangeType())) {
            typeFilterItem = new FilterItemInfo("type", (Object)new Integer(10));
        } else if (OrgRangeType.ADMIN_ORG_TYPE.equals((Object)this.getOrgRangeType())) {
            typeFilterItem = new FilterItemInfo("type", (Object)new Integer(20));
        } else if (OrgRangeType.MANAGE_ORG_TYPE.equals((Object)this.getOrgRangeType())) {
            typeFilterItem = new FilterItemInfo("type", (Object)new Integer(30));
        } else if (OrgRangeType.MANAGE_ADMIN_ORG_TYPE.equals((Object)this.getOrgRangeType())) {
            typeFilterItem = new FilterItemInfo("type", (Object)new Integer(50));
        }
        filter.getFilterItems().add(userFilterItem);
        filter.getFilterItems().add(typeFilterItem);
        if (OrgRangeType.BIZ_ORG_TYPE.equals((Object)this.getOrgRangeType())) {
            if (Administrator.isAdminType(this.getUser().getType())) {
                filter.getFilterItems().add(new FilterItemInfo(ORGID, (Object)this.getUser().getCU().getId().toString(), CompareType.NOTEQUALS));
            } else {
                filter.getFilterItems().add(new FilterItemInfo(ORGID, (Object)this.getUser().getDefOrgUnit().getId().toString(), CompareType.NOTEQUALS));
            }
        } else if (OrgRangeType.MANAGE_ORG_TYPE.equals((Object)this.getOrgRangeType())) {
            filter.getFilterItems().add(new FilterItemInfo(ORGID, (Object)this.getUser().getCU().getId().toString(), CompareType.NOTEQUALS));
        } else if (OrgRangeType.MANAGE_ADMIN_ORG_TYPE.equals((Object)this.getOrgRangeType())) {
            filter.getFilterItems().add(new FilterItemInfo(ORGID, (Object)this.getUser().getCU().getId().toString(), CompareType.NOTEQUALS));
        }
        if (defaultFilter == null || defaultFilter.getFilterItems().size() == 0) {
            filter.setMaskString(null);
            return filter;
        }
        try {
            defaultFilter.mergeFilter(filter, "and");
            defaultFilter.setMaskString(null);
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        return defaultFilter;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    private boolean isBizOrgType() {
        return OrgRangeType.BIZ_ORG_TYPE.equals((Object)this.getOrgRangeType()) && !Administrator.isAdminType(this.getUser().getType());
    }

    private boolean isSystemOrgType() {
        return OrgRangeType.BIZ_ORG_TYPE.equals((Object)this.getOrgRangeType()) && Administrator.isAdminType(this.getUser().getType());
    }

    private boolean isAdminOrgType() {
        return OrgRangeType.ADMIN_ORG_TYPE.equals((Object)this.getOrgRangeType());
    }

    private boolean isManagerOrgType() {
        return OrgRangeType.MANAGE_ORG_TYPE.equals((Object)this.getOrgRangeType());
    }

    private boolean isManagerAdminOrgType() {
        return OrgRangeType.MANAGE_ADMIN_ORG_TYPE.equals((Object)this.getOrgRangeType());
    }

    @Override
    public void actionAddOrg_actionPerformed(ActionEvent e) throws Exception {
        FullOrgUnitInfo[] newSelectedOrgs = null;
        Object orgF7 = null;
        final ArrayList old = new ArrayList();
        if (this.isBizOrgType()) {
            orgF7 = new BizOrgRangeF7PromptDialog((IUIObject)this, this.getUser()){

                public void viewDidShow() {
                    super.getInnerF7UI().setCancel(false);
                    OrgRangeListUI.this.initSnapshot((OrgRangeF7PromptDialog)this, old);
                    super.getInnerF7UI().setCancel(true);
                }
            };
        } else if (this.isSystemOrgType()) {
            orgF7 = new CtrlUnitOrgRangeF7PromptDialog((IUIObject)this, this.getUser()){

                protected StringBuffer getOrgRangeSQL(int orgRangeType, UserInfo userInfo) {
                    if ("00000000-0000-0000-0000-00000000000013B7DE7F".equals(OrgRangeListUI.this.getUser().getId().toString())) {
                        return new StringBuffer("select fid from t_org_baseunit where fiscu =1");
                    }
                    return super.getOrgRangeSQL(orgRangeType, userInfo);
                }

                public void viewDidShow() {
                    super.getInnerF7UI().setCancel(false);
                    OrgRangeListUI.this.initSnapshot((OrgRangeF7PromptDialog)this, old);
                    super.getInnerF7UI().setCancel(true);
                }
            };
        } else if (this.isAdminOrgType()) {
            orgF7 = new AdminOrgRangeF7PromptDialog((IUIObject)this, this.getUser()){

                public void viewDidShow() {
                    super.getInnerF7UI().setCancel(false);
                    OrgRangeListUI.this.initSnapshot((OrgRangeF7PromptDialog)this, old);
                    super.getInnerF7UI().setCancel(true);
                }

                protected OrgAssistInfo buildNewOrgF7AssistInfo(OrgViewType orgViewType, OrgTreeInfo orgTreeInfo, CoreBaseInfo userObject) throws EASBizException, BOSException {
                    OrgAssistInfo info = super.buildNewOrgF7AssistInfo(orgViewType, orgTreeInfo, userObject);
                    info.setNeedAddOrgRange(false);
                    info.setNeedAddUserCU(false);
                    info.setNeedAddCU(false);
                    info.setIgnoreUnionGroup(true);
                    info.setNeedConsiderFaultTree(true);
                    StringBuffer extraFilters = new StringBuffer();
                    extraFilters.append(" AND ").append("\"BASEUNIT\"").append(".FControlUnitID IN (").append(PermissionRangeHelper.getBizUserCUOrgRangeSQL(null, ToolUtils.getCurrentUserPK())).append(")");
                    info.setExtraFilters(extraFilters.toString());
                    return info;
                }

                public FilterInfo getOuterFilterInfo() {
                    FilterInfo filter = new FilterInfo();
                    try {
                        StringBuffer result = new StringBuffer();
                        result.append("UNIT.CU.id in (").append(PermissionRangeHelper.getBizUserCUOrgRangeSQL(null, ToolUtils.getCurrentUserPK())).append(")");
                        filter.mergeFilter(new FilterInfo(result.toString()), "and");
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                    return filter;
                }
            };
        } else if (this.isManagerOrgType()) {
            orgF7 = new ManageOrgRangeF7PromptDialog((IUIObject)this, this.getUser()){

                public void viewDidShow() {
                    super.getInnerF7UI().setCancel(false);
                    OrgRangeListUI.this.initSnapshot((OrgRangeF7PromptDialog)this, old);
                    super.getInnerF7UI().setCancel(true);
                }
            };
        } else if (this.isManagerAdminOrgType()) {
            orgF7 = new AdminOrgRangeF7PromptDialog((IUIObject)this, this.getUser()){

                public void viewDidShow() {
                    super.getInnerF7UI().setCancel(false);
                    OrgRangeListUI.this.initSnapshot((OrgRangeF7PromptDialog)this, old);
                    super.getInnerF7UI().setCancel(true);
                }

                public FilterInfo getOuterFilterInfo() {
                    FilterInfo filter = new FilterInfo();
                    try {
                        StringBuffer result = new StringBuffer();
                        result.append("UNIT.CU.id in (").append(PermissionRangeHelper.getBizUserCUOrgRangeSQL(null, ToolUtils.getCurrentUserPK())).append(")");
                        filter.mergeFilter(new FilterInfo(result.toString()), "and");
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                    return filter;
                }

                protected OrgAssistInfo buildNewOrgF7AssistInfo(OrgViewType orgViewType, OrgTreeInfo orgTreeInfo, CoreBaseInfo userObject) throws EASBizException, BOSException {
                    OrgAssistInfo info = super.buildNewOrgF7AssistInfo(orgViewType, orgTreeInfo, userObject);
                    info.setNeedAddOrgRange(false);
                    info.setNeedAddUserCU(false);
                    info.setNeedAddCU(false);
                    info.setIgnoreUnionGroup(true);
                    info.setNeedConsiderFaultTree(true);
                    StringBuffer extraFilters = new StringBuffer();
                    extraFilters.append(" AND ").append("\"BASEUNIT\"").append(".FControlUnitID IN (").append(PermissionRangeHelper.getBizUserCUOrgRangeSQL(null, ToolUtils.getCurrentUserPK())).append(")");
                    info.setExtraFilters(extraFilters.toString());
                    return info;
                }
            };
        }
        StringBuffer selectedOrgSQL = new StringBuffer();
        if (!Administrator.isSuperAdmin((IObjectPK)new ObjectUuidPK(this.getUser().getId()))) {
            StringBuffer manageSQL = new StringBuffer();
            if (this.isManagerAdminOrgType()) {
                manageSQL.append("select forgid from t_pm_orgrangeincludesuborg where fuserid = '").append(this.getCurrentUserPK().toString()).append("' and ftype = ").append(Administrator.isAdminType(this.getCurrentUser().getType()) ? 10 : 50);
            } else {
                manageSQL.append("select forgid from t_pm_orgrangeincludesuborg where fuserid = '").append(this.getCurrentUserPK().toString()).append("' and ftype = ").append(Administrator.isAdminType(this.getCurrentUser().getType()) ? 10 : 30);
            }
            selectedOrgSQL.append("select fid from t_org_baseunit where fid in (");
            selectedOrgSQL.append("select forgid from t_pm_orgrange where fuserid = '").append(this.getUser().getId().toString()).append("' and ftype = ").append(this.getOrgRangeType().getValue()).append(")").append(" and ((FIsUnion <>1 and FControlUnitId in (").append(manageSQL).append("))").append("or (FIsUnion=1 and FMaintainCuID in (").append(manageSQL).append(")))");
        } else {
            selectedOrgSQL.append("select forgid from t_pm_orgrange where fuserid = '").append(this.getUser().getId().toString()).append("' and ftype = ").append(this.getOrgRangeType().getValue());
        }
        orgF7.setSelectedOrgIdSQL(selectedOrgSQL.toString());
        orgF7.show();
        newSelectedOrgs = PermissionUIHelper.getOrgs(orgF7.getData());
        HashSet<String> newSelectedOrgIdSet = new HashSet<String>();
        if (newSelectedOrgs == null) {
            return;
        }
        for (int i = newSelectedOrgs.length - 1; i >= 0; --i) {
            newSelectedOrgIdSet.add(newSelectedOrgs[i].getId().toString());
        }
        HashSet<String> oldSelectedOrgs = new HashSet<String>();
        for (int i = 0; i < old.size(); ++i) {
            oldSelectedOrgs.add(((FullOrgUnitInfo)old.get(i)).getId().toString());
        }
        Collection deletedOrgs = this.getNotContain(newSelectedOrgIdSet, oldSelectedOrgs);
        Collection addedOrgs = this.getNotContain(oldSelectedOrgs, newSelectedOrgIdSet);
        this.checkDeleteDefaultOrg(deletedOrgs);
        long begin = System.currentTimeMillis();
        this.checkOrgIsRelatedWithPerms(deletedOrgs);
        this.checkOrgCanDelete(deletedOrgs);
        long end = System.currentTimeMillis();
        logger.error((Object)("this.checkOrgIsRelatedWithPerms(deletedOrgs); cost:" + (end - begin) / 1000L));
        this.saveOrgRange(this.getOrgRangeParam(deletedOrgs, addedOrgs, null));
        long end2 = System.currentTimeMillis();
        logger.error((Object)(" saveOrgRange(getOrgRangeParam(deletedOrgs,addedOrgs,null)); cost:" + (end2 - end) / 1000L));
        this.tblMain.refresh();
    }

    public void initSnapshot(OrgRangeF7PromptDialog dialog, List old) {
        FullOrgUnitInfo[] tmp = PermissionUIHelper.getOrgs(dialog.getData());
        if (tmp == null) {
            return;
        }
        for (FullOrgUnitInfo info : tmp) {
            old.add(info);
        }
    }

    private Set getOldSelectedOrgs() throws Exception {
        IOrgRangeIncludeSubOrg iOrgRange = (IOrgRangeIncludeSubOrg)this.getBizInterface();
        Set oldSelectedOrgs = null;
        try {
            oldSelectedOrgs = iOrgRange.getOrgIdsByUserAndType((IObjectPK)new ObjectUuidPK(this.getUser().getId()), this.getOrgRangeType());
        }
        catch (FindedTooMuchRecordsException e1) {
            logger.warn((Object)e1);
            oldSelectedOrgs = iOrgRange.getOrgIdsByUserAndTypeUsingSQL(this.getUser().getId().toString(), this.getOrgRangeType());
        }
        return oldSelectedOrgs;
    }

    private OrgRangeParam getOrgRangeParam(Collection deletedOrgs, Collection addedOrgs, OrgRangeIncludeSubOrgInfo changedOrgRangeIncludeSubOrg) {
        ObjectUuidPK userPK = new ObjectUuidPK(this.getUser().getId());
        OrgRangeType orgRangeType = this.getOrgRangeType();
        return new OrgRangeParam((IObjectPK)userPK, orgRangeType, deletedOrgs, addedOrgs, changedOrgRangeIncludeSubOrg);
    }

    private void saveOrgRange(OrgRangeParam orgRangeParam) throws Exception {
        IOrgRangeIncludeSubOrg iOrgRange = (IOrgRangeIncludeSubOrg)this.getBizInterface();
        iOrgRange.saveOrgRange(orgRangeParam);
        CacheService.getInstance().discardAll();
    }

    private void checkOrgIsRelatedWithPerms(Collection orgIds) throws EASBizException, BOSException {
        IUser iUser;
        ObjectUuidPK userPK = new ObjectUuidPK(this.getUser().getId());
        if (!Administrator.isAdminType(this.getUser().getType()) && OrgRangeType.BIZ_ORG_TYPE.equals((Object)this.getOrgRangeType()) && orgIds.size() > 0 && (iUser = UserFactory.getRemoteInstance()).checkOrgIsRelatedWithPerms((IObjectPK)userPK, orgIds)) {
            String msg = MessageFormat.format(EASResource.getString((String)this.RESOURCE, (String)"CONFIRM_DELETE_ORGRANGE"), new Object[]{null});
            if (MsgBox.showConfirm2((Component)((Object)this), (String)msg) == 2) {
                this.abort();
            }
            long begin = System.currentTimeMillis();
            iUser.deleteRelativePermAndRole((IObjectPK)userPK, orgIds);
            System.out.println("deleteRelativePermAndRole cost: " + (System.currentTimeMillis() - begin));
        }
    }

    private Collection getNotContain(Collection container, Collection containee) {
        ArrayList notContain = new ArrayList();
        for (Object obj : containee) {
            if (container.contains(obj)) continue;
            notContain.add(obj);
        }
        return notContain;
    }

    @Override
    public void actionAddOrgSolution_actionPerformed(ActionEvent e) throws Exception {
        KDBizPromptBox orgSolutionF7 = OrgRangeSolutionUtil.getOrgRangeF7(this.getOrgRangeType());
        OrgRangeSolutionCollection coll = OrgRangeSolutionUtil.getOrgRangeSolutionColl(orgSolutionF7);
        HashSet<String> planIds = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            planIds.add(coll.get(i).getId().toString());
        }
        List selectedOrgIds = OrgRangeSolutionFactory.getRemoteInstance().getOrgIDListFromSolutionCollWithPermission(planIds, this.getCurrentUserPK());
        IOrgRangeIncludeSubOrg iOrgRange = (IOrgRangeIncludeSubOrg)this.getBizInterface();
        Set oldSelectedOrgs = iOrgRange.getOrgIdsByUserAndType((IObjectPK)new ObjectUuidPK(this.getUser().getId()), this.getOrgRangeType());
        Collection addedOrgIds = this.getNotContain(oldSelectedOrgs, selectedOrgIds);
        OrgRangeParam orgRangeParam = this.getOrgRangeParam(null, addedOrgIds, null);
        this.saveOrgRange(orgRangeParam);
        this.refreshList();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionDelOrg_actionPerformed(ActionEvent e) throws Exception {
        long begin = System.currentTimeMillis();
        this.checkSelected();
        if (OrgRangeType.MANAGE_ORG_TYPE.equals((Object)this.getOrgRangeType()) && !this.isManageOrgCapable()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE, (String)"notDeal"));
            this.abort();
        }
        ArrayList<String> deletedOrgIds = new ArrayList<String>();
        ArrayList<FullOrgUnitInfo> deletedOrgs = new ArrayList<FullOrgUnitInfo>();
        int[] selectedRowIndexes = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        System.out.println("----->cost1: " + (System.currentTimeMillis() - begin));
        begin = System.currentTimeMillis();
        for (int i = 0; i < selectedRowIndexes.length; ++i) {
            int rowIndex = selectedRowIndexes[i];
            IRow row = this.tblMain.getRow(rowIndex);
            String orgId = row.getCell(ORGID).getValue().toString();
            String cuId = row.getCell(this.CUID).getValue().toString();
            if (!Administrator.isSuperAdmin((IObjectPK)new ObjectUuidPK(this.getUser().getId())) && !this.managedOrgids.contains(cuId)) continue;
            FullOrgUnitInfo orgInfo = new FullOrgUnitInfo();
            orgInfo.setId(BOSUuid.read((String)orgId));
            orgInfo.setName((String)row.getCell(ORGNAME).getValue());
            CtrlUnitInfo cu = new CtrlUnitInfo();
            cu.setId(BOSUuid.read((String)cuId));
            orgInfo.setCU(cu);
            deletedOrgs.add(orgInfo);
            deletedOrgIds.add(orgId);
        }
        this.checkOrgCanDelete(deletedOrgIds);
        this.checkDeleteDefaultOrg(deletedOrgIds);
        this.checkOrgIsRelatedWithPerms(deletedOrgIds);
        OrgRangeParam orgRangeParam = this.getOrgRangeParam(deletedOrgIds, null, null);
        this.saveOrgRange(orgRangeParam);
        this.refreshList();
    }

    private void checkDeleteDefaultOrg(Collection deletedOrgIds) {
        if ((this.isBizOrgType() || this.isSystemOrgType()) && this.getUser().getDefOrgUnit() != null && deletedOrgIds.contains(this.getUser().getDefOrgUnit().getId().toString())) {
            MsgBox.showWarning((String)MessageFormat.format(EASResource.getString((String)this.RESOURCE, (String)"Default_Org_Cannot_Delete"), this.getUser().getDefOrgUnit().getName()));
            SysUtil.abort();
        }
        UserType userType = this.getUser().getType();
        FullOrgUnitInfo defaultOrgInfo = this.getUser().getDefOrgUnit();
        String defaultOrgId = defaultOrgInfo.getId().toString();
        if (userType.equals((Object)UserType.AUTHENTICATEADMIN) && defaultOrgInfo != null && deletedOrgIds.contains(defaultOrgId)) {
            MsgBox.showWarning((String)MessageFormat.format(EASResource.getString((String)this.RESOURCE, (String)"Default_Org_Cannot_Delete"), this.getUser().getDefOrgUnit().getName()));
            SysUtil.abort();
        }
    }

    private boolean isManageOrgCapable() throws BOSException, EASBizException {
        UserInfo curUserInfo = ToolUtils.getCurrentUser();
        boolean curState = true;
        if (this.userInfo.getId() != null) {
            curState = UIFunctionView.getInstance().hasPermission(curUserInfo, this.userInfo, "UserEditUI", "FUNCTION_EIDT_MANAGE_ORG");
        }
        return curState;
    }

    private void checkOrgCanDelete(Collection orgUnitInfos) throws BOSException, EASBizException {
        FullOrgUnitCollection fullOrgCol = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection("select CU.id , name WHERE id in(" + ToolUtils.aryToStr(orgUnitInfos) + ")");
        for (OrgUnitInfo orgUnitInfo : fullOrgCol) {
            if (this.isManagerOrgType() && orgUnitInfo.getId().equals((Object)this.getUser().getCU().getId())) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE, (String)"DEFAULT_NOT_DEL"));
                this.abort();
            }
            if (this.userInfo.getId() == null || !Administrator.isCUAdminType(this.userInfo.getType()) || !orgUnitInfo.getId().equals((Object)this.getUser().getCU().getId())) continue;
            String msg = MessageFormat.format(EASResource.getString((String)this.RESOURCE, (String)"PARENT_ORG_CAN_NOT_DELETE"), orgUnitInfo.getName());
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            this.abort();
        }
    }

    private UserInfo getCurrentUser() {
        return SysContext.getSysContext().getCurrentUserInfo();
    }

    private IObjectPK getCurrentUserPK() {
        return new ObjectUuidPK(this.getCurrentUser().getId());
    }

    private List getUserCuIdList() throws EASBizException, BOSException {
        if (this.currentCUIdList == null) {
            this.currentCUIdList = PermissionUIHelper.getUserCuIdList();
        }
        return this.currentCUIdList;
    }

    protected String[] getLocateNames() {
        if (OrgRangeType.ADMIN_ORG_TYPE.equals((Object)this.getOrgRangeType())) {
            return new String[]{"org.number", ORGNAME, LONGNUMBER};
        }
        return new String[]{"org.number", ORGNAME};
    }

    public boolean checkBeforeWindowClosing() {
        try {
            ControlUtilities.checkFocusAndCommit();
        }
        catch (ParseException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return super.checkBeforeWindowClosing();
    }

    protected String getOrgIdColName() {
        return ORGID;
    }

    protected String getResource() {
        return this.RESOURCE;
    }

    @Override
    public void actionDelAllOrg_actionPerformed(ActionEvent e) throws Exception {
        Map orgInfoMap = OrgRangeIncludeSubOrgFactory.getRemoteInstance().getUserOrgRangeOrgInfo(this.userInfo, this.getOrgRangeType());
        ArrayList deleteOrgList = new ArrayList(orgInfoMap.keySet());
        Collection deleteOrgs = orgInfoMap.values();
        if (!Administrator.isSuperAdmin((IObjectPK)new ObjectUuidPK(this.getUser().getId()))) {
            Iterator ite = deleteOrgs.iterator();
            while (ite.hasNext()) {
                FullOrgUnitInfo orgInfo = (FullOrgUnitInfo)ite.next();
                String orgid = orgInfo.getId().toString();
                if (orgInfo.isIsUnion() && !this.managedOrgids.contains(orgInfo.getMaintainCU().getId().toString())) {
                    ite.remove();
                    deleteOrgList.remove(orgid);
                    continue;
                }
                if (this.managedOrgids.contains(orgInfo.getCU().getId().toString())) continue;
                ite.remove();
                deleteOrgList.remove(orgid);
            }
        }
        this.checkOrgCanDelete(deleteOrgs);
        this.checkOrgIsRelatedWithPerms(deleteOrgList);
        OrgRangeParam orgRangeParam = this.getOrgRangeParam(deleteOrgList, null, null);
        this.saveOrgRange(orgRangeParam);
        this.refreshList();
    }
}

