/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IOwnerPermExcept;
import com.kingdee.eas.base.permission.OrgRangeIncludeSubOrgFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.OwnerPermExceptCollection;
import com.kingdee.eas.base.permission.OwnerPermExceptFactory;
import com.kingdee.eas.base.permission.OwnerPermExceptInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractOwnerPermExcepListUI;
import com.kingdee.eas.base.permission.client.UserPromptBox;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.base.permission.client.util.UIUtil;
import com.kingdee.eas.base.permission.util.IObjectCol2Map;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.SpecialDataF7PromptDialog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class OwnerPermExcepListUI
extends AbstractOwnerPermExcepListUI {
    private static final Logger logger = CoreUIObject.getLogger(OwnerPermExcepListUI.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private IOwnerPermExcept iOwnerPermExcpt = null;
    private List objTypeList = null;
    private Set curSelectUserSet = new HashSet();
    public static final String OBJTYPE_LIST = "ObjTypeList";
    public static final String CU_ID = "cu_id";
    private static final String CUID = "CU1.id";
    private String cuId = null;
    private Set<String> managedOrgids;

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        if (this.iOwnerPermExcpt == null) {
            this.iOwnerPermExcpt = OwnerPermExceptFactory.getRemoteInstance();
        }
        return this.iOwnerPermExcpt;
    }

    private IOwnerPermExcept getBizIntefaceMy() throws Exception {
        return (IOwnerPermExcept)this.getBizInterface();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    private void initOriList() {
        OwnerPermExceptCollection ownerPermCol = null;
        try {
            ownerPermCol = this.getBizIntefaceMy().getOwnerPermExceptionCol(this.objTypeList, (IObjectPK)new ObjectStringPK(this.cuId));
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIException(e);
        }
        if (ownerPermCol == null || ownerPermCol.isEmpty()) {
            return;
        }
        Map userIdMap = ToolUtils.transCol2ListByPeroperty((IObjectCollection)ownerPermCol, new IObjectCol2Map(){

            @Override
            public String getKey(Object obj) {
                OwnerPermExceptInfo ownerPermInfo;
                if (obj instanceof OwnerPermExceptInfo && (ownerPermInfo = (OwnerPermExceptInfo)obj).getUser() != null && ownerPermInfo.getUser().getId() != null) {
                    return ownerPermInfo.getUser().getId().toString();
                }
                return null;
            }

            @Override
            public Object getList(Object obj) {
                return obj;
            }
        });
        if (userIdMap == null || userIdMap.isEmpty()) {
            return;
        }
        this.curSelectUserSet.addAll(userIdMap.keySet());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.addToMultiOrg.setIcon(EASResource.getIcon((String)"imgTbtn_allotmultipopedom"));
        this.addToMultiOrg.setEnabled(true);
        this.delFromMultiOrg.setIcon(EASResource.getIcon((String)"imgTbtn_deletemultipopedom"));
        this.delFromMultiOrg.setEnabled(true);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        this.objTypeList = (List)this.getUIContext().get(OBJTYPE_LIST);
        this.cuId = this.getUIContext().get(CU_ID).toString();
        if (this.objTypeList == null || this.objTypeList.isEmpty()) {
            throw new IllegalArgumentException("objTypeList is null!");
        }
        FilterInfo filterInfo = new FilterInfo();
        if (this.curSelectUserSet == null || this.curSelectUserSet.isEmpty()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("CU1.ID", (Object)this.cuId));
            filterInfo.getFilterItems().add(new FilterItemInfo("objType", (Object)ToolUtils.trans2Set(this.objTypeList), CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("SpecialDataPerm.CU.ID", (Object)this.cuId));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("user.id", (Object)ToolUtils.aryToStr(ToolUtils.trans2List(this.curSelectUserSet), false), CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("objType", (Object)ToolUtils.trans2Set(this.objTypeList), CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("CU1.ID", (Object)this.cuId));
            filterInfo.getFilterItems().add(new FilterItemInfo("SpecialDataPerm.CU.ID", (Object)this.cuId));
        }
        return filterInfo;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
        this.initOriList();
        this.initManagedCu();
        this.initTable();
        this.execQuery();
    }

    private void initUI() {
        this.btnAddNewUser.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelUser.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnSaveUser.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSaveUser.setVisible(false);
        this.btnQuery.setEnabled(true);
    }

    @Override
    public void actionAddUser_actionPerformed(ActionEvent e) throws Exception {
        KDCommonPromptDialog dlg = this.getUserDialog();
        dlg.show();
        if (!dlg.isCanceled()) {
            Object obj = dlg.getData();
            if (obj != null && obj instanceof Object[]) {
                Object[] userInfoAry = (Object[])obj;
                ArrayList<String> addNewUserList = new ArrayList<String>();
                for (int i = 0; i < userInfoAry.length; ++i) {
                    UserInfo userInfo = (UserInfo)userInfoAry[i];
                    if (userInfo == null || userInfo.getId() == null) continue;
                    addNewUserList.add(userInfo.getId().toString());
                    this.curSelectUserSet.add(userInfo.getId().toString());
                }
                this.iOwnerPermExcpt.saveUser(this.objTypeList, addNewUserList, (IObjectPK)new ObjectStringPK(this.cuId));
            }
            this.initOriList();
            this.execQuery();
        }
    }

    private KDCommonPromptDialog getUserDialog() {
        UserPromptBox dlg = null;
        IUIWindow win = this.getUIWindow();
        if (win instanceof Frame) {
            dlg = new UserPromptBox((Frame)this.getUIWindow());
        } else if (win instanceof Dialog) {
            dlg = new UserPromptBox((Dialog)this.getUIWindow());
        }
        dlg.setEnabledMultiSelection(true);
        IMetaDataLoader metaDataLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.base.permission.app.UserGroupListQuery2");
        dlg.setQueryInfo(queryPK);
        this.setMaySelectUserFilter(dlg);
        dlg.setHasCUDefaultFilter(false);
        return dlg;
    }

    @Override
    public void actionDelUser_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        IObjectPK[] pks = new IObjectPK[idList.size()];
        for (int i = 0; i < idList.size(); ++i) {
            pks[i] = new ObjectUuidPK(idList.get(i).toString());
            this.curSelectUserSet.remove(idList.get(i).toString());
        }
        UIUtil.removeRow(this.tblMain);
        this.iOwnerPermExcpt.delete(pks);
        this.tblMain.refresh();
    }

    private void setMaySelectUserFilter(KDCommonPromptDialog dlg) {
        List alreadySelectUserList = UITools.getUserIdList(this.tblMain, 1);
        FilterInfo filterInfo = null;
        if (alreadySelectUserList != null && !alreadySelectUserList.isEmpty()) {
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ToolUtils.aryToStr(alreadySelectUserList, false), CompareType.NOTINCLUDE));
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        dlg.setEntityViewInfo(entityViewInfo);
    }

    @Override
    public void actionSaveUser_actionPerformed(ActionEvent e) throws Exception {
        this.iOwnerPermExcpt.saveUser(this.objTypeList, ToolUtils.trans2List(this.curSelectUserSet), (IObjectPK)new ObjectStringPK(this.cuId));
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"saveSuccessed"));
    }

    private List getSelectedOrgList() throws EASBizException, BOSException {
        ArrayList<String> selectOrgList = new ArrayList<String>();
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        SpecialDataF7PromptDialog orgF7 = new SpecialDataF7PromptDialog((IUIObject)this, userInfo, true);
        orgF7.setIsCUFilter(true);
        orgF7.show();
        if (!orgF7.isCanceled()) {
            Object obj = orgF7.getData();
            OrgUnitInfo[] orgUnitInfoAry = (OrgUnitInfo[])obj;
            for (int i = 0; i < orgUnitInfoAry.length; ++i) {
                selectOrgList.add(orgUnitInfoAry[i].getId().toString());
            }
        }
        return selectOrgList;
    }

    @Override
    public void actionAddToMultiOrg_actionPerformed(ActionEvent e) throws Exception {
        List orgList = this.getSelectedOrgList();
        if (orgList == null || orgList.size() == 0) {
            return;
        }
        ArrayList ownerPermExceptList = this.getSelectedIdValues();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ToolUtils.trans2Set(ownerPermExceptList), CompareType.INCLUDE));
        view.setFilter(filter);
        OwnerPermExceptCollection ownerPermExceptCollection = this.iOwnerPermExcpt.getOwnerPermExceptCollection(view);
        this.iOwnerPermExcpt.addToMultiOrg(orgList, ownerPermExceptCollection);
        MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"MULTI_ORG_ADD_COMPLETE"));
    }

    @Override
    public void actionDelFromMultiOrg_actionPerformed(ActionEvent e) throws Exception {
        List orgList = this.getSelectedOrgList();
        if (orgList == null || orgList.size() == 0) {
            return;
        }
        ArrayList ownerPermExceptList = this.getSelectedIdValues();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ToolUtils.trans2Set(ownerPermExceptList), CompareType.INCLUDE));
        view.setFilter(filter);
        OwnerPermExceptCollection ownerPermExceptCollection = this.iOwnerPermExcpt.getOwnerPermExceptCollection(view);
        this.iOwnerPermExcpt.delFromMultiOrg(orgList, ownerPermExceptCollection);
        MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"MULTI_ORG_DELETE_COMPLETE"));
    }

    private void initManagedCu() throws Exception {
        ObjectUuidPK userPk = new ObjectUuidPK(this.getCurrentUser().getId());
        this.managedOrgids = OrgRangeIncludeSubOrgFactory.getRemoteInstance().getOrgIdsByUserAndTypeUsingSQL(this.getCurrentUser().getId().toString(), Administrator.isAdminType(this.getCurrentUser().getType()) ? OrgRangeType.BIZ_ORG_TYPE : OrgRangeType.MANAGE_ORG_TYPE);
    }

    private UserInfo getCurrentUser() {
        return SysContext.getSysContext().getCurrentUserInfo();
    }

    private void initTable() {
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int start = e.getFirstRow();
                int end = e.getLastRow();
                for (int i = start; i <= end; ++i) {
                    String org = (String)OwnerPermExcepListUI.this.tblMain.getCell(i, OwnerPermExcepListUI.CUID).getValue();
                    if (OwnerPermExcepListUI.this.managedOrgids.contains(org)) continue;
                    OwnerPermExcepListUI.this.tblMain.getRow(i).getStyleAttributes().setBackground(new Color(227, 227, 227));
                    OwnerPermExcepListUI.this.tblMain.getRow(i).getStyleAttributes().setLocked(true);
                }
            }
        });
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                int start = e.getSelectBlock().getBeginRow();
                int end = e.getSelectBlock().getEndRow();
                for (int i = start; i <= end; ++i) {
                    String orgid = (String)OwnerPermExcepListUI.this.tblMain.getRow(i).getCell(OwnerPermExcepListUI.CUID).getValue();
                    if (!OwnerPermExcepListUI.this.managedOrgids.contains(orgid)) continue;
                    OwnerPermExcepListUI.this.btnDelUser.setEnabled(true);
                    return;
                }
                OwnerPermExcepListUI.this.btnDelUser.setEnabled(false);
            }
        });
    }
}

