/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IPermission3DViewFacade;
import com.kingdee.eas.base.permission.IUserRoleOrgManager;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.Permission3DTypeEnum;
import com.kingdee.eas.base.permission.Permission3DViewFacadeFactory;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.RolePermInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserOrgPermInfo;
import com.kingdee.eas.base.permission.UserRoleOrgInfo;
import com.kingdee.eas.base.permission.UserRoleOrgManagerFactory;
import com.kingdee.eas.base.permission.UserUtils;
import com.kingdee.eas.base.permission.client.AbstractPermission3DViewUI;
import com.kingdee.eas.base.permission.client.ExclusivePermissionListUI;
import com.kingdee.eas.base.permission.client.IPermission3DViewUI;
import com.kingdee.eas.base.permission.client.OrgUser3DViewUI;
import com.kingdee.eas.base.permission.client.PermissionRole3DViewUI;
import com.kingdee.eas.base.permission.client.PermissionUser3DViewUI;
import com.kingdee.eas.base.permission.client.RolePermission3DViewUI;
import com.kingdee.eas.base.permission.client.RoleUser3DViewUI;
import com.kingdee.eas.base.permission.client.SensitivePermissionListUI;
import com.kingdee.eas.base.permission.client.UserOrg3DViewUI;
import com.kingdee.eas.base.permission.client.UserOrgRolePermUI;
import com.kingdee.eas.base.permission.client.UserRole3DViewUI;
import com.kingdee.eas.base.permission.util.CacheUtil;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class Permission3DViewUI
extends AbstractPermission3DViewUI
implements IPermission3DViewUI {
    private static final Logger logger = CoreUIObject.getLogger(Permission3DViewUI.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    int MAX_ROW_TO_EXPORT = 50000;
    Permission3DTypeEnum currentType = null;
    private boolean isRefresh = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initButton();
        if (this.currentType == null) {
            this.currentType = Permission3DTypeEnum.UserPermission;
        }
        this.cbPermission3DType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Permission3DViewUI.this.cbPermission3DType_itemStateChanged(e);
            }
        });
        this.setDoRequestData(false);
        this.tblMain.getDataRequestManager().setExportMemoryCallback(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                MsgBox.showInfo((String)EASResource.getString((String)Permission3DViewUI.RESOURCE, (String)"DATA_TOO_LARGE"));
            }
        }).start();
    }

    protected void execQuery() {
        if (this.getCurrentSolutionInfo() != null) {
            this.setDoRequestData(true);
        }
        super.execQuery();
    }

    private void initButton() {
        this.btnView.setVisible(false);
        this.btnAddNew.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnRemove.setVisible(false);
        this.menuItemAddNew.setVisible(false);
        this.menuItemEdit.setVisible(false);
        this.menuItemRemove.setVisible(false);
        this.menuItemView.setVisible(false);
        this.tHelper.getDisabledTables().add(this.tblMain);
        this.btnBatchDelete.setEnabled(true);
        BOSUuid userId = SysContext.getSysContext().getCurrentUserInfo().getId();
        if (!Administrator.isSuperCUAdmin((IObjectPK)new ObjectUuidPK(userId))) {
            this.btnSetExclusivePerm.setVisible(false);
            this.btnSetSensitivePerm.setVisible(false);
        }
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected String getKeyFieldName() {
        if (this.getTypeUI(this.currentType) != null) {
            return ((IPermission3DViewUI)this.getTypeUI(this.currentType)).getPrimaryKey();
        }
        return "id";
    }

    @Override
    public String getPrimaryKey() {
        return "id";
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected void cbPermission3DType_itemStateChanged(ActionEvent e) {
        this.currentType = (Permission3DTypeEnum)((Object)this.cbPermission3DType.getSelectedItem());
        try {
            this.showBatchDeleteButton(this.currentType);
            this.switchToType(this.currentType);
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
    }

    private void showUserRolePermUI() throws UIException {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"openModel", (Object)"frame");
        IUIWindow ui = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(UserOrgRolePermUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        ui.show();
    }

    private void switchToType(Permission3DTypeEnum type) throws Exception {
        if (Permission3DTypeEnum.userRoleperm.equals((Object)type)) {
            this.btnQuery.setEnabled(false);
            this.btnRefresh.setEnabled(false);
            KDTable currentTable = new UserOrgRolePermUI().tblMain;
            currentTable.checkParsed(true);
            this.tblMain.removeColumns();
            this.tblMain.setFormatXml(currentTable.getFormatXml());
            this.clearCommonQueryDialog();
            this.setCfgFormatXml(currentTable.getFormatXml());
            this.showUserRolePermUI();
            return;
        }
        this.btnQuery.setEnabled(true);
        this.btnRefresh.setEnabled(true);
        ListUI orgTypeUI = this.getTypeUI(type);
        KDTable currentTable = orgTypeUI.getMainTable();
        currentTable.checkParsed(true);
        this.tblMain.removeColumns();
        this.tblMain.setFormatXml(currentTable.getFormatXml());
        this.mainQueryPK = orgTypeUI.getMainQueryPK();
        this.clearCommonQueryDialog();
        this.setCfgFormatXml(currentTable.getFormatXml());
        this.mainQuery.setFilter(((IPermission3DViewUI)orgTypeUI).getDefaultFilter());
        this.mainQuery.setSorter(((IPermission3DViewUI)orgTypeUI).getDefaultSorter());
        this.tblMain.putBindContents("mainQuery", ((IPermission3DViewUI)orgTypeUI).getFields());
        this.tblMain.checkParsed(true);
        this.tblMain.removeRows(false);
    }

    private ListUI getTypeUI(Permission3DTypeEnum type) {
        try {
            if (!Permission3DTypeEnum.userRoleperm.equals((Object)type)) {
                if (Permission3DTypeEnum.PermissionUser.equals((Object)type)) {
                    return new PermissionUser3DViewUI();
                }
                if (Permission3DTypeEnum.UserRole.equals((Object)type)) {
                    return new UserRole3DViewUI();
                }
                if (Permission3DTypeEnum.RoleUser.equals((Object)type)) {
                    return new RoleUser3DViewUI();
                }
                if (Permission3DTypeEnum.RolePermission.equals((Object)type)) {
                    return new RolePermission3DViewUI();
                }
                if (Permission3DTypeEnum.PermissionRole.equals((Object)type)) {
                    return new PermissionRole3DViewUI();
                }
                if (Permission3DTypeEnum.UserOrg.equals((Object)type)) {
                    return new UserOrg3DViewUI();
                }
                if (Permission3DTypeEnum.OrgUser.equals((Object)type)) {
                    return new OrgUser3DViewUI();
                }
                return new Permission3DViewUI();
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            this.handleException(e);
        }
        return null;
    }

    @Override
    public FilterInfo getDefaultFilter() {
        FilterInfo info = new FilterInfo();
        try {
            if (SysContext.getSysContext().getCurrentUserInfo().isBizAdmin()) {
                StringBuffer bf = new StringBuffer();
                bf.append("(exists (SELECT 1 FROM t_PM_OrgRange range where  range.FTYPE = 30 and range.FUSERID = '" + SysContext.getSysContext().getCurrentUserInfo().getId().toString() + "' and  ORG.FCONTROLUNITID = range.forgid )");
                bf.append(" and exists (SELECT 1 from t_pm_userorgperm op where op.FPERMITEMID = PERMITEM.fid and  op.FPERMTYPE = 30 and op.FOWNER =  '" + SysContext.getSysContext().getCurrentUserInfo().getId().toString() + "' ))");
                info = new FilterInfo(bf.toString());
            }
            UserInfo currentUser = CacheUtil.getCacheUserInfo(null, SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            info.mergeFilter(UserUtils.getUserFilter(currentUser, "owner"), "and");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return info;
    }

    @Override
    public String[] getFields() {
        return new String[]{"id", "owner.number", "owner.name", "group.number", "group.name", "org.number", "org.displayName", "permItem.number", "permItem.name", "permItem.longNumber", "permItem.alias", "permType", "org.id", "permItem.id", "owner.id"};
    }

    @Override
    public SorterItemCollection getDefaultSorter() {
        SorterItemCollection sorterCol = new SorterItemCollection();
        sorterCol.add(new SorterItemInfo("owner.number"));
        sorterCol.add(new SorterItemInfo("org.number"));
        sorterCol.add(new SorterItemInfo("org.displayName"));
        sorterCol.add(new SorterItemInfo("permType"));
        return sorterCol;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return ((IPermission3DViewUI)this.getTypeUI(this.currentType)).getDefaultFilter();
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        super.beforeExcutQuery(ev);
        SorterItemCollection sorterCol = ((IPermission3DViewUI)this.getTypeUI(this.currentType)).getDefaultSorter();
        if (ev.getSorter() == null || ev.getSorter().size() == 0) {
            ev.setSorter(sorterCol);
        }
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() > this.MAX_ROW_TO_EXPORT) {
            String msg = EASResource.getString((String)RESOURCE, (String)"RODATA_TOO_MUCH");
            MsgBox.showWarning((String)MessageFormat.format(msg, String.valueOf(this.MAX_ROW_TO_EXPORT)));
            SysUtil.abort();
        }
        super.actionExport_actionPerformed(e);
    }

    protected String[] getLocateNames() {
        return ((IPermission3DViewUI)this.getTypeUI(this.currentType)).getLocateProperties();
    }

    @Override
    public String[] getLocateProperties() {
        return new String[]{"owner.number", "owner.name", "group.number", "group.name", "org.number", "org.displayName", "permItem.number", "permItem.name"};
    }

    protected boolean isOrderPre() {
        return false;
    }

    @Override
    public void actionViewUserOrgRolePerm_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"openModel", (Object)"frame");
        IUIWindow ui = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(UserOrgRolePermUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        ui.show();
    }

    @Override
    public void actionBatchDelete_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        List<Object> batchDeletePerms = this.getBatchDeletePerms();
        this.batchDelete(batchDeletePerms);
        if (this.isRefresh) {
            this.refresh(e);
        }
    }

    private void batchDelete(List<Object> batchDeletePerms) throws BOSException, EASBizException {
        if (batchDeletePerms == null || batchDeletePerms.isEmpty()) {
            return;
        }
        List nocancelperms = new ArrayList();
        IPermission3DViewFacade permission3DViewFacade = Permission3DViewFacadeFactory.getRemoteInstance();
        IUserRoleOrgManager iUserRoleOrgManager = UserRoleOrgManagerFactory.getRemoteInstance();
        if (Permission3DTypeEnum.UserPermission.equals((Object)this.currentType) || Permission3DTypeEnum.PermissionUser.equals((Object)this.currentType)) {
            nocancelperms = permission3DViewFacade.batchCancelUserOrgPerms(batchDeletePerms);
        } else if (Permission3DTypeEnum.RoleUser.equals((Object)this.currentType) || Permission3DTypeEnum.UserRole.equals((Object)this.currentType)) {
            iUserRoleOrgManager.removeUserOrgRole(batchDeletePerms);
        } else if (Permission3DTypeEnum.RolePermission.equals((Object)this.currentType) || Permission3DTypeEnum.PermissionRole.equals((Object)this.currentType)) {
            nocancelperms = permission3DViewFacade.batchCancleRolePerms(batchDeletePerms);
        }
        if (nocancelperms == null || nocancelperms.isEmpty() || "".equals(nocancelperms.get(0))) {
            this.isRefresh = true;
            String msg = EASResource.getString((String)RESOURCE, (String)"batchPermsDeleteOkMsg");
            MsgBox.showInfo((String)msg);
            return;
        }
        this.isRefresh = false;
        if (Permission3DTypeEnum.UserPermission.equals((Object)this.currentType) || Permission3DTypeEnum.PermissionUser.equals((Object)this.currentType)) {
            String msg = "\u90e8\u5206\u6743\u9650\u672a\u5220\u9664\u6210\u529f\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u8d85\u51fa\u5f53\u524d\u6388\u6743\u6743\u7528\u6237\u7684\u7ba1\u8f96\u548c\u53ef\u8f6c\u6388\u8303\u56f4\uff01\n\u672a\u5220\u9664\u6743\u9650\u8bb0\u5f55\u5982\u4e0b\uff1a\n{0}";
            MsgBox.showWarning((String)MessageFormat.format(msg, nocancelperms.get(0).toString()));
        } else if (Permission3DTypeEnum.RolePermission.equals((Object)this.currentType) || Permission3DTypeEnum.PermissionRole.equals((Object)this.currentType)) {
            String msg = EASResource.getString((String)RESOURCE, (String)"batchRolePermsDeleteMsg");
            MsgBox.showWarning((String)MessageFormat.format(msg, nocancelperms.get(0).toString(), nocancelperms.get(1).toString(), nocancelperms.get(2).toString()));
        } else {
            String msg = EASResource.getString((String)RESOURCE, (String)"batchRolesDeleteMsg");
            MsgBox.showWarning((String)MessageFormat.format(msg, nocancelperms.get(0).toString(), nocancelperms.get(1).toString()));
        }
    }

    private List<Object> getBatchDeletePerms() {
        int[] rowID = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        ArrayList<Object> deletePermsList = new ArrayList<Object>();
        UserOrgPermInfo userPermOrgInfo = null;
        RolePermInfo rolePermInfo = null;
        UserRoleOrgInfo userRoleOrgInfo = null;
        FullOrgUnitInfo orgInfo = null;
        UserInfo userInfo = null;
        PermItemInfo permItemInfo = null;
        RoleInfo roleInfo = null;
        IRow row = null;
        for (int i = 0; i < rowID.length; ++i) {
            row = this.tblMain.getRow(rowID[i]);
            if (Permission3DTypeEnum.UserPermission.equals((Object)this.currentType) || Permission3DTypeEnum.PermissionUser.equals((Object)this.currentType)) {
                userPermOrgInfo = new UserOrgPermInfo();
                orgInfo = new FullOrgUnitInfo();
                permItemInfo = new PermItemInfo();
                userInfo = new UserInfo();
                orgInfo.setId(BOSUuid.read((String)row.getCell("org.id").getValue().toString()));
                orgInfo.setDisplayName(row.getCell("org.displayName").getValue().toString());
                permItemInfo.setId(BOSUuid.read((String)row.getCell("permItem.id").getValue().toString()));
                permItemInfo.setAlias(row.getCell("permItem.alias").getValue().toString());
                userInfo.setId(BOSUuid.read((String)row.getCell("owner.id").getValue().toString()));
                userInfo.setNumber(row.getCell("owner.number").getValue().toString());
                userPermOrgInfo.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
                userPermOrgInfo.setOrg(orgInfo);
                userPermOrgInfo.setPermItem(permItemInfo);
                userPermOrgInfo.setOwner(userInfo);
                deletePermsList.add(userPermOrgInfo);
                continue;
            }
            if (Permission3DTypeEnum.RolePermission.equals((Object)this.currentType) || Permission3DTypeEnum.PermissionRole.equals((Object)this.currentType)) {
                rolePermInfo = new RolePermInfo();
                roleInfo = new RoleInfo();
                permItemInfo = new PermItemInfo();
                roleInfo.setId(BOSUuid.read((String)row.getCell("role.id").getValue().toString()));
                roleInfo.setName(row.getCell("role.name").getValue().toString());
                permItemInfo.setId(BOSUuid.read((String)row.getCell("permItem.id").getValue().toString()));
                permItemInfo.setAlias(row.getCell("permItem.alias").getValue().toString());
                rolePermInfo.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
                rolePermInfo.setRole(roleInfo);
                rolePermInfo.setPermItem(permItemInfo);
                deletePermsList.add(rolePermInfo);
                continue;
            }
            if (!Permission3DTypeEnum.RoleUser.equals((Object)this.currentType) && !Permission3DTypeEnum.UserRole.equals((Object)this.currentType)) continue;
            userRoleOrgInfo = new UserRoleOrgInfo();
            userInfo = new UserInfo();
            orgInfo = new FullOrgUnitInfo();
            roleInfo = new RoleInfo();
            userInfo.setId(BOSUuid.read((String)row.getCell("userId.id").getValue().toString()));
            orgInfo.setId(BOSUuid.read((String)row.getCell("orgId.id").getValue().toString()));
            orgInfo.setName(row.getCell("orgId.name").getValue().toString());
            roleInfo.setId(BOSUuid.read((String)row.getCell("roleId.id").getValue().toString()));
            roleInfo.setName(row.getCell("roleId.name").getValue().toString());
            userRoleOrgInfo.setUser(userInfo);
            userRoleOrgInfo.setOrg(orgInfo);
            userRoleOrgInfo.setRole(roleInfo);
            deletePermsList.add(userRoleOrgInfo);
        }
        return deletePermsList;
    }

    private void showBatchDeleteButton(Permission3DTypeEnum currentType) {
        if (Permission3DTypeEnum.userRoleperm.equals((Object)currentType) || Permission3DTypeEnum.UserOrg.equals((Object)currentType) || Permission3DTypeEnum.OrgUser.equals((Object)currentType)) {
            this.btnBatchDelete.setEnabled(false);
        } else {
            this.btnBatchDelete.setEnabled(true);
        }
    }

    @Override
    public void actionSetSensitivePerm_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        try {
            IUIWindow iWin = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SensitivePermissionListUI.class.getName(), (Map)uiContext, null);
            iWin.show();
        }
        catch (UIException e1) {
            logger.error((Object)"", (Throwable)e1);
            this.handleException((Exception)((Object)e1));
        }
    }

    @Override
    public void actionSetExclusivePerm_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        try {
            IUIWindow iWin = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ExclusivePermissionListUI.class.getName(), (Map)uiContext, null);
            iWin.show();
        }
        catch (UIException e1) {
            logger.error((Object)"", (Throwable)e1);
            this.handleException((Exception)((Object)e1));
        }
    }
}

