/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectMultiPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IRole;
import com.kingdee.eas.base.permission.IRoleGroup;
import com.kingdee.eas.base.permission.RoleCollection;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.RoleGroupFactory;
import com.kingdee.eas.base.permission.RoleGroupInfo;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractRoleListUI;
import com.kingdee.eas.base.permission.client.RoleAccreditUI;
import com.kingdee.eas.base.permission.client.RoleAssignUserUI;
import com.kingdee.eas.base.permission.client.RoleEditUI;
import com.kingdee.eas.base.permission.client.RoleGroupEditUI;
import com.kingdee.eas.base.permission.client.RolePermViewUI;
import com.kingdee.eas.base.permission.client.RoleSaveAsUI;
import com.kingdee.eas.base.permission.client.helper.UserRoleAssignHelper;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.base.permission.service.OrgRangeService;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RoleListUI
extends AbstractRoleListUI {
    private Logger logger = Logger.getLogger((String)RoleListUI.class.getName());
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private static final String NAME_INDEX = "name";
    private static final String ROLE_INDEX = "number";
    private static final String CTRL_INDEX = "CU.id";
    private static final String IS_DEF_ROLE = "isDefRole";
    QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    public boolean isPrepareActionEdit() {
        return true;
    }

    public boolean isPrepareActionAddNew() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return false;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAccredit.setIcon(EASResource.getIcon((String)"imgTbtn_popedomsetting"));
        this.btnAssignUser.setIcon(EASResource.getIcon((String)"imgTbtn_distributeuser"));
        this.btnViewRolePerm.setIcon(EASResource.getIcon((String)"imgTbtn_userview"));
        this.miAssignUser.setIcon(EASResource.getIcon((String)"imgTbtn_distributeuser"));
        this.miAccredit.setIcon(EASResource.getIcon((String)"imgTbtn_popedomsetting"));
        this.miViewRolePerm.setIcon(EASResource.getIcon((String)"imgTbtn_userview"));
        this.btnDefRole.setIcon(EASResource.getIcon((String)"imgTbtn_addmapping"));
        this.btnUnDefRole.setIcon(EASResource.getIcon((String)"imgTbtn_deletemapping"));
    }

    private void setToolbarStatus() throws EASBizException, BOSException {
        boolean isCUAdmin = Administrator.isCUAdmin(null, this.getCurrentUserPK());
        boolean isBizAdmin = Administrator.isBizAdmin(null, this.getCurrentUserPK());
        boolean isAdmin = Administrator.isSuperCUAdmin(this.getCurrentUserPK());
        this.actionAccredit.setEnabled(isCUAdmin || isBizAdmin);
        this.actionAccredit.setVisible(isCUAdmin || isBizAdmin);
        this.actionAssignUser.setEnabled(isCUAdmin || isBizAdmin);
        this.actionDefRole.setEnabled(isAdmin);
        this.actionUnDefRole.setEnabled(isAdmin);
        this.menuImPort.setVisible(!isBizAdmin);
        this.actionDefRole.setVisible(isAdmin);
        this.actionUnDefRole.setVisible(isAdmin);
    }

    private IObjectPK getCurrentUserPK() {
        return new ObjectUuidPK(this.getCurrentUser().getId());
    }

    private UserInfo getCurrentUser() {
        return SysContext.getSysContext().getCurrentUserInfo();
    }

    @Override
    public boolean isPrepareInit() {
        return false;
    }

    @Override
    public IUIActionPostman prepareInit() {
        SysContext.getSysContext().getCurrentUserInfo();
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.put("userinfoid", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    public void onLoad() throws Exception {
        if ("11111111-1111-1111-1111-111111111111CCE7AED4".equals(this.getCurrentCUPK().toString())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"canBeUsedInSysCU"));
            this.abort();
        }
        super.onLoad();
        this.setToolbarStatus();
    }

    public ICoreBase getBizInterface() throws Exception {
        return RoleFactory.getRemoteInstance();
    }

    public String getEditUIName() {
        return RoleEditUI.class.getName();
    }

    private IObjectPK getCurrentCUPK() {
        return new ObjectUuidPK(this.getCurrentCU().getId());
    }

    @Override
    public boolean isPrepareActionAccredit() {
        return true;
    }

    @Override
    public RequestContext prepareActionAccredit(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionAccredit(itemAction);
        request.setMethodName("_handleActionAccredit");
        return request;
    }

    @Override
    public void actionAccredit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex < 0) {
            return;
        }
        String cuID = this.tblMain.getRow(rowIndex).getCell(CTRL_INDEX).getValue().toString();
        if (!OrgRangeService.inCUOrgRange(null, ToolUtils.getCurrentUserPK(), cuID)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"canNotModifyOtherCUData"));
            this.abort();
        }
        super.actionAccredit_actionPerformed(e);
        this.checkSelected();
        LongTimeDialog dialog = UITools.getDialog((Component)((Object)this));
        dialog.setLongTimeTask(new ILongTimeTask(){

            @Override
            public Object exec() throws Exception {
                UIContext uiContext = new UIContext((Object)RoleListUI.this);
                uiContext.put((Object)"targetID", (Object)RoleListUI.this.getSelectedKeyValue());
                uiContext.put((Object)RoleListUI.NAME_INDEX, (Object)RoleListUI.this.getSelectedRoleName());
                uiContext.put((Object)RoleListUI.ROLE_INDEX, (Object)RoleListUI.this.getSelectedRoleNumber());
                uiContext.put((Object)"openModel", (Object)"frame");
                return UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(RoleAccreditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
            }

            @Override
            public void afterExec(Object result) throws Exception {
                UITools.showObject(result);
            }
        });
        dialog.show();
    }

    private String getSelectedRoleNumber() {
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        Object object = this.tblMain.getRow(rowIndex).getCell(ROLE_INDEX).getValue();
        return object == null ? "" : object.toString();
    }

    private String getSelectedRoleName() {
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        Object object = this.tblMain.getRow(rowIndex).getCell(NAME_INDEX).getValue();
        return object == null ? "" : object.toString();
    }

    private String getSelectedRoleCreatorID() {
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        Object object = this.tblMain.getRow(rowIndex).getCell("creator.id").getValue();
        return object == null ? "" : object.toString();
    }

    private boolean getSelectedRoleIsDefaultRole() {
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        boolean object = (Boolean)this.tblMain.getRow(rowIndex).getCell(IS_DEF_ROLE).getValue();
        return object;
    }

    @Override
    public boolean isPrepareActionAssignUser() {
        return true;
    }

    @Override
    public RequestContext prepareActionAssignUser(IItemAction itemAction) throws Exception {
        RequestContext request = new RequestContext();
        ObjectMultiPK pk = new ObjectMultiPK();
        pk.setKeyValue("user", (Object)SysContext.getSysContext().getCurrentUserInfo().getId());
        pk.setKeyValue("uiClassName", (Object)RoleAssignUserUI.class.getName());
        request.put("pk", (Object)pk);
        if (request != null) {
            request.setClassName(this.getUIHandlerClassName());
        }
        return request;
    }

    @Override
    public void actionAssignUser_actionPerformed(ActionEvent e) throws Exception {
        super.actionAssignUser_actionPerformed(e);
        this.checkSelected();
        LongTimeDialog dialog = UITools.getDialog((Component)((Object)this));
        dialog.setLongTimeTask(new ILongTimeTask(){

            @Override
            public Object exec() throws Exception {
                String roleID = RoleListUI.this.getSelectedKeyValue();
                UIContext uiContext = new UIContext((Object)RoleListUI.this);
                uiContext.put((Object)"targetID", (Object)roleID);
                uiContext.put((Object)RoleListUI.NAME_INDEX, (Object)RoleListUI.this.getSelectedRoleName());
                uiContext.put((Object)RoleListUI.ROLE_INDEX, (Object)RoleListUI.this.getSelectedRoleNumber());
                uiContext.put((Object)"creatorID", (Object)RoleListUI.this.getSelectedRoleCreatorID());
                uiContext.put((Object)"openModel", (Object)"frame");
                return UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(RoleAssignUserUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
            }

            @Override
            public void afterExec(Object result) throws Exception {
                UITools.showObject(result);
            }
        });
        dialog.show();
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        dialog.setShowSorter(false);
        return dialog;
    }

    private CtrlUnitInfo getCurrentCU() {
        return SysContext.getSysContext().getCurrentCtrlUnit();
    }

    @Override
    public boolean isPrepareActionViewRolePerm() {
        return true;
    }

    @Override
    public RequestContext prepareActionViewRolePerm(IItemAction itemAction) throws Exception {
        RequestContext request = new RequestContext();
        if (request != null) {
            request.setClassName(this.getUIHandlerClassName());
        }
        return request;
    }

    @Override
    public void actionViewRolePerm_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewRolePerm_actionPerformed(e);
        this.checkSelected();
        LongTimeDialog dialog = UITools.getDialog((Component)((Object)this));
        dialog.setLongTimeTask(new ILongTimeTask(){

            @Override
            public Object exec() throws Exception {
                UIContext uiContext = new UIContext((Object)RoleListUI.this);
                uiContext.put((Object)"targetID", (Object)RoleListUI.this.getSelectedKeyValue());
                uiContext.put((Object)RoleListUI.NAME_INDEX, (Object)RoleListUI.this.getSelectedRoleName());
                uiContext.put((Object)"openModel", (Object)"frame");
                return UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(RolePermViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            }

            @Override
            public void afterExec(Object result) throws Exception {
                UITools.showObject(result);
            }
        });
        dialog.show();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    protected boolean isIgnoreCUFilter() {
        return false;
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.systemplatform.security.permission.rolePerm";
        param.alias = EASResource.getString((String)RESOURCE, (String)"rolePerm");
        param.datataskMode = 0;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        super.checkSelected();
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.systemplatform.security.permission.rolePerm";
        param.alias = EASResource.getString((String)RESOURCE, (String)"rolePerm");
        param.datataskMode = 1;
        param.putContextParam((Object)"mainQueryPK", (Object)new MetaDataPK("com.kingdee.eas.base.permission.app.RolePermQuery"));
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("role.id", (Object)ToolUtils.aryToStr(this.getSelectedIdValues(), false), CompareType.INCLUDE));
        entityView.setFilter(filterInfo);
        param.putContextParam((Object)"mainQuery", (Object)entityView);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        DatataskCaller dc = new DatataskCaller();
        dc.setParentComponent((Component)((Object)this));
        dc.invoke(paramList, 1);
    }

    @Override
    public void actionRoleExport_actionPerformed(ActionEvent e) throws Exception {
        super.checkSelected();
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.systemplatform.security.permission.role";
        param.alias = EASResource.getString((String)RESOURCE, (String)"role");
        param.datataskMode = 1;
        param.putContextParam((Object)"mainQueryPK", (Object)new MetaDataPK("com.kingdee.eas.base.permission.app.RoleQuery"));
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ToolUtils.aryToStr(this.getSelectedIdValues(), false), CompareType.INCLUDE));
        entityView.setFilter(filterInfo);
        param.putContextParam((Object)"mainQuery", (Object)entityView);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        DatataskCaller dc = new DatataskCaller();
        dc.setParentComponent((Component)((Object)this));
        dc.invoke(paramList, 1);
    }

    @Override
    public void actionRoleImport_actionPerformed(ActionEvent e) throws Exception {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.systemplatform.security.permission.role";
        param.alias = EASResource.getString((String)RESOURCE, (String)"role");
        param.datataskMode = 0;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        DatataskCaller dc = new DatataskCaller();
        dc.setParentComponent((Component)((Object)this));
        dc.invoke(paramList, 0);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        if (ToolUtils.getCurrentUser().isBizAdmin()) {
            return UserRoleAssignHelper.getRoleFilter4BizAdmin();
        }
        FilterInfo fInfo = new FilterInfo();
        try {
            fInfo = UserRoleAssignHelper.getCURangeFilterInfo(CTRL_INDEX);
        }
        catch (EASBizException e) {
            fInfo = new FilterInfo();
            this.logger.error((Object)e);
        }
        catch (BOSException e) {
            fInfo = new FilterInfo();
            this.logger.error((Object)e);
        }
        return fInfo;
    }

    @Override
    public void actionSaveAs_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex != -1) {
            UIContext ctx = new UIContext();
            String roleID = this.tblMain.getRow(rowIndex).getCell("id").getValue().toString();
            ctx.put((Object)"ID", (Object)roleID);
            ctx.put((Object)"targetIDs", (Object)this.getAllSelecteIDListValues());
            ctx.put((Object)"targetRoles", (Object)this.getTargetRoles(this.getAllSelecteIDListValues()));
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(RoleSaveAsUI.class.getName(), (Map)ctx, null, OprtState.EDIT);
            uiWindow.show();
            this.refreshList();
        }
    }

    private RoleCollection getTargetRoles(List roleids) {
        RoleCollection roleCol = new RoleCollection();
        try {
            for (Object id : roleids) {
                ObjectStringPK rolepk = new ObjectStringPK((String)id);
                RoleInfo roleInfo = (RoleInfo)this.getBizInterface().getValue((IObjectPK)rolepk);
                roleCol.add(roleInfo);
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return roleCol;
    }

    @Override
    public void actionDefRole_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.haveDefRole()) {
            if (this.getSelectedRoleIsDefaultRole()) {
                MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"SET_DEF_ROLE_DUP"));
                SysUtil.abort();
            }
            if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"SET_DEF_ROLE_OK_TWO"))) && !this.getSelectIsDefRole()) {
                this.setDefRole(true);
            }
        } else if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"SET_DEF_ROLE_OK_ONE")))) {
            this.setDefRole(true);
        }
        KDTableUtil.setSelectedRow((KDTable)this.tblMain, (int)0);
    }

    @Override
    public void actionUnDefRole_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.getSelectIsDefRole()) {
            if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"SET_UN_DEF_ROLE_OK_ONE")))) {
                this.setDefRole(false);
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"SET_UN_DEF_ROLE_OK_TWO"));
        }
        KDTableUtil.setSelectedRow((KDTable)this.tblMain, (int)0);
    }

    private void setDefRole(boolean isDefRole) throws Exception {
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(this.getSelectedKeyValue());
        ((IRole)this.getBizInterface()).updateDefRoleByID(idList, isDefRole);
        this.refreshList();
    }

    private boolean getSelectIsDefRole() {
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        boolean isDefRole = false;
        if (this.tblMain.getRow(rowIndex) != null && this.tblMain.getRow(rowIndex).getCell(IS_DEF_ROLE) != null) {
            isDefRole = (Boolean)this.tblMain.getRow(rowIndex).getCell(IS_DEF_ROLE).getValue();
        }
        return isDefRole;
    }

    private boolean haveDefRole() throws Exception {
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo(IS_DEF_ROLE, (Object)new Integer(1));
        filterInfo.getFilterItems().add(filterItem);
        return this.getBizInterface().exists(filterInfo);
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        this.qfsi.setMustQueryAtFirst(true);
        return this.qfsi.supportExecutionWithoutFilters();
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        RoleInfo roleInfo = null;
        ObjectUuidPK detail = new ObjectUuidPK(this.getSelectedKeyValue());
        try {
            roleInfo = (RoleInfo)this.getBizInterface().getValue((IObjectPK)detail);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (roleInfo.getGroup() == null || roleInfo.getGroup().getId() == null) {
            this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot());
            this.abort();
        }
        return new ObjectUuidPK(roleInfo.getGroup().getId());
    }

    protected String getGroupEditUIName() {
        return RoleGroupEditUI.class.getName();
    }

    protected String getQueryFieldName() {
        return "group.id";
    }

    protected String getSelectDetailTreeName() {
        return "group";
    }

    protected ITreeBase getTreeInterface() throws Exception {
        try {
            return RoleGroupFactory.getRemoteInstance();
        }
        catch (BOSException e) {
            this.handUIException(e);
            return null;
        }
    }

    protected FilterItemInfo getSingleNodeFilter(TreeBaseInfo treeNode) {
        if (treeNode == null) {
            return new FilterItemInfo(this.getQueryFieldName(), (Object)"null");
        }
        return new FilterItemInfo(this.getQueryFieldName(), (Object)treeNode.getId().toString());
    }

    protected String getRootName() {
        return EASResource.getString((String)RESOURCE, (String)"roleGroup");
    }

    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
        IRoleGroup iRoleGroup = RoleGroupFactory.getRemoteInstance();
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getSelectionPath().getLastPathComponent();
        if (treeNode.getUserObject() instanceof String) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Root_CannotSelected"));
            return;
        }
        RoleGroupInfo RoleGroupInfo2 = (RoleGroupInfo)treeNode.getUserObject();
        ArrayList<ObjectStringPK> groupList = new ArrayList<ObjectStringPK>();
        groupList.add(new ObjectStringPK(RoleGroupInfo2.getId().toString()));
        if (!RoleGroupInfo2.isIsLeaf()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_OnlyLeaf_CanDelete"));
            return;
        }
        if (iRoleGroup.isExistRecord(groupList)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"exitRoleGroupRecord"));
            return;
        }
        ArrayList<RoleGroupInfo> parentGroupList = new ArrayList<RoleGroupInfo>();
        RoleGroupInfo userGroupPInfo = RoleGroupInfo2.getParent();
        iRoleGroup.removeGroup(groupList);
        if (userGroupPInfo != null) {
            parentGroupList.add(userGroupPInfo);
            iRoleGroup.deleteLeaf(parentGroupList);
        }
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_DelVoucherSuccess"));
        this.refreshList();
    }
}

