/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.permission.IRole;
import com.kingdee.eas.base.permission.PermissionResUtil;
import com.kingdee.eas.base.permission.RoleCollection;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.RoleGroupInfo;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.client.AbstractRoleSaveAsUI;
import com.kingdee.eas.base.permission.client.RolePromptBox;
import com.kingdee.eas.base.permission.client.helper.UserRoleAssignHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class RoleSaveAsUI
extends AbstractRoleSaveAsUI {
    private static final Logger logger = CoreUIObject.getLogger(RoleSaveAsUI.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private RoleCollection targetrRoleCol;
    boolean isCheck = false;

    public void onLoad() throws Exception {
        List object = (List)this.getUIContext().get("targetIDs");
        RoleCollection targetrRoleCol = (RoleCollection)((Object)this.getUIContext().get("targetRoles"));
        this.initRoleF7(this.bizSourceAcount, true);
        this.initRoleF7(this.bizTgtAccount, false);
        this.bizSourceAcount.setData((Object)targetrRoleCol);
        super.onLoad();
    }

    private void initRoleF7(KDBizPromptBox f7, boolean isMult) {
        f7.setSelector((KDPromptSelector)this.getRoleDialog(isMult));
        f7.setEnabledMultiSelection(isMult);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(this.getDefaultFilterForQuery());
        f7.setEntityViewInfo(evi);
        f7.setCommitFormat("$number$");
        f7.setDisplayFormat("$name$");
        f7.setEditFormat("$number$");
    }

    private KDCommonPromptDialog getRoleDialog(boolean isMult) {
        HashMap<String, Boolean> param = new HashMap<String, Boolean>();
        param.put("isSingle", isMult);
        RolePromptBox dlg = new RolePromptBox((IUIObject)this.getUIWindow(), param);
        dlg.setEnabledMultiSelection(isMult);
        IMetaDataLoader metaDataLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.base.permission.app.RoleQuery");
        dlg.setQueryInfo(queryPK);
        dlg.setHasCUDefaultFilter(false);
        return dlg;
    }

    @Override
    public void actionBtnConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.verifyInput()) {
            IRole iRole = RoleFactory.getRemoteInstance();
            boolean isCopyPerm = this.kdcCopyPerm.isSelected();
            boolean isCopyUserOrg = this.kdcCopyUserOrg.isSelected();
            RoleCollection sourceRoleInfo = this.getSourceCollection();
            ObjectUuidPK rolePK = null;
            if (this.isCheck) {
                String name;
                RoleInfo role = new RoleInfo();
                role.setNumber(this.txtTgtAccount.getText());
                if (this.tagGroup.getData() != null) {
                    role.setGroup((RoleGroupInfo)this.tagGroup.getData());
                }
                if (StringUtils.isEmpty((String)(name = this.tagRoleName.getDefaultLangItemData().toString()))) {
                    name = this.tagRoleName.getItemDataByLang(new LanguageInfo(LocaleUtils.locale_L1)).toString();
                }
                role.setName(name);
                rolePK = iRole.addnew((CoreBaseInfo)role);
            } else {
                RoleInfo tgtRoleInfo = (RoleInfo)this.bizTgtAccount.getData();
                rolePK = new ObjectUuidPK(tgtRoleInfo.getId());
            }
            iRole.roleCopy((IObjectCollection)sourceRoleInfo, (IObjectPK)rolePK, isCopyPerm, isCopyUserOrg);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"saveSucceed"));
            this.getUIWindow().close();
        }
    }

    @Override
    public void actionBtnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    private boolean verifyInput() throws Exception {
        if (this.bizSourceAcount.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)PermissionResUtil.getResource("res_139"));
            return false;
        }
        if (this.isCheck) {
            if (StringUtils.isEmpty((String)this.txtTgtAccount.getText())) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"numberIsBlank"));
                return false;
            }
            if (StringUtils.isEmpty((String)this.tagRoleName.getSelectedItemData().toString())) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"nameIsBlank"));
                return false;
            }
        } else {
            RoleInfo tgtRoleInfo;
            if (this.bizTgtAccount.getData() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)PermissionResUtil.getResource("res_140"));
                return false;
            }
            RoleCollection sourceRoleInfo = this.getSourceCollection();
            if (sourceRoleInfo.contains(tgtRoleInfo = (RoleInfo)this.bizTgtAccount.getData())) {
                MsgBox.showInfo((Component)((Object)this), (String)PermissionResUtil.getResource("res_141"));
                return false;
            }
        }
        if (!this.kdcCopyPerm.isSelected() && !this.kdcCopyUserOrg.isSelected()) {
            MsgBox.showInfo((Component)((Object)this), (String)PermissionResUtil.getResource("res_110"));
            return false;
        }
        return true;
    }

    private RoleCollection getSourceCollection() {
        RoleCollection roleCol = new RoleCollection();
        Object roleObj = this.bizSourceAcount.getData();
        if (roleObj == null) {
            return (RoleCollection)((Object)this.getUIContext().get("targetRoles"));
        }
        if (roleObj instanceof RoleCollection) {
            return (RoleCollection)((Object)roleObj);
        }
        if (roleObj instanceof Object[]) {
            Object[] roleObjs;
            for (Object roleInfo : roleObjs = (Object[])roleObj) {
                if (!(roleInfo instanceof RoleInfo)) continue;
                roleCol.add((RoleInfo)roleInfo);
            }
        } else if (roleObj instanceof RoleInfo) {
            roleCol.add((RoleInfo)roleObj);
        }
        return roleCol;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        if (ToolUtils.getCurrentUser().isBizAdmin()) {
            return UserRoleAssignHelper.getRoleFilter4BizAdmin();
        }
        FilterInfo fInfo = new FilterInfo();
        try {
            fInfo = UserRoleAssignHelper.getCURangeFilterInfo("CU.id");
        }
        catch (EASBizException e) {
            fInfo = new FilterInfo();
            logger.error((Object)e);
        }
        catch (BOSException e) {
            fInfo = new FilterInfo();
            logger.error((Object)e);
        }
        return fInfo;
    }

    @Override
    protected void chkCpBasicMsg_mouseClicked(MouseEvent e) throws Exception {
        this.updateUIByCheck(this.chkCpBasicMsg.isSelected());
    }

    private void updateUIByCheck(boolean isAddUser) {
        if (isAddUser) {
            this.checkedAddRole();
        } else {
            this.uncheckAddRole();
        }
    }

    private void checkedAddRole() {
        this.bizTgtAccount.setVisible(false);
        this.kDLabelContainer2.setBoundEditor((JComponent)this.txtTgtAccount);
        this.txtTgtAccount.setVisible(true);
        this.txtTgtAccount.setRequired(true);
        this.bizTgtAccount.setRequired(false);
        this.tagRoleName.setEnabled(true);
        this.tagGroup.setEnabled(true);
        this.isCheck = true;
    }

    private void uncheckAddRole() {
        this.txtTgtAccount.setVisible(false);
        this.bizTgtAccount.setVisible(true);
        this.bizTgtAccount.setRequired(true);
        this.txtTgtAccount.setRequired(false);
        this.kDLabelContainer2.setBoundEditor((JComponent)this.bizTgtAccount);
        this.kDLabelContainer2.validate();
        this.tagRoleName.setEnabled(false);
        this.tagGroup.setEnabled(false);
        this.isCheck = false;
    }
}

