/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.LogicSignEnum;
import com.kingdee.eas.base.commonquery.client.CommonEntityFilterPanel;
import com.kingdee.eas.base.commonquery.client.CommonEntityProcessor;
import com.kingdee.eas.base.commonquery.client.DataObject;
import com.kingdee.eas.base.commonquery.client.EntityTreePromptDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.permission.BizObjectForRoleCollection;
import com.kingdee.eas.base.permission.BizObjectForRoleEntryCollection;
import com.kingdee.eas.base.permission.BizObjectForRoleFactory;
import com.kingdee.eas.base.permission.BizObjectForRoleInfo;
import com.kingdee.eas.base.permission.EntryWhereEnum;
import com.kingdee.eas.base.permission.IBizObjectForRole;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.RuleFactory;
import com.kingdee.eas.base.permission.RuleInfo;
import com.kingdee.eas.base.permission.RuleUtil;
import com.kingdee.eas.base.permission.client.AbstractRuleEditUI;
import com.kingdee.eas.base.permission.client.DataSelectFilterPanel;
import com.kingdee.eas.base.permission.client.RuleListUI;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class RuleEditUI
extends AbstractRuleEditUI {
    private static Logger logger = Logger.getLogger((String)RuleEditUI.class.getName());
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    protected static final int FILTER_CONDITION = 1;
    private CommonEntityFilterPanel pnlFilter;
    private DataSelectFilterPanel dataSelectFilterPanel;
    private KDTable table = null;
    private Map dlgMap = new HashMap();
    private IMetaDataPK entityPK = null;
    private EntityObjectInfo entity = null;
    private String defaultQuery = null;

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            if (this.editData != null) {
                request.put("editdatabiz", (Object)BOSObjectType.create((String)this.editData.getBizObject()));
            }
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    private EntityObjectInfo getEntity() {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader.getEntity(BOSObjectType.create((String)this.editData.getBizObject()));
    }

    private void loadFilter() throws Exception {
        this.initContainerPanel();
    }

    private void initContainerPanel() throws Exception {
        this.resetContainer();
        this.entity = this.getEntity();
        this.entityPK = new MetaDataPK(this.entity.getFullName());
        this.defaultQuery = this.entity.getExtendedProperty("defaultF7Query");
        FilterInfo filterInfo = new FilterInfo(this.editData.getScript());
        filterInfo.setMaskString(this.editData.getMaskString());
        this.pnlFilter = new CommonEntityFilterPanel(this.entityPK, filterInfo, null, (IProcessor)new RuleProcess(), null, 540, 400, 10, false, true);
        this.table = this.pnlFilter.getKdtTable();
        this.contFilter.getContentPane().add((Component)this.table, "Center");
        this.contFilter.updateUI();
        this.contFilter.addButton((JButton)this.pnlFilter.getAddRowButton());
        this.contFilter.addButton((JButton)this.pnlFilter.getDelRowButton());
        this.contFilter.addButton((JButton)this.pnlFilter.getClearButton());
        this.addListener();
        this.initDataSelectPanel();
        this.initLogic();
    }

    private void initDataSelectPanel() throws Exception {
        if (this.isBaseData()) {
            this.dataSelectFilterPanel = new DataSelectFilterPanel(this.entityPK, this.editData);
            this.dataSelectFilter.getContentPane().add((Component)((Object)this.dataSelectFilterPanel), "Center");
            this.dataSelectFilter.updateUI();
            this.dataSelectFilter.addButton((JButton)this.dataSelectFilterPanel.getAddRowButton());
            this.dataSelectFilter.addButton((JButton)this.dataSelectFilterPanel.getDelRowButton());
            this.dataSelectFilter.addButton((JButton)this.dataSelectFilterPanel.getClearButton());
        } else {
            this.tabRule.setVisibleAt(0, false);
            this.tabRule.setEnabledAt(0, false);
            this.tabRule.setSelectedIndex(1);
        }
    }

    private void initLogic() {
        if (!this.isBaseData()) {
            this.lblDescription.setVisible(false);
            this.and.setVisible(false);
            this.or.setVisible(false);
        }
    }

    private boolean isBaseData() {
        String packageString = this.entity.getPackage();
        return packageString != null && packageString.indexOf("com.kingdee.eas.basedata") == 0 && !StringUtils.isEmpty((String)this.defaultQuery);
    }

    private void addListener() {
        this.pnlFilter.getKdtTable().addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarted(KDTEditEvent e) {
                RuleEditUI.this.table_editStarted(e);
            }
        });
    }

    private String[] getFilterProperties(int ruleType) {
        HashSet<String> filterProperties = new HashSet<String>();
        EntityObjectInfo entity = this.getEntity();
        PropertyCollection properties = entity.getInheritedNoDuplicatedProperties();
        int size = properties.size();
        for (int i = 0; i < size; ++i) {
            LinkPropertyInfo linkPropertyInfo;
            PropertyInfo propertyInfo = properties.get(i);
            if (propertyInfo instanceof OwnPropertyInfo) {
                if (ruleType == 2) continue;
                filterProperties.add(propertyInfo.getName());
                continue;
            }
            if (!(propertyInfo instanceof LinkPropertyInfo) || (PermissionCommonUtil.isEntry(linkPropertyInfo = (LinkPropertyInfo)propertyInfo) ? ruleType == 1 : ruleType == 2)) continue;
            EntityObjectInfo childEntity = PermissionCommonUtil.getLinkEntity(entity.getType(), linkPropertyInfo);
            PropertyCollection childProperties = childEntity.getInheritedNoDuplicatedProperties();
            int size1 = childProperties.size();
            for (int j = 0; j < size1; ++j) {
                LinkPropertyInfo childLinkPropertyInfo;
                PropertyInfo childPropertyInfo = childProperties.get(j);
                if (childPropertyInfo instanceof OwnPropertyInfo) {
                    filterProperties.add(linkPropertyInfo.getName() + "." + childPropertyInfo.getName());
                    continue;
                }
                if (!(childPropertyInfo instanceof LinkPropertyInfo) || PermissionCommonUtil.isEntry(childLinkPropertyInfo = (LinkPropertyInfo)childProperties.get(j))) continue;
                filterProperties.addAll(this.getLinkFitlerProperties(childEntity, linkPropertyInfo, linkPropertyInfo.getName() + "." + childLinkPropertyInfo.getName() + ".", 0));
            }
        }
        return filterProperties.toArray(new String[filterProperties.size()]);
    }

    private Set getLinkFitlerProperties(EntityObjectInfo entity, LinkPropertyInfo linkPropertyInfo, String prefix, int level) {
        HashSet<String> result = new HashSet<String>();
        if (++level < 2) {
            EntityObjectInfo linkEntity = PermissionCommonUtil.getLinkEntity(entity.getType(), linkPropertyInfo);
            PropertyCollection properties = linkEntity.getInheritedNoDuplicatedProperties();
            int size = properties.size();
            for (int i = 0; i < size; ++i) {
                PropertyInfo propertyInfo = properties.get(i);
                if (propertyInfo instanceof OwnPropertyInfo) {
                    result.add(prefix + propertyInfo.getName());
                    continue;
                }
                if (!(propertyInfo instanceof LinkPropertyInfo) || PermissionCommonUtil.isEntry((LinkPropertyInfo)propertyInfo)) continue;
                result.addAll(this.getLinkFitlerProperties(linkEntity, (LinkPropertyInfo)propertyInfo, prefix + propertyInfo.getName() + ".", level));
            }
        }
        return result;
    }

    private EntityTreePromptDialog getDialog(int rowIndex) throws EASBizException, ParserException, BOSException {
        Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        EntityObjectInfo entity = this.getEntity();
        int ruleType = 0;
        String[] properties = this.getFilterProperties(ruleType);
        properties = this.getCheckedProperties(properties);
        String strRuleType = String.valueOf(ruleType);
        if (!this.dlgMap.containsKey(strRuleType)) {
            EntityDialog dlg = null;
            if (parent instanceof Dialog) {
                dlg = new EntityDialog((Dialog)parent, entity, properties);
            } else if (parent instanceof Frame) {
                dlg = new EntityDialog((Frame)parent, entity, properties);
            }
            this.dlgMap.put(strRuleType, dlg);
        }
        return (EntityTreePromptDialog)this.dlgMap.get(strRuleType);
    }

    private String[] getCheckedProperties(String[] props) throws EASBizException, BOSException {
        HashSet<String> filterProperties = new HashSet<String>();
        IBizObjectForRole bfr = BizObjectForRoleFactory.getRemoteInstance();
        BizObjectForRoleCollection coll = bfr.getBizObjectForRoleCollection("where number='" + this.editData.getBizObject() + "'");
        if (coll != null && coll.size() > 0) {
            BizObjectForRoleInfo info = coll.get(0);
            BizObjectForRoleEntryCollection entryColl = info.getPropEntries();
            for (int i = 0; i < props.length; ++i) {
                int size = entryColl.size();
                for (int j = 0; j < size; ++j) {
                    if (!props[i].equals(entryColl.get(j).getPropNumber())) continue;
                    filterProperties.add(props[i]);
                }
            }
        } else {
            return props;
        }
        return filterProperties.toArray(new String[filterProperties.size()]);
    }

    protected void table_editStarted(KDTEditEvent e) {
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        if (rowIndex != -1 && colIndex == 1) {
            ICell cell = this.table.getRow(e.getRowIndex()).getCell(colIndex);
            if (cell == null || cell.getEditor() == null) {
                return;
            }
            KDPromptBox promptBox = (KDPromptBox)cell.getEditor().getComponent();
            try {
                if (promptBox == null) {
                    return;
                }
                promptBox.setSelector((KDPromptSelector)this.getDialog(rowIndex));
            }
            catch (EASBizException e1) {
                logger.error((Object)"error!", (Throwable)e1);
                this.handUIException(e1);
            }
            catch (ParserException e1) {
                logger.error((Object)"error!", (Throwable)e1);
                this.handUIException(e1);
            }
            catch (BOSException e1) {
                logger.error((Object)"error!", (Throwable)e1);
                this.handUIException(e1);
            }
        }
    }

    private int getCurrentRuleType() {
        EntityObjectInfo entity = this.getEntity();
        Set entryPropertyNames = RuleUtil.getEntryPropertyNames(entity);
        KDTable table = this.pnlFilter.getKdtTable();
        int count = table.getRowCount();
        for (int i = 0; i < count; ++i) {
            String str;
            Object object = table.getRow(i).getCell(1).getValue();
            if (object == null || !(object instanceof DataObject)) continue;
            String propertyName = ((DataObject)object).getValue();
            int pos = propertyName.indexOf(".");
            if (pos > 0 && entryPropertyNames.contains(str = propertyName.substring(0, pos))) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    private boolean isFiristRulePart(int rowIndex) {
        KDTable table = this.pnlFilter.getKdtTable();
        int count = table.getRowCount();
        for (int i = 0; i < count; ++i) {
            Object object = table.getRow(i).getCell(1).getValue();
            if (object == null || !(object instanceof DataObject) || i == rowIndex) continue;
            return false;
        }
        return true;
    }

    private void resetContainer() {
        if (this.contFilter != null) {
            this.removeTable();
            this.contFilter.removeAllButton();
            this.dataSelectFilter.removeAllButton();
        }
    }

    private void removeTable() {
        Component[] components = this.contFilter.getComponents();
        int length = components.length;
        for (int i = 0; i < length; ++i) {
            int size = ((JPanel)components[i]).getComponentCount();
            for (int j = 0; j < size; ++j) {
                if (!(((JPanel)components[i]).getComponent(j) instanceof KDTable)) continue;
                ((JPanel)components[i]).remove(((JPanel)components[i]).getComponent(j));
            }
        }
    }

    private void setComponentStatus() throws Exception {
        this.setButtonStatus();
    }

    private void setButtonStatus() {
        this.txtNumber.setEditable(!OprtState.VIEW.equals(this.getOprtState()));
        this.mlbName.setEditable(!OprtState.VIEW.equals(this.getOprtState()));
        this.pnlFilter.getKdtTable().getStyleAttributes().setLocked(OprtState.VIEW.equals(this.getOprtState()));
        this.pnlFilter.getAddRowButton().setVisible(!OprtState.VIEW.equals(this.getOprtState()));
        this.pnlFilter.getDelRowButton().setVisible(!OprtState.VIEW.equals(this.getOprtState()));
        this.pnlFilter.getClearButton().setVisible(!OprtState.VIEW.equals(this.getOprtState()));
        this.mltDescription.setEditable(!OprtState.VIEW.equals(this.getOprtState()));
        this.btnEdit.setVisible(false);
        LogicSignEnum logic = this.editData.getLogic();
        this.and.setSelected(LogicSignEnum.AND.equals((Object)logic));
        if (this.getUIContext().get("readonly") != null) {
            this.btnAddNew.setVisible(false);
            this.btnRemove.setVisible(false);
            this.btnSubmit.setVisible(false);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setTilte();
        this.btnCopy.setVisible(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            this.loadFilter();
            this.loadEntryWhere();
            this.setComponentStatus();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void loadEntryWhere() {
        EntryWhereEnum entryWhere = this.editData.getEntryDisplay();
        if (EntryWhereEnum.ENTRY_WHERE.equals((Object)entryWhere)) {
            this.rbEntryDisplay.setSelected(true);
        } else if (EntryWhereEnum.ENTRY_ANY_WHERE.equals((Object)entryWhere)) {
            this.rbDisplayAll.setSelected(true);
        } else {
            this.rbNotDisplay.setSelected(true);
        }
    }

    private void setTilte() {
        String title = PermissionCommonUtil.getUITitle(this.getUITitle(), this.getOprtState());
        this.setUITitle(title);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.storeEntryWhere();
        this.editData.setSyncOldValue(true);
        this.editData.setScript(this.handleLikeSymbol(this.pnlFilter.getFilterInfo().toString()));
        this.editData.setMaskString(this.pnlFilter.getFilterInfo().getMaskString());
        if (this.isBaseData()) {
            this.editData.setDataIds(this.dataSelectFilterPanel.getDataIds());
            this.editData.setLogic(this.getLogic());
        }
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.editData.setBizObject(this.getCurBOSObjectType());
        }
        this.editData.setSyncOldValue(false);
    }

    private void storeEntryWhere() {
        if (this.rbEntryDisplay.isSelected()) {
            this.editData.setEntryDisplay(EntryWhereEnum.ENTRY_WHERE);
        } else if (this.rbDisplayAll.isSelected()) {
            this.editData.setEntryDisplay(EntryWhereEnum.ENTRY_ANY_WHERE);
        } else {
            this.editData.setEntryDisplay(EntryWhereEnum.ENTRY_ALL_WHERE);
        }
    }

    private LogicSignEnum getLogic() {
        if (this.and.isSelected()) {
            return LogicSignEnum.AND;
        }
        return LogicSignEnum.OR;
    }

    private String handleLikeSymbol(String filterStr) {
        StringBuffer buf = new StringBuffer();
        int fromIndex = 0;
        int position = filterStr.indexOf(37, fromIndex);
        if (position == -1) {
            buf.append(filterStr);
        } else {
            while (position != -1) {
                buf.append(filterStr.substring(fromIndex, position + 1));
                for (fromIndex = position + 1; fromIndex < filterStr.length() && filterStr.charAt(fromIndex) == '%'; ++fromIndex) {
                }
                position = filterStr.indexOf(37, fromIndex);
            }
            if (fromIndex < filterStr.length()) {
                buf.append(filterStr.substring(fromIndex));
            }
        }
        return buf.toString();
    }

    private String getCurBOSObjectType() {
        String bizObject = null;
        Object objBizObject = this.getUIContext().get("bizObject");
        if (objBizObject != null) {
            bizObject = (String)objBizObject;
        }
        return bizObject;
    }

    private IObjectPK getCtrlUnitPK() {
        IObjectPK ctrlUnitPK = null;
        Object objCtrlUnitPK = this.getUIContext().get("ctrlUnitPK");
        ctrlUnitPK = objCtrlUnitPK == null ? this.getCurrentCUPK() : (IObjectPK)objCtrlUnitPK;
        return ctrlUnitPK;
    }

    private IObjectPK getCurrentCUPK() {
        return new ObjectUuidPK(SysContext.getSysContext().getCurrentCtrlUnit().getId());
    }

    protected IObjectValue createNewData() {
        String bosObjectType = this.getCurBOSObjectType();
        RuleInfo ruleInfo = new RuleInfo();
        ruleInfo.setBizObject(bosObjectType);
        ruleInfo.setIsDefault(false);
        CtrlUnitInfo ctrlUnitInfo = new CtrlUnitInfo();
        ctrlUnitInfo.setId(BOSUuid.read((String)this.getCtrlUnitPK().toString()));
        ruleInfo.setCU(ctrlUnitInfo);
        return ruleInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RuleFactory.getRemoteInstance();
    }

    private void checkName() {
        LanguageInfo languageInfo = new LanguageInfo(SysContext.getSysContext().getLocale());
        Object data = this.mlbName.getItemBy(languageInfo).getData();
        if (data != null && StringUtils.isEmpty((String)data.toString())) {
            this.mlbName.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"nameIsBlank"));
            this.abort();
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            this.txtNumber.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"numberIsBlank"));
            this.abort();
        }
        this.checkName();
        if (!this.pnlFilter.verify()) {
            this.abort();
        }
        if (StringUtils.isEmpty((String)this.editData.getScript()) && StringUtils.isEmpty((String)this.editData.getDataIds())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"ruleScriptIsEmpty"));
            this.abort();
        }
        if (RuleUtil.isMixHeadEntryRule(this.entity, this.editData)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"isMixRule"));
            this.abort();
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("*"));
        return sc;
    }

    private IObjectPK save() throws Exception {
        IObjectPK pk = this.runSubmit();
        this.editData.setId(BOSUuid.read((String)pk.toString()));
        return pk;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        Window window = SwingUtilities.getWindowAncestor((Component)((Object)this));
        LongTimeDialog dialog = UITools.getDialog((Component)((Object)this));
        dialog.setLongTimeTask(new ILongTimeTask(){

            @Override
            public Object exec() throws Exception {
                return RuleEditUI.this.save();
            }

            @Override
            public void afterExec(Object result) throws Exception {
                IObjectPK pk = (IObjectPK)result;
                RuleEditUI.this.showSubmitSuccess();
                RuleEditUI.this.setDataObject(RuleEditUI.this.getValue(pk));
                RuleEditUI.this.loadFields();
                RuleEditUI.this.setSave(true);
            }
        });
        dialog.show();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.setComponentStatus();
    }

    public boolean destroyWindow() {
        this.refreshRuleListUI();
        return super.destroyWindow();
    }

    private void refreshRuleListUI() {
        RuleListUI parentUI = null;
        if (this.getUIContext() != null && this.getUIContext().get("Owner") instanceof RuleListUI) {
            parentUI = (RuleListUI)((Object)this.getUIContext().get("Owner"));
            try {
                parentUI.refreshList();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class RuleProcess
    extends CommonEntityProcessor {
        private CtrlUnitInfo ctrlUnitInfo = null;

        private RuleProcess() {
        }

        private CtrlUnitInfo getCtrlUnitInfo(IObjectPK cuPK) throws EASBizException, BOSException {
            if (this.ctrlUnitInfo == null) {
                ICtrlUnit iCtrlUnit = CtrlUnitFactory.getRemoteInstance();
                this.ctrlUnitInfo = iCtrlUnit.getCtrlUnitInfo(cuPK);
            }
            return this.ctrlUnitInfo;
        }

        public void process() throws Exception {
        }
    }

    private static class EntityDialog
    extends EntityTreePromptDialog {
        public EntityDialog(Dialog owner, EntityObjectInfo entity, String[] properties) {
            super(owner, entity, properties);
        }

        public EntityDialog(Frame owner, EntityObjectInfo entity, String[] properties) {
            super(owner, entity, properties);
        }

        protected boolean isShowEntry() {
            return true;
        }
    }

    private static class RuleType {
        private static final int DEFUALT = 0;
        private static final int MAIN = 1;
        private static final int ENTRY = 2;

        private RuleType() {
        }
    }
}

