/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.permission.IRule;
import com.kingdee.eas.base.permission.IRuleRef;
import com.kingdee.eas.base.permission.LogicToken;
import com.kingdee.eas.base.permission.RuleFactory;
import com.kingdee.eas.base.permission.RuleInfo;
import com.kingdee.eas.base.permission.RuleRefFactory;
import com.kingdee.eas.base.permission.RuleUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractRuleSelectorUI;
import com.kingdee.eas.base.permission.client.IRuleAccreditUI;
import com.kingdee.eas.base.permission.client.RuleEditUI;
import com.kingdee.eas.base.permission.client.RuleListUI;
import com.kingdee.eas.base.permission.client.RulePanel;
import com.kingdee.eas.base.permission.helper.CUHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RuleSelectorUI
extends AbstractRuleSelectorUI {
    private static final int RULE_ID_INDEX = 0;
    private static final int IS_CHECKED_INDEX = 1;
    private static final int NUMBER_INDEX = 2;
    private static final int NAME_INDEX = 3;
    private static Logger logger = Logger.getLogger((String)RuleSelectorUI.class.getName());
    private static final int BIZ_OBJECT_INDEX = 6;
    CommonQueryDialog dialog = null;

    public RuleSelectorUI() throws Exception {
        this.initUI();
    }

    private void initUI() {
        this.initTable();
    }

    private void initTable() {
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent dre) {
                RuleSelectorUI.this.afterTableDataFilled(dre);
            }
        });
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnMaintain.setIcon(EASResource.getIcon((String)"imgTbtn_maintenance"));
    }

    private void afterTableDataFilled(KDTDataRequestEvent dre) {
        try {
            int firstRow = dre.getFirstRow();
            int lastRow = dre.getLastRow();
            if (lastRow - firstRow >= 0 && lastRow != -1) {
                int rowCount = lastRow - firstRow;
                Set rules = this.getRules();
                for (int i = firstRow; i <= firstRow + rowCount; ++i) {
                    String ruleID = (String)this.tblMain.getRow(i).getCell(0).getValue();
                    this.tblMain.getRow(i).getCell(1).setValue((Object)rules.contains(ruleID));
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.tblMain.getColumn("isChecked").getStyleAttributes().setLocked(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadFilter();
        this.btnQuery.setVisible(true);
    }

    private IObjectPK getCtrlUnitPK() {
        IObjectPK ctrlUnitPK = null;
        Object objCtrlUnitPK = this.getUIContext().get("ctrlUnitPK");
        ctrlUnitPK = objCtrlUnitPK != null ? (IObjectPK)objCtrlUnitPK : this.getCurrentCUPK();
        return ctrlUnitPK;
    }

    private Set getRules() {
        Set rules = null;
        Object objRules = this.getUIContext().get("rules");
        if (objRules != null) {
            rules = (Set)objRules;
        }
        return rules;
    }

    private HashMap getOldRuleMap() {
        HashMap ruleMap = null;
        Object objRules = this.getUIContext().get("ruleMap");
        if (objRules != null) {
            ruleMap = (HashMap)objRules;
        }
        return ruleMap;
    }

    private EntityObjectInfo getEntity() {
        EntityObjectInfo entity = null;
        Object objEntity = this.getUIContext().get("entity");
        if (objEntity != null) {
            entity = (EntityObjectInfo)objEntity;
        }
        return entity;
    }

    private IObjectPK getCurrentCUPK() {
        return new ObjectUuidPK(SysContext.getSysContext().getCurrentCtrlUnit().getId());
    }

    private void loadFilter() throws EASBizException, BOSException {
        EntityObjectInfo entity = this.getEntity();
        IRuleRef iRuleRef = RuleRefFactory.getRemoteInstance();
        Set set = iRuleRef.getSrcObjects(entity.getType());
        set.add(entity.getType().toString());
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("bizObject", (Object)set, CompareType.INCLUDE));
        if (this.mainQuery != null) {
            if (this.mainQuery.getFilter() != null) {
                this.mainQuery.getFilter().mergeFilter(filterInfo, "AND");
            } else {
                this.mainQuery.setFilter(filterInfo);
            }
        } else {
            this.mainQuery = new EntityViewInfo();
            this.mainQuery.setFilter(filterInfo);
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    private boolean isChanged(Set selectRules) {
        Set rules = this.getRules();
        HashMap oldRuleMap = this.getOldRuleMap();
        HashMap newRuleMap = this.getSelectedRuleMap();
        if (selectRules.size() == rules.size()) {
            for (String ruleID : selectRules) {
                if (!rules.contains(ruleID)) {
                    return true;
                }
                RuleInfo oldRule = (RuleInfo)oldRuleMap.get(ruleID);
                RuleInfo newRule = (RuleInfo)newRuleMap.get(ruleID);
                if (oldRule == null || newRule == null) continue;
                if (oldRule.getNumber() != null && !oldRule.getNumber().equals(newRule.getNumber())) {
                    return true;
                }
                if (oldRule.getName() == null || oldRule.getName().equals(newRule.getName())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private Set getSelectedRuleIDs() {
        HashSet<String> rule = new HashSet<String>();
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            boolean isChecked = (Boolean)this.tblMain.getRow(i).getCell(1).getValue();
            if (!isChecked) continue;
            String ruleID = (String)this.tblMain.getRow(i).getCell(0).getValue();
            rule.add(ruleID);
        }
        return rule;
    }

    private HashMap getSelectedRuleMap() {
        HashMap<String, RuleInfo> ruleMap = new HashMap<String, RuleInfo>();
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            boolean isChecked = (Boolean)this.tblMain.getRow(i).getCell(1).getValue();
            if (!isChecked) continue;
            String ruleID = (String)this.tblMain.getRow(i).getCell(0).getValue();
            RuleInfo rule = new RuleInfo();
            String number = (String)this.tblMain.getRow(i).getCell(2).getValue();
            String name = (String)this.tblMain.getRow(i).getCell(3).getValue();
            rule.setNumber(number);
            rule.setName(name);
            ruleMap.put(ruleID, rule);
        }
        return ruleMap;
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        Set selectedRuleIDs = this.getSelectedRuleIDs();
        if (this.isChanged(selectedRuleIDs)) {
            String ruleStructure = this.getRuleStructure(selectedRuleIDs);
            RulePanel rulePanel = ((IRuleAccreditUI)this.getUIContext().get("Owner")).getRulePanel();
            rulePanel.setRuleStructure(ruleStructure);
            rulePanel.refresh();
            this.getUIWindow().close();
        } else {
            this.getUIWindow().close();
        }
    }

    private RuleInfo getRuleInfo(String ruleID) throws EASBizException, BOSException {
        IRule rule = RuleFactory.getRemoteInstance();
        return rule.getRuleInfo((IObjectPK)new ObjectUuidPK(ruleID));
    }

    private String getRuleStructure(Set selectedRuleIDs) throws EASBizException, ParserException, BOSException {
        HashSet<String> mainRuleIDs = new HashSet<String>();
        HashMap entryAllRules = new HashMap();
        HashMap oldRuleMap = this.getOldRuleMap();
        EntityObjectInfo entity = this.getEntity();
        for (String ruleID : selectedRuleIDs) {
            if (RuleUtil.isEntryRule(entity, this.getRuleInfo(ruleID))) {
                Set<String> entryRules;
                RuleInfo ruleInfo = this.getRuleInfo(ruleID);
                String propertyName = RuleUtil.getEntryPropertyName(ruleInfo.getScript());
                if (entryAllRules.containsKey(propertyName)) {
                    entryRules = (Set)entryAllRules.get(propertyName);
                    entryRules.add(ruleID);
                    continue;
                }
                entryRules = new HashSet();
                entryRules.add(ruleID);
                entryAllRules.put(propertyName, entryRules);
                continue;
            }
            mainRuleIDs.add(ruleID);
        }
        StringBuffer ruleStructure = new StringBuffer();
        if (mainRuleIDs.size() > 0) {
            ruleStructure.append(" WHERE ");
            String[] ruleIDs = mainRuleIDs.toArray(new String[mainRuleIDs.size()]);
            int length = ruleIDs.length;
            for (int i = 0; i < length; ++i) {
                RuleInfo rule;
                if (i == length - 1) {
                    ruleStructure.append(" ").append(ruleIDs[i]).append(" ");
                    continue;
                }
                String logicStr = "AND";
                if (oldRuleMap.get(ruleIDs[i]) != null && (rule = (RuleInfo)oldRuleMap.get(ruleIDs[i])).get("logic") != null) {
                    LogicToken logic = (LogicToken)((Object)rule.get("logic"));
                    logicStr = logic.getName();
                }
                ruleStructure.append(" ").append(ruleIDs[i]).append(" ").append(logicStr).append(" ");
            }
        }
        Set collection = entryAllRules.keySet();
        for (String entryPropertyName : collection) {
            Set setEntry = (Set)entryAllRules.get(entryPropertyName);
            String[] rules = setEntry.toArray(new String[setEntry.size()]);
            int length = rules.length;
            if (length <= 0) continue;
            ruleStructure.append(" ").append("ENTRYALLWHERE").append(" ");
            for (int i = 0; i < length; ++i) {
                RuleInfo rule;
                String ruleID = rules[i];
                if (i == length - 1) {
                    ruleStructure.append(" ").append(ruleID).append(" ");
                    continue;
                }
                String logicStr = "AND";
                if (oldRuleMap.get(ruleID) != null && (rule = (RuleInfo)oldRuleMap.get(ruleID)).get("logic") != null) {
                    LogicToken logic = (LogicToken)((Object)rule.get("logic"));
                    logicStr = logic.getName();
                }
                ruleStructure.append(" ").append(ruleID).append(" ").append(logicStr).append(" ");
            }
            ruleStructure.append(" ON  ").append(entryPropertyName).append(" ");
        }
        return ruleStructure.toString();
    }

    @Override
    public void actionMaintain_actionPerformed(ActionEvent e) throws Exception {
        super.actionMaintain_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"entityType", (Object)this.getEntity().getType());
        uiContext.put((Object)"ctrlUnitPK", (Object)this.getCtrlUnitPK());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(RuleListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        this.refresh(e);
    }

    protected String getEditUIName() {
        return RuleEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RuleFactory.getRemoteInstance();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        if (this.btnView.equals(e.getSource())) {
            int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
            String bizObject = (String)this.tblMain.getRow(rowIndex).getCell(6).getValue();
            uiContext.put((Object)"bizObject", (Object)bizObject);
            uiContext.put((Object)"ctrlUnitPK", (Object)this.getCtrlUnitPK());
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getColIndex() == 1) {
            return;
        }
        super.tblMain_tableClicked(e);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        try {
            FilterInfo filter = CUHelper.getCuFilterByUser(this.getCurrentUser());
            EntityObjectInfo entity = this.getEntity();
            IRuleRef iRuleRef = RuleRefFactory.getRemoteInstance();
            Set set = iRuleRef.getSrcObjects(entity.getType());
            set.add(entity.getType().toString());
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("bizObject", (Object)set, CompareType.INCLUDE));
            if (filter != null) {
                filter.mergeFilter(filterInfo, "AND");
            }
            return filter;
        }
        catch (Exception be) {
            logger.error((Object)"", (Throwable)be);
            this.handleException(be);
            return super.getDefaultFilterForQuery();
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.dialog = this.getDialog();
        this.dialog.setParentUIClassName(((Object)((Object)this)).getClass().getName());
        this.dialog.setShowDefaultSolution(false);
        this.dialog.setShowToolbar(false);
        super.actionQuery_actionPerformed(e);
    }

    private UserInfo getCurrentUser() {
        return SysContext.getSysContext().getCurrentUserInfo();
    }

    protected void execQuery() {
        Set rules = this.getRules();
        if (rules.size() > 0) {
            FilterInfo filterInfo = this.mainQuery.getFilter();
            FilterInfo rulesIdsFilter = new FilterInfo();
            rulesIdsFilter.getFilterItems().add(new FilterItemInfo("id", (Object)rules, CompareType.INCLUDE));
            try {
                filterInfo.mergeFilter(rulesIdsFilter, "OR");
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        super.execQuery();
    }
}

