/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.InheritPermFacadeFactory;
import com.kingdee.eas.base.permission.RoleChangeInfo;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.client.AbstractSubOrgUI;
import com.kingdee.eas.base.permission.util.IObjectCol2List;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.ToolUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class SubOrgUI
extends AbstractSubOrgUI {
    public static final String ROLE_CHANGE_INFO = "roleChangeInfo";
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private static final Logger logger = CoreUIObject.getLogger(SubOrgUI.class);
    private static final String ROLE_NAME = "roleName";
    private static final String ROLE_NUMBER = "roleNumber";
    private static final String ROLE_ID = "id";
    private static final String ORG_NUMBER = "orgNumber";
    private static final String ORG_NAME = "orgName";
    public static final String USERPK = "USERPK";
    public static final String ORGPK = "ORGPK";
    public static final String ADDEDROLECOL = "ADDEDROLECOL";
    public static final String DELETEDROLECOL = "DELETEDROLECOL";
    public static final String ADDEDGRANTROLECOL = "ADDEDGRANTROLECOL";
    public static final String DELETEDGRANTROLECOL = "DELETEDGRANTROLECOL";

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
        this.initRoleTables();
    }

    private void initUI() {
        this.btnAddNew.setVisible(false);
        this.btnView.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnRemove.setVisible(false);
        this.kDLabel2.setText(EASResource.getString((String)RESOURCE, (String)"SelectedSubOrg"));
    }

    private Collection getAddedRoleCol() {
        return (Collection)this.getUIContext().get(ADDEDROLECOL);
    }

    private Collection getDeletedRoleCol() {
        return (Collection)this.getUIContext().get(DELETEDROLECOL);
    }

    private Collection getAddedGrantRoleCol() {
        return (Collection)this.getUIContext().get(ADDEDGRANTROLECOL);
    }

    private Collection getDeletedGrantRoleCol() {
        return (Collection)this.getUIContext().get(DELETEDGRANTROLECOL);
    }

    private IObjectPK getCurrentOrgPK() {
        return (IObjectPK)this.getUIContext().get(ORGPK);
    }

    private IObjectPK getUserPK() {
        return (IObjectPK)this.getUIContext().get(USERPK);
    }

    private void initRoleTables() {
        this.initRoleTable(this.kdtAddedRole, this.getAddedRoleCol());
        this.initRoleTable(this.kdtDeletedRole, this.getDeletedRoleCol());
        this.initRoleTable(this.kdtAddedGrantRole, this.getAddedGrantRoleCol());
        this.initRoleTable(this.kdtDeletedGrangRole, this.getDeletedGrantRoleCol());
    }

    private void initRoleTable(KDTable table, Collection roleCol) {
        for (RoleInfo role : roleCol) {
            IRow row = table.addRow();
            row.getCell(ROLE_NAME).setValue((Object)role.getName());
            row.getCell(ROLE_NUMBER).setValue((Object)role.getNumber());
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        super.beforeExcutQuery(ev);
        SorterItemCollection sortCol = new SorterItemCollection();
        sortCol.add(new SorterItemInfo("org.longNumber"));
        ev.setSorter(sortCol);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        String longNumber;
        FilterInfo defaultFilter = super.getDefaultFilterForQuery();
        IObjectPK orgPK = this.getCurrentOrgPK();
        try {
            longNumber = this.getOrgInfo(orgPK).getLongNumber();
        }
        catch (Exception e1) {
            logger.error((Object)e1);
            longNumber = null;
        }
        IObjectPK userPK = this.getUserPK();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo subFilterItem = new FilterItemInfo("org.longNumber", (Object)(longNumber + "!%"), CompareType.LIKE);
        FilterItemInfo userFilterItem = new FilterItemInfo("user.id", (Object)userPK);
        FilterItemInfo typeFilterItem = new FilterItemInfo("type", (Object)String.valueOf(10));
        filter.getFilterItems().add(subFilterItem);
        filter.getFilterItems().add(typeFilterItem);
        filter.getFilterItems().add(userFilterItem);
        if (defaultFilter == null || defaultFilter.getFilterItems().size() == 0) {
            return filter;
        }
        try {
            defaultFilter.mergeFilter(filter, "and");
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        return defaultFilter;
    }

    private FullOrgUnitInfo getOrgInfo(IObjectPK orgPK) throws Exception {
        return FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo(orgPK);
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    private Collection getPKColByCol(Collection roleCol) {
        return ToolUtils.transCol2ListByPeroperty(new ArrayList(roleCol), (IObjectCol2List)new IObjectCol2List(){

            @Override
            public String getList(Object obj) {
                return ((RoleInfo)obj).getId().toString();
            }
        });
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        Collection addedRolePKCol = this.getPKColByCol(this.getAddedRoleCol());
        Collection deletedRolePKCol = this.getPKColByCol(this.getDeletedRoleCol());
        Collection addedGrantRolePKCol = this.getPKColByCol(this.getAddedGrantRoleCol());
        Collection deletedGrantRolePKCol = this.getPKColByCol(this.getDeletedGrantRoleCol());
        RoleChangeInfo roleChangeInfo = new RoleChangeInfo(this.getUserPK(), this.getCurrentOrgPK(), addedRolePKCol, deletedRolePKCol, addedGrantRolePKCol, deletedGrantRolePKCol);
        InheritPermFacadeFactory.getRemoteInstance().changeSubOrgsRoles(roleChangeInfo);
        this.getUIWindow().close();
    }

    @Override
    public void actionNo_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{ORG_NUMBER, ORG_NAME};
        return locateNames;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }
}

