/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IPermissionRangeFacade;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.IUserRoleOrgManager;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PermissionRangeFacadeFactory;
import com.kingdee.eas.base.permission.RoleCollection;
import com.kingdee.eas.base.permission.RoleGroupFactory;
import com.kingdee.eas.base.permission.RoleGroupInfo;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserRoleOrgCollection;
import com.kingdee.eas.base.permission.UserRoleOrgInfo;
import com.kingdee.eas.base.permission.UserRoleOrgManagerFactory;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.base.permission.client.AbstractUserAssignRoleUI;
import com.kingdee.eas.base.permission.client.RolePermViewUI;
import com.kingdee.eas.base.permission.client.f7.AccreditF7PromptDialog;
import com.kingdee.eas.base.permission.client.f7.IDefaultSupportF7;
import com.kingdee.eas.base.permission.client.f7.ManageF7PromptDialog;
import com.kingdee.eas.base.permission.client.helper.RoleHelper;
import com.kingdee.eas.base.permission.client.helper.UserRoleAssignHelper;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.base.permission.client.util.InheritFatherUserRoleUtil;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.base.permission.util.IObjectCol2List;
import com.kingdee.eas.base.permission.util.LogNamesHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.NewOrgF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.CtrlF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.tree.DefaultLNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ILNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ITreeBuilder;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.client.tree.TreeBuilderFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;

public class UserAssignRoleUI
extends AbstractUserAssignRoleUI {
    private static final Logger logger = CoreUIObject.getLogger(UserAssignRoleUI.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private UserInfo targetUser = null;
    private Map accreditOrgs = new HashMap();
    private UserRoleAssignHelper roleAssignHelper = null;
    RoleCollection originRoleCol = new RoleCollection();
    RoleCollection originGrantRoleCol = new RoleCollection();
    private ITreeBuilder treeBuilder;
    IDefaultSupportF7 accreditF7Dialog = null;
    IDefaultSupportF7 ctrlUnitF7Dialog = null;
    FullOrgUnitInfo lastAccreditF7DialogSelected = null;
    FullOrgUnitInfo lastCtrlUnitF7DialogSelected = null;
    private int selectedIndex = 0;
    private boolean isFound = false;

    @Override
    public boolean isPrepareInit() {
        return false;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.put("getCurrentUserPK", (Object)ToolUtils.getCurrentUserPK());
            request.put("getTargetUserPK", (Object)this.getTargetUserPK());
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    private UserRoleAssignHelper getRoleAssignHelper() {
        if (this.roleAssignHelper == null) {
            this.roleAssignHelper = UserRoleAssignHelper.getHelper((Component)((Object)this), this.rolePanel, this.lstAll, this.lstGrant, this.lstAssign, this.targetUser);
        }
        return this.roleAssignHelper;
    }

    @Override
    protected void pmtOrg_willShow(SelectorEvent e) throws Exception {
        this.alertSave(e);
    }

    @Override
    protected void pmtOrg_dataChanged(DataChangeEvent e) throws EASBizException, BOSException, CloneNotSupportedException {
        FullOrgUnitInfo selectedOrg = this.getSelectedOrgInfo();
        if (selectedOrg != null) {
            ObjectUuidPK cuPK = new ObjectUuidPK(selectedOrg.getCU().getId());
            CtrlUnitInfo ctrl = CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo((IObjectPK)cuPK);
            String paramValueStr = ParamManager.getParamValue(null, null, (String)"UserRoleAssignCUIsNull");
            if ("true".equals(paramValueStr)) {
                this.pmtCtrlUnit.setValue(null);
                this.loadLeftRoleList();
                this.loadLists();
            } else {
                this.pmtCtrlUnit.setValue((Object)ctrl);
            }
        } else {
            this.pmtCtrlUnit.setValue(null);
            this.getRoleAssignHelper().clearLists();
        }
        if (this.rolePanel.getSelectedComponent().equals(this.spnGrantRole)) {
            if (this.lastCtrlUnitF7DialogSelected != null && selectedOrg != null && this.lastCtrlUnitF7DialogSelected.getId().toString().equals(selectedOrg.getId().toString())) {
                return;
            }
            this.lastCtrlUnitF7DialogSelected = selectedOrg;
        } else {
            if (this.lastAccreditF7DialogSelected != null && selectedOrg != null && this.lastAccreditF7DialogSelected.getId().toString().equals(selectedOrg.getId().toString())) {
                return;
            }
            this.lastAccreditF7DialogSelected = selectedOrg;
        }
        if (selectedOrg != null) {
            this.loadLists();
        }
    }

    private void loadLists() throws EASBizException, BOSException, CloneNotSupportedException {
        RoleCollection[] userRoles = this.getAssignRoles(this.getTargetUserPK(), this.getSelectedOrgPK(), "loadList");
        if (this.rolePanel.getSelectedComponent().equals(this.spnGrantRole)) {
            this.getRoleAssignHelper().loadListsByPanel(this.lstGrant, userRoles[1]);
            this.originGrantRoleCol = userRoles[1];
        } else {
            this.getRoleAssignHelper().loadListsByPanel(this.lstAssign, userRoles[0]);
            this.originRoleCol = userRoles[0];
        }
    }

    private RoleCollection[] getAssignRoles(IObjectPK userPK, IObjectPK orgPK, String methodName) throws EASBizException, BOSException {
        IUserRoleOrgManager iUserRoleOrgManager = UserRoleOrgManagerFactory.getRemoteInstance();
        RoleCollection[] roles = iUserRoleOrgManager.getUserRoles(userPK, orgPK, methodName);
        return roles;
    }

    private RoleCollection getAuthorizedRoles() throws EASBizException, BOSException {
        return RoleHelper.getAuthorizedRoles();
    }

    private CtrlUnitInfo getCurrentCU() {
        return SysContext.getSysContext().getCurrentCtrlUnit();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setUserInfo();
        this.initOrgF7();
        this.loadMainRoles();
        this.initCtrlF7();
        this.rolePanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    UserAssignRoleUI.this.tabAssign_stateChanged(e);
                }
                catch (Exception exc) {
                    UserAssignRoleUI.this.handUIException(exc);
                }
            }
        });
        this.lbcOrg.setBoundLabelText(EASResource.getString((String)RESOURCE, (String)"biz_org"));
        this.initRoleGroupTree();
    }

    private void tabAssign_stateChanged(ChangeEvent e) {
        int mode = this.rolePanel.getSelectedIndex();
        IDefaultSupportF7 orgF7 = null;
        if (mode == 0) {
            if (this.accreditF7Dialog == null) {
                this.accreditF7Dialog = new AccreditF7PromptDialog((IUIObject)this, this.targetUser, false);
            }
            orgF7 = this.accreditF7Dialog;
            this.lbcOrg.setBoundLabelText(EASResource.getString((String)RESOURCE, (String)"biz_org"));
            this.pmtOrg.setData((Object)this.lastAccreditF7DialogSelected);
        } else if (mode == 1) {
            this.lbcOrg.setBoundLabelText(EASResource.getString((String)RESOURCE, (String)"authorize_org"));
            if (this.ctrlUnitF7Dialog == null) {
                this.ctrlUnitF7Dialog = new ManageF7PromptDialog((IUIObject)this, this.targetUser);
                this.pmtOrg.setData(this.ctrlUnitF7Dialog.getDefaultData());
                ((NewOrgF7PromptDialog)this.ctrlUnitF7Dialog).setMultiSelect(false);
            }
            orgF7 = this.ctrlUnitF7Dialog;
            this.pmtOrg.setData((Object)this.lastCtrlUnitF7DialogSelected);
        }
        this.pmtOrg.setSelector((KDPromptSelector)orgF7);
        this.pmtOrg.setEditable(false);
    }

    private void initCtrlF7() throws EASBizException, BOSException {
        CtrlF7 ctrlF7 = UserRoleAssignHelper.getCtrlF7((IUIObject)this, this.getCurrentUserPK());
        this.pmtCtrlUnit.setSelector((KDPromptSelector)ctrlF7);
    }

    private OrgRangeType getOrgRangeType() {
        OrgRangeType rangeType = null;
        IObjectPK userPK = this.getCurrentUserPK();
        UserType type = this.getCurrentUser().getType();
        if (Administrator.isSuperAdmin(userPK) || Administrator.isAdminType(type)) {
            rangeType = OrgRangeType.BIZ_ORG_TYPE;
        } else if (!Administrator.isSuperCUAdmin(userPK) && this.getCurrentUser().isBizAdmin()) {
            rangeType = OrgRangeType.MANAGE_ORG_TYPE;
        } else {
            return null;
        }
        return rangeType;
    }

    private String buildCtrlF7OrgRangeSQL() {
        OrgRangeType rangeType = this.getOrgRangeType();
        if (rangeType == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select forgid from t_pm_orgrange where fuserid = '").append(this.getCurrentUserPK()).append("' and ftype = ").append(rangeType.getValue());
        return sql.toString();
    }

    @Override
    protected void pmtCtrlUnit_dataChanged(DataChangeEvent e) throws Exception {
        if (this.getSelectedOrgInfo() != null) {
            this.loadLeftRoleList();
        }
    }

    private void loadLeftRoleList() throws EASBizException, BOSException {
        RoleCollection authorizedRoles = null;
        authorizedRoles = this.getCurrentUser().isBizAdmin() ? this.getAssignRoles(this.getCurrentUserPK(), this.getSelectedOrgPK(), "loadLeftRoleList")[1] : this.getAuthorizedRoles();
        CtrlUnitInfo selectedCtrlInfo = this.getSelectedCtrlInfo();
        RoleGroupInfo selectedTreeNode = null;
        if (this.getSelectedTreeNode() != null && !this.getSelectedTreeNode().isRoot()) {
            selectedTreeNode = (RoleGroupInfo)this.getSelectedTreeNode().getUserObject();
        }
        RoleCollection currentCURoles = UserRoleAssignHelper.filterByCU(authorizedRoles, selectedCtrlInfo, selectedTreeNode);
        this.getRoleAssignHelper().loadLeftList(currentCURoles);
    }

    public void loadMainRoles() throws EASBizException, BOSException {
        IUserRoleOrgManager iUserRoleOrgManager = UserRoleOrgManagerFactory.getRemoteInstance();
        RoleCollection roles = iUserRoleOrgManager.getAllUserRole(this.getTargetUserPK());
        this.cmbMainRole.addItem((Object)"");
        this.cmbMainRole.addItems(roles.toArray());
        if (this.targetUser.getMainRole() != null) {
            int count = this.cmbMainRole.getItemCount();
            for (int i = 0; i < count; ++i) {
                Object item = this.cmbMainRole.getItemAt(i);
                if (item == null || !(item instanceof RoleInfo) || !this.targetUser.getMainRole().getId().equals((Object)((RoleInfo)item).getId())) continue;
                this.cmbMainRole.setSelectedIndex(i);
            }
        }
    }

    private void setAccreditOrgs() throws EASBizException, BOSException {
        IPermissionRangeFacade iPermissionRangeFacade = PermissionRangeFacadeFactory.getRemoteInstance();
        Collection col = iPermissionRangeFacade.getOrgRange(this.getTargetUserPK(), this.getCurrentUserPK());
        if (col != null) {
            Iterator it = col.iterator();
            while (it.hasNext()) {
                this.accreditOrgs.put(it.next().toString(), Boolean.FALSE);
            }
        }
    }

    private void selectDefOrg() throws EASBizException, BOSException {
        FullOrgUnitInfo defOrgUnit = this.targetUser.getDefOrgUnit();
        if (defOrgUnit != null) {
            this.pmtOrg.setData((Object)defOrgUnit);
        }
    }

    private void initOrgF7() throws EASBizException, BOSException {
        this.accreditF7Dialog = new AccreditF7PromptDialog((IUIObject)this, this.targetUser, false);
        this.pmtOrg.setSelector((KDPromptSelector)this.accreditF7Dialog);
        this.pmtOrg.setData(this.accreditF7Dialog.getDefaultData());
        this.pmtOrg.setEditable(false);
    }

    private void setUserInfo() throws EASBizException, BOSException {
        this.targetUser = this.getUserInfo(this.getTargetUserPK());
        this.txtUser.setText(this.targetUser.getNumber() + "(" + this.targetUser.getName() + ")");
    }

    private UserInfo getUserInfo(IObjectPK userPK) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("bizAdmin"));
        sic.add(new SelectorItemInfo("mainRole"));
        sic.add(new SelectorItemInfo("defOrgUnit.id"));
        sic.add(new SelectorItemInfo("defOrgUnit.number"));
        sic.add(new SelectorItemInfo("defOrgUnit.name"));
        sic.add(new SelectorItemInfo("defOrgUnit.CU.id"));
        IUser iUser = UserFactory.getRemoteInstance();
        return iUser.getUserInfo(userPK, sic);
    }

    @Override
    protected void addSingle(ActionEvent e) throws Exception {
        super.addSingle(e);
        int selectedIndex = this.lstAll.getSelectedIndex();
        if (selectedIndex != -1) {
            this.getRoleAssignHelper().addSingleRole();
        }
    }

    @Override
    protected void addAll(ActionEvent e) throws Exception {
        this.getRoleAssignHelper().addAllRole();
    }

    @Override
    protected void deleteSingle(ActionEvent e) throws Exception {
        this.getRoleAssignHelper().delSingleRole();
    }

    @Override
    protected void deleteAll(ActionEvent e) throws Exception {
        this.getRoleAssignHelper().delAllRole();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnAddAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnDeleteAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.setButtonDefaultStyl(this.btnAssignRole);
        this.btnAssignRole.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnViewRolePerm.setIcon(EASResource.getIcon((String)"imgTbtn_examinepurview"));
    }

    @Override
    public RequestContext prepareActionAssignRole(IItemAction itemAction) throws Exception {
        RequestContext request = new RequestContext();
        this.checkOrgSelected();
        if (request != null) {
            request.setClassName(this.getUIHandlerClassName());
            Object obj = this.cmbMainRole.getSelectedItem();
            if (obj instanceof String) {
                this.targetUser.setMainRole(null);
            } else if (obj instanceof RoleInfo) {
                this.targetUser.setMainRole((RoleInfo)obj);
            }
            request.put("targetUser", (Object)this.targetUser);
        }
        return request;
    }

    private void prepareActionRemoveAfter() throws Exception {
        if (!this.isPrepareActionAssignRole()) {
            return;
        }
        IUIActionPostman handle = super.prepareInit();
        RequestContext request = new RequestContext();
        request.put("LogDetailStr", (Object)this.getLogDetailStr(this.getUserRoleOrgCol()));
        request.put("userRoleOrgCol", (Object)this.getUserRoleOrgCol());
        request.put("currentUserPK", (Object)ToolUtils.getCurrentUserPK());
        request.put("targetUserPK", (Object)this.getTargetUserPK());
        request.put("selectedOrgPK", (Object)this.getSelectedOrgPK());
        request.put("isModify", (Object)new Boolean(this.isModify()));
        request.setMethodName("handleSaveRoleAfterConfirm");
        handle.setRequestContext((Serializable)request);
        handle.callHandler();
    }

    @Override
    public boolean isPrepareActionAssignRole() {
        return false;
    }

    @Override
    public void actionAssignRole_actionPerformed(ActionEvent e) throws Exception {
        super.actionAssignRole_actionPerformed(e);
        this.checkOrgSelected();
        this.save();
        this.reloadUI();
    }

    private String getLogDetailStr(UserRoleOrgCollection userRoleOrgCol) {
        Locale locale = SysContext.getSysContext().getLocale();
        String logStr = LogNamesHelper.getLogName("userNumber4Log", locale) + " : " + (this.targetUser == null ? "" : this.targetUser.getNumber()) + " , " + LogNamesHelper.getLogName("orgNumber4Log", locale) + ": " + (this.getSelectedOrgInfo() == null ? "" : this.getSelectedOrgInfo().getNumber());
        List roleNumberList = ToolUtils.transCol2ListByPeroperty((IObjectCollection)userRoleOrgCol, new IObjectCol2List(){

            @Override
            public String getList(Object obj) {
                UserRoleOrgInfo userRoleOrgInfo = (UserRoleOrgInfo)obj;
                if (userRoleOrgInfo != null && userRoleOrgInfo.getRole() != null) {
                    return userRoleOrgInfo.getRole().getNumber();
                }
                return "";
            }
        });
        String roleNumberStr = LogNamesHelper.getLogName("roleNumber4Log", locale) + ":(" + ToolUtils.aryToStr(roleNumberList, false) + ")";
        return logStr + roleNumberStr;
    }

    private void save() throws Exception {
        IUser iUser = UserFactory.getRemoteInstance();
        Object obj = this.cmbMainRole.getSelectedItem();
        RoleInfo currentMainRole = this.targetUser.getMainRole();
        boolean isMainRoleChange = false;
        if (currentMainRole != null && obj instanceof String) {
            this.targetUser.setMainRole(null);
            isMainRoleChange = true;
        } else if (currentMainRole == null && obj instanceof RoleInfo) {
            this.targetUser.setMainRole((RoleInfo)obj);
            isMainRoleChange = true;
        } else if (currentMainRole != null && obj instanceof RoleInfo && !currentMainRole.getId().equals((Object)((RoleInfo)obj).getId())) {
            this.targetUser.setMainRole((RoleInfo)obj);
            isMainRoleChange = true;
        }
        StringBuilder sb = new StringBuilder();
        if (isMainRoleChange) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("mainRole"));
            iUser.updatePartial((CoreBaseInfo)this.targetUser, sic);
            sb.append(EASResource.getString((String)RESOURCE, (String)"mainRoleSucceed"));
        }
        IUserRoleOrgManager iUserRoleOrgManager = UserRoleOrgManagerFactory.getRemoteInstance();
        if (this.isModify()) {
            UserRoleOrgCollection userRoleOrgCol;
            String msg;
            boolean isEnabledAuthen = false;
            ArrayList<String> orgList = new ArrayList<String>();
            if (this.lastAccreditF7DialogSelected != null) {
                orgList.add(this.lastAccreditF7DialogSelected.getId().toString());
            }
            ArrayList<String> grantOrgList = new ArrayList<String>();
            if (this.lastCtrlUnitF7DialogSelected != null) {
                orgList.add(this.lastCtrlUnitF7DialogSelected.getId().toString());
            }
            PermissionHelper.alertRoleNeedAuthen((Component)((Object)this), orgList, this.getAddRoleColl(false), grantOrgList, this.getAddRoleColl(false));
            if (isEnabledAuthen && MsgBox.showConfirm2((Component)((Object)this), (String)(msg = MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"ROLE_WILL_NEED_AUTHEN"), this.targetUser.getNumber()))) == 2) {
                SysUtil.abort();
            }
            if (this.lastAccreditF7DialogSelected != null) {
                userRoleOrgCol = this.getRoleAssignHelper().getUserAssignRoleOrgCols(this.lastAccreditF7DialogSelected);
                iUserRoleOrgManager.saveUserRoleOrgs(userRoleOrgCol, this.targetUser.getId().toString(), this.lastAccreditF7DialogSelected.getId().toString(), "T_PM_UserRoleOrg");
            }
            if (this.lastCtrlUnitF7DialogSelected != null) {
                userRoleOrgCol = this.getRoleAssignHelper().getUserGrantRoleOrgCols(this.lastCtrlUnitF7DialogSelected);
                iUserRoleOrgManager.saveUserRoleOrgs(userRoleOrgCol, this.targetUser.getId().toString(), this.lastCtrlUnitF7DialogSelected.getId().toString(), "T_PM_GrantUserRoleOrg");
            }
            if (isMainRoleChange) {
                sb.append(".");
            }
            sb.append(EASResource.getString((String)RESOURCE, (String)"accreditPermSucceed"));
            this.checkForReturn();
            this.changeSubOrgRole();
        }
        UITools.showMsg(this, sb.toString(), false);
    }

    private List<String> getAddRoleColl(boolean isGrant) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            int i;
            RoleCollection[] userRoles = this.getAssignRoles(this.getTargetUserPK(), this.getSelectedOrgPK(), "loadList");
            RoleCollection roleColl = isGrant ? userRoles[1] : userRoles[0];
            List roleIdList = isGrant ? this.getRoleAssignHelper().getSelectedGrantRoleIdList() : this.getRoleAssignHelper().getSelectedAssignRoleIdList();
            HashSet<String> roleIdSet = new HashSet<String>();
            if (roleColl != null && roleColl.size() > 0) {
                for (i = 0; i < roleColl.size(); ++i) {
                    roleIdSet.add(roleColl.get(i).getId().toString());
                }
            }
            if (roleIdList != null && roleIdList.size() > 0) {
                for (i = 0; i < roleIdList.size(); ++i) {
                    String roleId = roleIdList.get(i).toString();
                    if (roleIdSet.contains(roleId)) continue;
                    result.add(roleId);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private void checkForReturn() {
        UITools.showMsg(this, EASResource.getString((String)RESOURCE, (String)"accreditPermSucceed"), false);
    }

    private void changeSubOrgRole() throws Exception {
        if (!InheritFatherUserRoleUtil.needInheritParentUserAndRole()) {
            return;
        }
        List originRoleList = ToolUtils.tranColToList((IObjectCollection)this.originRoleCol);
        List originGrantRoleList = ToolUtils.tranColToList((IObjectCollection)this.originGrantRoleCol);
        List newRoleIdCol = this.getRoleAssignHelper().getSelectedRoleList();
        List newGrantRoleIdCol = this.getRoleAssignHelper().getSelectedGrantRoleList();
        Collection addedRoleCol = CollectionUtils.subtract((Collection)newRoleIdCol, (Collection)originRoleList);
        Collection deletedRoleCol = CollectionUtils.subtract((Collection)originRoleList, (Collection)newRoleIdCol);
        Collection addedGrantRoleCol = CollectionUtils.subtract((Collection)newGrantRoleIdCol, (Collection)originGrantRoleList);
        Collection deletedGrantRoleCol = CollectionUtils.subtract((Collection)originGrantRoleList, (Collection)newGrantRoleIdCol);
        InheritFatherUserRoleUtil.changeSubOrgsRole(this.getTargetUserPK(), this.getSelectedOrgPK(), addedRoleCol, deletedRoleCol, addedGrantRoleCol, deletedGrantRoleCol);
    }

    private UserRoleOrgCollection getUserRoleOrgCol() {
        return this.getRoleAssignHelper().getUserRoleOrgCols(this.getSelectedOrgInfo());
    }

    private void reloadUI() throws EASBizException, BOSException, CloneNotSupportedException {
        this.loadLists();
        this.cmbMainRole.removeAllItems();
        this.setUserInfo();
        this.loadMainRoles();
    }

    private IObjectPK getTargetUserPK() {
        return new ObjectUuidPK((String)this.getUIContext().get("targetID"));
    }

    private UserInfo getCurrentUser() {
        return SysContext.getSysContext().getCurrentUserInfo();
    }

    private IObjectPK getCurrentUserPK() {
        return new ObjectUuidPK(this.getCurrentUser().getId());
    }

    private FullOrgUnitInfo getSelectedOrgInfo() {
        if (this.pmtOrg.getData() == null) {
            return null;
        }
        if (this.pmtOrg.getData() instanceof FullOrgUnitInfo) {
            return (FullOrgUnitInfo)this.pmtOrg.getData();
        }
        return null;
    }

    private CtrlUnitInfo getSelectedCtrlInfo() {
        if (this.pmtCtrlUnit.getData() instanceof CtrlUnitInfo) {
            return (CtrlUnitInfo)this.pmtCtrlUnit.getData();
        }
        return null;
    }

    private IObjectPK getSelectedOrgPK() {
        if (this.getSelectedOrgInfo() == null) {
            return null;
        }
        return new ObjectUuidPK(this.getSelectedOrgInfo().getId());
    }

    @Override
    protected void lstAll_mouseClicked(MouseEvent e) throws Exception {
        super.lstAll_mouseClicked(e);
        if (e.getClickCount() == 2 && e.getButton() == 1) {
            this.getRoleAssignHelper().addSingleRole();
        }
    }

    @Override
    protected void lstGrant_mouseClicked(MouseEvent e) throws Exception {
        if (e.getClickCount() == 2 && e.getButton() == 1) {
            this.getRoleAssignHelper().delSingleRole();
        }
    }

    @Override
    protected void lstAssign_mouseClicked(MouseEvent e) throws Exception {
        super.lstAssign_mouseClicked(e);
        if (e.getClickCount() == 2 && e.getButton() == 1) {
            this.getRoleAssignHelper().delSingleRole();
        }
    }

    private void checkOrgSelected() {
        if (this.getSelectedOrgInfo() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"orgIsNotSelected"));
            this.abort();
        }
    }

    private void alertSave(SelectorEvent e) throws Exception {
        int isYes;
        if (this.getSelectedOrgInfo() != null && this.isModify() && MsgBox.isYes((int)(isYes = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"alertSave"))))) {
            this.save();
            e.setCanceled(true);
            this.getRoleAssignHelper().setModify(false);
        }
    }

    private boolean isModify() {
        return this.getRoleAssignHelper().isModify();
    }

    @Override
    public void actionViewRolePerm_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewRolePerm_actionPerformed(e);
        this.getRoleAssignHelper().checkRoleIsSelected();
        LongTimeDialog dialog = UITools.getDialog((Component)((Object)this));
        dialog.setLongTimeTask(new ILongTimeTask(){

            @Override
            public Object exec() throws Exception {
                UIContext uiContext = new UIContext((Object)UserAssignRoleUI.this);
                RoleInfo roleInfo = UserAssignRoleUI.this.getSelectedRole();
                uiContext.put((Object)"targetID", (Object)roleInfo.getId().toString());
                uiContext.put((Object)"name", (Object)roleInfo.getName());
                return UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(RolePermViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            }

            @Override
            public void afterExec(Object result) throws Exception {
                UITools.showObject(result);
            }
        });
        dialog.show();
    }

    private RoleInfo getSelectedRole() {
        return (RoleInfo)this.lstAll.getSelectedValue();
    }

    @Override
    protected void lstAll_valueChanged(ListSelectionEvent e) throws Exception {
        super.lstAll_valueChanged(e);
        this.btnViewRolePerm.setEnabled(this.lstAll.getModel().getSize() > 0);
    }

    protected void showResultMessage(String message) {
        this.setMessageText(EASResource.getString((String)message));
        this.showMessage();
    }

    public boolean checkBeforeWindowClosing() {
        if (this.getRoleAssignHelper().isModify()) {
            int isYes = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"alertSave"));
            if (MsgBox.isYes((int)isYes)) {
                try {
                    this.save();
                    return true;
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                    return false;
                }
            }
            return !MsgBox.isCancel((int)isYes);
        }
        return true;
    }

    private String getAllRoleIds(String newRoleIds, String deleteRoleIds) {
        if ("''".equals(newRoleIds)) {
            newRoleIds = "";
        }
        if ("''".equals(deleteRoleIds)) {
            deleteRoleIds = "";
        }
        String allRoleIds = !StringUtils.isEmpty((String)newRoleIds) && !StringUtils.isEmpty((String)deleteRoleIds) ? newRoleIds + "," + deleteRoleIds : (!StringUtils.isEmpty((String)newRoleIds) ? newRoleIds : deleteRoleIds);
        return allRoleIds;
    }

    @Override
    public void actionSearchRole_actionPerformed(ActionEvent e) throws Exception {
        String content = this.txtInput.getText();
        if (StringUtils.isEmpty((String)content)) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"pls_input_rolenumber"));
            return;
        }
        if (this.selectedIndex == this.lstAll.getElementCount()) {
            this.selectedIndex = 0;
        }
        for (int i = this.selectedIndex; i < this.lstAll.getElementCount(); ++i) {
            ++this.selectedIndex;
            RoleInfo role = (RoleInfo)this.lstAll.getElement(i);
            if (role.getNumber().toUpperCase().indexOf(content.toUpperCase()) >= 0 || role.getName().toUpperCase().indexOf(content.toUpperCase()) >= 0) {
                this.lstAll.setSelectedIndex(i);
                this.lstAll.ensureIndexIsVisible(i);
                this.isFound = true;
                if (i != this.selectedIndex) break;
                ++this.selectedIndex;
                break;
            }
            if (!this.isFound || i != this.lstAll.getElementCount() - 1) continue;
            i = -1;
            this.selectedIndex = 0;
            this.isFound = false;
        }
        if (!this.isFound) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource", (String)"Msg_NoResult"));
        }
    }

    @Override
    protected void orgLeftChange(TreeSelectionEvent e) throws Exception {
        if (this.pmtOrg.getData() != null) {
            this.loadLeftRoleList();
        }
    }

    private void initRoleGroupTree() throws Exception {
        this.kDSplitPane1.setDividerLocation(0.55);
        this.kDTreeView1.setShowButton(false);
        this.kDTreeView1.setShowFind(true);
        this.treeBuilder = TreeBuilderFactory.createTreeBuilder((ILNTreeNodeCtrl)this.getLNTreeNodeCtrl(), (int)this.getTreeInitialLevel(), (int)this.getTreeExpandLevel(), (FilterInfo)this.getDefaultFilterForTree(), (SelectorItemCollection)this.getSelectorForTree());
        if (this.getRootName() != null) {
            KDTreeNode rootNode = new KDTreeNode(this.getRootObject());
            ((DefaultTreeModel)this.roleGroupTree.getModel()).setRoot((TreeNode)rootNode);
        } else {
            ((DefaultTreeModel)this.roleGroupTree.getModel()).setRoot(null);
        }
        this.treeBuilder.buildTree(this.roleGroupTree);
        this.roleGroupTree.setShowPopMenuDefaultItem(true);
    }

    private String getRootName() {
        return EASResource.getString((String)RESOURCE, (String)"roleGroup");
    }

    private Object getRootObject() {
        return this.getRootName();
    }

    private ILNTreeNodeCtrl getLNTreeNodeCtrl() throws Exception {
        return new DefaultLNTreeNodeCtrl(this.getTreeInterface());
    }

    private int getTreeInitialLevel() {
        return 3;
    }

    private int getTreeExpandLevel() {
        return 3;
    }

    private FilterInfo getDefaultFilterForTree() {
        return this.getDefaultCUFilter(this.isIgnoreTreeCUFilter());
    }

    private FilterInfo getDefaultCUFilter(boolean isIgnore) {
        FilterInfo filter = new FilterInfo();
        if (isIgnore) {
            return filter;
        }
        if (SysContext.getSysContext().getCurrentCtrlUnit() == null) {
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
        filter.setMaskString("#0 or #1 or #2");
        return filter;
    }

    private SelectorItemCollection getSelectorForTree() {
        return null;
    }

    private ITreeBase getTreeInterface() throws Exception {
        try {
            return RoleGroupFactory.getRemoteInstance();
        }
        catch (BOSException e) {
            this.handUIException(e);
            return null;
        }
    }

    private boolean isIgnoreTreeCUFilter() {
        return false;
    }

    private KDTreeNode getSelectedTreeNode() {
        return (KDTreeNode)this.roleGroupTree.getLastSelectedPathComponent();
    }
}

