/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.syncUI.ThreadPool;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.ActionCache;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractUserDeletedListUI;
import com.kingdee.eas.base.permission.client.NewUserPermViewUI;
import com.kingdee.eas.base.permission.client.UserAssignRoleUI;
import com.kingdee.eas.base.permission.client.UserEditUI;
import com.kingdee.eas.base.permission.client.UserListUIHelper;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class UserDeletedListUI
extends AbstractUserDeletedListUI {
    private static final Logger logger = CoreUIObject.getLogger(UserDeletedListUI.class);
    private static final String permissionResource = "com.kingdee.eas.base.permission.PermissionResource";
    boolean isRegister = false;
    private String curEditUserId = null;

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.put("getCurrentUser", (Object)ToolUtils.getCurrentUser().getId().toString());
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnRemove.setVisible(false);
        this.btnRemove.setEnabled(false);
        this.btnCallBack.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
        this.btnViewPerm.setIcon(EASResource.getIcon((String)"imgTbtn_userview"));
        this.btnViewRole.setIcon(EASResource.getIcon((String)"imgTbtn_userview"));
        this.btnViewUser.setIcon(EASResource.getIcon((String)"imgTbtn_userview"));
        try {
            this.isRegister = FrameWorkClientUtils.getLicenseController().isRegister();
        }
        catch (LicenseException e) {
            logger.error((Object)e);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    protected String getEditUIName() {
        return UserEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return UserFactory.getRemoteInstance();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        try {
            UserListUIHelper helper = new UserListUIHelper();
            return helper.getCurrentRangeUserMayBeAdmin();
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIException(e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIException(e);
        }
        catch (UuidException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIException(e);
        }
        catch (ParserException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIException(e);
        }
        return null;
    }

    @Override
    public boolean isPrepareActionCallBack() {
        return false;
    }

    @Override
    public RequestContext prepareActionCallBack(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionCallBack(itemAction);
        ArrayList userIdList = this.getSelectedIdValues();
        request.put("selectUsers", (Object)userIdList);
        return request;
    }

    @Override
    public void actionCallBack_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int isYes = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)permissionResource, (String)"IfCallBack"));
        if (MsgBox.isYes((int)isYes)) {
            ActionCache.clear();
            ArrayList userIdList = this.getSelectedIdValues();
            IUser iUser = UserFactory.getRemoteInstance();
            for (int i = 0; i < userIdList.size(); ++i) {
                UserInfo userInfo = (UserInfo)iUser.getValue((IObjectPK)new ObjectStringPK(userIdList.get(i).toString()));
                Map map = iUser.userInfoCheck((IObjectValue)userInfo);
                if (((Boolean)map.get("flag")).booleanValue()) continue;
                String msg = (String)map.get("msg");
                int isok = MsgBox.showConfirm2((Component)((Object)this), (String)msg);
                if (!MsgBox.isYes((int)isok)) {
                    return;
                }
                this.curEditUserId = userInfo.getId().toString();
                super.actionEdit_actionPerformed(e);
                this.curEditUserId = null;
                return;
            }
            iUser.callBackUser(userIdList);
            this.refreshList();
            if (this.isRegister) {
                MsgBox.showInfo((Component)((Object)this), (String)(EASResource.getString((String)"saveSuccessed") + "\r\n" + EASResource.getString((String)permissionResource, (String)"changeUserStateByState")));
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"saveSuccessed"));
            }
        }
    }

    private void checkSystemUser() throws Exception {
        if (Administrator.isCUAdmin(null, (IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)permissionResource, (String)"adminCanNotViewPerm"));
            this.abort();
        }
    }

    @Override
    public void actionViewPerm_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkSystemUser();
        LongTimeDialog dialog = UITools.getDialog((Component)((Object)this));
        dialog.setLongTimeTask(new ILongTimeTask(){

            @Override
            public Object exec() throws Exception {
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"targetID", (Object)UserDeletedListUI.this.getSelectedKeyValue());
                return UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(NewUserPermViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            }

            @Override
            public void afterExec(Object result) throws Exception {
                UITools.showObject(result);
                ThreadPool.destroyMonitor();
            }
        });
        dialog.show();
    }

    @Override
    public void actionViewRole_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"targetID", (Object)this.getSelectedKeyValue());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(UserAssignRoleUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionViewUser_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ActionCache.clear();
        int isYES = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)permissionResource, (String)"DeleteUserWarning"));
        if (MsgBox.isYes((int)isYES)) {
            IUser user = UserFactory.getRemoteInstance();
            boolean isOK = user.remove(this.getAllSelecteIDListValues());
            if (isOK) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)permissionResource, (String)"DeleteUserOK"));
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)permissionResource, (String)"DeleteUserError"));
            }
            this.execQuery();
        }
    }
}

