/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetListener;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.ConfigurationInfo;
import com.kingdee.eas.base.permission.DiscretePermCollection;
import com.kingdee.eas.base.permission.DiscretePermInfo;
import com.kingdee.eas.base.permission.DiscretePermissionFactory;
import com.kingdee.eas.base.permission.IDiscretePermission;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.IPermissionManager;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionManagerFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractUserDiscretePermViewUI;
import com.kingdee.eas.base.permission.client.DiscreteAccreditManager;
import com.kingdee.eas.base.permission.client.IDiscreteAccreditProvider;
import com.kingdee.eas.base.permission.client.PermItemCheckBoxGroup;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.OrgF7PromptDialog;
import com.kingdee.eas.basedata.org.client.service.OrgCommonCilentUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;

public class UserDiscretePermViewUI
extends AbstractUserDiscretePermViewUI {
    public static final String BOS_OBJECT_TYPE = "bosObjectType";
    public static final String TARGET_USER_PK = "targetUserPK";
    public static final String TARGET_ORG_PK = "targetOrgPK";
    private BOSObjectType bizObjectType = null;
    private QueryInfo bizQuery = null;
    private IObjectPK targetUserPK = null;
    private PermItemCheckBoxGroup checkBoxGroup = new PermItemCheckBoxGroup();
    private IDiscreteAccreditProvider discreteAccreditProvider = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadUIContext();
        this.initUI();
        this.setStatus();
        this.selectDefOrg();
    }

    private void selectDefOrg() throws EASBizException, BOSException {
        IObjectPK orgPK = this.getTargetOrgPK();
        if (orgPK != null) {
            FullOrgUnitInfo defOrgUnit = this.getOrg(this.getTargetOrgPK());
            this.pmtOrg.setData((Object)defOrgUnit);
        }
    }

    private IObjectPK getTargetOrgPK() {
        if (this.getUIContext().get(TARGET_ORG_PK) != null) {
            return (IObjectPK)this.getUIContext().get(TARGET_ORG_PK);
        }
        return null;
    }

    private FullOrgUnitInfo getOrg(IObjectPK orgPK) throws EASBizException, BOSException {
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
        return iFullOrgUnit.getFullOrgUnitInfo(orgPK);
    }

    private void setStatus() {
        this.pmtOrg.setEnabled(false);
        this.checkBoxGroup.setAllEnable(false);
    }

    private void loadUIContext() {
        if (this.getUIContext().get(BOS_OBJECT_TYPE) == null) {
            throw new IllegalArgumentException("discreteAccreditContext can not be NULL.");
        }
        this.bizObjectType = (BOSObjectType)this.getUIContext().get(BOS_OBJECT_TYPE);
        this.discreteAccreditProvider = DiscreteAccreditManager.getInstace().getProvider(this.bizObjectType);
        this.bizQuery = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(this.discreteAccreditProvider.getQueryPK());
        this.targetUserPK = (IObjectPK)this.getUIContext().get(TARGET_USER_PK);
    }

    private void initUI() throws EASBizException, BOSException {
        this.initUserF7();
        this.initBizDataContainer();
        this.initPermItemPanel();
    }

    private void initBizDataContainer() {
        this.initTable();
    }

    private void initPermItemPanel() throws EASBizException, BOSException {
        this.pnlPermItem.setLayout((LayoutManager)new FlowLayout(3));
        this.loadPermItems();
    }

    private void loadPermItems() throws EASBizException, BOSException {
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        Set permItemNames = (Set)iPermission.getConfigurationInfo().getDiscretEntityPermItems().get(this.bizObjectType.toString());
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", new HashSet(permItemNames), CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("enableDataPermission", (Object)new Integer(1)));
        entityViewInfo.setFilter(filterInfo);
        IPermItem iPermItem = PermItemFactory.getRemoteInstance();
        PermItemCollection permItems = iPermItem.getPermItemCollection(entityViewInfo);
        HashSet<ObjectUuidPK> setPermItemPK = new HashSet<ObjectUuidPK>();
        int size = permItems.size();
        for (int i = 0; i < size; ++i) {
            PermItemInfo permItemInfo = permItems.get(i);
            KDCheckBox checkBox = new KDCheckBox(permItemInfo.getAlias());
            checkBox.setUserObject((Object)permItemInfo);
            this.checkBoxGroup.addCheckBox(permItemInfo.getId(), checkBox);
            this.pnlPermItem.add((Component)checkBox);
            setPermItemPK.add(new ObjectUuidPK(permItemInfo.getId()));
        }
    }

    private OrgType getBizObjectOrgType() {
        String ORG_TYPE = "OrgType";
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entity = loader.getEntity(this.bizObjectType);
        if (StringUtils.isEmpty((String)entity.getExtendedProperty("OrgType"))) {
            return OrgType.NONE;
        }
        return OrgType.getEnum((String)entity.getExtendedProperty("OrgType"));
    }

    private OrgF7PromptDialog getOrgF7() throws EASBizException, BOSException {
        OrgF7PromptDialog orgF7 = null;
        OrgType orgType = this.getBizObjectOrgType();
        orgF7 = OrgCommonCilentUtils.createF7(null, (OrgType)orgType);
        this.pmtOrg.setSelector((KDPromptSelector)orgF7);
        if (!OrgType.NONE.equals((Object)orgType)) {
            IPermissionManager iPermissionManager = PermissionManagerFactory.getRemoteInstance();
            Map accreditOrgs = iPermissionManager.getAccreditOrgs(this.getCurrentCUPK(), this.getCurrentUserPK(), this.getSelectedUserPK());
            if (Administrator.isSuperCUAdmin(this.getCurrentUserPK())) {
                orgF7.setIsCUFilter(true, true);
                orgF7.setCurrentCUID("00000000-0000-0000-0000-000000000000CCE7AED4");
            } else {
                orgF7.setIsCUFilter(true);
                orgF7.setCurrentCUID(this.getCurrentCUPK().toString());
            }
            orgF7.disablePerm((HashMap)accreditOrgs);
        }
        orgF7.setMultiSelect(false);
        return orgF7;
    }

    private IObjectPK getCurrentCUPK() {
        return new ObjectUuidPK(SysContext.getSysContext().getCurrentCtrlUnit().getId());
    }

    private void initUserF7() throws BOSException, EASBizException {
        if (this.targetUserPK != null) {
            IUser iUser = UserFactory.getRemoteInstance();
            UserInfo userInfo = iUser.getUserInfo(this.targetUserPK);
            this.pmtUser.setData((Object)userInfo);
            this.pmtUser.setEnabled(false);
        } else {
            IObjectPK currentUserPK = this.getCurrentUserPK();
            if (Administrator.isSuperCUAdmin(currentUserPK)) {
                this.pmtUser.setHasCUDefaultFilter(false);
            } else if (Administrator.isCUAdmin(null, currentUserPK)) {
                this.pmtUser.setEntityViewInfo(this.getCUAdminUserCondition());
            } else {
                this.pmtUser.setEntityViewInfo(this.getCommonUserCondition(this.getCurrentCUPK()));
            }
            this.pmtUser.setEnabledMultiSelection(false);
        }
    }

    private EntityViewInfo getCommonUserCondition(IObjectPK userPK) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT FUserID FROM T_PM_OrgRange ").append(" WHERE FOrgID IN (SELECT FOrgID FROM T_PM_OrgRange ").append(" WHERE FUserID = '").append(userPK).append("' ").append(" AND FType = ").append(10).append(") ").append(" AND FType = ").append(10).append(" ").append(" AND FUserID <> '").append(userPK.toString()).append("' ");
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)buffer.toString(), CompareType.INNER));
        entityViewInfo.setFilter(filterInfo);
        return entityViewInfo;
    }

    private EntityViewInfo getCUAdminUserCondition() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT OrgRange.FUserID FROM T_PM_OrgRange OrgRange ").append(" INNER JOIN T_ORG_BaseUnit BaseUnit ON BaseUnit.FID = OrgRange.FOrgID ").append(" WHERE OrgRange.FType = ").append(10).append(" ").append(" AND BaseUnit.FControlUnitID = '").append(this.getCurrentCUPK().toString()).append("' ").append(" AND OrgRange.FUserID <> '").append(this.getCurrentUserPK().toString()).append("' ");
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)buffer.toString(), CompareType.INNER));
        entityViewInfo.setFilter(filterInfo);
        return entityViewInfo;
    }

    private void initTable() {
        this.contBizData.getContentPane().add((Component)this.table, "Center");
        this.table.getStyleAttributes().setLocked(true);
        this.table.getSelectManager().setSelectMode(2);
        this.table.getDataRequestManager().setDataRequestMode(1);
        this.table.addRequestRowSetListener(new RequestRowSetListener(){

            public void doRequestRowSet(RequestRowSetEvent e) {
                UserDiscretePermViewUI.this.requestRowSet(e);
            }
        });
        this.fillTableHeader();
    }

    private void fillTableHeader() {
        String IS_VISIBLE_FOR_KDTABLE = "isVisibleForKDTable";
        String COL_WIDTH_IN_KDTABLE = "ColWidthInKDTable";
        String DISPLAY_FORMAT = "displayFormat";
        String QUERY = "query";
        this.table.setRefresh(false);
        SelectorInfo selector = this.bizQuery.getSelector();
        int size = selector.getFields().size();
        QueryFieldInfo field = null;
        String[] bindContents = new String[size];
        Map exProperties = this.bizQuery.getExtendedProperties();
        for (int i = 0; i < size; ++i) {
            String colFormat;
            IColumn col = this.table.addColumn(i);
            field = (QueryFieldInfo)selector.getFields().get(i);
            exProperties = field.getExtendedProperties();
            bindContents[i] = field.getName();
            col.setKey(bindContents[i]);
            if (exProperties == null) continue;
            Object objectVisible = exProperties.get("isVisibleForKDTable");
            boolean visible = true;
            if (objectVisible instanceof Boolean) {
                visible = (Boolean)objectVisible;
            } else if (objectVisible instanceof String) {
                visible = objectVisible == null ? true : Boolean.valueOf((String)objectVisible);
            }
            col.getStyleAttributes().setHided(!visible);
            Object objectColWidth = exProperties.get("ColWidthInKDTable");
            int colWidth = 100;
            if (objectColWidth instanceof Integer) {
                colWidth = (Integer)objectColWidth;
            } else if (objectColWidth instanceof String) {
                colWidth = Integer.parseInt((String)objectColWidth);
            }
            col.setWidth(colWidth);
            Object objColFormat = exProperties.get("displayFormat");
            if (!(objColFormat instanceof String) || StringUtils.isEmpty((String)(colFormat = (String)objColFormat))) continue;
            col.getStyleAttributes().setNumberFormat(colFormat);
        }
        this.table.putBindContents("query", bindContents);
        this.table.checkParsed(true);
        IRow row = this.table.addHeadRow();
        for (int i = 0; i < size; ++i) {
            field = (QueryFieldInfo)selector.getFields().get(i);
            String displayName = field.getDisplayName();
            row.getCell(i).setValue((Object)displayName);
        }
        this.table.setRefresh(true);
    }

    private boolean needRequestData() {
        return this.pmtOrg.getData() != null && this.pmtUser.getData() != null;
    }

    private void refreshUI() {
        boolean flag = this.getSelectedOrgPK() != null;
        this.table.removeRows(flag);
        this.checkBoxGroup.setAllSelected(false);
        this.checkBoxGroup.setAllEnable(false);
    }

    @Override
    protected void pmtUser_dataChanged(DataChangeEvent e) throws Exception {
        super.pmtUser_dataChanged(e);
        this.setOrgF7();
        this.refreshUI();
    }

    private void setOrgF7() throws EASBizException, BOSException {
        IObjectPK selectedUserPK = this.getSelectedUserPK();
        if (selectedUserPK != null) {
            this.lbcOrg.remove((Component)this.pmtOrg);
            this.pmtOrg = new KDBizPromptBox();
            OrgF7PromptDialog orgF7 = this.getOrgF7();
            this.pmtOrg.setSelector((KDPromptSelector)orgF7);
            this.pmtOrg.addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    UserDiscretePermViewUI.this.refreshUI();
                }
            });
            this.lbcOrg.setBoundEditor((JComponent)this.pmtOrg);
        }
        if (OrgType.NONE.equals((Object)this.getMainBizOrgType())) {
            ObjectUuidPK sysCUPK = new ObjectUuidPK("11111111-1111-1111-1111-111111111111CCE7AED4");
            FullOrgUnitInfo sysOrg = new FullOrgUnitInfo();
            sysOrg.setId(BOSUuid.read((String)sysCUPK.toString()));
            this.pmtOrg.setEnabled(false);
            this.pmtOrg.setText("");
            this.pmtOrg.setData((Object)sysOrg);
        } else {
            this.pmtOrg.setData(null);
            this.pmtOrg.setEnabled(selectedUserPK != null);
        }
    }

    private FilterInfo getBizDataFilter(BOSObjectType objectType, IObjectPK userPK, IObjectPK orgPK, boolean isAuthorized) throws BOSException, EASBizException {
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        ConfigurationInfo configurationInfo = iPermission.getConfigurationInfo();
        StringBuffer buffer = new StringBuffer(100);
        buffer.append("SELECT DISTINCT FBizDataID FROM ").append(configurationInfo.getDiscretEntityTables().get(objectType.toString())).append(" WHERE FUserID = '").append(userPK.toString()).append("' AND ( FOrgID = '").append(orgPK.toString()).append("' ").append(" OR FOrgID = '").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("' ) ");
        FilterInfo filterInfo = new FilterInfo();
        CompareType compareType = isAuthorized ? CompareType.INNER : CompareType.NOTINNER;
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)buffer.toString(), compareType));
        return filterInfo;
    }

    private IObjectPK getCurrentUserPK() {
        return new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
    }

    private IObjectPK getSelectedOrgPK() {
        if (this.pmtOrg.getData() == null) {
            return null;
        }
        return new ObjectUuidPK(((OrgUnitInfo)this.pmtOrg.getData()).getId());
    }

    private IObjectPK getSelectedUserPK() {
        if (this.pmtUser.getData() == null) {
            return null;
        }
        return new ObjectUuidPK(((UserInfo)this.pmtUser.getData()).getId());
    }

    private IObjectPK getSelectedBizDataPK() {
        if (this.table.getSelectManager().size() != 0) {
            int rowIndex = this.table.getSelectManager().getActiveRowIndex();
            BOSUuid bizDataID = BOSUuid.read((String)this.table.getRow(rowIndex).getCell(this.getLogicPKField(this.bizQuery)).getValue().toString());
            return new ObjectUuidPK(bizDataID);
        }
        return null;
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK) {
        IQueryExecutor queryExecutor = null;
        queryExecutor = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExecutor.option().isAutoTranslateEnum = true;
        queryExecutor.option().isAutoTranslateBoolean = true;
        queryExecutor.option().isAutoIgnoreZero = true;
        return queryExecutor;
    }

    private String getLogicPKField(QueryInfo queryInfo) {
        assert (this.bizQuery.getQueryPK().getKeyPropertys().size() == 1);
        QueryFieldInfo queryFieldInfo = this.bizQuery.getQueryPK().getKeyPropertys().get(0);
        return (String)queryFieldInfo.get("name");
    }

    private void requestRowSet(RequestRowSetEvent e) {
        if (this.needRequestData()) {
            try {
                int start = (Integer)e.getParam1();
                int length = (Integer)e.getParam2();
                MetaDataPK queryPK = new MetaDataPK(this.bizQuery.getFullName());
                IQueryExecutor queryExecutor = this.getQueryExecutor((IMetaDataPK)queryPK);
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                FilterInfo filterInfo = this.getBizDataFilter(this.bizObjectType, this.getSelectedUserPK(), this.getSelectedOrgPK(), true);
                entityViewInfo.setFilter(filterInfo);
                queryExecutor.setObjectView(entityViewInfo);
                IRowSet rowSet = queryExecutor.executeQuery(start, length);
                e.setRowSet(rowSet);
            }
            catch (Exception e1) {
                this.handUIException(e1);
            }
        }
    }

    private DiscretePermCollection getDiscretePerms(IObjectPK bizDataPK) throws EASBizException, BOSException {
        IDiscretePermission iDiscretePermission = DiscretePermissionFactory.getRemoteInstance();
        DiscretePermCollection ddps = iDiscretePermission.getUserDiscretePerms(this.bizObjectType, this.getSelectedUserPK(), this.getSelectedOrgPK(), this.getSelectedBizDataPK());
        return ddps;
    }

    @Override
    protected void table_activeCellChanged(KDTActiveCellEvent e) throws Exception {
        super.table_activeCellChanged(e);
        this.checkBoxGroup.setAllSelected(false);
        if (e.getRowIndex() != -1) {
            DiscretePermCollection ddps = this.getDiscretePerms(this.getSelectedBizDataPK());
            int size = ddps.size();
            for (int i = 0; i < size; ++i) {
                DiscretePermInfo info = ddps.get(i);
                BOSUuid permItemID = info.getPermItem().getId();
                if (!this.checkBoxGroup.contains(permItemID)) continue;
                this.checkBoxGroup.setSingleSelected(permItemID, true);
            }
            this.checkBoxGroup.setAllEnable(true);
        } else {
            this.checkBoxGroup.setAllEnable(false);
        }
    }
}

