/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDInfoTip;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.ActionCache;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.ui.util.UIHelper;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.license.CloudRegistSrvAgentFactory;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.file.cloudRegist.CloudRegistUserInfo;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.util.MutilLangeToolForParam;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.AbstractUserType;
import com.kingdee.eas.base.permission.ActiveStateEnum;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.AuthenModeFactory;
import com.kingdee.eas.base.permission.AuthenModeTypeEnum;
import com.kingdee.eas.base.permission.ISecurity;
import com.kingdee.eas.base.permission.IUsbKeyUserMap;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.IUserFacade;
import com.kingdee.eas.base.permission.IUserGroupGFacade;
import com.kingdee.eas.base.permission.Locale;
import com.kingdee.eas.base.permission.LoginAuthorWayEnum;
import com.kingdee.eas.base.permission.MultiLangHelper;
import com.kingdee.eas.base.permission.OrgRangeIncludeSubOrgFactory;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.SecurityCollection;
import com.kingdee.eas.base.permission.SecurityException;
import com.kingdee.eas.base.permission.SecurityFactory;
import com.kingdee.eas.base.permission.SecurityInfo;
import com.kingdee.eas.base.permission.SynStateEnum;
import com.kingdee.eas.base.permission.UsbKeyUserMapFactory;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserFacadeFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserGroupFactory;
import com.kingdee.eas.base.permission.UserGroupGFacadeFactory;
import com.kingdee.eas.base.permission.UserGroupInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserLicenseGroupInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.base.permission.UserTypeFactory;
import com.kingdee.eas.base.permission.UserUpdateParam;
import com.kingdee.eas.base.permission.client.AbstractUserEditUI;
import com.kingdee.eas.base.permission.client.AuditAdminListUI;
import com.kingdee.eas.base.permission.client.CUAdminListUI;
import com.kingdee.eas.base.permission.client.IUserEditUI;
import com.kingdee.eas.base.permission.client.PasswordMaintainUI;
import com.kingdee.eas.base.permission.client.UserEdit4AdminUI;
import com.kingdee.eas.base.permission.client.UserEdit4AuditAdminUI;
import com.kingdee.eas.base.permission.client.UserEdit4AuthAdminUI;
import com.kingdee.eas.base.permission.client.UserEdit4UserUI;
import com.kingdee.eas.base.permission.client.helper.UIFunctionView;
import com.kingdee.eas.base.permission.client.helper.UserHelper;
import com.kingdee.eas.base.permission.client.orgrange.UserEditStateInfo;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.base.permission.service.OrgRangeService;
import com.kingdee.eas.base.permission.service.ValidateCommunicationFactory;
import com.kingdee.eas.base.permission.service.comstrategy.CommunicationInfo;
import com.kingdee.eas.base.permission.service.comstrategy.ValidateComResultInfo;
import com.kingdee.eas.base.permission.util.LowTimeHelper;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.base.permission.util.UserInfoHelper;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.AccreditPermF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.NewCtrlF7;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectValueForEditUIUtil;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.util.CryptException;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LowTimer;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class UserEditUI
extends AbstractUserEditUI {
    private static Logger logger = Logger.getLogger(UserEditUI.class);
    protected IUserEditUI iUserEditUI = null;
    static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    protected UserInfo userInfo = null;
    private String title = null;
    private UserInfo oldData = null;
    private boolean isSystem = false;
    private String oldCu = "";
    boolean isBizAdmin = this.getCurrentUser().isBizAdmin();
    private boolean isAddNewCUAdmin = false;
    private boolean isAddAuthenticateAdmin = false;
    private boolean isAddAuditAdmin = false;
    private boolean dataChange = false;
    private boolean isAuthenticateAdminEnabled = false;
    private boolean isAuditAdminEnable = false;
    private UserEditStateInfo userEditStateInfo = null;
    private boolean isRestoreCU = false;
    private boolean isInternation = false;
    UserHelper userhelper = new UserHelper();
    boolean isRegister = false;
    private static String DEF_HIGHT_LEVEL_PASSWRD_SECURITY_ID = "00000000-0000-0000-0000-0000000000033EE2C673";

    public UserEditUI() throws Exception {
        this.userEditStateInfo = new UserEditStateInfo();
    }

    private void initUI() throws Exception {
        UserType[] userTypes = null;
        if (this.isAddNewCUAdmin) {
            userTypes = new UserType[]{UserType.SYSTEM};
            this.chkIsBizAdmin.setVisible(false);
        } else if (this.isAddAuthenticateAdmin) {
            userTypes = new UserType[]{UserType.AUTHENTICATEADMIN};
            this.chkIsBizAdmin.setVisible(false);
        } else if (this.isAddAuditAdmin) {
            userTypes = new UserType[]{UserType.AUDITADMIN};
            this.chkIsBizAdmin.setVisible(false);
        } else {
            userTypes = this.isBizAdmin ? new UserType[]{UserType.PERSON, UserType.CUSTOMER, UserType.SUPPLIER, UserType.OTHER} : new UserType[]{UserType.PERSON, UserType.CUSTOMER, UserType.SUPPLIER, UserType.SYSTEM, UserType.OTHER};
        }
        this.cmbUserType.removeAllItems();
        this.cmbUserType.addItems((Object[])userTypes);
        this.cmbUserType.setSelectedItem((Object)UserType.PERSON);
        this.mlbUserRelation.setRequired(true);
        this.pmtGroup.setHasCUDefaultFilter(false);
        this.txtCU.setQueryInfo("com.kingdee.eas.basedata.framework.app.CtrlUnitQuery");
        this.txtCU.setCommitFormat("$number$");
        this.txtCU.setDisplayFormat("$name$");
        this.txtCU.setEditFormat("$number$");
        this.txtAdNumber.setEnabled(false);
        this.txtCell.setText("");
        this.txtHomePhone.setText("");
        this.txtOfficePhone.setText("");
        this.initDefaultOrgEditor();
        if (!OprtState.ADDNEW.equals(this.getOprtState()) && this.isRegister) {
            this.setBounds(new Rectangle(10, 10, 670, 600));
            this.lbcUserSynStatue.setBounds(new Rectangle(10, 360, 310, 19));
            this.tblUserGroupInfo.setBounds(new Rectangle(10, 385, 650, 150));
            this.txtUserSynStatue.setEnabled(false);
        } else {
            this.setBounds(new Rectangle(10, 10, 670, 350));
            this.lbcUserSynStatue.setVisible(false);
            this.tblUserGroupInfo.setVisible(false);
            this.txtUserSynStatue.setVisible(false);
        }
    }

    private void disableNumberAndDescription() {
        boolean forbidEdit = false;
        try {
            forbidEdit = Boolean.valueOf(ParamManager.getParamValue(null, null, (String)"ForbidChangeUserNumber"));
        }
        catch (BOSException be) {
            this.handleException((Exception)((Object)be));
        }
        catch (EASBizException ee) {
            this.handleException((Exception)((Object)ee));
        }
        if (forbidEdit && this.isUserRefered()) {
            this.txtNumber.setEditable(false);
            this.mlaDescription.setEditable(false);
        }
    }

    private boolean isUserRefered() {
        Object userId = this.getUIContext().get("ID");
        if (userId == null) {
            return false;
        }
        try {
            Class<?> fdcHelper = Class.forName("com.kingdee.eas.fdc.basedata.FDCHelper");
            Method check = fdcHelper.getDeclaredMethod("checkReferencedOfBaseData", Context.class, String.class, String.class);
            return (Boolean)check.invoke(null, null, "User", userId.toString());
        }
        catch (Exception e) {
            this.handleException(e);
            return false;
        }
    }

    private void initDefaultOrgEditor() throws Exception {
        this.pmtDefaultOrg.setCommitFormat("$number$");
        this.pmtDefaultOrg.setDisplayFormat("$name$");
        this.pmtDefaultOrg.setEditFormat("$number$");
        this.pmtDefaultOrg.setRequired(true);
        if (OprtState.EDIT.equals(this.getOprtState())) {
            AccreditPermF7PromptDialog orgF7 = new AccreditPermF7PromptDialog((IUIObject)this, this.getUserInfo(), false);
            orgF7.setMultiSelect(false);
            orgF7.setShowAssistantOrg(true);
            this.pmtDefaultOrg.setSelector((KDPromptSelector)orgF7);
            this.pmtDefaultOrg.setEditable(false);
        } else if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.pmtDefaultOrg.setValue(this.txtCU.getValue());
            this.pmtDefaultOrg.setEnabled(false);
        } else if (OprtState.VIEW.equals(this.getOprtState())) {
            this.pmtDefaultOrg.setEnabled(false);
        }
    }

    private void verifyUiSource() {
        Object obj = this.getUIContext().get("Owner");
        if (obj == null) {
            obj = "";
        }
        if (obj instanceof CUAdminListUI) {
            this.isAddNewCUAdmin = true;
        } else if (obj instanceof AuditAdminListUI) {
            this.isAddAuditAdmin = true;
        }
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        this.verifyUiSource();
        try {
            if (clientHanlder != null) {
                RequestContext request = new RequestContext();
                request.put("OprtState", (Object)this.getOprtState());
                request.put("getCurrentOrgUnit", (Object)SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType()).getId().toString());
                if (this.getUIContext().get("ID") != null) {
                    ObjectUuidPK oupk = new ObjectUuidPK(BOSUuid.read((String)this.getUIContext().get("ID").toString()));
                    request.put("userObjectUuidPK", (Object)oupk);
                }
                if (OprtState.ADDNEW.equals(this.getOprtState())) {
                    request.put("addnewUserInfo", (Object)this.createNewUser());
                }
                if (OprtState.EDIT.equals(this.getOprtState()) || OprtState.VIEW.equals(this.getOprtState())) {
                    request.setId(StringUtils.cnulls(this.getUIContext().get("ID")));
                }
                request.put("getCurrentUserPK", (Object)ToolUtils.getCurrentUserPK());
                clientHanlder.setRequestContext((Serializable)request);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return clientHanlder;
    }

    public void onLoad() throws Exception {
        CommunicationInfo communicationInfo;
        try {
            this.isRegister = FrameWorkClientUtils.getLicenseController().isRegister();
        }
        catch (LicenseException e) {
            logger.error((Object)e);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        this.userhelper.setEditUI(this);
        if (!this.checkLicenseIsUserType()) {
            this.btnAddNew.setVisible(true);
        }
        LowTimeHelper lowTimer = new LowTimeHelper();
        this.isAuthenticateAdminEnabled = PermissionCommonUtil.isAuthenAddnewUserEnabled(null);
        this.verifyUiSource();
        lowTimer.printTime2Last("verifyUiSourceTime");
        this.pmtGroup.setEnabledMultiSelection(true);
        super.onLoad();
        lowTimer.printTime2Last("superOnLoadTime ");
        this.initUI();
        lowTimer.printTime2Last("initUI ");
        this.title = this.getUITitle();
        lowTimer.printTime2Last("getUITitle ");
        this.loadFields();
        this.getUIContext().put("CURRENT.VO", this.userInfo);
        lowTimer.printTime2Last("loadFields ");
        this.setOrgSelectData();
        lowTimer.printTime2Last("setOrgSelectData ");
        this.userEditStateInfo.setInit_over(true);
        this.kBlobalRoaming.setRequired(true);
        this.txtNCell.setRequired(true);
        if (this.userInfo.getId() != null && "00000000-0000-0000-0000-00000000000013B7DE7F".equals(this.userInfo.getId().toString())) {
            this.txtNumber.setEnabled(false);
        }
        if (Administrator.isDefaultUser(this.userInfo.getId())) {
            this.txtEmail.setRequired(false);
            this.kBlobalRoaming.setRequired(false);
            this.txtNCell.setRequired(false);
        } else if (this.isRegister && (communicationInfo = ValidateCommunicationFactory.getRemoteInstance().getCloudCommunicationStategy()) != null) {
            if (1 == communicationInfo.getNeedEmail()) {
                this.txtEmail.setRequired(true);
            }
            if (1 != communicationInfo.getNeedPhone() && 2 != communicationInfo.getNeedPhone()) {
                this.kBlobalRoaming.setRequired(false);
                this.txtNCell.setRequired(false);
            }
        }
        final KDInfoTip cellTip = new KDInfoTip((JComponent)this.txtNCell, EASResource.getString((String)RESOURCE, (String)"CELL_FORMAT"));
        cellTip.setMaxRenderWidth(260.0f);
        this.txtNCell.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    cellTip.setShowing(false);
                }
                catch (Exception exc) {
                    UserEditUI.this.handUIException(exc);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                try {
                    cellTip.setShowing(true);
                }
                catch (Exception exc) {
                    UserEditUI.this.handUIException(exc);
                }
            }
        });
        this.kBlobalRoaming.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7GlobalRoamingQuery");
        this.kBlobalRoaming.setCommitFormat("$areaCode$");
        this.kBlobalRoaming.setDisplayFormat("$areaCode$");
        this.kBlobalRoaming.setEditFormat("$areaCode$");
        this.kBlobalRoaming.setEditable(false);
    }

    private void setOrgSelectData() throws EASBizException, BOSException, Exception {
        UserInfo currentUserInfo;
        NewCtrlF7 ctrlUnitF7 = this.iUserEditUI.initCtrlOrgF7(this.userInfo);
        this.txtCU.setSelector((KDPromptSelector)ctrlUnitF7);
        if (this.txtCU.getData() == null && this.getCurrentUserByEdit() != null) {
            this.txtCU.setData((Object)this.getCurrentUserByEdit().getCU());
        }
        if ((currentUserInfo = SysContext.getSysContext().getCurrentUserInfo()) == null) {
            return;
        }
        ObjectUuidPK currentUserPK = new ObjectUuidPK(currentUserInfo.getId());
        boolean isBizAdmin = currentUserInfo.isBizAdmin();
        if (isBizAdmin && OprtState.ADDNEW.equalsIgnoreCase(this.getOprtState())) {
            this.txtCU.setData(null);
        }
        if (Administrator.isSuperCertifyAdmin((IObjectPK)currentUserPK) && OprtState.ADDNEW.equalsIgnoreCase(this.getOprtState())) {
            Object orgInfoObj = this.getUIContext().get("ParentNode");
            if (!FullOrgUnitInfo.class.isInstance(orgInfoObj)) {
                return;
            }
            FullOrgUnitInfo fullOrgInfo = (FullOrgUnitInfo)orgInfoObj;
            ObjectUuidPK orgPK = new ObjectUuidPK(fullOrgInfo.getId());
            CtrlUnitInfo ctrlUnitInfo = CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo((IObjectPK)orgPK);
            this.txtCU.setData((Object)ctrlUnitInfo);
        }
    }

    private UserType getUserType() {
        Object object = this.cmbUserType.getSelectedItem();
        if (object == null || object.equals("")) {
            return UserType.PERSON;
        }
        return (UserType)((Object)object);
    }

    protected void setUserRelationF7() {
        try {
            this.pmtUserRelation.setRequired(true);
            this.lbcUserRelation.setBoundEditor((JComponent)this.pmtUserRelation);
            this.pmtUserRelation.setEditFormat("$name$");
            this.pmtUserRelation.setDisplayFormat("$name$($number$)");
            this.pmtUserRelation.setCommitFormat("$name$");
            this.pmtUserRelation.setVisible(true);
            this.pmtUserRelation.setEditable(false);
            this.mlbUserRelation.setVisible(false);
            this.pmtUserRelation.setEntityViewInfo(null);
            this.pmtUserRelation.setQueryInfo(null);
            this.pmtUserRelation.setSelector(null);
            if (UserType.OTHER.equals((Object)this.getUserType()) || Administrator.isAdminType(this.getUserType())) {
                this.pmtUserRelation.setVisible(false);
                this.mlbUserRelation.setVisible(true);
                LanguageInfo languageInfo = new LanguageInfo(SysContext.getSysContext().getLocale());
                this.mlbUserRelation.setSelectedLanguage(languageInfo);
                this.mlbUserRelation.setRequired(true);
                this.lbcUserRelation.setBoundEditor((JComponent)this.mlbUserRelation);
            } else if (this.getUserType() != null) {
                try {
                    AbstractUserType userType = UserTypeFactory.getUserType(this.getUserType());
                    userType.setSelector(this.pmtUserRelation, this.getCurrentSelectCtrlUnit(), (Component)((Object)this));
                }
                catch (UserException e) {
                    logger.error((Object)"user Type not exist", (Throwable)((Object)e));
                    UserTypeFactory.getDefaultUserType().setSelector(this.pmtUserRelation, null, (Component)((Object)this));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            this.handleException(e);
        }
    }

    private void reloadUI() {
        this.userEditStateInfo.setInit_over(false);
        this.loadFields();
        this.userEditStateInfo.setInit_over(true);
    }

    private UserInfo getUserInfo() throws EASBizException, BOSException {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            UserInfo userInfo = this.createNewUser();
            return userInfo;
        }
        if (OprtState.VIEW.equals(this.getOprtState())) {
            IUser iUser = (IUser)this.getBizInterface();
            LowTimeHelper lowHelper = new LowTimeHelper();
            UserInfo userInfo = iUser.getUserInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getUIContext().get("ID").toString())), ToolUtils.getEditSelectors());
            lowHelper.printTime2Last("getUserInfo");
            return userInfo;
        }
        if (OprtState.EDIT.equals(this.getOprtState())) {
            IUser iUser = (IUser)this.getBizInterface();
            LowTimeHelper lowHelper = new LowTimeHelper();
            UserInfo userInfo = iUser.getUserInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getUIContext().get("ID").toString())), ToolUtils.getEditSelectors());
            lowHelper.printTime2Last("getUserInfo");
            if (StringUtils.isEmpty((String)userInfo.getDescription(MutilLangeToolForParam.LOCALE_CN)) && StringUtils.isEmpty((String)userInfo.getDescription(MutilLangeToolForParam.LOCALE_EN)) && StringUtils.isEmpty((String)userInfo.getDescription(MutilLangeToolForParam.LOCALE_WT))) {
                MutilLangeToolForParam.muti2Obj((String)"", (IObjectValue)userInfo, (String)"description");
            }
            return userInfo;
        }
        throw new IllegalArgumentException("UI' state " + this.getOprtState() + " is not supported");
    }

    public UserInfo createNewUser() {
        UserInfo info = UserInfoHelper.createNewDefaultUserInfo();
        if (this.isAddNewCUAdmin) {
            info.setType(UserType.SYSTEM);
        } else if (this.isAddAuthenticateAdmin) {
            info.setType(UserType.AUTHENTICATEADMIN);
        } else if (this.isAddAuditAdmin) {
            info.setType(UserType.AUDITADMIN);
        }
        info.setGroup(this.getUserGroupInfo());
        if (this.isBizAdmin) {
            info.setCU(this.getCurrentUser().getCU());
        } else {
            info.setCU(this.getCurrentCU());
        }
        OrgRangeInfo orgRangeInfo = new OrgRangeInfo();
        orgRangeInfo.setType(OrgRangeType.BIZ_ORG_TYPE);
        orgRangeInfo.setOrg(info.getCU().castToFullOrgUnitInfo());
        info.getOrgRange().add(orgRangeInfo);
        FullOrgUnitInfo cuFullOrgUnitInfo = new FullOrgUnitInfo();
        cuFullOrgUnitInfo.setId(info.getCU().getId());
        cuFullOrgUnitInfo.setNumber(info.getCU().getNumber());
        cuFullOrgUnitInfo.setName(info.getCU().getName());
        info.setDefOrgUnit(cuFullOrgUnitInfo);
        info.setChangedPW(false);
        return info;
    }

    protected CtrlUnitInfo getCurrentCU() {
        CtrlUnitInfo result = null;
        if (this.isAddAuthenticateAdmin || this.isAddAuditAdmin) {
            Object parentNode = this.getUIContext().get("ParentNode");
            if (parentNode == null) {
                result = SysContext.getSysContext().getCurrentCtrlUnit();
            } else {
                result = new CtrlUnitInfo();
                FullOrgUnitInfo fullOrgUnitInfo = (FullOrgUnitInfo)parentNode;
                result.setId(fullOrgUnitInfo.getId());
                result.setName(fullOrgUnitInfo.getName());
                result.setNumber(fullOrgUnitInfo.getNumber());
                result.setCU(fullOrgUnitInfo.getCU());
            }
        } else {
            result = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        result.put("name", result.get("name", SysContext.getSysContext().getLocale()));
        return result;
    }

    @Override
    public ICoreBase getBizInterface() throws BOSException {
        return UserFactory.getRemoteInstance();
    }

    protected UserGroupInfo getUserGroupInfo() {
        if (this.isAddAuthenticateAdmin || this.isAddAuditAdmin) {
            return null;
        }
        Object parentNode = this.getUIContext().get("ParentNode");
        return (UserGroupInfo)parentNode;
    }

    private void setComponentStatus() throws EASBizException, BOSException {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.setBaseInfoState(true);
            this.btnPassword.setVisible(false);
            this.btnAddNew.setEnabled(true);
            this.btnSubmit.setEnabled(true);
            this.lbcPassword.setVisible(true);
            this.lbcConfirmPassword.setVisible(true);
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            UIFunctionView uiFunctionView = UIFunctionView.getInstance();
            UserInfo curUserInfo = this.getCurrentUser();
            boolean curState = uiFunctionView.hasPermission(curUserInfo, this.userInfo, "UserEditUI", "FUNCTION_EIDT_BASEINFO");
            this.setBaseInfoState(curState);
            boolean userIsRelatdWithPerms = ((IUser)this.getBizInterface()).checkUserIsRelatedWithPerms((IObjectPK)new ObjectUuidPK(this.userInfo.getId()));
            boolean isBizAdmin = this.getCurrentUser().isBizAdmin();
            boolean isAdmin = Administrator.isAdmin(null, this.getCurrentUserPK());
            this.cmbUserType.setEnabled(curState && !userIsRelatdWithPerms);
            this.pmtUserRelation.setEnabled(curState && !UserType.OTHER.equals((Object)this.getUserType()) && !userIsRelatdWithPerms);
            this.pmtUserRelation.setEditable(curState && !UserType.OTHER.equals((Object)this.getUserType()) && !userIsRelatdWithPerms);
            this.mlbUserRelation.setEnabled(curState && !userIsRelatdWithPerms);
            this.mlbUserRelation.setEditable(curState && !userIsRelatdWithPerms);
            this.btnPassword.setVisible(uiFunctionView.hasPermission(curUserInfo, this.userInfo, "UserEditUI", "FUNCTION_SET_PWD"));
            this.btnAddNew.setEnabled(curState);
            this.btnSubmit.setEnabled(isAdmin || isBizAdmin);
            this.lbcPassword.setVisible(false);
            this.lbcConfirmPassword.setVisible(false);
            this.pmtUserRelation.setEnabled(this.cmbUserType.isEnabled());
        } else if (OprtState.VIEW.equals(this.getOprtState())) {
            this.setBaseInfoState(false);
            this.pmtUserRelation.setEnabled(false);
            this.mlbUserRelation.setEnabled(false);
            this.btnPassword.setVisible(false);
            this.btnAddNew.setEnabled(false);
            this.btnSubmit.setEnabled(false);
            this.lbcPassword.setVisible(false);
            this.labCell.setEnabled(false);
            this.txtNCell.setEnabled(false);
            this.lbcConfirmPassword.setVisible(false);
        }
    }

    private void setComponentLayout() {
        if (!OprtState.ADDNEW.equals(this.getOprtState())) {
            this.lbcPWEffectiveDate.setBounds(new Rectangle(10, 120, 310, 19));
            this.lbcPWInvaildDate.setBounds(new Rectangle(349, 120, 310, 19));
            this.lblPwdAuthorWay.setBounds(new Rectangle(10, 142, 310, 19));
            this.lbcDefaultOrg.setBounds(new Rectangle(10, 208, 310, 19));
            this.lblDescription.setBounds(new Rectangle(10, 230, 100, 19));
            this.mlaDescription.setBounds(new Rectangle(10, 252, 650, 94));
            this.labCell.setBounds(new Rectangle(349, 142, 195, 19));
            this.txtNCell.setBounds(new Rectangle(551, 142, 107, 19));
            this.labOfficePhone.setBounds(new Rectangle(349, 164, 310, 19));
            this.lablBackEmail.setBounds(new Rectangle(10, 186, 310, 19));
            this.labHomePhone.setBounds(new Rectangle(349, 186, 310, 19));
            this.labEmail.setBounds(new Rectangle(10, 164, 310, 19));
            this.lbcAdNumber.setBounds(new Rectangle(349, 208, 310, 19));
        } else {
            this.lbcPWEffectiveDate.setBounds(new Rectangle(10, 142, 310, 19));
            this.lbcPWInvaildDate.setBounds(new Rectangle(349, 142, 310, 19));
            this.lblPwdAuthorWay.setBounds(new Rectangle(10, 164, 310, 19));
            this.lbcDefaultOrg.setBounds(new Rectangle(10, 230, 310, 19));
            this.lblDescription.setBounds(new Rectangle(10, 252, 100, 19));
            this.mlaDescription.setBounds(new Rectangle(10, 274, 650, 60));
            this.labCell.setBounds(new Rectangle(349, 164, 195, 19));
            this.txtNCell.setBounds(new Rectangle(551, 164, 107, 19));
            this.labOfficePhone.setBounds(new Rectangle(349, 186, 310, 19));
            this.lablBackEmail.setBounds(new Rectangle(10, 208, 310, 19));
            this.labHomePhone.setBounds(new Rectangle(349, 208, 310, 19));
            this.labEmail.setBounds(new Rectangle(10, 186, 310, 19));
            this.lbcAdNumber.setBounds(new Rectangle(349, 229, 310, 19));
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.txtNumber.getText().trim().length() == 0) {
            this.txtNumber.requestFocus();
            throw new UserException(UserException.NUMBER_NOT_NULL);
        }
        if (StringUtils.isEmpty((String)StringUtils.cnulls((Object)this.txtCU.getData()))) {
            this.txtCU.requestFocus();
            throw new UserException(UserException.CU_IS_NULL_DETAIL);
        }
        if (this.txtNumber.getText().trim().indexOf("'") >= 0) {
            this.txtNumber.requestFocus();
            throw new UserException(UserException.NUMBER_INCLUDE_FORBIDDEN_CHAR);
        }
        if (this.cmbSecurity.getSelectedItem() == null) {
            this.cmbSecurity.requestFocus();
            throw new UserException(UserException.USER_NOT_SECURITY);
        }
        if (this.pmtDefaultOrg.getData() == null) {
            this.pmtDefaultOrg.requestFocus();
            throw new UserException(UserException.DEF_ORG_IS_NULL);
        }
        this.checkUserRealName();
        Date inuserDate = this.dpkInuseDate.getSqlDate();
        Date invalidDate = this.dpkInvaildDate.getSqlDate();
        if (inuserDate == null) {
            inuserDate = new Date();
        }
        if (invalidDate == null) {
            invalidDate = this.getDefaultInvalidDate().getTime();
        }
        if (DateTimeUtils.dayAfter((Date)inuserDate, (Date)invalidDate)) {
            this.dpkInuseDate.requestFocus();
            throw new UserException(UserException.USER_VALIDDATE_ERROR);
        }
        if (!StringUtils.isEmpty((String)this.txtBackEmail.getText()) && !this.checkMailAddress(this.txtBackEmail.getText().trim())) {
            this.txtBackEmail.requestFocusInWindow();
            throw new UserException(UserException.BACKEMAIL_ERROR);
        }
        UserInfo user = null;
        try {
            user = this.getUserInfo();
        }
        catch (Exception e1) {
            user = new UserInfo();
        }
        user.setCell(this.txtCell.getText());
        user.setEmail(this.txtEmail.getText());
        user.setType(this.getUserType());
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.verifyPassword(new String(this.pwdPassword.getPassword()), new String(this.pwdConfirmPassword.getPassword()));
        }
        if (Administrator.isDefaultUser(user.getId())) {
            return;
        }
        if (this.isRegister) {
            CommunicationInfo info = new CommunicationInfo();
            info.setEmail(this.txtEmail.getText());
            info.setPhone(user.getCell());
            ValidateComResultInfo resultInfo = ValidateCommunicationFactory.getRemoteInstance().ValidateCommunication(null, info);
            if (resultInfo != null && !resultInfo.isSuccess()) {
                throw new UserException(new NumericExceptionSubItem(resultInfo.getOprCode(), resultInfo.getOprMsg()));
            }
        }
    }

    private void sysnUserCell() throws EASBizException, BOSException {
        String cell = "";
        String areaCode = this.getAreaCodeBySelect(this.kBlobalRoaming.getData());
        if (!StringUtils.isEmpty((String)this.txtNCell.getText())) {
            if (StringUtils.isEmpty((String)areaCode)) {
                areaCode = "+86";
                DataBaseInfo info86 = UserFactory.getRemoteInstance().getGlobalRoaming("+86");
                this.kBlobalRoaming.setData((Object)info86);
            }
            cell = "+86".equals(areaCode) ? this.txtNCell.getText() : areaCode + "-" + this.txtNCell.getText();
        } else {
            this.kBlobalRoaming.setData(null);
            this.txtCell.setText(null);
        }
        this.txtCell.setText(cell);
    }

    protected boolean checkMailAddress(String email) {
        Pattern p = Pattern.compile("\\w+@(\\w+.)+[a-z]{2,3}");
        Matcher m = p.matcher(email);
        return m.matches();
    }

    protected boolean checkMobilePhone(String mobilePhone) throws UserException {
        if (StringUtils.isEmpty((String)this.txtCell.getText())) {
            if (this.isSystem || !this.isRegister) {
                return true;
            }
            if (OprtState.ADDNEW.equals(this.getOprtState())) {
                throw new UserException(UserException.CELL_NULL);
            }
            UserInfo user = null;
            try {
                user = this.getUserInfo();
            }
            catch (EASBizException eASBizException) {
            }
            catch (BOSException bOSException) {
                // empty catch block
            }
            if (user != null && user.getType() != UserType.SYSTEM && user.getType() != UserType.AUTHENTICATEADMIN && user.getType() != UserType.AUDITADMIN) {
                throw new UserException(UserException.CELL_NULL);
            }
            return true;
        }
        Pattern p = Pattern.compile("^[1]\\d{10}$");
        Matcher m = p.matcher(mobilePhone);
        return m.matches();
    }

    protected boolean checkPhone(String homePhone) {
        String format = "^[1]\\d{10}$";
        String format1 = "^((00\\d{2,3}-)?(0\\d{2,3})-)?(\\d{7,8})(-(\\d{3,}))?$";
        String format2 = "^\\d{4}$";
        Pattern p = Pattern.compile(format);
        Matcher m = p.matcher(homePhone);
        Pattern p1 = Pattern.compile(format1);
        Matcher m1 = p1.matcher(homePhone);
        Pattern p2 = Pattern.compile(format2);
        Matcher m2 = p2.matcher(homePhone);
        boolean isMatch = false;
        if (m.matches() || m1.matches() || m2.matches()) {
            isMatch = true;
        }
        return isMatch;
    }

    protected void checkUserRealName() {
        if (UserType.OTHER.equals((Object)this.getUserType()) || Administrator.isAdminType(this.getUserType())) {
            LanguageInfo languageInfo = new LanguageInfo(SysContext.getSysContext().getLocale());
            Object data = this.mlbUserRelation.getItemBy(languageInfo).getData();
            if (data != null && StringUtils.isEmpty((String)data.toString())) {
                this.mlbUserRelation.requestFocus();
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"userRealNameCanBeNull"));
                this.abort();
            }
        } else if (this.pmtUserRelation.getData() == null) {
            this.pmtUserRelation.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"userRealNameCanBeNull"));
            this.abort();
        }
    }

    private void verifyPassword(String password, String confirmPassword) throws EASBizException {
        if (password == null) {
            this.pwdPassword.requestFocus();
            throw new SecurityException(SecurityException.PASSWORD_TOO_SHORT);
        }
        if (password.indexOf("'") >= 0) {
            this.pwdPassword.requestFocus();
            throw new UserException(UserException.PASSWORD_INCLUDE_FORBIDDEN_CHAR);
        }
        if (confirmPassword == null) {
            this.pwdConfirmPassword.requestFocus();
            throw new UserException(UserException.CONFIRMED_PASSWORD_IS_NULL);
        }
        if (confirmPassword.indexOf("'") >= 0) {
            this.pwdConfirmPassword.requestFocus();
            throw new UserException(UserException.PASSWORD_INCLUDE_FORBIDDEN_CHAR);
        }
        if (!confirmPassword.equals(password)) {
            this.pwdConfirmPassword.requestFocus();
            throw new UserException(UserException.PASSWORD_NOT_MATCH);
        }
    }

    private SecurityCollection getSecurities(CtrlUnitInfo cuInfo) {
        SecurityCollection securities = null;
        try {
            StringBuffer buffer = new StringBuffer(200);
            buffer.append(" WHERE CU.id = '").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("' ");
            buffer.append(" OR CU.id = '").append("00000000-0000-0000-0000-000000000000CCE7AED4").append("' ");
            buffer.append(" OR CU.id = '").append(cuInfo.getId().toString()).append("' ");
            buffer.append(" ORDER BY number ");
            ISecurity iSecurity = SecurityFactory.getRemoteInstance();
            securities = iSecurity.getSecurityCollection(buffer.toString());
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return securities;
    }

    protected void tblAdminOrgRange_editValueChanged(KDTEditEvent e) throws Exception {
    }

    private void loadSecutity(CtrlUnitInfo cuInfo) throws EASBizException, BOSException {
        this.cmbSecurity.removeAllItems();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            SecurityCollection securities = this.getSecurities(cuInfo);
            if (securities != null && securities.size() > 0) {
                SecurityInfo defualtSecurity = SecurityFactory.getRemoteInstance().getDefualtSecurity();
                String defSecurityId = DEF_HIGHT_LEVEL_PASSWRD_SECURITY_ID;
                if (defualtSecurity != null) {
                    defSecurityId = defualtSecurity.getId().toString();
                }
                this.cmbSecurity.addItems(securities.toArray());
                int index = 0;
                for (int j = 0; j < securities.size(); ++j) {
                    SecurityInfo securityInfo = securities.get(j);
                    if (!defSecurityId.equals(securityInfo.getId().toString())) continue;
                    index = j;
                    break;
                }
                this.cmbSecurity.setSelectedIndex(index);
            }
        } else if (OprtState.EDIT.equals(this.getOprtState()) || OprtState.VIEW.equals(this.getOprtState())) {
            if (Administrator.isSuperCUAdmin((IObjectPK)new ObjectUuidPK(this.userInfo.getId())) || OrgRangeService.inCUOrgRange(null, ToolUtils.getCurrentUserPK(), this.userInfo.getCU().getId().toString())) {
                SecurityCollection securities = this.getSecurities(cuInfo);
                this.cmbSecurity.addItems(securities.toArray());
                int size = securities.size();
                for (int i = 0; i < size; ++i) {
                    if (securities == null || securities.get(i).getId() == null || this.userInfo.getSecurity() == null || !securities.get(i).getId().equals((Object)this.userInfo.getSecurity().getId())) continue;
                    this.cmbSecurity.setSelectedIndex(i);
                }
            } else if (this.userInfo.getSecurity() != null) {
                this.cmbSecurity.addItem((Object)this.userInfo.getSecurity());
            }
        }
    }

    @Override
    public void loadFields() {
        this.prepareLoadFields();
        this.loadUserSynInfo();
    }

    private void loadUserSynInfo() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            return;
        }
        UserInfo user = null;
        try {
            user = this.getUserInfo();
        }
        catch (EASBizException e) {
            logger.error((Object)"UserEditUI.loadUserSynInfo:getUserInfo1 error!");
        }
        catch (BOSException e) {
            logger.error((Object)"UserEditUI.loadUserSynInfo:getUserInfo2 error!");
        }
        if (user == null && user.getId() == null) {
            this.tblUserGroupInfo.removeRows();
            this.tblUserGroupInfo.addRow();
            this.tblUserGroupInfo.getRow(0).getCell(0).setValue((Object)EASResource.getString((String)RESOURCE, (String)"get_user_failed"));
            return;
        }
        Object cuInfo = null;
        List userLicensGroups = null;
        try {
            IUserFacade iuf = UserFacadeFactory.getRemoteInstance();
            userLicensGroups = iuf.getUserGroupList(user.getId().toString());
            if (SynStateEnum.SYN_YES.equals((Object)user.getIsSynToCloud())) {
                this.txtUserSynStatue.setText(EASResource.getString((String)RESOURCE, (String)"synchronized"));
            } else {
                this.txtUserSynStatue.setText(EASResource.getString((String)RESOURCE, (String)"not_synchronized"));
            }
            this.tblUserGroupInfo.setEnabled(false);
            this.tblUserGroupInfo.removeRows();
            if (userLicensGroups == null || userLicensGroups.size() == 0) {
                this.tblUserGroupInfo.addRow();
                this.tblUserGroupInfo.getRow(0).getCell(0).setValue((Object)EASResource.getString((String)RESOURCE, (String)"user_havenot_licensegroup"));
            } else {
                int len = userLicensGroups.size();
                for (int i = 0; i < len; ++i) {
                    UserLicenseGroupInfo ulgi = (UserLicenseGroupInfo)userLicensGroups.get(i);
                    this.tblUserGroupInfo.addRow();
                    this.tblUserGroupInfo.getRow(i).getCell(0).setValue((Object)(ulgi.getGroupNumber() + "(" + ulgi.getName() + ")"));
                    this.tblUserGroupInfo.getRow(i).getCell(1).setValue((Object)(1 == ulgi.getIsActive().getValue() ? ActiveStateEnum.Active_YES.getAlias(this.getLocale()) : ActiveStateEnum.Active_NO.getAlias(this.getLocale())));
                    try {
                        CloudRegistUserInfo cloudRegistUserInfo = CloudRegistSrvAgentFactory.getRemoteInstance().getCloudRegistUserInfo(user.getNumber());
                        if (cloudRegistUserInfo != null) {
                            Set groups = cloudRegistUserInfo.getGroup();
                            if (groups == null || groups.isEmpty() || !groups.contains(ulgi.getGroupNumber())) {
                                this.tblUserGroupInfo.getRow(i).getCell(2).setValue((Object)ActiveStateEnum.Active_NO.getAlias(this.getLocale()));
                                continue;
                            }
                            this.tblUserGroupInfo.getRow(i).getCell(2).setValue((Object)ActiveStateEnum.Active_YES.getAlias(this.getLocale()));
                            continue;
                        }
                        this.tblUserGroupInfo.getRow(i).getCell(2).setValue((Object)ActiveStateEnum.Active_NO.getAlias(this.getLocale()));
                        continue;
                    }
                    catch (LicenseException e) {
                        logger.error((Object)e);
                    }
                }
            }
        }
        catch (BOSException e) {
            this.tblUserGroupInfo.addRow();
            this.tblUserGroupInfo.getRow(0).getCell(0).setValue((Object)EASResource.getString((String)RESOURCE, (String)"get_user_failed"));
            logger.error((Object)"UserEditUI.loadUserSynInfo:BOSException !");
        }
        catch (EASBizException e) {
            this.tblUserGroupInfo.addRow();
            this.tblUserGroupInfo.getRow(0).getCell(0).setValue((Object)EASResource.getString((String)RESOURCE, (String)"get_user_failed"));
            logger.error((Object)"UserEditUI.loadUserSynInfo:EASBizException !");
        }
    }

    private void txtCuValuesChanged(DataChangeEvent e) {
        CtrlUnitInfo newSelectedCU = (CtrlUnitInfo)this.txtCU.getData();
        CtrlUnitInfo oldSelectedCU = (CtrlUnitInfo)e.getOldValue();
        OrgRangeInfo newOrgRangeInfo = new OrgRangeInfo();
        newOrgRangeInfo.setType(OrgRangeType.BIZ_ORG_TYPE);
        if (newSelectedCU == null) {
            newOrgRangeInfo.setOrg((FullOrgUnitInfo)null);
        } else {
            newOrgRangeInfo.setOrg(newSelectedCU.castToFullOrgUnitInfo());
        }
        OrgRangeInfo oldOrgRangeInfo = new OrgRangeInfo();
        oldOrgRangeInfo.setType(OrgRangeType.BIZ_ORG_TYPE);
        if (oldSelectedCU == null) {
            oldOrgRangeInfo.setOrg((FullOrgUnitInfo)null);
        } else {
            oldOrgRangeInfo.setOrg(oldSelectedCU.castToFullOrgUnitInfo());
        }
        this.userInfo.getOrgRange().remove(oldOrgRangeInfo);
        this.userInfo.getOrgRange().add(newOrgRangeInfo);
    }

    protected void prepareLoadFields() {
        try {
            DataBaseInfo info;
            this.userInfo = this.getUserInfo();
            this.setUserUI(this.userInfo);
            this.setComponentStatus();
            this.setComponentLayout();
            this.txtNumber.setText(this.userInfo.getNumber());
            this.txtAdNumber.setText(this.userInfo.getAdNumber());
            this.cmbUserType.setSelectedItem((Object)this.userInfo.getType());
            this.loadUserRelation();
            this.chkIsBizAdmin.setSelected(this.userInfo.isBizAdmin());
            try {
                this.pmtGroup.setData((Object)this.getGroups((IObjectPK)new ObjectUuidPK(this.userInfo.getId())).toArray());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (Administrator.isDefaultUser(this.userInfo.getId())) {
                this.kBlobalRoaming.setRequired(false);
                this.txtNCell.setRequired(false);
            }
            this.dpkInuseDate.setValue((Object)this.userInfo.getEffectiveDate());
            this.dpkInvaildDate.setValue((Object)this.userInfo.getInvalidationDate());
            this.cmbDefLang.setSelectedItem((Object)this.userInfo.getDefLocale());
            this.loadSecutity(this.userInfo.getCU());
            this.loadLoginAuthorWay();
            this.iUserEditUI.initUI(this.getOprtState());
            this.txtCU.setData((Object)this.userInfo.getCU());
            this.pmtDefaultOrg.setData((Object)this.userInfo.getDefOrgUnit());
            this.dpkPWEffectiveDate.setValue((Object)(this.userInfo.getPWEffectiveDate() == null ? new Date() : this.userInfo.getPWEffectiveDate()));
            this.loadPWInvaildDate();
            this.pwdPassword.setText(this.userInfo.getPassword());
            this.pwdConfirmPassword.setText(this.userInfo.getPassword());
            this.txtBackEmail.setText(this.userInfo.getBackupEMail());
            if (!StringUtils.isEmpty((String)this.userInfo.getGlobalRoaming())) {
                info = UserFactory.getRemoteInstance().getGlobalRoaming(this.userInfo.getGlobalRoaming());
                if (info != null) {
                    this.kBlobalRoaming.setData((Object)info);
                } else {
                    DataBaseInfo info86 = UserFactory.getRemoteInstance().getGlobalRoaming("+86");
                    this.kBlobalRoaming.setData((Object)info86);
                }
            }
            this.txtNCell.setText(this.userInfo.getNCell());
            this.txtEmail.setText(this.userInfo.getEmail());
            this.txtHomePhone.setText(this.userInfo.getHomePhone());
            this.txtOfficePhone.setText(this.userInfo.getOfficePhone());
            UIHelper.loadMultiLangFields((KDMultiLangBox)this.mlaDescription, (IObjectValue)this.userInfo, (String)"description");
            if (OprtState.ADDNEW.equals(this.oprtState)) {
                this.txtCU.setData((Object)SysContext.getSysContext().getCurrentCtrlUnit());
                this.pmtDefaultOrg.setData((Object)SysContext.getSysContext().getCurrentCtrlUnit().castToFullOrgUnitInfo());
                info = UserFactory.getRemoteInstance().getGlobalRoaming("+86");
                if (info != null) {
                    this.kBlobalRoaming.setData((Object)info);
                }
                this.prepareStoreFields();
            }
            this.oldData = (UserInfo)this.userInfo.clone();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void loadLoginAuthorWay() {
        this.bandingValue2Cmb(this.cmbPwdAuthorWay);
        if (this.userInfo != null && this.userInfo.getLoginAuthorWay() != null) {
            LoginAuthorWayEnum selectWayEnum = this.userInfo.getLoginAuthorWay();
            int size = this.cmbPwdAuthorWay.getItemCount();
            for (int i = 0; i < size; ++i) {
                if (selectWayEnum != this.cmbPwdAuthorWay.getItemAt(i)) continue;
                this.cmbPwdAuthorWay.setSelectedIndex(i);
            }
        }
    }

    private void bandingValue2Cmb(KDComboBox cmbBox) {
        if (cmbBox == null) {
            return;
        }
        cmbBox.removeAllItems();
        List loginAuthorEnumList = LoginAuthorWayEnum.getEnumList();
        int size = loginAuthorEnumList.size();
        for (int i = 0; i < size; ++i) {
            cmbBox.addItem((Object)((LoginAuthorWayEnum)((Object)loginAuthorEnumList.get(i))));
        }
    }

    private void setUserUI(UserInfo userInfo) {
        this.iUserEditUI = 10 == userInfo.getType().getValue() ? new UserEdit4AdminUI(this) : (60 == userInfo.getType().getValue() ? new UserEdit4AuthAdminUI(this) : (70 == userInfo.getType().getValue() ? new UserEdit4AuditAdminUI(this) : new UserEdit4UserUI(this)));
    }

    public void checkModified() throws Exception {
        if (this.isModify()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Check"));
            if (result == 0) {
                ActionEvent event = new ActionEvent(this.btnSubmit, 1001, this.btnSubmit.getActionCommand());
                this.actionSubmit.actionPerformed(event);
                if (this.actionSubmit.isInvokeFailed()) {
                    SysUtil.abort();
                }
            } else if (result == 2) {
                SysUtil.abort();
            }
        }
    }

    public boolean checkBeforeWindowClosing() {
        boolean flag = this.checkDefOrgUnit();
        if (!flag) {
            return false;
        }
        if (this.isModify()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
            if (result == 0) {
                try {
                    this.actionSubmit.setDaemonRun(false);
                    ActionEvent event = new ActionEvent(this.btnSubmit, 1001, this.btnSubmit.getActionCommand());
                    this.actionSubmit.actionPerformed(event);
                    return !this.actionSubmit.isInvokeFailed();
                }
                catch (Exception exc) {
                    return false;
                }
            }
            return result == 1;
        }
        return true;
    }

    public boolean checkDefOrgUnit() {
        if (OprtState.EDIT.equals(this.getOprtState()) && this.userInfo.getDefOrgUnit() == null) {
            int isYes = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"defOrgUnitIsNull"));
            return 0 == isYes;
        }
        return true;
    }

    public boolean isModify() {
        if (OprtState.VIEW.equals(this.getOprtState())) {
            return false;
        }
        try {
            this.storeFields();
        }
        catch (Exception exc) {
            return false;
        }
        UserInfo oldTemp = (UserInfo)this.oldData.clone();
        UserInfo newTemp = (UserInfo)this.userInfo.clone();
        oldTemp.setCell("");
        newTemp.setCell("");
        return !ObjectValueForEditUIUtil.objectValueEquals((AbstractObjectValue)oldTemp, (AbstractObjectValue)newTemp);
    }

    public boolean isDataChange() {
        return this.dataChange;
    }

    private void loadUserRelation() {
        this.setUserRelationF7();
        if (UserType.OTHER.equals((Object)this.getUserType()) || Administrator.isAdminType(this.getUserType())) {
            this.pmtUserRelation.setData(null);
            UIHelper.loadMultiLangFields((KDMultiLangBox)this.mlbUserRelation, (IObjectValue)this.userInfo, (String)"name");
        } else {
            try {
                try {
                    AbstractUserType userType = UserTypeFactory.getUserType(this.getUserType());
                    userType.loadData(this.userInfo, this.pmtUserRelation);
                }
                catch (UserException ue) {
                    logger.error((Object)"user type not exist", (Throwable)((Object)ue));
                    UserTypeFactory.getDefaultUserType().loadData(this.userInfo, this.pmtUserRelation);
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    private void setTilte() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.setUITitle(this.getUITitle() + EASResource.getString((String)RESOURCE, (String)"add"));
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            this.setUITitle(this.getUITitle() + EASResource.getString((String)RESOURCE, (String)"edit"));
        } else if (OprtState.VIEW.equals(this.getOprtState())) {
            this.setUITitle(this.getUITitle() + EASResource.getString((String)RESOURCE, (String)"view"));
        }
    }

    private void loadPWInvaildDate() {
        if (OprtState.EDIT.equals(this.getOprtState()) || OprtState.VIEW.equals(this.getOprtState())) {
            Object object = this.cmbSecurity.getSelectedItem();
            if (object != null && object instanceof SecurityInfo) {
                SecurityInfo securityInfo = (SecurityInfo)object;
                this.setComponentStatusOfPWInvaild(securityInfo);
            }
        } else if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.dpkPWInvaildDate.setValue((Object)this.getDefaultInvalidDate().getTime());
        } else {
            throw new IllegalArgumentException(" oprt:" + this.getOprtState() + " not supported");
        }
    }

    private UserInfo getCurrentUser() {
        return SysContext.getSysContext().getCurrentUserInfo();
    }

    private IObjectPK getCurrentUserPK() {
        return new ObjectUuidPK(this.getCurrentUser().getId());
    }

    @Override
    public void storeFields() {
        this.prepareStoreFields();
    }

    protected void prepareStoreFields() {
        UIHelper.storeMultiLangFields((KDMultiLangBox)this.mlaDescription, (IObjectValue)this.userInfo, (String)"description");
        this.userInfo.setNumber(this.txtNumber.getText().trim());
        this.userInfo.setType(this.getUserType());
        this.storeUserRelation();
        this.userInfo.setBizAdmin(this.chkIsBizAdmin.isSelected());
        Timestamp userEffectiveDate = (Timestamp)this.dpkInuseDate.getValue(Timestamp.class);
        if (userEffectiveDate == null) {
            userEffectiveDate = new Timestamp(new Date().getTime());
        }
        this.userInfo.setEffectiveDate(userEffectiveDate);
        Timestamp userInvalidDate = (Timestamp)this.dpkInvaildDate.getValue(Timestamp.class);
        if (userInvalidDate == null) {
            userInvalidDate = new Timestamp(this.getDefaultInvalidDate().getTimeInMillis());
        }
        this.userInfo.setInvalidationDate(userInvalidDate);
        Timestamp pwdEffectiveDate = (Timestamp)this.dpkPWEffectiveDate.getValue(Timestamp.class);
        if (pwdEffectiveDate == null) {
            pwdEffectiveDate = new Timestamp(new Date().getTime());
        }
        this.userInfo.setPWEffectiveDate(pwdEffectiveDate);
        SecurityInfo security = (SecurityInfo)this.cmbSecurity.getSelectedItem();
        this.userInfo.setSecurity(security);
        LoginAuthorWayEnum loginEnum = (LoginAuthorWayEnum)((Object)this.cmbPwdAuthorWay.getSelectedItem());
        this.userInfo.setLoginAuthorWay(loginEnum);
        this.userInfo.setDefLocale((Locale)((Object)this.cmbDefLang.getSelectedItem()));
        this.storePassword();
        this.userInfo.setBizAdmin(this.chkIsBizAdmin.isSelected());
        this.userInfo.setCU((CtrlUnitInfo)this.txtCU.getValue());
        this.userInfo.setDefOrgUnit((FullOrgUnitInfo)this.pmtDefaultOrg.getValue());
        this.userInfo.setAgentUser(false);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.userInfo.setIsRegister(!this.isAuthenticateAdminEnabled || this.userInfo.getType().equals((Object)UserType.AUTHENTICATEADMIN));
        }
        String areaCode = this.getAreaCodeBySelect(this.kBlobalRoaming.getData());
        this.userInfo.setGlobalRoaming(areaCode);
        this.userInfo.setNCell(this.txtNCell.getText().trim());
        this.userInfo.setCell(this.txtNCell.getText().trim());
        this.userInfo.setEmail(this.txtEmail.getText());
        this.userInfo.setBackupEMail(this.txtBackEmail.getText());
        this.userInfo.setOfficePhone(this.txtOfficePhone.getText());
        this.userInfo.setHomePhone(this.txtHomePhone.getText());
    }

    protected void storeUserRelation() {
        java.util.Locale[] locales = MultiLangHelper.getDefinedLocales(null);
        if (UserType.OTHER.equals((Object)this.getUserType()) || Administrator.isAdminType(this.getUserType())) {
            this.emptyTypeProperties();
            UIHelper.storeMultiLangFields((KDMultiLangBox)this.mlbUserRelation, (IObjectValue)this.userInfo, (String)"name");
        } else {
            this.emptyTypeProperties();
            IObjectValue objectValue = (IObjectValue)this.pmtUserRelation.getData();
            try {
                AbstractUserType userType = UserTypeFactory.getUserType(this.getUserType());
                userType.storeData(this.userInfo, this.pmtUserRelation);
            }
            catch (UserException ue) {
                logger.error((Object)"user type not exist", (Throwable)((Object)ue));
                UserTypeFactory.getDefaultUserType().storeData(this.userInfo, this.pmtUserRelation);
            }
            if (objectValue != null) {
                MultiLangHelper.copyMultiLangProperty(objectValue, (IObjectValue)this.userInfo, "name", locales);
            }
        }
    }

    private void emptyTypeProperties() {
        this.userInfo.setPerson(null);
        this.userInfo.setCustomerID(null);
        this.userInfo.setSupplierID(null);
        this.userInfo.setReferId(null);
    }

    private void storePassword() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            String password = new String(this.pwdPassword.getPassword());
            try {
                password = CryptoTean.encrypt((String)this.userInfo.getNumber(), (String)password);
            }
            catch (CryptException e) {
                this.handUIException(e);
            }
            this.userInfo.setPassword(password);
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            this.userInfo.setDefOrgUnit(this.getDefOrg());
        }
    }

    private FullOrgUnitInfo getDefOrg() {
        return null;
    }

    @Override
    public boolean isPrepareActionSubmit() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.sysnUserCell();
        this.verifyInput(e);
        this.storeFields();
        ObjectUuidPK userPK = null;
        Set<String> groupIDs = this.getGroupID();
        IUser iUser = (IUser)this.getBizInterface();
        IUserGroupGFacade iUserGroupGFacade = UserGroupGFacadeFactory.getRemoteInstance();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            String deletedUserID = iUser.getDeletedUserID(this.userInfo.getNumber());
            if (StringUtils.isEmpty((String)deletedUserID)) {
                if (this.isPrepareActionSubmit() && ActionCache.get((Object)"Fw_ObjectPK") != null) {
                    userPK = (IObjectPK)ActionCache.get((Object)"Fw_ObjectPK");
                } else {
                    String msg;
                    boolean isEnabledAuthen = AuthenModeFactory.getRemoteInstance().isEnabled(AuthenModeTypeEnum.NewUserAuthen);
                    if (isEnabledAuthen && MsgBox.showConfirm2((Component)((Object)this), (String)(msg = EASResource.getString((String)RESOURCE, (String)"addnew_user_need_authen"))) == 2) {
                        SysUtil.abort();
                    }
                    try {
                        userPK = iUser.addnew((CoreBaseInfo)this.userInfo);
                    }
                    catch (BOSException be) {
                        if (be.getMessage() != null && be.getMessage().contains(EASResource.getString((String)RESOURCE, (String)"addnew_user_fail_because_of_no_authentor"))) {
                            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"addnew_user_fail_because_of_no_authentor"));
                            return;
                        }
                        throw be;
                    }
                    if (userPK != null && !groupIDs.isEmpty()) {
                        iUserGroupGFacade.addNew((IObjectPK)userPK, groupIDs);
                    }
                }
                this.userInfo.setId(BOSUuid.read((String)userPK.toString()));
            } else {
                SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
                selectorItemCollection.add("*");
                UserInfo deleteUserInfo = ToolUtils.getUserInfo(null, deletedUserID, selectorItemCollection);
                String cuIdStr = null;
                if (deleteUserInfo != null && deleteUserInfo.getCU() != null) {
                    cuIdStr = deleteUserInfo.getCU().getId().toString();
                }
                if (!StringUtils.isEmpty(cuIdStr) && PermissionRangeHelper.inCUOrgRange(null, ToolUtils.getCurrentUserPK(), cuIdStr)) {
                    int isYes = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"recycleUserAlert"));
                    if (!MsgBox.isYes((int)isYes)) {
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"userNumberIsExistd"));
                        return;
                    }
                    userPK = new ObjectUuidPK(deletedUserID);
                    if (!this.usbKeyUserConfirmOK(deleteUserInfo)) {
                        return;
                    }
                    ArrayList<String> userIdList = new ArrayList<String>();
                    userIdList.add(deleteUserInfo.getId().toString());
                    iUser.callBackUser(userIdList);
                    deleteUserInfo.setIsDelete(false);
                    UserFactory.getRemoteInstance().update((IObjectPK)userPK, (CoreBaseInfo)deleteUserInfo);
                } else {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"userNumberIsExistd"));
                    return;
                }
            }
            this.getUIContext().put("ID", userPK.toString());
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            if (this.isRegister && this.isKeyInfoChanged()) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"changeUserStateByKeyInfo"));
            }
            userPK = new ObjectUuidPK(this.userInfo.getId());
            if (!this.usbKeyUserConfirmOK(this.userInfo)) {
                return;
            }
            boolean isDeleteOldCuPerm = false;
            if (!this.oldData.getCU().getId().equals((Object)this.userInfo.getCU().getId())) {
                if (0 != MsgBox.showConfirm2((String)EASResource.getString((String)RESOURCE, (String)"ConfirmSwitchCU"))) {
                    return;
                }
                isDeleteOldCuPerm = true;
            }
            UserUpdateParam param = new UserUpdateParam();
            param.setUpdatePW(false);
            param.setUpdateOrgRange(false);
            param.setDeleteOldCuPerm(isDeleteOldCuPerm);
            iUser.update((IObjectPK)userPK, this.userInfo, param);
            this.oldData = (UserInfo)this.userInfo.clone();
            IObjectPK logPK = LogUtil.beginLog(null, (String)"UserEditUI.actionSubmit_actionPerformed(ActionEvent)", (BOSObjectType)new BOSObjectType("E66D0481"), (IObjectPK)userPK, (String)(EASResource.getString((String)RESOURCE, (String)"USER_GROUP_UPDATE") + "\uff1a" + ToolUtils.aryToStr(groupIDs.toArray(), true)));
            iUserGroupGFacade.update((IObjectPK)userPK, groupIDs);
            LogUtil.afterLog(null, (IObjectPK)logPK);
        }
        if (this.userInfo.getId() != null) {
            OrgRangeIncludeSubOrgFactory.getRemoteInstance().updateOrgRange(this.userInfo.getId().toString());
        }
        UITools.showMsg(this, EASResource.getString((String)RESOURCE, (String)"saveSucceed"), false);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.reloadUI();
        }
        this.dataChange = true;
        this.setUserSynState();
    }

    private void setUserSynState() throws EASBizException, BOSException {
        UserInfo userInfo = this.getUserInfo();
        if (userInfo == null) {
            return;
        }
        if (SynStateEnum.SYN_YES.equals((Object)userInfo.getIsSynToCloud())) {
            this.txtUserSynStatue.setText(EASResource.getString((String)RESOURCE, (String)"synchronized"));
        } else {
            this.txtUserSynStatue.setText(EASResource.getString((String)RESOURCE, (String)"not_synchronized"));
        }
        if (OprtState.EDIT.equals(this.getOprtState())) {
            this.userInfo.setIsSynToCloud(userInfo.getIsSynToCloud());
        }
    }

    private boolean usbKeyUserConfirmOK(UserInfo usbKeyUser) throws Exception {
        if (usbKeyUser == null || usbKeyUser.getLoginAuthorWay() == null) {
            return true;
        }
        if (usbKeyUser.getId() != null && LoginAuthorWayEnum.USBKEY == usbKeyUser.getLoginAuthorWay()) {
            try {
                IUsbKeyUserMap iUsbKeyUserMap = UsbKeyUserMapFactory.getRemoteInstance();
                if (!iUsbKeyUserMap.useUsbKey4User(usbKeyUser.getId().toString()) && !MsgBox.isOk((int)MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"usbkeyUserPrompt")))) {
                    return false;
                }
            }
            catch (Exception e) {
                logger.info((Object)"check usbkey user state error, not deal!", (Throwable)e);
            }
        }
        return true;
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkModified();
        super.actionAddNew_actionPerformed(e);
        this.setOprtState(OprtState.ADDNEW);
        this.userInfo = this.createNewUser();
        this.prepareLoadFields();
    }

    public boolean isPrepareActionAddOrg() {
        return false;
    }

    public boolean isPrepareActionDelOrg() {
        return false;
    }

    private void checkCUSelected() {
        if (this.txtCU.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"MUST_FIRST_SELECT_ORG"));
            this.abort();
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.setButtonDefaultStyl(this.btnAddNew);
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.setButtonDefaultStyl(this.btnSubmit);
        this.btnPassword.setIcon(EASResource.getIcon((String)"imgTbtn_setpassword"));
        this.txtCU.setEditable(true);
    }

    public void setBaseInfoState(boolean state) throws EASBizException, BOSException {
        this.txtNumber.setEnabled(state);
        this.pmtGroup.setEnabled(state);
        this.cmbUserType.setEnabled(state);
        this.pmtUserRelation.setEnabled(state);
        this.txtCU.setEnabled(state);
        this.cmbSecurity.setEnabled(state);
        this.dpkInuseDate.setEnabled(state);
        this.dpkInvaildDate.setEnabled(state);
        this.cmbDefLang.setEnabled(state);
        this.dpkPWEffectiveDate.setEnabled(state);
        this.dpkPWInvaildDate.setEnabled(false);
        this.chkIsBizAdmin.setEnabled(state);
        this.txtBackEmail.setEnabled(state);
        this.txtCell.setEnabled(state);
        this.txtEmail.setEnabled(state);
        this.txtHomePhone.setEnabled(state);
        this.txtOfficePhone.setEnabled(state);
        if (this.isBizAdmin) {
            this.chkIsBizAdmin.setEnabled(false);
        }
        this.cmbPwdAuthorWay.setEnabled(state);
        if (OprtState.EDIT.equals(this.getOprtState()) && Administrator.isSuperCertifyAdmin((IObjectPK)new ObjectUuidPK(this.getUIContext().get("ID").toString()))) {
            this.cmbPwdAuthorWay.setEnabled(false);
        } else if (this.isAuthenticateAdminEnabled && !UserType.AUTHENTICATEADMIN.equals((Object)this.getUserType())) {
            this.cmbPwdAuthorWay.setEnabled(false);
        } else {
            this.pmtUserRelation.setEditable(state);
        }
    }

    @Override
    public void actionPassword_actionPerformed(ActionEvent e) throws Exception {
        super.actionPassword_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"targetID", (Object)this.userInfo.getId().toString());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PasswordMaintainUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        uiWindow.show();
    }

    @Override
    protected void cmbSecurity_itemStateChanged(ItemEvent e) throws Exception {
        Object object;
        if (!this.userEditStateInfo.isInit_over()) {
            return;
        }
        super.cmbSecurity_itemStateChanged(e);
        if (e.getStateChange() == 1 && (object = this.cmbSecurity.getSelectedItem()) != null && object instanceof SecurityInfo) {
            SecurityInfo securityInfo = (SecurityInfo)object;
            this.setComponentStatusOfPWInvaild(securityInfo);
        }
    }

    private Date getPWInvaildDate(int days) {
        Calendar pwInvaildDate = Calendar.getInstance();
        Date pwEffectiveDate = (Date)this.dpkPWEffectiveDate.getValue();
        if (pwEffectiveDate == null) {
            pwEffectiveDate = new Date();
        }
        pwInvaildDate.setTime(pwEffectiveDate);
        pwInvaildDate.add(5, days);
        return pwInvaildDate.getTime();
    }

    private void setComponentStatusOfPWInvaild(SecurityInfo securityInfo) {
        if (securityInfo.isPasswordForever()) {
            this.dpkPWInvaildDate.setValue((Object)this.getDefaultInvalidDate().getTime());
        } else {
            this.dpkPWInvaildDate.setValue((Object)this.getPWInvaildDate(securityInfo.getPasswordCycle()));
        }
    }

    private Calendar getDefaultInvalidDate() {
        Calendar pwInvaildDate = Calendar.getInstance();
        pwInvaildDate.set(2099, 11, 31, 0, 0, 0);
        return pwInvaildDate;
    }

    @Override
    protected void dpkPWEffectiveDate_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.userEditStateInfo.isInit_over()) {
            return;
        }
        super.dpkPWEffectiveDate_dataChanged(e);
        Object object = this.cmbSecurity.getSelectedItem();
        if (object != null && object instanceof SecurityInfo) {
            SecurityInfo securityInfo = (SecurityInfo)object;
            this.setComponentStatusOfPWInvaild(securityInfo);
        }
    }

    @Override
    protected void cmbSecurity_mouseEntered(MouseEvent e) throws Exception {
        super.cmbSecurity_mouseEntered(e);
        Object object = this.cmbSecurity.getSelectedItem();
        if (object != null && object instanceof SecurityInfo) {
            Object[] objects;
            String str;
            StringBuffer sbTip = new StringBuffer();
            SecurityInfo securityInfo = (SecurityInfo)object;
            sbTip.append(EASResource.getString((String)RESOURCE, (String)"securityForever")).append(this.getYesOrNo(securityInfo.isPasswordForever()));
            if (!securityInfo.isPasswordForever()) {
                sbTip.append(EASResource.getString((String)RESOURCE, (String)"securityPasswordDay")).append(securityInfo.getPasswordCycle());
            }
            sbTip.append(EASResource.getString((String)RESOURCE, (String)"securityChangePassword")).append(this.getYesOrNo(securityInfo.isPasswordCanChg()));
            sbTip.append(EASResource.getString((String)RESOURCE, (String)"securityPasswordLength")).append(securityInfo.getPasswordLength());
            sbTip.append(EASResource.getString((String)RESOURCE, (String)"securityIsComplex")).append(this.getYesOrNo(securityInfo.isComplex()));
            sbTip.append(EASResource.getString((String)RESOURCE, (String)"securityIsRequireUpChar")).append(this.getYesOrNo(securityInfo.isRequireUpChar()));
            sbTip.append(EASResource.getString((String)RESOURCE, (String)"securityIsRequireLowChar")).append(this.getYesOrNo(securityInfo.isRequireLowChar()));
            sbTip.append(EASResource.getString((String)RESOURCE, (String)"securityIsRequireSpecialChar")).append(this.getYesOrNo(securityInfo.isRequireSpecialChar()));
            sbTip.append(EASResource.getString((String)RESOURCE, (String)"securityIsRequireNotIncludeNumber")).append(this.getYesOrNo(securityInfo.isRequireNotIncludeNumber()));
            sbTip.append(EASResource.getString((String)RESOURCE, (String)"securityIsRequireWeakPw")).append(this.getYesOrNo(securityInfo.isRequireWeakPw()));
            if (securityInfo.isEnableRepeatPw()) {
                str = EASResource.getString((String)RESOURCE, (String)"securityIsEnableRepeatPw");
                objects = new Object[]{new Integer(securityInfo.getRepeatTimes())};
                str = MessageFormat.format(str, objects);
                sbTip.append(str);
            }
            sbTip.append(EASResource.getString((String)RESOURCE, (String)"securityLock")).append(this.getYesOrNo(securityInfo.isNeedLocked()));
            if (securityInfo.isNeedLocked()) {
                str = EASResource.getString((String)RESOURCE, (String)"securityErrorCount");
                objects = new Object[]{new Integer(securityInfo.getLockCount())};
                str = MessageFormat.format(str, objects);
                sbTip.append(str);
            }
            sbTip.append(EASResource.getString((String)RESOURCE, (String)"securityIsNeedUpdatePwLocked")).append(this.getYesOrNo(securityInfo.isNeedUpdatePwLocked()));
            if (securityInfo.isNeedUpdatePwLocked()) {
                str = EASResource.getString((String)RESOURCE, (String)"securityUpdatePwErrorCount");
                objects = new Object[]{new Integer(securityInfo.getLockUpdatePwCount())};
                str = MessageFormat.format(str, objects);
                sbTip.append(str);
            }
            sbTip.append(EASResource.getString((String)RESOURCE, (String)"securityEnd"));
            this.cmbSecurity.setToolTipText(sbTip.toString());
        }
    }

    private String getYesOrNo(boolean value) {
        return value ? EASResource.getString((String)RESOURCE, (String)"yes") : EASResource.getString((String)RESOURCE, (String)"no");
    }

    protected void resetLayout() {
        this.initUIContentLayout();
        this.setComponentLayout();
    }

    @Override
    protected void cmbUserType_itemStateChanged(ItemEvent e) throws Exception {
        if (!this.userEditStateInfo.isInit_over()) {
            return;
        }
        super.cmbUserType_itemStateChanged(e);
        if (e.getStateChange() == 1) {
            this.pmtUserRelation.setData(null);
            this.setUserRelationF7();
        }
        if (UserType.SYSTEM.equals((Object)this.getUserType())) {
            this.iUserEditUI = new UserEdit4AdminUI(this);
            this.resetLayout();
            this.isSystem = true;
        } else if (!UserType.SYSTEM.equals((Object)this.getUserType()) && this.isSystem) {
            this.iUserEditUI = new UserEdit4UserUI(this);
            this.resetLayout();
            this.isSystem = false;
        }
        this.iUserEditUI.initUI(this.getOprtState());
        this.setComponentLaout();
        if (e.getStateChange() == 1) {
            this.setOrgSelectData();
        }
    }

    private void setComponentLaout() {
        if (!OprtState.ADDNEW.equals(this.getOprtState()) && this.isRegister) {
            this.lbcUserSynStatue.setBounds(new Rectangle(10, 360, 310, 19));
            this.tblUserGroupInfo.setBounds(new Rectangle(10, 385, 650, 150));
        }
    }

    @Override
    protected void txtCU_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.userEditStateInfo.isInit_over()) {
            return;
        }
        if (this.isRestoreCU) {
            this.isRestoreCU = false;
            return;
        }
        CtrlUnitInfo ctrlUnitInfo = (CtrlUnitInfo)((KDBizPromptBox)e.getSource()).getData();
        CtrlUnitInfo oldCtrlUnitInfo = (CtrlUnitInfo)e.getOldValue();
        if (ctrlUnitInfo != null && this.userEditStateInfo.isInit_over()) {
            this.iUserEditUI.checkCUValue(ctrlUnitInfo.getId().toString());
        }
        if (ctrlUnitInfo != null && !this.oldCu.equals(ctrlUnitInfo.getId().toString())) {
            this.pmtDefaultOrg.setValue((Object)ctrlUnitInfo.castToFullOrgUnitInfo());
            this.pmtDefaultOrg.setEnabled(false);
        }
        this.oldCu = ctrlUnitInfo != null && this.userEditStateInfo.isInit_over() ? ctrlUnitInfo.getId().toString() : "";
        this.setUserRelationF7();
        if (UserType.PERSON.equals((Object)this.getUserType()) && this.userEditStateInfo.isInit_over() && OprtState.ADDNEW.equals(this.oprtState)) {
            this.pmtUserRelation.setData(null);
        }
        if (ctrlUnitInfo != null) {
            this.loadSecutity(ctrlUnitInfo);
        }
        this.txtCuValuesChanged(e);
    }

    private CtrlUnitInfo getCurrentSelectCtrlUnit() {
        CtrlUnitInfo ctrlInfo = this.getCurrentOrgRangeCU();
        if (ctrlInfo == null) {
            ctrlInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        return ctrlInfo;
    }

    private CtrlUnitInfo getCurrentOrgRangeCU() {
        if (this.txtCU == null || this.txtCU.getData() == null) {
            return null;
        }
        return (CtrlUnitInfo)this.txtCU.getData();
    }

    public UserInfo getCurrentUserByEdit() {
        return this.userInfo;
    }

    public boolean isRefreshParent() {
        return this.dataChange;
    }

    @Override
    protected void pmtUserRelation_dataChanged(DataChangeEvent e) throws Exception {
        LowTimer lowTime = new LowTimer();
        if (UserType.PERSON.equals((Object)this.getUserType()) && e.getNewValue() != null && !e.getNewValue().equals(e.getOldValue())) {
            PersonInfo selectPerson = (PersonInfo)e.getNewValue();
            try {
                selectPerson = ((IUser)this.getBizInterface()).getPersonWithContact(selectPerson);
            }
            catch (Throwable t) {
                logger.error((Object)"", t);
            }
            this.synTouchInfo(selectPerson);
        }
        logger.info((Object)("begin getAdmin org:" + lowTime.msValue()));
    }

    private void synTouchInfo(PersonInfo personInfo) throws Exception {
        if (!StringUtils.isEmpty((String)((String)personInfo.getClass().getMethod("getGlobalRoaming", new Class[0]).invoke((Object)personInfo, new Object[0])))) {
            DataBaseInfo globalRoamingInfo = UserFactory.getRemoteInstance().getGlobalRoaming((String)personInfo.getClass().getMethod("getGlobalRoaming", new Class[0]).invoke((Object)personInfo, new Object[0]));
            this.kBlobalRoaming.setData((Object)globalRoamingInfo);
        }
        this.txtNCell.setText((String)personInfo.getClass().getMethod("getNCell", new Class[0]).invoke((Object)personInfo, new Object[0]));
        if (!StringUtils.isEmpty((String)this.txtNCell.getText())) {
            if ("+86".equals(this.kBlobalRoaming.getText())) {
                this.txtCell.setText(this.txtNCell.getText());
            } else {
                this.txtCell.setText(this.kBlobalRoaming.getText() + "-" + this.txtNCell.getText());
            }
        }
        this.txtBackEmail.setText(personInfo.getBackupEMail());
        this.txtEmail.setText(personInfo.getEmail());
        this.txtOfficePhone.setText(personInfo.getOfficePhone());
        this.txtHomePhone.setText(personInfo.getHomePhone());
    }

    private boolean checkLicenseIsUserType() {
        boolean rs = false;
        try {
            rs = CloudRegistSrvAgentFactory.getRemoteInstance().isInternalUseType();
        }
        catch (LicenseException e) {
            logger.error((Object)e);
        }
        return rs;
    }

    protected Set<String> getGroupID() {
        Object groupObj = this.pmtGroup.getData();
        HashSet<String> ret = new HashSet<String>();
        if (groupObj != null) {
            if (groupObj instanceof Object[]) {
                Object[] groupObjs = (Object[])groupObj;
                if (0 != groupObjs.length) {
                    for (Object group : groupObjs) {
                        if (!(group instanceof UserGroupInfo)) continue;
                        ret.add(((UserGroupInfo)group).getId().toString());
                    }
                }
            } else {
                ret.add(((UserGroupInfo)groupObj).getId().toString());
            }
        }
        return ret;
    }

    public Set<UserGroupInfo> getGroups(IObjectPK userid) throws Exception {
        HashSet<UserGroupInfo> userGroupsSet = new HashSet<UserGroupInfo>();
        if (OprtState.ADDNEW.equals(this.oprtState)) {
            userGroupsSet.add(this.getUserGroupInfo());
            return userGroupsSet;
        }
        IUserGroupGFacade iUserGroupGFacade = UserGroupGFacadeFactory.getRemoteInstance();
        Set userGroups = iUserGroupGFacade.selectGroups(userid);
        for (String groupId : userGroups) {
            UserGroupInfo userGrupInfo = UserGroupFactory.getRemoteInstance().getUserGroupInfo((IObjectPK)new ObjectUuidPK(groupId));
            userGroupsSet.add(userGrupInfo);
        }
        return userGroupsSet;
    }

    private boolean isKeyInfoChanged() {
        String cell = "";
        String areaCode = this.getAreaCodeBySelect(this.kBlobalRoaming.getData());
        if (!StringUtils.isEmpty((String)areaCode) && !StringUtils.isEmpty((String)this.txtNCell.getText())) {
            cell = "+86".equals(areaCode) ? this.txtNCell.getText() : areaCode + "-" + this.txtNCell.getText();
        }
        return !cell.equals(this.oldData.getCell() == null ? "" : this.oldData.getCell()) || !this.txtEmail.getText().equals(this.oldData.getEmail() == null ? "" : this.oldData.getEmail()) || !this.txtNumber.getText().equals(this.oldData.getNumber());
    }

    private String getAreaCodeBySelect(Object obj) {
        obj = this.kBlobalRoaming.getData();
        String areaCode = "";
        if (obj != null && obj instanceof DataBaseInfo) {
            DataBaseInfo info = (DataBaseInfo)obj;
            areaCode = info.get("areaCode").toString();
        }
        return areaCode;
    }
}

