/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.FieldAccessInfo;
import com.kingdee.eas.base.permission.FieldPermission;
import com.kingdee.eas.base.permission.GrantUserFieldFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractUserFieldAccessAccreditUI;
import com.kingdee.eas.base.permission.client.util.FieldAccessUtil;
import com.kingdee.eas.base.permission.client.util.UIUtil;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.AccreditPermF7PromptDialog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SubSystemUtils;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.util.client.EASResource;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class UserFieldAccessViewUI
extends AbstractUserFieldAccessAccreditUI {
    private static final int FIELD_NAME_INDEX = 0;
    private static final int VIEWABLE_INDEX = 1;
    private static final int EDITABLE_INDEX = 2;
    private static final String GRANTABLE = "grantable";
    public static final String TARGET_USER_INFO = "targetUserInfo";
    public static final String TARGET_ORG_PK = "orgPK";
    public static final String TARGET_USER_PK = "userPK";
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private Map loadedData = null;
    private BOSObjectType currentBOSObjectType = null;

    @Override
    public boolean isPrepareInit() {
        return false;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.put("CurrentUserPK", (Object)ToolUtils.getCurrentUserPK());
            request.put("TargetUserPK", (Object)this.getTargetUserPK());
            request.put("TargetOrgPK", (Object)this.getTargetOrgPK());
            this.setCurrentEntityType();
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
    }

    private void initUI() throws EASBizException, BOSException {
        this.pmtOrg.setEnabled(false);
        this.selectDefOrg();
        this.initTable();
        this.initButton();
        this.setUITitle(EASResource.getString((String)RESOURCE, (String)"UserFieldPermView"));
    }

    private void initButton() {
        this.btnClearAll.setVisible(false);
        this.btnSelectAll.setVisible(false);
        this.btnSubmit.setVisible(false);
    }

    private void initTable() {
        this.tblMain.checkParsed(true);
        if (this.isTargetBizAdmin()) {
            this.tblMain.getColumn(GRANTABLE).getStyleAttributes().setHided(false);
        }
    }

    private boolean isTargetBizAdmin() {
        if (this.getTargetUserInfo() != null) {
            return this.getTargetUserInfo().isBizAdmin();
        }
        return false;
    }

    private UserInfo getTargetUserInfo() {
        if (this.getUIContext().get(TARGET_USER_INFO) != null) {
            return (UserInfo)this.getUIContext().get(TARGET_USER_INFO);
        }
        return null;
    }

    private IObjectPK getSelectedOrgPK() {
        if (this.pmtOrg.getData() == null) {
            return null;
        }
        FullOrgUnitInfo fullOrgUnitInfo = (FullOrgUnitInfo)this.pmtOrg.getData();
        return new ObjectUuidPK(fullOrgUnitInfo.getId());
    }

    private void initOrgF7() throws EASBizException, BOSException {
        UserInfo targetUser = UserFactory.getRemoteInstance().getUserByID(this.getTargetUserPK());
        AccreditPermF7PromptDialog orgF7 = new AccreditPermF7PromptDialog((IUIObject)this, targetUser, false);
        this.pmtOrg.setSelector((KDPromptSelector)orgF7);
        this.pmtOrg.setEditable(false);
        this.pmtOrg.setEnabled(false);
    }

    private void selectDefOrg() throws EASBizException, BOSException {
        IObjectPK orgPK = this.getTargetOrgPK();
        if (orgPK != null) {
            FullOrgUnitInfo defOrgUnit = this.getOrg(orgPK);
            this.pmtOrg.setData((Object)defOrgUnit);
        }
    }

    private FullOrgUnitInfo getOrg(IObjectPK orgPK) throws EASBizException, BOSException {
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
        return iFullOrgUnit.getFullOrgUnitInfo(orgPK);
    }

    private void buildTree() throws EASBizException, BOSException {
        DefaultKingdeeTreeNode root = this.createNode();
        FieldAccessUtil.filterUserFieldAccessTreeNode(this.getTargetUserPK(), this.getTargetOrgPK(), root);
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)root);
        this.tree.setModel((TreeModel)model);
        UIUtil.addStandardPopupMenu(this.tree);
    }

    private DefaultKingdeeTreeNode createNode() {
        return SubSystemUtils.getKDTreeNode((IBriefViewTreeNode)SubSystemUtils.getRemoveEmptyPackageNode((IBriefViewTreeNode)SubSystemUtils.getSubSystemByName((String)"com_kingdee_eas_base_fieldpermission")));
    }

    private IObjectPK getTargetOrgPK() {
        if (this.getUIContext().get(TARGET_ORG_PK) != null) {
            return (IObjectPK)this.getUIContext().get(TARGET_ORG_PK);
        }
        return null;
    }

    private IObjectPK getAccreditOrgPK() {
        IObjectPK orgPK = this.getSelectedOrgPK();
        if (orgPK != null) {
            IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            EntityObjectInfo entity = loader.getEntity(this.currentBOSObjectType);
            if (OrgType.NONE.equals((Object)PermissionCommonUtil.getMainBizOrgType(entity))) {
                return new ObjectUuidPK("11111111-1111-1111-1111-111111111111CCE7AED4");
            }
            return orgPK;
        }
        return null;
    }

    private IObjectPK getTargetUserPK() {
        if (this.getUIContext().get(TARGET_USER_PK) != null) {
            return (IObjectPK)this.getUIContext().get(TARGET_USER_PK);
        }
        return null;
    }

    @Override
    protected void pmtOrg_dataChanged(DataChangeEvent e) throws Exception {
        super.pmtOrg_dataChanged(e);
        IObjectPK orgPK = this.getSelectedOrgPK();
        if (orgPK != null) {
            this.buildTree();
        } else {
            this.clearTree();
        }
    }

    private void clearTree() {
        ((DefaultTreeModel)this.tree.getModel()).setRoot(null);
    }

    @Override
    protected void tree_valueChanged(TreeSelectionEvent e) throws Exception {
        super.tree_valueChanged(e);
        this.refreshList();
    }

    private void setCurrentEntityType() {
        MetaDataBriefInfo mdbInfo;
        DefaultKingdeeTreeNode node;
        Object userObject;
        Object object = this.tree.getLastSelectedPathComponent();
        if (object != null && object instanceof DefaultKingdeeTreeNode && (userObject = (node = (DefaultKingdeeTreeNode)object).getUserObject()) instanceof MetaDataBriefInfo && (mdbInfo = (MetaDataBriefInfo)userObject).getMetaDataType().equals((Object)MetaDataTypeList.ENTITY)) {
            this.currentBOSObjectType = mdbInfo.getBOType();
            return;
        }
        this.currentBOSObjectType = null;
    }

    private void refreshList() throws BOSException, EASBizException {
        this.setCurrentEntityType();
        if (this.currentBOSObjectType != null) {
            this.loadCurrentFieldAccess(this.currentBOSObjectType);
            this.loadRowData(this.currentBOSObjectType);
        } else {
            this.loadedData = null;
            this.tblMain.removeRows();
        }
    }

    private Map loadCurrentFieldAccess(BOSObjectType objectType) throws BOSException, EASBizException {
        this.loadedData = new HashMap();
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        FieldPermission collection = iPermission.getFieldPermission(objectType, this.getTargetUserPK(), this.getAccreditOrgPK());
        if (collection != null) {
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                FieldAccessInfo info = collection.get(i);
                this.loadedData.put(info.getFieldName(), info);
            }
        }
        return this.loadedData;
    }

    private void loadRowData(BOSObjectType objectType) throws BOSException, EASBizException {
        this.tblMain.setRefresh(false);
        this.tblMain.removeRows();
        Set result = FieldAccessUtil.getFieldAccessStrategy(objectType, this.getCUPK(this.getAccreditOrgPK()));
        Set fieldInfos = FieldAccessUtil.getEntityFieldInfos(objectType);
        Set grantedUserFields = GrantUserFieldFactory.getRemoteInstance().getUserAndRoleGrantedFields(this.getTargetUserPK(), this.getTargetOrgPK(), objectType);
        for (String[] fieldInfo : fieldInfos) {
            if (!result.contains(fieldInfo[1])) continue;
            IRow row = this.tblMain.addRow();
            row.getCell(0).setValue((Object)fieldInfo[0]);
            row.getCell(0).setUserObject((Object)fieldInfo[1]);
            if (this.loadedData.containsKey(fieldInfo[1])) {
                FieldAccessInfo info = (FieldAccessInfo)this.loadedData.get(fieldInfo[1]);
                row.getCell(1).setValue((Object)info.isViewable());
                row.getCell(2).setValue((Object)info.isEditable());
            } else {
                row.getCell(1).setValue((Object)Boolean.TRUE);
                row.getCell(2).setValue((Object)Boolean.TRUE);
            }
            if (grantedUserFields.contains(fieldInfo[1])) {
                row.getCell(GRANTABLE).setValue((Object)Boolean.TRUE);
                continue;
            }
            row.getCell(GRANTABLE).setValue((Object)Boolean.FALSE);
        }
        this.tblMain.setRefresh(true);
        this.tblMain.reLayoutAndPaint();
    }

    private IObjectPK getCUPK(IObjectPK orgPK) throws EASBizException, BOSException {
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
        FullOrgUnitInfo fullOrgUnitInfo = iFullOrgUnit.getFullOrgUnitInfo(orgPK);
        return new ObjectUuidPK(fullOrgUnitInfo.getCU().getId());
    }

    @Override
    protected void tblMain_editValueChanged(KDTEditEvent e) throws Exception {
        super.tblMain_editValueChanged(e);
        boolean flag = e.getValue() == null ? false : (Boolean)e.getValue();
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (colIndex == 1) {
            if (!flag) {
                this.tblMain.getRow(rowIndex).getCell(2).setValue((Object)Boolean.FALSE);
            }
        } else if (colIndex == 2 && flag) {
            this.tblMain.getRow(rowIndex).getCell(1).setValue((Object)Boolean.TRUE);
        }
    }
}

