/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.UserGroupFactory;
import com.kingdee.eas.base.permission.UserGroupInfo;
import com.kingdee.eas.base.permission.client.AbstractUserGroupEditUI;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UserGroupEditUI
extends AbstractUserGroupEditUI {
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    private void initUI() {
        this.btnRemove.setVisible(false);
        this.btnAddNew.setVisible(false);
        this.btnEdit.setVisible(false);
    }

    public IObjectValue createNewData() {
        UserGroupInfo groupInfo = new UserGroupInfo();
        groupInfo.setParent((UserGroupInfo)this.getUIContext().get("ParentNode"));
        return groupInfo;
    }

    public ICoreBase getBizInterface() throws Exception {
        return UserGroupFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("parent.*"));
        return sic;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        try {
            if (!this.checkNumber()) {
                MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"invalid_number"));
                return;
            }
            CtrlUnitInfo ctrlUnitInfo = new CtrlUnitInfo();
            ctrlUnitInfo.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"));
            this.editData.setCU(ctrlUnitInfo);
            super.actionSubmit_actionPerformed(e);
        }
        catch (EASBizException e1) {
            this.handUIException(e1);
        }
    }

    private boolean checkNumber() {
        String number = this.txtNumber.getText();
        if (StringUtils.isEmpty((String)number)) {
            return true;
        }
        String patternStr = "[\\W_]+";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(number);
        return !matcher.find();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    private void setUIView() {
        this.initUI();
        String title = PermissionCommonUtil.getUITitle(this.getUITitle(), this.getOprtState());
        this.setUITitle(title);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setUIView();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        UserGroupInfo userGroupInfo = (UserGroupInfo)this.getUIContext().get("ParentNode");
        if (!userGroupInfo.isIsLeaf()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_OnlyLeaf_CanDelete"));
            return;
        }
        super.actionRemove_actionPerformed(e);
    }
}

