/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.IUserOrgRolePermFacade;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserOrgRolePermFacadeFactory;
import com.kingdee.eas.base.permission.UserOrgRolePermParam;
import com.kingdee.eas.base.permission.UserOrgRolePermResult;
import com.kingdee.eas.base.permission.client.AbstractUserOrgRolePermUI;
import com.kingdee.eas.base.permission.client.SimpleExportExcelConfigUI;
import com.kingdee.eas.base.permission.client.UserPromptBox;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.exportexcel.ExportExcelConfigManager;
import com.kingdee.eas.framework.client.exportexcel.ExportExcelConfigParam;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class UserOrgRolePermUI
extends AbstractUserOrgRolePermUI {
    private static final Logger logger = CoreUIObject.getLogger(UserOrgRolePermUI.class);
    private static final String USER_NAME = "userName";
    private static final String ORG_NAME = "orgName";
    private static final String PERMITEM_LONGNUMBER = "permitemLongnumber";
    private static final String PERMITEM_NAME = "permItemName";
    private static final String PERM_TYPE = "permType";
    private static final String GROUP1 = "group1";
    private static final String GROUP2 = "group2";
    private static final String GROUP3 = "group3";
    private static final String GROUP4 = "group4";
    private static final int GROUP_NUM = 4;
    static Set<String> digitalSet = new HashSet<String>();

    public UserOrgRolePermUI() throws Exception {
        this.initUI();
    }

    private void initUI() {
        this.tblMain.checkParsed();
        this.initUserF7();
    }

    private void initUserF7() {
        UserPromptBox userSelector = new UserPromptBox();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isDelete", (Object)0, CompareType.EQUALS));
        List<Integer> sysUserTypeList = this.getSysUserTypes();
        filter.getFilterItems().add(new FilterItemInfo("type", sysUserTypeList, CompareType.NOTINNER));
        view.setFilter(filter);
        this.pmtUser.setEntityViewInfo(view);
        this.pmtUser.setSelector((KDPromptSelector)userSelector);
        this.pmtUser.setEnabledMultiSelection(true);
        this.pmtUser.setEditFormat("$name$");
        this.pmtUser.setDisplayFormat("$name$");
        this.pmtUser.setCommitFormat("$name$");
    }

    private List<Integer> getSysUserTypes() {
        ArrayList<Integer> sysUserTypeList = new ArrayList<Integer>();
        sysUserTypeList.add(10);
        sysUserTypeList.add(70);
        sysUserTypeList.add(60);
        return sysUserTypeList;
    }

    @Override
    public void actionPermQuery_actionPerformed(ActionEvent e) throws Exception {
        IUserOrgRolePermFacade uorpFacade = UserOrgRolePermFacadeFactory.getRemoteInstance();
        Set<String> userIdSet = this.getUserIdSet();
        UserOrgRolePermParam param = new UserOrgRolePermParam();
        param.setUserIdSet(userIdSet);
        UserOrgRolePermResult result = uorpFacade.getUserOrgRolePerm(param);
        this.renderTable(result);
    }

    private void renderTable(UserOrgRolePermResult result) {
        this.tblMain.removeRows();
        Map<String, Map<String, Map<Integer, Set<String>>>> userOrgPermMap = result.getUserOrgPermMap();
        Iterator<Map.Entry<String, Map<String, Map<Integer, Set<String>>>>> uopItr = userOrgPermMap.entrySet().iterator();
        Map<String, UserInfo> idUserMap = result.getIdUserMap();
        Map<String, FullOrgUnitInfo> idOrgMap = result.getIdOrgMap();
        Map<String, PermItemInfo> idPermMap = result.getIdPermItemMap();
        while (uopItr.hasNext()) {
            Map.Entry<String, Map<String, Map<Integer, Set<String>>>> uopEntry = uopItr.next();
            String userId = uopEntry.getKey();
            Map<String, Map<Integer, Set<String>>> orgPermMap = uopEntry.getValue();
            for (Map.Entry<String, Map<Integer, Set<String>>> orgPermEntry : orgPermMap.entrySet()) {
                String orgId = orgPermEntry.getKey();
                Map<Integer, Set<String>> typePermMap = orgPermEntry.getValue();
                for (Map.Entry<Integer, Set<String>> typePermEntry : typePermMap.entrySet()) {
                    int permType = typePermEntry.getKey();
                    Set<String> permItemIdSet = typePermEntry.getValue();
                    for (String permItemId : permItemIdSet) {
                        this.addRow(idUserMap, idOrgMap, idPermMap, userId, orgId, permType, permItemId);
                    }
                }
            }
        }
    }

    private void addRow(Map<String, UserInfo> idUserMap, Map<String, FullOrgUnitInfo> idOrgMap, Map<String, PermItemInfo> idPermMap, String userId, String orgId, int permType, String permItemId) {
        PermItemInfo perm = idPermMap.get(permItemId);
        FullOrgUnitInfo org = idOrgMap.get(orgId);
        if (perm == null || org == null) {
            return;
        }
        IRow row = this.tblMain.addRow();
        row.getCell(USER_NAME).setValue((Object)idUserMap.get(userId).getName());
        row.getCell(ORG_NAME).setValue((Object)org.getName());
        row.getCell(PERMITEM_LONGNUMBER).setValue((Object)perm.getLongNumber());
        row.getCell(PERMITEM_NAME).setValue((Object)perm.getAlias());
        row.getCell(PERM_TYPE).setValue((Object)PermType.getEnum(permType));
        String longNumber = perm.getLongNumber();
        String[] groups = this.getGroups(longNumber);
        row.getCell(GROUP1).setValue((Object)groups[0]);
        row.getCell(GROUP2).setValue((Object)groups[1]);
        row.getCell(GROUP3).setValue((Object)groups[2]);
        row.getCell(GROUP4).setValue((Object)groups[3]);
    }

    private String[] getGroups(String longNumber) {
        String[] groupNames = longNumber.split("!");
        String[] ret = new String[4];
        int len = Math.min(groupNames.length - 2, 4);
        for (int i = 0; i < len; ++i) {
            ret[i] = this.getTrimedGroup(groupNames[i + 1]);
        }
        return ret;
    }

    private boolean isDigital(char c) {
        return digitalSet.contains(c + "");
    }

    private String getTrimedGroup(String originGroup) {
        char[] groupChars = originGroup.toCharArray();
        int index = -1;
        int len = groupChars.length;
        for (int i = 0; i < len; ++i) {
            index = i;
            if (!this.isDigital(groupChars[i])) break;
        }
        return String.valueOf(groupChars, index, len - index);
    }

    private Set<String> getUserIdSet() {
        Object userObj = this.pmtUser.getData();
        HashSet<String> ret = new HashSet<String>();
        if (userObj instanceof Object[]) {
            Object[] userObjs;
            for (Object user : userObjs = (Object[])userObj) {
                if (!(user instanceof UserInfo)) continue;
                ret.add(((UserInfo)user).getId().toString());
            }
        }
        return ret;
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"table", (Object)this.tblMain);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(SimpleExportExcelConfigUI.class.getName(), (Map)uiContext, null, null);
        SimpleExportExcelConfigUI exportExcelConfigUI = (SimpleExportExcelConfigUI)window.getUIObject();
        ExportExcelConfigParam param = ExportExcelConfigManager.loadExportExcelConfig();
        param.setExcelVersion(0);
        int selectedRowCount = KDTableUtil.getSelectedRows((KDTable)this.tblMain).length;
        int rowCount = this.tblMain.getRowCount();
        exportExcelConfigUI.setRowCount(rowCount);
        exportExcelConfigUI.setSelectedRowCount(selectedRowCount);
        exportExcelConfigUI.setTable(this.tblMain);
        exportExcelConfigUI.initConfigParam(param);
        window.show();
    }

    static {
        for (int i = 0; i < 10; ++i) {
            digitalSet.add(i + "");
        }
    }
}

