/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserInfoRpcHelper;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.base.permission.client.AbstractUserWithDeletedPersonListUI;
import com.kingdee.eas.base.permission.client.UserListUIHelper;
import com.kingdee.eas.base.permission.client.helper.UIFunctionView;
import com.kingdee.eas.base.permission.client.helper.UserHelper;
import com.kingdee.eas.base.permission.util.CacheUtil;
import com.kingdee.eas.base.permission.util.LogProxy;
import com.kingdee.eas.base.permission.util.MyEntityInfo;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.base.usermonitor.IUserMonitor;
import com.kingdee.eas.base.usermonitor.UserMonitorFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class UserWithDeletedPersonListUI
extends AbstractUserWithDeletedPersonListUI {
    private static final Logger logger = CoreUIObject.getLogger(UserWithDeletedPersonListUI.class);
    private static final String USER_ID_CELLNAME = "id";
    private static final String CU_ID_CELLNAME = "CtrlUnit.id";
    private static final String USER_NUMBER_CELLNAME = "number";
    private static final String USER_TYPE_CELLNAME = "";
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int isYes = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"delUserWarning"));
        if (MsgBox.isYes((int)isYes)) {
            try {
                this.processUserDelete();
            }
            catch (EASBizException e1) {
                this.handleException((Exception)((Object)e1));
            }
            catch (BOSException e1) {
                this.handleException((Exception)((Object)e1));
            }
            this.refresh(e);
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        UserListUIHelper helper = new UserListUIHelper();
        try {
            return helper.getCurrentRangeUser();
        }
        catch (EASBizException e) {
            logger.error((Object)USER_TYPE_CELLNAME, (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)USER_TYPE_CELLNAME, (Throwable)e);
        }
        catch (UuidException e) {
            logger.error((Object)USER_TYPE_CELLNAME, (Throwable)e);
        }
        catch (ParserException e) {
            logger.error((Object)USER_TYPE_CELLNAME, (Throwable)e);
        }
        return super.getDefaultFilterForQuery();
    }

    private void processUserDelete() throws Exception {
        UserCollection userCol = new UserCollection();
        ArrayList<ObjectStringPK> arrayList = new ArrayList<ObjectStringPK>();
        int size = this.tblMain.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            IBlock selectBlock = KDTSelectBlock.change((KDTable)this.tblMain, (IBlock)this.tblMain.getSelectManager().get(i));
            int size1 = selectBlock.getBottom();
            for (int j = selectBlock.getTop(); j <= size1; ++j) {
                UserInfo tempUserInfo = this.getUserInfoFromTable(this.tblMain.getRow(j));
                this.checkUserCanBeMaintain(tempUserInfo);
                userCol.add(tempUserInfo);
                arrayList.add(new ObjectStringPK(tempUserInfo.getId().toString()));
            }
        }
        IObjectPK[] userPKs = new IObjectPK[arrayList.size()];
        int length = userPKs.length;
        for (int i = 0; i < length; ++i) {
            userPKs[i] = (IObjectPK)arrayList.get(i);
        }
        IUser iUser = (IUser)this.getBizInterface();
        LogProxy logProxy = new LogProxy();
        Locale locale = SysContext.getSysContext().getLocale();
        logProxy.beginLog(null, MyEntityInfo.getMethodAlias(null, iUser.getType(), "delete"), iUser.getType(), null, UserInfoRpcHelper.getforbidDetail(userCol, "delete", true, locale));
        UserHelper userHelper = new UserHelper();
        if (userHelper.hasUserWorkflow(arrayList)) {
            if (MsgBox.isOk((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"haveWFTask")))) {
                iUser.delete(userPKs);
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"deleteSucceed"));
            }
        } else {
            iUser.delete(userPKs);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"deleteSucceed"));
        }
        logProxy.end();
    }

    private UserInfo getUserInfoFromTable(IRow iRow) {
        Object object = iRow.getCell(USER_ID_CELLNAME).getValue();
        UserInfo info = new UserInfo();
        info.setId(BOSUuid.read((String)object.toString()));
        CtrlUnitInfo ctrlUnitInfo = new CtrlUnitInfo();
        ctrlUnitInfo.setId(BOSUuid.read((String)iRow.getCell(CU_ID_CELLNAME).getValue().toString()));
        info.setCU(ctrlUnitInfo);
        info.setNumber(iRow.getCell(USER_NUMBER_CELLNAME).getValue().toString());
        info.setType(UserType.PERSON);
        return info;
    }

    private void checkUserCanBeMaintain(UserInfo userInfo) throws EASBizException, BOSException, UuidException {
        IUserMonitor iUserMonitor;
        List onLineInfoList;
        if (!this.mayManagerUser(userInfo, "FUNCTION_DELETE_USER")) {
            Object[] objects = new Object[]{userInfo.getNumber()};
            String str = MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"userCanBeMaintain"), objects);
            MsgBox.showWarning((Component)((Object)this), (String)str);
            this.abort();
        }
        if ((onLineInfoList = (iUserMonitor = UserMonitorFactory.getRemoteInstance()).findUsers(SysContext.getSysContext().getDcName(), userInfo.getNumber())) != null && !onLineInfoList.isEmpty()) {
            Object[] objects = new Object[]{userInfo.getNumber()};
            String str = MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"userOnlineWhenDelete"), objects);
            MsgBox.showWarning((Component)((Object)this), (String)str);
            this.abort();
        }
    }

    private boolean mayManagerUser(UserInfo eidtUserInfo, String functionType) throws EASBizException, BOSException, UuidException {
        return UIFunctionView.getInstance().hasPermission(CacheUtil.getCacheUserInfo(null, ToolUtils.getCurrentUserPK().toString()), eidtUserInfo, "UserListUI", functionType);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0) {
            super.tblMain_tableClicked(e);
        }
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return UserFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }
}

